/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleUtil;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;

public class PolygonizerPlugIn
extends ThreadedBasePlugIn {
    private boolean useSelected = false;
    private MultiInputDialog dialog;
    private String layerName;
    private boolean splitLineStrings = false;
    private boolean nodeInputLines = false;
    private int inputEdgeCount = 0;
    private int dangleCount = 0;
    private int cutCount = 0;
    private int invalidRingCount = 0;
    private GeometryFactory fact = new GeometryFactory();
    private static final String SRC_LAYER = I18N.get("jump.plugin.edit.PolygonizerPlugIn.Line-Layer");
    private static final String NODE_INPUT = I18N.get("jump.plugin.edit.PolygonizerPlugIn.Node-input-before-polygonizing");
    private static final String SELECTED_ONLY = GenericNames.USE_SELECTED_FEATURES_ONLY;

    public String getName() {
        return I18N.get("jump.plugin.edit.PolygonizerPlugIn.Polygonize");
    }

    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY, MenuNames.CONVERT}, this.getName() + "...", false, null, this.createEnableCheck(context.getWorkbenchContext()));
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), I18N.get("jump.plugin.edit.PolygonizerPlugIn.Polygonize"), true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Collection lines;
        monitor.allowCancellationRequests();
        Polygonizer polygonizer = new Polygonizer();
        monitor.report(I18N.get("jump.plugin.edit.PolygonizerPlugIn.Polygonizing"));
        Layer layer = this.dialog.getLayer(SRC_LAYER);
        Collection inputFeatures = this.getFeaturesToProcess(layer, context);
        this.inputEdgeCount = inputFeatures.size();
        Collection nodedLines = lines = this.getLines(inputFeatures);
        if (this.nodeInputLines) {
            monitor.report(I18N.get("jump.plugin.edit.PolygonizerPlugIn.Noding-input-lines"));
            nodedLines = this.nodeLines((List)lines);
        }
        for (Geometry g : nodedLines) {
            polygonizer.add(g);
        }
        if (monitor.isCancelRequested()) {
            return;
        }
        this.createLayers(context, polygonizer);
    }

    private Collection getFeaturesToProcess(Layer lyr, PlugInContext context) {
        if (this.useSelected) {
            return context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(lyr);
        }
        return lyr.getFeatureCollectionWrapper().getFeatures();
    }

    private Collection getLines(Collection inputFeatures) {
        ArrayList linesList = new ArrayList();
        LinearComponentExtracter lineFilter = new LinearComponentExtracter(linesList);
        for (Feature f : inputFeatures) {
            Geometry g = f.getGeometry();
            g.apply((GeometryComponentFilter)lineFilter);
        }
        return linesList;
    }

    private Collection nodeLines(Collection lines) {
        MultiLineString linesGeom = this.fact.createMultiLineString(GeometryFactory.toLineStringArray((Collection)lines));
        MultiLineString unionInput = this.fact.createMultiLineString(null);
        Geometry point = this.extractPoint(lines);
        if (point != null) {
            unionInput = point;
        }
        Geometry noded = linesGeom.union((Geometry)unionInput);
        ArrayList<Geometry> nodedList = new ArrayList<Geometry>();
        nodedList.add(noded);
        return nodedList;
    }

    private Geometry extractPoint(Collection lines) {
        int minPts = Integer.MAX_VALUE;
        Point point = null;
        for (Geometry g : lines) {
            if (g.isEmpty()) continue;
            Coordinate p = g.getCoordinate();
            point = g.getFactory().createPoint(p);
        }
        return point;
    }

    private void createLayers(PlugInContext context, Polygonizer polygonizer) throws Exception {
        FeatureCollection dangleFC = FeatureDatasetFactory.createFromGeometry(polygonizer.getDangles());
        this.dangleCount = dangleFC.size();
        if (dangleFC.size() > 0) {
            Layer lyr4 = context.addLayer(StandardCategoryNames.QA, I18N.get("jump.plugin.edit.PolygonizerPlugIn.Dangles"), dangleFC);
            LayerStyleUtil.setLinearStyle(lyr4, Color.red, 2, 0);
            lyr4.setDescription(I18N.get("jump.plugin.edit.PolygonizerPlugIn.Dangling-edges"));
        }
        FeatureCollection cutFC = FeatureDatasetFactory.createFromGeometry(polygonizer.getCutEdges());
        this.cutCount = cutFC.size();
        if (cutFC.size() > 0) {
            Layer lyr = context.addLayer(StandardCategoryNames.QA, I18N.get("jump.plugin.edit.PolygonizerPlugIn.Cuts"), cutFC);
            LayerStyleUtil.setLinearStyle(lyr, Color.blue, 2, 0);
            lyr.setDescription(I18N.get("jump.plugin.edit.PolygonizerPlugIn.Cut-edges"));
        }
        FeatureCollection invalidRingFC = FeatureDatasetFactory.createFromGeometry(polygonizer.getInvalidRingLines());
        this.invalidRingCount = invalidRingFC.size();
        if (invalidRingFC.size() > 0) {
            Layer lyr = context.addLayer(StandardCategoryNames.QA, I18N.get("jump.plugin.edit.PolygonizerPlugIn.Invalid-Rings"), invalidRingFC);
            LayerStyleUtil.setLinearStyle(lyr, Color.blue, 2, 0);
            lyr.setDescription(I18N.get("jump.plugin.edit.PolygonizerPlugIn.Invalid-Rings"));
        }
        FeatureCollection polyFC = FeatureDatasetFactory.createFromGeometry(polygonizer.getPolygons());
        context.addLayer(StandardCategoryNames.RESULT, this.layerName + " " + I18N.get("jump.plugin.edit.PolygonizerPlugIn.Polygons"), polyFC);
        this.createOutput(context, polyFC);
    }

    private void createOutput(PlugInContext context, FeatureCollection polyFC) {
        context.getOutputFrame().createNewDocument();
        context.getOutputFrame().addHeader(1, I18N.get("jump.plugin.edit.PolygonizerPlugIn.Polygonization"));
        context.getOutputFrame().addField("Layer: ", this.layerName);
        context.getOutputFrame().addText(" ");
        context.getOutputFrame().addField(I18N.get("jump.plugin.edit.PolygonizerPlugIn.Number-of-input-edges"), "" + this.inputEdgeCount);
        context.getOutputFrame().addField(I18N.get("jump.plugin.edit.PolygonizerPlugIn.Number-of-polygons-created"), "" + polyFC.size());
        context.getOutputFrame().addField(I18N.get("jump.plugin.edit.PolygonizerPlugIn.Number-of-dangling-edges-found"), "" + this.dangleCount);
        context.getOutputFrame().addField(I18N.get("jump.plugin.edit.PolygonizerPlugIn.Number-of-cut-edges-found"), "" + this.cutCount);
        context.getOutputFrame().addField(I18N.get("jump.plugin.edit.PolygonizerPlugIn.Number-of-invalid-rings-found"), "" + this.invalidRingCount);
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarImage(new ImageIcon(this.getClass().getResource("Polygonize.png")));
        dialog.setSideBarDescription(I18N.get("jump.plugin.edit.PolygonizerPlugIn.Polygonizes-the-line-segments-in-a-layer") + " " + I18N.get("jump.plugin.edit.PolygonizerPlugIn.Polygonization-requires-correctly-noded-data") + " " + I18N.get("jump.plugin.edit.PolygonizerPlugIn.If-desired-the-input-data-may-be-noded-before-polygonizing-is-performed") + " " + I18N.get("jump.plugin.edit.PolygonizerPlugIn.Dangles-Cutlines-and-Invalid-Rings-are-identified"));
        String fieldName = SRC_LAYER;
        JComboBox addLayerComboBox = dialog.addLayerComboBox(fieldName, context.getCandidateLayer(0), null, context.getLayerManager());
        dialog.addCheckBox(SELECTED_ONLY, this.useSelected);
        dialog.addCheckBox(NODE_INPUT, this.nodeInputLines, NODE_INPUT);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        Layer layer = dialog.getLayer(SRC_LAYER);
        this.layerName = layer.getName();
        this.useSelected = dialog.getBoolean(SELECTED_ONLY);
        this.nodeInputLines = dialog.getBoolean(NODE_INPUT);
    }
}

