/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.feature.AttributeType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class FeatureSchema
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8627306219650589202L;
    private CoordinateSystem coordinateSystem = CoordinateSystem.UNSPECIFIED;
    private HashMap attributeNameToIndexMap = new HashMap();
    private int geometryIndex = -1;
    private int attributeCount = 0;
    private ArrayList attributeNames = new ArrayList();
    private ArrayList attributeTypes = new ArrayList();
    private ArrayList<Boolean> attributeReadOnly = new ArrayList();

    public Object clone() {
        try {
            FeatureSchema fs = new FeatureSchema();
            for (int i = 0; i < this.attributeCount; ++i) {
                AttributeType at = (AttributeType)this.attributeTypes.get(i);
                String aname = (String)this.attributeNames.get(i);
                fs.addAttribute(aname, at);
                fs.setAttributeReadOnly(i, this.isAttributeReadOnly(i));
            }
            fs.setCoordinateSystem(this.coordinateSystem);
            return fs;
        }
        catch (Exception ex) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public int getAttributeIndex(String attributeName) {
        Integer index = (Integer)this.attributeNameToIndexMap.get(attributeName);
        if (index == null) {
            throw new IllegalArgumentException(I18N.get("feature.FeatureSchema.unrecognized-attribute-name") + " " + attributeName);
        }
        return index;
    }

    public boolean hasAttribute(String attributeName) {
        return this.attributeNameToIndexMap.get(attributeName) != null;
    }

    public int getGeometryIndex() {
        return this.geometryIndex;
    }

    public String getAttributeName(int attributeIndex) {
        return (String)this.attributeNames.get(attributeIndex);
    }

    public AttributeType getAttributeType(int attributeIndex) {
        return (AttributeType)this.attributeTypes.get(attributeIndex);
    }

    public AttributeType getAttributeType(String attributeName) {
        return this.getAttributeType(this.getAttributeIndex(attributeName));
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public void addAttribute(String attributeName, AttributeType attributeType) {
        if (AttributeType.GEOMETRY == attributeType) {
            Assert.isTrue((this.geometryIndex == -1 ? 1 : 0) != 0);
            this.geometryIndex = this.attributeCount;
        }
        this.attributeNames.add(attributeName);
        this.attributeNameToIndexMap.put(attributeName, new Integer(this.attributeCount));
        this.attributeTypes.add(attributeType);
        this.attributeReadOnly.add(false);
        ++this.attributeCount;
    }

    public boolean equals(Object other) {
        return this.equals(other, false);
    }

    public boolean equals(Object other, boolean orderMatters) {
        if (!(other instanceof FeatureSchema)) {
            return false;
        }
        FeatureSchema otherFeatureSchema = (FeatureSchema)other;
        if (this.attributeNames.size() != otherFeatureSchema.attributeNames.size()) {
            return false;
        }
        for (int i = 0; i < this.attributeNames.size(); ++i) {
            String attributeName = (String)this.attributeNames.get(i);
            if (!otherFeatureSchema.attributeNames.contains(attributeName)) {
                return false;
            }
            if (orderMatters && !otherFeatureSchema.attributeNames.get(i).equals(attributeName)) {
                return false;
            }
            if (this.getAttributeType(attributeName) == otherFeatureSchema.getAttributeType(attributeName)) continue;
            return false;
        }
        return true;
    }

    public FeatureSchema setCoordinateSystem(CoordinateSystem coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
        return this;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public boolean isAttributeReadOnly(int attributeIndex) {
        return this.attributeReadOnly.get(attributeIndex);
    }

    public void setAttributeReadOnly(int attributeIndex, boolean isReadOnly) {
        this.attributeReadOnly.set(attributeIndex, isReadOnly);
    }
}

