/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.FontChooser;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.ValidatingTextField;
import com.vividsolutions.jump.workbench.ui.renderer.style.LabelStyle;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LabelStylePanel
extends JPanel
implements StylePanel {
    private static final String NONE = "(" + I18N.get((String)"ui.style.LabelStylePanel.none") + ")";
    private static final String CHOOSE_COLOUR = I18N.get((String)"ui.style.LabelStylePanel.choose-colour");
    private static final String CHOOSE_FONT = I18N.get((String)"ui.style.LabelStylePanel.choose-font");
    private static final String BROWSE = I18N.get((String)"ui.style.LabelStylePanel.browse");
    private static final String LABEL_ATTRIBUTE = I18N.get((String)"ui.style.LabelStylePanel.label-attribute");
    private static final String SCALE_LABELS_WITH_THE_ZOOM_LEVEL = I18N.get((String)"ui.style.LabelStylePanel.scale-labels-with-the-zoom-level");
    private static final String HIDE_LABELS_WHEN = I18N.get((String)"ui.style.LabelStylePanel.hide-labels-when");
    private static final String DRAW_OUTLINE_HALO_AROUND_LABELS = I18N.get((String)"ui.style.LabelStylePanel.draw-outline-halo-around-labels");
    private static final String ENABLE_LABELLING = I18N.get((String)"ui.style.LabelStylePanel.enable-labelling");
    private static final String HEIGHT = I18N.get((String)"ui.style.LabelStylePanel.height");
    private static final String OUTLINE_WIDTH = I18N.get((String)"ui.style.LabelStylePanel.outline-width");
    private static final String PREVIEW_AT_CURRENT_ZOOM_LEVEL = I18N.get((String)"ui.style.LabelStylePanel.preview-at-current-zoom-level");
    private static final String VERTICAL_ALIGNMENT_FOR_POINTS_AND_LINES = I18N.get((String)"ui.style.LabelStylePanel.vertical-alignment-for-lines");
    private static final String HORIZONTAL_ALIGNMENT_FOR_POINTS_AND_LINES = I18N.get((String)"ui.style.LabelStylePanel.horizontal-alignment-for-points_and_lines");
    private static final String CHANGE_FONT = I18N.get((String)"ui.style.LabelStylePanel.change-font");
    private static final String CHANGE_COLOUR = I18N.get((String)"ui.style.LabelStylePanel.change-colour");
    private static final String ANGLE_ATTRIBUTE_DEGREES = I18N.get((String)"ui.style.LabelStylePanel.angle-attribute-degrees");
    private static final String HIDE_OVERLAPPING_LABELS = I18N.get((String)"ui.style.LabelStylePanel.hide-overlapping-labels");
    private static final String HEIGHT_ATTRIBUTE = I18N.get((String)"ui.style.LabelStylePanel.height-attribute");
    private static final String SCALE_IS_BELOW = I18N.get((String)"ui.style.LabelStylePanel.scale-is-below");
    private static final String HIDE_AT_SCALE_TEXT = SCALE_IS_BELOW + "   1:";
    private BorderLayout borderLayout1 = new BorderLayout();
    private GridBagLayout gridBagLayout6 = new GridBagLayout();
    private JLabel attributeLabel = new JLabel();
    private JComboBox attributeComboBox = new JComboBox();
    private JComboBox angleAttributeComboBox = new JComboBox();
    private JPanel previewPanel = new JPanel(){

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            LabelStyle labelStyle = LabelStylePanel.this.createLabelStyle(LabelStylePanel.this.layer.getLabelStyle());
            if (!labelStyle.isEnabled()) {
                return;
            }
            labelStyle.initialize(LabelStylePanel.this.layer);
            labelStyle.paint((Graphics2D)g, LabelStylePanel.this.sampleText(), LabelStylePanel.this.layerViewPanel.getViewport(), new Point2D.Double((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0), LabelStylePanel.this.layer.getFeatureCollectionWrapper().isEmpty() ? 0.0 : LabelStyle.angle((Feature)LabelStylePanel.this.layer.getFeatureCollectionWrapper().iterator().next(), LabelStylePanel.this.getAngleAttribute(), 0.0), LabelStylePanel.this.layer.getFeatureCollectionWrapper().isEmpty() ? LabelStylePanel.this.getLabelHeight() : LabelStyle.height((Feature)LabelStylePanel.this.layer.getFeatureCollectionWrapper().iterator().next(), LabelStylePanel.this.getHeightAttribute(), LabelStylePanel.this.getLabelHeight()), false);
        }
    };
    private JCheckBox scaleCheckBox = new JCheckBox();
    private Layer layer;
    private JCheckBox labellingCheckBox = new JCheckBox();
    private Border border1;
    private LayerViewPanel layerViewPanel;
    private JDialog parent;
    private Color color;
    private Color outlineColor;
    private Font labelFont;
    private ValidatingTextField heightTextField = new ValidatingTextField("999", 7, new ValidatingTextField.Validator(){

        public boolean isValid(String text) {
            if (text.length() == 0) {
                return true;
            }
            try {
                Double.parseDouble(text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    });
    private ValidatingTextField outlineWidthField = new ValidatingTextField("4", 7, new ValidatingTextField.Validator(){

        public boolean isValid(String text) {
            if (text.length() == 0) {
                return true;
            }
            try {
                Double.parseDouble(text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    });
    private JLabel heightLabel = new JLabel();
    private JLabel outlineLabel = new JLabel();
    private JLabel previewLabel = new JLabel();
    private JPanel fillerPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JButton colorButton = new JButton();
    private JButton outlineColorButton = new JButton();
    private JPanel outlineButtonPanel = new JPanel();
    private JButton fontButton = new JButton();
    private JPanel jPanel3 = new JPanel();
    private JLabel verticalAlignmentLabel = new JLabel();
    private JComboBox verticalAlignmentComboBox = new JComboBox();
    private JLabel angleLabel = new JLabel();
    private JCheckBox hideOverlappingLabelsCheckBox = new JCheckBox();
    private JLabel heightAttributeLabel = new JLabel();
    private JComboBox heightAttributeComboBox = new JComboBox();
    private JLabel horizontalAlignmentLabel = new JLabel();
    private JComboBox horizontalAlignmentComboBox = new JComboBox();
    private JCheckBox showOutlineCheckBox = new JCheckBox();
    private JPanel hideAtScaleButtonPanel = new JPanel();
    private JCheckBox hideAtScaleCheckBox = new JCheckBox();
    private JLabel hideAtScaleLabel = new JLabel();
    private ValidatingTextField hideAtScaleField = new ValidatingTextField("999999", 7, new ValidatingTextField.Validator(){

        public boolean isValid(String text) {
            if (text.length() == 0) {
                return true;
            }
            try {
                Double.parseDouble(text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    });

    public String getTitle() {
        return I18N.get((String)"ui.style.LabelStylePanel.labels");
    }

    public String validateInput() {
        return null;
    }

    public LabelStylePanel(Layer layer, LayerViewPanel layerViewPanel, JDialog parent, ErrorHandler errorHandler) {
        try {
            this.parent = parent;
            this.layerViewPanel = layerViewPanel;
            this.verticalAlignmentComboBox.addItem(LabelStyle.ABOVE_LINE_TEXT);
            this.verticalAlignmentComboBox.addItem(LabelStyle.ON_LINE_TEXT);
            this.verticalAlignmentComboBox.addItem(LabelStyle.BELOW_LINE_TEXT);
            this.horizontalAlignmentComboBox.addItem(LabelStyle.JUSTIFY_CENTER_TEXT);
            this.horizontalAlignmentComboBox.addItem(LabelStyle.JUSTIFY_LEFT_TEXT);
            this.horizontalAlignmentComboBox.addItem(LabelStyle.JUSTIFY_RIGHT_TEXT);
            this.setLayer(layer);
            this.jbInit();
            this.heightTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    this.documentChanged();
                }

                public void removeUpdate(DocumentEvent e) {
                    this.documentChanged();
                }

                public void changedUpdate(DocumentEvent e) {
                    this.documentChanged();
                }

                private void documentChanged() {
                    LabelStylePanel.this.updateControls();
                }
            });
            this.outlineWidthField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    this.documentChanged();
                }

                public void removeUpdate(DocumentEvent e) {
                    this.documentChanged();
                }

                public void changedUpdate(DocumentEvent e) {
                    this.documentChanged();
                }

                private void documentChanged() {
                    LabelStylePanel.this.updateControls();
                }
            });
            this.hideAtScaleField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    this.documentChanged();
                }

                public void removeUpdate(DocumentEvent e) {
                    this.documentChanged();
                }

                public void changedUpdate(DocumentEvent e) {
                    this.documentChanged();
                }

                private void documentChanged() {
                    LabelStylePanel.this.updateControls();
                }
            });
            this.colorButton.setToolTipText(BROWSE);
            this.outlineColorButton.setToolTipText(BROWSE);
            this.fontButton.setToolTipText(BROWSE);
            this.updateControls();
        }
        catch (Throwable t) {
            errorHandler.handleThrowable(t);
        }
    }

    private String sampleText() {
        Object attribute;
        String sampleText = "Abc123";
        if (this.layer.getFeatureCollectionWrapper().isEmpty()) {
            return sampleText;
        }
        Feature firstFeature = (Feature)this.layer.getFeatureCollectionWrapper().iterator().next();
        Object object = attribute = this.getLabelAttribute().equals("$FID") ? firstFeature.getID() + "" : firstFeature.getAttribute(this.getLabelAttribute());
        if (attribute == null) {
            return sampleText;
        }
        if (attribute.toString().trim().length() == 0) {
            return sampleText;
        }
        return attribute.toString().trim();
    }

    private void setLayer(Layer layer) {
        this.layer = layer;
        LabelStyle labelStyle = layer.getLabelStyle();
        this.setLabelling(labelStyle.isEnabled());
        this.setAttributes(layer.getFeatureCollectionWrapper().getFeatureSchema());
        this.setAttribute(labelStyle.getAttribute());
        this.setAngleAttribute(labelStyle.getAngleAttribute());
        this.setHeightAttribute(labelStyle.getHeightAttribute());
        this.setColor(labelStyle.getColor());
        this.setLabelFont(labelStyle.getFont());
        this.setScaling(labelStyle.isScaling());
        this.setHideAtScale(labelStyle.isHidingAtScale());
        this.setHideAtScaleField(labelStyle.getScaleToHideAt());
        this.setOutline(labelStyle.getOutlineShowing());
        this.hideOverlappingLabelsCheckBox.setSelected(labelStyle.isHidingOverlappingLabels());
        this.heightTextField.setText(labelStyle.getHeight() + "");
        this.outlineWidthField.setText(labelStyle.getOutlineWidth() + "");
        String va = labelStyle.getVerticalAlignment();
        int index = 0;
        for (index = LabelStyle.verticalAlignmentLookup.length - 1; index > 0 && !va.equalsIgnoreCase(LabelStyle.verticalAlignmentLookup[index]); --index) {
        }
        this.verticalAlignmentComboBox.setSelectedIndex(index);
        this.horizontalAlignmentComboBox.setSelectedIndex(labelStyle.getHorizontalAlignment());
    }

    private void setHideAtScaleField(double scaleField) {
        this.hideAtScaleField.setText(scaleField + "");
    }

    private void setAttributes(FeatureSchema schema) {
        this.attributeComboBox.removeAllItems();
        this.angleAttributeComboBox.removeAllItems();
        this.heightAttributeComboBox.removeAllItems();
        this.attributeComboBox.addItem("$FID");
        this.angleAttributeComboBox.addItem(NONE);
        this.heightAttributeComboBox.addItem(NONE);
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            this.attributeComboBox.addItem(schema.getAttributeName(i));
            if (schema.getAttributeType(i) != AttributeType.DOUBLE && schema.getAttributeType(i) != AttributeType.INTEGER) continue;
            this.angleAttributeComboBox.addItem(schema.getAttributeName(i));
            this.heightAttributeComboBox.addItem(schema.getAttributeName(i));
        }
    }

    private void setLabelling(boolean labelling) {
        this.labellingCheckBox.setSelected(labelling);
    }

    private void setColor(Color color) {
        this.color = color;
    }

    private void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    private void setAttribute(String attribute) {
        Assert.isTrue((!attribute.equals("") ? 1 : 0) != 0);
        this.attributeComboBox.setSelectedItem(attribute);
    }

    private void setAngleAttribute(String angleAttribute) {
        if (angleAttribute.equals("")) {
            this.angleAttributeComboBox.setSelectedItem(NONE);
            return;
        }
        this.angleAttributeComboBox.setSelectedItem(angleAttribute);
    }

    private void setHeightAttribute(String heightAttribute) {
        if (heightAttribute.equals("")) {
            this.heightAttributeComboBox.setSelectedItem(NONE);
            return;
        }
        this.heightAttributeComboBox.setSelectedItem(heightAttribute);
    }

    private void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }

    private void setScaling(boolean scaling) {
        this.scaleCheckBox.setSelected(scaling);
    }

    private void setOutline(boolean showOutline) {
        this.showOutlineCheckBox.setSelected(showOutline);
    }

    private void setHideAtScale(boolean hideAtScale) {
        this.hideAtScaleCheckBox.setSelected(hideAtScale);
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(2, 10, 2, 5);
        this.setLayout(this.borderLayout1);
        this.setLayout(this.gridBagLayout6);
        this.attributeLabel.setText(LABEL_ATTRIBUTE);
        this.previewPanel.setBackground(Color.white);
        this.previewPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.previewPanel.setMaximumSize(new Dimension(200, 38));
        this.previewPanel.setMinimumSize(new Dimension(200, 38));
        this.previewPanel.setPreferredSize(new Dimension(200, 38));
        this.scaleCheckBox.setText(SCALE_LABELS_WITH_THE_ZOOM_LEVEL);
        this.scaleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.scaleCheckBox_actionPerformed(e);
            }
        });
        this.hideAtScaleCheckBox.setText(HIDE_LABELS_WHEN);
        this.hideAtScaleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.hideAtScaleCheckBox_actionPerformed(e);
            }
        });
        this.hideAtScaleLabel.setText(HIDE_AT_SCALE_TEXT);
        this.showOutlineCheckBox.setText(DRAW_OUTLINE_HALO_AROUND_LABELS);
        this.showOutlineCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.showOutlineCheckBox_actionPerformed(e);
            }
        });
        this.setBorder(this.border1);
        this.labellingCheckBox.setText(ENABLE_LABELLING);
        this.labellingCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.enableLabellingCheckBox_actionPerformed(e);
            }
        });
        this.heightLabel.setText(HEIGHT);
        this.attributeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.attributeComboBox_actionPerformed(e);
            }
        });
        this.outlineLabel.setText(OUTLINE_WIDTH);
        this.angleAttributeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.angleAttributeComboBox_actionPerformed(e);
            }
        });
        this.previewLabel.setText(PREVIEW_AT_CURRENT_ZOOM_LEVEL);
        this.buttonPanel.setLayout(this.gridBagLayout2);
        this.outlineButtonPanel.setLayout(this.gridBagLayout2);
        this.colorButton.setText(CHANGE_COLOUR);
        this.colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.colorButton_actionPerformed(e);
            }
        });
        this.outlineColorButton.setText(CHANGE_COLOUR);
        this.outlineColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.outlineColorButton_actionPerformed(e);
            }
        });
        this.fontButton.setText(CHANGE_FONT);
        this.fontButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.fontButton_actionPerformed(e);
            }
        });
        this.verticalAlignmentLabel.setText(VERTICAL_ALIGNMENT_FOR_POINTS_AND_LINES);
        this.verticalAlignmentComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.verticalAlignmentComboBox_actionPerformed(e);
            }
        });
        this.horizontalAlignmentLabel.setText(HORIZONTAL_ALIGNMENT_FOR_POINTS_AND_LINES);
        this.horizontalAlignmentComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.horizontalAlignmentComboBox_actionPerformed(e);
            }
        });
        this.angleLabel.setText(ANGLE_ATTRIBUTE_DEGREES);
        this.hideOverlappingLabelsCheckBox.setText(HIDE_OVERLAPPING_LABELS);
        this.hideOverlappingLabelsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.hideOverlappingLabelsCheckBox_actionPerformed(e);
            }
        });
        this.heightAttributeLabel.setText(HEIGHT_ATTRIBUTE);
        this.heightAttributeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.heightAttributeComboBox_actionPerformed(e);
            }
        });
        int row = 0;
        this.add((Component)this.labellingCheckBox, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.attributeLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.attributeComboBox, new GridBagConstraints(1, row++, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 2, 0), 0, 0));
        this.add((Component)this.verticalAlignmentLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.verticalAlignmentComboBox, new GridBagConstraints(1, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 2, 0), 0, 0));
        this.add((Component)this.horizontalAlignmentLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.horizontalAlignmentComboBox, new GridBagConstraints(1, row++, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 2, 0), 0, 0));
        this.add((Component)this.angleLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.angleAttributeComboBox, new GridBagConstraints(1, row++, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 2, 0), 0, 0));
        this.add((Component)this.heightAttributeLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.heightAttributeComboBox, new GridBagConstraints(1, row++, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 2, 0), 0, 0));
        this.add((Component)this.heightTextField, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.add((Component)this.heightLabel, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.scaleCheckBox, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.hideAtScaleButtonPanel.setLayout(this.gridBagLayout2);
        this.add((Component)this.hideAtScaleButtonPanel, new GridBagConstraints(0, row++, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.hideAtScaleButtonPanel.add((Component)this.hideAtScaleCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.hideAtScaleButtonPanel.add((Component)this.hideAtScaleLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.hideAtScaleButtonPanel.add((Component)this.hideAtScaleField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.hideAtScaleButtonPanel.add((Component)new JPanel(), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.hideOverlappingLabelsCheckBox, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.colorButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.fontButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.jPanel3, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.showOutlineCheckBox, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.outlineButtonPanel, new GridBagConstraints(0, row++, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.outlineButtonPanel.add((Component)this.outlineColorButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.outlineButtonPanel.add((Component)this.outlineLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.outlineButtonPanel.add((Component)this.outlineWidthField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.add((Component)this.previewLabel, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.previewPanel, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 4), 0, 0));
        this.add((Component)this.fillerPanel, new GridBagConstraints(98, 104, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStyles() {
        boolean firingEvents = this.layer.getLayerManager().isFiringEvents();
        this.layer.getLayerManager().setFiringEvents(false);
        try {
            LabelStyle newLabelStyle = this.createLabelStyle(this.layer.getLabelStyle());
            this.layer.removeStyle(this.layer.getLabelStyle());
            this.layer.addStyle(newLabelStyle);
        }
        finally {
            this.layer.getLayerManager().setFiringEvents(firingEvents);
        }
        this.layer.fireAppearanceChanged();
    }

    private String getAngleAttribute() {
        if (NONE == this.angleAttributeComboBox.getSelectedItem()) {
            return "";
        }
        return (String)this.angleAttributeComboBox.getSelectedItem();
    }

    private String getHeightAttribute() {
        if (NONE == this.heightAttributeComboBox.getSelectedItem()) {
            return "";
        }
        return (String)this.heightAttributeComboBox.getSelectedItem();
    }

    private String getLabelAttribute() {
        return (String)this.attributeComboBox.getSelectedItem();
    }

    public LabelStyle createLabelStyle(LabelStyle defaultValues) {
        LabelStyle labelStyle = (LabelStyle)defaultValues.clone();
        labelStyle.setEnabled(this.labellingCheckBox.isSelected());
        Assert.isTrue((this.attributeComboBox.getSelectedIndex() != -1 ? 1 : 0) != 0);
        labelStyle.setAttribute(this.getLabelAttribute());
        labelStyle.setAngleAttribute(this.getAngleAttribute());
        labelStyle.setHeightAttribute(this.getHeightAttribute());
        labelStyle.setColor(this.color);
        labelStyle.setOutlineColor(this.outlineColor);
        labelStyle.setFont(this.labelFont);
        labelStyle.setScaling(this.scaleCheckBox.isSelected());
        labelStyle.setHideAtScale(this.hideAtScaleCheckBox.isSelected());
        labelStyle.setOutlineShowing(this.showOutlineCheckBox.isSelected());
        labelStyle.setHidingOverlappingLabels(this.hideOverlappingLabelsCheckBox.isSelected());
        labelStyle.setHeight(this.getLabelHeight());
        labelStyle.setOutlineWidth(this.getOutlineWidth());
        labelStyle.setScaleToHideAt(this.getScaleToHideAt());
        labelStyle.setVerticalAlignment(LabelStyle.verticalAlignmentLookup[this.verticalAlignmentComboBox.getSelectedIndex()]);
        labelStyle.setHorizontalAlignment(this.horizontalAlignmentComboBox.getSelectedIndex());
        return labelStyle;
    }

    private double getLabelHeight() {
        return this.heightTextField.getText().length() == 0 ? 12.0 : Double.parseDouble(this.heightTextField.getText());
    }

    private double getOutlineWidth() {
        return this.outlineWidthField.getText().length() == 0 ? 12.0 : Double.parseDouble(this.outlineWidthField.getText());
    }

    private double getScaleToHideAt() {
        double scale = this.hideAtScaleField.getText().length() == 0 ? 20000.0 : Double.parseDouble(this.hideAtScaleField.getText());
        return scale;
    }

    public void updateControls() {
        this.previewPanel.repaint();
        this.attributeLabel.setEnabled(this.labellingCheckBox.isSelected());
        this.angleLabel.setEnabled(this.labellingCheckBox.isSelected());
        this.heightAttributeLabel.setEnabled(this.labellingCheckBox.isSelected());
        this.attributeComboBox.setEnabled(this.labellingCheckBox.isSelected());
        this.angleAttributeComboBox.setEnabled(this.labellingCheckBox.isSelected());
        this.heightAttributeComboBox.setEnabled(this.labellingCheckBox.isSelected());
        this.colorButton.setEnabled(this.labellingCheckBox.isSelected());
        this.fontButton.setEnabled(this.labellingCheckBox.isSelected());
        this.heightLabel.setEnabled(this.labellingCheckBox.isSelected() && this.getHeightAttribute().equals(""));
        this.heightTextField.setEnabled(this.labellingCheckBox.isSelected() && this.getHeightAttribute().equals(""));
        this.showOutlineCheckBox.setEnabled(this.labellingCheckBox.isSelected());
        this.outlineWidthField.setEnabled(this.labellingCheckBox.isSelected() && this.showOutlineCheckBox.isSelected());
        this.outlineLabel.setEnabled(this.labellingCheckBox.isSelected() && this.showOutlineCheckBox.isSelected());
        this.outlineColorButton.setEnabled(this.labellingCheckBox.isSelected() && this.showOutlineCheckBox.isSelected());
        this.scaleCheckBox.setEnabled(this.labellingCheckBox.isSelected());
        this.hideOverlappingLabelsCheckBox.setEnabled(this.labellingCheckBox.isSelected());
        this.hideAtScaleCheckBox.setEnabled(this.labellingCheckBox.isSelected());
        this.hideAtScaleLabel.setEnabled(this.labellingCheckBox.isSelected() && this.hideAtScaleCheckBox.isSelected());
        this.hideAtScaleField.setEnabled(this.labellingCheckBox.isSelected() && this.hideAtScaleCheckBox.isSelected());
        this.previewLabel.setEnabled(this.labellingCheckBox.isSelected());
        this.previewPanel.setEnabled(this.labellingCheckBox.isSelected());
        this.verticalAlignmentLabel.setEnabled(this.labellingCheckBox.isSelected());
        this.verticalAlignmentComboBox.setEnabled(this.labellingCheckBox.isSelected());
        this.horizontalAlignmentLabel.setEnabled(this.labellingCheckBox.isSelected());
        this.horizontalAlignmentComboBox.setEnabled(this.labellingCheckBox.isSelected());
    }

    void colorButton_actionPerformed(ActionEvent e) {
        Color newColor = JColorChooser.showDialog(this, CHOOSE_COLOUR, this.color);
        if (newColor == null) {
            return;
        }
        this.setColor(newColor);
        this.updateControls();
    }

    void outlineColorButton_actionPerformed(ActionEvent e) {
        Color newColor = JColorChooser.showDialog(this, CHOOSE_COLOUR, this.color);
        if (newColor == null) {
            return;
        }
        this.setOutlineColor(newColor);
        this.updateControls();
    }

    void fontButton_actionPerformed(ActionEvent e) {
        Font newFont = FontChooser.showDialog(this.parent, CHOOSE_FONT, this.labelFont);
        if (newFont == null) {
            return;
        }
        this.setLabelFont(newFont);
        this.updateControls();
    }

    void enableLabellingCheckBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    void attributeComboBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    void angleAttributeComboBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    void scaleCheckBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    void hideAtScaleCheckBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    void showOutlineCheckBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    void verticalAlignmentComboBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    void horizontalAlignmentComboBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    void hideOverlappingLabelsCheckBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    void heightAttributeComboBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }
}

