/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadSafeImage;
import java.awt.Graphics2D;
import javax.swing.SwingUtilities;

public abstract class ImageCachingRenderer
implements Renderer {
    protected volatile boolean cancelled = false;
    private Object contentID;
    protected volatile ThreadSafeImage image = null;
    protected LayerViewPanel panel;
    protected volatile boolean rendering = false;

    public ImageCachingRenderer(Object contentID, LayerViewPanel panel) {
        this.contentID = contentID;
        this.panel = panel;
    }

    public void clearImageCache() {
        this.image = null;
    }

    public boolean isRendering() {
        return this.rendering;
    }

    public Object getContentID() {
        return this.contentID;
    }

    protected ThreadSafeImage getImage() {
        return this.image;
    }

    public void copyTo(Graphics2D graphics) {
        if (this.getImage() == null) {
            return;
        }
        this.getImage().copyTo(graphics, null);
    }

    public Runnable createRunnable() {
        if (this.image != null) {
            return null;
        }
        this.rendering = true;
        this.cancelled = false;
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (ImageCachingRenderer.this.cancelled) {
                        return;
                    }
                    ImageCachingRenderer.this.image = new ThreadSafeImage(ImageCachingRenderer.this.panel);
                    try {
                        ImageCachingRenderer.this.renderHook(ImageCachingRenderer.this.image);
                    }
                    catch (Throwable t) {
                        ImageCachingRenderer.this.panel.getContext().warnUser(WorkbenchFrame.toMessage(t));
                        t.printStackTrace(System.err);
                        ImageCachingRenderer.this.rendering = false;
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ImageCachingRenderer.this.panel.superRepaint();
                        }
                    });
                }
                finally {
                    ImageCachingRenderer.this.rendering = false;
                }
            }
        };
    }

    protected abstract void renderHook(ThreadSafeImage var1) throws Exception;

    public void cancel() {
        this.cancelled = true;
    }
}

