/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.imagery;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageStyle;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.imagery.ImageFeatureCreator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImageLayerManagerPlugIn
extends AbstractPlugIn {
    public ImageLayerManagerPlugIn() {
        super(I18N.get((String)"ui.plugin.imagery.ImageLayerManagerPlugIn.Image-Layer-Manager"));
    }

    public static EnableCheck createEnableCheck(final WorkbenchContext context) {
        MultiEnableCheck mec = new MultiEnableCheck();
        mec.add(new EnableCheckFactory(context).createExactlyNLayersMustBeSelectedCheck(1));
        mec.add(new EnableCheck(){

            public String check(JComponent component) {
                return context.getLayerNamePanel().getSelectedLayers()[0].getStyle(ReferencedImageStyle.class) == null ? I18N.get((String)"ui.plugin.imagery.ImageLayerManagerPlugIn.Layer-must-be-an-Imagery-layer") : null;
            }
        });
        return mec;
    }

    public boolean execute(PlugInContext context) throws Exception {
        ImageLayerManagerDialog dlg = new ImageLayerManagerDialog(context);
        dlg.pack();
        dlg.setModal(true);
        GUIUtil.centre(dlg, context.getWorkbenchFrame());
        dlg.setVisible(true);
        return false;
    }

    private static class ImageLayerManagerDialog
    extends JDialog {
        private PlugInContext context;
        private Layer layer;
        private Vector images;
        private JList imagesPaths;
        private JTextArea metadata;
        private JScrollPane metadataScrollPane;

        public ImageLayerManagerDialog(PlugInContext context) {
            super(context.getWorkbenchFrame());
            this.context = context;
            this.setTitle(I18N.get((String)"ui.plugin.imagery.ImageLayerManagerDialog.Image-Layer-Manager"));
            this.layer = context.getSelectedLayer(0);
            this.images = new Vector();
            Iterator i = this.layer.getFeatureCollectionWrapper().getFeatures().iterator();
            while (i.hasNext()) {
                this.images.add(new FeaturePrinter((Feature)i.next()));
            }
            this.initialize();
            this.loadMetadata();
            this.imagesPaths.setSelectedIndex(0);
        }

        private void initialize() {
            JPanel mainPanel = this.createMainPanel();
            JPanel buttonPanel = this.createButtonPanel();
            JPanel dialogPanel = new JPanel(new BorderLayout());
            dialogPanel.add((Component)mainPanel, "Center");
            dialogPanel.add((Component)buttonPanel, "East");
            this.getContentPane().add(dialogPanel);
        }

        private JPanel createMainPanel() {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            this.imagesPaths = new JList();
            this.imagesPaths.setListData(this.images);
            this.imagesPaths.setBorder(BorderFactory.createLoweredBevelBorder());
            this.imagesPaths.setFont(this.context.getActiveInternalFrame().getFont());
            JScrollPane imagePathsScrollPane = new JScrollPane(this.imagesPaths);
            imagePathsScrollPane.setPreferredSize(new Dimension(400, 150));
            imagePathsScrollPane.setMinimumSize(new Dimension(400, 150));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.fill = 2;
            this.imagesPaths.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    ImageLayerManagerDialog.this.loadMetadata();
                }
            });
            this.imagesPaths.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    ImageLayerManagerDialog.this.flashSelectedImages();
                }
            });
            mainPanel.add((Component)imagePathsScrollPane, gbc);
            JLabel label = new JLabel();
            label.setText("Image Metadata");
            label.setFont(this.context.getActiveInternalFrame().getFont());
            label.setBackground(this.getBackground());
            gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.fill = 0;
            mainPanel.add((Component)label, gbc);
            this.metadata = new JTextArea();
            this.metadata.setBackground(this.getBackground());
            this.metadata.setAutoscrolls(true);
            this.metadata.setFont(this.context.getActiveInternalFrame().getFont());
            gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridwidth = 1;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.ipadx = 4;
            gbc.ipady = 4;
            gbc.fill = 1;
            this.metadata.setMargin(new Insets(4, 4, 4, 4));
            this.metadata.setEditable(false);
            this.metadataScrollPane = new JScrollPane(this.metadata);
            this.metadataScrollPane.setPreferredSize(new Dimension(400, 100));
            mainPanel.add((Component)this.metadataScrollPane, gbc);
            return mainPanel;
        }

        private JPanel createButtonPanel() {
            int buttonNumber = 0;
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridBagLayout());
            JButton button = new JButton(I18N.get((String)"ui.plugin.imagery.ImageLayerManagerDialog.Add") + "...", GUIUtil.toSmallIcon(IconLoader.icon("Plus.gif")));
            button.addActionListener(new AddButtonListener());
            buttonPanel.add((Component)button, new GridBagConstraints(0, buttonNumber++, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
            button = new JButton(I18N.get((String)"ui.plugin.imagery.ImageLayerManagerDialog.Delete"), GUIUtil.toSmallIcon(IconLoader.icon("Delete.gif")));
            button.addActionListener(new DeleteButtonListener());
            buttonPanel.add((Component)button, new GridBagConstraints(0, buttonNumber++, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
            button = new JButton(I18N.get((String)"ui.plugin.imagery.ImageLayerManagerDialog.Close"));
            button.addActionListener(new CloseButtonListener(this));
            buttonPanel.add((Component)button, new GridBagConstraints(0, buttonNumber++, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
            buttonPanel.add((Component)new Label(), new GridBagConstraints(0, buttonNumber++, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
            return buttonPanel;
        }

        private void flashSelectedImages() {
            GeometryFactory factory = new GeometryFactory();
            Object[] values = this.imagesPaths.getSelectedValues();
            Geometry[] geoms = new Geometry[values.length];
            if (values != null && values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    FeaturePrinter current = (FeaturePrinter)values[i];
                    geoms[i] = current.instance.getGeometry();
                }
            }
            try {
                GeometryCollection gc = factory.createGeometryCollection(geoms);
                this.context.getLayerViewPanel().flash(gc);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }

        private void loadMetadata() {
            Object[] values;
            StringBuffer buf = new StringBuffer();
            if (this.images.size() > 0 && (values = this.imagesPaths.getSelectedValues()) != null && values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    FeaturePrinter current;
                    if (values[i] != null && (current = (FeaturePrinter)values[i]).instance != null) {
                        this.appendMetadata(current.instance, buf);
                    }
                    buf.append("\n");
                }
            }
            buf.append("\n  ");
            this.metadata.setText(buf.toString());
            this.metadata.setCaretPosition(0);
        }

        private void appendMetadata(Feature imageFeat, StringBuffer buf) {
            buf.append(I18N.get((String)"ui.plugin.imagery.ImageLayerManagerDialog.Filename") + ": \t" + imageFeat.getAttribute("IMAGEFILE") + "\n");
            buf.append("  " + I18N.get((String)"ui.plugin.imagery.ImageLayerManagerDialog.Format") + ": \t" + imageFeat.getAttribute("IMAGEFORMAT") + "\n");
            this.appendEnvelope(imageFeat.getGeometry().getEnvelopeInternal(), buf);
        }

        private void appendEnvelope(Envelope env, StringBuffer buf) {
            buf.append("  " + I18N.get((String)"ui.plugin.imagery.ImageLayerManagerDialog.Lower-Left") + ":  \t" + env.getMinX() + ", " + env.getMinY() + "\n");
            buf.append("  " + I18N.get((String)"ui.plugin.imagery.ImageLayerManagerDialog.Upper-Right") + ": \t" + env.getMaxX() + ", " + env.getMaxY() + "\n");
        }

        private void deleteSelectedImages() {
            Object[] values = this.imagesPaths.getSelectedValues();
            if (values != null) {
                ImageFeatureCreator ifc = new ImageFeatureCreator();
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null) continue;
                    FeaturePrinter current = (FeaturePrinter)values[i];
                    if (current.instance != null) {
                        this.layer.getFeatureCollectionWrapper().remove(current.instance);
                    }
                    this.images.remove(current);
                    this.imagesPaths.setListData(this.images);
                }
                ifc.setLayerSelectability(this.layer);
            }
        }

        private void addImages() {
            ImageFeatureCreator ifc = new ImageFeatureCreator();
            Collection features = ifc.getImages(this.context, this.layer);
            FeaturePrinter fp = null;
            if (features != null) {
                for (Feature f : features) {
                    fp = new FeaturePrinter(f);
                    this.images.addElement(fp);
                    this.layer.getFeatureCollectionWrapper().add(f);
                }
                this.imagesPaths.setListData(this.images);
                if (fp != null) {
                    this.imagesPaths.setSelectedValue(fp, true);
                }
                ifc.setLayerSelectability(this.layer);
            }
        }

        private class CloseButtonListener
        implements ActionListener {
            private JDialog dialog;

            CloseButtonListener(JDialog dlg) {
                this.dialog = dlg;
            }

            public void actionPerformed(ActionEvent e) {
                this.dialog.dispose();
            }
        }

        private class AddButtonListener
        implements ActionListener {
            private AddButtonListener() {
            }

            public void actionPerformed(ActionEvent e) {
                ImageLayerManagerDialog.this.addImages();
            }
        }

        private class DeleteButtonListener
        implements ActionListener {
            private DeleteButtonListener() {
            }

            public void actionPerformed(ActionEvent e) {
                ImageLayerManagerDialog.this.deleteSelectedImages();
            }
        }
    }

    private static class FeaturePrinter {
        private Feature instance;

        public FeaturePrinter(Feature i) {
            this.instance = i;
        }

        public String toString() {
            String val = this.instance == null ? "   " : (String)this.instance.getAttribute("IMAGEFILE");
            return val;
        }
    }
}

