/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.UndoableEditReceiver;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.ui.ApplicationExitHandler;
import com.vividsolutions.jump.workbench.ui.ErrorDialog;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.HTMLFrame;
import com.vividsolutions.jump.workbench.ui.InternalFrameCloseHandler;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelListener;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelListener;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.PrimaryInfoFrame;
import com.vividsolutions.jump.workbench.ui.RecursiveKeyListener;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.ViewportListener;
import com.vividsolutions.jump.workbench.ui.WorkbenchToolBar;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.style.ChoosableStyle;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openjump.core.model.TaskEvent;
import org.openjump.core.model.TaskListener;
import org.openjump.swing.factory.component.ComponentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbenchFrame
extends JFrame
implements LayerViewPanelContext,
ViewportListener {
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel coordinateLabel = new JLabel();
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = (JMenu)FeatureInstaller.installMnemonic(new JMenu(MenuNames.FILE), this.menuBar);
    JMenuItem exitMenuItem = FeatureInstaller.installMnemonic(new JMenuItem(I18N.get((String)"ui.WorkbenchFrame.exit")), this.fileMenu);
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JTextField messageTextField = new JTextField();
    JPanel statusPanel = new JPanel();
    JLabel timeLabel = new JLabel();
    WorkbenchToolBar toolBar;
    JMenu windowMenu = (JMenu)FeatureInstaller.installMnemonic(new JMenu(MenuNames.WINDOW), this.menuBar);
    private DecimalFormat memoryFormat = new DecimalFormat("###,###");
    private TitledPopupMenu categoryPopupMenu = new TitledPopupMenu(){
        {
            this.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    LayerNamePanel panel = ((LayerNamePanelProxy)((Object)WorkbenchFrame.this.getActiveInternalFrame())).getLayerNamePanel();
                    this.setTitle(panel.selectedNodes(Category.class).size() != 1 ? "(" + panel.selectedNodes(Category.class).size() + " categories selected)" : ((Category)panel.selectedNodes(Category.class).iterator().next()).getName());
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    };
    private JDesktopPane desktopPane = new JDesktopPane(){
        {
            this.setDesktopManager(new DefaultDesktopManager());
        }
    };
    private int envelopeRenderingThreshold = 500;
    private HTMLFrame outputFrame = new HTMLFrame(this){
        {
            super.setTitle(I18N.get((String)"ui.WorkbenchFrame.output"));
        }

        public void setTitle(String title) {
        }
    };
    private TitledPopupMenu layerNamePopupMenu = new TitledPopupMenu(){
        {
            this.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    LayerNamePanel panel = ((LayerNamePanelProxy)((Object)WorkbenchFrame.this.getActiveInternalFrame())).getLayerNamePanel();
                    this.setTitle(panel.selectedNodes(Layer.class).size() != 1 ? "(" + panel.selectedNodes(Layer.class).size() + " " + I18N.get((String)"ui.WorkbenchFrame.layers-selected") + ")" : ((Layerable)panel.selectedNodes(Layer.class).iterator().next()).getName());
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    };
    private TitledPopupMenu wmsLayerNamePopupMenu = new TitledPopupMenu(){
        {
            this.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    LayerNamePanel panel = ((LayerNamePanelProxy)((Object)WorkbenchFrame.this.getActiveInternalFrame())).getLayerNamePanel();
                    this.setTitle(panel.selectedNodes(WMSLayer.class).size() != 1 ? "(" + panel.selectedNodes(WMSLayer.class).size() + " " + I18N.get((String)"ui.WorkbenchFrame.wms-layers-selected") + ")" : ((Layerable)panel.selectedNodes(WMSLayer.class).iterator().next()).getName());
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    };
    private LayerNamePanelListener layerNamePanelListener = new LayerNamePanelListener(){

        public void layerSelectionChanged() {
            WorkbenchFrame.this.toolBar.updateEnabledState();
        }
    };
    private LayerViewPanelListener layerViewPanelListener = new LayerViewPanelListener(){
        private StringBuffer positionStatusBuf = new StringBuffer("(");

        public void cursorPositionChanged(String x, String y) {
            this.positionStatusBuf.setLength(1);
            this.positionStatusBuf.append(x).append(", ").append(y).append(")");
            WorkbenchFrame.this.coordinateLabel.setText(this.positionStatusBuf.toString());
        }

        public void selectionChanged() {
            WorkbenchFrame.this.toolBar.updateEnabledState();
        }

        public void fenceChanged() {
            WorkbenchFrame.this.toolBar.updateEnabledState();
        }

        public void painted(Graphics graphics) {
        }
    };
    private int maximumFeatureExtentForEnvelopeRenderingInPixels = 10;
    private int minimumFeatureExtentForAnyRenderingInPixels = 2;
    private StringBuffer log = new StringBuffer();
    private int taskSequence = 1;
    private WorkbenchContext workbenchContext;
    private JLabel memoryLabel = new JLabel();
    private String lastStatusMessage = "";
    private Set choosableStyleClasses = new HashSet();
    private JLabel wmsLabel = new JLabel();
    private ArrayList easyKeyListeners = new ArrayList();
    private ArrayList<TaskListener> taskListeners = new ArrayList();
    private Map nodeClassToLayerNamePopupMenuMap = CollectionUtil.createMap((Object[])new Object[]{Layer.class, this.layerNamePopupMenu, WMSLayer.class, this.wmsLayerNamePopupMenu, Category.class, this.categoryPopupMenu});
    private int positionIndex = -1;
    private int primaryInfoFrameIndex = -1;
    private int addedMenuItems = -1;
    private ComponentFactory<TaskFrame> taskFrameFactory;
    private ArrayList lastFiveThrowableDates = new ArrayList(){

        public boolean add(Object o) {
            if (this.size() == 5) {
                this.remove(0);
            }
            return super.add(o);
        }
    };
    private HashMap keyCodeAndModifiersToPlugInAndEnableCheckMap = new HashMap();
    InternalFrameCloseHandler internalFrameCloseHandler = new DefaultInternalFrameCloser();
    ApplicationExitHandler applicationExitHandler = new DefaultApplicationExitHandler();
    public static final String MAXIMIZED_KEY = WorkbenchFrame.class.getName() + " - MAXIMIZED_KEY";
    public static final String HORIZONTAL_KEY = WorkbenchFrame.class.getName() + " - HORIZONTAL_KEY";
    public static final String VERTICAL_KEY = WorkbenchFrame.class.getName() + " - VERTICAL_KEY";
    public static final String WIDTH_KEY = WorkbenchFrame.class.getName() + " - WIDTH_KEY";
    public static final String HEIGHT_KEY = WorkbenchFrame.class.getName() + " - HEIGHT_KEY";

    public WorkbenchFrame(String title, WorkbenchContext workbenchContext) throws Exception {
        this.setTitle(title);
        new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkbenchFrame.this.memoryLabel.setText(WorkbenchFrame.this.getMBCommittedMemory() + " MB " + I18N.get((String)"ui.WorkbenchFrame.committed-memory"));
            }
        }).start();
        this.workbenchContext = workbenchContext;
        JUMPWorkbench.setIcon(this);
        this.toolBar = new WorkbenchToolBar(workbenchContext);
        this.toolBar.setTaskMonitorManager(new TaskMonitorManager());
        try {
            this.jbInit();
            this.configureStatusLabel(this.messageTextField, 300);
            this.configureStatusLabel(this.coordinateLabel, 150);
            this.configureStatusLabel(this.timeLabel, 200);
            this.configureStatusLabel(this.wmsLabel, 100);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new RecursiveKeyListener(this){

            public void keyTyped(KeyEvent e) {
                for (KeyListener l : WorkbenchFrame.this.easyKeyListeners) {
                    l.keyTyped(e);
                }
            }

            public void keyPressed(KeyEvent e) {
                for (KeyListener l : new ArrayList(WorkbenchFrame.this.easyKeyListeners)) {
                    l.keyPressed(e);
                }
            }

            public void keyReleased(KeyEvent e) {
                for (KeyListener l : new ArrayList(WorkbenchFrame.this.easyKeyListeners)) {
                    l.keyReleased(e);
                }
            }
        };
        this.installKeyboardShortcutListener();
    }

    public void addEasyKeyListener(KeyListener l) {
        this.easyKeyListeners.add(l);
    }

    public void removeEasyKeyListener(KeyListener l) {
        this.easyKeyListeners.remove(l);
    }

    public String getMBCommittedMemory() {
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        double usedMemoryInMB = (double)usedMemory / 1048576.0;
        String memoryStr = this.memoryFormat.format(usedMemoryInMB);
        return memoryStr;
    }

    public void setEnvelopeRenderingThreshold(int newEnvelopeRenderingThreshold) {
        this.envelopeRenderingThreshold = newEnvelopeRenderingThreshold;
    }

    public void setMaximumFeatureExtentForEnvelopeRenderingInPixels(int newMaximumFeatureExtentForEnvelopeRenderingInPixels) {
        this.maximumFeatureExtentForEnvelopeRenderingInPixels = newMaximumFeatureExtentForEnvelopeRenderingInPixels;
    }

    public void log(String message) {
        this.log.append(new Date() + "  " + message + System.getProperty("line.separator"));
    }

    public String getLog() {
        return this.log.toString();
    }

    public void setMinimumFeatureExtentForAnyRenderingInPixels(int newMinimumFeatureExtentForAnyRenderingInPixels) {
        this.minimumFeatureExtentForAnyRenderingInPixels = newMinimumFeatureExtentForAnyRenderingInPixels;
    }

    public void displayLastStatusMessage() {
        this.setStatusMessage(this.lastStatusMessage);
    }

    @Override
    public void setStatusMessage(String message) {
        this.lastStatusMessage = message;
        this.setStatusBarText(message);
        this.setStatusBarTextHighlighted(false, null);
    }

    private void setStatusBarText(String message) {
        this.messageTextField.setText(message.equals("") ? " " : message);
    }

    private void setStatusBarTextHighlighted(boolean highlighted, Color color) {
        this.messageTextField.setForeground(highlighted ? Color.black : this.coordinateLabel.getForeground());
        this.messageTextField.setBackground(highlighted ? color : this.coordinateLabel.getBackground());
    }

    public void setTimeMessage(String message) {
        this.timeLabel.setText(message.equals("") ? " " : message);
        this.timeLabel.setToolTipText(message);
    }

    public JInternalFrame getActiveInternalFrame() {
        return this.desktopPane.getSelectedFrame();
    }

    public JInternalFrame[] getInternalFrames() {
        return this.desktopPane.getAllFrames();
    }

    public TitledPopupMenu getCategoryPopupMenu() {
        return this.categoryPopupMenu;
    }

    public WorkbenchContext getContext() {
        return this.workbenchContext;
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    public int getEnvelopeRenderingThreshold() {
        return this.envelopeRenderingThreshold;
    }

    public TitledPopupMenu getLayerNamePopupMenu() {
        return this.layerNamePopupMenu;
    }

    public TitledPopupMenu getWMSLayerNamePopupMenu() {
        return this.wmsLayerNamePopupMenu;
    }

    public LayerViewPanelListener getLayerViewPanelListener() {
        return this.layerViewPanelListener;
    }

    public Map getNodeClassToPopupMenuMap() {
        return this.nodeClassToLayerNamePopupMenuMap;
    }

    public LayerNamePanelListener getLayerNamePanelListener() {
        return this.layerNamePanelListener;
    }

    public int getMaximumFeatureExtentForEnvelopeRenderingInPixels() {
        return this.maximumFeatureExtentForEnvelopeRenderingInPixels;
    }

    public int getMinimumFeatureExtentForAnyRenderingInPixels() {
        return this.minimumFeatureExtentForAnyRenderingInPixels;
    }

    public HTMLFrame getOutputFrame() {
        return this.outputFrame;
    }

    public WorkbenchToolBar getToolBar() {
        return this.toolBar;
    }

    public void activateFrame(JInternalFrame frame) {
        try {
            if (frame.isIcon()) {
                frame.setIcon(false);
            }
            frame.moveToFront();
            frame.requestFocus();
            frame.setSelected(true);
            if (!(frame instanceof TaskFrame)) {
                frame.setMaximum(false);
            }
        }
        catch (PropertyVetoException e) {
            this.warnUser(StringUtil.stackTrace((Throwable)e));
        }
    }

    public void addInternalFrame(JInternalFrame internalFrame) {
        this.addInternalFrame(internalFrame, false, true);
    }

    public void addInternalFrame(JInternalFrame internalFrame, boolean alwaysOnTop, boolean autoUpdateToolBar) {
        if (internalFrame instanceof LayerManagerProxy) {
            this.setClosingBehaviour((LayerManagerProxy)((Object)internalFrame));
            this.installTitleBarModifiedIndicator((LayerManagerProxy)((Object)internalFrame));
        }
        JUMPWorkbench.setIcon(internalFrame);
        internalFrame.setVisible(true);
        this.desktopPane.add((Component)internalFrame, alwaysOnTop ? JLayeredPane.PALETTE_LAYER : JLayeredPane.DEFAULT_LAYER);
        if (autoUpdateToolBar) {
            internalFrame.addInternalFrameListener(new InternalFrameListener(){

                public void internalFrameActivated(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                    WorkbenchFrame.this.toolBar.reClickSelectedCursorToolButton();
                }

                public void internalFrameClosed(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }

                public void internalFrameClosing(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }

                public void internalFrameDeactivated(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }

                public void internalFrameDeiconified(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }

                public void internalFrameIconified(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }

                public void internalFrameOpened(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }
            });
            this.activateFrame(internalFrame);
            this.position(internalFrame);
        }
    }

    private void installTitleBarModifiedIndicator(final LayerManagerProxy internalFrame) {
        final JInternalFrame i = (JInternalFrame)((Object)internalFrame);
        new Block(){
            private boolean updatingTitle = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void updateTitle() {
                if (this.updatingTitle) {
                    return;
                }
                this.updatingTitle = true;
                try {
                    String newTitle = i.getTitle();
                    if (newTitle.charAt(0) == '*') {
                        newTitle = newTitle.substring(1);
                    }
                    if (!internalFrame.getLayerManager().getLayersWithModifiedFeatureCollections().isEmpty()) {
                        newTitle = '*' + newTitle;
                    }
                    i.setTitle(newTitle);
                }
                finally {
                    this.updatingTitle = false;
                }
            }

            public Object yield() {
                internalFrame.getLayerManager().addLayerListener(new LayerListener(){

                    public void layerChanged(LayerEvent e) {
                        if (e.getType() == LayerEventType.METADATA_CHANGED || e.getType() == LayerEventType.REMOVED) {
                            this.updateTitle();
                        }
                    }

                    public void categoryChanged(CategoryEvent e) {
                    }

                    public void featuresChanged(FeatureEvent e) {
                    }
                });
                i.addPropertyChangeListener("title", new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent e) {
                        this.updateTitle();
                    }
                });
                return null;
            }
        }.yield();
    }

    private void setClosingBehaviour(LayerManagerProxy proxy) {
        final JInternalFrame internalFrame = (JInternalFrame)((Object)proxy);
        internalFrame.setDefaultCloseOperation(0);
        internalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                WorkbenchFrame.this.internalFrameCloseHandler.close(internalFrame);
            }
        });
    }

    private Collection getInternalFramesAssociatedWith(LayerManager layerManager) {
        ArrayList<JInternalFrame> internalFramesAssociatedWithLayerManager = new ArrayList<JInternalFrame>();
        JInternalFrame[] internalFrames = this.getInternalFrames();
        for (int i = 0; i < internalFrames.length; ++i) {
            if (!(internalFrames[i] instanceof LayerManagerProxy) || ((LayerManagerProxy)((Object)internalFrames[i])).getLayerManager() != layerManager) continue;
            internalFramesAssociatedWithLayerManager.add(internalFrames[i]);
        }
        return internalFramesAssociatedWithLayerManager;
    }

    private Collection getTaskFramesAssociatedWith(LayerManager layerManager) {
        ArrayList<JInternalFrame> taskFramesAssociatedWithLayerManager = new ArrayList<JInternalFrame>();
        JInternalFrame[] internalFrames = this.getInternalFrames();
        for (int i = 0; i < internalFrames.length; ++i) {
            if (!(internalFrames[i] instanceof TaskFrame) || ((TaskFrame)internalFrames[i]).getLayerManager() != layerManager) continue;
            taskFramesAssociatedWithLayerManager.add(internalFrames[i]);
        }
        return taskFramesAssociatedWithLayerManager;
    }

    private Collection getInternalFramesAssociatedWith(TaskFrame taskFrame) {
        ArrayList<JInternalFrame> internalFramesAssociatedWithTaskFrame = new ArrayList<JInternalFrame>();
        JInternalFrame[] internalFrames = this.getInternalFrames();
        for (int i = 0; i < internalFrames.length; ++i) {
            if (!(internalFrames[i] instanceof TaskFrameProxy) || ((TaskFrameProxy)((Object)internalFrames[i])).getTaskFrame() != taskFrame || internalFrames[i] == taskFrame) continue;
            internalFramesAssociatedWithTaskFrame.add(internalFrames[i]);
        }
        return internalFramesAssociatedWithTaskFrame;
    }

    public TaskFrame addTaskFrame() {
        TaskFrame f = this.addTaskFrame(this.createTask());
        return f;
    }

    public Task createTask() {
        Task task = new Task();
        task.getLayerManager().addCategory(StandardCategoryNames.WORKING);
        task.getLayerManager().addCategory(StandardCategoryNames.SYSTEM);
        task.setName(I18N.get((String)"ui.WorkbenchFrame.task") + " " + this.taskSequence++);
        return task;
    }

    public TaskFrame addTaskFrame(Task task) {
        TaskFrame taskFrame;
        if (this.taskFrameFactory != null) {
            taskFrame = (TaskFrame)this.taskFrameFactory.createComponent();
            taskFrame.setTask(task);
        } else {
            taskFrame = new TaskFrame(task, this.workbenchContext);
        }
        return this.addTaskFrame(taskFrame);
    }

    public TaskFrame addTaskFrame(TaskFrame taskFrame) {
        taskFrame.getTask().getLayerManager().addLayerListener(new LayerListener(){

            public void featuresChanged(FeatureEvent e) {
            }

            public void categoryChanged(CategoryEvent e) {
                WorkbenchFrame.this.toolBar.updateEnabledState();
            }

            public void layerChanged(LayerEvent layerEvent) {
                WorkbenchFrame.this.toolBar.updateEnabledState();
            }
        });
        this.addInternalFrame(taskFrame);
        taskFrame.getLayerViewPanel().getLayerManager().getUndoableEditReceiver().add(new UndoableEditReceiver.Listener(){

            public void undoHistoryChanged() {
                WorkbenchFrame.this.toolBar.updateEnabledState();
            }

            public void undoHistoryTruncated() {
                WorkbenchFrame.this.toolBar.updateEnabledState();
                WorkbenchFrame.this.log(I18N.get((String)"ui.WorkbenchFrame.undo-history-was-truncated"));
            }
        });
        Object[] listeners = this.getTaskListeners().toArray();
        for (int i = 0; i < listeners.length; ++i) {
            TaskListener l = (TaskListener)listeners[i];
            l.taskAdded(new TaskEvent((Object)this, taskFrame.getTask()));
        }
        return taskFrame;
    }

    public void flash(final HTMLFrame frame) {
        final Color originalColor = frame.getBackgroundColor();
        new Timer(100, new ActionListener(){
            private int tickCount = 0;

            public void actionPerformed(ActionEvent e) {
                try {
                    ++this.tickCount;
                    frame.setBackgroundColor(this.tickCount % 2 == 0 ? originalColor : Color.yellow);
                    if (this.tickCount == 2) {
                        Timer timer = (Timer)e.getSource();
                        timer.stop();
                    }
                }
                catch (Throwable t) {
                    WorkbenchFrame.this.handleThrowable(t);
                }
            }
        }).start();
    }

    private void flashStatusMessage(final String message, final Color color) {
        new Timer(100, new ActionListener(){
            private int tickCount = 0;

            public void actionPerformed(ActionEvent e) {
                ++this.tickCount;
                WorkbenchFrame.this.setStatusBarText(message);
                WorkbenchFrame.this.setStatusBarTextHighlighted(this.tickCount % 2 == 0, color);
                if (this.tickCount == 4) {
                    Timer timer = (Timer)e.getSource();
                    timer.stop();
                }
            }
        }).start();
    }

    @Override
    public void handleThrowable(Throwable t) {
        this.log(StringUtil.stackTrace((Throwable)t));
        Window parent = this;
        Window[] ownedWindows = this.getOwnedWindows();
        for (int i = 0; i < ownedWindows.length; ++i) {
            if (!(ownedWindows[i] instanceof Dialog) || !ownedWindows[i].isVisible() || !((Dialog)ownedWindows[i]).isModal()) continue;
            parent = ownedWindows[i];
            break;
        }
        WorkbenchFrame.handleThrowable(t, parent);
    }

    public static void handleThrowable(final Throwable t, final Component parent) {
        t.printStackTrace(System.err);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ErrorDialog.show(parent, StringUtil.toFriendlyName((String)t.getClass().getName()), WorkbenchFrame.toMessage(t), StringUtil.stackTrace((Throwable)t));
            }
        });
    }

    public static String toMessage(Throwable t) {
        String message = t.getLocalizedMessage() == null ? I18N.get((String)"ui.WorkbenchFrame.no-description-was-provided") : (t.getLocalizedMessage().toLowerCase().indexOf(I18N.get((String)"ui.WorkbenchFrame.side-location-conflict")) > -1 ? t.getLocalizedMessage() + " -- " + I18N.get((String)"ui.WorkbenchFrame.check-for-invalid-geometries") : t.getLocalizedMessage());
        return message + " (" + StringUtil.toFriendlyName((String)t.getClass().getName()) + ")";
    }

    public boolean hasInternalFrame(JInternalFrame internalFrame) {
        JInternalFrame[] frames = this.desktopPane.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i] != internalFrame) continue;
            return true;
        }
        return false;
    }

    public void removeInternalFrame(JInternalFrame internalFrame) {
        this.desktopPane.getDesktopManager().closeFrame(internalFrame);
    }

    @Override
    public void warnUser(String warning) {
        this.log(I18N.get((String)"ui.WorkbenchFrame.warning") + ": " + warning);
        this.flashStatusMessage(warning, Color.yellow);
    }

    @Override
    public void zoomChanged(Envelope modelEnvelope) {
        this.toolBar.updateEnabledState();
    }

    void exitMenuItem_actionPerformed(ActionEvent e) {
        this.closeApplication();
    }

    void this_componentShown(ComponentEvent e) {
        try {
            this.toolBar.updateEnabledState();
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
    }

    void this_windowClosing(WindowEvent e) {
        this.closeApplication();
    }

    void windowMenu_menuSelected(MenuEvent e) {
        if (this.addedMenuItems == -1) {
            this.addedMenuItems = this.windowMenu.getItemCount();
        }
        while (this.windowMenu.getItemCount() > this.addedMenuItems) {
            this.windowMenu.remove(this.windowMenu.getItemCount() - 1);
        }
        JInternalFrame[] frames = this.desktopPane.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            JMenuItem menuItem = new JMenuItem();
            menuItem.setText(GUIUtil.truncateString(frames[i].getTitle(), 40));
            this.associate(menuItem, frames[i]);
            this.windowMenu.add(menuItem);
        }
        if (this.windowMenu.getItemCount() == this.addedMenuItems) {
            this.windowMenu.add(new JMenuItem("(" + I18N.get((String)"ui.WorkbenchFrame.no-windows") + ")"));
        }
    }

    private void associate(JMenuItem menuItem, final JInternalFrame frame) {
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    WorkbenchFrame.this.activateFrame(frame);
                }
                catch (Throwable t) {
                    WorkbenchFrame.this.handleThrowable(t);
                }
            }
        });
    }

    private void closeApplication() {
        this.applicationExitHandler.exitApplication(this);
    }

    private Collection getLayersWithModifiedFeatureCollections() {
        ArrayList layersWithModifiedFeatureCollections = new ArrayList();
        for (LayerManager layerManager : this.getLayerManagers()) {
            layersWithModifiedFeatureCollections.addAll(layerManager.getLayersWithModifiedFeatureCollections());
        }
        return layersWithModifiedFeatureCollections;
    }

    private Collection getGeneratedLayers() {
        ArrayList list = new ArrayList();
        for (LayerManager layerManager : this.getLayerManagers()) {
            list.addAll(layerManager.getLayersWithNullDataSource());
        }
        return list;
    }

    private Collection getLayerManagers() {
        HashSet<LayerManager> layerManagers = new HashSet<LayerManager>();
        JInternalFrame[] internalFrames = this.getInternalFrames();
        for (int i = 0; i < internalFrames.length; ++i) {
            if (!(internalFrames[i] instanceof LayerManagerProxy)) continue;
            layerManagers.add(((LayerManagerProxy)((Object)internalFrames[i])).getLayerManager());
        }
        return layerManagers;
    }

    private void configureStatusLabel(JComponent component, int width) {
        component.setMinimumSize(new Dimension(width, (int)component.getMinimumSize().getHeight()));
        component.setMaximumSize(new Dimension(width, (int)component.getMaximumSize().getHeight()));
        component.setPreferredSize(new Dimension(width, (int)component.getPreferredSize().getHeight()));
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(0);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                WorkbenchFrame.this.this_componentShown(e);
            }
        });
        this.getContentPane().setLayout(this.borderLayout1);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                WorkbenchFrame.this.this_windowClosing(e);
            }
        });
        this.setJMenuBar(this.menuBar);
        this.setSize(900, 665);
        this.messageTextField.setOpaque(true);
        this.messageTextField.setEditable(false);
        this.messageTextField.setToolTipText(I18N.get((String)"ui.WorkbenchFrame.copy-to-clipboard"));
        this.messageTextField.setFont(this.coordinateLabel.getFont());
        this.memoryLabel.setText("jLabel1");
        this.wmsLabel.setHorizontalAlignment(2);
        this.wmsLabel.setText(" ");
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkbenchFrame.this.exitMenuItem_actionPerformed(e);
            }
        });
        this.windowMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                WorkbenchFrame.this.windowMenu_menuSelected(e);
            }
        });
        this.coordinateLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.wmsLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.coordinateLabel.setText(" ");
        this.statusPanel.setLayout(this.gridBagLayout1);
        this.statusPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.messageTextField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.messageTextField.setText(" ");
        this.timeLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.timeLabel.setText(" ");
        this.memoryLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.memoryLabel.setText(" ");
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.windowMenu);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.desktopPane, "Center");
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitMenuItem);
        this.statusPanel.add((Component)this.coordinateLabel, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.statusPanel.add((Component)this.timeLabel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.statusPanel.add((Component)this.messageTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.statusPanel.add((Component)this.memoryLabel, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.statusPanel.add((Component)this.wmsLabel, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void position(JInternalFrame internalFrame) {
        int STEP = 5;
        GUIUtil.Location location = null;
        if (internalFrame instanceof PrimaryInfoFrame) {
            ++this.primaryInfoFrameIndex;
            int offset = this.primaryInfoFrameIndex % 3 * 5;
            location = new GUIUtil.Location(offset, true, offset, true);
        } else {
            ++this.positionIndex;
            int offset = this.positionIndex % 5 * 5;
            location = new GUIUtil.Location(offset, false, offset, false);
        }
        GUIUtil.setLocation(internalFrame, location, this.desktopPane);
    }

    public Set getChoosableStyleClasses() {
        return Collections.unmodifiableSet(this.choosableStyleClasses);
    }

    public void addChoosableStyleClass(Class choosableStyleClass) {
        Assert.isTrue((boolean)ChoosableStyle.class.isAssignableFrom(choosableStyleClass));
        this.choosableStyleClasses.add(choosableStyleClass);
    }

    public void addKeyboardShortcut(int keyCode, int modifiers, PlugIn plugIn, EnableCheck enableCheck) {
        this.keyCodeAndModifiersToPlugInAndEnableCheckMap.put(keyCode + ":" + modifiers, new Object[]{plugIn, enableCheck});
    }

    private void installKeyboardShortcutListener() {
        this.addEasyKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                Object[] plugInAndEnableCheck = (Object[])WorkbenchFrame.this.keyCodeAndModifiersToPlugInAndEnableCheckMap.get(e.getKeyCode() + ":" + e.getModifiers());
                if (plugInAndEnableCheck == null) {
                    return;
                }
                PlugIn plugIn = (PlugIn)plugInAndEnableCheck[0];
                EnableCheck enableCheck = (EnableCheck)plugInAndEnableCheck[1];
                if (enableCheck != null && enableCheck.check(null) != null) {
                    return;
                }
                AbstractPlugIn.toActionListener(plugIn, WorkbenchFrame.this.workbenchContext, new TaskMonitorManager()).actionPerformed(null);
            }
        });
    }

    public InternalFrameCloseHandler getInternalFrameCloseHandler() {
        return this.internalFrameCloseHandler;
    }

    public void setInternalFrameCloseHandler(InternalFrameCloseHandler value) {
        this.internalFrameCloseHandler = value;
    }

    public ApplicationExitHandler getApplicationExitHandler() {
        return this.applicationExitHandler;
    }

    public void setApplicationExitHandler(ApplicationExitHandler value) {
        this.applicationExitHandler = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void closeTaskFrame(TaskFrame taskFrame) {
        boolean lastTaskFrame;
        LayerManager layerManager = taskFrame.getLayerManager();
        Collection associatedFrames = this.getInternalFramesAssociatedWith(taskFrame);
        boolean bl = lastTaskFrame = this.getTaskFramesAssociatedWith(layerManager).size() == 1;
        if (lastTaskFrame) {
            Collection modifiedItems = layerManager.getLayersWithModifiedFeatureCollections();
            LinkedList generatedItems = layerManager.getLayersWithNullDataSource();
            if (!this.confirmClose(I18N.get((String)"ui.WorkbenchFrame.close-task"), modifiedItems, generatedItems)) return;
            if (associatedFrames.size() != 0) {
                if (!this.confirmClose(StringUtil.split((String)(I18N.get((String)"ui.WorkbenchFrame.other-internal-frames-depend-on-this-task-frame") + " " + I18N.get((String)"ui.WorkbenchFrame.do-you-want-to-close-them-also")), (int)60), I18N.get((String)"ui.WorkbenchFrame.close-all"))) return;
                Iterator it = associatedFrames.iterator();
                while (it.hasNext()) {
                    GUIUtil.dispose((JInternalFrame)it.next(), this.desktopPane);
                }
            }
            layerManager.dispose();
            taskFrame.getLayerViewPanel().dispose();
            taskFrame.getLayerNamePanel().dispose();
            GUIUtil.dispose(taskFrame, this.desktopPane);
            return;
        } else {
            if (associatedFrames.size() != 0) {
                if (!this.confirmClose(StringUtil.split((String)(I18N.get((String)"ui.WorkbenchFrame.other-internal-frames-depend-on-this-task-frame") + " " + I18N.get((String)"ui.WorkbenchFrame.do-you-want-to-close-them-also")), (int)60), I18N.get((String)"ui.WorkbenchFrame.close-all"))) return;
                Iterator it = associatedFrames.iterator();
                while (it.hasNext()) {
                    GUIUtil.dispose((JInternalFrame)it.next(), this.desktopPane);
                }
            }
            taskFrame.getLayerViewPanel().dispose();
            taskFrame.getLayerNamePanel().dispose();
            GUIUtil.dispose(taskFrame, this.desktopPane);
        }
    }

    private boolean confirmClose(String action, Collection modifiedLayers, Collection generatedLayers) {
        if (modifiedLayers.isEmpty()) {
            if (generatedLayers.isEmpty()) {
                return true;
            }
            JOptionPane pane = new JOptionPane(I18N.getMessage((String)"ui.WorkbenchFrame.do-you-really-want-to-close-openjump-generated-layers-not-saved", (Object[])new Object[]{generatedLayers.size()}), 3);
            pane.setOptions(new String[]{action, I18N.get((String)"ui.WorkbenchFrame.cancel")});
            pane.createDialog(this, "JUMP").setVisible(true);
            return pane.getValue().equals(action);
        }
        JOptionPane pane = new JOptionPane(StringUtil.split((String)(modifiedLayers.size() + " " + I18N.get((String)"ui.WorkbenchFrame.dataset") + StringUtil.s((int)modifiedLayers.size()) + " " + (modifiedLayers.size() > 1 ? I18N.get((String)"ui.WorkbenchFrame.have-been-modified") : I18N.get((String)"ui.WorkbenchFrame.has-been-modified")) + " (" + (modifiedLayers.size() > 3 ? "e.g. " : "") + StringUtil.toCommaDelimitedString(new ArrayList(modifiedLayers).subList(0, Math.min(3, modifiedLayers.size()))) + "). " + I18N.get((String)"ui.WorkbenchFrame.continue") + "?"), (int)80), 2);
        pane.setOptions(new String[]{action, I18N.get((String)"ui.WorkbenchFrame.cancel")});
        pane.createDialog(this, "JUMP").setVisible(true);
        return pane.getValue().equals(action);
    }

    private boolean confirmClose(String question, String action) {
        JOptionPane pane = new JOptionPane(question, 2);
        pane.setOptions(new String[]{action, I18N.get((String)"ui.WorkbenchFrame.cancel")});
        pane.createDialog(this, "JUMP").setVisible(true);
        return pane.getValue().equals(action);
    }

    public void setTaskFrameFactory(ComponentFactory<TaskFrame> taskFrameFactory) {
        this.taskFrameFactory = taskFrameFactory;
    }

    public void saveWindowState() {
        boolean maximized = this.getExtendedState() == 6;
        Blackboard blackboard = PersistentBlackboardPlugIn.get(this.workbenchContext);
        blackboard.put(MAXIMIZED_KEY, maximized);
        Point p = this.getLocation(null);
        blackboard.put(HORIZONTAL_KEY, p.x);
        blackboard.put(VERTICAL_KEY, p.y);
        Dimension d = this.getSize();
        blackboard.put(WIDTH_KEY, d.width);
        blackboard.put(HEIGHT_KEY, d.height);
    }

    public boolean recallMaximizedState() {
        Blackboard blackboard = PersistentBlackboardPlugIn.get(this.workbenchContext);
        boolean maximized = false;
        if (blackboard.get(MAXIMIZED_KEY) == null) {
            blackboard.put(MAXIMIZED_KEY, maximized);
        }
        maximized = (Boolean)blackboard.get(MAXIMIZED_KEY);
        return maximized;
    }

    public Point recallWindowLocation() {
        Blackboard blackboard = PersistentBlackboardPlugIn.get(this.workbenchContext);
        Point p = new Point(0, 0);
        if (blackboard.get(HORIZONTAL_KEY) == null) {
            blackboard.put(HORIZONTAL_KEY, p.x);
            blackboard.put(VERTICAL_KEY, p.y);
        }
        p.x = (Integer)blackboard.get(HORIZONTAL_KEY);
        p.y = (Integer)blackboard.get(VERTICAL_KEY);
        return p;
    }

    public Dimension recallWindowSize() {
        Blackboard blackboard = PersistentBlackboardPlugIn.get(this.workbenchContext);
        Dimension d = new Dimension(900, 665);
        if (blackboard.get(WIDTH_KEY) == null) {
            blackboard.put(WIDTH_KEY, d.width);
            blackboard.put(HEIGHT_KEY, d.height);
        }
        d.width = (Integer)blackboard.get(WIDTH_KEY);
        d.height = (Integer)blackboard.get(HEIGHT_KEY);
        return d;
    }

    public ArrayList<TaskListener> getTaskListeners() {
        return this.taskListeners;
    }

    public void addTaskListener(TaskListener l) {
        this.getTaskListeners().add(l);
    }

    public void removeTaskListener(TaskListener l) {
        this.getTaskListeners().remove(l);
    }

    private class DefaultApplicationExitHandler
    implements ApplicationExitHandler {
        private DefaultApplicationExitHandler() {
        }

        public void exitApplication(JFrame mainFrame) {
            if (WorkbenchFrame.this.confirmClose(I18N.get((String)"ui.WorkbenchFrame.exit-jump"), WorkbenchFrame.this.getLayersWithModifiedFeatureCollections(), WorkbenchFrame.this.getGeneratedLayers())) {
                WorkbenchFrame.this.saveWindowState();
                WorkbenchFrame.this.setVisible(false);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        System.exit(0);
                    }
                });
            }
        }
    }

    private class DefaultInternalFrameCloser
    implements InternalFrameCloseHandler {
        private DefaultInternalFrameCloser() {
        }

        public void close(JInternalFrame internalFrame) {
            if (internalFrame instanceof TaskFrame) {
                WorkbenchFrame.this.closeTaskFrame((TaskFrame)internalFrame);
            } else {
                GUIUtil.dispose(internalFrame, WorkbenchFrame.this.desktopPane);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    System.runFinalization();
                    System.gc();
                }
            });
        }
    }
}

