/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.ColumnBasedTableModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;

public class LayerTableModel
extends ColumnBasedTableModel {
    private Layer layer;
    private ArrayList features = new ArrayList();
    private String sortedColumnName = null;
    private boolean sortAscending = false;
    private ColumnBasedTableModel.Column fidColumn = new MyColumn("FID", Integer.class){

        protected Object getValue(Feature feature) {
            return new Integer(feature.getID());
        }

        protected void setValue(Object value, Feature feature) {
            Assert.shouldNeverReachHere();
        }
    };
    private ColumnBasedTableModel.Column geomButtonColumn = new MyColumn(" ", null){

        protected Object getValue(Feature feature) {
            return feature;
        }

        protected void setValue(Object value, Feature feature) {
            Assert.shouldNeverReachHere();
        }
    };
    private FeatureSchema schema;
    private LayerListener layerListener = new LayerListener(){

        public void categoryChanged(CategoryEvent e) {
        }

        public void featuresChanged(FeatureEvent e) {
            if (e.getLayer() != LayerTableModel.this.getLayer()) {
                return;
            }
            if (e.getType() == FeatureEventType.DELETED) {
                LayerTableModel.this.removeAll(e.getFeatures());
            }
            if (e.getType() == FeatureEventType.ATTRIBUTES_MODIFIED) {
                for (Feature feature : e.getFeatures()) {
                    int row = LayerTableModel.this.getFeatures().indexOf(feature);
                    if (row == -1) continue;
                    LayerTableModel.this.fireTableChanged(new TableModelEvent(LayerTableModel.this, row, row));
                }
            }
        }

        public void layerChanged(LayerEvent e) {
            if (e.getLayerable() != LayerTableModel.this.getLayer()) {
                return;
            }
            if (e.getType() == LayerEventType.METADATA_CHANGED && !LayerTableModel.this.schema.equals((Object)LayerTableModel.this.layer.getFeatureCollectionWrapper().getFeatureSchema(), true)) {
                LayerTableModel.this.initColumns(LayerTableModel.this.layer);
                LayerTableModel.this.fireTableChanged(new TableModelEvent(LayerTableModel.this, -1));
            }
        }
    };

    public LayerTableModel(Layer layer) {
        this.layer = layer;
        layer.getLayerManager().addLayerListener(this.layerListener);
        this.initColumns(layer);
    }

    private void initColumns(final Layer layer) {
        this.schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        ArrayList<ColumnBasedTableModel.Column> columns = new ArrayList<ColumnBasedTableModel.Column>();
        columns.add(this.geomButtonColumn);
        columns.add(this.fidColumn);
        for (int i = 0; i < this.schema.getAttributeCount(); ++i) {
            if (this.schema.getAttributeType(i) == AttributeType.GEOMETRY) continue;
            final int j = i;
            columns.add(new MyColumn(this.schema.getAttributeName(i), this.schema.getAttributeType(i).toJavaClass()){

                protected Object getValue(Feature feature) {
                    Object value = null;
                    try {
                        value = feature.getAttribute(j);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        ex.printStackTrace();
                    }
                    return value;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void setValue(Object value, final Feature feature) {
                    final Feature oldAttributes = (Feature)feature.clone();
                    final Feature newAttributes = (Feature)feature.clone();
                    newAttributes.setAttribute(j, value);
                    layer.getLayerManager().getUndoableEditReceiver().startReceiving();
                    try {
                        UndoableCommand command = new UndoableCommand(I18N.get((String)"ui.plugin.LayerTableModel.edit") + " " + LayerTableModel.this.schema.getAttributeName(j)){

                            public void execute() {
                                LayerTableModel.this.setAttributesOf(feature, newAttributes);
                            }

                            public void unexecute() {
                                LayerTableModel.this.setAttributesOf(feature, oldAttributes);
                            }
                        };
                        command.execute();
                        layer.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
                    }
                    finally {
                        layer.getLayerManager().getUndoableEditReceiver().stopReceiving();
                    }
                }
            });
        }
        this.setColumns(columns);
    }

    private void setAttributesOf(Feature feature, Feature attributes) {
        Feature oldClone = (Feature)feature.clone();
        for (int i = 0; i < feature.getSchema().getAttributeCount(); ++i) {
            feature.setAttribute(i, attributes.getAttribute(i));
        }
        this.layer.getLayerManager().fireFeaturesAttChanged(Arrays.asList(feature), FeatureEventType.ATTRIBUTES_MODIFIED, this.layer, Arrays.asList(oldClone));
    }

    public Layer getLayer() {
        return this.layer;
    }

    public Feature getFeature(int row) {
        return (Feature)this.features.get(row);
    }

    public int getRowCount() {
        return this.features.size();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.layer.isEditable()) {
            return false;
        }
        if (this.getColumn(columnIndex) == this.fidColumn) {
            return false;
        }
        if (this.getColumn(columnIndex) == this.geomButtonColumn) {
            return false;
        }
        FeatureSchema schema = this.layer.getFeatureCollectionWrapper().getFeatureSchema();
        return !schema.isAttributeReadOnly(schema.getAttributeIndex(this.getColumn(columnIndex).getName()));
    }

    public void clear() {
        this.features.clear();
        this.fireTableChanged(new TableModelEvent(this));
    }

    private void removeAll(Collection featuresToRemove) {
        ArrayList<Integer> idsToRemove = new ArrayList<Integer>();
        Iterator it = featuresToRemove.iterator();
        while (it.hasNext()) {
            idsToRemove.add(((Feature)it.next()).getID());
        }
        Collections.sort(idsToRemove);
        ArrayList<Feature> newFeatures = new ArrayList<Feature>();
        for (Feature f : this.features) {
            if (Collections.binarySearch(idsToRemove, f.getID()) >= 0) continue;
            newFeatures.add(f);
        }
        this.features = newFeatures;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void addAll(Collection newFeatures) {
        int originalFeaturesSize = this.features.size();
        ArrayList newFeaturesOnly = new ArrayList(newFeatures);
        newFeaturesOnly.removeAll(this.features);
        this.features.addAll(newFeaturesOnly);
        if (this.sortedColumnName != null) {
            this.sort(this.sortedColumnName, this.sortAscending);
        }
        this.fireTableChanged(new TableModelEvent(this, originalFeaturesSize, this.features.size() - 1, -1, 1));
    }

    public void dispose() {
        this.layer.getLayerManager().removeLayerListener(this.layerListener);
        this.features.clear();
    }

    public List getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public String getSortedColumnName() {
        return this.sortedColumnName;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void sort(String columnName) {
        this.sort(columnName, columnName.equals(this.sortedColumnName) ? !this.sortAscending : true);
    }

    public void sort(String columnName, final boolean ascending) {
        this.sortAscending = ascending;
        this.sortedColumnName = columnName;
        final int column = this.indexOfColumn(columnName);
        Collections.sort(this.features, new Comparator(){

            public int compare(Object o1, Object o2) {
                return this.ascendingCompare(o1, o2) * (ascending ? 1 : -1);
            }

            private int ascendingCompare(Object o1, Object o2) {
                Feature f1 = (Feature)o1;
                Feature f2 = (Feature)o2;
                Object v1 = ((MyColumn)LayerTableModel.this.getColumn(column)).getValue(f1);
                Object v2 = ((MyColumn)LayerTableModel.this.getColumn(column)).getValue(f2);
                return LayerTableModel.compareValue(v1, v2);
            }
        });
    }

    private static int compareValue(Object o1, Object o2) {
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Boolean) {
            return LayerTableModel.compareBoolean((Boolean)o1, (Boolean)o2);
        }
        if (o1 instanceof Geometry) {
            return 0;
        }
        if (o1 instanceof Comparable) {
            Comparable attribute1 = (Comparable)o1;
            Comparable attribute2 = (Comparable)o2;
            return attribute1.compareTo(attribute2);
        }
        return 0;
    }

    private static int compareBoolean(Boolean b1, Boolean b2) {
        boolean bool2;
        boolean bool1 = b1;
        if (bool1 == (bool2 = b2.booleanValue())) {
            return 0;
        }
        return bool1 ? 1 : -1;
    }

    public String getType(int column) {
        return null;
    }

    public static void main(String[] args) {
        System.out.println(new JTable().getDefaultEditor(Date.class));
    }

    private abstract class MyColumn
    extends ColumnBasedTableModel.Column {
        public MyColumn(String name, Class dataClass) {
            super(name, dataClass);
        }

        public Object getValueAt(int rowIndex) {
            return this.getValue(LayerTableModel.this.getFeature(rowIndex));
        }

        public void setValueAt(Object value, int rowIndex) {
            this.setValue(value, LayerTableModel.this.getFeature(rowIndex));
        }

        protected abstract Object getValue(Feature var1);

        protected abstract void setValue(Object var1, Feature var2);
    }
}

