/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.plugin;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.plugin.ViewAttributesPlugIn;
import com.vividsolutions.jump.workbench.ui.warp.WarpingVectorLayerFinder;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;

public class EnableCheckFactory {
    WorkbenchContext workbenchContext;

    public EnableCheckFactory(WorkbenchContext workbenchContext) {
        Assert.isTrue((workbenchContext != null ? 1 : 0) != 0);
        this.workbenchContext = workbenchContext;
    }

    public EnableCheck createTaskWindowMustBeActiveCheck() {
        return new EnableCheck(){

            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof TaskFrame) ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.A-Task-Window-must-be-active") : null;
            }
        };
    }

    public EnableCheck createWindowWithSelectionManagerMustBeActiveCheck() {
        return new EnableCheck(){

            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof SelectionManagerProxy) ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.A-window-with-a-selection-manager-must-be-active") : null;
            }
        };
    }

    public EnableCheck createWindowWithLayerManagerMustBeActiveCheck() {
        return new EnableCheck(){

            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof LayerManagerProxy) ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.A-window-with-a-layer-manager-must-be-active") : null;
            }
        };
    }

    public EnableCheck createWindowWithAssociatedTaskFrameMustBeActiveCheck() {
        return new EnableCheck(){

            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof TaskFrameProxy) ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.A-window-with-an-associated-task-frame-must-be-active") : null;
            }
        };
    }

    public EnableCheck createWindowWithLayerNamePanelMustBeActiveCheck() {
        return new EnableCheck(){

            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof LayerNamePanelProxy) ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.A-window-with-a-layer-name-panel-must-be-active") : null;
            }
        };
    }

    public EnableCheck createWindowWithLayerViewPanelMustBeActiveCheck() {
        return new EnableCheck(){

            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof LayerViewPanelProxy) ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.A-window-with-a-layer-view-panel-must-be-active") : null;
            }
        };
    }

    public EnableCheck createOnlyOneLayerMayHaveSelectedFeaturesCheck() {
        return new EnableCheck(){

            public String check(JComponent component) {
                Collection layersWithSelectedFeatures = ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeatureSelection().getLayersWithSelectedItems();
                return layersWithSelectedFeatures.size() > 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.Only-one-layer-may-have-selected-features") : null;
            }
        };
    }

    public EnableCheck createOnlyOneLayerMayHaveSelectedItemsCheck() {
        return new EnableCheck(){

            public String check(JComponent component) {
                Collection layersWithSelectedItems = ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getLayersWithSelectedItems();
                return layersWithSelectedItems.size() > 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.Only-one-layer-may-have-selected-items") : null;
            }
        };
    }

    public EnableCheck createSelectedItemsLayersMustBeEditableCheck() {
        return new EnableCheck(){

            public String check(JComponent component) {
                for (Layer layer : ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getLayersWithSelectedItems()) {
                    if (layer.isEditable()) continue;
                    return I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.Selected-items-layers-must-be-editable", (Object[])new String[]{layer.getName()});
                }
                return null;
            }
        };
    }

    public EnableCheck createExactlyNCategoriesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            public String check(JComponent component) {
                String msg = n == 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.Exactly-one-category-must-be-selected") : I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.Exactly-n-categories-must-be-selected", (Object[])new Object[]{n});
                return n != EnableCheckFactory.this.workbenchContext.getLayerNamePanel().getSelectedCategories().size() ? msg : null;
            }
        };
    }

    public EnableCheck createExactlyNLayerablesMustBeSelectedCheck(final int n, final Class layerableClass) {
        return new EnableCheck(){

            public String check(JComponent component) {
                String msg = n == 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.Exactly-one-layer-must-be-selected") : I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.Exactly-n-layers-must-be-selected", (Object[])new Object[]{n});
                return n != EnableCheckFactory.this.workbenchContext.getLayerNamePanel().selectedNodes(layerableClass).size() ? msg : null;
            }
        };
    }

    public EnableCheck createExactlyNLayersMustBeSelectedCheck(int n) {
        return this.createExactlyNLayerablesMustBeSelectedCheck(n, Layer.class);
    }

    public EnableCheck createAtLeastNCategoriesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            public String check(JComponent component) {
                String msg = n == 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.At-least-one-category-must-be-selected") : I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.At-least-n-categories-must-be-selected", (Object[])new Object[]{n});
                return n > EnableCheckFactory.this.workbenchContext.getLayerNamePanel().getSelectedCategories().size() ? msg : null;
            }
        };
    }

    public EnableCheck createAtLeastNLayerablesMustBeSelectedCheck(final int n, final Class layerableClass) {
        return new EnableCheck(){

            public String check(JComponent component) {
                LayerNamePanel layerNamePanel = EnableCheckFactory.this.workbenchContext.getLayerNamePanel();
                String msg = n == 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.At-least-one-layer-must-be-selected") : I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.At-least-n-layers-must-be-selected", (Object[])new Object[]{n});
                return layerNamePanel == null || n > EnableCheckFactory.this.workbenchContext.getLayerNamePanel().selectedNodes(layerableClass).size() ? msg : null;
            }
        };
    }

    public EnableCheck createAtLeastNLayersMustBeSelectedCheck(int n) {
        return this.createAtLeastNLayerablesMustBeSelectedCheck(n, Layer.class);
    }

    public EnableCheck createAtLeastNLayersMustBeEditableCheck(final int n) {
        return new EnableCheck(){

            public String check(JComponent component) {
                String msg = n == 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.At-least-one-layer-must-be-editable") : I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.At-least-n-layers-must-be-editable", (Object[])new Object[]{n});
                return n > EnableCheckFactory.this.workbenchContext.getLayerManager().getEditableLayers().size() ? msg : null;
            }
        };
    }

    public EnableCheck createExactlyOneSelectedLayerMustBeEditableCheck() {
        return new EnableCheck(){

            public String check(JComponent component) {
                String msg = I18N.get((String)"com.vividsolutions.jump.workbench.plugin.Exactly-one-selected-layer-must-be-editable");
                Layer[] layers = EnableCheckFactory.this.workbenchContext.getLayerNamePanel().getSelectedLayers();
                int countSelectedEditable = 0;
                for (int i = 0; i < layers.length; ++i) {
                    if (!layers[i].isEditable()) continue;
                    ++countSelectedEditable;
                }
                return 1 != countSelectedEditable ? msg : null;
            }
        };
    }

    public EnableCheck createAtLeastNLayersMustExistCheck(final int n) {
        return new EnableCheck(){

            public String check(JComponent component) {
                LayerManager layerManager = EnableCheckFactory.this.workbenchContext.getLayerManager();
                String msg = n == 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.At-least-one-layer-must-exist") : I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.At-least-n-layers-must-exist", (Object[])new Object[]{n});
                return layerManager == null || n > layerManager.size() ? msg : null;
            }
        };
    }

    public EnableCheck createAtMostNLayersMustExistCheck(final int n) {
        return new EnableCheck(){

            public String check(JComponent component) {
                String msg = n == 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.At-most-one-layer-must-exist") : I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.At-most-n-layers-must-exist", (Object[])new Object[]{n});
                return n < EnableCheckFactory.this.workbenchContext.getLayerManager().size() ? msg : null;
            }
        };
    }

    public EnableCheck createExactlyNVectorsMustBeDrawnCheck(final int n) {
        return new EnableCheck(){

            public String check(JComponent component) {
                String msg = n == 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.Exactly-one-vector-must-be-drawn") : I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.Exactly-n-vectors-must-be-drawn", (Object[])new Object[]{n});
                return n != EnableCheckFactory.this.vectorCount() ? msg : null;
            }
        };
    }

    public EnableCheck createAtLeastNVectorsMustBeDrawnCheck(final int n) {
        return new EnableCheck(){

            public String check(JComponent component) {
                String msg = n == 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.At-least-one-vector-must-be-drawn") : I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.At-least-n-vectors-must-be-drawn", (Object[])new Object[]{n});
                return n > EnableCheckFactory.this.vectorCount() ? msg : null;
            }
        };
    }

    public EnableCheck createAtLeastNFeaturesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            public String check(JComponent component) {
                String msg = n == 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.At-least-one-feature-must-be-selected") : I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.At-least-n-features-must-be-selected", (Object[])new Object[]{n});
                return n > ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeaturesWithSelectedItemsCount() ? msg : null;
            }
        };
    }

    public EnableCheck createAtLeastNItemsMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            public String check(JComponent component) {
                JInternalFrame iFrame = EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame();
                int selected = 0;
                try {
                    selected = ((SelectionManagerProxy)((Object)iFrame)).getSelectionManager().getSelectedItemsCount();
                    if (iFrame instanceof ViewAttributesPlugIn.ViewAttributesFrame) {
                        selected = ((SelectionManagerProxy)((Object)iFrame)).getSelectionManager().getSelectedItems().size();
                    }
                }
                catch (Exception e) {
                    System.out.println("eat exception @ EnableCheckFactory.createAtLeastNItemsMustBeSelectedCheck(i) if a non taskframe(or child) is selected");
                }
                String retVal = null;
                String msg = n == 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.At-least-one-item-must-be-selected") : I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.At-least-n-items-must-be-selected", (Object[])new Object[]{n});
                retVal = iFrame == null || n > selected ? msg : null;
                return retVal;
            }
        };
    }

    public EnableCheck createExactlyNFeaturesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            public String check(JComponent component) {
                String msg = n == 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.Exactly-one-feature-must-be-selected") : I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.Exactly-n-features-must-be-selected", (Object[])new Object[]{n});
                return n != ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeaturesWithSelectedItemsCount() ? msg : null;
            }
        };
    }

    public EnableCheck createExactlyNItemsMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            public String check(JComponent component) {
                String msg = n == 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.Exactly-one-item-must-be-selected") : I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.Exactly-n-items-must-be-selected", (Object[])new Object[]{n});
                return n != ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getSelectedItemsCount() ? msg : null;
            }
        };
    }

    public EnableCheck createExactlyNLayersMustHaveSelectedItemsCheck(final int n) {
        return new EnableCheck(){

            public String check(JComponent component) {
                String msg = n == 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.Exactly-one-layer-must-have-selected-items") : I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.Exactly-n-layers-must-have-selected-items", (Object[])new Object[]{n});
                return n != ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getLayersWithSelectedItems().size() ? msg : null;
            }
        };
    }

    public EnableCheck createExactlyNFeaturesMustHaveSelectedItemsCheck(final int n) {
        return new EnableCheck(){

            public String check(JComponent component) {
                String msg = n == 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.Exactly-one-feature-must-have-selected-items") : I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.Exactly-n-features-must-have-selected-items", (Object[])new Object[]{n});
                return n != ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeaturesWithSelectedItemsCount() ? msg : null;
            }
        };
    }

    public EnableCheck createSelectedLayersMustBeEditableCheck() {
        return new EnableCheck(){

            public String check(JComponent component) {
                for (Layer layer : Arrays.asList(EnableCheckFactory.this.workbenchContext.getLayerNamePanel().getSelectedLayers())) {
                    if (layer.isEditable()) continue;
                    return I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.Selected-layers-must-be-editable", (Object[])new String[]{layer.getName()});
                }
                return null;
            }
        };
    }

    public EnableCheck createFenceMustBeDrawnCheck() {
        return new EnableCheck(){

            public String check(JComponent component) {
                LayerViewPanel layerViewPanel = EnableCheckFactory.this.workbenchContext.getLayerViewPanel();
                return layerViewPanel == null || null == layerViewPanel.getFence() ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.A-fence-must-be-drawn") : null;
            }
        };
    }

    public EnableCheck createBetweenNAndMVectorsMustBeDrawnCheck(final int min, final int max) {
        return new EnableCheck(){

            public String check(JComponent component) {
                return EnableCheckFactory.this.vectorCount() > max || EnableCheckFactory.this.vectorCount() < min ? I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.Between-and-vectors-must-be-drawn", (Object[])new Object[]{min, max}) : null;
            }
        };
    }

    int vectorCount() {
        return new WarpingVectorLayerFinder(this.workbenchContext).getVectors().size();
    }

    public EnableCheck createAtLeastNFeaturesMustHaveSelectedItemsCheck(final int n) {
        return new EnableCheck(){

            public String check(JComponent component) {
                String msg = n == 1 ? I18N.get((String)"com.vividsolutions.jump.workbench.plugin.At-least-one-feature-must-have-selected-items") : I18N.getMessage((String)"com.vividsolutions.jump.workbench.plugin.At-least-n-features-must-have-selected-items", (Object[])new Object[]{n});
                return n > ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeaturesWithSelectedItemsCount() ? msg : null;
            }
        };
    }
}

