/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.geotiff;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public abstract class GeoReferencedRaster {
    protected String imageFileLocation;
    protected RenderedOp src = null;
    Envelope envModel_image;
    double[] min;
    double[] max;
    Coordinate coorRasterTiff_tiepointLT;
    Coordinate coorModel_tiepointLT;
    private double dblModelUnitsPerRasterUnit_X;
    private double dblModelUnitsPerRasterUnit_Y;

    public GeoReferencedRaster(String imageFileLocation) throws Exception {
        this.imageFileLocation = imageFileLocation;
    }

    protected void fetchRaster() throws Exception {
        this.src = JAI.create((String)"fileload", (Object)this.imageFileLocation);
    }

    protected void readRasterfile() throws Exception {
        this.fetchRaster();
        this.normalize(this.src);
    }

    private Coordinate rasterToModelSpace(Coordinate coorRaster) {
        Coordinate coorModel = new Coordinate();
        coorModel.x = this.coorModel_tiepointLT.x + (coorRaster.x - this.coorRasterTiff_tiepointLT.x) * this.dblModelUnitsPerRasterUnit_X;
        coorModel.y = this.coorModel_tiepointLT.y - (coorRaster.y + this.coorRasterTiff_tiepointLT.y) * this.dblModelUnitsPerRasterUnit_Y;
        coorModel.z = 0.0;
        return coorModel;
    }

    protected void normalize(RenderedOp image) {
    }

    public Coordinate getCoorModel_tiepointLT() {
        return this.coorModel_tiepointLT;
    }

    public Coordinate getCoorRasterTiff_tiepointLT() {
        return this.coorRasterTiff_tiepointLT;
    }

    public double getDblModelUnitsPerRasterUnit_X() {
        return this.dblModelUnitsPerRasterUnit_X;
    }

    public double getDblModelUnitsPerRasterUnit_Y() {
        return this.dblModelUnitsPerRasterUnit_Y;
    }

    public RenderedOp getImage() throws Exception {
        if (this.src == null) {
            this.readRasterfile();
        }
        return this.src;
    }

    void setEnvelope() {
        Coordinate coorRaster_imageLB = new Coordinate(this.coorRasterTiff_tiepointLT.x, (double)(this.src.getHeight() - 1), 0.0);
        Coordinate coorRaster_imageRT = new Coordinate((double)(this.src.getWidth() - 1), 0.0, 0.0);
        Coordinate coorModel_imageLB = this.rasterToModelSpace(coorRaster_imageLB);
        Coordinate coorModel_imageRT = this.rasterToModelSpace(coorRaster_imageRT);
        this.envModel_image = new Envelope(coorModel_imageLB, coorModel_imageRT);
    }

    public void setCoorModel_tiepointLT(Coordinate coordinate) {
        this.coorModel_tiepointLT = coordinate;
        this.setEnvelope();
    }

    public void setCoorRasterTiff_tiepointLT(Coordinate coordinate) {
        this.coorRasterTiff_tiepointLT = coordinate;
    }

    public void setDblModelUnitsPerRasterUnit_X(double d) {
        this.dblModelUnitsPerRasterUnit_X = d;
    }

    public void setDblModelUnitsPerRasterUnit_Y(double d) {
        this.dblModelUnitsPerRasterUnit_Y = d;
        this.setEnvelope();
    }

    public void setAffineTransformation(AffineTransform transform) {
        double scaleX = Math.abs(transform.getScaleX());
        double scaleY = Math.abs(transform.getScaleY());
        this.setDblModelUnitsPerRasterUnit_X(scaleX);
        this.setDblModelUnitsPerRasterUnit_Y(scaleY);
        Point2D.Double rasterLT = new Point2D.Double(this.src.getMinX(), this.src.getMinY());
        Point2D.Double modelLT = new Point2D.Double();
        transform.transform(rasterLT, modelLT);
        this.setCoorRasterTiff_tiepointLT(new Coordinate(((Point2D)rasterLT).getX(), ((Point2D)rasterLT).getY()));
        this.setCoorModel_tiepointLT(new Coordinate(((Point2D)modelLT).getX(), ((Point2D)modelLT).getY()));
    }

    public RenderedOp fullContrast() {
        int bands = this.src.getNumBands();
        double[] constants = new double[bands];
        double[] offsets = new double[bands];
        for (int i = 0; i < bands; ++i) {
            constants[i] = 306.0 / (this.max[i] - this.min[i]);
            offsets[i] = 255.0 * this.min[i] / (this.min[i] - this.max[i]);
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(this.src);
        pb.add(constants);
        pb.add(offsets);
        return JAI.create((String)"rescale", (ParameterBlock)pb, null);
    }

    public Envelope getEnvelope() {
        return this.envModel_image;
    }

    public double[] getMinimumExtreme() {
        return this.min;
    }

    public double[] getMaximumExtreme() {
        return this.max;
    }
}

