/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datasource;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.FMEGMLReader;
import com.vividsolutions.jump.io.FMEGMLWriter;
import com.vividsolutions.jump.io.JMLReader;
import com.vividsolutions.jump.io.JMLWriter;
import com.vividsolutions.jump.io.JUMPReader;
import com.vividsolutions.jump.io.JUMPWriter;
import com.vividsolutions.jump.io.ShapefileReader;
import com.vividsolutions.jump.io.ShapefileWriter;
import com.vividsolutions.jump.io.WKTReader;
import com.vividsolutions.jump.io.WKTWriter;
import com.vividsolutions.jump.io.datasource.StandardReaderWriterFileDataSource;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooserManager;
import com.vividsolutions.jump.workbench.datasource.GMLDataSourceQueryChooserInstaller;
import com.vividsolutions.jump.workbench.datasource.LoadFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.datasource.SaveFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.Component;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.openjump.core.ui.DatasetOptionsPanel;
import org.openjump.core.ui.swing.ComboBoxComponentPanel;
import org.openjump.core.ui.swing.factory.field.ComboBoxFieldComponentFactory;

public class InstallStandardDataSourceQueryChoosersPlugIn
extends AbstractPlugIn {
    private void addFileDataSourceQueryChoosers(JUMPReader reader, JUMPWriter writer, final String description, final WorkbenchContext context, Class readerWriterDataSourceClass) {
        DataSourceQueryChooserManager chooserManager = DataSourceQueryChooserManager.get(context.getBlackboard());
        chooserManager.addLoadDataSourceQueryChooser(new LoadFileDataSourceQueryChooser(readerWriterDataSourceClass, description, InstallStandardDataSourceQueryChoosersPlugIn.extensions(readerWriterDataSourceClass), context){

            protected void addFileFilters(JFileChooser chooser) {
                super.addFileFilters(chooser);
                InstallStandardDataSourceQueryChoosersPlugIn.addCompressedFileFilter(description, chooser);
            }
        });
        if (readerWriterDataSourceClass != StandardReaderWriterFileDataSource.Shapefile.class) {
            chooserManager.addSaveDataSourceQueryChooser(new SaveFileDataSourceQueryChooser(readerWriterDataSourceClass, description, InstallStandardDataSourceQueryChoosersPlugIn.extensions(readerWriterDataSourceClass), context));
        } else {
            chooserManager.addSaveDataSourceQueryChooser(new SaveFileDataSourceQueryChooser(readerWriterDataSourceClass, description, InstallStandardDataSourceQueryChoosersPlugIn.extensions(readerWriterDataSourceClass), context){
                private JComponent comboboxFieldComponent;

                protected Map toProperties(File file) {
                    HashMap<String, String> properties = new HashMap<String, String>(super.toProperties(file));
                    String charsetName = Charset.defaultCharset().name();
                    if (this.comboboxFieldComponent instanceof ComboBoxComponentPanel) {
                        charsetName = (String)((ComboBoxComponentPanel)this.comboboxFieldComponent).getSelectedItem();
                    }
                    properties.put("charset", charsetName);
                    return properties;
                }

                protected Component getSouthComponent1() {
                    boolean showCharsetSelection = false;
                    Object showCharsetSelectionObject = PersistentBlackboardPlugIn.get(context.getBlackboard()).get(DatasetOptionsPanel.BB_DATASET_OPTIONS_SHOW_CHARSET_SELECTION);
                    if (showCharsetSelectionObject instanceof Boolean) {
                        showCharsetSelection = (Boolean)showCharsetSelectionObject;
                    }
                    if (showCharsetSelection) {
                        ComboBoxFieldComponentFactory fieldComponentFactory = new ComboBoxFieldComponentFactory(context, I18N.get((String)"org.openjump.core.ui.io.file.DataSourceFileLayerLoader.charset") + ":", Charset.availableCharsets().keySet().toArray());
                        this.comboboxFieldComponent = fieldComponentFactory.createComponent();
                        fieldComponentFactory.setValue(this.comboboxFieldComponent, (Object)Charset.defaultCharset().name());
                        return this.comboboxFieldComponent;
                    }
                    return new Component(){};
                }
            });
        }
    }

    public static String[] extensions(Class readerWriterDataSourceClass) {
        String[] exts = null;
        try {
            exts = ((StandardReaderWriterFileDataSource)readerWriterDataSourceClass.newInstance()).getExtensions();
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.toString());
        }
        return exts;
    }

    public void initialize(PlugInContext context) throws Exception {
        this.addFileDataSourceQueryChoosers((JUMPReader)new JMLReader(), (JUMPWriter)new JMLWriter(), "JUMP GML", context.getWorkbenchContext(), StandardReaderWriterFileDataSource.JML.class);
        new GMLDataSourceQueryChooserInstaller().addLoadGMLFileDataSourceQueryChooser(context);
        new GMLDataSourceQueryChooserInstaller().addSaveGMLFileDataSourceQueryChooser(context);
        this.addFileDataSourceQueryChoosers((JUMPReader)new FMEGMLReader(), (JUMPWriter)new FMEGMLWriter(), "FME GML", context.getWorkbenchContext(), StandardReaderWriterFileDataSource.FMEGML.class);
        this.addFileDataSourceQueryChoosers((JUMPReader)new WKTReader(), (JUMPWriter)new WKTWriter(), "WKT", context.getWorkbenchContext(), StandardReaderWriterFileDataSource.WKT.class);
        this.addFileDataSourceQueryChoosers((JUMPReader)new ShapefileReader(), (JUMPWriter)new ShapefileWriter(), "ESRI Shapefile", context.getWorkbenchContext(), StandardReaderWriterFileDataSource.Shapefile.class);
    }

    public static void addCompressedFileFilter(String description, JFileChooser chooser) {
        chooser.addChoosableFileFilter(GUIUtil.createFileFilter(I18N.get((String)"datasource.InstallStandardDataSourceQueryChoosersPlugIn.compressed") + " " + description, new String[]{"zip", "gz"}));
    }
}

