/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datasource;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.AbstractLoadSaveDatasetPlugIn;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AbstractLoadDatasetPlugIn
extends AbstractLoadSaveDatasetPlugIn {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Assert.isTrue((!this.getDataSourceQueries().isEmpty() ? 1 : 0) != 0);
        boolean exceptionsEncountered = false;
        for (DataSourceQuery dataSourceQuery : this.getDataSourceQueries()) {
            ArrayList exceptions = new ArrayList();
            Assert.isTrue((boolean)dataSourceQuery.getDataSource().isReadable());
            monitor.report(I18N.get((String)"datasource.LoadDatasetPlugIn.loading") + " " + dataSourceQuery.toString() + "...");
            Connection connection = dataSourceQuery.getDataSource().getConnection();
            try {
                FeatureCollection dataset = dataSourceQuery.getDataSource().installCoordinateSystem(connection.executeQuery(dataSourceQuery.getQuery(), exceptions, monitor), CoordinateSystemRegistry.instance((Blackboard)context.getWorkbenchContext().getBlackboard()));
                if (dataset != null) {
                    context.getLayerManager().addLayer(this.chooseCategory(context), dataSourceQuery.toString(), dataset).setDataSourceQuery(dataSourceQuery).setFeatureCollectionModified(false);
                }
            }
            finally {
                connection.close();
            }
            if (exceptions.isEmpty()) continue;
            if (!exceptionsEncountered) {
                context.getOutputFrame().createNewDocument();
                exceptionsEncountered = true;
            }
            this.reportExceptions(exceptions, dataSourceQuery, context);
        }
        if (exceptionsEncountered) {
            context.getWorkbenchFrame().warnUser(I18N.get((String)"datasource.LoadDatasetPlugIn.problems-were-encountered"));
        }
    }

    private void reportExceptions(ArrayList exceptions, DataSourceQuery dataSourceQuery, PlugInContext context) {
        context.getOutputFrame().addHeader(1, exceptions.size() + " " + I18N.get((String)"datasource.LoadDatasetPlugIn.problem") + StringUtil.s((int)exceptions.size()) + " " + I18N.get((String)"datasource.LoadDatasetPlugIn.loading") + " " + dataSourceQuery.toString() + "." + (exceptions.size() > 10 ? " " + I18N.get((String)"datasource.LoadDatasetPlugIn.first-and-last-five") : ""));
        context.getOutputFrame().addText(I18N.get((String)"datasource.LoadDatasetPlugIn.see-view-log"));
        context.getOutputFrame().append("<ul>");
        ArrayList exceptionsToReport = exceptions.size() <= 10 ? exceptions : CollectionUtil.concatenate(Arrays.asList(exceptions.subList(0, 5), exceptions.subList(exceptions.size() - 5, exceptions.size())));
        for (Exception exception : exceptionsToReport) {
            context.getWorkbenchFrame().log(StringUtil.stackTrace((Throwable)exception));
            context.getOutputFrame().append("<li>");
            context.getOutputFrame().append(GUIUtil.escapeHTML(WorkbenchFrame.toMessage(exception), true, true));
            context.getOutputFrame().append("</li>");
        }
        context.getOutputFrame().append("</ul>");
    }

    private String chooseCategory(PlugInContext context) {
        return context.getLayerNamePanel().getSelectedCategories().isEmpty() ? StandardCategoryNames.WORKING : context.getLayerNamePanel().getSelectedCategories().iterator().next().toString();
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck());
    }
}

