/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.DataStoreDriver;
import com.vividsolutions.jump.datastore.DataStoreException;
import com.vividsolutions.jump.datastore.postgis.PostgisDataStoreDriver;
import com.vividsolutions.jump.workbench.Setup;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.AbstractSaveDatasetAsPlugIn;
import com.vividsolutions.jump.workbench.datasource.InstallStandardDataSourceQueryChoosersPlugIn;
import com.vividsolutions.jump.workbench.datasource.LoadDatasetPlugIn;
import com.vividsolutions.jump.workbench.datasource.SaveDatasetAsPlugIn;
import com.vividsolutions.jump.workbench.datastore.ConnectionManager;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.ApplicationExitHandler;
import com.vividsolutions.jump.workbench.ui.AttributeTab;
import com.vividsolutions.jump.workbench.ui.CloneableInternalFrame;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DrawPolygonFenceTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DrawRectangleFenceTool;
import com.vividsolutions.jump.workbench.ui.cursortool.FeatureInfoTool;
import com.vividsolutions.jump.workbench.ui.cursortool.MeasureTool;
import com.vividsolutions.jump.workbench.ui.cursortool.OrCompositeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.SelectFeaturesTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPlugIn;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.AboutPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.AddNewCategoryPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.AddNewFeaturesPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.AddNewLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.AddWMSDemoBoxEasterEggPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.ClearSelectionPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.CloneWindowPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.CombineSelectedFeaturesPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.DeleteAllFeaturesPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.DeleteSelectedItemsPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.EditSelectedFeaturePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.EditablePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.ExplodeSelectedFeaturesPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInfoPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.FirstTaskFramePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.GenerateLogPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.InstallStandardFeatureTextWritersPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.MapToolTipsPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.MoveLayerablePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.NewTaskPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.OpenProjectPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.OptionsPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.OutputWindowPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.RedoPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.RemoveSelectedCategoriesPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.RemoveSelectedLayersPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.SaveImageAsPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.SaveProjectAsPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.SaveProjectPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.SelectFeaturesInFencePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.SelectablePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.ShortcutKeysPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.UndoPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.VerticesInFencePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.ViewAttributesPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.ViewSchemaPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CopyImagePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CopySelectedItemsPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CopySelectedLayersPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CopyThisCoordinatePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CutSelectedItemsPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CutSelectedLayersPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.PasteItemsPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.PasteLayersPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.AddDatastoreLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.InstallDatastoreLayerRendererHintsPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.RefreshDataStoreLayerPlugin;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.RunDatastoreQueryPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.imagery.AddImageLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.imagery.ImageLayerManagerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.imagery.InstallReferencedImageFactoriesPlugin;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.InstallScaleBarPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.ScaleBarPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.ScaleBarRenderer;
import com.vividsolutions.jump.workbench.ui.plugin.skin.InstallSkinsPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.wms.AddWMSQueryPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.wms.EditWMSQueryPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRendererFactory;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import com.vividsolutions.jump.workbench.ui.renderer.WmsLayerRendererFactory;
import com.vividsolutions.jump.workbench.ui.renderer.style.ArrowLineStringEndpointStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.ArrowLineStringSegmentStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.CircleLineStringEndpointStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.MetricsLineStringSegmentStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexIndexLineSegmentStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexXYLineSegmentStyle;
import com.vividsolutions.jump.workbench.ui.snap.InstallGridPlugIn;
import com.vividsolutions.jump.workbench.ui.snap.SnapToVerticesPolicy;
import com.vividsolutions.jump.workbench.ui.style.CopyStylesPlugIn;
import com.vividsolutions.jump.workbench.ui.style.PasteStylesPlugIn;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import com.vividsolutions.jump.workbench.ui.zoom.InstallZoomBarPlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.PanTool;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomBarPlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomNextPlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomPreviousPlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToClickPlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToCoordinatePlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToFencePlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToFullExtentPlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToSelectedItemsPlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomTool;
import de.latlon.deejump.plugin.style.DeeChangeStylesPlugIn;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.reflect.Field;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import org.openjump.OpenJumpConfiguration;
import org.openjump.core.ui.plugin.tools.ZoomRealtimeTool;

public class JUMPConfiguration
implements Setup {
    private InstallScaleBarPlugIn installScaleBarPlugIn = new InstallScaleBarPlugIn();
    private InstallGridPlugIn installGridPlugIn = new InstallGridPlugIn();
    private FirstTaskFramePlugIn firstTaskFramePlugIn = new FirstTaskFramePlugIn();
    private InstallZoomBarPlugIn installZoomBarPlugIn = new InstallZoomBarPlugIn();
    private MoveLayerablePlugIn moveUpPlugIn = MoveLayerablePlugIn.UP;
    private InstallStandardDataSourceQueryChoosersPlugIn installStandardDataSourceQueryChoosersPlugIn = new InstallStandardDataSourceQueryChoosersPlugIn();
    private InstallStandardFeatureTextWritersPlugIn installStandardFeatureTextWritersPlugIn = new InstallStandardFeatureTextWritersPlugIn();
    private ShortcutKeysPlugIn shortcutKeysPlugIn = new ShortcutKeysPlugIn();
    private ClearSelectionPlugIn clearSelectionPlugIn = new ClearSelectionPlugIn();
    private EditWMSQueryPlugIn editWMSQueryPlugIn = new EditWMSQueryPlugIn();
    private MoveLayerablePlugIn moveDownPlugIn = MoveLayerablePlugIn.DOWN;
    private AddWMSQueryPlugIn addWMSQueryPlugIn = new AddWMSQueryPlugIn();
    private AddNewFeaturesPlugIn addNewFeaturesPlugIn = new AddNewFeaturesPlugIn();
    private OptionsPlugIn optionsPlugIn = new OptionsPlugIn();
    private AddNewCategoryPlugIn addNewCategoryPlugIn = new AddNewCategoryPlugIn();
    private CloneWindowPlugIn cloneWindowPlugIn = new CloneWindowPlugIn();
    private CopySelectedItemsPlugIn copySelectedItemsPlugIn = new CopySelectedItemsPlugIn();
    private CopyThisCoordinatePlugIn copyThisCoordinatePlugIn = new CopyThisCoordinatePlugIn();
    private CopyImagePlugIn copyImagePlugIn = new CopyImagePlugIn();
    private MapToolTipsPlugIn toolTipsPlugIn = new MapToolTipsPlugIn();
    private CopySelectedLayersPlugIn copySelectedLayersPlugIn = new CopySelectedLayersPlugIn();
    private AddNewLayerPlugIn addNewLayerPlugIn = new AddNewLayerPlugIn();
    private AddWMSDemoBoxEasterEggPlugIn addWMSDemoBoxEasterEggPlugIn = new AddWMSDemoBoxEasterEggPlugIn();
    private EditSelectedFeaturePlugIn editSelectedFeaturePlugIn = new EditSelectedFeaturePlugIn();
    private EditingPlugIn editingPlugIn = new EditingPlugIn();
    private EditablePlugIn editablePlugIn = new EditablePlugIn(this.editingPlugIn);
    private SelectablePlugIn selectablePlugIn = new SelectablePlugIn();
    private LoadDatasetPlugIn loadDatasetPlugIn = new LoadDatasetPlugIn();
    private SaveDatasetAsPlugIn saveDatasetAsPlugIn = new SaveDatasetAsPlugIn();
    private SaveImageAsPlugIn saveImageAsPlugIn = new SaveImageAsPlugIn();
    private GenerateLogPlugIn generateLogPlugIn = new GenerateLogPlugIn();
    private NewTaskPlugIn newTaskPlugIn = new NewTaskPlugIn();
    private OpenProjectPlugIn openProjectPlugIn = new OpenProjectPlugIn();
    private PasteItemsPlugIn pasteItemsPlugIn = new PasteItemsPlugIn();
    private PasteLayersPlugIn pasteLayersPlugIn = new PasteLayersPlugIn();
    private DeleteAllFeaturesPlugIn deleteAllFeaturesPlugIn = new DeleteAllFeaturesPlugIn();
    private DeleteSelectedItemsPlugIn deleteSelectedItemsPlugIn = new DeleteSelectedItemsPlugIn();
    private RemoveSelectedLayersPlugIn removeSelectedLayersPlugIn = new RemoveSelectedLayersPlugIn();
    private RemoveSelectedCategoriesPlugIn removeSelectedCategoriesPlugIn = new RemoveSelectedCategoriesPlugIn();
    private SaveProjectAsPlugIn saveProjectAsPlugIn = new SaveProjectAsPlugIn();
    private SaveProjectPlugIn saveProjectPlugIn = new SaveProjectPlugIn(this.saveProjectAsPlugIn);
    private SelectFeaturesInFencePlugIn selectFeaturesInFencePlugIn = new SelectFeaturesInFencePlugIn();
    private ScaleBarPlugIn scaleBarPlugIn = new ScaleBarPlugIn();
    private ZoomBarPlugIn zoomBarPlugIn = new ZoomBarPlugIn();
    private DeeChangeStylesPlugIn changeStylesPlugIn = new DeeChangeStylesPlugIn();
    private UndoPlugIn undoPlugIn = new UndoPlugIn();
    private RedoPlugIn redoPlugIn = new RedoPlugIn();
    private ViewAttributesPlugIn viewAttributesPlugIn = new ViewAttributesPlugIn();
    private ViewSchemaPlugIn viewSchemaPlugIn = new ViewSchemaPlugIn(this.editingPlugIn);
    private FeatureInfoPlugIn featureInfoPlugIn = new FeatureInfoPlugIn();
    private OutputWindowPlugIn outputWindowPlugIn = new OutputWindowPlugIn();
    private VerticesInFencePlugIn verticesInFencePlugIn = new VerticesInFencePlugIn();
    private ZoomNextPlugIn zoomNextPlugIn = new ZoomNextPlugIn();
    private ZoomToClickPlugIn zoomToClickPlugIn = new ZoomToClickPlugIn(0.5);
    private ZoomPreviousPlugIn zoomPreviousPlugIn = new ZoomPreviousPlugIn();
    private ZoomToFencePlugIn zoomToFencePlugIn = new ZoomToFencePlugIn();
    private ZoomToCoordinatePlugIn zoomToCoordinatePlugIn = new ZoomToCoordinatePlugIn();
    private ZoomToFullExtentPlugIn zoomToFullExtentPlugIn = new ZoomToFullExtentPlugIn();
    private ZoomToLayerPlugIn zoomToLayerPlugIn = new ZoomToLayerPlugIn();
    private ZoomToSelectedItemsPlugIn zoomToSelectedItemsPlugIn = new ZoomToSelectedItemsPlugIn();
    private CutSelectedItemsPlugIn cutSelectedItemsPlugIn = new CutSelectedItemsPlugIn();
    private CutSelectedLayersPlugIn cutSelectedLayersPlugIn = new CutSelectedLayersPlugIn();
    private CopyStylesPlugIn copyStylesPlugIn = new CopyStylesPlugIn();
    private PasteStylesPlugIn pasteStylesPlugIn = new PasteStylesPlugIn();
    private CombineSelectedFeaturesPlugIn combineSelectedFeaturesPlugIn = new CombineSelectedFeaturesPlugIn();
    private ExplodeSelectedFeaturesPlugIn explodeSelectedFeaturesPlugIn = new ExplodeSelectedFeaturesPlugIn();
    private InstallSkinsPlugIn installSkinsPlugIn = new InstallSkinsPlugIn();
    private InstallReferencedImageFactoriesPlugin installReferencedImageFactoriesPlugin = new InstallReferencedImageFactoriesPlugin();
    private ImageLayerManagerPlugIn imageLayerManagerPlugIn = new ImageLayerManagerPlugIn();
    private RefreshDataStoreLayerPlugin refreshDataStoreLayerPlugin = new RefreshDataStoreLayerPlugin();
    private AddDatastoreLayerPlugIn addDatastoreLayerPlugIn = new AddDatastoreLayerPlugIn();
    private RunDatastoreQueryPlugIn runDatastoreQueryPlugIn = new RunDatastoreQueryPlugIn();
    private InstallDatastoreLayerRendererHintsPlugIn installDatastoreLayerRendererHintsPlugIn = new InstallDatastoreLayerRendererHintsPlugIn();
    private AddImageLayerPlugIn addImageLayerPlugIn = new AddImageLayerPlugIn();

    public void setup(WorkbenchContext workbenchContext) throws Exception {
        this.configureStyles(workbenchContext);
        this.configureDatastores(workbenchContext);
        workbenchContext.getWorkbench().getBlackboard().put(SnapToVerticesPolicy.ENABLED_KEY, true);
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        FeatureInstaller featureInstaller = new FeatureInstaller(workbenchContext);
        this.configureToolBar(workbenchContext, checkFactory);
        this.configureMainMenus(workbenchContext, checkFactory, featureInstaller);
        this.configureLayerPopupMenu(workbenchContext, featureInstaller, checkFactory);
        this.configureAttributePopupMenu(workbenchContext, featureInstaller, checkFactory);
        this.configureWMSQueryNamePopupMenu(workbenchContext, featureInstaller, checkFactory);
        this.configureCategoryPopupMenu(workbenchContext, featureInstaller);
        this.configureLayerViewPanelPopupMenu(workbenchContext, checkFactory, featureInstaller);
        this.initializeRenderingManager();
        OpenJumpConfiguration.loadOpenJumpPlugIns((WorkbenchContext)workbenchContext);
        this.initializeBuiltInPlugIns(workbenchContext);
    }

    private void initializeRenderingManager() {
        RenderingManager.setRendererFactory(Layer.class, new LayerRendererFactory());
        RenderingManager.setRendererFactory(WMSLayer.class, new WmsLayerRendererFactory());
    }

    private void configureCategoryPopupMenu(WorkbenchContext workbenchContext, FeatureInstaller featureInstaller) {
        featureInstaller.addPopupMenuItem(workbenchContext.getWorkbench().getFrame().getCategoryPopupMenu(), this.addNewLayerPlugIn, this.addNewLayerPlugIn.getName(), false, IconLoader.icon("layers.png"), null);
        featureInstaller.addPopupMenuItem(workbenchContext.getWorkbench().getFrame().getCategoryPopupMenu(), this.loadDatasetPlugIn, this.loadDatasetPlugIn.getName() + "...", false, LoadDatasetPlugIn.getIcon(), LoadDatasetPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(workbenchContext.getWorkbench().getFrame().getCategoryPopupMenu(), this.addDatastoreLayerPlugIn, this.addDatastoreLayerPlugIn.getName() + "...", false, null, null);
        featureInstaller.addPopupMenuItem(workbenchContext.getWorkbench().getFrame().getCategoryPopupMenu(), this.pasteLayersPlugIn, this.pasteLayersPlugIn.getNameWithMnemonic(), false, null, this.pasteLayersPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(workbenchContext.getWorkbench().getFrame().getCategoryPopupMenu(), this.removeSelectedCategoriesPlugIn, this.removeSelectedCategoriesPlugIn.getName(), false, null, this.removeSelectedCategoriesPlugIn.createEnableCheck(workbenchContext));
    }

    private void configureWMSQueryNamePopupMenu(WorkbenchContext workbenchContext, FeatureInstaller featureInstaller, EnableCheckFactory checkFactory) {
        TitledPopupMenu wmsLayerNamePopupMenu = workbenchContext.getWorkbench().getFrame().getWMSLayerNamePopupMenu();
        featureInstaller.addPopupMenuItem(wmsLayerNamePopupMenu, this.editWMSQueryPlugIn, this.editWMSQueryPlugIn.getName() + "...", false, null, this.editWMSQueryPlugIn.createEnableCheck(workbenchContext));
        wmsLayerNamePopupMenu.addSeparator();
        featureInstaller.addPopupMenuItem(wmsLayerNamePopupMenu, this.moveUpPlugIn, this.moveUpPlugIn.getName(), false, MoveLayerablePlugIn.UPICON, this.moveUpPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(wmsLayerNamePopupMenu, this.moveDownPlugIn, this.moveDownPlugIn.getName(), false, MoveLayerablePlugIn.DOWNICON, this.moveDownPlugIn.createEnableCheck(workbenchContext));
        wmsLayerNamePopupMenu.addSeparator();
        featureInstaller.addPopupMenuItem(wmsLayerNamePopupMenu, this.cutSelectedLayersPlugIn, this.cutSelectedLayersPlugIn.getNameWithMnemonic(), false, CutSelectedLayersPlugIn.ICON, this.cutSelectedLayersPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(wmsLayerNamePopupMenu, this.copySelectedLayersPlugIn, this.copySelectedLayersPlugIn.getNameWithMnemonic(), false, CopySelectedLayersPlugIn.ICON, this.copySelectedLayersPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(wmsLayerNamePopupMenu, this.removeSelectedLayersPlugIn, this.removeSelectedLayersPlugIn.getName(), false, RemoveSelectedLayersPlugIn.ICON, this.removeSelectedLayersPlugIn.createEnableCheck(workbenchContext));
    }

    private void configureAttributePopupMenu(WorkbenchContext workbenchContext, FeatureInstaller featureInstaller, EnableCheckFactory checkFactory) {
        AttributeTab.addPopupMenuItem(workbenchContext, this.editablePlugIn, this.editablePlugIn.getName(), true, EditablePlugIn.ICON, this.editablePlugIn.createEnableCheck(workbenchContext));
        AttributeTab.addPopupMenuItem(workbenchContext, this.featureInfoPlugIn, this.featureInfoPlugIn.getName(), false, GUIUtil.toSmallIcon(FeatureInfoTool.ICON), FeatureInfoPlugIn.createEnableCheck(workbenchContext));
        AttributeTab.addPopupMenuItem(workbenchContext, this.viewSchemaPlugIn, this.viewSchemaPlugIn.getName(), false, ViewSchemaPlugIn.ICON, ViewSchemaPlugIn.createEnableCheck(workbenchContext));
        AttributeTab.addPopupMenuItem(workbenchContext, this.cutSelectedItemsPlugIn, this.cutSelectedItemsPlugIn.getName(), false, CutSelectedItemsPlugIn.ICON, this.cutSelectedItemsPlugIn.createEnableCheck(workbenchContext));
        AttributeTab.addPopupMenuItem(workbenchContext, this.copySelectedItemsPlugIn, this.copySelectedItemsPlugIn.getNameWithMnemonic(), false, CopySelectedItemsPlugIn.ICON, CopySelectedItemsPlugIn.createEnableCheck(workbenchContext));
        AttributeTab.addPopupMenuItem(workbenchContext, this.deleteSelectedItemsPlugIn, this.deleteSelectedItemsPlugIn.getName(), false, DeleteSelectedItemsPlugIn.ICON, DeleteSelectedItemsPlugIn.createEnableCheck(workbenchContext));
    }

    private void configureLayerPopupMenu(WorkbenchContext workbenchContext, FeatureInstaller featureInstaller, EnableCheckFactory checkFactory) {
        TitledPopupMenu layerNamePopupMenu = workbenchContext.getWorkbench().getFrame().getLayerNamePopupMenu();
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.editablePlugIn, this.editablePlugIn.getName(), true, EditablePlugIn.ICON, this.editablePlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.selectablePlugIn, this.selectablePlugIn.getName(), true, SelectablePlugIn.ICON, this.selectablePlugIn.createEnableCheck(workbenchContext));
        layerNamePopupMenu.addSeparator();
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.zoomToLayerPlugIn, this.zoomToLayerPlugIn.getName(), false, ZoomToLayerPlugIn.ICON, this.zoomToLayerPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, (PlugIn)this.changeStylesPlugIn, this.changeStylesPlugIn.getName() + "...", false, GUIUtil.toSmallIcon(this.changeStylesPlugIn.getIcon()), this.changeStylesPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.copyStylesPlugIn, this.copyStylesPlugIn.getName(), false, null, CopyStylesPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.pasteStylesPlugIn, this.pasteStylesPlugIn.getName(), false, null, PasteStylesPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.viewAttributesPlugIn, this.viewAttributesPlugIn.getName(), false, GUIUtil.toSmallIcon(this.viewAttributesPlugIn.getIcon()), this.viewAttributesPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.viewSchemaPlugIn, this.viewSchemaPlugIn.getName(), false, ViewSchemaPlugIn.ICON, ViewSchemaPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.imageLayerManagerPlugIn, this.imageLayerManagerPlugIn.getName() + "...", false, null, ImageLayerManagerPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.refreshDataStoreLayerPlugin, this.refreshDataStoreLayerPlugin.getName() + "...", false, RefreshDataStoreLayerPlugin.ICON, RefreshDataStoreLayerPlugin.createEnableCheck(workbenchContext));
        layerNamePopupMenu.addSeparator();
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.saveDatasetAsPlugIn, this.saveDatasetAsPlugIn.getName() + "...", false, SaveDatasetAsPlugIn.ICON, AbstractSaveDatasetAsPlugIn.createEnableCheck(workbenchContext));
        layerNamePopupMenu.addSeparator();
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.moveUpPlugIn, this.moveUpPlugIn.getName(), false, MoveLayerablePlugIn.UPICON, this.moveUpPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.moveDownPlugIn, this.moveDownPlugIn.getName(), false, MoveLayerablePlugIn.DOWNICON, this.moveDownPlugIn.createEnableCheck(workbenchContext));
        layerNamePopupMenu.addSeparator();
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.cutSelectedLayersPlugIn, this.cutSelectedLayersPlugIn.getNameWithMnemonic(), false, CutSelectedLayersPlugIn.ICON, this.cutSelectedLayersPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.copySelectedLayersPlugIn, this.copySelectedLayersPlugIn.getNameWithMnemonic(), false, CopySelectedLayersPlugIn.ICON, this.copySelectedLayersPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.removeSelectedLayersPlugIn, this.removeSelectedLayersPlugIn.getName(), false, RemoveSelectedLayersPlugIn.ICON, this.removeSelectedLayersPlugIn.createEnableCheck(workbenchContext));
        layerNamePopupMenu.addSeparator();
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.addNewFeaturesPlugIn, this.addNewFeaturesPlugIn.getName() + "...", false, AddNewFeaturesPlugIn.ICON, AddNewFeaturesPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.pasteItemsPlugIn, this.pasteItemsPlugIn.getNameWithMnemonic(), false, PasteItemsPlugIn.ICON, PasteItemsPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this.deleteAllFeaturesPlugIn, this.deleteAllFeaturesPlugIn.getName(), false, DeleteAllFeaturesPlugIn.ICON, this.deleteAllFeaturesPlugIn.createEnableCheck(workbenchContext));
    }

    private void configureLayerViewPanelPopupMenu(WorkbenchContext workbenchContext, EnableCheckFactory checkFactory, FeatureInstaller featureInstaller) {
        JPopupMenu popupMenu = LayerViewPanel.popupMenu();
        featureInstaller.addPopupMenuItem(popupMenu, this.featureInfoPlugIn, this.featureInfoPlugIn.getName(), false, GUIUtil.toSmallIcon(FeatureInfoTool.ICON), FeatureInfoPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(popupMenu, this.verticesInFencePlugIn, this.verticesInFencePlugIn.getName(), false, null, new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createFenceMustBeDrawnCheck()));
        popupMenu.addSeparator();
        featureInstaller.addPopupMenuItem(popupMenu, this.zoomToFencePlugIn, I18N.get((String)"JUMPConfiguration.fence"), false, GUIUtil.toSmallIcon(this.zoomToFencePlugIn.getIcon()), new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createFenceMustBeDrawnCheck()));
        featureInstaller.addPopupMenuItem(popupMenu, this.zoomToSelectedItemsPlugIn, this.zoomToSelectedItemsPlugIn.getName(), false, GUIUtil.toSmallIcon(this.zoomToSelectedItemsPlugIn.getIcon()), ZoomToSelectedItemsPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(popupMenu, this.zoomToClickPlugIn, I18N.get((String)"JUMPConfiguration.zoom-out"), false, null, null);
        popupMenu.addSeparator();
        featureInstaller.addPopupMenuItem(popupMenu, this.cutSelectedItemsPlugIn, this.cutSelectedItemsPlugIn.getName(), false, CutSelectedItemsPlugIn.ICON, this.cutSelectedItemsPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(popupMenu, this.copySelectedItemsPlugIn, this.copySelectedItemsPlugIn.getNameWithMnemonic(), false, null, CopySelectedItemsPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(popupMenu, this.copyThisCoordinatePlugIn, this.copyThisCoordinatePlugIn.getName(), false, null, CopyThisCoordinatePlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(popupMenu, this.editSelectedFeaturePlugIn, this.editSelectedFeaturePlugIn.getName(), false, null, EditSelectedFeaturePlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(popupMenu, this.deleteSelectedItemsPlugIn, this.deleteSelectedItemsPlugIn.getName(), false, DeleteSelectedItemsPlugIn.ICON, DeleteSelectedItemsPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(popupMenu, this.combineSelectedFeaturesPlugIn, this.combineSelectedFeaturesPlugIn.getName(), false, null, this.combineSelectedFeaturesPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addPopupMenuItem(popupMenu, this.explodeSelectedFeaturesPlugIn, this.explodeSelectedFeaturesPlugIn.getName(), false, null, this.explodeSelectedFeaturesPlugIn.createEnableCheck(workbenchContext));
    }

    private void configureMainMenus(final WorkbenchContext workbenchContext, EnableCheckFactory checkFactory, FeatureInstaller featureInstaller) throws Exception {
        FeatureInstaller.addMainMenu(featureInstaller, new String[]{MenuNames.FILE}, MenuNames.FILE_NEW, 0);
        JUMPConfiguration jUMPConfiguration = this;
        featureInstaller.addMainMenuItemWithJava14Fix(this.newTaskPlugIn, new String[]{MenuNames.FILE, MenuNames.FILE_NEW}, this.newTaskPlugIn.getName(), false, jUMPConfiguration.newTaskPlugIn.getIcon(), null);
        featureInstaller.addMenuSeparator(new String[]{MenuNames.FILE, MenuNames.FILE_NEW});
        featureInstaller.addMainMenuItemWithJava14Fix(this.addNewLayerPlugIn, new String[]{MenuNames.FILE, MenuNames.FILE_NEW}, I18N.get((String)"com.vividsolutions.jump.workbench.ui.plugin.AddNewLayerPlugIn.name"), false, IconLoader.icon("layers.png"), checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
        featureInstaller.addMainMenuItem(this.addNewCategoryPlugIn, new String[]{MenuNames.FILE, MenuNames.FILE_NEW}, I18N.get((String)"com.vividsolutions.jump.workbench.ui.plugin.AddNewCategoryPlugIn.name"), false, IconLoader.icon("chart_organisation.png"), checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
        featureInstaller.addMenuSeparator(MenuNames.FILE);
        featureInstaller.addMainMenuItemWithJava14Fix(this.saveDatasetAsPlugIn, new String[]{MenuNames.FILE}, this.saveDatasetAsPlugIn.getName() + "...", false, SaveDatasetAsPlugIn.ICON, SaveDatasetAsPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMainMenuItemWithJava14Fix(this.saveProjectPlugIn, new String[]{MenuNames.FILE}, this.saveProjectPlugIn.getName(), false, null, checkFactory.createTaskWindowMustBeActiveCheck());
        featureInstaller.addMainMenuItemWithJava14Fix(this.saveProjectAsPlugIn, new String[]{MenuNames.FILE}, this.saveProjectAsPlugIn.getName() + "...", false, null, checkFactory.createTaskWindowMustBeActiveCheck());
        FeatureInstaller.addMainMenu(featureInstaller, new String[]{MenuNames.FILE}, MenuNames.FILE_SAVEVIEW, 5);
        featureInstaller.addMainMenuItemWithJava14Fix(this.saveImageAsPlugIn, new String[]{MenuNames.FILE, MenuNames.FILE_SAVEVIEW}, this.saveImageAsPlugIn.getName(), false, null, SaveImageAsPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMainMenuItemWithJava14Fix(this.undoPlugIn, new String[]{MenuNames.EDIT}, this.undoPlugIn.getName(), false, GUIUtil.toSmallIcon(this.undoPlugIn.getIcon()), this.undoPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMainMenuItemWithJava14Fix(this.redoPlugIn, new String[]{MenuNames.EDIT}, this.redoPlugIn.getName(), false, GUIUtil.toSmallIcon(this.redoPlugIn.getIcon()), this.redoPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMenuSeparator(MenuNames.EDIT);
        featureInstaller.addMainMenuItemWithJava14Fix(this.addNewFeaturesPlugIn, new String[]{MenuNames.EDIT}, this.addNewFeaturesPlugIn.getName() + "...", false, AddNewFeaturesPlugIn.ICON, AddNewFeaturesPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMainMenuItemWithJava14Fix(this.editSelectedFeaturePlugIn, new String[]{MenuNames.EDIT}, this.editSelectedFeaturePlugIn.getName(), false, null, EditSelectedFeaturePlugIn.createEnableCheck(workbenchContext));
        FeatureInstaller.addMainMenu(featureInstaller, new String[]{MenuNames.EDIT}, MenuNames.SELECTION, 6);
        featureInstaller.addMainMenuItemWithJava14Fix(this.selectFeaturesInFencePlugIn, new String[]{MenuNames.EDIT, MenuNames.SELECTION}, this.selectFeaturesInFencePlugIn.getName(), false, null, SelectFeaturesInFencePlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMainMenuItemWithJava14Fix(this.clearSelectionPlugIn, new String[]{MenuNames.EDIT}, this.clearSelectionPlugIn.getName(), false, null, this.clearSelectionPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMenuSeparator(MenuNames.EDIT);
        featureInstaller.addMainMenuItemWithJava14Fix(this.cutSelectedItemsPlugIn, new String[]{MenuNames.EDIT}, this.cutSelectedItemsPlugIn.getName(), false, CutSelectedItemsPlugIn.ICON, this.cutSelectedItemsPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMainMenuItem(this.copySelectedItemsPlugIn, new String[]{MenuNames.EDIT}, this.copySelectedItemsPlugIn.getNameWithMnemonic(), false, CopySelectedItemsPlugIn.ICON, CopySelectedItemsPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMainMenuItem(this.pasteItemsPlugIn, new String[]{MenuNames.EDIT}, this.pasteItemsPlugIn.getNameWithMnemonic(), false, PasteItemsPlugIn.ICON, PasteItemsPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMainMenuItemWithJava14Fix(this.deleteSelectedItemsPlugIn, new String[]{MenuNames.EDIT}, this.deleteSelectedItemsPlugIn.getName(), false, DeleteSelectedItemsPlugIn.ICON, DeleteSelectedItemsPlugIn.createEnableCheck(workbenchContext));
        this.editingPlugIn.createMainMenuItem(new String[]{MenuNames.VIEW}, GUIUtil.toSmallIcon(EditingPlugIn.ICON), workbenchContext);
        featureInstaller.addMainMenuItemWithJava14Fix(this.copyImagePlugIn, new String[]{MenuNames.VIEW}, this.copyImagePlugIn.getName(), false, CopyImagePlugIn.ICON, CopyImagePlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMenuSeparator(MenuNames.VIEW);
        featureInstaller.addMainMenuItemWithJava14Fix(this.featureInfoPlugIn, new String[]{MenuNames.VIEW}, this.featureInfoPlugIn.getName(), false, GUIUtil.toSmallIcon(FeatureInfoTool.ICON), FeatureInfoPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMainMenuItemWithJava14Fix(this.verticesInFencePlugIn, new String[]{MenuNames.VIEW}, this.verticesInFencePlugIn.getName(), false, null, new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createFenceMustBeDrawnCheck()));
        featureInstaller.addMenuSeparator(MenuNames.VIEW);
        featureInstaller.addMainMenuItemWithJava14Fix(this.zoomToFullExtentPlugIn, new String[]{MenuNames.VIEW}, this.zoomToFullExtentPlugIn.getName(), false, GUIUtil.toSmallIcon(this.zoomToFullExtentPlugIn.getIcon()), this.zoomToFullExtentPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMainMenuItemWithJava14Fix(this.zoomToFencePlugIn, new String[]{MenuNames.VIEW}, this.zoomToFencePlugIn.getName(), false, GUIUtil.toSmallIcon(this.zoomToFencePlugIn.getIcon()), new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createFenceMustBeDrawnCheck()));
        featureInstaller.addMainMenuItemWithJava14Fix(this.zoomToSelectedItemsPlugIn, new String[]{MenuNames.VIEW}, this.zoomToSelectedItemsPlugIn.getName(), false, GUIUtil.toSmallIcon(this.zoomToSelectedItemsPlugIn.getIcon()), ZoomToSelectedItemsPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMainMenuItemWithJava14Fix(this.zoomToCoordinatePlugIn, new String[]{MenuNames.VIEW}, this.zoomToCoordinatePlugIn.getName() + "...", false, null, this.zoomToCoordinatePlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMainMenuItemWithJava14Fix(this.zoomPreviousPlugIn, new String[]{MenuNames.VIEW}, this.zoomPreviousPlugIn.getName(), false, GUIUtil.toSmallIcon(this.zoomPreviousPlugIn.getIcon()), this.zoomPreviousPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMainMenuItemWithJava14Fix(this.zoomNextPlugIn, new String[]{MenuNames.VIEW}, this.zoomNextPlugIn.getName(), false, GUIUtil.toSmallIcon(this.zoomNextPlugIn.getIcon()), this.zoomNextPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMenuSeparator(MenuNames.VIEW);
        featureInstaller.addMainMenuItemWithJava14Fix(this.scaleBarPlugIn, new String[]{MenuNames.VIEW}, this.scaleBarPlugIn.getName(), true, null, new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(new EnableCheck(){

            public String check(JComponent component) {
                ((JCheckBoxMenuItem)component).setSelected(ScaleBarRenderer.isEnabled(workbenchContext.getLayerViewPanel()));
                return null;
            }
        }));
        featureInstaller.addMainMenuItemWithJava14Fix(this.toolTipsPlugIn, new String[]{MenuNames.VIEW}, this.toolTipsPlugIn.getName(), true, null, MapToolTipsPlugIn.createEnableCheck(workbenchContext));
        this.zoomBarPlugIn.createMainMenuItem(new String[]{MenuNames.VIEW}, null, workbenchContext);
        this.configLayer(workbenchContext, checkFactory, featureInstaller);
        featureInstaller.addMainMenuItemWithJava14Fix(this.outputWindowPlugIn, new String[]{MenuNames.WINDOW}, this.outputWindowPlugIn.getName(), false, GUIUtil.toSmallIcon(this.outputWindowPlugIn.getIcon()), null);
        featureInstaller.addMainMenuItemWithJava14Fix(this.generateLogPlugIn, new String[]{MenuNames.WINDOW}, this.generateLogPlugIn.getName() + "...", false, null, null);
        featureInstaller.addMenuSeparator(MenuNames.WINDOW);
        featureInstaller.addMainMenuItemWithJava14Fix(this.cloneWindowPlugIn, new String[]{MenuNames.WINDOW}, this.cloneWindowPlugIn.getName(), false, null, new EnableCheck(){

            public String check(JComponent component) {
                return !(workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof CloneableInternalFrame) ? I18N.get((String)"JUMPConfiguration.not-available-for-the-current-window") : null;
            }
        });
        featureInstaller.addMainMenuItemWithJava14Fix(this.shortcutKeysPlugIn, new String[]{MenuNames.HELP}, this.shortcutKeysPlugIn.getName() + "...", false, null, null);
        new FeatureInstaller(workbenchContext).addMainMenuItemWithJava14Fix(new AboutPlugIn(), new String[]{MenuNames.HELP}, I18N.get((String)"JUMPConfiguration.about"), false, null, null);
        featureInstaller.addMainMenuItemWithJava14Fix(this.optionsPlugIn, new String[]{MenuNames.CUSTOMIZE}, this.optionsPlugIn.getName() + "...", false, null, null);
    }

    private void configLayer(WorkbenchContext workbenchContext, EnableCheckFactory checkFactory, FeatureInstaller featureInstaller) throws Exception {
        String MENU_LAYER = MenuNames.LAYER;
        featureInstaller.addLayerViewMenuItem((PlugIn)this.runDatastoreQueryPlugIn, MENU_LAYER, this.runDatastoreQueryPlugIn.getName() + "...");
        featureInstaller.addLayerViewMenuItem((PlugIn)this.addImageLayerPlugIn, MENU_LAYER, this.addImageLayerPlugIn.getName() + "...");
        featureInstaller.addMenuSeparator(MENU_LAYER);
        featureInstaller.addMainMenuItem(this.cutSelectedLayersPlugIn, MENU_LAYER, this.cutSelectedLayersPlugIn.getNameWithMnemonic(), CutSelectedLayersPlugIn.ICON, this.cutSelectedLayersPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMainMenuItem(this.copySelectedLayersPlugIn, MENU_LAYER, this.copySelectedLayersPlugIn.getNameWithMnemonic(), CopySelectedLayersPlugIn.ICON, this.copySelectedLayersPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMainMenuItem(this.pasteLayersPlugIn, MENU_LAYER, this.pasteLayersPlugIn.getNameWithMnemonic(), null, this.pasteLayersPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMenuSeparator(MENU_LAYER);
        featureInstaller.addMainMenuItem(this.removeSelectedLayersPlugIn, MENU_LAYER, this.removeSelectedLayersPlugIn.getName(), RemoveSelectedLayersPlugIn.ICON, this.removeSelectedLayersPlugIn.createEnableCheck(workbenchContext));
        featureInstaller.addMainMenuItem(this.removeSelectedCategoriesPlugIn, MENU_LAYER, this.removeSelectedCategoriesPlugIn.getName(), null, this.removeSelectedCategoriesPlugIn.createEnableCheck(workbenchContext));
    }

    public void configureDatastores(final WorkbenchContext context) throws Exception {
        context.getRegistry().createEntry(DataStoreDriver.REGISTRY_CLASSIFICATION, new PostgisDataStoreDriver());
        final ApplicationExitHandler oldApplicationExitHandler = context.getWorkbench().getFrame().getApplicationExitHandler();
        context.getWorkbench().getFrame().setApplicationExitHandler(new ApplicationExitHandler(){

            public void exitApplication(JFrame mainFrame) {
                try {
                    ConnectionManager.instance(context).closeConnections();
                }
                catch (DataStoreException e) {
                    throw new RuntimeException(e);
                }
                oldApplicationExitHandler.exitApplication(mainFrame);
            }
        });
    }

    private void configureStyles(WorkbenchContext workbenchContext) {
        WorkbenchFrame frame = workbenchContext.getWorkbench().getFrame();
        frame.addChoosableStyleClass(VertexXYLineSegmentStyle.VertexXY.class);
        frame.addChoosableStyleClass(VertexIndexLineSegmentStyle.VertexIndex.class);
        frame.addChoosableStyleClass(MetricsLineStringSegmentStyle.LengthAngle.class);
        frame.addChoosableStyleClass(ArrowLineStringSegmentStyle.Open.class);
        frame.addChoosableStyleClass(ArrowLineStringSegmentStyle.Solid.class);
        frame.addChoosableStyleClass(ArrowLineStringSegmentStyle.NarrowSolid.class);
        frame.addChoosableStyleClass(ArrowLineStringEndpointStyle.FeathersStart.class);
        frame.addChoosableStyleClass(ArrowLineStringEndpointStyle.FeathersEnd.class);
        frame.addChoosableStyleClass(ArrowLineStringEndpointStyle.OpenStart.class);
        frame.addChoosableStyleClass(ArrowLineStringEndpointStyle.OpenEnd.class);
        frame.addChoosableStyleClass(ArrowLineStringEndpointStyle.SolidStart.class);
        frame.addChoosableStyleClass(ArrowLineStringEndpointStyle.SolidEnd.class);
        frame.addChoosableStyleClass(ArrowLineStringEndpointStyle.NarrowSolidStart.class);
        frame.addChoosableStyleClass(ArrowLineStringEndpointStyle.NarrowSolidEnd.class);
        frame.addChoosableStyleClass(CircleLineStringEndpointStyle.Start.class);
        frame.addChoosableStyleClass(CircleLineStringEndpointStyle.End.class);
    }

    private QuasimodeTool add(CursorTool tool, WorkbenchContext context) {
        return context.getWorkbench().getFrame().getToolBar().addCursorTool(tool).getQuasimodeTool();
    }

    private void configureToolBar(WorkbenchContext workbenchContext, EnableCheckFactory checkFactory) {
        WorkbenchFrame frame = workbenchContext.getWorkbench().getFrame();
        frame.getToolBar().addPlugIn(NewTaskPlugIn.getIcon(), this.newTaskPlugIn, NewTaskPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        frame.getToolBar().addSeparator();
        this.add(new ZoomTool(), workbenchContext);
        this.add(new PanTool(), workbenchContext);
        frame.getToolBar().addSeparator();
        frame.getToolBar().addPlugIn(this.zoomToFullExtentPlugIn.getIcon(), this.zoomToFullExtentPlugIn, this.zoomToFullExtentPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        frame.getToolBar().addPlugIn(this.zoomToSelectedItemsPlugIn.getIcon(), this.zoomToSelectedItemsPlugIn, ZoomToSelectedItemsPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        this.add((CursorTool)new ZoomRealtimeTool(), workbenchContext);
        frame.getToolBar().addPlugIn(this.zoomToFencePlugIn.getIcon(), this.zoomToFencePlugIn, new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createFenceMustBeDrawnCheck()), workbenchContext);
        frame.getToolBar().addPlugIn(this.zoomPreviousPlugIn.getIcon(), this.zoomPreviousPlugIn, this.zoomPreviousPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        frame.getToolBar().addPlugIn(this.zoomNextPlugIn.getIcon(), this.zoomNextPlugIn, this.zoomNextPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        frame.getToolBar().addPlugIn(this.changeStylesPlugIn.getIcon(), (PlugIn)this.changeStylesPlugIn, this.changeStylesPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        frame.getToolBar().addPlugIn(this.viewAttributesPlugIn.getIcon(), this.viewAttributesPlugIn, this.viewAttributesPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        frame.getToolBar().addSeparator();
        this.add(new QuasimodeTool(new SelectFeaturesTool()).add(new QuasimodeTool.ModifierKeySpec(true, false, false), null), workbenchContext);
        frame.getToolBar().addPlugIn(ClearSelectionPlugIn.getIcon(), this.clearSelectionPlugIn, this.clearSelectionPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        this.add(new OrCompositeTool(){

            public String getName() {
                return I18N.get((String)"JUMPConfiguration.fence");
            }
        }.add(new DrawRectangleFenceTool()).add(new DrawPolygonFenceTool()), workbenchContext);
        this.add(new FeatureInfoTool(), workbenchContext);
        frame.getToolBar().addSeparator();
        this.configureEditingButton(workbenchContext);
        frame.getToolBar().addSeparator();
        this.add(new MeasureTool(), workbenchContext);
        frame.getToolBar().addSeparator();
        frame.getToolBar().addPlugIn(this.undoPlugIn.getIcon(), this.undoPlugIn, this.undoPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        frame.getToolBar().addPlugIn(this.redoPlugIn.getIcon(), this.redoPlugIn, this.redoPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        frame.getToolBar().addSeparator();
        workbenchContext.getWorkbench().getFrame().getOutputFrame().setButton(frame.getToolBar().addPlugIn(this.outputWindowPlugIn.getIcon(), this.outputWindowPlugIn, new MultiEnableCheck(), workbenchContext));
        frame.getToolBar().addSeparator();
    }

    private void configureEditingButton(final WorkbenchContext workbenchContext) {
        final JToggleButton toggleButton = new JToggleButton();
        workbenchContext.getWorkbench().getFrame().getToolBar().add(toggleButton, this.editingPlugIn.getName(), EditingPlugIn.ICON, AbstractPlugIn.toActionListener(this.editingPlugIn, workbenchContext, new TaskMonitorManager()), null);
        workbenchContext.getWorkbench().getFrame().addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                JUMPConfiguration.this.editingPlugIn.getToolbox(workbenchContext).addComponentListener(new ComponentAdapter(){

                    public void componentShown(ComponentEvent e) {
                        toggleButton.setSelected(true);
                    }

                    public void componentHidden(ComponentEvent e) {
                        toggleButton.setSelected(false);
                    }
                });
            }
        });
    }

    private void initializeBuiltInPlugIns(WorkbenchContext workbenchContext) throws Exception {
        Field[] fields = this.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Object field = null;
            try {
                field = fields[i].get(this);
            }
            catch (IllegalAccessException e) {
                Assert.shouldNeverReachHere();
            }
            if (!(field instanceof PlugIn)) continue;
            PlugIn plugIn = (PlugIn)field;
            plugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        }
    }
}

