/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.style.decoration;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.LineStringEndpointStyle;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.Icon;

public class ArrowLineStringMiddlepointStyle
extends LineStringEndpointStyle {
    private static final double SMALL_ANGLE = 10.0;
    private static final double MEDIUM_ANGLE = 30.0;
    private static final double MEDIUM_LENGTH = 10.0;
    private static final double LARGE_LENGTH = 15.0;
    private boolean filled;
    private double finAngle;
    protected double finLength;

    public ArrowLineStringMiddlepointStyle(String name, boolean start, String iconFile, double finAngle, double finLength, boolean filled) {
        super(name, (Icon)IconLoader.icon((String)iconFile), start);
        this.finAngle = finAngle;
        this.finLength = finLength;
        this.filled = filled;
    }

    private GeneralPath arrowhead(Point2D shaftTip, Point2D shaftTail, double finLength, double finAngle) {
        GeneralPath arrowhead = new GeneralPath();
        Point2D finTip1 = this.fin(shaftTip, shaftTail, finLength, finAngle);
        Point2D finTip2 = this.fin(shaftTip, shaftTail, finLength, -finAngle);
        arrowhead.moveTo((float)finTip1.getX(), (float)finTip1.getY());
        arrowhead.lineTo((float)shaftTip.getX(), (float)shaftTip.getY());
        arrowhead.lineTo((float)finTip2.getX(), (float)finTip2.getY());
        return arrowhead;
    }

    private Point2D fin(Point2D shaftTip, Point2D shaftTail, double length, double angle) {
        double shaftLength = shaftTip.distance(shaftTail);
        Point2D finTail = shaftTip;
        Point2D finTip = GUIUtil.add((Point2D)GUIUtil.multiply((Point2D)GUIUtil.subtract((Point2D)shaftTail, (Point2D)shaftTip), (double)(length / shaftLength)), (Point2D)finTail);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(angle * Math.PI / 180.0, finTail.getX(), finTail.getY());
        return affineTransform.transform(finTip, null);
    }

    protected void paint(Point2D terminal, Point2D next, Viewport viewport, Graphics2D graphics) throws NoninvertibleTransformException {
        if (terminal.equals(next)) {
            return;
        }
        graphics.setColor(this.lineColorWithAlpha);
        graphics.setStroke(this.stroke);
        Point middle = new Point();
        ((Point2D)middle).setLocation((terminal.getX() + next.getX()) / 2.0, (terminal.getY() + next.getY()) / 2.0);
        GeneralPath arrowhead = this.arrowhead(middle, next, this.finLength, this.finAngle);
        if (this.filled) {
            arrowhead.closePath();
            graphics.fill(arrowhead);
        }
        graphics.draw(arrowhead);
    }

    public static class NarrowSolidMiddle
    extends ArrowLineStringMiddlepointStyle {
        public NarrowSolidMiddle() {
            super(I18N.get("ui.renderer.style.ArrowLineStringMiddlepointStyle.Middle-Arrow-Solid-Narrow"), false, "ArrowEndSolidNarrow.gif", 10.0, 15.0, true);
        }
    }
}

