/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.generalization;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.tools.AttributeMapping;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import org.openjump.core.geomutils.algorithm.IntersectGeometries;
import org.openjump.core.graph.polygongraph.PolygonGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplifyPolygonCoveragePlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private String sName = "Simplify Polygon Coverage";
    private String sSidebar = "Simplifies the outlines of polygons that have adjacent polygons.";
    private String note = "Note, if the simplification destroys the topology, then try to simplify iteratively.";
    private String sCreateGraph = "create graph";
    private String sSimplify = "simplify";
    private String LAYERREGIONS = "select layer with polygons";
    private static String T3 = "Maximum point displacement in model units";
    private String sSimplificationFinalized = "simplification finalized";
    private String sPolygonize = "Polygonization";
    private FeatureCollection regions = null;
    private Layer input = null;
    private MultiInputDialog dialog;
    private double tolerance = 0.0;

    public void initialize(PlugInContext context) throws Exception {
        this.sName = I18N.get("org.openjump.core.ui.plugin.tools.SimplifyPolygonCoveragePlugIn.Simplify-Polygon-Coverage");
        this.note = I18N.get("org.openjump.core.ui.plugin.tools.SimplifyPolygonCoveragePlugIn.note");
        this.sSidebar = I18N.get("org.openjump.core.ui.plugin.tools.SimplifyPolygonCoveragePlugIn.Simplifies-the-outlines-of-polygons-that-have-adjacent-polygons");
        this.sCreateGraph = I18N.get("org.openjump.core.ui.plugin.tools.ExtractCommonBoundaryBetweenPolysPlugIn.create-graph");
        this.LAYERREGIONS = I18N.get("org.openjump.core.ui.plugin.tools.ExtractCommonBoundaryBetweenPolysPlugIn.select-layer-with-polygons");
        this.sSimplify = I18N.get("ui.plugin.analysis.GeometryFunction.Simplify-(D-P)");
        T3 = I18N.get("org.openjump.core.ui.plugin.tools.LineSimplifyJTS15AlgorithmPlugIn.Maximum-point-displacement-in-model-units");
        this.sSimplificationFinalized = I18N.get("org.openjump.core.ui.plugin.tools.LineSimplifyJTS15AlgorithmPlugIn.simplification-finalized");
        this.sPolygonize = I18N.get("jump.plugin.edit.PolygonizerPlugIn.Polygonization");
        this.sSidebar = this.sSidebar + " " + this.note;
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_GENERALIZATION}, this.sName + "...", false, null, (EnableCheck)SimplifyPolygonCoveragePlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.initDialog(context);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.input = this.dialog.getLayer(this.LAYERREGIONS);
        this.regions = this.input.getFeatureCollectionWrapper();
        this.tolerance = this.dialog.getDouble(T3);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        System.gc();
        monitor.allowCancellationRequests();
        List features = this.regions.getFeatures();
        Feature firstFeature = (Feature)features.iterator().next();
        if (firstFeature.getGeometry() instanceof Polygon) {
            monitor.report(this.sCreateGraph);
            PolygonGraph pg = new PolygonGraph(features, monitor);
            FeatureCollection boundaries = pg.getSharedBoundaries();
            boundaries.addAll(pg.getNonSharedBoundaries().getFeatures());
            if (monitor.isCancelRequested()) {
                return;
            }
            monitor.report(this.sSimplify);
            int count = 0;
            int noItems = boundaries.size();
            Iterator iterator = boundaries.iterator();
            while (iterator.hasNext()) {
                Feature edge = (Feature)iterator.next();
                Geometry resultgeom = TopologyPreservingSimplifier.simplify((Geometry)edge.getGeometry(), (double)Math.abs(this.tolerance));
                edge.setGeometry(resultgeom);
                String mytext = ++count + " / " + noItems + " : " + this.sSimplificationFinalized;
                monitor.report(mytext);
                if (!monitor.isCancelRequested()) continue;
                return;
            }
            monitor.report(this.sPolygonize);
            ArrayList<Geometry> lines = new ArrayList<Geometry>();
            Iterator iterator2 = boundaries.iterator();
            while (iterator2.hasNext()) {
                Feature edge = (Feature)iterator2.next();
                lines.add(edge.getGeometry());
            }
            Collection nodedLines = IntersectGeometries.nodeLines(lines);
            Polygonizer polygonizer = new Polygonizer();
            for (Geometry g : nodedLines) {
                polygonizer.add(g);
                if (!monitor.isCancelRequested()) continue;
                return;
            }
            Collection withoutIntersection = polygonizer.getPolygons();
            FeatureCollection resultD = this.transferAttributesFromPolysToPolys(this.regions, withoutIntersection, context, monitor);
            context.addLayer(StandardCategoryNames.RESULT, this.input + "-" + this.sSimplify, resultD);
        } else {
            context.getWorkbenchFrame().warnUser("no (simple) polygon geometries found");
        }
    }

    private void initDialog(PlugInContext context) {
        this.dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.sName, true);
        this.dialog.setSideBarDescription(this.sSidebar);
        try {
            JComboBox addLayerComboBoxRegions = this.dialog.addLayerComboBox(this.LAYERREGIONS, context.getCandidateLayer(0), null, context.getLayerManager());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.dialog.addDoubleField(T3, 1.0, 5);
        GUIUtil.centreOnWindow((Component)this.dialog);
    }

    public FeatureCollection transferAttributesFromPolysToPolys(FeatureCollection fcA, Collection<Geometry> geometries, PlugInContext context, TaskMonitor monitor) {
        STRtree treeA = new STRtree();
        Iterator iterator = fcA.iterator();
        while (iterator.hasNext()) {
            Feature f = (Feature)iterator.next();
            treeA.insert(f.getGeometry().getEnvelopeInternal(), (Object)f);
        }
        AttributeMapping mapping = new AttributeMapping(fcA.getFeatureSchema(), new FeatureSchema());
        FeatureDataset fd = new FeatureDataset(mapping.createSchema("Geometry"));
        for (Geometry geom : geometries) {
            Point pt = geom.getInteriorPoint();
            BasicFeature f = new BasicFeature(fd.getFeatureSchema());
            Feature featureA = null;
            Feature featureB = null;
            List candidatesA = treeA.query(pt.getEnvelopeInternal());
            int foundCountA = 0;
            for (Feature ftemp : candidatesA) {
                if (!ftemp.getGeometry().contains((Geometry)pt)) continue;
                ++foundCountA;
                featureA = ftemp;
            }
            if (foundCountA > 1) {
                if (context != null) {
                    context.getWorkbenchFrame().warnUser(I18N.get("org.openjump.plugin.tools.IntersectPolygonLayersPlugIn.Found-more-than-one-source-feature-in-Layer") + " " + GenericNames.LAYER_A);
                }
            } else if (foundCountA != 0 || context != null) {
                // empty if block
            }
            if (foundCountA > 0) {
                mapping.transferAttributes(featureA, featureB, f);
                f.setGeometry((Geometry)geom.clone());
                fd.add(f);
            }
            if (monitor == null || !monitor.isCancelRequested()) continue;
            return fd;
        }
        return fd;
    }
}

