/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.analysis.onelayer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.tools.AttributeMapping;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openjump.core.geomutils.algorithm.GeometryConverter;
import org.openjump.core.geomutils.algorithm.IntersectGeometries;

public class IntersectPolygonsOneLayerPlugIn
extends ThreadedBasePlugIn {
    private static final String LAYER1 = GenericNames.LAYER_A;
    private static final String sTRANSFER = I18N.get("org.openjump.plugin.tools.IntersectPolygonLayersPlugIn.Transfer-attributes");
    private String sDescription = "Intersects all polygon geometries in a layer. Regions that can be mapped to two source polygons will not contain attributes. Note: The Planar Graph function provides similar functionality.";
    private PlugInContext context;
    private Layer layer1 = null;
    private boolean exceptionThrown = false;
    private boolean transferAtt = true;

    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS, MenuNames.ONELAYER}, this.getName() + "...", false, null, (EnableCheck)new MultiEnableCheck().add(new EnableCheckFactory(context.getWorkbenchContext()).createTaskWindowMustBeActiveCheck()).add(new EnableCheckFactory(context.getWorkbenchContext()).createAtLeastNLayersMustExistCheck(2)));
        this.sDescription = I18N.get("org.openjump.plugin.tools.analysis.onelayer.IntersectPolygonsOneLayerPlugIn.sDescription");
    }

    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), true);
        if (this.layer1 == null) {
            this.layer1 = context.getCandidateLayer(0);
        }
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow((Component)dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    public String getName() {
        return I18N.get("org.openjump.plugin.tools.analysis.onelayer.IntersectPolygonsOneLayerPlugIn.Intersect-Polygons");
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.context = context;
        monitor.allowCancellationRequests();
        FeatureSchema featureSchema = new FeatureSchema();
        FeatureCollection resultColl = this.runIntersectionNew(this.layer1.getFeatureCollectionWrapper(), this.transferAtt, monitor, context);
        if (resultColl != null && resultColl.size() > 0) {
            context.addLayer(StandardCategoryNames.RESULT, I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.intersection") + "-" + this.layer1.getName(), resultColl);
        }
        if (this.exceptionThrown) {
            context.getWorkbenchFrame().warnUser(I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.Error-while-executing-spatial-function"));
        }
    }

    private FeatureCollection runIntersectionNew(FeatureCollection fcA, boolean transferAttributes, TaskMonitor monitor, PlugInContext context) {
        FeatureDataset fd = null;
        ArrayList<Geometry> geomsToCheck = new ArrayList<Geometry>();
        Iterator iterator = fcA.iterator();
        while (iterator.hasNext()) {
            Feature f = (Feature)iterator.next();
            geomsToCheck.add(f.getGeometry());
        }
        ArrayList lines = new ArrayList();
        for (Geometry geom : geomsToCheck) {
            if (geom instanceof Polygon || geom instanceof MultiPolygon) {
                lines.addAll(GeometryConverter.transformPolygonToLineStrings(geom));
                continue;
            }
            if (context != null) {
                context.getWorkbenchFrame().warnUser(I18N.get("org.openjump.plugin.tools.IntersectPolygonLayersPlugIn.Geometry-no-Polygon-or-Multi-Polygon"));
            }
            return null;
        }
        Collection nodedLines = IntersectGeometries.nodeLines(lines);
        Polygonizer polygonizer = new Polygonizer();
        for (Geometry g : nodedLines) {
            polygonizer.add(g);
        }
        Collection withoutIntersection = polygonizer.getPolygons();
        STRtree treeA = new STRtree();
        Iterator iterator2 = fcA.iterator();
        while (iterator2.hasNext()) {
            Feature f = (Feature)iterator2.next();
            treeA.insert(f.getGeometry().getEnvelopeInternal(), (Object)f);
        }
        AttributeMapping mapping = new AttributeMapping(fcA.getFeatureSchema(), new FeatureSchema());
        fd = new FeatureDataset(mapping.createSchema("Geometry"));
        Iterator iterator3 = withoutIntersection.iterator();
        while (iterator3.hasNext()) {
            boolean errorInA = false;
            Geometry geom = (Geometry)iterator3.next();
            Point pt = geom.getInteriorPoint();
            BasicFeature f = new BasicFeature(fd.getFeatureSchema());
            Feature featureA = null;
            List candidatesA = treeA.query(pt.getEnvelopeInternal());
            int foundCountA = 0;
            for (Feature ftemp : candidatesA) {
                if (!ftemp.getGeometry().contains((Geometry)pt)) continue;
                ++foundCountA;
                featureA = ftemp;
            }
            if (foundCountA > 1) {
                if (context != null) {
                    errorInA = true;
                }
            } else if (foundCountA == 0) {
                // empty if block
            }
            if (foundCountA <= 0) continue;
            if (errorInA) {
                featureA = IntersectPolygonsOneLayerPlugIn.resetFeatureValuesToNaN(featureA);
            } else {
                mapping.transferAttributes(featureA, null, f);
            }
            f.setGeometry((Geometry)geom.clone());
            fd.add(f);
        }
        return fd;
    }

    public static Feature resetFeatureValuesToNaN(Feature f) {
        Feature ftemp = f.clone(true);
        FeatureSchema fs = ftemp.getSchema();
        for (int i = 0; i < fs.getAttributeCount(); ++i) {
            AttributeType type = fs.getAttributeType(i);
            if (type.equals(AttributeType.GEOMETRY)) continue;
            if (type.equals(AttributeType.DOUBLE)) {
                ftemp.setAttribute(i, (Object)Double.NaN);
            }
            if (type.equals(AttributeType.INTEGER)) {
                ftemp.setAttribute(i, (Object)Double.NaN);
            }
            if (type.equals(AttributeType.STRING)) {
                ftemp.setAttribute(i, (Object)"NaN");
            }
            if (type.equals(AttributeType.OBJECT)) {
                ftemp.setAttribute(i, null);
            }
            if (!type.equals(AttributeType.DATE)) continue;
            ftemp.setAttribute(i, null);
        }
        return ftemp;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(this.sDescription);
        dialog.addLayerComboBox(LAYER1, this.layer1, context.getLayerManager());
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer1 = dialog.getLayer(LAYER1);
    }
}

