/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.Range;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorScheme;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.LabelStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MultiRingBufferSelectedPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static String BUFFER;
    private static String LAYER;
    private static String NEWLAYERNAME;
    private static String LABEL;
    private static String THEMING;
    private static String LAYERNAME;
    private static String ATTRIBUTENAME;
    private static String ATTRIBUTEVALUE;
    private static String BUFFERDISTANCE;
    private static String BUFFERNUMBER;
    private static String DISTANCEATTRIBUTE;
    private static String LAYEROPTIONS;
    private static String BUFFEROPTIONS;
    private static String SELECTED_ONLY;
    private static String MULTIPLE_RING_BUFFER;
    private static String sRESET;
    private static String layerName;
    private static String attributeName;
    private static boolean enableTheming;
    private static boolean enableRanging;
    private static boolean enableLabeling;
    private JSpinner bufferSpinner;
    private boolean exceptionThrown = false;
    private static String[] bufferDistances;
    private static String[] bufferAttributeValues;
    private int currBufferNumber = 1;
    private JTextField currBufferDistance;
    private JTextField currAttributeValue;

    public void initialize(PlugInContext context) throws Exception {
        MULTIPLE_RING_BUFFER = I18N.get("org.openjump.core.ui.plugin.tools.MultiRingBufferSelectedPlugIn.Multiple-Ring-Buffer");
        context.getFeatureInstaller().addMainMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_GENERATE}, MULTIPLE_RING_BUFFER + "...", false, null, (EnableCheck)this.createEnableCheck(context.getWorkbenchContext()));
    }

    public boolean execute(PlugInContext context) throws Exception {
        MULTIPLE_RING_BUFFER = I18N.get("org.openjump.core.ui.plugin.tools.MultiRingBufferSelectedPlugIn.Multiple-Ring-Buffer");
        sRESET = I18N.get("org.openjump.core.ui.plugin.tools.MultiRingBufferSelectedPlugIn.Reset-all-buffer-options");
        SELECTED_ONLY = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Use-selected-features-only");
        BUFFERDISTANCE = I18N.get("ui.plugin.analysis.BufferPlugIn.buffer-distance");
        BUFFER = I18N.get("com.vividsolutions.jump.workbench.ui.plugin.analysis.BufferPlugIn");
        NEWLAYERNAME = BUFFER + "-" + I18N.get("ui.MenuNames.SELECTION");
        LAYER = MenuNames.LAYER;
        layerName = NEWLAYERNAME;
        String options = I18N.get("com.vividsolutions.jump.workbench.ui.plugin.OptionsPlugIn");
        LAYEROPTIONS = LAYER + " " + options + ":";
        BUFFEROPTIONS = BUFFER + " " + options + ":";
        LABEL = I18N.get("ui.style.LabelStylePanel.labels");
        THEMING = I18N.get("ui.renderer.style.ColorThemingPanel.colour-theming");
        String name = I18N.get("jump.workbench.ui.plugin.datastore.ConnectionDescriptorPanel.Name");
        LAYERNAME = LAYER + " " + name;
        String attribute = I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.attribute");
        ATTRIBUTENAME = attribute + " " + name;
        ATTRIBUTEVALUE = BUFFER + " " + LABEL;
        BUFFERNUMBER = BUFFER + " Number";
        DISTANCEATTRIBUTE = I18N.get("org.openjump.core.ui.plugin.tools.MeasureM_FTool.Distance");
        MultiInputDialog dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow((Component)dialog);
        boolean goodEntry = false;
        while (!goodEntry) {
            dialog.setVisible(true);
            if (!dialog.wasOKPressed()) {
                return false;
            }
            goodEntry = this.getDialogValues(dialog);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        if (!DISTANCEATTRIBUTE.equalsIgnoreCase(attributeName)) {
            featureSchema.addAttribute(DISTANCEATTRIBUTE, AttributeType.DOUBLE);
        }
        featureSchema.addAttribute(attributeName, AttributeType.STRING);
        FeatureDataset featureDataset = new FeatureDataset(featureSchema);
        Collection selectedCategories = context.getLayerNamePanel().getSelectedCategories();
        Layer layer = context.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.WORKING : selectedCategories.iterator().next().toString(), layerName, (FeatureCollection)featureDataset);
        layer.setFeatureCollectionModified(true).setEditable(true);
        Collection selectedFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        Collection bufferCollection = this.getBuffers(featureSchema, selectedFeatures);
        Iterator i = bufferCollection.iterator();
        while (i.hasNext()) {
            layer.getFeatureCollectionWrapper().add((Feature)i.next());
        }
        if (enableLabeling) {
            LabelStyle labelStyle = layer.getLabelStyle();
            labelStyle.setAttribute(attributeName);
            labelStyle.setVerticalAlignment("ON_LINE");
            labelStyle.setEnabled(true);
        }
        ColorScheme colorScheme = ColorScheme.create((String)"spectral (ColorBrewer)");
        AbstractMap attributeToStyleMap = new HashMap();
        if (enableTheming) {
            for (Feature feature : bufferCollection) {
                attributeToStyleMap.put((String)feature.getAttribute(attributeName), new BasicStyle(colorScheme.next()));
            }
        } else if (enableRanging) {
            colorScheme = ColorScheme.create((String)"Reds (ColorBrewer)");
            attributeToStyleMap = new Range.RangeTreeMap();
            Object previousValue = null;
            Iterator i2 = bufferCollection.iterator();
            while (i2.hasNext()) {
                Object value = ((Feature)i2.next()).getAttribute(attributeName);
                try {
                    if (previousValue == null) continue;
                    attributeToStyleMap.put(new Range(previousValue, true, value, false), new BasicStyle(colorScheme.next()));
                }
                finally {
                    previousValue = value;
                }
            }
            attributeToStyleMap.put(new Range(previousValue, true, new Range.PositiveInfinity(), false), new BasicStyle(colorScheme.next()));
        }
        if (enableTheming) {
            layer.getBasicStyle().setEnabled(false);
            ColorThemingStyle themeStyle = new ColorThemingStyle(attributeName, attributeToStyleMap, new BasicStyle(Color.gray));
            themeStyle.setEnabled(true);
            layer.addStyle((Style)themeStyle);
            ColorThemingStyle.get((Layer)layer).setEnabled(enableTheming);
            layer.removeStyle((Style)ColorThemingStyle.get((Layer)layer));
            ColorThemingStyle.get((Layer)layer).setEnabled(true);
            layer.getBasicStyle().setEnabled(false);
        }
        if (this.exceptionThrown) {
            context.getWorkbenchFrame().warnUser("Errors found while executing buffer");
        }
    }

    private Collection getBuffers(FeatureSchema featureSchema, Collection selectedFeatures) {
        this.exceptionThrown = false;
        ArrayList<BasicFeature> bufferFeatureCollection = new ArrayList<BasicFeature>();
        Geometry prevGeo = null;
        Iterator ia = selectedFeatures.iterator();
        prevGeo = ((Feature)selectedFeatures.iterator().next()).getGeometry();
        while (ia.hasNext()) {
            prevGeo = prevGeo.union(((Feature)ia.next()).getGeometry());
        }
        for (int bufferNum = 0; bufferNum < bufferDistances.length; ++bufferNum) {
            Geometry bufferGeo = null;
            double bufferDistance = Double.parseDouble(bufferDistances[bufferNum]);
            if (!(bufferDistance > 0.0)) continue;
            ia = selectedFeatures.iterator();
            Geometry featureGeo = ((Feature)selectedFeatures.iterator().next()).getGeometry();
            bufferGeo = this.getBuffer(featureGeo, bufferDistance);
            while (ia.hasNext()) {
                featureGeo = ((Feature)ia.next()).getGeometry();
                Geometry result = this.getBuffer(featureGeo, bufferDistance);
                if (result == null) continue;
                bufferGeo = bufferGeo.union(result);
            }
            BasicFeature bufferFeature = new BasicFeature(featureSchema);
            bufferFeature.setGeometry(bufferGeo.difference(prevGeo));
            bufferFeature.setAttribute(DISTANCEATTRIBUTE, (Object)new Double(bufferDistances[bufferNum]));
            bufferFeature.setAttribute(attributeName, (Object)bufferAttributeValues[bufferNum]);
            bufferFeatureCollection.add(bufferFeature);
            prevGeo = bufferGeo;
        }
        return bufferFeatureCollection;
    }

    private Geometry getBuffer(Geometry a, double distance) {
        Geometry result = null;
        try {
            result = a.buffer(distance);
            return result;
        }
        catch (RuntimeException ex) {
            this.exceptionThrown = true;
            return null;
        }
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(SELECTED_ONLY);
        dialog.addSeparator();
        dialog.addLabel(LAYEROPTIONS);
        dialog.addSeparator();
        dialog.addTextField(LAYERNAME, layerName, 30, null, "");
        dialog.addTextField(ATTRIBUTENAME, attributeName, 30, null, "");
        dialog.addCheckBox(LABEL, enableLabeling, "");
        dialog.addCheckBox(THEMING, enableTheming, "");
        dialog.addSeparator();
        dialog.addLabel(BUFFEROPTIONS);
        dialog.addSeparator();
        int maxVal = bufferDistances.length;
        SpinnerNumberModel bufferSpinnerModel = new SpinnerNumberModel(1, 1, maxVal, 1);
        this.bufferSpinner = new JSpinner(bufferSpinnerModel);
        this.bufferSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSpinner spinner = (JSpinner)e.getSource();
                int spinVal = (Integer)spinner.getValue();
                bufferDistances[((MultiRingBufferSelectedPlugIn)MultiRingBufferSelectedPlugIn.this).currBufferNumber - 1] = MultiRingBufferSelectedPlugIn.this.currBufferDistance.getText().trim();
                bufferAttributeValues[((MultiRingBufferSelectedPlugIn)MultiRingBufferSelectedPlugIn.this).currBufferNumber - 1] = MultiRingBufferSelectedPlugIn.this.currAttributeValue.getText().trim();
                MultiRingBufferSelectedPlugIn.this.currBufferNumber = spinVal;
                MultiRingBufferSelectedPlugIn.this.currBufferDistance.setText("" + bufferDistances[spinVal - 1]);
                MultiRingBufferSelectedPlugIn.this.currAttributeValue.setText(bufferAttributeValues[spinVal - 1]);
            }
        });
        dialog.addRow(BUFFERNUMBER, (JComponent)new JLabel(BUFFERNUMBER), (JComponent)this.bufferSpinner, null, "");
        this.currBufferDistance = dialog.addTextField(BUFFERDISTANCE, bufferDistances[0], 10, null, "");
        this.currAttributeValue = dialog.addTextField(ATTRIBUTEVALUE, bufferAttributeValues[0], 30, null, "");
        JButton resetButton = dialog.addButton(sRESET);
        resetButton.addActionListener(new ResetButtonListener());
        this.currBufferNumber = 1;
        this.currBufferDistance.setText("" + bufferDistances[this.currBufferNumber - 1]);
        this.currAttributeValue.setText(bufferAttributeValues[this.currBufferNumber - 1]);
    }

    private boolean getDialogValues(MultiInputDialog dialog) {
        int spinVal = (Integer)this.bufferSpinner.getValue();
        MultiRingBufferSelectedPlugIn.bufferDistances[spinVal - 1] = this.currBufferDistance.getText().trim();
        MultiRingBufferSelectedPlugIn.bufferAttributeValues[spinVal - 1] = this.currAttributeValue.getText().trim();
        layerName = dialog.getText(LAYERNAME);
        attributeName = dialog.getText(ATTRIBUTENAME);
        enableLabeling = dialog.getCheckBox(LABEL).isSelected();
        enableTheming = dialog.getCheckBox(THEMING).isSelected();
        int bufNum = 0;
        try {
            for (bufNum = 0; bufNum < bufferDistances.length; ++bufNum) {
                double bufDist = Double.parseDouble(bufferDistances[bufNum]);
                if (!(bufDist < 0.0)) continue;
                this.reportValidationError(dialog, BUFFER + " #" + (bufNum + 1) + " < 0.");
                return false;
            }
        }
        catch (NumberFormatException e) {
            this.reportValidationError(dialog, "\"" + bufferDistances[bufNum] + "\" is an invalid double for buffer distance #" + (bufNum + 1) + ".");
            return false;
        }
        return true;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNFeaturesMustHaveSelectedItemsCheck(1));
    }

    private void reportValidationError(MultiInputDialog dialog, String errorMessage) {
        JOptionPane.showMessageDialog((Component)dialog, errorMessage, "JUMP", 0);
    }

    static {
        attributeName = "Label";
        enableTheming = true;
        enableRanging = false;
        enableLabeling = true;
        bufferDistances = new String[]{"10", "50", "100", "250", "0", "0", "0", "0", "0", "0"};
        bufferAttributeValues = new String[]{"A", "B", "C", "D", "", "", "", "", "", ""};
    }

    private class ResetButtonListener
    implements ActionListener {
        private ResetButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            MultiRingBufferSelectedPlugIn.this.currBufferNumber = 1;
            MultiRingBufferSelectedPlugIn.this.bufferSpinner.setValue(new Integer(MultiRingBufferSelectedPlugIn.this.currBufferNumber));
            for (int i = 0; i < bufferDistances.length; ++i) {
                bufferDistances[i] = "0";
                bufferAttributeValues[i] = "";
            }
            MultiRingBufferSelectedPlugIn.this.currBufferDistance.setText("" + bufferDistances[MultiRingBufferSelectedPlugIn.this.currBufferNumber - 1]);
            MultiRingBufferSelectedPlugIn.this.currAttributeValue.setText(bufferAttributeValues[MultiRingBufferSelectedPlugIn.this.currBufferNumber - 1]);
        }
    }
}

