/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.tools.AttributeMapping;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openjump.core.geomutils.algorithm.GeometryConverter;
import org.openjump.core.geomutils.algorithm.IntersectGeometries;

public class IntersectPolygonLayersPlugIn
extends ThreadedBasePlugIn {
    private static final String LAYER1 = GenericNames.LAYER_A;
    private static final String LAYER2 = GenericNames.LAYER_B;
    private static final String sTRANSFER = I18N.get("org.openjump.plugin.tools.IntersectPolygonLayersPlugIn.Transfer-attributes");
    private String sDescription = "Intersects all geometries of two layers that contain both polygons. Note: The Planar Graph function provides similar functionality.";
    private static final String sAccurracy = "Set calculation accuray in map units";
    private MultiInputDialog dialog;
    private Layer layer1 = null;
    private Layer layer2 = null;
    private String methodNameToRun;
    private boolean exceptionThrown = false;
    private PlugInContext context = null;
    private boolean transferAtt = true;
    private double accurracy = 0.01;

    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS, MenuNames.TWOLAYERS}, this.getName(), false, null, (EnableCheck)new MultiEnableCheck().add(new EnableCheckFactory(context.getWorkbenchContext()).createTaskWindowMustBeActiveCheck()).add(new EnableCheckFactory(context.getWorkbenchContext()).createAtLeastNLayersMustExistCheck(2)));
        this.sDescription = I18N.get("org.openjump.plugin.tools.IntersectPolygonLayersPlugIn.sDescrition");
    }

    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), true);
        if (this.layer1 == null) {
            this.layer1 = context.getCandidateLayer(0);
            this.layer2 = context.getCandidateLayer(0);
        }
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow((Component)dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    public String getName() {
        return I18N.get("org.openjump.plugin.tools.IntersectPolygonLayersPlugIn.Intersect-Polygon-Layers") + "...";
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.context = context;
        monitor.allowCancellationRequests();
        FeatureSchema featureSchema = new FeatureSchema();
        FeatureCollection resultColl = this.runIntersectionNew(this.layer1.getFeatureCollectionWrapper(), this.layer2.getFeatureCollectionWrapper(), this.transferAtt, monitor, context);
        if (resultColl != null && resultColl.size() > 0) {
            context.addLayer(StandardCategoryNames.RESULT, I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.intersection") + "-" + this.layer1.getName() + "-" + this.layer2.getName(), resultColl);
        }
        if (this.exceptionThrown) {
            context.getWorkbenchFrame().warnUser(I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.Error-while-executing-spatial-function"));
        }
    }

    private FeatureCollection runIntersectionNew(FeatureCollection fcA, FeatureCollection fcB, boolean transferAttributes, TaskMonitor monitor, PlugInContext context) {
        Feature f;
        FeatureDataset fd = null;
        ArrayList<Geometry> geomsToCheck = new ArrayList<Geometry>();
        Iterator iterator = fcA.iterator();
        while (iterator.hasNext()) {
            f = (Feature)iterator.next();
            geomsToCheck.add(f.getGeometry());
        }
        iterator = fcB.iterator();
        while (iterator.hasNext()) {
            f = (Feature)iterator.next();
            geomsToCheck.add(f.getGeometry());
        }
        ArrayList lines = new ArrayList();
        for (Geometry geom : geomsToCheck) {
            if (geom instanceof Polygon || geom instanceof MultiPolygon) {
                lines.addAll(GeometryConverter.transformPolygonToLineStrings(geom));
                continue;
            }
            if (context != null) {
                context.getWorkbenchFrame().warnUser(I18N.get("org.openjump.plugin.tools.IntersectPolygonLayersPlugIn.Geometry-no-Polygon-or-Multi-Polygon"));
            }
            return null;
        }
        Collection nodedLines = IntersectGeometries.nodeLines(lines);
        Polygonizer polygonizer = new Polygonizer();
        for (Geometry g : nodedLines) {
            polygonizer.add(g);
        }
        Collection withoutIntersection = polygonizer.getPolygons();
        STRtree treeA = new STRtree();
        Iterator iterator2 = fcA.iterator();
        while (iterator2.hasNext()) {
            Feature f2 = (Feature)iterator2.next();
            treeA.insert(f2.getGeometry().getEnvelopeInternal(), (Object)f2);
        }
        STRtree treeB = new STRtree();
        Iterator iterator3 = fcB.iterator();
        while (iterator3.hasNext()) {
            Feature f3 = (Feature)iterator3.next();
            treeB.insert(f3.getGeometry().getEnvelopeInternal(), (Object)f3);
        }
        AttributeMapping mapping = new AttributeMapping(fcA.getFeatureSchema(), fcB.getFeatureSchema());
        fd = new FeatureDataset(mapping.createSchema("Geometry"));
        Iterator iterator4 = withoutIntersection.iterator();
        while (iterator4.hasNext()) {
            boolean errorInA = false;
            boolean errorInB = false;
            Geometry geom = (Geometry)iterator4.next();
            Point pt = geom.getInteriorPoint();
            BasicFeature f4 = new BasicFeature(fd.getFeatureSchema());
            Feature featureA = null;
            Feature featureB = null;
            List candidatesA = treeA.query(pt.getEnvelopeInternal());
            int foundCountA = 0;
            for (Feature ftemp : candidatesA) {
                if (!ftemp.getGeometry().contains((Geometry)pt)) continue;
                ++foundCountA;
                featureA = ftemp;
            }
            if (foundCountA > 1) {
                if (context != null) {
                    errorInA = true;
                    String errorStrg = I18N.get("org.openjump.plugin.tools.IntersectPolygonLayersPlugIn.Found-more-than-one-source-feature-in-Layer");
                    context.getWorkbenchFrame().warnUser(errorStrg + " " + GenericNames.LAYER_A);
                    context.getWorkbenchFrame().getOutputFrame().createNewDocument();
                    context.getWorkbenchFrame().getOutputFrame().addText("IntersectPolygonLayersPlugIn: " + errorStrg + ": " + GenericNames.LAYER_A + ". Reason: The Layer contains probably objects that overlay each other. Will set polygon values of item with FID: " + f4.getID() + " to NaN. Use i)" + I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.Transfer-Attributes") + " or ii)" + I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.Join-Attributes-Spatially") + " functions to obtain atributes from " + GenericNames.LAYER_A);
                }
            } else if (foundCountA != 0 || context != null) {
                // empty if block
            }
            List candidatesB = treeB.query(pt.getEnvelopeInternal());
            int foundCountB = 0;
            for (Feature ftemp : candidatesB) {
                if (!ftemp.getGeometry().contains((Geometry)pt)) continue;
                ++foundCountB;
                featureB = ftemp;
            }
            if (foundCountB > 1) {
                if (context != null) {
                    errorInB = true;
                    String errorStrg = I18N.get("org.openjump.plugin.tools.IntersectPolygonLayersPlugIn.Found-more-than-one-source-feature-in-Layer");
                    context.getWorkbenchFrame().warnUser(errorStrg + " " + GenericNames.LAYER_B);
                    context.getWorkbenchFrame().getOutputFrame().createNewDocument();
                    context.getWorkbenchFrame().getOutputFrame().addText("IntersectPolygonLayersPlugIn: " + errorStrg + ": " + GenericNames.LAYER_B + ". Reason: The Layer contains probably objects that overlay each other. Will set polygon values of item with FID: " + f4.getID() + " to NaN. Use " + I18N.get("org.openjump.sigle.plugin.SpatialJoinPlugIn.Transfer-Attributes") + " or " + I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.Join-Attributes-Spatially") + " functions to obtain atributes from " + GenericNames.LAYER_B);
                }
            } else if (foundCountB != 0 || context != null) {
                // empty if block
            }
            if (foundCountA <= 0 && foundCountB <= 0) continue;
            if (errorInA) {
                featureA = IntersectPolygonLayersPlugIn.resetFeatureValuesToNaN(featureA);
            }
            if (errorInB) {
                featureB = IntersectPolygonLayersPlugIn.resetFeatureValuesToNaN(featureB);
            }
            mapping.transferAttributes(featureA, featureB, f4);
            f4.setGeometry((Geometry)geom.clone());
            fd.add(f4);
        }
        return fd;
    }

    public static Feature resetFeatureValuesToNaN(Feature f) {
        Feature ftemp = f.clone(true);
        FeatureSchema fs = ftemp.getSchema();
        for (int i = 0; i < fs.getAttributeCount(); ++i) {
            AttributeType type = fs.getAttributeType(i);
            if (type.equals(AttributeType.GEOMETRY)) continue;
            if (type.equals(AttributeType.DOUBLE)) {
                ftemp.setAttribute(i, (Object)Double.NaN);
            }
            if (type.equals(AttributeType.INTEGER)) {
                ftemp.setAttribute(i, (Object)Double.NaN);
            }
            if (type.equals(AttributeType.STRING)) {
                ftemp.setAttribute(i, (Object)"NaN");
            }
            if (type.equals(AttributeType.OBJECT)) {
                ftemp.setAttribute(i, null);
            }
            if (!type.equals(AttributeType.DATE)) continue;
            ftemp.setAttribute(i, null);
        }
        return ftemp;
    }

    private FeatureCollection runIntersectionOld(FeatureCollection fcA, FeatureCollection fcB, double accurracy, boolean transferAttributes, TaskMonitor monitor, PlugInContext context) {
        Feature f;
        FeatureCollection fd = null;
        ArrayList<Geometry> geomsToCheck = new ArrayList<Geometry>();
        Iterator iterator = fcA.iterator();
        while (iterator.hasNext()) {
            f = (Feature)iterator.next();
            geomsToCheck.add(f.getGeometry());
        }
        iterator = fcB.iterator();
        while (iterator.hasNext()) {
            f = (Feature)iterator.next();
            geomsToCheck.add(f.getGeometry());
        }
        for (Geometry geom : geomsToCheck) {
            if (geom instanceof Polygon || geom instanceof MultiPolygon) continue;
            if (context != null) {
                context.getWorkbenchFrame().warnUser(I18N.get("org.openjump.plugin.tools.IntersectPolygonLayersPlugIn.Geometry-no-Polygon-or-Multi-Polygon"));
            }
            return null;
        }
        ArrayList<Geometry> withoutIntersection = IntersectGeometries.intersectPolygons(geomsToCheck, accurracy, monitor, context);
        if (!transferAttributes) {
            fd = FeatureDatasetFactory.createFromGeometry(withoutIntersection);
            return fd;
        }
        if (monitor != null) {
            monitor.report(sTRANSFER);
        }
        STRtree treeA = new STRtree();
        Iterator iterator2 = fcA.iterator();
        while (iterator2.hasNext()) {
            Feature f2 = (Feature)iterator2.next();
            treeA.insert(f2.getGeometry().getEnvelopeInternal(), (Object)f2);
        }
        STRtree treeB = new STRtree();
        Iterator iterator3 = fcB.iterator();
        while (iterator3.hasNext()) {
            Feature f3 = (Feature)iterator3.next();
            treeB.insert(f3.getGeometry().getEnvelopeInternal(), (Object)f3);
        }
        AttributeMapping mapping = new AttributeMapping(fcA.getFeatureSchema(), fcB.getFeatureSchema());
        fd = new FeatureDataset(mapping.createSchema("Geometry"));
        for (Geometry geom : withoutIntersection) {
            Point pt = geom.getInteriorPoint();
            BasicFeature f4 = new BasicFeature(fd.getFeatureSchema());
            Feature featureA = null;
            Feature featureB = null;
            List candidatesA = treeA.query(pt.getEnvelopeInternal());
            int foundCountA = 0;
            for (Feature ftemp : candidatesA) {
                if (!ftemp.getGeometry().contains((Geometry)pt)) continue;
                ++foundCountA;
                featureA = ftemp;
            }
            if (foundCountA > 1) {
                if (context != null) {
                    context.getWorkbenchFrame().warnUser(I18N.get("org.openjump.plugin.tools.IntersectPolygonLayersPlugIn.Found-more-than-one-source-feature-in-Layer") + " " + GenericNames.LAYER_A);
                }
            } else if (foundCountA != 0 || context != null) {
                // empty if block
            }
            List candidatesB = treeB.query(pt.getEnvelopeInternal());
            int foundCountB = 0;
            for (Feature ftemp : candidatesB) {
                if (!ftemp.getGeometry().contains((Geometry)pt)) continue;
                ++foundCountB;
                featureB = ftemp;
            }
            if (foundCountB > 1) {
                if (context != null) {
                    context.getWorkbenchFrame().warnUser(I18N.get("org.openjump.plugin.tools.IntersectPolygonLayersPlugIn.Found-more-than-one-source-feature-in-Layer") + " " + GenericNames.LAYER_B);
                }
            } else if (foundCountB != 0 || context != null) {
                // empty if block
            }
            mapping.transferAttributes(featureA, featureB, f4);
            f4.setGeometry((Geometry)geom.clone());
            fd.add(f4);
        }
        return fd;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(this.sDescription);
        dialog.addLayerComboBox(LAYER1, this.layer1, context.getLayerManager());
        dialog.addLayerComboBox(LAYER2, this.layer2, context.getLayerManager());
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer1 = dialog.getLayer(LAYER1);
        this.layer2 = dialog.getLayer(LAYER2);
    }
}

