/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.Frame;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class BlendLineStringsPlugIn
extends AbstractPlugIn {
    private WorkbenchContext workbenchContext;
    private String sToolTipText = "huhu!  :)";
    private String sTheBlendTolerance = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.The-blend-tolerance");
    private String sNew = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.New");
    private String TOLERANCE = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.Tolerance");
    private String sName = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.Blend-LineStrings");
    private double blendTolerance = 0.1;

    public void initialize(PlugInContext context) throws Exception {
        this.workbenchContext = context.getWorkbenchContext();
        context.getFeatureInstaller().addMainMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY}, this.sName, false, null, (EnableCheck)this.createEnableCheck(this.workbenchContext));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.sToolTipText = "huhu!  :)";
        this.sTheBlendTolerance = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.The-blend-tolerance");
        this.sNew = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.New");
        this.TOLERANCE = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.Tolerance");
        this.sName = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.Blend-LineStrings");
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        Collection selectedFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        Feature currFeature = (Feature)selectedFeatures.iterator().next();
        Collection selectedCategories = context.getLayerNamePanel().getSelectedCategories();
        LayerManager layerManager = context.getLayerManager();
        FeatureDataset newFeatures = new FeatureDataset(currFeature.getSchema());
        Vector<Geometry> inputLS = new Vector<Geometry>(selectedFeatures.size());
        for (Feature f : selectedFeatures) {
            Geometry geo = f.getGeometry();
            if (!(geo instanceof LineString)) continue;
            inputLS.add(geo);
        }
        Vector<LineString> outputLS = new Vector<LineString>(inputLS.size());
        while (inputLS.size() > 0) {
            LineString ls = (LineString)inputLS.get(0);
            CoordinateList blendedCoords = new CoordinateList(ls.getCoordinates());
            inputLS.removeElementAt(0);
            int currIndex = 0;
            while (currIndex < inputLS.size()) {
                ls = (LineString)inputLS.get(currIndex);
                CoordinateList lsCoords = new CoordinateList(ls.getCoordinates());
                if (this.blended(blendedCoords, lsCoords)) {
                    inputLS.removeElementAt(currIndex);
                    currIndex = 0;
                    continue;
                }
                ++currIndex;
            }
            outputLS.add(new GeometryFactory().createLineString(blendedCoords.toCoordinateArray()));
        }
        Iterator i = outputLS.iterator();
        while (i.hasNext()) {
            Feature newFeature = (Feature)currFeature.clone();
            newFeature.setGeometry((Geometry)((LineString)i.next()));
            newFeatures.add(newFeature);
        }
        layerManager.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.WORKING : selectedCategories.iterator().next().toString(), layerManager.uniqueLayerName(this.sNew), (FeatureCollection)newFeatures);
        layerManager.getLayer(0).setFeatureCollectionModified(true);
        layerManager.getLayer(0).setEditable(true);
        return true;
    }

    private boolean blended(CoordinateList blendedCoords, CoordinateList lsCoords) {
        Coordinate start = blendedCoords.getCoordinate(0);
        Coordinate end = blendedCoords.getCoordinate(blendedCoords.size() - 1);
        Coordinate first = lsCoords.getCoordinate(0);
        Coordinate last = lsCoords.getCoordinate(lsCoords.size() - 1);
        if (start.distance(first) < this.blendTolerance) {
            for (int i = 1; i < lsCoords.size(); ++i) {
                blendedCoords.add(0, (Object)lsCoords.getCoordinate(i));
            }
        } else if (start.distance(last) < this.blendTolerance) {
            for (int i = lsCoords.size() - 2; i >= 0; --i) {
                blendedCoords.add(0, (Object)lsCoords.getCoordinate(i));
            }
        } else if (end.distance(first) < this.blendTolerance) {
            for (int i = 1; i < lsCoords.size(); ++i) {
                blendedCoords.add((Object)lsCoords.getCoordinate(i));
            }
        } else if (end.distance(last) < this.blendTolerance) {
            for (int i = lsCoords.size() - 2; i >= 0; --i) {
                blendedCoords.add((Object)lsCoords.getCoordinate(i));
            }
        } else {
            return false;
        }
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.addDoubleField(this.TOLERANCE, this.blendTolerance, 6, this.sTheBlendTolerance);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.blendTolerance = dialog.getDouble(this.TOLERANCE);
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createOnlyOneLayerMayHaveSelectedFeaturesCheck()).add(checkFactory.createAtLeastNFeaturesMustHaveSelectedItemsCheck(2));
    }
}

