/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.sextante.OpenJUMPSextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridExtent;
import org.openjump.core.ui.plot.Plot2DPanelOJ;
import org.openjump.core.ui.plugin.raster.ShowProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileGraphTool
extends MultiClickTool {
    private static final String sDistance = I18N.get("org.openjump.core.ui.plugin.tools.MeasureM_FTool.Distance");
    private static final String sMeters = I18N.get("org.openjump.core.ui.plugin.tools.MeasureM_FTool.meters");
    private static final String sFeet = I18N.get("org.openjump.core.ui.plugin.tools.MeasureM_FTool.feet");
    private List<Coordinate> savedCoordinates = new ArrayList<Coordinate>();
    private Coordinate currCoord;
    private OpenJUMPSextanteRasterLayer rstLayer = null;
    private GeometryFactory gf = new GeometryFactory();
    private FeatureCollection resultFC = null;
    private FeatureSchema resultFSchema = null;
    private double dDist = 0.0;
    private double dHorzDist = 0.0;
    private double m_dLastX;
    private double m_dLastY;
    private double m_dLastZ;
    private int nPoints = 0;

    public ProfileGraphTool() {
        this.allowSnapping();
        this.resultFSchema = new FeatureSchema();
        this.resultFSchema.addAttribute("geometry", AttributeType.GEOMETRY);
        this.resultFSchema.addAttribute("X", AttributeType.DOUBLE);
        this.resultFSchema.addAttribute("Y", AttributeType.DOUBLE);
        this.resultFSchema.addAttribute("Z", AttributeType.DOUBLE);
        this.resultFSchema.addAttribute("PlaneDist", AttributeType.DOUBLE);
        this.resultFSchema.addAttribute("TerrainDist", AttributeType.DOUBLE);
        this.resultFC = new FeatureDataset(this.resultFSchema);
    }

    public Icon getIcon() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("RulerM_F.gif"));
    }

    public Cursor getCursor() {
        for (int i = 0; i < this.savedCoordinates.size(); ++i) {
            this.add(this.savedCoordinates.get(i));
        }
        return ProfileGraphTool.createCursor((Image)new ImageIcon(((Object)((Object)this)).getClass().getResource("RulerCursorM_F.gif")).getImage());
    }

    public void mouseLocationChanged(MouseEvent e) {
        try {
            if (this.isShapeOnScreen()) {
                ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
                currentCoordinates.add(this.getPanel().getViewport().toModelCoordinate((Point2D)e.getPoint()));
                this.display(currentCoordinates, this.getPanel());
            }
            this.currCoord = this.snap(e.getPoint());
            super.mouseLocationChanged(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.savedCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
    }

    protected void gestureFinished() throws NoninvertibleTransformException {
        this.reportNothingToUndoYet();
        this.savedCoordinates.clear();
        this.display(this.getCoordinates(), this.getPanel());
        RasterImageLayer rLayer = (RasterImageLayer)LayerTools.getSelectedLayerable(this.getWorkbench().getContext(), RasterImageLayer.class);
        if (rLayer == null) {
            this.getPanel().getContext().warnUser(I18N.get("pirol.plugIns.EditAttributeByFormulaPlugIn.no-layer-selected"));
            return;
        }
        this.rstLayer = new OpenJUMPSextanteRasterLayer();
        this.rstLayer.create(rLayer);
        this.rstLayer.setFullExtent();
        GridExtent extent = this.rstLayer.getWindowGridExtent();
        this.resultFC.clear();
        this.nPoints = 0;
        this.calculateProfile(this.getCoordinates(), this.getWorkbench().getContext());
    }

    private void display(List<Coordinate> coordinates, LayerViewPanel panel) throws NoninvertibleTransformException {
        this.display(this.distance(coordinates), panel);
    }

    private void display(double distance, LayerViewPanel panel) {
        DecimalFormat df3 = new DecimalFormat("###,###,##0.0##");
        String distString = df3.format(distance / 0.3048);
        panel.getContext().setStatusMessage(sDistance + ": " + panel.format(distance) + " " + sMeters + " " + " = " + distString + " feet");
    }

    private double distance(List<Coordinate> coordinates) {
        double distance = 0.0;
        for (int i = 1; i < coordinates.size(); ++i) {
            distance += coordinates.get(i - 1).distance(coordinates.get(i));
        }
        if (this.currCoord != null && coordinates.size() > 1) {
            distance -= coordinates.get(coordinates.size() - 2).distance(coordinates.get(coordinates.size() - 1));
            distance += coordinates.get(coordinates.size() - 2).distance(this.currCoord);
        }
        return distance;
    }

    private void calculateProfile(List<Coordinate> coordinates, WorkbenchContext context) {
        Coordinate[] coords = new Coordinate[coordinates.size()];
        int i = 0;
        Iterator<Coordinate> iterator = coordinates.iterator();
        while (iterator.hasNext()) {
            Coordinate c;
            coords[i] = c = iterator.next();
            ++i;
        }
        LineString line = this.gf.createLineString(coords);
        this.processLine((Geometry)line);
        PlugInContext pc = context.createPlugInContext();
        if (this.resultFC != null && this.resultFC.size() > 0) {
            pc.addLayer(StandardCategoryNames.RESULT, I18N.get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.profile-pts"), this.resultFC);
        }
        ShowProfile myScorePlot = new ShowProfile(this.resultFC);
        Plot2DPanelOJ plot = myScorePlot.getPlot();
        JInternalFrame frame = new JInternalFrame(I18N.get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.Profile-Plot"));
        frame.setLayout(new BorderLayout());
        frame.add((Component)((Object)plot), "Center");
        frame.setClosable(true);
        frame.setResizable(true);
        frame.setMaximizable(true);
        frame.setSize(450, 450);
        frame.setVisible(true);
        context.getWorkbench().getFrame().addInternalFrame(frame);
    }

    private void processLine(Geometry line) {
        Coordinate[] coords = line.getCoordinates();
        for (int i = 0; i < coords.length - 1; ++i) {
            double x = coords[i].x;
            double y = coords[i].y;
            double x2 = coords[i + 1].x;
            double y2 = coords[i + 1].y;
            this.processSegment(x, y, x2, y2);
        }
    }

    private void processSegment(double x, double y, double x2, double y2) {
        double dx = Math.abs(x2 - x);
        double dy = Math.abs(y2 - y);
        if (dx > 0.0 || dy > 0.0) {
            double n;
            if (dx > dy) {
                n = dx /= this.rstLayer.getWindowCellSize();
                dy /= dx;
                dx = this.rstLayer.getWindowCellSize();
            } else {
                n = dy /= this.rstLayer.getWindowCellSize();
                dx /= dy;
                dy = this.rstLayer.getWindowCellSize();
            }
            if (x2 < x) {
                dx = -dx;
            }
            if (y2 < y) {
                dy = -dy;
            }
            double d = 0.0;
            while (d <= n) {
                this.addPoint(x, y);
                d += 1.0;
                x += dx;
                y += dy;
            }
        }
    }

    private void addPoint(double x, double y) {
        double z = this.rstLayer.getValueAt(x, y);
        if (this.nPoints == 0) {
            this.dDist = 0.0;
            this.dHorzDist = 0.0;
        } else {
            double dDX = x - this.m_dLastX;
            double dDY = y - this.m_dLastY;
            double dDZ = this.rstLayer.isNoDataValue(z) || this.rstLayer.isNoDataValue(this.m_dLastZ) ? 0.0 : z - this.m_dLastZ;
            this.dDist += Math.sqrt(dDX * dDX + dDY * dDY);
            this.dHorzDist += Math.sqrt(dDX * dDX + dDY * dDY + dDZ * dDZ);
        }
        this.m_dLastX = x;
        this.m_dLastY = y;
        this.m_dLastZ = z;
        ++this.nPoints;
        Point geometry = new GeometryFactory().createPoint(new Coordinate(x, y));
        BasicFeature fpoint = new BasicFeature(this.resultFSchema);
        fpoint.setGeometry((Geometry)geometry);
        fpoint.setAttribute("X", (Object)new Double(x));
        fpoint.setAttribute("Y", (Object)new Double(y));
        fpoint.setAttribute("Z", (Object)new Double(z));
        fpoint.setAttribute("PlaneDist", (Object)new Double(this.dDist));
        fpoint.setAttribute("TerrainDist", (Object)new Double(this.dHorzDist));
        this.resultFC.add(fpoint);
    }
}

