/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.geom.Point2D;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.sextante.OpenJUMPSextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridWrapperNotInterpolated;

public class CreateLatticeFromSelectedImageLayerPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private PlugInContext context = null;
    GeometryFactory gfactory = new GeometryFactory();
    private String sName = "Create Lattice from Raster";
    private String sBand = "band";
    private String sLattice = "lattice";
    private String sCreatePoints = "creating points";

    public void initialize(PlugInContext context) throws Exception {
        this.sName = I18N.get("org.openjump.core.ui.plugin.raster.CreateLatticeFromSelectedImageLayerPlugIn.Create-Lattice-from-Raster");
        this.sBand = I18N.get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.band");
        this.sLattice = I18N.get("org.openjump.core.ui.plugin.raster.CreateLatticeFromSelectedImageLayerPlugIn.lattice");
        this.sCreatePoints = I18N.get("org.openjump.core.ui.plugin.raster.CreateLatticeFromSelectedImageLayerPlugIn.creating-points");
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem((PlugIn)this, new String[]{MenuNames.RASTER}, this.sName, false, null, (EnableCheck)CreateLatticeFromSelectedImageLayerPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayerablesMustBeSelectedCheck(1, RasterImageLayer.class));
    }

    public String getIconString() {
        return null;
    }

    public boolean execute(PlugInContext context) throws Exception {
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        GeometryFactory gf = new GeometryFactory();
        RasterImageLayer rLayer = (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class);
        if (rLayer == null) {
            context.getWorkbenchFrame().warnUser(I18N.get("pirol.plugIns.EditAttributeByFormulaPlugIn.no-layer-selected"));
            return;
        }
        OpenJUMPSextanteRasterLayer rstLayer = new OpenJUMPSextanteRasterLayer();
        rstLayer.create(rLayer);
        GridWrapperNotInterpolated gwrapper = new GridWrapperNotInterpolated(rstLayer, rstLayer.getLayerGridExtent());
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("geometry", AttributeType.GEOMETRY);
        fs.addAttribute("cellid_x", AttributeType.INTEGER);
        fs.addAttribute("cellid_y", AttributeType.INTEGER);
        int numBands = rstLayer.getBandsCount();
        for (int i = 0; i < numBands; ++i) {
            fs.addAttribute(this.sBand + "_" + i, AttributeType.DOUBLE);
        }
        FeatureDataset fd = new FeatureDataset(fs);
        monitor.report(this.sCreatePoints);
        int nx = rstLayer.getLayerGridExtent().getNX();
        int ny = rstLayer.getLayerGridExtent().getNY();
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                BasicFeature ftemp = new BasicFeature(fs);
                Point2D pt = rstLayer.getLayerGridExtent().getWorldCoordsFromGridCoords(x, y);
                Point centerPoint = gf.createPoint(new Coordinate(pt.getX(), pt.getY()));
                ftemp.setGeometry((Geometry)centerPoint);
                for (int i = 0; i < numBands; ++i) {
                    double value = gwrapper.getCellValueAsDouble(x, y, i);
                    ftemp.setAttribute(this.sBand + "_" + i, (Object)value);
                }
                ftemp.setAttribute("cellid_x", (Object)x);
                ftemp.setAttribute("cellid_y", (Object)y);
                fd.add(ftemp);
                if (!monitor.isCancelRequested()) continue;
                if (fd.size() > 0) {
                    context.addLayer(StandardCategoryNames.RESULT, rstLayer.getName() + "_cancel_" + this.sLattice, (FeatureCollection)fd);
                }
                return;
            }
        }
        if (fd.size() > 0) {
            context.addLayer(StandardCategoryNames.RESULT, rstLayer.getName() + "_" + this.sLattice, (FeatureCollection)fd);
        }
    }
}

