/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ExtractLayersByGeometry
extends AbstractPlugIn {
    private static final String EXTRACT_LAYERS_BY_GEOMETRY_TYPE = I18N.get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.Extract-Layers-by-Geometry-Type");
    private static final String ONLY_ONE_GEOMETRY_TYPE_FOUND = I18N.get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.Only-one-geometry-type-found");
    private static final String EMPTY = I18N.get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.empty");
    private static final String POINT = I18N.get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.point");
    private static final String LINE = I18N.get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.line");
    private static final String AREA = I18N.get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.area");
    public static final ImageIcon ICON = IconLoader.icon((String)"extract.gif");
    static final int emptyBit = 0;
    static final int pointBit = 1;
    static final int lineBit = 2;
    static final int polyBit = 3;

    public void initialize(PlugInContext context) throws Exception {
        WorkbenchContext workbenchContext = context.getWorkbenchContext();
        FeatureInstaller featureInstaller = new FeatureInstaller(workbenchContext);
        featureInstaller.addMenuSeparator(MenuNames.EDIT);
        FeatureInstaller.addMainMenu((FeatureInstaller)featureInstaller, (String[])new String[]{MenuNames.EDIT}, (String)MenuNames.EXTRACT, (int)14);
        context.getFeatureInstaller().addMainMenuItemWithJava14Fix((PlugIn)this, new String[]{MenuNames.EDIT, MenuNames.EXTRACT}, this.getName(), false, (Icon)ICON, (EnableCheck)ExtractLayersByGeometry.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        Layer[] layers = context.getWorkbenchContext().getLayerNamePanel().getSelectedLayers();
        if (layers.length > 0) {
            Layer layer = layers[0];
            if (!this.compatibleFeatures(layer)) {
                this.splitLayer(context, layer);
            } else {
                context.getWorkbenchFrame().warnUser(ONLY_ONE_GEOMETRY_TYPE_FOUND);
            }
            return true;
        }
        return false;
    }

    public String getName() {
        return EXTRACT_LAYERS_BY_GEOMETRY_TYPE;
    }

    private List splitLayer(PlugInContext context, Layer layer) {
        ArrayList<Layer> newLayers = new ArrayList<Layer>();
        ArrayList emptyFeatures = new ArrayList();
        ArrayList<Feature> pointFeatures = new ArrayList<Feature>();
        ArrayList<Feature> lineFeatures = new ArrayList<Feature>();
        ArrayList<Feature> polyFeatures = new ArrayList<Feature>();
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        List featureList = featureCollection.getFeatures();
        FeatureSchema featureSchema = featureCollection.getFeatureSchema();
        Collection selectedCategories = context.getLayerNamePanel().getSelectedCategories();
        for (Feature feature : featureList) {
            Geometry geo = feature.getGeometry();
            BitSet currFeatureBit = new BitSet();
            currFeatureBit = ExtractLayersByGeometry.setBit(currFeatureBit, geo);
            if (geo instanceof GeometryCollection) {
                this.explodeGeometryCollection(featureSchema, emptyFeatures, pointFeatures, lineFeatures, polyFeatures, (GeometryCollection)geo, feature);
                continue;
            }
            if (currFeatureBit.get(1)) {
                pointFeatures.add(feature.clone(true));
                continue;
            }
            if (currFeatureBit.get(2)) {
                lineFeatures.add(feature.clone(true));
                continue;
            }
            if (!currFeatureBit.get(3)) continue;
            polyFeatures.add(feature.clone(true));
        }
        if (emptyFeatures.size() > 0) {
            Layer emptyLayer = context.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.RESULT : selectedCategories.iterator().next().toString(), layer.getName() + "_" + EMPTY, (FeatureCollection)new FeatureDataset(featureSchema));
            emptyLayer.setStyles(layer.cloneStyles());
            FeatureCollectionWrapper emptyFeatureCollection = emptyLayer.getFeatureCollectionWrapper();
            newLayers.add(emptyLayer);
            emptyFeatureCollection.addAll(emptyFeatures);
        }
        if (pointFeatures.size() > 0) {
            Layer pointLayer = context.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.RESULT : selectedCategories.iterator().next().toString(), layer.getName() + "_" + POINT, (FeatureCollection)new FeatureDataset(featureSchema));
            pointLayer.setStyles(layer.cloneStyles());
            FeatureCollectionWrapper pointFeatureCollection = pointLayer.getFeatureCollectionWrapper();
            newLayers.add(pointLayer);
            pointFeatureCollection.addAll(pointFeatures);
        }
        if (lineFeatures.size() > 0) {
            Layer lineLayer = context.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.RESULT : selectedCategories.iterator().next().toString(), layer.getName() + "_" + LINE, (FeatureCollection)new FeatureDataset(featureSchema));
            lineLayer.setStyles(layer.cloneStyles());
            FeatureCollectionWrapper lineFeatureCollection = lineLayer.getFeatureCollectionWrapper();
            newLayers.add(lineLayer);
            lineFeatureCollection.addAll(lineFeatures);
        }
        if (polyFeatures.size() > 0) {
            Layer polyLayer = context.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.RESULT : selectedCategories.iterator().next().toString(), layer.getName() + "_" + AREA, (FeatureCollection)new FeatureDataset(featureSchema));
            polyLayer.setStyles(layer.cloneStyles());
            FeatureCollectionWrapper polyFeatureCollection = polyLayer.getFeatureCollectionWrapper();
            newLayers.add(polyLayer);
            polyFeatureCollection.addAll(polyFeatures);
        }
        context.getLayerViewPanel().repaint();
        return newLayers;
    }

    private void explodeGeometryCollection(FeatureSchema fs, ArrayList emptyFeatures, ArrayList pointFeatures, ArrayList lineFeatures, ArrayList polyFeatures, GeometryCollection geometryCollection, Feature feature) {
        if (geometryCollection.isEmpty()) {
            emptyFeatures.add(feature.clone(false));
        } else {
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                Geometry geometry = geometryCollection.getGeometryN(i);
                if (geometry instanceof GeometryCollection) {
                    this.explodeGeometryCollection(fs, emptyFeatures, pointFeatures, lineFeatures, polyFeatures, (GeometryCollection)geometry, feature);
                    continue;
                }
                Feature newFeature = feature.clone(false);
                newFeature.setGeometry((Geometry)geometry.clone());
                BitSet featureBit = new BitSet();
                featureBit = ExtractLayersByGeometry.setBit(featureBit, geometry);
                if (featureBit.get(1)) {
                    pointFeatures.add(newFeature);
                    continue;
                }
                if (featureBit.get(2)) {
                    lineFeatures.add(newFeature);
                    continue;
                }
                if (!featureBit.get(3)) continue;
                polyFeatures.add(newFeature);
            }
        }
    }

    private boolean compatibleFeatures(Layer layer) {
        BitSet bitSet = new BitSet();
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        List featureList = featureCollection.getFeatures();
        Iterator i = featureList.iterator();
        while (i.hasNext()) {
            bitSet = ExtractLayersByGeometry.setBit(bitSet, ((Feature)i.next()).getGeometry());
        }
        return bitSet.cardinality() < 2;
    }

    private static BitSet setBit(BitSet bitSet, Geometry geometry) {
        BitSet newBitSet = (BitSet)bitSet.clone();
        if (geometry instanceof Point) {
            newBitSet.set(1);
        } else if (geometry instanceof MultiPoint) {
            newBitSet.set(1);
        } else if (geometry instanceof LineString) {
            newBitSet.set(2);
        } else if (geometry instanceof LinearRing) {
            newBitSet.set(2);
        } else if (geometry instanceof MultiLineString) {
            newBitSet.set(2);
        } else if (geometry instanceof Polygon) {
            newBitSet.set(3);
        } else if (geometry instanceof MultiPolygon) {
            newBitSet.set(3);
        } else if (geometry instanceof GeometryCollection) {
            if (geometry.isEmpty()) {
                newBitSet.set(0);
            } else {
                GeometryCollection geometryCollection = (GeometryCollection)geometry;
                for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                    newBitSet = ExtractLayersByGeometry.setBit(newBitSet, geometryCollection.getGeometryN(i));
                }
            }
        }
        return newBitSet;
    }
}

