/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openjump.core.geomutils.GeoUtils;
import org.openjump.core.geomutils.MathVector;

public class RotateSelectedItemTool
extends DragTool {
    static final String rotateSelectedItem = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.RotateSelectedItemTool.Rotate-Selected-Item");
    static final String angleST = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.angle");
    static final String degrees = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.degrees");
    private EnableCheckFactory checkFactory;
    private Shape selectedFeatureShape;
    private Coordinate centerCoord;
    protected boolean clockwise = true;
    private double fullAngle = 0.0;
    private boolean shiftDown = false;
    private Cursor rotateCursor = RotateSelectedItemTool.createCursor((Image)new ImageIcon(((Object)((Object)this)).getClass().getResource("RotateSelCursor.gif")).getImage());
    private Cursor crosshairCursor = RotateSelectedItemTool.createCursor((Image)new ImageIcon(((Object)((Object)this)).getClass().getResource("CrossHairCursor.gif")).getImage());

    public RotateSelectedItemTool(EnableCheckFactory checkFactory) {
        this.checkFactory = checkFactory;
    }

    public void activate(LayerViewPanel layerViewPanel) {
        this.centerCoord = null;
        super.activate(layerViewPanel);
    }

    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        if (!this.check(this.checkFactory.createAtLeastNItemsMustBeSelectedCheck(1))) {
            return;
        }
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        for (Layer layerWithSelectedItems : this.getPanel().getSelectionManager().getLayersWithSelectedItems()) {
            transactions.add(this.createTransaction(layerWithSelectedItems));
        }
        EditTransaction.commit(transactions);
    }

    private EditTransaction createTransaction(Layer layer) {
        EditTransaction transaction = EditTransaction.createTransactionOnSelection((EditTransaction.SelectionEditor)new EditTransaction.SelectionEditor(){

            public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                for (Geometry item : selectedItems) {
                    RotateSelectedItemTool.this.rotate(item);
                }
                return geometryWithSelectedItems;
            }
        }, (SelectionManagerProxy)this.getPanel(), (LayerViewPanelContext)this.getPanel().getContext(), (String)this.getName(), (Layer)layer, (boolean)this.isRollingBackInvalidEdits(), (boolean)false);
        return transaction;
    }

    private void rotate(Geometry geometry) {
        geometry.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                double cosAngle = Math.cos(RotateSelectedItemTool.this.fullAngle);
                double sinAngle = Math.sin(RotateSelectedItemTool.this.fullAngle);
                double x = coordinate.x - ((RotateSelectedItemTool)RotateSelectedItemTool.this).centerCoord.x;
                double y = coordinate.y - ((RotateSelectedItemTool)RotateSelectedItemTool.this).centerCoord.y;
                coordinate.x = ((RotateSelectedItemTool)RotateSelectedItemTool.this).centerCoord.x + x * cosAngle + y * sinAngle;
                coordinate.y = ((RotateSelectedItemTool)RotateSelectedItemTool.this).centerCoord.y + y * cosAngle - x * sinAngle;
            }
        });
    }

    public Cursor getCursor() {
        if (this.shiftDown) {
            return this.crosshairCursor;
        }
        return this.rotateCursor;
    }

    public Icon getIcon() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("RotateSel.gif"));
    }

    public void mouseMoved(MouseEvent e) {
        if (e.isShiftDown()) {
            this.shiftDown = true;
            this.getPanel().setCursor(this.crosshairCursor);
        } else {
            this.shiftDown = false;
            this.getPanel().setCursor(this.rotateCursor);
        }
        super.mouseMoved(e);
    }

    public String getName() {
        return rotateSelectedItem;
    }

    public void mousePressed(MouseEvent e) {
        try {
            if (!this.check(this.checkFactory.createSelectedItemsLayersMustBeEditableCheck())) {
                return;
            }
            if (e.isShiftDown()) {
                this.centerCoord = this.getPanel().getViewport().toModelCoordinate((Point2D)e.getPoint());
            } else {
                if (!this.check(this.checkFactory.createAtLeastNItemsMustBeSelectedCheck(1))) {
                    return;
                }
                this.selectedFeatureShape = this.createSelectedItemsShape();
                super.mousePressed(e);
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private Shape createSelectedItemsShape() throws NoninvertibleTransformException {
        Collection selectedGeos = this.getPanel().getSelectionManager().getSelectedItems();
        Geometry geo = (Geometry)selectedGeos.iterator().next();
        Geometry[] allGeoms = new Geometry[selectedGeos.size()];
        int i = 0;
        Iterator j = selectedGeos.iterator();
        while (j.hasNext()) {
            allGeoms[i++] = (Geometry)j.next();
        }
        GeometryFactory geoFac = new GeometryFactory();
        geo = geoFac.createGeometryCollection(allGeoms);
        if (this.centerCoord == null) {
            this.centerCoord = geo.getCentroid().getCoordinate();
        }
        return this.getPanel().getJava2DConverter().toShape(geo);
    }

    protected Shape getShape() throws Exception {
        boolean ccwQuad;
        AffineTransform transform = new AffineTransform();
        Point2D centerPt = this.getPanel().getViewport().toViewPoint((Point2D)new Point2D.Double(this.centerCoord.x, this.centerCoord.y));
        Point2D initialPt = this.getViewSource();
        Point2D currPt = this.getViewDestination();
        MathVector center = new MathVector(centerPt.getX(), centerPt.getY());
        MathVector initial = new MathVector(initialPt.getX(), initialPt.getY());
        MathVector curr = new MathVector(currPt.getX(), currPt.getY());
        MathVector initVec = initial.vectorBetween(center);
        MathVector currVec = curr.vectorBetween(center);
        double arcAngle = initVec.angleRad(currVec);
        Coordinate initialCoord = this.getPanel().getViewport().toModelCoordinate(initialPt);
        Coordinate currCoord = this.getPanel().getViewport().toModelCoordinate(currPt);
        boolean toRight = GeoUtils.pointToRight(currCoord, this.centerCoord, initialCoord);
        boolean cwQuad = this.fullAngle >= 0.0 && this.fullAngle <= 90.0 && this.clockwise;
        boolean bl = ccwQuad = this.fullAngle < 0.0 && this.fullAngle >= -90.0 && !this.clockwise;
        if (arcAngle <= 90.0 && (cwQuad || ccwQuad)) {
            this.clockwise = toRight;
        }
        this.fullAngle = this.fullAngle > 90.0 || this.fullAngle < -90.0 ? (this.clockwise && !toRight || !this.clockwise && toRight ? 360.0 - arcAngle : arcAngle) : arcAngle;
        if (!this.clockwise) {
            this.fullAngle = -this.fullAngle;
        }
        DecimalFormat df2 = new DecimalFormat("##0.0#");
        this.getPanel().getContext().setStatusMessage(angleST + ": " + df2.format(Math.toDegrees(this.fullAngle)) + " " + degrees);
        transform.rotate(this.fullAngle, centerPt.getX(), centerPt.getY());
        return transform.createTransformedShape(this.selectedFeatureShape);
    }
}

