/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edit;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class SelectByTypePlugIn
extends AbstractPlugIn {
    private WorkbenchContext workbenchContext;
    private boolean selectEmpty = false;
    private boolean selectPoint = false;
    private boolean selectMultiPoint = false;
    private boolean selectLineString = false;
    private boolean selectLinearRing = false;
    private boolean selectMultiLineString = false;
    private boolean selectPolygon = false;
    private boolean selectMultiPolygon = false;
    private boolean selectGeometryCollection = false;
    private boolean selectedLayersOnly = true;
    protected AbstractSelection selection;
    static final String sSelectByGeometryType = I18N.get("org.openjump.core.ui.plugin.edit.SelectByTypePlugIn.Select-by-Geometry-Type");
    static final String sSelectOnlyTheseTypes = I18N.get("org.openjump.core.ui.plugin.edit.SelectByTypePlugIn.Select-only-these-types");
    static final String sEmptyGeometries = I18N.get("org.openjump.core.ui.plugin.edit.SelectByTypePlugIn.Empty-Geometries");
    static final String sOnSelectedLayersOnly = I18N.get("org.openjump.core.ui.plugin.edit.SelectByTypePlugIn.On-selected-layers-only");

    public void initialize(PlugInContext context) throws Exception {
        this.workbenchContext = context.getWorkbenchContext();
        context.getFeatureInstaller().addMainMenuItemWithJava14Fix((PlugIn)this, new String[]{MenuNames.EDIT, MenuNames.SELECTION}, sSelectByGeometryType + "...", false, null, (EnableCheck)this.createEnableCheck(this.workbenchContext));
    }

    public String getName() {
        return sSelectByGeometryType;
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        LayerViewPanel layerViewPanel = context.getWorkbenchContext().getLayerViewPanel();
        ArrayList<Feature> selectedFeatures = new ArrayList<Feature>();
        layerViewPanel.getSelectionManager().clear();
        Collection layers = this.selectedLayersOnly ? context.getWorkbenchContext().getLayerNamePanel().selectedNodes(Layer.class) : context.getWorkbenchContext().getLayerNamePanel().getLayerManager().getLayers();
        for (Layer layer : layers) {
            selectedFeatures.clear();
            if (layer.isVisible()) {
                FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
                Iterator i = featureCollection.iterator();
                while (i.hasNext()) {
                    Feature feature = (Feature)i.next();
                    if (!this.selectFeature(feature)) continue;
                    selectedFeatures.add(feature);
                }
            }
            if (selectedFeatures.size() <= 0) continue;
            layerViewPanel.getSelectionManager().getFeatureSelection().selectItems(layer, selectedFeatures);
        }
        return true;
    }

    private boolean selectFeature(Feature feature) {
        Geometry geo = feature.getGeometry();
        if (this.selectPoint && geo instanceof Point) {
            return true;
        }
        if (this.selectMultiPoint && geo instanceof MultiPoint) {
            return true;
        }
        if (this.selectLineString && geo instanceof LineString) {
            return true;
        }
        if (this.selectLinearRing && geo instanceof LinearRing) {
            return true;
        }
        if (this.selectMultiLineString && geo instanceof MultiLineString) {
            return true;
        }
        if (this.selectPolygon && geo instanceof Polygon) {
            return true;
        }
        if (this.selectMultiPolygon && geo instanceof MultiPolygon) {
            return true;
        }
        if (this.selectGeometryCollection && geo instanceof GeometryCollection) {
            return true;
        }
        return this.selectEmpty && geo.isEmpty();
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.addLabel(sSelectOnlyTheseTypes);
        dialog.addCheckBox(sEmptyGeometries, this.selectEmpty);
        dialog.addCheckBox("Point", this.selectPoint);
        dialog.addCheckBox("MultiPoint", this.selectMultiPoint);
        dialog.addCheckBox("LineString", this.selectLineString);
        dialog.addCheckBox("LinearRing", this.selectLinearRing);
        dialog.addCheckBox("MultiLineString", this.selectMultiLineString);
        dialog.addCheckBox("Polygon", this.selectPolygon);
        dialog.addCheckBox("MultiPolygon", this.selectMultiPolygon);
        dialog.addCheckBox("GeometryCollection", this.selectGeometryCollection);
        dialog.addCheckBox(sOnSelectedLayersOnly, this.selectedLayersOnly);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.selectEmpty = dialog.getCheckBox(sEmptyGeometries).isSelected();
        this.selectPoint = dialog.getCheckBox("Point").isSelected();
        this.selectMultiPoint = dialog.getCheckBox("MultiPoint").isSelected();
        this.selectLineString = dialog.getCheckBox("LineString").isSelected();
        this.selectLinearRing = dialog.getCheckBox("LinearRing").isSelected();
        this.selectMultiLineString = dialog.getCheckBox("MultiLineString").isSelected();
        this.selectPolygon = dialog.getCheckBox("Polygon").isSelected();
        this.selectMultiPolygon = dialog.getCheckBox("MultiPolygon").isSelected();
        this.selectGeometryCollection = dialog.getCheckBox("GeometryCollection").isSelected();
        this.selectedLayersOnly = dialog.getCheckBox(sOnSelectedLayersOnly).isSelected();
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }
}

