/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edit;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JPopupMenu;

public class SelectAllLayerItemsPlugIn
extends AbstractPlugIn {
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addPopupMenuItem((JPopupMenu)context.getWorkbenchContext().getWorkbench().getFrame().getLayerNamePopupMenu(), (PlugIn)this, I18N.get("org.openjump.core.ui.plugin.edit.SelectAllLayerItemsPlugIn.select-current-layer-items"), false, null, (EnableCheck)SelectAllLayerItemsPlugIn.createEnableCheck(context.getWorkbenchContext()));
        context.getFeatureInstaller().addMainMenuItemWithJava14Fix((PlugIn)this, new String[]{MenuNames.EDIT, MenuNames.SELECTION}, I18N.get("org.openjump.core.ui.plugin.edit.SelectAllLayerItemsPlugIn.select-layer-items"), false, null, (EnableCheck)SelectAllLayerItemsPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        int count = 0;
        Layer[] selectedLayers = context.getLayerNamePanel().getSelectedLayers();
        for (int i = 0; i < selectedLayers.length; ++i) {
            Layer actualLayer = selectedLayers[i];
            if (!actualLayer.isVisible()) continue;
            FeatureCollection fc = context.getSelectedLayer(i).getFeatureCollectionWrapper().getWrappee();
            ArrayList<Feature> features = new ArrayList<Feature>();
            Iterator iter = fc.iterator();
            while (iter.hasNext()) {
                Feature element = (Feature)iter.next();
                features.add(element);
                ++count;
            }
            context.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(actualLayer, features);
        }
        Collection myf = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        context.getWorkbenchFrame().setTimeMessage(I18N.get("org.openjump.core.ui.plugin.edit.SelectAllLayerItemsPlugIn.layer-items") + ": " + count + ", " + I18N.get("org.openjump.core.ui.plugin.edit.SelectAllLayerItemsPlugIn.selected-items") + ": " + myf.size());
        System.gc();
        return true;
    }
}

