/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.registry.Registry;
import com.vividsolutions.jump.workbench.ui.OptionsPanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.openjump.core.ui.io.file.DataSourceFileLayerLoader;
import org.openjump.core.ui.io.file.FileLayerLoader;

public class DatasetOptionsPanel
extends JPanel
implements OptionsPanel {
    public static final String BB_DATASET_OPTIONS_SHOW_CHARSET_SELECTION = DatasetOptionsPanel.class.getName() + "SHOW_CHARSET_SELECTION";
    private JPanel mainPanel;
    private JPanel fillPanel;
    private JCheckBox charsetSelectionCheckBox;
    private Blackboard blackboard = null;
    private WorkbenchContext context = null;

    public DatasetOptionsPanel(WorkbenchContext context) {
        this.context = context;
        this.blackboard = PersistentBlackboardPlugIn.get((WorkbenchContext)context);
        this.initComponents();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.fillPanel = new JPanel();
        this.charsetSelectionCheckBox = new JCheckBox(I18N.get("ui.DatasetOptionsPanel.ShowCharsetSelection"));
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.mainPanel.setLayout(new GridBagLayout());
        this.add((Component)this.mainPanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.mainPanel.add((Component)this.charsetSelectionCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.fillPanel, gridBagConstraints);
    }

    public String validateInput() {
        return null;
    }

    public void okPressed() {
        this.blackboard.put(BB_DATASET_OPTIONS_SHOW_CHARSET_SELECTION, this.charsetSelectionCheckBox.isSelected());
        Registry registry = this.context.getRegistry();
        List loaders = registry.getEntries((Object)FileLayerLoader.KEY);
        for (Object loader : loaders) {
            DataSourceFileLayerLoader fileLoader;
            if (!(loader instanceof DataSourceFileLayerLoader) || !(fileLoader = (DataSourceFileLayerLoader)loader).getDescription().equals("ESRI Shapefile")) continue;
            fileLoader.removeOption("charset", "CharSetComboBoxField", Charset.defaultCharset().displayName(), true);
            if (!this.charsetSelectionCheckBox.isSelected()) continue;
            fileLoader.addOption("charset", "CharSetComboBoxField", Charset.defaultCharset().displayName(), true);
        }
    }

    public void init() {
        Object showCharsetSelection = this.blackboard.get(BB_DATASET_OPTIONS_SHOW_CHARSET_SELECTION);
        if (showCharsetSelection instanceof Boolean) {
            this.charsetSelectionCheckBox.setSelected((Boolean)showCharsetSelection);
        } else {
            this.charsetSelectionCheckBox.setSelected(false);
        }
    }
}

