/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.openjump.core.rasterimage.GridAscii;
import org.openjump.core.rasterimage.GridFloat;
import org.openjump.util.metaData.MetaDataMap;
import org.openjump.util.metaData.ObjectContainingMetaInformation;

public class RasterImageLayer
extends AbstractLayerable
implements ObjectContainingMetaInformation {
    protected static Blackboard blackboard = null;
    protected static final String BLACKBOARD_KEY_PLUGINCONTEXT = PlugInContext.class.getName();
    protected static final String BLACKBOARD_KEY_WORKBENCHCONTEXT = PlugInContext.class.getName();
    protected int lastImgProcessingMode = 0;
    protected static final int MODE_NONE = 0;
    protected static final int MODE_SCALINGFIRST = 1;
    protected static final int MODE_CLIPPINGFIRST = 2;
    protected static final int MODE_FASTDISPLAY = 3;
    protected Rectangle imagePart;
    protected Rectangle oldImagePart;
    protected Rectangle visibleRect = null;
    protected double scaleXImg2Canvas;
    protected double oldScaleXImg2Canvas;
    protected double scaleYImg2Canvas;
    protected int xOffset;
    protected int yOffset;
    protected double transparencyLevel = 0.0;
    protected static long availRAM = Runtime.getRuntime().maxMemory();
    protected static double freeRamFactor = 0.5;
    protected static double minRamToKeepFree = (double)availRAM * freeRamFactor;
    protected static int maxPixelsForFastDisplayMode = 250000;
    protected String imageFileName = null;
    protected int origImageWidth;
    protected int origImageHeight;
    protected boolean imageSet = false;
    protected PlanarImage image = null;
    protected static Raster rasterData = null;
    protected boolean rasterDataChanged = false;
    protected boolean wasScaledForDisplay = false;
    protected PlanarImage imageProcessingStep1 = null;
    protected PlanarImage imageProcessingStep2 = null;
    protected Envelope envelope = null;
    protected Envelope visibleEnv = null;
    protected boolean firingAppearanceEvents = true;
    protected boolean needToKeepImage = false;
    protected static final Point nullpunkt = new Point(0, 0);
    protected Color transparentColor = null;
    protected boolean transparencyColorNeedsToBeApplied = false;
    protected MetaDataMap metaInformation = null;

    public RasterImageLayer() {
        this.getBlackboard().put(LayerNameRenderer.USE_CLOCK_ANIMATION_KEY, true);
    }

    public RasterImageLayer(String name, LayerManager layerManager, String imageFileName, RenderedImage imageToDisplay, Raster newRaster, Envelope envelope) {
        super(name, layerManager);
        long avram;
        this.getBlackboard().put(LayerNameRenderer.USE_CLOCK_ANIMATION_KEY, true);
        this.imageFileName = imageFileName;
        this.envelope = envelope;
        if (imageToDisplay != null) {
            this.setImage(PlanarImage.wrapRenderedImage((RenderedImage)imageToDisplay));
        }
        if (newRaster != null) {
            this.setRasterData(newRaster);
        }
        if ((avram = RasterImageLayer.getAvailRAM()) > 256000000L) {
            maxPixelsForFastDisplayMode = 250000;
        }
        if (avram > 750000000L) {
            maxPixelsForFastDisplayMode = 4000000;
        }
    }

    public RasterImageLayer(String name, LayerManager layerManager, RenderedImage imageToDisplay, Raster newRaster, Envelope envelope) {
        super(name, layerManager);
        long avram;
        this.getBlackboard().put(LayerNameRenderer.USE_CLOCK_ANIMATION_KEY, true);
        this.setNeedToKeepImage(true);
        this.envelope = envelope;
        if (imageToDisplay != null) {
            this.setImage(PlanarImage.wrapRenderedImage((RenderedImage)imageToDisplay));
        }
        if (newRaster != null) {
            this.setRasterData(newRaster);
        }
        if ((avram = RasterImageLayer.getAvailRAM()) > 256000000L) {
            maxPixelsForFastDisplayMode = 250000;
        }
        if (avram > 750000000L) {
            maxPixelsForFastDisplayMode = 563500;
        }
    }

    public Blackboard getBlackboard() {
        if (blackboard == null) {
            blackboard = new Blackboard();
        }
        return blackboard;
    }

    public Object clone() throws CloneNotSupportedException {
        if (this.isNeedToKeepImage()) {
            return new RasterImageLayer(this.getName(), this.getLayerManager(), (RenderedImage)this.getImageForDisplay(), this.getRasterData(), new Envelope(this.getEnvelope()));
        }
        return new RasterImageLayer(this.getName(), this.getLayerManager(), this.getImageFileName(), (RenderedImage)this.getImageForDisplay(), this.getRasterData(), new Envelope(this.getEnvelope()));
    }

    protected PlanarImage scaleImage(PlanarImage im, float xScale, float yScale) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(im);
        pb.add(xScale);
        pb.add(yScale);
        return JAI.create((String)"Scale", (ParameterBlock)pb, null);
    }

    protected PlanarImage createOneColorImage() {
        this.scaleXImg2Canvas = Math.min(Math.abs(this.scaleXImg2Canvas), (double)Math.abs(this.visibleRect.width));
        this.scaleYImg2Canvas = Math.min(Math.abs(this.scaleYImg2Canvas), (double)Math.abs(this.visibleRect.height));
        BufferedImage bim = new BufferedImage(this.visibleRect.width, this.visibleRect.height, 2);
        Graphics2D grfcs = bim.createGraphics();
        grfcs.setColor(new Color(this.imageProcessingStep1.getAsBufferedImage().getRGB(0, 0)));
        grfcs.fillRect(0, 0, bim.getWidth(), bim.getHeight());
        grfcs.dispose();
        return PlanarImage.wrapRenderedImage((RenderedImage)bim);
    }

    public BufferedImage createImage(LayerViewPanel layerViewPanel) {
        Viewport viewport = layerViewPanel.getViewport();
        if (!this.isVisible() || this.transparencyLevel >= 1.0) {
            this.setImageProcessingMode(0);
            this.clearImageAndRaster(true);
            return null;
        }
        BufferedImage imageToDraw = null;
        try {
            Point2D upperLeftCornerOfImage = null;
            Point2D lowerRightCornerOfImage = null;
            try {
                upperLeftCornerOfImage = viewport.toViewPoint(new Coordinate(this.getEnvelope().getMinX(), this.getEnvelope().getMaxY()));
                lowerRightCornerOfImage = viewport.toViewPoint(new Coordinate(this.getEnvelope().getMaxX(), this.getEnvelope().getMinY()));
            }
            catch (NoninvertibleTransformException ne) {
                ne.printStackTrace();
                return null;
            }
            this.visibleRect = viewport.getPanel().getVisibleRect();
            int visibleX1 = this.visibleRect.x;
            int visibleY1 = this.visibleRect.y;
            int visibleX2 = visibleX1 + this.visibleRect.width;
            int visibleY2 = visibleY1 + this.visibleRect.height;
            Coordinate upperLeftVisible = viewport.toModelCoordinate((Point2D)nullpunkt);
            Coordinate lowerRightVisible = viewport.toModelCoordinate((Point2D)new Point(visibleX2, visibleY2));
            Envelope newVisibleEnv = new Envelope(upperLeftVisible.x, lowerRightVisible.x, upperLeftVisible.y, lowerRightVisible.y);
            double scaledWidth = lowerRightCornerOfImage.getX() - upperLeftCornerOfImage.getX();
            double scaledHeight = upperLeftCornerOfImage.getY() - lowerRightCornerOfImage.getY();
            if (!this.isImageSet()) {
                this.reLoadImage();
            }
            this.scaleXImg2Canvas = scaledWidth / (double)this.origImageWidth;
            this.scaleYImg2Canvas = scaledHeight / (double)this.origImageHeight;
            if (this.visibleEnv == null || this.visibleEnv.getMinX() != newVisibleEnv.getMinX() || this.visibleEnv.getMaxX() != newVisibleEnv.getMaxX() || this.visibleEnv.getMinY() != newVisibleEnv.getMinY() || this.visibleEnv.getMaxY() != newVisibleEnv.getMaxY()) {
                this.visibleEnv = newVisibleEnv;
                if (this.origImageWidth * this.origImageHeight < RasterImageLayer.getMaxPixelsForFastDisplayMode()) {
                    double maxMemoryToCommit;
                    long freeMem;
                    long totalMem;
                    long committedMemory;
                    boolean needFreeRAM;
                    this.setImageProcessingMode(3);
                    if (this.isImageNull()) {
                        this.reLoadImage();
                    }
                    boolean bl = needFreeRAM = (double)(committedMemory = (totalMem = Runtime.getRuntime().totalMemory()) - (freeMem = Runtime.getRuntime().freeMemory())) > (maxMemoryToCommit = (double)availRAM - minRamToKeepFree);
                    if (!needFreeRAM) {
                        if (!this.wasScaledForDisplay) {
                            this.setImage(RasterImageLayer.stretchImageValuesForDisplay((RenderedImage)this.getImageForDisplay()));
                            this.wasScaledForDisplay = true;
                        }
                        this.setNeedToKeepImage(true);
                    }
                    this.imagePart = this.getVisibleImageCoordinatesOfImage(this.origImageWidth, this.origImageHeight, this.visibleEnv, this.getEnvelope());
                    if (this.imageProcessingStep2 == null || this.scaleXImg2Canvas != this.oldScaleXImg2Canvas || !RasterImageLayer.tilesAreNotNullAndCongruent(this.imagePart, this.oldImagePart)) {
                        this.imageProcessingStep1 = this.getVisiblePartOfTheImage(this.getImageForDisplay(), this.imagePart);
                        if (this.imageProcessingStep1 != null) {
                            if (this.imagePart.width == 1 || this.imagePart.height == 1) {
                                this.xOffset = 0;
                                this.yOffset = 0;
                                this.imageProcessingStep2 = this.createOneColorImage();
                            } else {
                                this.imageProcessingStep2 = this.getScaledImageMatchingVisible(this.imageProcessingStep1, this.scaleXImg2Canvas, this.scaleYImg2Canvas);
                            }
                        } else {
                            return null;
                        }
                        if (this.transparentColor != null) {
                            this.transparencyColorNeedsToBeApplied = true;
                        }
                        this.imageProcessingStep1 = null;
                        this.xOffset = (int)((double)this.xOffset * this.scaleXImg2Canvas);
                        this.yOffset = (int)((double)this.yOffset * -this.scaleYImg2Canvas);
                        this.oldScaleXImg2Canvas = this.scaleXImg2Canvas;
                        this.oldImagePart = this.imagePart;
                    }
                } else if (this.scaleXImg2Canvas >= 1.0 || scaledWidth > 2500.0 && this.visibleRect.width < 1500) {
                    this.setImageProcessingMode(2);
                    this.imagePart = this.getVisibleImageCoordinatesOfImage(this.origImageWidth, this.origImageHeight, this.visibleEnv, this.getEnvelope());
                    if (this.imageProcessingStep2 == null || this.scaleXImg2Canvas != this.oldScaleXImg2Canvas || !RasterImageLayer.tilesAreNotNullAndCongruent(this.imagePart, this.oldImagePart)) {
                        if (!RasterImageLayer.tilesAreNotNullAndCongruent(this.oldImagePart, this.imagePart)) {
                            this.imageProcessingStep1 = null;
                            if (this.isImageNull()) {
                                this.reLoadImage();
                            }
                            this.imageProcessingStep1 = this.getVisiblePartOfTheImage(this.getImageForDisplay(), this.imagePart);
                            this.clearImageAndRaster(false);
                        }
                        if (this.imageProcessingStep1 != null) {
                            if (this.imagePart.width == 1 || this.imagePart.height == 1) {
                                this.xOffset = 0;
                                this.yOffset = 0;
                                this.imageProcessingStep2 = this.createOneColorImage();
                            } else {
                                this.imageProcessingStep2 = this.getScaledImageMatchingVisible(this.imageProcessingStep1, this.scaleXImg2Canvas, this.scaleYImg2Canvas);
                            }
                        } else {
                            return null;
                        }
                        if (this.transparentColor != null) {
                            this.transparencyColorNeedsToBeApplied = true;
                        }
                        this.imageProcessingStep1 = null;
                        this.xOffset = (int)((double)this.xOffset * this.scaleXImg2Canvas);
                        this.yOffset = (int)((double)this.yOffset * -this.scaleYImg2Canvas);
                        this.oldScaleXImg2Canvas = this.scaleXImg2Canvas;
                        this.oldImagePart = this.imagePart;
                    }
                } else {
                    this.setImageProcessingMode(1);
                    if (this.scaleXImg2Canvas != this.oldScaleXImg2Canvas || this.imageProcessingStep1 == null) {
                        this.imageProcessingStep1 = null;
                        if (this.isImageNull()) {
                            this.reLoadImage();
                        }
                        this.imageProcessingStep1 = this.getScaledImageMatchingVisible(this.getImageForDisplay(), this.scaleXImg2Canvas, this.scaleYImg2Canvas);
                        this.clearImageAndRaster(false);
                        this.oldScaleXImg2Canvas = this.scaleXImg2Canvas;
                    }
                    if (this.imageProcessingStep1 != null) {
                        this.imagePart = this.getVisibleImageCoordinatesOfImage(this.imageProcessingStep1, this.visibleEnv, this.getEnvelope());
                        if (this.imageProcessingStep2 == null || !RasterImageLayer.tilesAreNotNullAndCongruent(this.imagePart, this.oldImagePart)) {
                            this.imageProcessingStep2 = this.getVisiblePartOfTheImage(PlanarImage.wrapRenderedImage((RenderedImage)this.imageProcessingStep1), this.imagePart);
                            this.oldImagePart = this.imagePart;
                        }
                    } else {
                        return null;
                    }
                    if (this.transparentColor != null) {
                        this.transparencyColorNeedsToBeApplied = true;
                    }
                }
            }
            if (this.imageProcessingStep2 != null && this.transparencyColorNeedsToBeApplied) {
                imageToDraw = this.setupTransparency(this.imageProcessingStep2);
            } else if (this.imageProcessingStep2 != null) {
                imageToDraw = this.imageProcessingStep2.getAsBufferedImage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ((double)Runtime.getRuntime().freeMemory() < RasterImageLayer.getMinRamToKeepFree()) {
            this.clearImageAndRaster(true);
        }
        if (imageToDraw != null) {
            return imageToDraw;
        }
        if (this.imageProcessingStep2 != null) {
            return this.imageProcessingStep2.getAsBufferedImage();
        }
        return null;
    }

    public boolean clearImageAndRaster(boolean garbageCollect) {
        boolean reallyNeedToFreeRAM;
        boolean bl = reallyNeedToFreeRAM = (double)Runtime.getRuntime().freeMemory() < minRamToKeepFree;
        if (!this.needToKeepImage && reallyNeedToFreeRAM) {
            this.image = null;
            rasterData = null;
            this.wasScaledForDisplay = false;
        }
        if (garbageCollect) {
            Runtime.getRuntime().gc();
        }
        return reallyNeedToFreeRAM;
    }

    public void flushImages(boolean garbageCollect) {
        if (this.image != null) {
            this.image.dispose();
        }
        this.image = null;
        if (this.imageProcessingStep1 != null) {
            this.imageProcessingStep1.dispose();
        }
        this.imageProcessingStep1 = null;
        if (this.imageProcessingStep2 != null) {
            this.imageProcessingStep2.dispose();
        }
        this.imageProcessingStep2 = null;
        if (garbageCollect) {
            Runtime.getRuntime().gc();
        }
    }

    public void reLoadImage() {
        WorkbenchContext context = this.getWorkbenchContext();
        if (this.image == null && !this.needToKeepImage) {
            this.setImage(RasterImageLayer.loadImage(context, this.imageFileName));
        } else if (this.image != null || this.needToKeepImage) {
            // empty if block
        }
    }

    public void reLoadImageButKeepImageForDisplay() {
        WorkbenchContext context = this.getWorkbenchContext();
        PlanarImage pi = this.getImageForDisplay();
        this.setImage(pi);
    }

    public static Point getImageDimensions(WorkbenchContext context, String filenameOrURL) {
        block18: {
            if (!(filenameOrURL.toLowerCase().endsWith(".jpg") || filenameOrURL.toLowerCase().endsWith(".flt") || filenameOrURL.toLowerCase().endsWith(".asc"))) {
                try {
                    RenderedOp pImage = JAI.create((String)"fileload", (Object)filenameOrURL);
                    if (pImage != null) {
                        return new Point(pImage.getWidth(), pImage.getHeight());
                    }
                }
                catch (Throwable e) {
                    if (e.getMessage().indexOf("Planar (band-sequential) format TIFF is not supported") > -1) {
                        context.getWorkbench().getFrame().warnUser("unsupported-tiff");
                        break block18;
                    }
                    context.getWorkbench().getFrame().warnUser("problems-loading-image" + e.getMessage());
                }
            } else if (filenameOrURL.toLowerCase().endsWith(".flt")) {
                try {
                    GridFloat gf = new GridFloat(filenameOrURL);
                    return new Point(gf.getnCols(), gf.getnRows());
                }
                catch (Throwable e) {
                    if (e.getMessage().indexOf("Error in FLT file") > -1) {
                        context.getWorkbench().getFrame().warnUser("unsupported-flt");
                    }
                    context.getWorkbench().getFrame().warnUser("problems-loading-image" + e.getMessage());
                }
            } else if (filenameOrURL.toLowerCase().endsWith(".asc")) {
                try {
                    GridAscii ga = new GridAscii(filenameOrURL);
                    return new Point(ga.getnCols(), ga.getnRows());
                }
                catch (Throwable e) {
                    if (e.getMessage().indexOf("Error in Grid Ascii file") > -1) {
                        context.getWorkbench().getFrame().warnUser("unsupported-asc");
                    }
                    context.getWorkbench().getFrame().warnUser("problems-loading-image" + e.getMessage());
                }
            } else {
                BufferedImage image = null;
                try {
                    image = ImageIO.read(new File(filenameOrURL));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return new Point(image.getWidth(), image.getHeight());
            }
        }
        return null;
    }

    public static final PlanarImage loadImage(WorkbenchContext context, String filenameOrURL) {
        if (filenameOrURL.toLowerCase().endsWith(".gif") || filenameOrURL.toLowerCase().endsWith(".png") || filenameOrURL.toLowerCase().endsWith(".tif") || filenameOrURL.toLowerCase().endsWith(".tiff")) {
            try {
                RenderedOp pImage = JAI.create((String)"fileload", (Object)filenameOrURL);
                WritableRaster rData = pImage.copyData();
                rasterData = rData;
                PlanarImage surrogatImage = null;
                surrogatImage = RasterImageLayer.stretchImageValuesForDisplay((RenderedImage)pImage);
                return surrogatImage;
            }
            catch (Throwable e) {
                if (context != null) {
                    if (e.getMessage().indexOf("Planar (band-sequential) format TIFF is not supported") > -1) {
                        context.getWorkbench().getFrame().warnUser(I18N.get("unsupported-tiff"));
                    } else {
                        context.getWorkbench().getFrame().warnUser(I18N.get("problems-loading-image") + e.getMessage());
                    }
                }
                e.printStackTrace();
                return null;
            }
        }
        if (filenameOrURL.toLowerCase().endsWith(".jpg")) {
            PlanarImage pimage = null;
            try {
                BufferedImage image = ImageIO.read(new File(filenameOrURL));
                pimage = PlanarImage.wrapRenderedImage((RenderedImage)image);
                WritableRaster rData = pimage.copyData();
                rasterData = rData;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            PlanarImage surrogatImage = RasterImageLayer.stretchImageValuesForDisplay(pimage);
            return surrogatImage;
        }
        if (filenameOrURL.toLowerCase().endsWith(".flt")) {
            try {
                GridFloat gf = new GridFloat(filenameOrURL);
                gf.readGrid();
                PlanarImage pImage = gf.getPlanarImage();
                WritableRaster rData = pImage.copyData();
                rasterData = rData;
                ParameterBlock pbMaxMin = new ParameterBlock();
                pbMaxMin.addSource(pImage);
                RenderedOp extrema = JAI.create((String)"extrema", (ParameterBlock)pbMaxMin);
                double minValue = gf.getMinVal();
                double maxValue = gf.getMaxVal();
                double[] subtractThis = new double[]{minValue};
                double[] multiplyBy = new double[]{255.0 / (maxValue - minValue)};
                ParameterBlock pbSub = new ParameterBlock();
                pbSub.addSource(pImage);
                pbSub.add(subtractThis);
                RenderedOp surrogateImage = JAI.create((String)"subtractconst", (ParameterBlock)pbSub, null);
                ParameterBlock pbMult = new ParameterBlock();
                pbMult.addSource(surrogateImage);
                pbMult.add(multiplyBy);
                surrogateImage = JAI.create((String)"multiplyconst", (ParameterBlock)pbMult, null);
                ParameterBlock pbConvert = new ParameterBlock();
                pbConvert.addSource(surrogateImage);
                pbConvert.add(0);
                surrogateImage = JAI.create((String)"format", (ParameterBlock)pbConvert);
                return surrogateImage;
            }
            catch (Throwable e) {
                if (e.getMessage().indexOf("Error in FLT file") > -1) {
                    context.getWorkbench().getFrame().warnUser("unsupported-flt");
                }
                context.getWorkbench().getFrame().warnUser("problems-loading-image" + e.getMessage());
            }
        } else if (filenameOrURL.toLowerCase().endsWith(".asc")) {
            try {
                GridAscii ga = new GridAscii(filenameOrURL);
                ga.readGrid();
                PlanarImage pImage = ga.getPlanarImage();
                WritableRaster rData = pImage.copyData();
                rasterData = rData;
                ParameterBlock pbMaxMin = new ParameterBlock();
                pbMaxMin.addSource(pImage);
                RenderedOp extrema = JAI.create((String)"extrema", (ParameterBlock)pbMaxMin);
                double minValue = ga.getMinVal();
                double maxValue = ga.getMaxVal();
                double[] subtractThis = new double[]{minValue};
                double[] multiplyBy = new double[]{255.0 / (maxValue - minValue)};
                ParameterBlock pbSub = new ParameterBlock();
                pbSub.addSource(pImage);
                pbSub.add(subtractThis);
                RenderedOp surrogateImage = JAI.create((String)"subtractconst", (ParameterBlock)pbSub, null);
                ParameterBlock pbMult = new ParameterBlock();
                pbMult.addSource(surrogateImage);
                pbMult.add(multiplyBy);
                surrogateImage = JAI.create((String)"multiplyconst", (ParameterBlock)pbMult, null);
                ParameterBlock pbConvert = new ParameterBlock();
                pbConvert.addSource(surrogateImage);
                pbConvert.add(0);
                surrogateImage = JAI.create((String)"format", (ParameterBlock)pbConvert);
                return surrogateImage;
            }
            catch (Throwable e) {
                if (e.getMessage().indexOf("Error in ASCII file") > -1) {
                    context.getWorkbench().getFrame().warnUser("unsupported-ascii");
                }
                context.getWorkbench().getFrame().warnUser("problems-loading-image" + e.getMessage());
            }
        }
        return null;
    }

    private static PlanarImage stretchImageValuesForDisplay(RenderedImage pImage) {
        ParameterBlock pbMaxMin = new ParameterBlock();
        pbMaxMin.addSource(pImage);
        RenderedOp extrema = JAI.create((String)"extrema", (ParameterBlock)pbMaxMin);
        double[] allMins = (double[])extrema.getProperty("minimum");
        double[] allMaxs = (double[])extrema.getProperty("maximum");
        double minValue = allMins[0];
        double maxValue = allMaxs[0];
        for (int v = 1; v < allMins.length; ++v) {
            if (allMins[v] < minValue) {
                minValue = allMins[v];
            }
            if (!(allMaxs[v] > maxValue)) continue;
            maxValue = allMaxs[v];
        }
        double[] subtractThis = new double[]{minValue};
        double[] multiplyBy = new double[]{255.0 / (maxValue - minValue)};
        ParameterBlock pbSub = new ParameterBlock();
        pbSub.addSource(pImage);
        pbSub.add(subtractThis);
        RenderedOp surrogateImage = JAI.create((String)"subtractconst", (ParameterBlock)pbSub, null);
        ParameterBlock pbMult = new ParameterBlock();
        pbMult.addSource(surrogateImage);
        pbMult.add(multiplyBy);
        surrogateImage = JAI.create((String)"multiplyconst", (ParameterBlock)pbMult, null);
        ParameterBlock pbConvert = new ParameterBlock();
        pbConvert.addSource(surrogateImage);
        pbConvert.add(0);
        surrogateImage = JAI.create((String)"format", (ParameterBlock)pbConvert);
        return surrogateImage;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(Envelope envelope) {
        this.envelope = envelope;
        this.forceTotalRepaint();
        if (this.isFiringAppearanceEvents()) {
            this.fireAppearanceChanged();
        }
    }

    public String getXmlEnvelope() {
        return this.envelope.toString();
    }

    public void setXmlEnvelope(String envStr) {
        String coords = envStr.substring(envStr.indexOf("[") + 1, envStr.indexOf("]"));
        String[] coordArray = coords.split(",");
        String[] xCoords = coordArray[0].split(":");
        String[] yCoords = coordArray[1].split(":");
        double minX = Double.parseDouble(xCoords[0]);
        double maxX = Double.parseDouble(xCoords[1]);
        double minY = Double.parseDouble(yCoords[0]);
        double maxY = Double.parseDouble(yCoords[1]);
        this.setEnvelope(new Envelope(minX, maxX, minY, maxY));
    }

    public Polygon getEnvelopeAsGeometry() {
        Coordinate[] coordinates = new Coordinate[]{new Coordinate(this.envelope.getMinX(), this.envelope.getMaxY()), new Coordinate(this.envelope.getMaxX(), this.envelope.getMaxY()), new Coordinate(this.envelope.getMaxX(), this.envelope.getMinY()), new Coordinate(this.envelope.getMinX(), this.envelope.getMinY()), new Coordinate(this.envelope.getMinX(), this.envelope.getMaxY())};
        GeometryFactory gf = new GeometryFactory();
        return gf.createPolygon(gf.createLinearRing(coordinates), null);
    }

    public void setGeometryAsEnvelope(Geometry geometry) {
        this.setEnvelope(geometry.getEnvelopeInternal());
    }

    private BufferedImage setupTransparency(PlanarImage pImage) {
        BufferedImage bim = pImage.getAsBufferedImage();
        ColorModel cm = bim.getColorModel();
        int fullTransparencyAlpha = 255;
        if (this.getTransparentColor() == null) {
            return null;
        }
        int transparentColor = this.getTransparentColor().getRGB();
        int currentColor = -1;
        int[] argb = new int[4];
        if (!cm.hasAlpha()) {
            bim = RasterImageLayer.makeBufferedImage(bim);
            cm = bim.getColorModel();
        }
        for (int w = 0; w < bim.getWidth(); ++w) {
            for (int h = 0; h < bim.getHeight(); ++h) {
                currentColor = bim.getRGB(w, h);
                if (currentColor != transparentColor) continue;
                argb[0] = fullTransparencyAlpha;
                argb[1] = cm.getRed(currentColor);
                argb[2] = cm.getGreen(currentColor);
                argb[3] = cm.getBlue(currentColor);
                bim.setRGB(w, h, 1, 1, argb, 0, 1);
            }
        }
        return bim;
    }

    private void setImageProcessingMode(int nr) {
        if (this.lastImgProcessingMode != nr) {
            if (this.imageProcessingStep1 != null) {
                this.imageProcessingStep1.dispose();
            }
            this.imageProcessingStep1 = null;
            if (this.imageProcessingStep2 != null) {
                this.imageProcessingStep2.dispose();
            }
            this.imageProcessingStep2 = null;
            this.imagePart = null;
            this.oldImagePart = null;
            this.oldScaleXImg2Canvas = -1.0;
            if ((double)Runtime.getRuntime().freeMemory() < RasterImageLayer.getMinRamToKeepFree()) {
                Runtime.getRuntime().gc();
            }
            this.lastImgProcessingMode = nr;
        }
    }

    private static boolean tilesAreNotNullAndCongruent(Rectangle r1, Rectangle r2) {
        boolean result = r1 == null || r2 == null ? false : r1.x == r2.x && r1.y == r2.y && r1.width == r2.width && r1.height == r2.height;
        return result;
    }

    public static final BufferedImage makeBufferedImage(Image im) {
        BufferedImage copy = new BufferedImage(im.getWidth(null), im.getHeight(null), 2);
        Graphics2D g2d = copy.createGraphics();
        g2d.drawImage(im, 0, 0, null);
        g2d.dispose();
        return copy;
    }

    protected PlanarImage getScaledImageMatchingVisible(PlanarImage toBeScaled, double XscaleImg2Canvas, double YscaleImg2Canvas) {
        if (toBeScaled == null) {
            return null;
        }
        int scaledWidth = (int)((double)toBeScaled.getWidth() * XscaleImg2Canvas);
        int scaledHeight = (int)((double)toBeScaled.getHeight() * Math.abs(YscaleImg2Canvas));
        if (scaledWidth <= 0 || scaledHeight <= 0) {
            return null;
        }
        return this.scaleImage(toBeScaled, (float)XscaleImg2Canvas, (float)Math.abs(YscaleImg2Canvas));
    }

    public BufferedImage getTileAsImage(Envelope wantedEnvelope) {
        double imgWidth = this.origImageWidth;
        double imgHeight = this.origImageHeight;
        Envelope imageEnv = this.getEnvelope();
        double minVisibleX = Math.max(wantedEnvelope.getMinX(), imageEnv.getMinX());
        double minVisibleY = Math.max(wantedEnvelope.getMinY(), imageEnv.getMinY());
        double maxVisibleX = Math.min(wantedEnvelope.getMaxX(), imageEnv.getMaxX());
        double maxVisibleY = Math.min(wantedEnvelope.getMaxY(), imageEnv.getMaxY());
        double offset2VisibleX = imageEnv.getMinX() - wantedEnvelope.getMinX();
        double offset2VisibleY = wantedEnvelope.getMaxY() - imageEnv.getMaxY();
        double scaleX = imgWidth / imageEnv.getWidth();
        double scaleY = imgHeight / imageEnv.getHeight();
        int xOffset = offset2VisibleX >= 0.0 ? 0 : (int)(-offset2VisibleX * scaleX);
        int yOffset = offset2VisibleY >= 0.0 ? 0 : (int)(-offset2VisibleY * scaleY);
        int width = (int)((maxVisibleX - minVisibleX) * scaleX);
        int height = (int)((maxVisibleY - minVisibleY) * scaleY);
        if ((double)width < imgWidth && (double)height < imgHeight) {
            ++width;
            ++height;
        }
        if (width <= 0 || height <= 0) {
            return null;
        }
        int wantedWidth = (int)(wantedEnvelope.getWidth() * scaleX);
        int wantedHeight = (int)(wantedEnvelope.getHeight() * scaleY);
        if (this.image == null) {
            this.reLoadImage();
        }
        BufferedImage imgTile = this.image.getAsBufferedImage(new Rectangle(xOffset, yOffset, width, height), this.image.getColorModel());
        BufferedImage result = new BufferedImage(wantedWidth, wantedHeight, 2);
        Graphics2D graf = result.createGraphics();
        Color backgroundColor = this.transparentColor != null ? this.transparentColor : Color.white;
        graf.fillRect(0, 0, wantedWidth, wantedHeight);
        int xTileOffset = xOffset > 0 ? 0 : (int)(offset2VisibleX * scaleX);
        int yTileOffset = yOffset > 0 ? 0 : (int)(offset2VisibleY * scaleY);
        graf.drawImage(imgTile, xTileOffset, yTileOffset, imgTile.getWidth(), imgTile.getHeight(), backgroundColor, null);
        graf.dispose();
        this.clearImageAndRaster(false);
        return result;
    }

    public Raster getTileAsRaster(Envelope wantedEnvelope) {
        double imgWidth = this.origImageWidth;
        double imgHeight = this.origImageHeight;
        Envelope imageEnv = this.getEnvelope();
        double minVisibleX = Math.max(wantedEnvelope.getMinX(), imageEnv.getMinX());
        double minVisibleY = Math.max(wantedEnvelope.getMinY(), imageEnv.getMinY());
        double maxVisibleX = Math.min(wantedEnvelope.getMaxX(), imageEnv.getMaxX());
        double maxVisibleY = Math.min(wantedEnvelope.getMaxY(), imageEnv.getMaxY());
        double offset2VisibleX = imageEnv.getMinX() - wantedEnvelope.getMinX();
        double offset2VisibleY = wantedEnvelope.getMaxY() - imageEnv.getMaxY();
        double scaleX = imgWidth / imageEnv.getWidth();
        double scaleY = imgHeight / imageEnv.getHeight();
        int xOffset = offset2VisibleX >= 0.0 ? 0 : (int)(-offset2VisibleX * scaleX);
        int yOffset = offset2VisibleY >= 0.0 ? 0 : (int)(-offset2VisibleY * scaleY);
        int width = (int)((maxVisibleX - minVisibleX) * scaleX);
        int height = (int)((maxVisibleY - minVisibleY) * scaleY);
        if ((double)width < imgWidth && (double)height < imgHeight) {
            ++width;
            ++height;
        }
        if (width <= 0 || height <= 0) {
            return null;
        }
        int wantedWidth = (int)(wantedEnvelope.getWidth() * scaleX);
        int wantedHeight = (int)(wantedEnvelope.getHeight() * scaleY);
        if (rasterData == null) {
            this.reLoadImage();
        }
        ColorModel colorModel = PlanarImage.createColorModel((SampleModel)rasterData.getSampleModel());
        BufferedImage bufimg = new BufferedImage(colorModel, (WritableRaster)rasterData, false, null);
        PlanarImage pimage = PlanarImage.wrapRenderedImage((RenderedImage)bufimg);
        BufferedImage imgTile = pimage.getAsBufferedImage(new Rectangle(xOffset, yOffset, width, height), pimage.getColorModel());
        BufferedImage result = new BufferedImage(wantedWidth, wantedHeight, 2);
        Graphics2D graf = result.createGraphics();
        Color backgroundColor = this.transparentColor != null ? this.transparentColor : Color.white;
        graf.fillRect(0, 0, wantedWidth, wantedHeight);
        int xTileOffset = xOffset > 0 ? 0 : (int)(offset2VisibleX * scaleX);
        int yTileOffset = yOffset > 0 ? 0 : (int)(offset2VisibleY * scaleY);
        graf.drawImage(imgTile, xTileOffset, yTileOffset, imgTile.getWidth(), imgTile.getHeight(), backgroundColor, null);
        graf.dispose();
        this.clearImageAndRaster(false);
        return result.getData();
    }

    protected WorkbenchContext getWorkbenchContext() {
        return (WorkbenchContext)this.getBlackboard().get(BLACKBOARD_KEY_WORKBENCHCONTEXT);
    }

    public static void setWorkbenchContext(WorkbenchContext wContext) {
        if (blackboard == null) {
            blackboard = new Blackboard();
        }
        blackboard.put(BLACKBOARD_KEY_WORKBENCHCONTEXT, wContext);
    }

    public Rectangle getDrawingRectangle(double imgWidth, double imgHeight, Envelope imageEnv, Viewport viewport) throws NoninvertibleTransformException {
        Rectangle visible = viewport.getPanel().getVisibleRect();
        Point2D upperLeftCorner = null;
        Point2D lowerRightCorner = null;
        try {
            upperLeftCorner = viewport.toViewPoint(new Coordinate(imageEnv.getMinX(), imageEnv.getMaxY()));
            lowerRightCorner = viewport.toViewPoint(new Coordinate(imageEnv.getMaxX(), imageEnv.getMinY()));
        }
        catch (NoninvertibleTransformException ne) {
            ne.printStackTrace();
            return null;
        }
        int visibleX1 = visible.x;
        int visibleY1 = visible.y;
        int visibleX2 = visibleX1 + visible.width;
        int visibleY2 = visibleY1 + visible.height;
        Coordinate upperLeftVisible = viewport.toModelCoordinate((Point2D)nullpunkt);
        Coordinate lowerRightVisible = viewport.toModelCoordinate((Point2D)new Point(visibleX2, visibleY2));
        Envelope newVisibleEnv = new Envelope(upperLeftVisible.x, lowerRightVisible.x, upperLeftVisible.y, lowerRightVisible.y);
        Rectangle rect = this.getVisibleImageCoordinatesOfImage(imgWidth, imgHeight, newVisibleEnv, imageEnv);
        if (rect == null) {
            return null;
        }
        double scaledWidth = lowerRightCorner.getX() - upperLeftCorner.getX();
        double scaledHeight = upperLeftCorner.getY() - lowerRightCorner.getY();
        double scaleXImg2Canvas = scaledWidth / imgWidth;
        double scaleYImg2Canvas = scaledHeight / imgHeight;
        rect.width = (int)((double)rect.width * scaleXImg2Canvas);
        rect.height = (int)((double)rect.height * scaleYImg2Canvas);
        return rect;
    }

    protected Rectangle getVisibleImageCoordinatesOfImage(double imgWidth, double imgHeight, Envelope visible, Envelope imageEnv) {
        double minVisibleX = Math.max(visible.getMinX(), imageEnv.getMinX());
        double minVisibleY = Math.max(visible.getMinY(), imageEnv.getMinY());
        double maxVisibleX = Math.min(visible.getMaxX(), imageEnv.getMaxX());
        double maxVisibleY = Math.min(visible.getMaxY(), imageEnv.getMaxY());
        double offset2VisibleX = imageEnv.getMinX() - visible.getMinX();
        double offset2VisibleY = visible.getMaxY() - imageEnv.getMaxY();
        double scaleX = imgWidth / imageEnv.getWidth();
        double scaleY = imgHeight / imageEnv.getHeight();
        this.xOffset = offset2VisibleX >= 0.0 ? 0 : (int)(-offset2VisibleX * scaleX);
        this.yOffset = offset2VisibleY >= 0.0 ? 0 : (int)(-offset2VisibleY * scaleY);
        int width = (int)((maxVisibleX - minVisibleX) * scaleX);
        int height = (int)((maxVisibleY - minVisibleY) * scaleY);
        if ((double)width < imgWidth && (double)height < imgHeight) {
            ++width;
            ++height;
        }
        if (width <= 0 || height <= 0) {
            return null;
        }
        return new Rectangle(this.xOffset, this.yOffset, width, height);
    }

    protected Rectangle getVisibleImageCoordinatesOfImage(PlanarImage img, Envelope visible, Envelope imageEnv) {
        return this.getVisibleImageCoordinatesOfImage(img.getWidth(), img.getHeight(), visible, imageEnv);
    }

    protected PlanarImage getVisiblePartOfTheImage(PlanarImage img, Rectangle desiredImageArea) {
        if (desiredImageArea == null) {
            return null;
        }
        if (desiredImageArea.width > 0 && desiredImageArea.height > 0 && desiredImageArea.width + desiredImageArea.x <= img.getWidth() && desiredImageArea.height + desiredImageArea.y <= img.getHeight()) {
            return PlanarImage.wrapRenderedImage((RenderedImage)img.getAsBufferedImage(new Rectangle(desiredImageArea.x, desiredImageArea.y, desiredImageArea.width, desiredImageArea.height), img.getColorModel()));
        }
        return null;
    }

    public void setImage(PlanarImage image) {
        this.image = image;
        this.origImageWidth = image.getWidth();
        this.origImageHeight = image.getHeight();
        this.imageSet = true;
    }

    public void setImageSet(boolean imageSet) {
        this.imageSet = imageSet;
    }

    public boolean isImageNull() {
        return this.image == null;
    }

    public PlanarImage getImageForDisplay() {
        if (this.image == null) {
            this.reLoadImage();
        }
        return this.image;
    }

    public boolean isImageSet() {
        return this.imageSet;
    }

    public double getTransparencyLevel() {
        return this.transparencyLevel;
    }

    public void setTransparencyLevel(double transparencyLevel) {
        if (transparencyLevel != this.transparencyLevel) {
            this.transparencyLevel = transparencyLevel;
            if (this.isFiringAppearanceEvents()) {
                this.fireAppearanceChanged();
            }
        }
    }

    public void setTransparencyLevelInPercent(int transparencyInPercent) {
        double tLevel = (double)transparencyInPercent / 100.0;
        if (tLevel != this.transparencyLevel) {
            this.transparencyLevel = tLevel;
            if (this.isFiringAppearanceEvents()) {
                this.fireAppearanceChanged();
            }
        }
    }

    public Color getTransparentColor() {
        return this.transparentColor;
    }

    public String getTransparentColorAsString() {
        if (this.getTransparentColor() == null) {
            return "null";
        }
        String hexColor = Integer.toHexString(this.getTransparentColor().getRGB());
        if (hexColor.length() > 6) {
            hexColor = hexColor.substring(2);
        }
        return hexColor;
    }

    public void setTransparentColorAsString(String hexColorString) {
        if (hexColorString == null || hexColorString.equals("null")) {
            return;
        }
        int rgb = Integer.parseInt(hexColorString.toUpperCase(), 16);
        Color tColor = new Color(rgb);
        this.setTransparentColor(tColor);
    }

    public void setTransparentColor(Color transparentColor) {
        if (!(this.transparentColor == transparentColor || this.transparentColor != null && this.transparentColor.equals(transparentColor))) {
            this.transparentColor = transparentColor;
            this.forceTotalRepaint();
            if (this.isFiringAppearanceEvents()) {
                this.fireAppearanceChanged();
            }
        }
    }

    protected void forceTotalRepaint() {
        this.visibleEnv = null;
        this.setImageProcessingMode(0);
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public static double getFreeRamFactor() {
        return freeRamFactor;
    }

    public static void setFreeRamFactor(double freeRamFactor) {
        RasterImageLayer.freeRamFactor = freeRamFactor;
        minRamToKeepFree = (double)availRAM * RasterImageLayer.freeRamFactor;
        maxPixelsForFastDisplayMode = (int)(((double)availRAM - minRamToKeepFree) / 1048576.0 * 3000.0);
    }

    public static long getAvailRAM() {
        return availRAM;
    }

    public static int getMaxPixelsForFastDisplayMode() {
        return maxPixelsForFastDisplayMode;
    }

    public static double getMinRamToKeepFree() {
        return minRamToKeepFree;
    }

    public void setImageFileName(String imageFileName) {
        this.imageFileName = imageFileName;
        this.setNeedToKeepImage(false);
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public boolean isNeedToKeepImage() {
        return this.needToKeepImage;
    }

    public void setNeedToKeepImage(boolean needToKeepImage) {
        this.needToKeepImage = needToKeepImage;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.flushImages(true);
    }

    public int getOrigImageHeight() {
        return this.origImageHeight;
    }

    public int getOrigImageWidth() {
        return this.origImageWidth;
    }

    public void setOrigImageHeight(int origImageHeight) {
        this.origImageHeight = origImageHeight;
    }

    public void setOrigImageWidth(int origImageWidth) {
        this.origImageWidth = origImageWidth;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.clearImageAndRaster(true);
        }
        if (this.isFiringAppearanceEvents()) {
            this.fireAppearanceChanged();
        }
    }

    public boolean isFiringAppearanceEvents() {
        return this.firingAppearanceEvents;
    }

    public void setFiringAppearanceEvents(boolean firingAppearanceEvents) {
        this.firingAppearanceEvents = firingAppearanceEvents;
    }

    public MetaDataMap getMetaInformation() {
        return this.metaInformation;
    }

    public void setMetaInformation(MetaDataMap metaInformation) {
        this.metaInformation = metaInformation;
    }

    public Raster getRasterData() {
        this.reLoadImageButKeepImageForDisplay();
        return rasterData;
    }

    public void setRasterData(Raster newRaster) {
        rasterData = newRaster;
        this.setRasterDataChanged(true);
    }

    public boolean isRasterDataChanged() {
        return this.rasterDataChanged;
    }

    public void setRasterDataChanged(boolean rasterDataChanged) {
        this.rasterDataChanged = rasterDataChanged;
    }
}

