/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.TiledImage;

public class GridAscii {
    private String ascFullFileName = null;
    private boolean origCorner = false;
    private int nCols = 0;
    private int nRows = 0;
    private double xllCorner = 0.0;
    private double yllCorner = 0.0;
    private double cellSize = 0.0;
    private double noData = -9999.0;
    private double[] dataArray = null;
    private Raster raster = null;
    private long cellCount = 0L;
    private double minVal = Double.MAX_VALUE;
    private double maxVal = -1.7976931348623157E308;
    private double meanVal = 0.0;
    private double stDevVal = 0.0;
    private boolean isInteger = true;

    public GridAscii(String ascFullFileName) {
        this.ascFullFileName = ascFullFileName;
        this.readHeader();
    }

    public GridAscii(String ascFullFileName, GridAscii gridAscii2) {
        this.ascFullFileName = ascFullFileName;
        this.nCols = gridAscii2.getnCols();
        this.nRows = gridAscii2.getnRows();
        this.xllCorner = gridAscii2.getXllCorner();
        this.yllCorner = gridAscii2.getYllCorner();
        this.cellSize = gridAscii2.getCellSize();
        this.noData = gridAscii2.getNoData();
    }

    public GridAscii(String ascFullFileName, int nCols, int nRows, boolean origCorner, double xllOrig, double yllOrig, double cellSize, double noData, String byteOrder) {
        this.ascFullFileName = ascFullFileName;
        this.nCols = nCols;
        this.nRows = nRows;
        this.origCorner = origCorner;
        if (origCorner) {
            this.xllCorner = xllOrig;
            this.yllCorner = yllOrig;
        } else {
            this.xllCorner = xllOrig - 0.5 * cellSize;
            this.yllCorner = yllOrig - 0.5 * cellSize;
        }
        this.cellSize = cellSize;
        this.noData = noData;
    }

    public final int readHeader() {
        try {
            BufferedReader buffRead = new BufferedReader(new FileReader(this.ascFullFileName));
            String line = null;
            String[] lines = null;
            int nDecimalsXll = 0;
            int nDecimalsYll = 0;
            int nDecimalsCellSize = 0;
            String[] header = new String[6];
            for (int l = 0; l < 6; ++l) {
                line = buffRead.readLine();
                lines = line.split(" +");
                if (lines[0].trim().toLowerCase().equals("ncols")) {
                    header[0] = lines[1];
                }
                if (lines[0].trim().toLowerCase().equals("nrows")) {
                    header[1] = lines[1];
                }
                if (lines[0].trim().toLowerCase().equals("xllcorner")) {
                    header[2] = lines[1];
                    this.origCorner = true;
                    nDecimalsXll = lines[1].length() - lines[1].lastIndexOf(".") - 1;
                }
                if (lines[0].trim().toLowerCase().equals("yllcorner")) {
                    header[3] = lines[1];
                    this.origCorner = true;
                    nDecimalsYll = lines[1].length() - lines[1].lastIndexOf(".") - 1;
                }
                if (lines[0].trim().toLowerCase().equals("xllcenter")) {
                    header[2] = lines[1];
                    this.origCorner = false;
                    nDecimalsXll = lines[1].length() - lines[1].lastIndexOf(".") - 1;
                }
                if (lines[0].trim().toLowerCase().equals("yllcenter")) {
                    header[3] = lines[1];
                    this.origCorner = false;
                    nDecimalsYll = lines[1].length() - lines[1].lastIndexOf(".") - 1;
                }
                if (lines[0].trim().toLowerCase().equals("cellsize")) {
                    header[4] = lines[1];
                    nDecimalsCellSize = lines[1].length() - lines[1].lastIndexOf(".") - 1;
                }
                if (!lines[0].trim().toLowerCase().equals("nodata_value")) continue;
                header[5] = lines[1];
            }
            buffRead.close();
            this.nCols = Integer.parseInt(header[0]);
            this.nRows = Integer.parseInt(header[1]);
            this.xllCorner = Double.parseDouble(header[2]);
            this.yllCorner = Double.parseDouble(header[3]);
            this.cellSize = Double.parseDouble(header[4]);
            this.noData = Double.parseDouble(header[5]);
            if (!this.origCorner) {
                this.xllCorner += 0.5 * this.cellSize;
                this.yllCorner += 0.5 * this.cellSize;
            }
            return 0;
        }
        catch (Exception ex) {
            return 1;
        }
    }

    public int readGrid() {
        int ret = this.readHeader();
        if (ret != 0) {
            return 1;
        }
        double valSum = 0.0;
        double valSumSquare = 0.0;
        this.minVal = Double.MAX_VALUE;
        this.maxVal = -this.minVal;
        try {
            BufferedReader buffRead = new BufferedReader(new FileReader(this.ascFullFileName));
            for (int l = 0; l <= 5; ++l) {
                buffRead.readLine();
            }
            String dtmLine = null;
            String[] dtmLines = null;
            boolean col = false;
            boolean row = false;
            int line = 0;
            int cell = 0;
            this.cellCount = 0L;
            this.dataArray = new double[this.nCols * this.nRows];
            while ((dtmLine = buffRead.readLine()) != null) {
                dtmLine = dtmLine.trim();
                dtmLines = dtmLine.split(" +");
                for (int c = 0; c < dtmLines.length; ++c) {
                    this.dataArray[cell] = Double.parseDouble(dtmLines[c]);
                    if (this.dataArray[cell] != this.noData) {
                        valSum += this.dataArray[cell];
                        valSumSquare += this.dataArray[cell] * this.dataArray[cell];
                        ++this.cellCount;
                        if (this.dataArray[cell] < this.minVal) {
                            this.minVal = this.dataArray[cell];
                        }
                        if (this.dataArray[cell] > this.maxVal) {
                            this.maxVal = this.dataArray[cell];
                        }
                        if ((double)((int)this.dataArray[cell]) != this.dataArray[cell]) {
                            this.isInteger = false;
                        }
                    }
                    ++cell;
                }
                ++line;
            }
            buffRead.close();
            this.meanVal = valSum / (double)this.cellCount;
            this.stDevVal = Math.sqrt(valSumSquare / (double)this.cellCount - this.meanVal * this.meanVal);
            SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)4, (int)this.nCols, (int)this.nRows, (int)1);
            DataBufferDouble db = new DataBufferDouble(this.dataArray, this.nCols * this.nRows);
            Point point = new Point();
            point.setLocation(this.xllCorner, this.yllCorner);
            this.raster = RasterFactory.createRaster((SampleModel)sampleModel, (DataBuffer)db, (Point)point);
            return 0;
        }
        catch (Exception ex) {
            return 1;
        }
    }

    public void setHeaderEqualTo(GridAscii gridAscii) {
        this.nCols = gridAscii.getnCols();
        this.nRows = gridAscii.getnRows();
        this.xllCorner = gridAscii.getXllCorner();
        this.yllCorner = gridAscii.getYllCorner();
        this.cellSize = gridAscii.getCellSize();
        this.noData = gridAscii.getNoData();
        this.origCorner = gridAscii.origCorner;
    }

    public boolean isSpatiallyEqualTo(GridAscii gridAscii2) {
        boolean isEqual = true;
        if (this.nCols != gridAscii2.getnCols()) {
            isEqual = false;
        }
        if (this.nRows != gridAscii2.getnRows()) {
            isEqual = false;
        }
        if (this.origCorner != gridAscii2.getOrigCorner()) {
            isEqual = false;
        }
        if (this.xllCorner != gridAscii2.getXllCorner()) {
            isEqual = false;
        }
        if (this.yllCorner != gridAscii2.getYllCorner()) {
            isEqual = false;
        }
        if (this.cellSize != gridAscii2.getCellSize()) {
            isEqual = false;
        }
        if (this.noData != gridAscii2.getNoData()) {
            isEqual = false;
        }
        return isEqual;
    }

    public PlanarImage getPlanarImage() {
        try {
            SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)4, (int)this.nCols, (int)this.nRows, (int)1);
            TiledImage tiledImage = new TiledImage(0, 0, this.nCols, this.nRows, 0, 0, sampleModel, null);
            WritableRaster wraster = tiledImage.getWritableTile(0, 0);
            wraster.setPixels(0, 0, this.nCols, this.nRows, this.dataArray);
            tiledImage.setData((Raster)wraster);
            return tiledImage;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return null;
        }
    }

    public int getnCols() {
        return this.nCols;
    }

    public void setnCols(int nCols) {
        this.nCols = nCols;
    }

    public int getnRows() {
        return this.nRows;
    }

    public void setnRows(int nRows) {
        this.nRows = nRows;
    }

    public double getXllCorner() {
        return this.xllCorner;
    }

    public void setXllCorner(double xllCorner) {
        this.xllCorner = xllCorner;
    }

    public double getYllCorner() {
        return this.yllCorner;
    }

    public void setYllCorner(double yllCorner) {
        this.yllCorner = yllCorner;
    }

    public boolean getOrigCorner() {
        return this.origCorner;
    }

    public void setOrigCorner(boolean origCorner) {
        this.origCorner = origCorner;
    }

    public double getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(double cellSize) {
        this.cellSize = cellSize;
    }

    public double getNoData() {
        return this.noData;
    }

    public void setNoData(double noData) {
        this.noData = noData;
    }

    public Raster getRaster() {
        return this.raster;
    }

    public void setRas(Raster raster) {
        this.raster = raster;
        this.cellCount = 0L;
        DataBuffer db = raster.getDataBuffer();
        for (int e = 0; e < db.getSize(); ++e) {
            if ((double)db.getElemFloat(e) == this.noData) continue;
            ++this.cellCount;
        }
    }

    public double getMinVal() {
        return this.minVal;
    }

    public double getMaxVal() {
        return this.maxVal;
    }

    public double getMeanVal() {
        return this.meanVal;
    }

    public double getStDevVal() {
        return this.stDevVal;
    }

    public long getCellCount() {
        return this.cellCount;
    }

    public boolean isInteger() {
        return this.isInteger;
    }
}

