/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util.java2xml;

import com.vividsolutions.jump.util.java2xml.XMLBinder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class Java2XML
extends XMLBinder {
    private static Logger LOG = Logger.getLogger(Java2XML.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String write(Object object, String rootTagName) throws Exception {
        StringWriter writer = new StringWriter();
        try {
            this.write(object, rootTagName, writer);
            String string = writer.toString();
            return string;
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object object, String rootTagName, File file) throws Exception {
        FileWriter fileWriter = new FileWriter(file, false);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            try {
                new Java2XML().write(object, rootTagName, bufferedWriter);
                bufferedWriter.flush();
                fileWriter.flush();
            }
            finally {
                bufferedWriter.close();
            }
        }
        finally {
            fileWriter.close();
        }
    }

    public void write(Object object, String rootTagName, Writer writer) throws Exception {
        Document document = new Document(new Element(rootTagName));
        this.write(object, document.getRootElement(), this.specElements(object.getClass()));
        XMLOutputter xmlOutputter = new XMLOutputter();
        xmlOutputter.setNewlines(true);
        xmlOutputter.setIndent(true);
        xmlOutputter.output(document, writer);
    }

    private void write(final Object object, final Element tag, List specElements) throws Exception {
        try {
            this.visit(specElements, new XMLBinder.SpecVisitor(){

                public void tagSpecFound(String xmlName, String javaName, List specChildElements) throws Exception {
                    ArrayList<Element> childTags = new ArrayList<Element>();
                    if (javaName != null) {
                        childTags.addAll(Java2XML.this.writeChildTags(tag, xmlName, Java2XML.this.getter(object.getClass(), javaName).invoke(object, new Object[0]), Java2XML.this.specifyingTypeExplicitly(Java2XML.this.fieldClass(Java2XML.this.setter(object.getClass(), javaName)))));
                    } else {
                        Element childTag = new Element(xmlName);
                        tag.addContent(childTag);
                        childTags.add(childTag);
                    }
                    for (Element childTag : childTags) {
                        Java2XML.this.write(object, childTag, specChildElements);
                    }
                }

                public void attributeSpecFound(String xmlName, String javaName) throws Exception {
                    Java2XML.this.writeAttribute(tag, xmlName, Java2XML.this.getter(object.getClass(), javaName).invoke(object, new Object[0]));
                }
            }, object.getClass());
        }
        catch (Exception e) {
            LOG.error((Object)("Java2XML: Exception writing " + object.getClass()));
            throw e;
        }
    }

    private void writeAttribute(Element tag, String name, Object value) throws XMLBinder.XMLBinderException {
        if (value == null) {
            throw new XMLBinder.XMLBinderException("Cannot store null value as attribute. Store as element instead. (" + name + ").");
        }
        tag.setAttribute(new Attribute(name, this.toXML(value)));
    }

    private Element writeChildTag(Element tag, String name, Object value, boolean specifyingType) throws Exception {
        Element childTag = new Element(name);
        if (value != null && specifyingType) {
            childTag.setAttribute(new Attribute("class", value.getClass().getName()));
        }
        if (value == null) {
            childTag.setAttribute(new Attribute("null", "true"));
        } else if (this.hasCustomConverter(value.getClass())) {
            childTag.setText(this.toXML(value));
        } else if (value instanceof Map) {
            for (Object key : ((Map)value).keySet()) {
                Element mappingTag = new Element("mapping");
                childTag.addContent(mappingTag);
                this.writeChildTag(mappingTag, "key", key, true);
                this.writeChildTag(mappingTag, "value", ((Map)value).get(key), true);
            }
        } else if (value instanceof Collection) {
            for (Object item : (Collection)value) {
                this.writeChildTag(childTag, "item", item, true);
            }
        } else if (value instanceof QName) {
            childTag.addContent(value.toString());
        } else {
            this.write(value, childTag, this.specElements(value.getClass()));
        }
        tag.addContent(childTag);
        return childTag;
    }

    private Collection writeChildTags(Element tag, String name, Object value, boolean specifyingType) throws Exception {
        ArrayList<Element> childTags = new ArrayList<Element>();
        if (value instanceof Collection) {
            for (Object item : (Collection)value) {
                childTags.add(this.writeChildTag(tag, name, item, specifyingType));
            }
        } else {
            childTags.add(this.writeChildTag(tag, name, value, specifyingType));
        }
        return childTags;
    }

    private Method getter(Class fieldClass, String field) throws XMLBinder.XMLBinderException {
        int i;
        Method[] methods = fieldClass.getMethods();
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().toUpperCase().equals("GET" + field.toUpperCase()) && !methods[i].getName().toUpperCase().equals("IS" + field.toUpperCase()) || methods[i].getParameterTypes().length != 0) continue;
            return methods[i];
        }
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().toUpperCase().startsWith("GET" + field.toUpperCase()) && !methods[i].getName().toUpperCase().startsWith("IS" + field.toUpperCase()) || methods[i].getParameterTypes().length != 0) continue;
            return methods[i];
        }
        throw new XMLBinder.XMLBinderException("Could not find getter named like '" + field + "' " + fieldClass);
    }
}

