/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.transcoder.wmf.tosvg.AbstractWMFReader;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;

public class WMFRecordStore
extends AbstractWMFReader {
    private URL url;
    protected int numRecords;
    protected float vpX;
    protected float vpY;
    protected List records;
    private boolean _bext = true;

    public WMFRecordStore() {
        this.reset();
    }

    public void reset() {
        this.numRecords = 0;
        this.vpX = 0.0f;
        this.vpY = 0.0f;
        this.vpW = 1000;
        this.vpH = 1000;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.inch = 0;
        this.records = new ArrayList(20);
    }

    protected boolean readRecords(DataInputStream dataInputStream) throws IOException {
        int n = 1;
        int n2 = 0;
        this.numRecords = 0;
        while (n > 0) {
            n2 = this.readInt(dataInputStream);
            n2 -= 3;
            n = this.readShort(dataInputStream);
            if (n <= 0) break;
            MetaRecord metaRecord = new MetaRecord();
            switch (n) {
                case 1583: {
                    int n3;
                    for (n3 = 0; n3 < n2; ++n3) {
                        short s = this.readShort(dataInputStream);
                    }
                    --this.numRecords;
                    break;
                }
                case 2610: {
                    int n4;
                    int n5;
                    int n3 = this.readShort(dataInputStream) * this.ySign;
                    int n6 = this.readShort(dataInputStream) * this.xSign;
                    int n7 = this.readShort(dataInputStream);
                    int n8 = this.readShort(dataInputStream);
                    int n9 = 4;
                    int n10 = 0;
                    int n11 = 0;
                    int n12 = 0;
                    int n13 = 0;
                    int n14 = 0;
                    if ((n8 & 4) != 0) {
                        n11 = this.readShort(dataInputStream) * this.xSign;
                        n12 = this.readShort(dataInputStream) * this.ySign;
                        n13 = this.readShort(dataInputStream) * this.xSign;
                        n14 = this.readShort(dataInputStream) * this.ySign;
                        n9 += 4;
                        n10 = 1;
                    }
                    byte[] byArray = new byte[n7];
                    for (n5 = 0; n5 < n7; ++n5) {
                        byArray[n5] = dataInputStream.readByte();
                    }
                    n9 += (n7 + 1) / 2;
                    if (n7 % 2 != 0) {
                        dataInputStream.readByte();
                    }
                    if (n9 < n2) {
                        for (n4 = n9; n4 < n2; ++n4) {
                            this.readShort(dataInputStream);
                        }
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.addElement(n6);
                    metaRecord.addElement(n3);
                    metaRecord.addElement(n8);
                    if (n10 != 0) {
                        metaRecord.addElement(n11);
                        metaRecord.addElement(n12);
                        metaRecord.addElement(n13);
                        metaRecord.addElement(n14);
                    }
                    this.records.add(metaRecord);
                    break;
                }
                case 1313: {
                    int n10;
                    int n8;
                    int n3 = this.readShort(dataInputStream);
                    int n15 = 1;
                    byte[] byArray = new byte[n3];
                    for (n8 = 0; n8 < n3; ++n8) {
                        byArray[n8] = dataInputStream.readByte();
                    }
                    if (n3 % 2 != 0) {
                        dataInputStream.readByte();
                    }
                    n15 += (n3 + 1) / 2;
                    n8 = this.readShort(dataInputStream) * this.ySign;
                    int n9 = this.readShort(dataInputStream) * this.xSign;
                    if ((n15 += 2) < n2) {
                        for (n10 = n15; n10 < n2; ++n10) {
                            this.readShort(dataInputStream);
                        }
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n8);
                    this.records.add(metaRecord);
                    break;
                }
                case 763: {
                    int n3 = this.readShort(dataInputStream);
                    short s = this.readShort(dataInputStream);
                    short s2 = this.readShort(dataInputStream);
                    int n8 = this.readShort(dataInputStream);
                    int n9 = this.readShort(dataInputStream);
                    int n10 = dataInputStream.readByte();
                    int n11 = dataInputStream.readByte();
                    int n12 = dataInputStream.readByte();
                    int n13 = dataInputStream.readByte() & 0xFF;
                    byte by = dataInputStream.readByte();
                    int n16 = dataInputStream.readByte();
                    byte by2 = dataInputStream.readByte();
                    int n5 = dataInputStream.readByte();
                    int n4 = 2 * (n2 - 9);
                    byte[] byArray = new byte[n4];
                    for (int i = 0; i < n4; ++i) {
                        byArray[i] = dataInputStream.readByte();
                    }
                    String string = new String(byArray);
                    metaRecord = new MetaRecord.StringRecord(string);
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.addElement(n3);
                    metaRecord.addElement(n10);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n13);
                    metaRecord.addElement(n11);
                    metaRecord.addElement(n12);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(s2);
                    this.records.add(metaRecord);
                    break;
                }
                case 259: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream);
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream);
                    short s = this.readShort(dataInputStream);
                    if (s < 0) {
                        s = -s;
                        this.xSign = -1;
                    }
                    if (n3 < 0) {
                        n3 = -n3;
                        this.ySign = -1;
                    }
                    metaRecord.addElement(s);
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    if (!this._bext || n != 524) break;
                    this.vpW = s;
                    this.vpH = n3;
                    this._bext = false;
                    break;
                }
                case 527: 
                case 529: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream) * this.ySign;
                    int n17 = this.readShort(dataInputStream) * this.xSign;
                    metaRecord.addElement(n17);
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 1040: 
                case 1042: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream);
                    short s = this.readShort(dataInputStream);
                    short s3 = this.readShort(dataInputStream);
                    int n8 = this.readShort(dataInputStream);
                    metaRecord.addElement(s3);
                    metaRecord.addElement(n3);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(s);
                    this.records.add(metaRecord);
                    this.scaleX = this.scaleX * (float)s3 / (float)n8;
                    this.scaleY = this.scaleY * (float)n3 / (float)s;
                    break;
                }
                case 764: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.addElement(this.readShort(dataInputStream));
                    int n3 = this.readInt(dataInputStream);
                    int n18 = n3 & 0xFF;
                    int n19 = (n3 & 0xFF00) >> 8;
                    int n8 = (n3 & 0xFF0000) >> 16;
                    int n9 = (n3 & 0x3000000) >> 24;
                    metaRecord.addElement(n18);
                    metaRecord.addElement(n19);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(this.readShort(dataInputStream));
                    this.records.add(metaRecord);
                    break;
                }
                case 762: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.addElement(this.readShort(dataInputStream));
                    int n3 = this.readInt(dataInputStream);
                    int n20 = this.readInt(dataInputStream);
                    if (n2 == 6) {
                        this.readShort(dataInputStream);
                    }
                    int n21 = n20 & 0xFF;
                    int n8 = (n20 & 0xFF00) >> 8;
                    int n9 = (n20 & 0xFF0000) >> 16;
                    int n10 = (n20 & 0x3000000) >> 24;
                    metaRecord.addElement(n21);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 302: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream);
                    if (n2 > 1) {
                        for (int i = 1; i < n2; ++i) {
                            this.readShort(dataInputStream);
                        }
                    }
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 513: 
                case 521: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readInt(dataInputStream);
                    int n22 = n3 & 0xFF;
                    int n23 = (n3 & 0xFF00) >> 8;
                    int n8 = (n3 & 0xFF0000) >> 16;
                    int n9 = (n3 & 0x3000000) >> 24;
                    metaRecord.addElement(n22);
                    metaRecord.addElement(n23);
                    metaRecord.addElement(n8);
                    this.records.add(metaRecord);
                    break;
                }
                case 531: 
                case 532: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream) * this.ySign;
                    int n24 = this.readShort(dataInputStream) * this.xSign;
                    metaRecord.addElement(n24);
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 262: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream);
                    if (n2 > 1) {
                        for (int i = 1; i < n2; ++i) {
                            this.readShort(dataInputStream);
                        }
                    }
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 1336: {
                    int n11;
                    int n10;
                    int n9;
                    int n8;
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream);
                    int[] nArray = new int[n3];
                    int n25 = 0;
                    for (n8 = 0; n8 < n3; ++n8) {
                        nArray[n8] = this.readShort(dataInputStream);
                        n25 += nArray[n8];
                    }
                    metaRecord.addElement(n3);
                    for (n8 = 0; n8 < n3; ++n8) {
                        metaRecord.addElement(nArray[n8]);
                    }
                    n8 = n3 + 1;
                    for (n9 = 0; n9 < n3; ++n9) {
                        n10 = nArray[n9];
                        for (n11 = 0; n11 < n10; ++n11) {
                            metaRecord.addElement(this.readShort(dataInputStream) * this.xSign);
                            metaRecord.addElement(this.readShort(dataInputStream) * this.ySign);
                        }
                    }
                    this.records.add(metaRecord);
                    break;
                }
                case 804: 
                case 805: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream);
                    metaRecord.addElement(n3);
                    for (int i = 0; i < n3; ++i) {
                        metaRecord.addElement(this.readShort(dataInputStream) * this.xSign);
                        metaRecord.addElement(this.readShort(dataInputStream) * this.ySign);
                    }
                    this.records.add(metaRecord);
                    break;
                }
                case 1046: 
                case 1048: 
                case 1051: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream) * this.ySign;
                    int n26 = this.readShort(dataInputStream) * this.xSign;
                    int n27 = this.readShort(dataInputStream) * this.ySign;
                    int n8 = this.readShort(dataInputStream) * this.xSign;
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n27);
                    metaRecord.addElement(n26);
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 1791: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream) * this.xSign;
                    int n28 = this.readShort(dataInputStream) * this.ySign;
                    int n29 = this.readShort(dataInputStream) * this.xSign;
                    int n8 = this.readShort(dataInputStream) * this.ySign;
                    metaRecord.addElement(n3);
                    metaRecord.addElement(n28);
                    metaRecord.addElement(n29);
                    metaRecord.addElement(n8);
                    this.records.add(metaRecord);
                    break;
                }
                case 1564: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream) * this.ySign;
                    int n30 = this.readShort(dataInputStream) * this.xSign;
                    int n31 = this.readShort(dataInputStream) * this.ySign;
                    int n8 = this.readShort(dataInputStream) * this.xSign;
                    int n9 = this.readShort(dataInputStream) * this.ySign;
                    int n10 = this.readShort(dataInputStream) * this.xSign;
                    metaRecord.addElement(n10);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n31);
                    metaRecord.addElement(n30);
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 2071: 
                case 2074: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream) * this.ySign;
                    int n32 = this.readShort(dataInputStream) * this.xSign;
                    int n33 = this.readShort(dataInputStream) * this.ySign;
                    int n8 = this.readShort(dataInputStream) * this.xSign;
                    int n9 = this.readShort(dataInputStream) * this.ySign;
                    int n10 = this.readShort(dataInputStream) * this.xSign;
                    int n11 = this.readShort(dataInputStream) * this.ySign;
                    int n12 = this.readShort(dataInputStream) * this.xSign;
                    metaRecord.addElement(n12);
                    metaRecord.addElement(n11);
                    metaRecord.addElement(n10);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n33);
                    metaRecord.addElement(n32);
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 1565: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readInt(dataInputStream);
                    int n34 = this.readShort(dataInputStream) * this.ySign;
                    int n35 = this.readShort(dataInputStream) * this.xSign;
                    int n8 = this.readShort(dataInputStream) * this.xSign;
                    int n9 = this.readShort(dataInputStream) * this.ySign;
                    metaRecord.addElement(n3);
                    metaRecord.addElement(n34);
                    metaRecord.addElement(n35);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n8);
                    this.records.add(metaRecord);
                    break;
                }
                case 258: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream);
                    metaRecord.addElement(n3);
                    if (n2 > 1) {
                        for (int i = 1; i < n2; ++i) {
                            this.readShort(dataInputStream);
                        }
                    }
                    this.records.add(metaRecord);
                    break;
                }
                case 260: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = n2 == 1 ? (int)this.readShort(dataInputStream) : this.readInt(dataInputStream);
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 2881: {
                    int n3 = dataInputStream.readInt() & 0xFF;
                    int n36 = this.readShort(dataInputStream) * this.ySign;
                    int n37 = this.readShort(dataInputStream) * this.xSign;
                    int n8 = this.readShort(dataInputStream) * this.ySign;
                    int n9 = this.readShort(dataInputStream) * this.xSign;
                    int n10 = this.readShort(dataInputStream) * this.ySign;
                    int n11 = this.readShort(dataInputStream) * this.xSign;
                    int n12 = this.readShort(dataInputStream) * this.ySign;
                    int n13 = this.readShort(dataInputStream) * this.xSign;
                    int n38 = 2 * n2 - 20;
                    byte[] byArray = new byte[n38];
                    for (int i = 0; i < n38; ++i) {
                        byArray[i] = dataInputStream.readByte();
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.addElement(n3);
                    metaRecord.addElement(n36);
                    metaRecord.addElement(n37);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n10);
                    metaRecord.addElement(n11);
                    metaRecord.addElement(n12);
                    metaRecord.addElement(n13);
                    this.records.add(metaRecord);
                    break;
                }
                case 2368: {
                    int n16;
                    int n3 = dataInputStream.readInt() & 0xFF;
                    short s = this.readShort(dataInputStream);
                    short s4 = this.readShort(dataInputStream);
                    int n8 = this.readShort(dataInputStream);
                    int n9 = this.readShort(dataInputStream);
                    int n10 = this.readShort(dataInputStream);
                    int n11 = this.readShort(dataInputStream);
                    int n12 = this.readShort(dataInputStream);
                    int n13 = 2 * n2 - 18;
                    if (n13 > 0) {
                        byte[] byArray = new byte[n13];
                        for (n16 = 0; n16 < n13; ++n16) {
                            byArray[n16] = dataInputStream.readByte();
                        }
                        metaRecord = new MetaRecord.ByteRecord(byArray);
                        metaRecord.numPoints = n2;
                        metaRecord.functionId = n;
                    } else {
                        metaRecord.numPoints = n2;
                        metaRecord.functionId = n;
                        for (int i = 0; i < n13; ++i) {
                            dataInputStream.readByte();
                        }
                    }
                    metaRecord.addElement(n3);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n10);
                    metaRecord.addElement(s);
                    metaRecord.addElement(s4);
                    metaRecord.addElement(n11);
                    metaRecord.addElement(n12);
                    this.records.add(metaRecord);
                }
                case 322: {
                    int n8;
                    int n3 = dataInputStream.readInt() & 0xFF;
                    int n39 = 2 * n2 - 4;
                    byte[] byArray = new byte[n39];
                    for (n8 = 0; n8 < n39; ++n8) {
                        byArray[n8] = dataInputStream.readByte();
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                default: {
                    int n3;
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    for (n3 = 0; n3 < n2; ++n3) {
                        metaRecord.addElement(this.readShort(dataInputStream));
                    }
                    this.records.add(metaRecord);
                }
            }
            ++this.numRecords;
        }
        this.setReading(false);
        return true;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public MetaRecord getRecord(int n) {
        return (MetaRecord)this.records.get(n);
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public float getVpX() {
        return this.vpX;
    }

    public float getVpY() {
        return this.vpY;
    }

    public void setVpX(float f) {
        this.vpX = f;
    }

    public void setVpY(float f) {
        this.vpY = f;
    }
}

