/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.warp;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.warp.AffineTransform;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.warp.WarpingVectorLayerFinder;

public class AffineTransformPlugIn
extends AbstractPlugIn {
    public static EnableCheck getEnableCheck(EnableCheckFactory checkFactory) {
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1)).add(checkFactory.createBetweenNAndMVectorsMustBeDrawnCheck(1, 3));
    }

    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_WARP}, this.getName(), false, null, AffineTransformPlugIn.getEnableCheck(context.getCheckFactory()));
    }

    public boolean execute(PlugInContext context) throws Exception {
        AffineTransform transform = this.affineTransform(context);
        FeatureCollection featureCollection = transform.transform((FeatureCollection)context.getSelectedLayer(0).getFeatureCollectionWrapper());
        context.getLayerManager().addLayer(StandardCategoryNames.WORKING, I18N.get((String)"ui.warp.AffineTransformPlugIn.affined") + " " + context.getSelectedLayer(0).getName(), featureCollection);
        AffineTransformPlugIn.checkValid(featureCollection, context);
        return true;
    }

    public static void checkValid(FeatureCollection featureCollection, PlugInContext context) {
        for (Feature feature : featureCollection) {
            if (feature.getGeometry().isValid()) continue;
            context.getLayerViewPanel().getContext().warnUser(I18N.get((String)"ui.warp.AffineTransformPlugIn.some-geometries-are-not-valid"));
            return;
        }
    }

    private Coordinate vectorCoordinate(int n, boolean tip, PlugInContext context, WarpingVectorLayerFinder vectorLayerManager) {
        LineString vector = (LineString)vectorLayerManager.getVectors().get(n);
        return tip ? vector.getCoordinateN(1) : vector.getCoordinateN(0);
    }

    private AffineTransform affineTransform(PlugInContext context) {
        WarpingVectorLayerFinder vlm = new WarpingVectorLayerFinder(context);
        switch (vlm.getVectors().size()) {
            case 1: {
                return new AffineTransform(this.vectorCoordinate(0, false, context, vlm), this.vectorCoordinate(0, true, context, vlm));
            }
            case 2: {
                return new AffineTransform(this.vectorCoordinate(0, false, context, vlm), this.vectorCoordinate(0, true, context, vlm), this.vectorCoordinate(1, false, context, vlm), this.vectorCoordinate(1, true, context, vlm));
            }
            case 3: {
                return new AffineTransform(this.vectorCoordinate(0, false, context, vlm), this.vectorCoordinate(0, true, context, vlm), this.vectorCoordinate(1, false, context, vlm), this.vectorCoordinate(1, true, context, vlm), this.vectorCoordinate(2, false, context, vlm), this.vectorCoordinate(2, true, context, vlm));
            }
        }
        Assert.shouldNeverReachHere();
        return null;
    }
}

