/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.CollectionMap;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.FeatureCollectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;

public abstract class AbstractSelectionRenderer
extends FeatureCollectionRenderer
implements Style {
    public static final int HANDLE_WIDTH = 5;
    private boolean enabled = true;
    private Stroke handleStroke = new BasicStroke(1.0f);
    private Color handleFillColor;
    private Color handleLineColor = Color.black;
    private Stroke lineStroke = new BasicStroke(2.0f);
    private Color lineColor;
    private Stroke fillStroke = new BasicStroke(1.0f);
    private Color fillColor;
    private boolean filling = true;
    protected LayerViewPanel panel;
    private CollectionMap featureToSelectedItemsMap;
    private boolean paintingHandles;
    Rectangle2D.Double handle = new Rectangle2D.Double(0.0, 0.0, 5.0, 5.0);

    public AbstractSelectionRenderer(Object contentID, LayerViewPanel panel, Color color, boolean paintingHandles, boolean filling) {
        super(contentID, panel);
        this.panel = panel;
        this.handleFillColor = color;
        this.lineColor = color;
        this.fillColor = GUIUtil.alphaColor(Color.white, 75);
        this.paintingHandles = paintingHandles;
        this.filling = filling;
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public Icon getIcon() {
        throw new UnsupportedOperationException();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Object clone() {
        Assert.shouldNeverReachHere();
        return null;
    }

    public void initialize(Layer layer) {
    }

    public void paint(Feature f, Graphics2D g, Viewport viewport) throws NoninvertibleTransformException {
        for (Geometry geometry : this.featureToSelectedItemsMap.getItems((Object)f)) {
            this.paint(geometry, g, viewport);
        }
    }

    public void paint(Geometry geometry, Graphics2D g, Viewport viewport) throws NoninvertibleTransformException {
        Coordinate[] modelCoordinates = geometry.getCoordinates();
        if (geometry.getDimension() > 0 || !this.paintingHandles) {
            StyleUtil.paint(geometry, g, viewport, this.filling, this.fillStroke, this.fillColor, true, this.lineStroke, this.lineColor);
        }
        if (this.paintingHandles) {
            Rectangle2D viewRectangle = viewport.toViewRectangle(viewport.getEnvelopeInModelCoordinates());
            Coordinate[] viewCoordinates = viewport.getJava2DConverter().toViewCoordinates(modelCoordinates);
            g.setStroke(this.handleStroke);
            for (int i = 0; i < viewCoordinates.length; ++i) {
                Coordinate p = viewCoordinates[i];
                double x = p.x;
                double y = p.y;
                if (!viewRectangle.contains(x, y)) continue;
                this.handle.x = x - 2.0;
                this.handle.y = y - 2.0;
                g.setColor(this.handleFillColor);
                g.fill(this.handle);
                g.setColor(this.handleLineColor);
                g.draw(this.handle);
            }
        }
    }

    protected Collection styles() {
        return Collections.singleton(this);
    }

    protected Map layerToFeaturesMap() {
        this.featureToSelectedItemsMap = new CollectionMap();
        HashMap layerToFeaturesMap = new HashMap();
        Iterator i = this.panel.getLayerManager().iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            CollectionMap featureToSelectedItemsMapForLayer = this.featureToSelectedItemsMap(layer);
            this.featureToSelectedItemsMap.putAll((Map)featureToSelectedItemsMapForLayer);
            layerToFeaturesMap.put(layer, featureToSelectedItemsMapForLayer.keySet());
        }
        return layerToFeaturesMap;
    }

    protected abstract CollectionMap featureToSelectedItemsMap(Layer var1);

    private static Shape handle(Point2D point) {
        Rectangle2D.Double handle = new Rectangle2D.Double(0.0, 0.0, 5.0, 5.0);
        handle.x = point.getX() - 2.0;
        handle.y = point.getY() - 2.0;
        return handle;
    }

    public static void paintHandles(Graphics2D g, Coordinate[] coordinates, Stroke stroke, Color fillColor, Color lineColor, Viewport viewport) throws NoninvertibleTransformException {
        int i;
        g.setStroke(stroke);
        g.setColor(fillColor);
        for (i = 0; i < coordinates.length; ++i) {
            if (!viewport.getEnvelopeInModelCoordinates().contains(coordinates[i])) continue;
            g.fill(AbstractSelectionRenderer.handle(viewport.toViewPoint(new Point2D.Double(coordinates[i].x, coordinates[i].y))));
        }
        g.setColor(lineColor);
        for (i = 0; i < coordinates.length; ++i) {
            if (!viewport.getEnvelopeInModelCoordinates().contains(coordinates[i])) continue;
            g.draw(AbstractSelectionRenderer.handle(viewport.toViewPoint(new Point2D.Double(coordinates[i].x, coordinates[i].y))));
        }
    }

    protected boolean useImageCaching(Map layerToFeaturesMap) {
        return true;
    }
}

