/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.clipboard;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jump.coordsys.Reprojector;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.WKTReader;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.images.famfam.IconLoaderFamFam;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CollectionOfFeaturesTransferable;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasteItemsPlugIn
extends AbstractPlugIn {
    private WKTReader reader = new WKTReader();
    private static final String DECIMAL_PATTERN = "\\d+(?:\\.\\d+)?";
    private static final String WHITESPACE_OR_COMMA = "(?:\\s+|(?:\\s*,\\s*))";
    private static final Pattern pointCoordsPattern = Pattern.compile("\\s*\\(?\\s*(\\d+(?:\\.\\d+)?)(?:\\s+|(?:\\s*,\\s*))(\\d+(?:\\.\\d+)?)(?:(?:\\s+|(?:\\s*,\\s*))(\\d+(?:\\.\\d+)?))?\\s*\\)?\\s*");
    public static final ImageIcon ICON = IconLoaderFamFam.icon("paste_plain.png");

    public String getNameWithMnemonic() {
        return StringUtil.replace((String)this.getName(), (String)"P", (String)"&P", (boolean)false);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        List features;
        this.reportNothingToUndoYet(context);
        Transferable transferable = GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
        if (transferable.isDataFlavorSupported(CollectionOfFeaturesTransferable.COLLECTION_OF_FEATURES_FLAVOR)) {
            features = (List)GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard()).getTransferData(CollectionOfFeaturesTransferable.COLLECTION_OF_FEATURES_FLAVOR);
        } else {
            String value = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            features = this.processCoordinates(value);
            if (features.isEmpty()) {
                features = this.reader.read((Reader)new StringReader(value)).getFeatures();
            }
        }
        final Layer layer = context.getSelectedLayer(0);
        final Collection featureCopies = PasteItemsPlugIn.conform(features, layer.getFeatureCollectionWrapper().getFeatureSchema());
        this.execute(new UndoableCommand(this.getName()){

            public void execute() {
                layer.getFeatureCollectionWrapper().addAll(featureCopies);
            }

            public void unexecute() {
                layer.getFeatureCollectionWrapper().removeAll(featureCopies);
            }
        }, context);
        return true;
    }

    private Collection<Feature> processCoordinates(String value) {
        Matcher matcher = pointCoordsPattern.matcher(value);
        ArrayList<Feature> features = new ArrayList<Feature>();
        if (matcher.find() && matcher.start() == 0) {
            do {
                double x = Double.parseDouble(matcher.group(1));
                double y = Double.parseDouble(matcher.group(2));
                Coordinate coordinate = new Coordinate(x, y);
                String zString = matcher.group(3);
                if (zString != null) {
                    coordinate.z = Double.parseDouble(zString);
                }
                FeatureSchema featureSchema = new FeatureSchema();
                featureSchema.addAttribute("Geometry", AttributeType.GEOMETRY);
                BasicFeature feature = new BasicFeature(featureSchema);
                Point point = new GeometryFactory().createPoint(coordinate);
                feature.setGeometry((Geometry)point);
                features.add((Feature)feature);
            } while (matcher.find());
        }
        return features;
    }

    public static Collection conform(Collection features, FeatureSchema targetFeatureSchema) {
        ArrayList<Feature> featureCopies = new ArrayList<Feature>();
        for (Feature feature : features) {
            featureCopies.add(PasteItemsPlugIn.conform(feature, targetFeatureSchema));
        }
        return featureCopies;
    }

    private static Feature conform(Feature original, FeatureSchema targetFeatureSchema) {
        BasicFeature copy = new BasicFeature(targetFeatureSchema);
        copy.setGeometry((Geometry)original.getGeometry().clone());
        for (int i = 0; i < original.getSchema().getAttributeCount(); ++i) {
            if (i == original.getSchema().getGeometryIndex()) continue;
            String attributeName = original.getSchema().getAttributeName(i);
            if (!copy.getSchema().hasAttribute(attributeName) || copy.getSchema().getAttributeType(attributeName) != original.getSchema().getAttributeType(attributeName)) continue;
            copy.setAttribute(attributeName, original.getAttribute(attributeName));
        }
        Reprojector.instance().reproject(copy.getGeometry(), original.getSchema().getCoordinateSystem(), copy.getSchema().getCoordinateSystem());
        return copy;
    }

    public static MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1)).add(checkFactory.createSelectedLayersMustBeEditableCheck()).add(new EnableCheck(){

            public String check(JComponent component) {
                Transferable transferable = GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
                if (transferable == null) {
                    return "Clipboard must not be empty";
                }
                if (transferable.isDataFlavorSupported(CollectionOfFeaturesTransferable.COLLECTION_OF_FEATURES_FLAVOR)) {
                    return null;
                }
                try {
                    String value;
                    if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && (this.isWKT(value = (String)transferable.getTransferData(DataFlavor.stringFlavor)) || this.isCoordinates(value))) {
                        return null;
                    }
                }
                catch (Exception e) {
                    workbenchContext.getErrorHandler().handleThrowable(e);
                }
                return "Clipboard must contain geometries or Well-Known Text";
            }

            private boolean isCoordinates(String value) {
                return pointCoordsPattern.matcher(value).find();
            }

            private boolean isWKT(String s) {
                try {
                    new WKTReader().read((Reader)new StringReader(s));
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
    }
}

