/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.operation.union.UnaryUnionOp;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.PasteItemsPlugIn;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class BufferPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    public static final ImageIcon ICON = IconLoader.icon("buffer.gif");
    private String LAYER;
    private String DISTANCE;
    private String END_CAP_STYLE;
    private String QUADRANT_SEGMENTS;
    private String SELECTED_ONLY;
    private String UNION_RESULT;
    private String COPY_ATTRIUBTES;
    private String CAP_STYLE_ROUND;
    private String CAP_STYLE_SQUARE;
    private String CAP_STYLE_BUTT;
    private String ATTRIBUTE;
    private String FROMATTRIBUTE;
    private List endCapStyles;
    private MultiInputDialog dialog;
    private Layer layer;
    private double bufferDistance = 1.0;
    private String endCapStyle;
    private boolean exceptionThrown = false;
    private boolean useSelected = false;
    private int quadrantSegments = 16;
    private boolean unionResult = false;
    private String sideBarText = "";
    private boolean copyAttributes = true;
    private boolean fromAttribute = false;
    private int attributeIndex = 0;
    private final String ROUND = "Round";
    private final String SQUARE = "Square";
    private final String BUTT = "Butt";
    private String categoryName = StandardCategoryNames.RESULT;

    public void setCategoryName(String value) {
        this.categoryName = value;
    }

    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_GENERATE}, this.getName() + "...", false, null, BufferPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.LAYER = I18N.get((String)"ui.plugin.analysis.BufferPlugIn.layer");
        this.DISTANCE = I18N.get((String)"ui.plugin.analysis.BufferPlugIn.buffer-distance");
        this.END_CAP_STYLE = I18N.get((String)"ui.plugin.analysis.BufferPlugIn.End-Cap-Style");
        this.QUADRANT_SEGMENTS = I18N.get((String)"org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawCircleWithGivenRadiusTool.Number-of-segments-per-circle-quarter");
        this.SELECTED_ONLY = I18N.get((String)"ui.plugin.analysis.GeometryFunctionPlugIn.Use-selected-features-only");
        this.UNION_RESULT = I18N.get((String)"ui.plugin.analysis.UnionPlugIn.union");
        this.COPY_ATTRIUBTES = I18N.get((String)"org.openjump.sigle.plugin.PlanarGraphPlugIn.Keep-attributes");
        this.CAP_STYLE_ROUND = I18N.get((String)"ui.plugin.analysis.BufferPlugIn.Round");
        this.CAP_STYLE_SQUARE = I18N.get((String)"ui.plugin.analysis.BufferPlugIn.Square");
        this.CAP_STYLE_BUTT = I18N.get((String)"ui.plugin.analysis.BufferPlugIn.Butt");
        this.endCapStyles = new ArrayList();
        this.endCapStyles.add(this.CAP_STYLE_ROUND);
        this.endCapStyles.add(this.CAP_STYLE_SQUARE);
        this.endCapStyles.add(this.CAP_STYLE_BUTT);
        this.endCapStyle = this.CAP_STYLE_ROUND;
        this.ATTRIBUTE = I18N.get((String)"ui.plugin.analysis.BufferPlugIn.attribute-to-use");
        this.FROMATTRIBUTE = I18N.get((String)"ui.plugin.analysis.BufferPlugIn.Get-distance-from-attribute-value");
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        int n = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems().size();
        this.useSelected = n > 0;
        this.sideBarText = this.useSelected ? this.SELECTED_ONLY : I18N.get((String)"ui.plugin.analysis.BufferPlugIn.buffers-all-geometries-in-the-input-layer");
        this.setDialogValues(this.dialog, context);
        this.updateControls();
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Collection inputC;
        monitor.allowCancellationRequests();
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        FeatureDataset resultFC = new FeatureDataset(featureSchema);
        if (this.useSelected) {
            inputC = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
            Feature feature = (Feature)inputC.iterator().next();
            featureSchema = feature.getSchema();
            inputC = PasteItemsPlugIn.conform(inputC, featureSchema);
        } else {
            inputC = this.layer.getFeatureCollectionWrapper().getFeatures();
            featureSchema = this.layer.getFeatureCollectionWrapper().getFeatureSchema();
            resultFC = new FeatureDataset(featureSchema);
        }
        FeatureDataset inputFD = new FeatureDataset(inputC, featureSchema);
        Collection resultGeomColl = this.runBuffer(monitor, (FeatureCollection)inputFD);
        if (this.copyAttributes) {
            FeatureDataset resultFeatureColl = new FeatureDataset(featureSchema);
            Iterator iResult = resultGeomColl.iterator();
            for (Feature sourceFeature : inputFD) {
                Geometry gResult = (Geometry)iResult.next();
                if (gResult != null && !gResult.isEmpty()) {
                    Feature newFeature = sourceFeature.clone(true);
                    newFeature.setGeometry(gResult);
                    resultFeatureColl.add(newFeature);
                }
                if (!monitor.isCancelRequested()) continue;
                break;
            }
            resultFC = resultFeatureColl;
        } else {
            resultFC = FeatureDatasetFactory.createFromGeometry((Collection)resultGeomColl);
        }
        if (this.unionResult) {
            List geoms = FeatureUtil.toGeometries((Collection)resultFC.getFeatures());
            Geometry g = UnaryUnionOp.union((Collection)geoms);
            geoms.clear();
            geoms.add(g);
            resultFC = FeatureDatasetFactory.createFromGeometry((Collection)geoms);
        }
        context.getLayerManager().addCategory(this.categoryName);
        String name = !this.useSelected ? this.layer.getName() : I18N.get((String)"ui.MenuNames.SELECTION");
        name = I18N.get((String)"com.vividsolutions.jump.workbench.ui.plugin.analysis.BufferPlugIn") + "-" + name;
        if (this.endCapStyle != this.CAP_STYLE_ROUND) {
            name = name + "-" + this.endCapStyle;
        }
        context.addLayer(this.categoryName, name, (FeatureCollection)resultFC);
        if (this.exceptionThrown) {
            context.getWorkbenchFrame().warnUser(I18N.get((String)"ui.plugin.analysis.BufferPlugIn.errors-found-while-executing-buffer"));
        }
    }

    private Collection runBuffer(TaskMonitor monitor, FeatureCollection fcA) {
        this.exceptionThrown = false;
        int total = fcA.size();
        int count = 0;
        ArrayList<Geometry> resultColl = new ArrayList<Geometry>();
        Iterator ia = fcA.iterator();
        while (ia.hasNext()) {
            Geometry result;
            monitor.report(count++, total, I18N.get((String)"com.vividsolutions.jump.qa.diff.DiffGeometry.features"));
            if (monitor.isCancelRequested()) break;
            Feature fa = (Feature)ia.next();
            Geometry ga = fa.getGeometry();
            if (this.fromAttribute) {
                Object o = fa.getAttribute(this.attributeIndex);
                if (o instanceof Double) {
                    this.bufferDistance = (Double)o;
                } else if (o instanceof Integer) {
                    this.bufferDistance = ((Integer)o).doubleValue();
                }
            }
            if ((result = this.runBuffer(ga)) == null) continue;
            resultColl.add(result);
        }
        return resultColl;
    }

    private Geometry runBuffer(Geometry a) {
        Geometry result = null;
        try {
            BufferOp bufOp = new BufferOp(a);
            bufOp.setQuadrantSegments(this.quadrantSegments);
            bufOp.setEndCapStyle(this.endCapStyleCode(this.endCapStyle));
            result = bufOp.getResultGeometry(this.bufferDistance);
            return result;
        }
        catch (RuntimeException ex) {
            this.exceptionThrown = true;
            return null;
        }
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(this.sideBarText);
        try {
            dialog.setSideBarImage(IconLoader.icon("Round.gif"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.useSelected) {
            dialog.addLabel(this.SELECTED_ONLY);
        } else {
            dialog.addLayerComboBox(this.LAYER, context.getCandidateLayer(0), context.getLayerManager());
            this.initComboFields(dialog, this.FROMATTRIBUTE, this.ATTRIBUTE);
            final MultiInputDialog fdialog = dialog;
            dialog.getCheckBox(this.FROMATTRIBUTE).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BufferPlugIn.this.fromAttribute = fdialog.getCheckBox(BufferPlugIn.this.FROMATTRIBUTE).isSelected();
                    fdialog.getComboBox(BufferPlugIn.this.ATTRIBUTE).setEnabled(BufferPlugIn.this.fromAttribute);
                }
            });
        }
        dialog.addDoubleField(this.DISTANCE, this.bufferDistance, 10, null);
        JComboBox endCapComboBox = dialog.addComboBox(this.END_CAP_STYLE, this.endCapStyle, this.endCapStyles, null);
        endCapComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BufferPlugIn.this.updateControls();
            }
        });
        dialog.addIntegerField(this.QUADRANT_SEGMENTS, this.quadrantSegments, 3, null);
        JCheckBox unionCheckBox = dialog.addCheckBox(this.UNION_RESULT, this.unionResult);
        unionCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BufferPlugIn.this.updateControls();
            }
        });
        JCheckBox copyAttributesCheckBox = dialog.addCheckBox(this.COPY_ATTRIUBTES, this.copyAttributes);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        if (!this.useSelected) {
            this.layer = dialog.getLayer(this.LAYER);
        }
        this.bufferDistance = dialog.getDouble(this.DISTANCE);
        this.endCapStyle = dialog.getText(this.END_CAP_STYLE);
        this.quadrantSegments = dialog.getInteger(this.QUADRANT_SEGMENTS);
        this.unionResult = dialog.getBoolean(this.UNION_RESULT);
        this.copyAttributes = dialog.getBoolean(this.COPY_ATTRIUBTES);
        if (this.fromAttribute) {
            if (dialog.getCheckBox(this.FROMATTRIBUTE).isEnabled()) {
                Layer destinationLayer = dialog.getLayer(this.LAYER);
                FeatureSchema schema = destinationLayer.getFeatureCollectionWrapper().getFeatureSchema();
                String attributeName = dialog.getText(this.ATTRIBUTE);
                this.attributeIndex = schema.getAttributeIndex(attributeName);
            } else {
                this.fromAttribute = false;
            }
        }
    }

    private void initComboFields(final MultiInputDialog dialog, final String checkBoxFieldName, final String comboBoxFieldName) {
        JCheckBox checkBox = dialog.addCheckBox(checkBoxFieldName, false);
        JComboBox comboBox = dialog.addComboBox(comboBoxFieldName, null, new ArrayList(), null);
        Layer newLayer = (Layer)dialog.getComboBox(this.LAYER).getSelectedItem();
        if (newLayer != null) {
            dialog.getComboBox(comboBoxFieldName).setModel(new DefaultComboBoxModel(new Vector(this.candidateAttributeNames(newLayer))));
        }
        boolean numericAttributesPresent = this.candidateAttributeNames(newLayer).size() != 0;
        checkBox.setEnabled(numericAttributesPresent);
        comboBox.setEnabled(false);
        dialog.getComboBox(this.LAYER).addActionListener(new ActionListener(){
            private Layer lastLayer = null;

            public void actionPerformed(ActionEvent e) {
                Layer newLayer = (Layer)dialog.getComboBox(BufferPlugIn.this.LAYER).getSelectedItem();
                if (this.lastLayer == newLayer) {
                    return;
                }
                this.lastLayer = newLayer;
                dialog.getComboBox(comboBoxFieldName).setModel(new DefaultComboBoxModel(new Vector(BufferPlugIn.this.candidateAttributeNames(newLayer))));
                boolean notEmpty = BufferPlugIn.this.candidateAttributeNames(newLayer).size() != 0;
                dialog.getCheckBox(checkBoxFieldName).setEnabled(notEmpty);
                if (notEmpty) {
                    dialog.getComboBox(comboBoxFieldName).setSelectedItem(BufferPlugIn.this.candidateAttributeNames(newLayer).get(0));
                }
            }
        });
        dialog.addEnableChecks(comboBoxFieldName, Arrays.asList(new EnableCheck(){

            public String check(JComponent component) {
                return dialog.getBoolean(checkBoxFieldName) && dialog.getComboBox(comboBoxFieldName).getItemCount() == 0 ? " " : null;
            }
        }));
        dialog.indentLabel(comboBoxFieldName);
    }

    private List candidateAttributeNames(Layer layer) {
        ArrayList<String> candidateAttributeNames = new ArrayList<String>();
        FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (schema.getAttributeType(i) != AttributeType.DOUBLE && schema.getAttributeType(i) != AttributeType.INTEGER) continue;
            candidateAttributeNames.add(schema.getAttributeName(i));
        }
        return candidateAttributeNames;
    }

    private int endCapStyleCode(String capStyle) {
        if (capStyle == this.CAP_STYLE_BUTT) {
            return 2;
        }
        if (capStyle == this.CAP_STYLE_SQUARE) {
            return 3;
        }
        return 1;
    }

    private Feature combine(Collection originalFeatures) {
        GeometryFactory factory = new GeometryFactory();
        Feature feature = (Feature)((Feature)originalFeatures.iterator().next()).clone();
        feature.setGeometry((Geometry)factory.createGeometryCollection(FeatureUtil.toGeometries((Collection)originalFeatures).toArray(new Geometry[originalFeatures.size()])));
        return feature;
    }

    protected void updateControls() {
        this.getDialogValues(this.dialog);
        this.dialog.getCheckBox(this.COPY_ATTRIUBTES).setEnabled(!this.unionResult);
        int capCode = this.endCapStyleCode(this.endCapStyle);
        if (capCode == 2) {
            this.updateUIForFunction("Butt");
        } else if (capCode == 3) {
            this.updateUIForFunction("Square");
        } else {
            this.updateUIForFunction("Round");
        }
    }

    private void updateUIForFunction(String capName) {
        if (this.unionResult) {
            try {
                this.dialog.setSideBarImage(IconLoader.icon(capName + "-union.gif"));
            }
            catch (Exception ex) {}
        } else {
            try {
                this.dialog.setSideBarImage(IconLoader.icon(capName + ".gif"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

