/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.CloneableInternalFrame;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.OneLayerAttributeTab;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class ViewAttributesPlugIn
extends AbstractPlugIn {
    public String getName() {
        return I18N.get((String)"ui.plugin.ViewAttributesPlugIn.view-edit-attributes");
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        ViewAttributesFrame frame = new ViewAttributesFrame(context.getSelectedLayer(0), context);
        context.getWorkbenchFrame().addInternalFrame(frame);
        return true;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    public ImageIcon getIcon() {
        return IconLoader.icon("Row.gif");
    }

    public static class ViewAttributesFrame
    extends JInternalFrame
    implements LayerManagerProxy,
    SelectionManagerProxy,
    LayerNamePanelProxy,
    TaskFrameProxy,
    LayerViewPanelProxy {
        private LayerManager layerManager;
        private OneLayerAttributeTab attributeTab;

        public ViewAttributesFrame(Layer layer, PlugInContext context) {
            this.layerManager = context.getLayerManager();
            this.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameClosed(InternalFrameEvent e) {
                    ViewAttributesFrame.this.attributeTab.getModel().dispose();
                }
            });
            this.setResizable(true);
            this.setClosable(true);
            this.setMaximizable(true);
            this.setIconifiable(true);
            this.getContentPane().setLayout(new BorderLayout());
            this.attributeTab = new OneLayerAttributeTab(context.getWorkbenchContext(), ((TaskFrameProxy)((Object)context.getActiveInternalFrame())).getTaskFrame(), this).setLayer(layer);
            this.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameOpened(InternalFrameEvent e) {
                    ViewAttributesFrame.this.attributeTab.getToolBar().updateEnabledState();
                }
            });
            this.getContentPane().add((Component)this.attributeTab, "Center");
            this.setSize(500, 300);
            this.updateTitle(this.attributeTab.getLayer());
            context.getLayerManager().addLayerListener(new LayerListener(){

                public void layerChanged(LayerEvent e) {
                    if (ViewAttributesFrame.this.attributeTab.getLayer() != null) {
                        ViewAttributesFrame.this.updateTitle(ViewAttributesFrame.this.attributeTab.getLayer());
                    }
                }

                public void categoryChanged(CategoryEvent e) {
                }

                public void featuresChanged(FeatureEvent e) {
                }
            });
            Assert.isTrue((!(this instanceof CloneableInternalFrame) ? 1 : 0) != 0, (String)I18N.get((String)"ui.plugin.ViewAttributesPlugIn.there-can-be-no-other-views-on-the-InfoModels"));
        }

        public LayerViewPanel getLayerViewPanel() {
            return this.getTaskFrame().getLayerViewPanel();
        }

        public LayerManager getLayerManager() {
            return this.layerManager;
        }

        private void updateTitle(Layer layer) {
            if (layer.isEditable()) {
                String editView = I18N.get((String)"ui.plugin.ViewAttributesPlugIn.edit");
            } else {
                String editView = I18N.get((String)"ui.plugin.ViewAttributesPlugIn.view");
            }
            this.setTitle(" " + I18N.get((String)"ui.plugin.ViewAttributesPlugIn.attributes") + ": " + layer.getName());
        }

        public TaskFrame getTaskFrame() {
            return this.attributeTab.getTaskFrame();
        }

        public SelectionManager getSelectionManager() {
            return this.attributeTab.getPanel().getSelectionManager();
        }

        public LayerNamePanel getLayerNamePanel() {
            return this.attributeTab;
        }
    }
}

