/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.AttributeTab;
import com.vividsolutions.jump.workbench.ui.GeometryInfoTab;
import com.vividsolutions.jump.workbench.ui.InfoModel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class InfoFrame
extends JInternalFrame
implements LayerManagerProxy,
SelectionManagerProxy,
LayerNamePanelProxy,
TaskFrameProxy,
LayerViewPanelProxy {
    private LayerManager layerManager;
    private BorderLayout borderLayout1 = new BorderLayout();
    private AttributeTab attributeTab;
    private InfoModel model = new InfoModel();
    private GeometryInfoTab geometryInfoTab;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private WorkbenchFrame workbenchFrame;

    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public TaskFrame getTaskFrame() {
        return this.attributeTab.getTaskFrame();
    }

    public InfoFrame(WorkbenchContext workbenchContext, LayerManagerProxy layerManagerProxy, final TaskFrame taskFrame) {
        this.geometryInfoTab = new GeometryInfoTab(this.model, workbenchContext);
        Assert.isTrue((layerManagerProxy.getLayerManager() != null ? 1 : 0) != 0);
        this.layerManager = layerManagerProxy.getLayerManager();
        this.attributeTab = new AttributeTab(this.model, workbenchContext, taskFrame, this, false);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameOpened(InternalFrameEvent e) {
                InfoFrame.this.attributeTab.getToolBar().updateEnabledState();
            }
        });
        this.workbenchFrame = workbenchContext.getWorkbench().getFrame();
        this.setResizable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.setSize(550, 185);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tabbedPane.addTab("", IconLoader.icon("Table.gif"), this.attributeTab, "Table View");
        this.tabbedPane.addTab("", IconLoader.icon("Paper.gif"), this.geometryInfoTab, "HTML View");
        this.updateTitle(taskFrame.getTask().getName());
        taskFrame.getTask().add(new Task.NameListener(){

            public void taskNameChanged(String name) {
                InfoFrame.this.updateTitle(taskFrame.getTask().getName());
            }
        });
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosed(InternalFrameEvent e) {
                InfoFrame.this.model.dispose();
            }
        });
    }

    public JPanel getAttributeTab() {
        return this.attributeTab;
    }

    public JPanel getGeometryTab() {
        return this.geometryInfoTab;
    }

    public void setSelectedTab(JPanel tab) {
        this.tabbedPane.setSelectedComponent(tab);
    }

    public static String title(String taskName) {
        return I18N.get((String)"ui.InfoFrame.feature-info") + ": " + taskName;
    }

    private void updateTitle(String taskName) {
        this.setTitle(InfoFrame.title(taskName));
    }

    public InfoModel getModel() {
        return this.model;
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.setTitle(I18N.get((String)"ui.InfoFrame.feature-info"));
        this.getContentPane().setLayout(this.borderLayout1);
        this.tabbedPane.setTabPlacement(2);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
    }

    public void surface() {
        JInternalFrame activeFrame = this.workbenchFrame.getActiveInternalFrame();
        if (!this.workbenchFrame.hasInternalFrame(this)) {
            this.workbenchFrame.addInternalFrame(this, false, true);
        }
        if (activeFrame != null) {
            this.workbenchFrame.activateFrame(activeFrame);
        }
        this.moveToFront();
    }

    public SelectionManager getSelectionManager() {
        return this.attributeTab.getPanel().getSelectionManager();
    }

    public LayerNamePanel getLayerNamePanel() {
        return this.attributeTab;
    }

    public LayerViewPanel getLayerViewPanel() {
        return this.getTaskFrame().getLayerViewPanel();
    }
}

