/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.FlexibleDateParser;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributeTablePanelListener;
import com.vividsolutions.jump.workbench.ui.FeatureInfoWriter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.LayerTableModel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.EditSelectedFeaturePlugIn;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class AttributeTablePanel
extends JPanel {
    private FeatureEditor featureEditor = new FeatureEditor(){

        public void edit(PlugInContext context, Feature feature, final Layer myLayer) throws Exception {
            new EditSelectedFeaturePlugIn(){

                protected Layer layer(PlugInContext context) {
                    return myLayer;
                }
            }.execute(context, feature, myLayer.isEditable());
        }
    };
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private boolean columnWidthsInitialized = false;
    private MyTable table = new MyTable();
    private TableCellRenderer headerRenderer = new TableCellRenderer(){
        private Icon clearIcon = IconLoader.icon("Clear.gif");
        private Icon downIcon = IconLoader.icon("Down.gif");
        private TableCellRenderer originalRenderer = AttributeTablePanel.access$100(AttributeTablePanel.this).getTableHeader().getDefaultRenderer();
        private Icon upIcon = IconLoader.icon("Up.gif");

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)this.originalRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (AttributeTablePanel.this.getModel().getSortedColumnName() == null || !AttributeTablePanel.this.getModel().getSortedColumnName().equals(table.getColumnName(column))) {
                label.setIcon(this.clearIcon);
            } else if (AttributeTablePanel.this.getModel().isSortAscending()) {
                label.setIcon(this.upIcon);
            } else {
                label.setIcon(this.downIcon);
            }
            label.setHorizontalTextPosition(2);
            return label;
        }
    };
    private LayerNameRenderer layerNameRenderer = new LayerNameRenderer();
    private ArrayList listeners = new ArrayList();
    private WorkbenchContext workbenchContext;

    public AttributeTablePanel(final LayerTableModel model, boolean addScrollPane, final WorkbenchContext workbenchContext) {
        this();
        if (addScrollPane) {
            this.remove(this.table);
            this.remove(this.table.getTableHeader());
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.getViewport().add(this.table);
            this.add((Component)scrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.updateGrid(model.getLayer());
        model.getLayer().getLayerManager().addLayerListener(new LayerListener(){

            public void categoryChanged(CategoryEvent e) {
            }

            public void featuresChanged(FeatureEvent e) {
            }

            public void layerChanged(LayerEvent e) {
                if (e.getLayerable() != model.getLayer()) {
                    return;
                }
                if (e.getType() == LayerEventType.METADATA_CHANGED) {
                    AttributeTablePanel.this.updateGrid(model.getLayer());
                    AttributeTablePanel.this.repaint();
                }
            }
        });
        try {
            JList list = new JList();
            list.setBackground(new JLabel().getBackground());
            this.layerNameRenderer.getListCellRendererComponent(list, model.getLayer(), -1, false, false);
            this.table.setModel(model);
            model.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    if (e.getFirstRow() == -1) {
                        AttributeTablePanel.this.initColumnWidths();
                    }
                }
            });
            this.layerNameRenderer.getLabel().setFont(this.layerNameRenderer.getLabel().getFont().deriveFont(1));
            model.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    AttributeTablePanel.this.updateLabel();
                }
            });
            this.updateLabel();
            this.workbenchContext = workbenchContext;
            this.table.setSelectionModel(new SelectionModelWrapper(this));
            this.table.getTableHeader().setDefaultRenderer(this.headerRenderer);
            this.initColumnWidths();
            this.setToolTips();
            this.setBorder(BorderFactory.createMatteBorder(0, 5, 0, 0, new FeatureInfoWriter().sidebarColor(model.getLayer())));
            this.table.getTableHeader().addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    try {
                        int column = AttributeTablePanel.this.table.columnAtPoint(e.getPoint());
                        if (AttributeTablePanel.this.isEditButtonColumn(column)) {
                            return;
                        }
                        if (SwingUtilities.isLeftMouseButton(e)) {
                            model.sort(AttributeTablePanel.this.table.getColumnName(column));
                        }
                    }
                    catch (Throwable t) {
                        workbenchContext.getErrorHandler().handleThrowable(t);
                    }
                }
            });
            this.table.addMouseListener(new MouseAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void mouseClicked(MouseEvent e) {
                    block5: {
                        try {
                            int column = AttributeTablePanel.this.table.columnAtPoint(e.getPoint());
                            int row = AttributeTablePanel.this.table.rowAtPoint(e.getPoint());
                            if (!AttributeTablePanel.this.isEditButtonColumn(column)) break block5;
                            PlugInContext context = new PlugInContext(workbenchContext, null, model.getLayer(), null, null);
                            model.getLayer().getLayerManager().getUndoableEditReceiver().startReceiving();
                            try {
                                AttributeTablePanel.this.featureEditor.edit(context, model.getFeature(row), model.getLayer());
                            }
                            finally {
                                model.getLayer().getLayerManager().getUndoableEditReceiver().stopReceiving();
                            }
                            return;
                        }
                        catch (Throwable t) {
                            workbenchContext.getErrorHandler().handleThrowable(t);
                        }
                    }
                }
            });
        }
        catch (Throwable t) {
            workbenchContext.getErrorHandler().handleThrowable(t);
        }
    }

    private AttributeTablePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void updateGrid(Layer layer) {
        this.table.setShowGrid(layer.isEditable());
    }

    private boolean isEditButtonColumn(int column) {
        return this.getModel().getColumnName(0).equals(this.table.getColumnName(column));
    }

    private void updateLabel() {
        if (this.getModel().getRowCount() == 1) {
            this.layerNameRenderer.getLabel().setText(this.getModel().getLayer().getName() + " (" + this.getModel().getRowCount() + " " + I18N.get((String)"ui.AttributeTablePanel.feature") + ")");
        } else {
            this.layerNameRenderer.getLabel().setText(this.getModel().getLayer().getName() + " (" + this.getModel().getRowCount() + " " + I18N.get((String)"ui.AttributeTablePanel.features") + ")");
        }
    }

    public LayerTableModel getModel() {
        return (LayerTableModel)this.table.getModel();
    }

    public JTable getTable() {
        return this.table;
    }

    public void addListener(AttributeTablePanelListener listener) {
        this.listeners.add(listener);
    }

    void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.layerNameRenderer, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.table.getTableHeader(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.table, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 200), 0, 0));
    }

    private void initColumnWidths() {
        GUIUtil.chooseGoodColumnWidths(this.table);
        int editButtonWidth = 16;
        this.table.getColumnModel().getColumn(0).setMinWidth(editButtonWidth);
        this.table.getColumnModel().getColumn(0).setMaxWidth(editButtonWidth);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(editButtonWidth);
        this.columnWidthsInitialized = true;
    }

    private void setToolTips() {
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                int column = AttributeTablePanel.this.table.columnAtPoint(e.getPoint());
                if (column == -1) {
                    return;
                }
                AttributeTablePanel.this.table.setToolTipText(AttributeTablePanel.this.table.getColumnName(column) + " [" + AttributeTablePanel.this.getModel().getLayer().getName() + "]");
            }
        });
    }

    private void fireSelectionReplaced() {
        for (AttributeTablePanelListener listener : this.listeners) {
            listener.selectionReplaced(this);
        }
    }

    public Collection getSelectedFeatures() {
        ArrayList<Feature> selectedFeatures = new ArrayList<Feature>();
        if (this.getModel().getRowCount() == 0) {
            return selectedFeatures;
        }
        int[] selectedRows = this.table.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedFeatures.add(this.getModel().getFeature(selectedRows[i]));
        }
        return selectedFeatures;
    }

    public LayerNameRenderer getLayerNameRenderer() {
        return this.layerNameRenderer;
    }

    public void setFeatureEditor(FeatureEditor featureEditor) {
        this.featureEditor = featureEditor;
    }

    private static class SelectionModelWrapper
    implements ListSelectionModel {
        private AttributeTablePanel panel;
        private ListSelectionModel selectionModel;

        public SelectionModelWrapper(AttributeTablePanel panel) {
            this.panel = panel;
            this.selectionModel = panel.table.getSelectionModel();
        }

        public void setAnchorSelectionIndex(int index) {
            this.selectionModel.setAnchorSelectionIndex(index);
        }

        public void setLeadSelectionIndex(int index) {
            this.selectionModel.setLeadSelectionIndex(index);
        }

        public void setSelectionInterval(int index0, int index1) {
            this.selectionModel.setSelectionInterval(index0, index1);
            this.panel.fireSelectionReplaced();
        }

        public void setSelectionMode(int selectionMode) {
            this.selectionModel.setSelectionMode(selectionMode);
        }

        public void setValueIsAdjusting(boolean valueIsAdjusting) {
            this.selectionModel.setValueIsAdjusting(valueIsAdjusting);
        }

        public int getAnchorSelectionIndex() {
            return this.selectionModel.getAnchorSelectionIndex();
        }

        public int getLeadSelectionIndex() {
            return this.selectionModel.getLeadSelectionIndex();
        }

        public int getMaxSelectionIndex() {
            return this.selectionModel.getMaxSelectionIndex();
        }

        public int getMinSelectionIndex() {
            return this.selectionModel.getMinSelectionIndex();
        }

        public int getSelectionMode() {
            return this.selectionModel.getSelectionMode();
        }

        public boolean getValueIsAdjusting() {
            return this.selectionModel.getValueIsAdjusting();
        }

        public boolean isSelectedIndex(int index) {
            return this.selectionModel.isSelectedIndex(index);
        }

        public boolean isSelectionEmpty() {
            return this.selectionModel.isSelectionEmpty();
        }

        public void addListSelectionListener(ListSelectionListener x) {
            this.selectionModel.addListSelectionListener(x);
        }

        public void addSelectionInterval(int index0, int index1) {
            this.selectionModel.addSelectionInterval(index0, index1);
        }

        public void clearSelection() {
            this.selectionModel.clearSelection();
        }

        public void insertIndexInterval(int index, int length, boolean before) {
            this.selectionModel.insertIndexInterval(index, length, before);
        }

        public void removeIndexInterval(int index0, int index1) {
            this.selectionModel.removeIndexInterval(index0, index1);
        }

        public void removeListSelectionListener(ListSelectionListener x) {
            this.selectionModel.removeListSelectionListener(x);
        }

        public void removeSelectionInterval(int index0, int index1) {
            this.selectionModel.removeSelectionInterval(index0, index1);
        }
    }

    private class GeometryCellRenderer
    implements TableCellRenderer {
        private JButton button = new JButton(IconLoader.icon("Pencil.gif"));
        private JButton buttonPoint = new JButton(IconLoader.icon("EditPoint.gif"));
        private JButton buttonMultiPoint = new JButton(IconLoader.icon("EditMultiPoint.gif"));
        private JButton buttonLineString = new JButton(IconLoader.icon("EditLineString.gif"));
        private JButton buttonMultiLineString = new JButton(IconLoader.icon("EditMultiLineString.gif"));
        private JButton buttonPolygon = new JButton(IconLoader.icon("EditPolygon.gif"));
        private JButton buttonMultiPolygon = new JButton(IconLoader.icon("EditMultiPolygon.gif"));
        private JButton buttonGC = new JButton(IconLoader.icon("EditGeometryCollection.gif"));
        private JButton buttonEmptyGC = new JButton(IconLoader.icon("EditEmptyGC.gif"));

        GeometryCellRenderer() {
            this.buttonPoint.setToolTipText("View/Edit Point");
            this.buttonMultiPoint.setToolTipText("View/Edit MultiPoint");
            this.buttonLineString.setToolTipText("View/Edit LineString");
            this.buttonMultiLineString.setToolTipText("View/Edit MultiLineString");
            this.buttonPolygon.setToolTipText("View/Edit Polygon");
            this.buttonMultiPolygon.setToolTipText("View/Edit MultiPolygon");
            this.buttonGC.setToolTipText("View/Edit GeometryCollection");
            this.buttonEmptyGC.setToolTipText("View/Edit empty GeometryCollection");
            this.button.setToolTipText("View/Edit Geometry");
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Feature f = (Feature)value;
            Geometry g = f.getGeometry();
            if (g instanceof Point) {
                return this.buttonPoint;
            }
            if (g instanceof MultiPoint) {
                return this.buttonMultiPoint;
            }
            if (g instanceof LineString) {
                return this.buttonLineString;
            }
            if (g instanceof MultiLineString) {
                return this.buttonMultiLineString;
            }
            if (g instanceof Polygon) {
                return this.buttonPolygon;
            }
            if (g instanceof MultiPolygon) {
                return this.buttonMultiPolygon;
            }
            if (g.isEmpty()) {
                return this.buttonEmptyGC;
            }
            return this.buttonGC;
        }
    }

    private class MyTable
    extends JTable {
        private final Color LIGHT_GRAY = new Color(230, 230, 230);
        private GeometryCellRenderer geomCellRenderer = new GeometryCellRenderer();

        public MyTable() {
            this.setAutoResizeMode(0);
            GUIUtil.doNotRoundDoubles(this);
            this.setDefaultEditor(Date.class, (TableCellEditor)new FlexibleDateParser.CellEditor());
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            if (!AttributeTablePanel.this.isEditButtonColumn(column)) {
                JComponent renderer = (JComponent)((Object)super.getCellRenderer(row, column));
                renderer.setBackground(AttributeTablePanel.this.getModel().getLayer().isEditable() || row % 2 == 0 ? Color.white : this.LIGHT_GRAY);
                return (TableCellRenderer)((Object)renderer);
            }
            return this.geomCellRenderer;
        }
    }

    public static interface FeatureEditor {
        public void edit(PlugInContext var1, Feature var2, Layer var3) throws Exception;
    }
}

