/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.mrsid;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactory;
import com.vividsolutions.jump.workbench.imagery.mrsid.MrSIDReferencedImage;
import com.vividsolutions.jump.workbench.imagery.mrsid.SIDInfo;
import java.io.File;

public class MrSIDImageFactory
implements ReferencedImageFactory {
    public static String WORKING_DIR;
    public static String ETC_PATH;
    public static String TMP_PATH;
    public static String MRSIDDECODE;
    public static String MRSIDINFO;
    public static final String MRSIDDECODEFILE = "mrsidgeodecode.exe";
    public static final String MRSIDINFOFILE = "mrsidgeoinfo.exe";
    static final String sNotInstalled;
    static final String sErrorSeeOutputWindow;

    public String getTypeName() {
        return "MrSID";
    }

    public ReferencedImage createImage(String location) throws JUMPException {
        return new MrSIDReferencedImage(SIDInfo.readInfo(location), location);
    }

    public String getDescription() {
        return this.getTypeName();
    }

    public String[] getExtensions() {
        return new String[]{"sid"};
    }

    public boolean isEditableImage(String location) {
        return false;
    }

    public boolean isAvailable(WorkbenchContext context) {
        int i = -1;
        File empty = new File("");
        String sep = File.separator;
        WORKING_DIR = context.getWorkbench().getPlugInManager().getPlugInDirectory() + sep;
        ETC_PATH = WORKING_DIR + "etc" + sep;
        TMP_PATH = WORKING_DIR + "etc" + sep + "tmp" + sep;
        MRSIDDECODE = ETC_PATH + MRSIDDECODEFILE;
        MRSIDINFO = ETC_PATH + MRSIDINFOFILE;
        if (!new File(MRSIDDECODE).exists()) {
            return false;
        }
        return new File(MRSIDINFO).exists();
    }

    static {
        sNotInstalled = I18N.get((String)"org.openjump.core.ui.plugin.layer.AddSIDLayerPlugIn.not-installed");
        sErrorSeeOutputWindow = I18N.get((String)"org.openjump.core.ui.plugin.layer.AddSIDLayerPlugIn.Error-See-Output-Window");
    }
}

