/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.internal.SingleWidgetPanel;
import buoy.widget.BSeparator;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.IndexedContainerDelegate;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JToolBar;

public class BToolBar
extends WidgetContainer {
    private ArrayList child;
    public static final Orientation HORIZONTAL = new Orientation(0);
    public static final Orientation VERTICAL = new Orientation(1);

    public BToolBar() {
        this(HORIZONTAL);
    }

    public BToolBar(Orientation orientation) {
        this.component = this.createComponent();
        this.child = new ArrayList();
        this.setOrientation(orientation);
    }

    protected JToolBar createComponent() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        return toolbar;
    }

    public Orientation getOrientation() {
        int orientation = ((JToolBar)this.getComponent()).getOrientation();
        return orientation == 0 ? HORIZONTAL : VERTICAL;
    }

    public void setOrientation(Orientation orientation) {
        ((JToolBar)this.getComponent()).setOrientation(orientation.value);
    }

    public void add(Widget widget) {
        this.add(widget, this.getChildCount());
    }

    public void add(Widget widget, int index) {
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        this.child.add(index, widget);
        ((JToolBar)this.component).add((Component)new SingleWidgetPanel(widget), index);
        this.setAsParent(widget);
    }

    public void addSeparator() {
        this.add(new BSeparator(this.getOrientation() == HORIZONTAL ? BSeparator.VERTICAL : BSeparator.HORIZONTAL));
    }

    public int getChildCount() {
        return this.child.size();
    }

    public Widget getChild(int i) {
        return (Widget)this.child.get(i);
    }

    public Collection getChildren() {
        return new ArrayList(this.child);
    }

    public void remove(Widget widget) {
        this.child.remove(widget);
        ((JToolBar)this.component).remove(widget.component.getParent());
        this.removeAsParent(widget);
    }

    public void removeAll() {
        for (int i = 0; i < this.child.size(); ++i) {
            this.removeAsParent((Widget)this.child.get(i));
        }
        ((JToolBar)this.component).removeAll();
        this.child.clear();
    }

    public int getChildIndex(Widget widget) {
        return this.child.indexOf(widget);
    }

    public void layoutChildren() {
        this.getComponent().validate();
        for (int i = 0; i < this.child.size(); ++i) {
            Widget w = (Widget)this.child.get(i);
            if (!(w instanceof WidgetContainer)) continue;
            ((WidgetContainer)w).layoutChildren();
        }
    }

    static {
        WidgetEncoder.setPersistenceDelegate(BToolBar.class, new IndexedContainerDelegate(new String[]{"getChild"}));
        WidgetEncoder.setPersistenceDelegate(Orientation.class, new StaticFieldDelegate(BToolBar.class));
    }

    public static class Orientation {
        private int value;

        private Orientation(int value) {
            this.value = value;
        }
    }
}

