/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.ValueChangedEvent;
import buoy.widget.Widget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.StaticFieldDelegate;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BSlider
extends Widget {
    private int suppressEvents;
    public static final Orientation HORIZONTAL = new Orientation(0);
    public static final Orientation VERTICAL = new Orientation(1);

    public BSlider() {
        this(0, 0, 100, VERTICAL);
    }

    public BSlider(int value, int minimum, int maximum, Orientation orientation) {
        this.component = this.createComponent(orientation);
        ((JSlider)this.component).setModel(new DefaultBoundedRangeModel(value, 0, minimum, maximum));
        ((JSlider)this.component).addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                if (BSlider.this.suppressEvents == 0) {
                    BSlider.this.dispatchEvent(new ValueChangedEvent(BSlider.this, ((JSlider)BSlider.this.component).getValueIsAdjusting()));
                }
            }
        });
        this.setMajorTickSpacing(20);
        this.setMinorTickSpacing(5);
    }

    protected JSlider createComponent(Orientation orientation) {
        return new JSlider(orientation.value);
    }

    public int getMinimum() {
        return ((JSlider)this.component).getMinimum();
    }

    public void setMinimum(int value) {
        ((JSlider)this.component).setMinimum(value);
    }

    public int getMaximum() {
        return ((JSlider)this.component).getMaximum();
    }

    public void setMaximum(int value) {
        ((JSlider)this.component).setMaximum(value);
    }

    public int getValue() {
        return ((JSlider)this.component).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int value) {
        try {
            ++this.suppressEvents;
            ((JSlider)this.component).setValue(value);
        }
        finally {
            --this.suppressEvents;
        }
    }

    public Orientation getOrientation() {
        int orient = ((JSlider)this.component).getOrientation();
        return orient == BSlider.HORIZONTAL.value ? HORIZONTAL : VERTICAL;
    }

    public void setOrientation(Orientation orientation) {
        ((JSlider)this.component).setOrientation(orientation.value);
        this.invalidateSize();
    }

    public int getMajorTickSpacing() {
        return ((JSlider)this.component).getMajorTickSpacing();
    }

    public void setMajorTickSpacing(int spacing) {
        JSlider slider = (JSlider)this.component;
        slider.setMajorTickSpacing(spacing);
        if (spacing < slider.getMinorTickSpacing()) {
            slider.setMinorTickSpacing(spacing);
        }
        slider.setLabelTable(slider.createStandardLabels(spacing));
    }

    public int getMinorTickSpacing() {
        return ((JSlider)this.component).getMinorTickSpacing();
    }

    public void setMinorTickSpacing(int spacing) {
        JSlider slider = (JSlider)this.component;
        slider.setMinorTickSpacing(spacing);
        if (spacing > slider.getMajorTickSpacing()) {
            slider.setMajorTickSpacing(spacing);
        }
    }

    public boolean getShowTicks() {
        return ((JSlider)this.component).getPaintTicks();
    }

    public void setShowTicks(boolean show) {
        ((JSlider)this.component).setPaintTicks(show);
    }

    public boolean getShowLabels() {
        return ((JSlider)this.component).getPaintLabels();
    }

    public void setShowLabels(boolean show) {
        ((JSlider)this.component).setPaintLabels(show);
    }

    public boolean getSnapToTicks() {
        return ((JSlider)this.component).getSnapToTicks();
    }

    public void setSnapToTicks(boolean snap) {
        ((JSlider)this.component).setSnapToTicks(snap);
    }

    static {
        WidgetEncoder.setPersistenceDelegate(Orientation.class, new StaticFieldDelegate(BSlider.class));
    }

    public static class Orientation {
        protected int value;

        private Orientation(int value) {
            this.value = value;
        }
    }
}

