/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.swing;

import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openjump.core.apitools.ToolToMakeYourLifeEasier;

public class DialogTools
extends ToolToMakeYourLifeEasier {
    public static void centerOnScreen(Window window) {
        GUIUtil.centreOnScreen((Component)window);
    }

    public static void centerOnWindow(Component component) {
        GUIUtil.centreOnWindow((Component)component);
    }

    public static void centerOnWindow(Component component2move, Component component2CenterOn) {
        GUIUtil.centre((Component)component2move, (Component)component2CenterOn);
    }

    public static JPanel getPanelWithLabels(String text, int charsPerLine) {
        int i;
        ArrayList<String> labelTextParts = new ArrayList<String>();
        if (text.length() > charsPerLine) {
            int estimatedStrings = (int)Math.ceil((float)text.length() / (float)charsPerLine);
            String copyLabelText = text.toString();
            for (i = 0; i < estimatedStrings; ++i) {
                if (copyLabelText.indexOf(" ", charsPerLine) > -1) {
                    labelTextParts.add(copyLabelText.substring(0, copyLabelText.indexOf(" ", charsPerLine) + 1));
                } else {
                    labelTextParts.add(copyLabelText);
                }
                copyLabelText = copyLabelText.substring(((String)labelTextParts.get(i)).length());
            }
        } else {
            labelTextParts.add(text);
        }
        JPanel texts = new JPanel();
        GridLayout gl = new GridLayout(labelTextParts.size(), 1);
        gl.setHgap(0);
        texts.setLayout(gl);
        for (i = 0; i < labelTextParts.size(); ++i) {
            texts.add(new JLabel("  " + (String)labelTextParts.get(i) + "  "));
        }
        texts.doLayout();
        return texts;
    }

    public static double localNumberStringToDouble(String s) {
        DecimalFormatSymbols ds = new DecimalFormatSymbols();
        s = s.replace(ds.getDecimalSeparator(), '.');
        return Double.parseDouble(s);
    }

    public static String numberStringToLocalNumberString(String s) {
        DecimalFormatSymbols ds = new DecimalFormatSymbols();
        s = s.replace('.', ds.getDecimalSeparator());
        return s;
    }

    public static String numberToLocalNumberString(double number) {
        String s = new Double(number).toString();
        return DialogTools.numberStringToLocalNumberString(s);
    }

    public static void setPreferedWidth(JComponent component, int width) {
        int preferedHeight = component.getPreferredSize().height;
        component.setPreferredSize(new Dimension(width, preferedHeight));
    }

    public static void setPreferedHeight(JComponent component, int height) {
        int preferedWidth = component.getPreferredSize().width;
        component.setPreferredSize(new Dimension(preferedWidth, height));
    }

    public static void setMaximumWidth(JComponent component, int width) {
        int preferedHeight = component.getPreferredSize().height;
        component.setMaximumSize(new Dimension(width, preferedHeight));
    }

    public static void setMaximumHeight(JComponent component, int height) {
        int preferedWidth = component.getPreferredSize().width;
        component.setMaximumSize(new Dimension(preferedWidth, height));
    }
}

