/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.openjump.core.attributeoperations.JoinAttributes;

public class JoinAttributesSpatiallyPlugIn
extends ThreadedBasePlugIn {
    private String sidebartext = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.Joins-attributes-of-source-layer-according-to-a-spatial-and-a-statistic-criterion");
    private String SRC_LAYER = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.source-layer");
    private String TGT_LAYER = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.target-layer");
    private String SRC_ATTRIB = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.select-attribute");
    private String ATTRIB_OP = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.select-attribute-operation");
    private String SPATIAL_OP = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.select-spatial-operation");
    private String joinresult = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.join-result");
    private String notimplemented = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.not-implemented");
    private String BUFFER_RADIUS = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.buffer-radius");
    private Layer srcLayer = null;
    private Layer targetLayer = null;
    private String attrName = "";
    int attributeOperation = 0;
    int spatialOperation = 0;
    private double bradius = 0.0;
    private MultiInputDialog dialog;
    private PlugInContext pc = null;
    ArrayList attrOpList = new ArrayList();
    ArrayList spatialOpList = new ArrayList();
    private JComboBox layerboxA;
    private JComboBox layerboxB;
    private JComboBox attribbox;
    private JComboBox attribOpbox;
    private JComboBox spatialOpbox;
    private Object attrValue = null;
    private Object attrOpValue = "";
    private Object spatialOpValue = "";
    private ArrayList attColl = new ArrayList();
    private ArrayList attOpColl = new ArrayList();
    private ArrayList SpatialOpColl = new ArrayList();

    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS, MenuNames.TWOLAYERS}, this.getName() + "{pos:5}", false, null, (EnableCheck)JoinAttributesSpatiallyPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.Join-Attributes-Spatially") + "...";
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(2));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.sidebartext = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.Joins-attributes-of-source-layer-according-to-a-spatial-and-a-statistic-criterion");
        this.SRC_LAYER = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.source-layer");
        this.TGT_LAYER = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.target-layer");
        this.SRC_ATTRIB = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.select-attribute");
        this.ATTRIB_OP = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.select-attribute-operation");
        this.SPATIAL_OP = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.select-spatial-operation");
        this.joinresult = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.join-result");
        this.notimplemented = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.not-implemented");
        this.BUFFER_RADIUS = I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.buffer-radius");
        this.generateOpLists();
        this.dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow((Component)this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getdialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        this.pc = context;
        List srcFeatures = this.srcLayer.getFeatureCollectionWrapper().getFeatures();
        List targetFeatures = this.targetLayer.getFeatureCollectionWrapper().getFeatures();
        FeatureDataset results = JoinAttributes.joinAttributes(srcFeatures, targetFeatures, this.attrName, this.attributeOperation, this.spatialOperation, this.bradius, monitor);
        if (results.size() > 0) {
            context.addLayer(StandardCategoryNames.RESULT, this.joinresult, (FeatureCollection)results);
        } else {
            context.getWorkbenchFrame().warnUser(this.notimplemented);
        }
    }

    private void setDialogValues(MultiInputDialog selectTypeDialog2, PlugInContext context) {
        this.dialog.setSideBarDescription(this.sidebartext);
        if (this.targetLayer == null) {
            this.targetLayer = context.getCandidateLayer(0);
        }
        this.layerboxA = this.dialog.addLayerComboBox(this.TGT_LAYER, this.targetLayer, "", context.getLayerManager());
        if (this.srcLayer == null) {
            this.srcLayer = context.getCandidateLayer(0);
        }
        this.layerboxB = this.dialog.addLayerComboBox(this.SRC_LAYER, this.srcLayer, "", context.getLayerManager());
        this.layerboxB.addItemListener(new MethodItemListener());
        this.attribbox = this.dialog.addComboBox(this.SRC_ATTRIB, this.attrValue, (Collection)this.attColl, "");
        this.updateUIForAttributes();
        this.attribOpbox = this.dialog.addComboBox(this.ATTRIB_OP, this.attrOpValue, (Collection)this.attOpColl, "");
        DefaultComboBoxModel modelA = new DefaultComboBoxModel();
        for (int i = 0; i < this.attrOpList.size(); ++i) {
            modelA.addElement(this.attrOpList.get(i));
        }
        this.attribOpbox.setModel(modelA);
        this.spatialOpbox = this.dialog.addComboBox(this.SPATIAL_OP, this.attrValue, (Collection)this.attOpColl, "");
        DefaultComboBoxModel modelS = new DefaultComboBoxModel();
        for (int i = 0; i < this.spatialOpList.size(); ++i) {
            modelS.addElement(this.spatialOpList.get(i));
        }
        this.spatialOpbox.setModel(modelS);
        this.dialog.addDoubleField(this.BUFFER_RADIUS, this.bradius, 7);
    }

    private void updateUIForAttributes() {
        this.srcLayer = this.dialog.getLayer(this.SRC_LAYER);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (int i = 0; i < this.srcLayer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeCount(); ++i) {
            if (i == this.srcLayer.getFeatureCollectionWrapper().getFeatureSchema().getGeometryIndex()) continue;
            model.addElement(this.srcLayer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeName(i));
        }
        this.attribbox.setModel(model);
        if (model.getSize() == 0) {
            // empty if block
        }
        this.dialog.validate();
    }

    private void getdialogValues(MultiInputDialog dialog) {
        this.srcLayer = dialog.getLayer(this.SRC_LAYER);
        this.targetLayer = dialog.getLayer(this.TGT_LAYER);
        this.attrName = (String)this.attribbox.getSelectedItem();
        this.attributeOperation = this.attribOpbox.getSelectedIndex();
        this.spatialOperation = this.spatialOpbox.getSelectedIndex();
        this.bradius = dialog.getDouble(this.BUFFER_RADIUS);
    }

    private void generateOpLists() {
        this.attrOpList.clear();
        this.attrOpList.add(0, I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.majority"));
        this.attrOpList.add(1, I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.minority"));
        this.attrOpList.add(2, I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.mean"));
        this.attrOpList.add(3, I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.median"));
        this.attrOpList.add(4, I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.minimum"));
        this.attrOpList.add(5, I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.maximum"));
        this.attrOpList.add(6, I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.standard-dev"));
        this.attrOpList.add(7, I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.sum"));
        this.attrOpList.add(8, I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.count"));
        this.spatialOpList.clear();
        this.spatialOpList.add(0, I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.source-features-contained-in-a-target-feature"));
        this.spatialOpList.add(1, I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.source-features-intersecting-a-target-feature"));
        this.spatialOpList.add(2, I18N.get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.target-feature-covered-by-source-features"));
    }

    private class MethodItemListener
    implements ItemListener {
        private MethodItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            JoinAttributesSpatiallyPlugIn.this.updateUIForAttributes();
        }
    }
}

