/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.util.ArrayList;
import java.util.Collection;

public class DeleteEmptyGeometriesPlugIn
extends AbstractPlugIn {
    private WorkbenchContext workbenchContext;
    private MultiInputDialog dialog;
    private boolean exceptionThrown = false;
    private boolean selectEmpty = false;
    private boolean selectPoint = false;
    private boolean selectMultiPoint = false;
    private boolean selectLineString = false;
    private boolean selectLinearRing = false;
    private boolean selectMultiLineString = false;
    private boolean selectPolygon = false;
    private boolean selectMultiPolygon = false;
    private boolean selectGeometryCollection = false;
    private boolean selectedLayersOnly = true;
    protected AbstractSelection selection;
    String sDeleteEmptyGeometries = I18N.get("org.openjump.core.ui.plugin.tools.DeleteEmptyGeometriesPlugIn.Delete-Empty-Geometries-in-Selection");

    public void initialize(PlugInContext context) throws Exception {
        this.workbenchContext = context.getWorkbenchContext();
        context.getFeatureInstaller().addMainMenuItemWithJava14Fix((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_QA}, this.sDeleteEmptyGeometries + "...", false, null, (EnableCheck)this.createEnableCheck(this.workbenchContext));
    }

    public boolean execute(PlugInContext context) throws Exception {
        String sDeleteEmptyGeometries = I18N.get("org.openjump.core.ui.plugin.tools.DeleteEmptyGeometriesPlugIn.Delete-Empty-Geometries-in-Selection");
        this.reportNothingToUndoYet(context);
        ArrayList<Feature> featuresToDelete = new ArrayList<Feature>();
        Collection layers = context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        for (Layer layer : layers) {
            Collection selectedFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(layer);
            for (Feature feature : selectedFeatures) {
                if (!feature.getGeometry().isEmpty()) continue;
                featuresToDelete.add(feature);
            }
            layer.getFeatureCollectionWrapper().removeAll(featuresToDelete);
            featuresToDelete.clear();
        }
        return true;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNFeaturesMustHaveSelectedItemsCheck(1));
    }
}

