/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JPopupMenu;

public class ToggleVisiblityPlugIn
extends AbstractPlugIn {
    private static final String toggleVisibility = I18N.get("org.openjump.core.ui.plugin.layer.ToggleVisiblityPlugIn.Toggle-Visibility");
    private static final String errorSeeOutputWindow = I18N.get("org.openjump.core.ui.plugin.layer.ToggleVisiblityPlugIn.Error-See-Output-Window");
    private static final String layerName = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Layer-Name");

    public void initialize(PlugInContext context) throws Exception {
        WorkbenchContext workbenchContext = context.getWorkbenchContext();
        FeatureInstaller featureInstaller = new FeatureInstaller(workbenchContext);
        TitledPopupMenu layerNamePopupMenu = workbenchContext.getWorkbench().getFrame().getLayerNamePopupMenu();
        featureInstaller.addPopupMenuItem((JPopupMenu)layerNamePopupMenu, (PlugIn)this, toggleVisibility, false, null, (EnableCheck)ToggleVisiblityPlugIn.createEnableCheck(workbenchContext));
        TitledPopupMenu wmsLayerNamePopupMenu = workbenchContext.getWorkbench().getFrame().getWMSLayerNamePopupMenu();
        featureInstaller.addPopupMenuItem((JPopupMenu)wmsLayerNamePopupMenu, (PlugIn)this, toggleVisibility, false, null, (EnableCheck)ToggleVisiblityPlugIn.createEnableCheck2(workbenchContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(PlugInContext context) throws Exception {
        try {
            Collection layerCollection = context.getWorkbenchContext().getLayerNamePanel().selectedNodes(Layerable.class);
            boolean firingEvents = context.getLayerManager().isFiringEvents();
            context.getLayerManager().setFiringEvents(false);
            try {
                Iterator j = layerCollection.iterator();
                while (j.hasNext()) {
                    Layerable layer;
                    layer.setVisible(!(layer = (Layerable)j.next()).isVisible());
                }
            }
            finally {
                context.getLayerManager().setFiringEvents(firingEvents);
                context.getLayerViewPanel().repaint();
                context.getWorkbenchFrame().repaint();
            }
        }
        catch (Exception e) {
            context.getWorkbenchFrame().warnUser(errorSeeOutputWindow);
            context.getWorkbenchFrame().getOutputFrame().createNewDocument();
            context.getWorkbenchFrame().getOutputFrame().addText("ToggleVisiblityPlugIn Exception:" + e.toString());
            return false;
        }
        return true;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
    }

    public static MultiEnableCheck createEnableCheck2(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesMustBeSelectedCheck(1, Layerable.class));
    }
}

