/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file.open;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.LoadFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.registry.Registry;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openjump.core.ui.io.file.FileLayerLoader;
import org.openjump.core.ui.io.file.FileLayerLoaderExtensionFilter;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;
import org.openjump.core.ui.plugin.file.open.OpenFileWizardState;
import org.openjump.swing.listener.InvokeMethodActionListener;

public class SelectFilesPanel
extends JFileChooser
implements WizardPanel {
    public static final String KEY = SelectFilesPanel.class.getName();
    public static final String TITLE = I18N.get(KEY);
    public static final String INSTRUCTIONS = I18N.get(KEY + ".instructions");
    public static final String ALL_FILES = I18N.get(KEY + ".all-files");
    private Set<InputChangedListener> listeners = new LinkedHashSet<InputChangedListener>();
    private Blackboard blackboard;
    private OpenFileWizardState state;
    private WorkbenchContext workbenchContext;
    private boolean initialized = false;
    private WizardDialog dialog;

    public SelectFilesPanel(WorkbenchContext workbenchContext) {
        this.workbenchContext = workbenchContext;
    }

    public OpenFileWizardState getState() {
        return this.state;
    }

    public void setState(OpenFileWizardState state) {
        this.state = state;
        for (FileFilter filter : this.getChoosableFileFilters()) {
            this.removeChoosableFileFilter(filter);
        }
    }

    public WizardDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(WizardDialog dialog) {
        this.dialog = dialog;
    }

    private void initialize() {
        this.initialized = true;
        this.blackboard = PersistentBlackboardPlugIn.get((WorkbenchContext)this.workbenchContext);
        Registry registry = this.workbenchContext.getRegistry();
        String savedDirectoryName = (String)this.blackboard.get(LoadFileDataSourceQueryChooser.FILE_CHOOSER_DIRECTORY_KEY);
        if (savedDirectoryName != null) {
            this.setCurrentDirectory(new File(savedDirectoryName));
        }
        this.setAcceptAllFileFilterUsed(false);
        this.setMultiSelectionEnabled(true);
        List loaders = registry.getEntries((Object)FileLayerLoader.KEY);
        TreeSet<String> allExtensions = new TreeSet<String>();
        allExtensions.add("zip");
        allExtensions.add("gz");
        TreeMap<String, FileLayerLoaderExtensionFilter> filters = new TreeMap<String, FileLayerLoaderExtensionFilter>();
        for (Object loader : loaders) {
            FileLayerLoader fileLayerLoader = (FileLayerLoader)loader;
            FileLayerLoaderExtensionFilter filter = new FileLayerLoaderExtensionFilter(fileLayerLoader);
            allExtensions.addAll(fileLayerLoader.getFileExtensions());
            filters.put(((FileFilter)filter).getDescription(), filter);
        }
        FileNameExtensionFilter allFilter = new FileNameExtensionFilter(ALL_FILES, allExtensions.toArray(new String[0]));
        this.addChoosableFileFilter(allFilter);
        for (FileFilter filter : filters.values()) {
            this.addChoosableFileFilter(filter);
        }
        this.setFileFilter(allFilter);
        this.setControlButtonsAreShown(false);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                FileLayerLoader fileLayerLoader = null;
                File[] files = SelectFilesPanel.this.getSelectedFiles();
                FileFilter selectedFileFilter = SelectFilesPanel.this.getFileFilter();
                if (selectedFileFilter instanceof FileLayerLoaderExtensionFilter) {
                    FileLayerLoaderExtensionFilter filter = (FileLayerLoaderExtensionFilter)selectedFileFilter;
                    fileLayerLoader = filter.getFileLoader();
                }
                SelectFilesPanel.this.state.setupFileLoaders(files, fileLayerLoader);
                SelectFilesPanel.this.fireInputChanged();
            }
        });
        this.addActionListener(new InvokeMethodActionListener(this.dialog, "next"));
    }

    public void enteredFromLeft(Map dataMap) {
        this.initialize();
        this.rescanCurrentDirectory();
        this.state.setCurrentPanel(KEY);
    }

    public void exitingToRight() throws Exception {
        this.blackboard.put(LoadFileDataSourceQueryChooser.FILE_CHOOSER_DIRECTORY_KEY, this.getCurrentDirectory().getAbsolutePath());
    }

    public String getID() {
        return this.getClass().getName();
    }

    public String getInstructions() {
        return INSTRUCTIONS;
    }

    public String getNextID() {
        return this.state.getNextPanel(KEY);
    }

    public String getTitle() {
        return TITLE;
    }

    public boolean isInputValid() {
        return this.state.hasSelectedFiles();
    }

    public void add(InputChangedListener listener) {
        this.listeners.add(listener);
    }

    public void remove(InputChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void fireInputChanged() {
        for (InputChangedListener listener : this.listeners) {
            listener.inputChanged();
        }
    }
}

