/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.customize;

import bsh.EvalError;
import bsh.Interpreter;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import org.apache.log4j.Logger;

public class BeanToolsPlugIn
extends AbstractPlugIn {
    private static final Logger LOG = Logger.getLogger(BeanToolsPlugIn.class);
    private static final String sName = I18N.get("org.openjump.core.ui.plugin.customize.BeanToolsPlugIn.Bean-Tools");
    private String lastcmd = "";
    private String beanShellDirName;
    private TaskMonitorManager taskMonitorManager;
    private FeatureInstaller featureInstaller;

    public void initialize(PlugInContext context) throws Exception {
        File plugInDirectory = context.getWorkbenchContext().getWorkbench().getPlugInManager().getPlugInDirectory();
        if (null == plugInDirectory || !plugInDirectory.exists()) {
            LOG.debug((Object)"BeanTools plugin has not been initialized : the plugin directory is missing");
            return;
        }
        this.beanShellDirName = plugInDirectory.getPath() + File.separator + I18N.get("ui.plugin.customize.BeanToolsPlugIn.BeanTools");
        File beanShellDir = new File(this.beanShellDirName);
        this.featureInstaller = context.getFeatureInstaller();
        this.taskMonitorManager = new TaskMonitorManager();
        if (beanShellDir.exists()) {
            this.scanBeanShellDir(beanShellDir, context);
        }
    }

    private String ancestors(File dir, File file) throws IOException {
        String path = file.getCanonicalPath();
        return path.substring(path.lastIndexOf(dir.getName()), path.lastIndexOf(file.getName()));
    }

    private void scanBeanShellDir(final File file, PlugInContext context) throws IOException {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.scanBeanShellDir(f, context);
            }
        } else if (file.getName().endsWith(".bsh")) {
            File beanShellDir = new File(this.beanShellDirName);
            String ancestors = this.ancestors(beanShellDir, file);
            String shellName = file.getName().substring(0, file.getName().length() - 4);
            JMenu menu = this.featureInstaller.menuBarMenu(MenuNames.CUSTOMIZE);
            if (menu == null) {
                menu = (JMenu)FeatureInstaller.installMnemonic((JMenuItem)new JMenu(I18N.get(MenuNames.CUSTOMIZE)), (MenuElement)this.featureInstaller.menuBar());
                this.featureInstaller.menuBar().add(menu);
            }
            JMenu parent = this.featureInstaller.createMenusIfNecessary(menu, ancestors.split(File.separator.replace("\\", "\\\\")));
            JMenuItem menuItem = FeatureInstaller.installMnemonic((JMenuItem)new JMenuItem(shellName), (MenuElement)parent);
            final ActionListener listener = AbstractPlugIn.toActionListener((PlugIn)this, (WorkbenchContext)context.getWorkbenchContext(), (TaskMonitorManager)this.taskMonitorManager);
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e != null) {
                        BeanToolsPlugIn.this.lastcmd = file.getPath();
                    }
                    listener.actionPerformed(e);
                }
            });
            parent.add(menuItem);
        }
    }

    public String getName() {
        return sName;
    }

    public boolean execute(PlugInContext context) throws Exception {
        ToolboxDialog toolbox = new ToolboxDialog(context.getWorkbenchContext());
        try {
            Interpreter interpreter = new Interpreter();
            interpreter.setClassLoader(toolbox.getContext().getWorkbench().getPlugInManager().getClassLoader());
            interpreter.set("wc", toolbox.getContext());
            interpreter.eval("setAccessibility(true)");
            interpreter.eval("import com.vividsolutions.jts.geom.*");
            interpreter.eval("import com.vividsolutions.jump.feature.*");
            interpreter.source(this.lastcmd);
        }
        catch (EvalError e) {
            toolbox.getContext().getErrorHandler().handleThrowable((Throwable)e);
        }
        return true;
    }
}

