/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.graph.polygongraph;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openjump.core.apitools.FeatureCollectionTools;
import org.openjump.core.geomutils.algorithm.GeometryConverter;
import org.openjump.core.graph.polygongraph.PolygonGraphEdge;
import org.openjump.core.graph.polygongraph.PolygonGraphNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonGraph {
    public ArrayList<PolygonGraphEdge> edges = new ArrayList();
    public ArrayList<PolygonGraphNode> nodes = new ArrayList();

    public PolygonGraph(Collection<Feature> polygonFeatures) {
        this.createPolygonGraphFrom(polygonFeatures, null);
    }

    public PolygonGraph(Collection<Feature> polygonFeatures, TaskMonitor monitor) {
        this.createPolygonGraphFrom(polygonFeatures, monitor);
    }

    public PolygonGraph(FeatureCollection polygonFeatures) {
        this.createPolygonGraphFrom(polygonFeatures.getFeatures(), null);
    }

    public void createPolygonGraphFrom(Collection<Feature> fc, TaskMonitor monitor) {
        Geometry geom;
        STRtree tree = new STRtree();
        for (Feature f : fc) {
            if (f.getGeometry() instanceof Polygon) {
                PolygonGraphNode node = new PolygonGraphNode(f);
                this.nodes.add(node);
                tree.insert(f.getGeometry().getEnvelopeInternal(), (Object)node);
                continue;
            }
            if (!(f.getGeometry() instanceof MultiPolygon)) continue;
            geom = f.getGeometry();
            ArrayList<Geometry> parts = GeometryConverter.explodeGeomsIfMultiG(geom);
            for (Geometry gpart : parts) {
                Feature fnew = FeatureCollectionTools.copyFeature(f);
                fnew.setGeometry(gpart);
                PolygonGraphNode node = new PolygonGraphNode(fnew);
                this.nodes.add(node);
                tree.insert(gpart.getEnvelopeInternal(), (Object)node);
            }
        }
        if (monitor != null && monitor.isCancelRequested()) {
            monitor.report("canceled 1");
            return;
        }
        for (PolygonGraphNode node : this.nodes) {
            geom = node.geometry;
            List candidates = tree.query(geom.getEnvelopeInternal());
            for (PolygonGraphNode ntemp : candidates) {
                if (ntemp.nodeId != node.nodeId && !node.hasConnection(ntemp) && !geom.disjoint(ntemp.geometry)) {
                    PolygonGraphEdge edge = new PolygonGraphEdge(node, ntemp);
                    node.edges.add(edge);
                    ntemp.edges.add(edge);
                    this.edges.add(edge);
                }
                if (monitor == null || !monitor.isCancelRequested()) continue;
                monitor.report("canceled 2");
                return;
            }
        }
    }

    public FeatureCollection getEdgesBetweenInterriorPoints() {
        FeatureDataset fc = new FeatureDataset(PolygonGraphEdge.getEdgeFeatureSchema());
        for (PolygonGraphEdge edge : this.edges) {
            fc.add(edge.getEdgeBetweenInterriorPointsAsFeature());
        }
        return fc;
    }

    public FeatureCollection getNodesAsInterriorPoint() {
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("Geometry", AttributeType.GEOMETRY);
        fs.addAttribute("nodeId", AttributeType.INTEGER);
        fs.addAttribute("featureId", AttributeType.INTEGER);
        FeatureDataset fc = new FeatureDataset(fs);
        for (PolygonGraphNode node : this.nodes) {
            BasicFeature f = new BasicFeature(fs);
            f.setAttribute("nodeId", (Object)node.nodeId);
            f.setAttribute("featureId", (Object)node.realWorldObject.getID());
            f.setGeometry((Geometry)node.geometry.getInteriorPoint());
            fc.add(f);
        }
        return fc;
    }

    public FeatureCollection getSharedBoundaries() {
        FeatureDataset fc = new FeatureDataset(PolygonGraphNode.getBoundaryFeatureSchema());
        for (PolygonGraphEdge tedge : this.edges) {
            ArrayList<Feature> edgeBoundaries = tedge.getBoundariesAsFeature();
            for (Feature f : edgeBoundaries) {
                f.setAttribute("edgeType", (Object)"shared");
            }
            fc.addAll(edgeBoundaries);
        }
        return fc;
    }

    public FeatureCollection getNonSharedBoundaries() {
        FeatureDataset fc = new FeatureDataset(PolygonGraphNode.getBoundaryFeatureSchema());
        for (PolygonGraphNode tnode : this.nodes) {
            ArrayList<Feature> nonSharedBoundaries = tnode.getNonSharedBoundariesAsFeature();
            for (Feature f : nonSharedBoundaries) {
                f.setAttribute("edgeType", (Object)"nonshared");
            }
            fc.addAll(nonSharedBoundaries);
        }
        return fc;
    }

    public FeatureCollection getCommonBoundaries(PolygonGraphNode node) {
        ArrayList<Feature> boundaries = node.retrieveSharedBoundaries();
        FeatureDataset fc = new FeatureDataset(PolygonGraphNode.getBoundaryFeatureSchema());
        fc.addAll(boundaries);
        return fc;
    }
}

