/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.attributeoperations;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jump.feature.Feature;
import java.util.ArrayList;
import java.util.List;

public class SpatialRelationOp {
    public static final int CONTAINS = 0;
    public static final int INTERSECTS = 1;
    public static final int COVEREDBY = 2;

    public static String getName(int spatialRel) {
        String retval = "";
        if (spatialRel == 0) {
            retval = "contains";
        } else if (spatialRel == 1) {
            retval = "intersects";
        }
        return retval;
    }

    public static List evaluateSpatial(int spatialRelation, Quadtree featureTree, Geometry g, double radius) {
        ArrayList<Feature> foundItems = new ArrayList<Feature>();
        if (spatialRelation == 0) {
            Geometry buffer = g.buffer(radius);
            List candidates = featureTree.query(buffer.getEnvelopeInternal());
            if (g instanceof Point) {
                radius = 10.0;
                Geometry buffer2 = g.buffer(radius);
                candidates = featureTree.query(buffer2.getEnvelopeInternal());
            }
            for (Feature candidate : candidates) {
                boolean retval = buffer.contains((Geometry)candidate.getGeometry().getCentroid());
                if (!retval) continue;
                foundItems.add(candidate);
            }
        } else if (spatialRelation == 1) {
            Geometry buffer = g.buffer(radius);
            List candidates = featureTree.query(buffer.getEnvelopeInternal());
            if (g instanceof Point) {
                radius = 10.0;
                Geometry buffer2 = g.buffer(radius);
                candidates = featureTree.query(buffer2.getEnvelopeInternal());
                buffer = g;
            }
            for (Feature candidate : candidates) {
                Geometry geom = buffer.intersection(candidate.getGeometry());
                if (!(geom.getArea() > 0.0)) continue;
                foundItems.add(candidate);
            }
        } else if (spatialRelation == 2) {
            Geometry buffer = g.buffer(radius);
            List candidates = featureTree.query(buffer.getEnvelopeInternal());
            if (g instanceof Point) {
                radius = 10.0;
                Geometry buffer2 = g.buffer(radius);
                candidates = featureTree.query(buffer2.getEnvelopeInternal());
                buffer = g;
            }
            for (Feature candidate : candidates) {
                if (!buffer.coveredBy(candidate.getGeometry())) continue;
                foundItems.add(candidate);
            }
        } else {
            System.out.println("SpatialRelationOp: spatial relation does not exit");
        }
        return foundItems;
    }
}

