/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.qa;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.qa.diff.DiffSegments;
import com.vividsolutions.jump.qa.diff.DiffSegmentsWithTolerance;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleUtil;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DiffSegmentsPlugIn
extends ThreadedBasePlugIn {
    private String sLayer = I18N.get("jump.plugin.qa.DiffGeometryPlugIn.Layer");
    private String LAYER1 = this.sLayer + " 1";
    private String LAYER2 = this.sLayer + " 2";
    private String USE_TOLERANCE = I18N.get("jump.plugin.qa.DiffSegmentsPlugIn.Use-Distance-Tolerance");
    private String DISTANCE_TOL = I18N.get("jump.plugin.qa.DiffGeometryPlugIn.Distance-Tolerance");
    private String sSegmentDiffs = I18N.get("jump.plugin.qa.DiffGeometryPlugIn.Segment-Diffs");
    private String sUnmSegm = I18N.get("jump.plugin.qa.DiffSegmentsPlugIn.Unmatched-Segments-in-Layer");
    private Layer layer1;
    private Layer layer2;
    private boolean useTolerance = false;
    private double distanceTolerance = 0.0;

    public String getName() {
        return I18N.get("jump.plugin.qa.DiffSegmentsPlugIn.Calculate-Segment-Differences");
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.sLayer = I18N.get("jump.plugin.qa.DiffGeometryPlugIn.Layer");
        this.LAYER1 = this.sLayer + " 1";
        this.LAYER2 = this.sLayer + " 2";
        this.USE_TOLERANCE = I18N.get("jump.plugin.qa.DiffSegmentsPlugIn.Use-Distance-Tolerance");
        this.DISTANCE_TOL = I18N.get("jump.plugin.qa.DiffGeometryPlugIn.Distance-Tolerance");
        this.sSegmentDiffs = I18N.get("jump.plugin.qa.DiffGeometryPlugIn.Segment-Diffs");
        this.sUnmSegm = I18N.get("jump.plugin.qa.DiffSegmentsPlugIn.Unmatched-Segments-in-Layer");
        MultiInputDialog dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), I18N.get("jump.plugin.qa.DiffSegmentsPlugIn.Diff-Segments"), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow((Component)dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureCollection[] diffFC;
        if (!this.useTolerance) {
            DiffSegments diff = new DiffSegments(monitor);
            diff.setSegments(0, this.layer1.getFeatureCollectionWrapper());
            diff.setSegments(1, this.layer2.getFeatureCollectionWrapper());
            diffFC = new FeatureCollection[]{diff.computeDiffEdges(0), diff.computeDiffEdges(1)};
        } else {
            DiffSegmentsWithTolerance diff = new DiffSegmentsWithTolerance(this.layer1.getFeatureCollectionWrapper(), this.layer2.getFeatureCollectionWrapper(), this.distanceTolerance);
            diffFC = diff.diff();
        }
        this.createLayers(context, diffFC);
        this.createOutput(context, diffFC);
    }

    private void createLayers(PlugInContext context, FeatureCollection[] diffFC) {
        Layer lyr = context.addLayer(StandardCategoryNames.QA, this.sSegmentDiffs + " - " + this.layer1.getName(), diffFC[0]);
        LayerStyleUtil.setLinearStyle((Layer)lyr, (Color)Color.red, (int)2, (int)4);
        lyr.fireAppearanceChanged();
        Layer lyr2 = context.addLayer(StandardCategoryNames.QA, this.sSegmentDiffs + " - " + this.layer2.getName(), diffFC[1]);
        LayerStyleUtil.setLinearStyle((Layer)lyr2, (Color)Color.blue, (int)2, (int)4);
        lyr2.fireAppearanceChanged();
    }

    private void createOutput(PlugInContext context, FeatureCollection[] diffFC) {
        context.getOutputFrame().createNewDocument();
        context.getOutputFrame().addHeader(1, I18N.get("jump.plugin.qa.DiffSegmentsPlugIn.Diff-Segments"));
        context.getOutputFrame().addField(this.sLayer + " 1: ", this.layer1.getName());
        context.getOutputFrame().addField(this.sLayer + " 2: ", this.layer2.getName());
        context.getOutputFrame().addText(" ");
        if (this.useTolerance) {
            context.getOutputFrame().addField(this.DISTANCE_TOL + ": ", "" + this.distanceTolerance);
        }
        context.getOutputFrame().addField("# " + this.sUnmSegm + " 1: ", "" + diffFC[0].size());
        context.getOutputFrame().addField("# " + this.sUnmSegm + " 2: ", "" + diffFC[1].size());
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarImage((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("DiffSegments.png")));
        dialog.setSideBarDescription(I18N.get("jump.plugin.qa.DiffSegmentsPlugIn.Finds-line-segments-which-occur-in-Layer-1-or-Layer-2-but-not-both"));
        dialog.addLayerComboBox(this.LAYER1, context.getLayerManager().getLayer(0), context.getLayerManager());
        dialog.addLayerComboBox(this.LAYER2, context.getLayerManager().getLayer(1), context.getLayerManager());
        dialog.addCheckBox(this.USE_TOLERANCE, this.useTolerance, I18N.get("jump.plugin.qa.DiffSegmentsPlugIn.Match-segments-if-all-points-are-within-a-Distance-Tolerance"));
        dialog.addDoubleField(this.DISTANCE_TOL, this.distanceTolerance, 8, I18N.get("jump.plugin.qa.DiffSegmentsPlugIn.The-Distance-Tolerance-specifies-how-close-segments-must-be-to-match"));
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer1 = dialog.getLayer(this.LAYER1);
        this.layer2 = dialog.getLayer(this.LAYER2);
        this.useTolerance = dialog.getBoolean(this.USE_TOLERANCE);
        this.distanceTolerance = dialog.getDouble(this.DISTANCE_TOL);
    }
}

