/*
 * Decompiled with CFR 0.152.
 */
package com.foo;

import com.foobar.Utils;
import java.text.DecimalFormatSymbols;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class DecimalFormatSymbolsProviderImpl
extends DecimalFormatSymbolsProvider {
    static Locale[] avail = new Locale[]{new Locale("ja", "JP", "osaka"), new Locale("ja", "JP", "kyoto"), Locale.JAPAN, new Locale("yy", "ZZ", "UUU")};
    static List<Locale> availList = Arrays.asList(avail);
    static String[] dialect = new String[]{"\u3084\u3002", "\u3069\u3059\u3002", "\u3067\u3059\u3002", "-yy-ZZ-UUU"};
    static HashMap<Locale, FooDecimalFormatSymbols> symbols = new HashMap(4);

    @Override
    public Locale[] getAvailableLocales() {
        return avail;
    }

    @Override
    public DecimalFormatSymbols getInstance(Locale locale) {
        if (!Utils.supportsLocale(availList, locale)) {
            throw new IllegalArgumentException("locale is not supported: " + locale);
        }
        FooDecimalFormatSymbols fooDecimalFormatSymbols = symbols.get(locale);
        if (fooDecimalFormatSymbols == null) {
            for (int i = 0; i < avail.length; ++i) {
                if (!Utils.supportsLocale(avail[i], locale)) continue;
                fooDecimalFormatSymbols = new FooDecimalFormatSymbols(i);
                symbols.put(locale, fooDecimalFormatSymbols);
                break;
            }
        }
        return fooDecimalFormatSymbols;
    }

    class FooDecimalFormatSymbols
    extends DecimalFormatSymbols {
        String dialect;
        String infinity;
        String nan;

        public FooDecimalFormatSymbols(int n) {
            super(avail[n]);
            this.dialect = "";
            this.infinity = null;
            this.nan = null;
            this.dialect = dialect[n];
        }

        @Override
        public String getInfinity() {
            if (this.infinity == null) {
                this.infinity = super.getInfinity() + this.dialect;
            }
            return this.infinity;
        }

        @Override
        public void setInfinity(String string) {
            this.infinity = string;
        }

        @Override
        public String getNaN() {
            if (this.nan == null) {
                this.nan = super.getNaN() + this.dialect;
            }
            return this.nan;
        }

        @Override
        public void setNaN(String string) {
            this.nan = string;
        }
    }
}

