
/*
 * Copyright 2003-2006 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/*
 */


import java.nio.CharBuffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.*;

public class IBM949_OLD
    extends Charset
    implements HistoricallyNamedCharset
{

    public IBM949_OLD() {
        super("x-IBM949-Old", null);
    }

    public String historicalName() {
        return "Cp949";
    }

    public boolean contains(Charset cs) {
        return (cs instanceof IBM949);
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }


    /**
     * These accessors are temporarily supplied while sun.io
     * converters co-exist with the sun.nio.cs.{ext} charset coders
     * These facilitate sharing of conversion tables between the
     * two co-existing implementations. When sun.io converters
     * are made extinct these will be unncessary and should be removed
     */

    public String getDecoderSingleByteMappings() {
        return Decoder.singleByteToChar;

    }

    public short[] getDecoderIndex1() {
        return Decoder.index1;
    }

    public String getDecoderIndex2() {
        return Decoder.index2;

    }

    public short[] getEncoderIndex1() {
        return Encoder.index1;

    }
    public String getEncoderIndex2() {
        return Encoder.index2;

    }
    public String getEncoderIndex2a() {
        return Encoder.index2a;

    }

    protected static class Decoder extends DBCS_IBM_ASCII_Decoder {

        private void initLookupTables() {
                super.mask1 = 0xFFE0;
                super.mask2 = 0x001F;
                super.shift = 5;
                super.leadByte = this.leadByte;
                super.index1 = this.index1;
                super.index2 = this.index2;
        }
        public Decoder(Charset cs) {
                super(cs);
                initLookupTables();
                super.singleByteToChar = this.singleByteToChar;
        }
        protected Decoder(Charset cs, String singleByteToChar) {
                super(cs);
                initLookupTables();
                super.singleByteToChar = singleByteToChar;
        }

        private static final boolean leadByte[] = {
                false, false, false, false, false, false, false, false,  // 00 - 07
                false, false, false, false, false, false, false, false,  // 08 - 0F
                false, false, false, false, false, false, false, false,  // 10 - 17
                false, false, false, false, false, false, false, false,  // 18 - 1F
                false, false, false, false, false, false, false, false,  // 20 - 27
                false, false, false, false, false, false, false, false,  // 28 - 2F
                false, false, false, false, false, false, false, false,  // 30 - 37
                false, false, false, false, false, false, false, false,  // 38 - 3F
                false, false, false, false, false, false, false, false,  // 40 - 47
                false, false, false, false, false, false, false, false,  // 48 - 4F
                false, false, false, false, false, false, false, false,  // 50 - 57
                false, false, false, false, false, false, false, false,  // 58 - 5F
                false, false, false, false, false, false, false, false,  // 60 - 67
                false, false, false, false, false, false, false, false,  // 68 - 6F
                false, false, false, false, false, false, false, false,  // 70 - 77
                false, false, false, false, false, false, false, false,  // 78 - 7F
                false, false, false, false, false, false, false, false,  // 80 - 87
                false, false, false, false, false, false, false, true,   // 88 - 8F
                true,  true,  true,  true,  true,  true,  true,  true,   // 90 - 97
                true,  true,  true,  true,  true,  true,  true,  true,   // 98 - 9F
                true,  true,  true,  true,  true,  true,  true,  true,   // A0 - A7
                true,  true,  true,  true,  true,  false, false, false,  // A8 - AF
                true,  true,  true,  true,  true,  true,  true,  true,   // B0 - B7
                true,  true,  true,  true,  true,  true,  true,  true,   // B8 - BF
                true,  true,  true,  true,  true,  true,  true,  true,   // C0 - C7
                true,  true,  true,  true,  true,  true,  true,  true,   // C8 - CF
                true,  true,  true,  true,  true,  true,  true,  true,   // D0 - D7
                true,  true,  true,  true,  true,  true,  true,  true,   // D8 - DF
                true,  true,  true,  true,  true,  true,  true,  true,   // E0 - E7
                true,  true,  true,  true,  true,  true,  true,  true,   // E8 - EF
                true,  true,  true,  true,  true,  true,  true,  true,   // F0 - F7
                true,  true,  true,  true,  true,  true,  true,  false,  // F8 - FF
        };


        protected static final String singleByteToChar =
                "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007" +
                "\u0008\u0009\n\u000B\u000C\r\u000E\u000F" +
                "\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017" +
                "\u0018\u0019\u001A\u001B\u001C\u001D\u001E\u001F" +
                "\u0020\u0021\"\u0023\u0024\u0025\u0026\u0027" +
                "\u0028\u0029\u002A\u002B\u002C\u002D\u002E\u002F" +
                "\u0030\u0031\u0032\u0033\u0034\u0035\u0036\u0037" +
                "\u0038\u0039\u003A\u003B\u003C\u003D\u003E\u003F" +
                "\u0040\u0041\u0042\u0043\u0044\u0045\u0046\u0047" +
                "\u0048\u0049\u004A\u004B\u004C\u004D\u004E\u004F" +
                "\u0050\u0051\u0052\u0053\u0054\u0055\u0056\u0057" +
                "\u0058\u0059\u005A\u005B\u20A9\u005D\u005E\u005F" +
                "\u0060\u0061\u0062\u0063\u0064\u0065\u0066\u0067" +
                "\u0068\u0069\u006A\u006B\u006C\u006D\u006E\u006F" +
                "\u0070\u0071\u0072\u0073\u0074\u0075\u0076\u0077" +
                "\u0078\u0079\u007A\u007B\u007C\u007D\u007E\u007F" +
                "\u00A2\u00AC\\\u203E\u00A6\uFFFD\uFFFD\uFFFD" +
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" +
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" +
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" +
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" +
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" +
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" +
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" +
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" +
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" +
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" +
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" +
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" +
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" +
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" +
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD"
                ;
        private static short index1[] =
        {
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 0000 - 00FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 0100 - 01FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 0200 - 02FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 0300 - 03FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 0400 - 04FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 0500 - 05FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 0600 - 06FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 0700 - 07FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 0800 - 08FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 0900 - 09FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 0A00 - 0AFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 0B00 - 0BFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 0C00 - 0CFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 0D00 - 0DFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 0E00 - 0EFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 0F00 - 0FFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 1000 - 10FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 1100 - 11FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 1200 - 12FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 1300 - 13FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 1400 - 14FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 1500 - 15FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 1600 - 16FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 1700 - 17FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 1800 - 18FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 1900 - 19FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 1A00 - 1AFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 1B00 - 1BFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 1C00 - 1CFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 1D00 - 1DFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 1E00 - 1EFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 1F00 - 1FFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 2000 - 20FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 2100 - 21FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 2200 - 22FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 2300 - 23FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 2400 - 24FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 2500 - 25FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 2600 - 26FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 2700 - 27FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 2800 - 28FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 2900 - 29FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 2A00 - 2AFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 2B00 - 2BFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 2C00 - 2CFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 2D00 - 2DFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 2E00 - 2EFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 2F00 - 2FFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 3000 - 30FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 3100 - 31FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 3200 - 32FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 3300 - 33FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 3400 - 34FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 3500 - 35FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 3600 - 36FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 3700 - 37FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 3800 - 38FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 3900 - 39FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 3A00 - 3AFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 3B00 - 3BFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 3C00 - 3CFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 3D00 - 3DFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 3E00 - 3EFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 3F00 - 3FFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 4000 - 40FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 4100 - 41FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 4200 - 42FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 4300 - 43FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 4400 - 44FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 4500 - 45FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 4600 - 46FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 4700 - 47FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 4800 - 48FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 4900 - 49FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 4A00 - 4AFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 4B00 - 4BFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 4C00 - 4CFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 4D00 - 4DFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 4E00 - 4EFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 4F00 - 4FFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 5000 - 50FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 5100 - 51FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 5200 - 52FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 5300 - 53FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 5400 - 54FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 5500 - 55FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 5600 - 56FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 5700 - 57FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 5800 - 58FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 5900 - 59FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 5A00 - 5AFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 5B00 - 5BFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 5C00 - 5CFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 5D00 - 5DFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 5E00 - 5EFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 5F00 - 5FFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 6000 - 60FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 6100 - 61FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 6200 - 62FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 6300 - 63FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 6400 - 64FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 6500 - 65FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 6600 - 66FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 6700 - 67FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 6800 - 68FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 6900 - 69FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 6A00 - 6AFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 6B00 - 6BFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 6C00 - 6CFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 6D00 - 6DFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 6E00 - 6EFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 6F00 - 6FFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 7000 - 70FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 7100 - 71FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 7200 - 72FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 7300 - 73FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 7400 - 74FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 7500 - 75FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 7600 - 76FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 7700 - 77FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 7800 - 78FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 7900 - 79FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 7A00 - 7AFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 7B00 - 7BFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 7C00 - 7CFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 7D00 - 7DFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 7E00 - 7EFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 7F00 - 7FFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 8000 - 80FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 8100 - 81FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 8200 - 82FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 8300 - 83FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 8400 - 84FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 8500 - 85FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 8600 - 86FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 8700 - 87FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 8800 - 88FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 8900 - 89FF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 8A00 - 8AFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 8B00 - 8BFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 8C00 - 8CFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 8D00 - 8DFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // 8E00 - 8EFF
                 8080,  8080,  8080,  8080,  8080,  8111, 10326, 10263, // 8F00 - 8FFF
                 8080,  8080,  8080,  8080,  8080,  8396, 10231, 10168, // 9000 - 90FF
                 8080,  8080,  8080,  8080,  8080,  8011, 10136, 10073, // 9100 - 91FF
                 8080,  8080,  8080,  8080,  8080,  7536, 10041,  9978, // 9200 - 92FF
                 8080,  8080,  8080,  8080,  8080,  7726,  9946,  9883, // 9300 - 93FF
                 8080,  8080,  8080,  8080,  8080,  7631,  9851,  9788, // 9400 - 94FF
                 8080,  8080,  8080,  8080,  8080,  8933,  9756,  9693, // 9500 - 95FF
                 8080,  8080,  8080,  8080,  8080,  8807,  9661,  9598, // 9600 - 96FF
                 8080,  8080,  8080,  8080,  8080,  9059,  9566,  9503, // 9700 - 97FF
                 8080,  8080,  8080,  8080,  8080, 10294,  9471,  9408, // 9800 - 98FF
                 8080,  8080,  8080,  8080,  8080, 10199,  9376,  9313, // 9900 - 99FF
                 8080,  8080,  8080,  8080,  8080, 10104,  9281,  9218, // 9A00 - 9AFF
                 8080,  8080,  8080,  8080,  8080, 10009,  9186,  9123, // 9B00 - 9BFF
                 8080,  8080,  8080,  8080,  8080,  9914,  9091,  8997, // 9C00 - 9CFF
                 8080,  8080,  8080,  8080,  8080,  9819,  8965,  8871, // 9D00 - 9DFF
                 8080,  8080,  8080,  8080,  8080,  9724,  8839,  8745, // 9E00 - 9EFF
                 8080,  8080,  8080,  8080,  8080,  9629,  8713,  8650, // 9F00 - 9FFF
                 8080,  8080,  8080,  8080,  8080,  9534,  8618,  8555, // A000 - A0FF
                 8080,  8080,  8080,  8080,  8080,  9439,  8523,  8460, // A100 - A1FF
                 8080,  8080,  8080,  8080,  8080,  9344,  8428,  8365, // A200 - A2FF
                 8080,  8080,  8080,  8080,  8080,  9249,  8333,  8270, // A300 - A3FF
                 8080,  8080,  8080,  8080,  8080,  9154,  8238,  8175, // A400 - A4FF
                 8080,  8080,  8080,  8080,  8080,  9028,  8902,  8776, // A500 - A5FF
                 8080,  8080,  8080,  8080,  8080,  8681,  8143,  8075, // A600 - A6FF
                 8080,  8080,  8080,  8080,  8080,  8586,  8043,  7980, // A700 - A7FF
                 8080,  8080,  8080,  8080,  8080,  8491,  7948,  7885, // A800 - A8FF
                 8080,  8080,  8080,  8080,  8080,  8301,  7853,  7790, // A900 - A9FF
                 8080,  8080,  8080,  8080,  8080,  8206,  7758,  7695, // AA00 - AAFF
                 8080,  8080,  8080,  8080,  8080,  7916,  7663,  7600, // AB00 - ABFF
                 8080,  8080,  8080,  8080,  8080,  7821,  7568,  7505, // AC00 - ACFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // AD00 - ADFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // AE00 - AEFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080, // AF00 - AFFF
                 8080,  8080,  8080,  8080,  8080,  7441,  7473,  7410, // B000 - B0FF
                 8080,  8080,  8080,  8080,  8080,  7346,  7378,  7315, // B100 - B1FF
                 8080,  8080,  8080,  8080,  8080,  7251,  7283,  7220, // B200 - B2FF
                 8080,  8080,  8080,  8080,  8080,  7156,  7188,  7125, // B300 - B3FF
                 8080,  8080,  8080,  8080,  8080,  7061,  7093,  7030, // B400 - B4FF
                 8080,  8080,  8080,  8080,  8080,  6966,  6998,  6935, // B500 - B5FF
                 8080,  8080,  8080,  8080,  8080,  6871,  6903,  6840, // B600 - B6FF
                 8080,  8080,  8080,  8080,  8080,  6776,  6808,  6745, // B700 - B7FF
                 8080,  8080,  8080,  8080,  8080,  6681,  6713,  6650, // B800 - B8FF
                 8080,  8080,  8080,  8080,  8080,  6586,  6618,  6555, // B900 - B9FF
                 8080,  8080,  8080,  8080,  8080,  6491,  6523,  6460, // BA00 - BAFF
                 8080,  8080,  8080,  8080,  8080,  6396,  6428,  6365, // BB00 - BBFF
                 8080,  8080,  8080,  8080,  8080,  6301,  6333,  6270, // BC00 - BCFF
                 8080,  8080,  8080,  8080,  8080,  6206,  6238,  6175, // BD00 - BDFF
                 8080,  8080,  8080,  8080,  8080,  6111,  6143,  6080, // BE00 - BEFF
                 8080,  8080,  8080,  8080,  8080,  6016,  6048,  5985, // BF00 - BFFF
                 8080,  8080,  8080,  8080,  8080,  5921,  5953,  5890, // C000 - C0FF
                 8080,  8080,  8080,  8080,  8080,  5826,  5858,  5795, // C100 - C1FF
                 8080,  8080,  8080,  8080,  8080,  5731,  5763,  5700, // C200 - C2FF
                 8080,  8080,  8080,  8080,  8080,  5636,  5668,  5605, // C300 - C3FF
                 8080,  8080,  8080,  8080,  8080,  5541,  5573,  5510, // C400 - C4FF
                 8080,  8080,  8080,  8080,  8080,  5446,  5478,  5415, // C500 - C5FF
                 8080,  8080,  8080,  8080,  8080,  5351,  5383,  5320, // C600 - C6FF
                 8080,  8080,  8080,  8080,  8080,  5256,  5288,  5225, // C700 - C7FF
                 8080,  8080,  8080,  8080,  8080,  5161,  5193,  5130, // C800 - C8FF
                 8080,  8080,  8080,  8080,  8080,  5066,  5098,  5035, // C900 - C9FF
                 8080,  8080,  8080,  8080,  8080,  4971,  5003,  4940, // CA00 - CAFF
                 8080,  8080,  8080,  8080,  8080,  4876,  4908,  4845, // CB00 - CBFF
                 8080,  8080,  8080,  8080,  8080,  4781,  4813,  4750, // CC00 - CCFF
                 8080,  8080,  8080,  8080,  8080,  4686,  4718,  4655, // CD00 - CDFF
                 8080,  8080,  8080,  8080,  8080,  4591,  4623,  4560, // CE00 - CEFF
                 8080,  8080,  8080,  8080,  8080,  4496,  4528,  4465, // CF00 - CFFF
                 8080,  8080,  8080,  8080,  8080,  4401,  4433,  4370, // D000 - D0FF
                 8080,  8080,  8080,  8080,  8080,  4306,  4338,  4275, // D100 - D1FF
                 8080,  8080,  8080,  8080,  8080,  4211,  4243,  4180, // D200 - D2FF
                 8080,  8080,  8080,  8080,  8080,  4116,  4148,  4085, // D300 - D3FF
                 8080,  8080,  8080,  8080,  8080,  4021,  4053,  3990, // D400 - D4FF
                 8080,  8080,  8080,  8080,  8080,  3926,  3958,  3895, // D500 - D5FF
                 8080,  8080,  8080,  8080,  8080,  3831,  3863,  3800, // D600 - D6FF
                 8080,  8080,  8080,  8080,  8080,  3736,  3768,  3705, // D700 - D7FF
                 8080,  8080,  8080,  8080,  8080,  3641,  3673,  3610, // D800 - D8FF
                 8080,  8080,  8080,  8080,  8080,  3546,  3578,  3515, // D900 - D9FF
                 8080,  8080,  8080,  8080,  8080,  3451,  3483,  3420, // DA00 - DAFF
                 8080,  8080,  8080,  8080,  8080,  3356,  3388,  3325, // DB00 - DBFF
                 8080,  8080,  8080,  8080,  8080,  3261,  3293,  3230, // DC00 - DCFF
                 8080,  8080,  8080,  8080,  8080,  3166,  3198,  3135, // DD00 - DDFF
                 8080,  8080,  8080,  8080,  8080,  3071,  3103,  3040, // DE00 - DEFF
                 8080,  8080,  8080,  8080,  8080,  2976,  3008,  2945, // DF00 - DFFF
                 8080,  8080,  8080,  8080,  8080,  2881,  2913,  2850, // E000 - E0FF
                 8080,  8080,  8080,  8080,  8080,  2786,  2818,  2755, // E100 - E1FF
                 8080,  8080,  8080,  8080,  8080,  2691,  2723,  2660, // E200 - E2FF
                 8080,  8080,  8080,  8080,  8080,  2596,  2628,  2565, // E300 - E3FF
                 8080,  8080,  8080,  8080,  8080,  2501,  2533,  2470, // E400 - E4FF
                 8080,  8080,  8080,  8080,  8080,  2406,  2438,  2375, // E500 - E5FF
                 8080,  8080,  8080,  8080,  8080,  2311,  2343,  2280, // E600 - E6FF
                 8080,  8080,  8080,  8080,  8080,  2216,  2248,  2185, // E700 - E7FF
                 8080,  8080,  8080,  8080,  8080,  2121,  2153,  2090, // E800 - E8FF
                 8080,  8080,  8080,  8080,  8080,  2026,  2058,  1995, // E900 - E9FF
                 8080,  8080,  8080,  8080,  8080,  1931,  1963,  1900, // EA00 - EAFF
                 8080,  8080,  8080,  8080,  8080,  1836,  1868,  1805, // EB00 - EBFF
                 8080,  8080,  8080,  8080,  8080,  1741,  1773,  1710, // EC00 - ECFF
                 8080,  8080,  8080,  8080,  8080,  1646,  1678,  1615, // ED00 - EDFF
                 8080,  8080,  8080,  8080,  8080,  1551,  1583,  1520, // EE00 - EEFF
                 8080,  8080,  8080,  8080,  8080,  1456,  1488,  1425, // EF00 - EFFF
                 8080,  8080,  8080,  8080,  8080,  1361,  1393,  1330, // F000 - F0FF
                 8080,  8080,  8080,  8080,  8080,  1266,  1298,  1235, // F100 - F1FF
                 8080,  8080,  8080,  8080,  8080,  1171,  1203,  1140, // F200 - F2FF
                 8080,  8080,  8080,  8080,  8080,  1076,  1108,  1045, // F300 - F3FF
                 8080,  8080,  8080,  8080,  8080,   981,  1013,   950, // F400 - F4FF
                 8080,  8080,  8080,  8080,  8080,   886,   918,   855, // F500 - F5FF
                 8080,  8080,  8080,  8080,  8080,   791,   823,   760, // F600 - F6FF
                 8080,  8080,  8080,  8080,  8080,   696,   728,   665, // F700 - F7FF
                 8080,  8080,  8080,  8080,  8080,   601,   633,   570, // F800 - F8FF
                 8080,  8080,  8080,  8080,  8080,   506,   538,   475, // F900 - F9FF
                 8080,  8080,  8080,  8080,  8080,   411,   443,   380, // FA00 - FAFF
                 8080,  8080,  8080,  8080,  8080,   316,   348,   285, // FB00 - FBFF
                 8080,  8080,  8080,  8080,  8080,   221,   253,   190, // FC00 - FCFF
                 8080,  8080,  8080,  8080,  8080,   126,   158,    95, // FD00 - FDFF
                 8080,  8080,  8080,  8080,  8080,    31,    63,     0, // FE00 - FEFF
                 8080,  8080,  8080,  8080,  8080,  8080,  8080,  8080,
        };

        private static String index2 =
                "\uE09D\uE09E\uE09F\uE0A0\uE0A1\uE0A2\uE0A3\uE0A4\uE0A5\uE0A6" + //     0 -     9
                "\uE0A7\uE0A8\uE0A9\uE0AA\uE0AB\uE0AC\uE0AD\uE0AE\uE0AF\uE0B0" + //    10 -    19
                "\uE0B1\uE0B2\uE0B3\uE0B4\uE0B5\uE0B6\uE0B7\uE0B8\uE0B9\uE0BA" + //    20 -    29
                "\uE0BB\uFFFD\uE05E\uE05F\uE060\uE061\uE062\uE063\uE064\uE065" + //    30 -    39
                "\uE066\uE067\uE068\uE069\uE06A\uE06B\uE06C\uE06D\uE06E\uE06F" + //    40 -    49
                "\uE070\uE071\uE072\uE073\uE074\uE075\uE076\uE077\uE078\uE079" + //    50 -    59
                "\uE07A\uE07B\uE07C\uE07D\uE07E\uE07F\uE080\uE081\uE082\uE083" + //    60 -    69
                "\uE084\uE085\uE086\uE087\uE088\uE089\uE08A\uE08B\uE08C\uE08D" + //    70 -    79
                "\uE08E\uE08F\uE090\uE091\uE092\uE093\uE094\uE095\uE096\uE097" + //    80 -    89
                "\uE098\uE099\uE09A\uE09B\uE09C\u7D07\u8A16\u6B20\u6B3D\u6B46" + //    90 -    99
                "\u5438\u6070\u6D3D\u7FD5\u8208\u50D6\u51DE\u559C\u566B\u56CD" + //   100 -   109
                "\u59EC\u5B09\u5E0C\u6199\u6198\u6231\u665E\u66E6\u7199\u71B9" + //   110 -   119
                "\u71BA\u72A7\u79A7\u7A00\u7FB2\u8A70\uFFFD\u723B\u80B4\u9175" + //   120 -   129
                "\u9A4D\u4FAF\u5019\u539A\u540E\u543C\u5589\u55C5\u5E3F\u5F8C" + //   130 -   139
                "\u673D\u7166\u73DD\u9005\u52DB\u52F3\u5864\u58CE\u7104\u718F" + //   140 -   149
                "\u71FB\u85B0\u8A13\u6688\u85A8\u55A7\u6684\u714A\u8431\u5349" + //   150 -   159
                "\u5599\u6BC1\u5F59\u5FBD\u63EE\u6689\u7147\u8AF1\u8F1D\u9EBE" + //   160 -   169
                "\u4F11\u643A\u70CB\u7566\u8667\u6064\u8B4E\u9DF8\u5147\u51F6" + //   170 -   179
                "\u5308\u6D36\u80F8\u9ED1\u6615\u6B23\u7098\u75D5\u5403\u5C79" + //   180 -   189
                "\u5F8A\u6062\u6094\u61F7\u6666\u6703\u6A9C\u6DEE\u6FAE\u7070" + //   190 -   199
                "\u736A\u7E6A\u81BE\u8334\u86D4\u8AA8\u8CC4\u5283\u7372\u5B96" + //   200 -   209
                "\u6A6B\u9404\u54EE\u5686\u5B5D\u6548\u6585\u66C9\u689F\u6D8D" + //   210 -   219
                "\u6DC6\uFFFD\u798D\u79BE\u82B1\u83EF\u8A71\u8B41\u8CA8\u9774" + //   220 -   229
                "\uFA0B\u64F4\u652B\u78BA\u78BB\u7A6B\u4E38\u559A\u5950\u5BA6" + //   230 -   239
                "\u5E7B\u60A3\u63DB\u6B61\u6665\u6853\u6E19\u7165\u74B0\u7D08" + //   240 -   249
                "\u9084\u9A69\u9C25\u6D3B\u6ED1\u733E\u8C41\u95CA\u51F0\u5E4C" + //   250 -   259
                "\u5FA8\u604D\u60F6\u6130\u614C\u6643\u6644\u69A5\u6CC1\u6E5F" + //   260 -   269
                "\u6EC9\u6F62\u714C\u749C\u7687\u7BC1\u7C27\u8352\u8757\u9051" + //   270 -   279
                "\u968D\u9EC3\u532F\u56DE\u5EFB\u93AC\u9800\u9865\u60D1\u6216" + //   280 -   289
                "\u9177\u5A5A\u660F\u6DF7\u6E3E\u743F\u9B42\u5FFD\u60DA\u7B0F" + //   290 -   299
                "\u54C4\u5F18\u6C5E\u6CD3\u6D2A\u70D8\u7D05\u8679\u8A0C\u9D3B" + //   300 -   309
                "\u5316\u548C\u5B05\u6A3A\u706B\u7575\uFFFD\u5F62\u6CC2\u6ECE" + //   310 -   319
                "\u7005\u7050\u70AF\u7192\u73E9\u7469\u834A\u87A2\u8861\u9008" + //   320 -   329
                "\u90A2\u93A3\u99A8\u516E\u5F57\u60E0\u6167\u66B3\u8559\u8E4A" + //   330 -   339
                "\u91AF\u978B\u4E4E\u4E92\u547C\u58D5\u58FA\u597D\u5CB5\u5F27" + //   340 -   349
                "\u6236\u6248\u660A\u6667\u6BEB\u6D69\u6DCF\u6E56\u6EF8\u6F94" + //   350 -   359
                "\u6FE0\u6FE9\u705D\u72D0\u7425\u745A\u74E0\u7693\u795C\u7CCA" + //   360 -   369
                "\u7E1E\u80E1\u82A6\u846B\u84BF\u864E\u865F\u8774\u8B77\u8C6A" + //   370 -   379
                "\u774D\u7D43\u7D62\u7E23\u8237\u8852\uFA0A\u8CE2\u9249\u986F" + //   380 -   389
                "\u5B51\u7A74\u8840\u9801\u5ACC\u4FE0\u5354\u593E\u5CFD\u633E" + //   390 -   399
                "\u6D79\u72F9\u8105\u8107\u83A2\u92CF\u9830\u4EA8\u5144\u5211" + //   400 -   409
                "\u578B\uFFFD\uFA08\uFA09\u9805\u4EA5\u5055\u54B3\u5793\u595A" + //   410 -   419
                "\u5B69\u5BB3\u61C8\u6977\u6D77\u7023\u87F9\u89E3\u8A72\u8AE7" + //   420 -   429
                "\u9082\u99ED\u9AB8\u52BE\u6838\u5016\u5E78\u674F\u8347\u884C" + //   430 -   439
                "\u4EAB\u5411\u56AE\u73E6\u9115\u97FF\u9909\u9957\u9999\u5653" + //   440 -   449
                "\u589F\u865B\u8A31\u61B2\u6AF6\u737B\u8ED2\u6B47\u96AA\u9A57" + //   450 -   459
                "\u5955\u7200\u8D6B\u9769\u4FD4\u5CF4\u5F26\u61F8\u665B\u6CEB" + //   460 -   469
                "\u70AB\u7384\u73B9\u73FE\u7729\u54B8\u5563\u558A\u6ABB\u6DB5" + //   470 -   479
                "\u7DD8\u8266\u929C\u9677\u9E79\u5408\u54C8\u76D2\u86E4\u95A4" + //   480 -   489
                "\u95D4\u965C\u4EA2\u4F09\u59EE\u5AE6\u5DF7\u6052\u6297\u676D" + //   490 -   499
                "\u6841\u6C86\u6E2F\u7F38\u809B\u822A\uFFFD\u54C1\u7A1F\u6953" + //   500 -   509
                "\u8AF7\u8C4A\u98A8\u99AE\u5F7C\u62AB\u75B2\u76AE\u88AB\u907F" + //   510 -   519
                "\u9642\u5339\u5F3C\u5FC5\u6CCC\u73CC\u7562\u758B\u7B46\u82FE" + //   520 -   529
                "\u999D\u4E4F\u903C\u4E0B\u4F55\u53A6\u590F\u5EC8\u6630\u6CB3" + //   530 -   539
                "\u7455\u8377\u8766\u8CC0\u9050\u971E\u9C15\u58D1\u5B78\u8650" + //   540 -   549
                "\u8B14\u9DB4\u5BD2\u6068\u608D\u65F1\u6C57\u6F22\u6FA3\u701A" + //   550 -   559
                "\u7F55\u7FF0\u9591\u9592\u9650\u97D3\u5272\u8F44\u51FD\u542B" + //   560 -   569
                "\u80DE\u812F\u82DE\u8461\u84B2\u888D\u8912\u900B\u92EA\u98FD" + //   570 -   579
                "\u9B91\u5E45\u66B4\u66DD\u7011\u7206\uFA07\u4FF5\u527D\u5F6A" + //   580 -   589
                "\u6153\u6753\u6A19\u6F02\u74E2\u7968\u8868\u8C79\u98C7\u98C4" + //   590 -   599
                "\u9A43\uFFFD\u962A\u516B\u53ED\u634C\u4F69\u5504\u6096\u6557" + //   600 -   609
                "\u6C9B\u6D7F\u724C\u72FD\u7A17\u8987\u8C9D\u5F6D\u6F8E\u70F9" + //   610 -   619
                "\u81A8\u610E\u4FBF\u504F\u6241\u7247\u7BC7\u7DE8\u7FE9\u904D" + //   620 -   629
                "\u97AD\u9A19\u8CB6\u576A\u5E73\u67B0\u840D\u8A55\u5420\u5B16" + //   630 -   639
                "\u5E63\u5EE2\u5F0A\u6583\u80BA\u853D\u9589\u965B\u4F48\u5305" + //   640 -   649
                "\u530D\u530F\u5486\u54FA\u5703\u5E03\u6016\u629B\u62B1\u6355" + //   650 -   659
                "\uFA06\u6CE1\u6D66\u75B1\u7832\u59AC\u6295\u900F\u9B2A\u615D" + //   660 -   669
                "\u7279\u95D6\u5761\u5A46\u5DF4\u628A\u64AD\u64FA\u6777\u6CE2" + //   670 -   679
                "\u6D3E\u722C\u7436\u7834\u7F77\u82AD\u8DDB\u9817\u5224\u5742" + //   680 -   689
                "\u677F\u7248\u74E3\u8CA9\u8FA6\u9211\uFFFD\u9438\u5451\u5606" + //   690 -   699
                "\u5766\u5F48\u619A\u6B4E\u7058\u70AD\u7DBB\u8A95\u596A\u812B" + //   700 -   709
                "\u63A2\u7708\u803D\u8CAA\u5854\u642D\u69BB\u5B95\u5E11\u6E6F" + //   710 -   719
                "\uFA03\u8569\u514C\u53F0\u592A\u6020\u614B\u6B86\u6C70\u6CF0" + //   720 -   729
                "\u7B1E\u80CE\u82D4\u8DC6\u90B0\u98B1\uFA04\u64C7\u6FA4\u6491" + //   730 -   739
                "\u6504\u514E\u5410\u571F\u8A0E\u615F\u6876\uFA05\u75DB\u7B52" + //   740 -   749
                "\u7D71\u901A\u5806\u69CC\u817F\u892A\u9000\u9839\u5078\u5957" + //   750 -   759
                "\u7A31\u5FEB\u4ED6\u54A4\u553E\u58AE\u59A5\u60F0\u6253\u62D6" + //   760 -   769
                "\u6736\u6955\u8235\u9640\u99B1\u99DD\u502C\u5353\u5544\u577C" + //   770 -   779
                "\uFA01\u6258\uFA02\u64E2\u666B\u67DD\u6FC1\u6FEF\u7422\u7438" + //   780 -   789
                "\u8A17\uFFFD\u8D05\u53D6\u5439\u5634\u5A36\u5C31\u708A\u7FE0" + //   790 -   799
                "\u805A\u8106\u81ED\u8DA3\u9189\u9A5F\u9DF2\u5074\u4EC4\u53A0" + //   800 -   809
                "\u60FB\u6E2C\u5C64\u4F88\u5024\u55E4\u5CD9\u5E5F\u6065\u6894" + //   810 -   819
                "\u6CBB\u6DC4\u71BE\u75D4\u75F4\u7661\u7A1A\u7A49\u7DC7\u7DFB" + //   820 -   829
                "\u7F6E\u81F4\u86A9\u8F1C\u96C9\u99B3\u9F52\u5247\u52C5\u98ED" + //   830 -   839
                "\u89AA\u4E03\u67D2\u6F06\u4FB5\u5BE2\u6795\u6C88\u6D78\u741B" + //   840 -   849
                "\u7827\u91DD\u937C\u87C4\u79E4\u939A\u96DB\u9A36\u9C0D\u4E11" + //   850 -   859
                "\u755C\u795D\u7AFA\u7B51\u7BC9\u7E2E\u84C4\u8E59\u8E74\u8EF8" + //   860 -   869
                "\u9010\u6625\u693F\u7443\u51FA\u672E\u9EDC\u5145\u5FE0\u6C96" + //   870 -   879
                "\u87F2\u885D\u8877\u60B4\u81B5\u8403\uFFFD\u6912\u695A\u6A35" + //   880 -   889
                "\u7092\u7126\u785D\u7901\u790E\u79D2\u7A0D\u8096\u8278\u82D5" + //   890 -   899
                "\u8349\u8549\u8C82\u8D85\u9162\u918B\u91AE\u4FC3\u56D1\u71ED" + //   900 -   909
                "\u77D7\u8700\u89F8\u5BF8\u5FD6\u6751\u90A8\u53E2\u585A\u5BF5" + //   910 -   919
                "\u60A4\u6181\u6460\u7E3D\u8070\u8525\u9283\u64AE\u50AC\u5D14" + //   920 -   929
                "\u6700\u589C\u62BD\u63A8\u690E\u6978\u6A1E\u6E6B\u76BA\u79CB" + //   930 -   939
                "\u82BB\u8429\u8ACF\u8DA8\u8FFD\u9112\u914B\u919C\u9310\u9318" + //   940 -   949
                "\u7252\u758A\u776B\u8ADC\u8CBC\u8F12\u5EF3\u6674\u6DF8\u807D" + //   950 -   959
                "\u83C1\u8ACB\u9751\u9BD6\uFA00\u5243\u66FF\u6D95\u6EEF\u7DE0" + //   960 -   969
                "\u8AE6\u902E\u905E\u9AD4\u521D\u527F\u54E8\u6194\u6284\u62DB" + //   970 -   979
                "\u68A2\uFFFD\u8CAC\u51C4\u59BB\u60BD\u8655\u501C\uF9FF\u5254" + //   980 -   989
                "\u5C3A\u617D\u621A\u62D3\u64F2\u65A5\u6ECC\u7620\u810A\u8E60" + //   990 -   999
                "\u965F\u96BB\u4EDF\u5343\u5598\u5929\u5DDD\u64C5\u6CC9\u6DFA" + //  1000 -  1009
                "\u7394\u7A7F\u821B\u85A6\u8CE4\u8E10\u9077\u91E7\u95E1\u9621" + //  1010 -  1019
                "\u97C6\u51F8\u54F2\u5586\u5FB9\u64A4\u6F88\u7DB4\u8F1F\u8F4D" + //  1020 -  1029
                "\u9435\u50C9\u5C16\u6CBE\u6DFB\u751B\u77BB\u7C3D\u7C64\u8A79" + //  1030 -  1039
                "\u8AC2\u581E\u59BE\u5E16\u6377\u5F70\u6134\u655E\u660C\u6636" + //  1040 -  1049
                "\u66A2\u69CD\u6EC4\u6F32\u7316\u7621\u7A93\u8139\u8259\u83D6" + //  1050 -  1059
                "\u84BC\u50B5\u57F0\u5BC0\u5BE8\u5F69\u63A1\u7826\u7DB5\u83DC" + //  1060 -  1069
                "\u8521\u91C7\u91F5\u518A\u67F5\u7B56\uFFFD\u93F6\u96C6\u5FB5" + //  1070 -  1079
                "\u61F2\u6F84\u4E14\u4F98\u501F\u53C9\u55DF\u5D6F\u5DEE\u6B21" + //  1080 -  1089
                "\u6B64\u78CB\u7B9A\uF9FE\u8E49\u8ECA\u906E\u6349\u643E\u7740" + //  1090 -  1099
                "\u7A84\u932F\u947F\u9F6A\u64B0\u6FAF\u71E6\u74A8\u74DA\u7AC4" + //  1100 -  1109
                "\u7C12\u7E82\u7CB2\u7E98\u8B9A\u8D0A\u947D\u9910\u994C\u5239" + //  1110 -  1119
                "\u5BDF\u64E6\u672D\u7D2E\u50ED\u53C3\u5879\u6158\u6159\u61FA" + //  1120 -  1129
                "\u65AC\u7AD9\u8B92\u8B96\u5009\u5021\u5275\u5531\u5A3C\u5EE0" + //  1130 -  1139
                "\u8A3A\u8CD1\u8EEB\u8FB0\u9032\u93AD\u9663\u9673\u9707\u4F84" + //  1140 -  1149
                "\u53F1\u59EA\u5AC9\u5E19\u684E\u74C6\u75BE\u79E9\u7A92\u81A3" + //  1150 -  1159
                "\u86ED\u8CEA\u8DCC\u8FED\u659F\u6715\uF9FD\u57F7\u6F57\u7DDD" + //  1160 -  1169
                "\u8F2F\uFFFD\u54AB\u5730\u5740\u5FD7\u6301\u6307\u646F\u652F" + //  1170 -  1179
                "\u65E8\u667A\u679D\u67B3\u6B62\u6C60\u6C9A\u6F2C\u77E5\u7825" + //  1180 -  1189
                "\u7949\u7957\u7D19\u80A2\u8102\u81F3\u829D\u82B7\u8718\u8A8C" + //  1190 -  1199
                "\uF9FC\u8D04\u8DBE\u9072\u76F4\u7A19\u7A37\u7E54\u8077\u5507" + //  1200 -  1209
                "\u55D4\u5875\u632F\u6422\u6649\u664B\u686D\u699B\u6B84\u6D25" + //  1210 -  1219
                "\u6EB1\u73CD\u7468\u74A1\u755B\u75B9\u76E1\u771E\u778B\u79E6" + //  1220 -  1229
                "\u7E09\u7E1D\u81FB\u852F\u8897\u710C\u756F\u7AE3\u8822\u9021" + //  1230 -  1239
                "\u9075\u96CB\u99FF\u8301\u4E2D\u4EF2\u8846\u91CD\u537D\u6ADB" + //  1240 -  1249
                "\u696B\u6C41\u847A\u589E\u618E\u66FE\u62EF\u70DD\u7511\u75C7" + //  1250 -  1259
                "\u7E52\u84B8\u8B49\u8D08\u4E4B\u53EA\uFFFD\u8E2A\u8E35\u937E" + //  1260 -  1269
                "\u9418\u4F50\u5750\u5DE6\u5EA7\u632B\u7F6A\u4E3B\u4F4F\u4F8F" + //  1270 -  1279
                "\u505A\u59DD\u80C4\u546A\u5468\u55FE\u594F\u5B99\u5DDE\u5EDA" + //  1280 -  1289
                "\u665D\u6731\u67F1\u682A\u6CE8\u6D32\u6E4A\u6F8D\u70B7\u73E0" + //  1290 -  1299
                "\u7587\u7C4C\u7D02\u7D2C\u7DA2\u821F\u86DB\u8A3B\u8A85\u8D70" + //  1300 -  1309
                "\u8E8A\u8F33\u9031\u914E\u9152\u9444\u99D0\u7AF9\u7CA5\u4FCA" + //  1310 -  1319
                "\u5101\u51C6\u57C8\u5BEF\u5CFB\u6659\u6A3D\u6D5A\u6E96\u6FEC" + //  1320 -  1329
                "\u8ABF\u8D99\u8E81\u9020\u906D\u91E3\u963B\u96D5\u9CE5\u65CF" + //  1330 -  1339
                "\u7C07\u8DB3\u93C3\u5B58\u5C0A\u5352\u62D9\u731D\u5027\u5B97" + //  1340 -  1349
                "\u5F9E\u60B0\u616B\u68D5\u6DD9\u742E\u7A2E\u7D42\u7D9C\u7E31" + //  1350 -  1359
                "\u816B\uFFFD\u975C\u9802\u9F0E\u5236\u5291\u557C\u5824\u5E1D" + //  1360 -  1369
                "\u5F1F\u608C\u63D0\u68AF\u6FDF\u796D\u7B2C\u81CD\u85BA\u88FD" + //  1370 -  1379
                "\u8AF8\u8E44\u918D\u9664\u969B\u973D\u984C\u9F4A\u4FCE\u5146" + //  1380 -  1389
                "\u51CB\u52A9\u5632\u5F14\u5F6B\u63AA\u64CD\u65E9\u6641\u66FA" + //  1390 -  1399
                "\u66F9\u671D\u689D\u68D7\u69FD\u6F15\u6F6E\u7167\u71E5\u722A" + //  1400 -  1409
                "\u74AA\u773A\u7956\u795A\u79DF\u7A20\u7A95\u7C97\u7CDF\u7D44" + //  1410 -  1419
                "\u7E70\u8087\u85FB\u86A4\u8A54\u6A89\u6B63\u6C40\u6DC0\u6DE8" + //  1420 -  1429
                "\u6E1F\u6E5E\u701E\u70A1\u738E\u73FD\u753A\u775B\u7887\u798E" + //  1430 -  1439
                "\u7A0B\u7A7D\u7CBE\u7D8E\u8247\u8A02\u8AEA\u8C9E\u912D\u914A" + //  1440 -  1449
                "\u91D8\u9266\u92CC\u9320\u9706\u9756\uFFFD\u714E\u7420\u7530" + //  1450 -  1459
                "\u7538\u7551\u7672\u7B4C\u7B8B\u7BAD\u7BC6\u7E8F\u8A6E\u8F3E" + //  1460 -  1469
                "\u8F49\u923F\u9293\u9322\u942B\u96FB\u985A\u986B\u991E\u5207" + //  1470 -  1479
                "\u622A\u6298\u6D59\u7664\u7ACA\u7BC0\u7D76\u5360\u5CBE\u5E97" + //  1480 -  1489
                "\u6F38\u70B9\u7C98\u9711\u9B8E\u9EDE\u63A5\u647A\u8776\u4E01" + //  1490 -  1499
                "\u4E95\u4EAD\u505C\u5075\u5448\u59C3\u5B9A\u5E40\u5EAD\u5EF7" + //  1500 -  1509
                "\u5F81\u60C5\u633A\u653F\u6574\u65CC\u6676\u6678\u67FE\u6968" + //  1510 -  1519
                "\u7E3E\u7FDF\u837B\u8B2B\u8CCA\u8D64\u8DE1\u8E5F\u8FEA\u8FF9" + //  1520 -  1529
                "\u9069\u93D1\u4F43\u4F7A\u50B3\u5168\u5178\u524D\u526A\u5861" + //  1530 -  1539
                "\u587C\u5960\u5C08\u5C55\u5EDB\u609B\u6230\u6813\u6BBF\u6C08" + //  1540 -  1549
                "\u6FB1\uFFFD\u969C\u518D\u54C9\u5728\u5BB0\u624D\u6750\u683D" + //  1550 -  1559
                "\u6893\u6E3D\u6ED3\u707D\u7E21\u88C1\u8CA1\u8F09\u9F4B\u9F4E" + //  1560 -  1569
                "\u722D\u7B8F\u8ACD\u931A\u4F47\u4F4E\u5132\u5480\u59D0\u5E95" + //  1570 -  1579
                "\u62B5\u6775\u696E\u6A17\u6CAE\u6E1A\u72D9\u732A\u75BD\u7BB8" + //  1580 -  1589
                "\u7D35\u82E7\u83F9\u8457\u85F7\u8A5B\u8CAF\u8E87\u9019\u90B8" + //  1590 -  1599
                "\u96CE\u9F5F\u52E3\u540A\u5AE1\u5BC2\u6458\u6575\u6EF4\u72C4" + //  1600 -  1609
                "\uF9FB\u7684\u7A4D\u7B1B\u7C4D\u58EF\u596C\u5C07\u5E33\u5E84" + //  1610 -  1619
                "\u5F35\u638C\u66B2\u6756\u6A1F\u6AA3\u6B0C\u6F3F\u7246\uF9FA" + //  1620 -  1629
                "\u7350\u748B\u7AE0\u7CA7\u8178\u81DF\u81E7\u838A\u846C\u8523" + //  1630 -  1639
                "\u8594\u85CF\u88DD\u8D13\u91AC\u9577\uFFFD\uF9F7\uF9F8\uF9F9" + //  1640 -  1649
                "\u4ECD\u5269\u5B55\u82BF\u4ED4\u523A\u54A8\u59C9\u59FF\u5B50" + //  1650 -  1659
                "\u5B57\u5B5C\u6063\u6148\u6ECB\u7099\u716E\u7386\u74F7\u75B5" + //  1660 -  1669
                "\u78C1\u7D2B\u8005\u81EA\u8328\u8517\u85C9\u8AEE\u8CC7\u96CC" + //  1670 -  1679
                "\u4F5C\u52FA\u56BC\u65AB\u6628\u707C\u70B8\u7235\u7DBD\u828D" + //  1680 -  1689
                "\u914C\u96C0\u9D72\u5B71\u68E7\u6B98\u6F7A\u76DE\u5C91\u66AB" + //  1690 -  1699
                "\u6F5B\u7BB4\u7C2A\u8836\u96DC\u4E08\u4ED7\u5320\u5834\u58BB" + //  1700 -  1709
                "\u8335\uF9F0\u8693\u8A8D\uF9F1\u976D\u9777\uF9F2\uF9F3\u4E00" + //  1710 -  1719
                "\u4F5A\u4F7E\u58F9\u65E5\u6EA2\u9038\u93B0\u99B9\u4EFB\u58EC" + //  1720 -  1729
                "\u598A\u59D9\u6041\uF9F4\uF9F5\u7A14\uF9F6\u834F\u8CC3\u5165" + //  1730 -  1739
                "\u5344\uFFFD\u8B70\u91AB\u4E8C\u4EE5\u4F0A\uF9DD\uF9DE\u5937" + //  1740 -  1749
                "\u59E8\uF9DF\u5DF2\u5F1B\u5F5B\u6021\uF9E0\uF9E1\uF9E2\uF9E3" + //  1750 -  1759
                "\u723E\u73E5\uF9E4\u7570\u75CD\uF9E5\u79FB\uF9E6\u800C\u8033" + //  1760 -  1769
                "\u8084\u82E1\u8351\uF9E7\uF9E8\u8CBD\u8CB3\u9087\uF9E9\uF9EA" + //  1770 -  1779
                "\u98F4\u990C\uF9EB\uF9EC\u7037\u76CA\u7FCA\u7FCC\u7FFC\u8B1A" + //  1780 -  1789
                "\u4EBA\u4EC1\u5203\u5370\uF9ED\u54BD\u56E0\u59FB\u5BC5\u5F15" + //  1790 -  1799
                "\u5FCD\u6E6E\uF9EE\uF9EF\u7D6A\u4E59\u541F\u6DEB\u852D\u9670" + //  1800 -  1809
                "\u97F3\u98EE\u63D6\u6CE3\u9091\u51DD\u61C9\u81BA\u9DF9\u4F9D" + //  1810 -  1819
                "\u501A\u5100\u5B9C\u610F\u61FF\u64EC\u6905\u6BC5\u7591\u77E3" + //  1820 -  1829
                "\u7FA9\u8264\u858F\u87FB\u8863\u8ABC\uFFFD\u6FE1\u7336\u7337" + //  1830 -  1839
                "\uF9CC\u745C\u7531\uF9CD\u7652\uF9CE\uF9CF\u7DAD\u81FE\u8438" + //  1840 -  1849
                "\u88D5\u8A98\u8ADB\u8AED\u8E30\u8E42\u904A\u903E\u907A\u9149" + //  1850 -  1859
                "\u91C9\u936E\uF9D0\uF9D1\u5809\uF9D2\u6BD3\u8089\u80B2\uF9D3" + //  1860 -  1869
                "\uF9D4\u5141\u596B\u5C39\uF9D5\uF9D6\u6F64\u73A7\u80E4\u8D07" + //  1870 -  1879
                "\uF9D7\u9217\u958F\uF9D8\uF9D9\uF9DA\uF9DB\u807F\u620E\u701C" + //  1880 -  1889
                "\u7D68\u878D\uF9DC\u57A0\u6069\u6147\u6BB7\u8ABE\u9280\u96B1" + //  1890 -  1899
                "\u9B4F\u4E73\u4F91\u5112\u516A\uF9C7\u552F\u55A9\u5B7A\u5BA5" + //  1900 -  1909
                "\u5E7C\u5E7D\u5EBE\u60A0\u60DF\u6108\u6109\u63C4\u6538\u6709" + //  1910 -  1919
                "\uF9C8\u67D4\u67DA\uF9C9\u6961\u6962\u6CB9\u6D27\uF9CA\u6E38" + //  1920 -  1929
                "\uF9CB\uFFFD\u904B\u9695\u96F2\u97FB\u851A\u9B31\u4E90\u718A" + //  1930 -  1939
                "\u96C4\u5143\u539F\u54E1\u5713\u5712\u57A3\u5A9B\u5AC4\u5BC3" + //  1940 -  1949
                "\u6028\u613F\u63F4\u6C85\u6D39\u6E72\u6E90\u7230\u733F\u7457" + //  1950 -  1959
                "\u82D1\u8881\u8F45\u9060\uF9C6\u9662\u9858\u9D1B\u6708\u8D8A" + //  1960 -  1969
                "\u925E\u4F4D\u5049\u50DE\u5371\u570D\u59D4\u5A01\u5C09\u6170" + //  1970 -  1979
                "\u6690\u6E2D\u7232\u744B\u7DEF\u80C3\u840E\u8466\u853F\u875F" + //  1980 -  1989
                "\u885B\u8918\u8B02\u9055\u97CB\u79B9\u7D06\u7FBD\u828B\u85D5" + //  1990 -  1999
                "\u865E\u8FC2\u9047\u90F5\u91EA\u9685\u96E8\u96E9\u52D6\u5F67" + //  2000 -  2009
                "\u65ED\u6631\u682F\u715C\u7A36\u90C1\u980A\u4E91\uF9C5\u6A52" + //  2010 -  2019
                "\u6B9E\u6F90\u7189\u8018\u82B8\u8553\uFFFD\u7A88\u7AAF\u7E47" + //  2020 -  2029
                "\u7E5E\u8000\u8170\uF9C2\u87EF\u8981\u8B20\u9059\uF9C3\u9080" + //  2030 -  2039
                "\u9952\u617E\u6B32\u6D74\u7E1F\u8925\u8FB1\u4FD1\u50AD\u5197" + //  2040 -  2049
                "\u52C7\u57C7\u5889\u5BB9\u5EB8\u6142\u6995\u6D8C\u6E67\u6EB6" + //  2050 -  2059
                "\u7194\u7462\u7528\u752C\u8073\u8338\u84C9\u8E0A\u9394\u93DE" + //  2060 -  2069
                "\uF9C4\u4E8E\u4F51\u5076\u512A\u53C8\u53CB\u53F3\u5B87\u5BD3" + //  2070 -  2079
                "\u5C24\u611A\u6182\u65F4\u725B\u7397\u7440\u76C2\u7950\u7991" + //  2080 -  2089
                "\u6B6A\u77EE\u5916\u5D6C\u5DCD\u7325\u754F\uF9BA\uF9BB\u50E5" + //  2090 -  2099
                "\u51F9\u582F\u592D\u5996\u59DA\u5BE5\uF9BC\uF9BD\u5DA2\u62D7" + //  2100 -  2109
                "\u6416\u6493\u64FE\uF9BE\u66DC\uF9BF\u6A48\uF9C0\u71FF\u7464" + //  2110 -  2119
                "\uF9C1\uFFFD\u70CF\u71AC\u7352\u7B7D\u8708\u8AA4\u9C32\u9F07" + //  2120 -  2129
                "\u5C4B\u6C83\u7344\u7389\u923A\u6EAB\u7465\u761F\u7A69\u7E15" + //  2130 -  2139
                "\u860A\u5140\u58C5\u64C1\u74EE\u7515\u7670\u7FC1\u9095\u96CD" + //  2140 -  2149
                "\u9954\u6E26\u74E6\u7AA9\u7AAA\u81E5\u86D9\u8778\u8A1B\u5A49" + //  2150 -  2159
                "\u5B8C\u5B9B\u68A1\u6900\u6D63\u73A9\u7413\u742C\u7897\u7DE9" + //  2160 -  2169
                "\u7FEB\u8118\u8155\u839E\u8C4C\u962E\u9811\u66F0\u5F80\u65FA" + //  2170 -  2179
                "\u6789\u6C6A\u738B\u502D\u5A03\u88D4\u8A63\u8B7D\u8C6B\uF9B7" + //  2180 -  2189
                "\u92B3\uF9B8\u9713\u9810\u4E94\u4F0D\u4FC9\u50B2\u5348\u543E" + //  2190 -  2199
                "\u5433\u55DA\u5862\u58BA\u5967\u5A1B\u5BE4\u609F\uF9B9\u61CA" + //  2200 -  2209
                "\u6556\u65FF\u6664\u68A7\u6C5A\u6FB3\uFFFD\uF9A6\u95BB\u9AE5" + //  2210 -  2219
                "\u9E7D\u66C4\uF9A7\u71C1\u8449\uF9A8\uF9A9\u584B\uF9AA\uF9AB" + //  2220 -  2229
                "\u5DB8\u5F71\uF9AC\u6620\u668E\u6979\u69AE\u6C38\u6CF3\u6E36" + //  2230 -  2239
                "\u6F41\u6FDA\u701B\u702F\u7150\u71DF\u7370\uF9AD\u745B\uF9AE" + //  2240 -  2249
                "\u74D4\u76C8\u7A4E\u7E93\uF9AF\uF9B0\u82F1\u8A60\u8FCE\uF9B1" + //  2250 -  2259
                "\u9348\uF9B2\u9719\uF9B3\uF9B4\u4E42\u502A\uF9B5\u5208\u53E1" + //  2260 -  2269
                "\u66F3\u6C6D\u6FCA\u730A\u777F\u7A62\u82AE\u85DD\u8602\uF9B6" + //  2270 -  2279
                "\u7E2F\uF997\u884D\u8EDF\uF998\uF999\uF99A\u925B\uF99B\u9CF6" + //  2280 -  2289
                "\uF99C\uF99D\uF99E\u6085\u6D85\uF99F\u71B1\uF9A0\uF9A1\u95B1" + //  2290 -  2299
                "\u53AD\uF9A2\uF9A3\uF9A4\u67D3\uF9A5\u708E\u7130\u7430\u8276" + //  2300 -  2309
                "\u82D2\uFFFD\uF983\u6B5F\u6C5D\uF984\u74B5\u7916\uF985\u8207" + //  2310 -  2319
                "\u8245\u8339\u8F3F\u8F5D\uF986\u9918\uF987\uF988\uF989\u4EA6" + //  2320 -  2329
                "\uF98A\u57DF\u5F79\u6613\uF98B\uF98C\u75AB\u7E79\u8B6F\uF98D" + //  2330 -  2339
                "\u9006\u9A5B\u56A5\u5827\u59F8\u5A1F\u5BB4\uF98E\u5EF6\uF98F" + //  2340 -  2349
                "\uF990\u6350\u633B\uF991\u693D\u6C87\u6CBF\u6D8E\u6D93\u6DF5" + //  2350 -  2359
                "\u6F14\uF992\u70DF\u7136\u7159\uF993\u71C3\u71D5\uF994\u784F" + //  2360 -  2369
                "\u786F\uF995\u7B75\u7DE3\uF996\u9B5A\u9F6C\u5104\u61B6\u6291" + //  2370 -  2379
                "\u6A8D\u81C6\u5043\u5830\u5F66\u7109\u8A00\u8AFA\u5B7C\u8616" + //  2380 -  2389
                "\u4FFA\u513C\u56B4\u5944\u63A9\u6DF9\u5DAA\u696D\u5186\u4E88" + //  2390 -  2399
                "\u4F59\uF97F\uF980\uF981\u5982\uF982\uFFFD\u6AFB\u7F4C\u9DAF" + //  2400 -  2409
                "\u9E1A\u4E5F\u503B\u51B6\u591C\u60F9\u63F6\u6930\u723A\u8036" + //  2410 -  2419
                "\uF974\u91CE\u5F31\uF975\uF976\u7D04\u82E5\u846F\u84BB\u85E5" + //  2420 -  2429
                "\u8E8D\uF977\u4F6F\uF978\uF979\u58E4\u5B43\u6059\u63DA\u6518" + //  2430 -  2439
                "\u656D\u6698\uF97A\u694A\u6A23\u6D0B\u7001\u716C\u75D2\u760D" + //  2440 -  2449
                "\u79B3\u7A70\uF97B\u7F8A\uF97C\u8944\uF97D\u8B93\u91C0\u967D" + //  2450 -  2459
                "\uF97E\u990A\u5704\u5FA1\u65BC\u6F01\u7600\u79A6\u8A9E\u99AD" + //  2460 -  2469
                "\u83F4\u95C7\u58D3\u62BC\u72CE\u9D28\u4EF0\u592E\u600F\u663B" + //  2470 -  2479
                "\u6B83\u79E7\u9D26\u5393\u54C0\u57C3\u5D16\u611B\u66D6\u6DAF" + //  2480 -  2489
                "\u788D\u827E\u9698\u9744\u5384\u627C\u6396\u6DB2\u7E0A\u814B" + //  2490 -  2499
                "\u984D\uFFFD\uF972\u6DF1\u700B\u751A\u82AF\u8AF6\u4EC0\u5341" + //  2500 -  2509
                "\uF973\u96D9\u6C0F\u4E9E\u4FC4\u5152\u555E\u5A25\u5CE8\u6211" + //  2510 -  2519
                "\u7259\u82BD\u83AA\u86FE\u8859\u8A1D\u963F\u96C5\u9913\u9D09" + //  2520 -  2529
                "\u9D5D\u580A\u5CB3\u5DBD\u5E44\u60E1\u6115\u63E1\u6A02\u6E25" + //  2530 -  2539
                "\u9102\u9354\u984E\u9C10\u9F77\u5B89\u5CB8\u6309\u664F\u6848" + //  2540 -  2549
                "\u773C\u96C1\u978D\u9854\u9B9F\u65A1\u8B01\u8ECB\u95BC\u5535" + //  2550 -  2559
                "\u5CA9\u5DD6\u5EB5\u6697\u764C\u4F81\u4FE1\u547B\u5A20\u5BB8" + //  2560 -  2569
                "\u613C\u65B0\u6668\u71FC\u7533\u795E\u7D33\u814E\u81E3\u8398" + //  2570 -  2579
                "\u85AA\u85CE\u8703\u8A0A\u8EAB\u8F9B\uF971\u8FC5\u5931\u5BA4" + //  2580 -  2589
                "\u5BE6\u6089\u5BE9\u5C0B\u5FC3\u6C81\uFFFD\u5D69\u745F\u819D" + //  2590 -  2599
                "\u8768\u6FD5\u62FE\u7FD2\u8936\u8972\u4E1E\u4E58\u50E7\u52DD" + //  2600 -  2609
                "\u5347\u627F\u6607\u7E69\u8805\u965E\u4F8D\u5319\u5636\u59CB" + //  2610 -  2619
                "\u5AA4\u5C38\u5C4E\u5C4D\u5E02\u5F11\u6043\u65BD\u662F\u6642" + //  2620 -  2629
                "\u67BE\u67F4\u731C\u77E2\u793A\u7FC5\u8494\u84CD\u8996\u8A66" + //  2630 -  2639
                "\u8A69\u8AE1\u8C55\u8C7A\u57F4\u5BD4\u5F0F\u606F\u62ED\u690D" + //  2640 -  2649
                "\u6B96\u6E5C\u7184\u7BD2\u8755\u8B58\u8EFE\u98DF\u98FE\u4F38" + //  2650 -  2659
                "\u5FAA\u6042\u65EC\u6812\u696F\u6A53\u6B89\u6D35\u6DF3\u73E3" + //  2660 -  2669
                "\u76FE\u77AC\u7B4D\u7D14\u8123\u821C\u8340\u84F4\u8563\u8A62" + //  2670 -  2679
                "\u8AC4\u9187\u931E\u9806\u99B4\u620C\u8853\u8FF0\u9265\u5D07" + //  2680 -  2689
                "\u5D27\uFFFD\u620D\u624B\u6388\u641C\u6536\u6578\u6A39\u6B8A" + //  2690 -  2699
                "\u6C34\u6D19\u6F31\u71E7\u72E9\u7378\u7407\u74B2\u7626\u7761" + //  2700 -  2709
                "\u79C0\u7A57\u7AEA\u7CB9\u7D8F\u7DAC\u7E61\u7F9E\u8129\u8331" + //  2710 -  2719
                "\u8490\u84DA\u85EA\u8896\u8AB0\u8B90\u8F38\u9042\u9083\u916C" + //  2720 -  2729
                "\u9296\u92B9\u968B\u96A7\u96A8\u96D6\u9700\u9808\u9996\u9AD3" + //  2730 -  2739
                "\u9B1A\u53D4\u587E\u5919\u5B70\u5BBF\u6DD1\u6F5A\u719F\u7421" + //  2740 -  2749
                "\u74B9\u8085\u83FD\u5DE1\u5F87\u84C0\u905C\u98E1\u7387\u5B8B" + //  2750 -  2759
                "\u609A\u677E\u6DDE\u8A1F\u8AA6\u9001\u980C\u5237\uF970\u7051" + //  2760 -  2769
                "\u788E\u9396\u8870\u91D7\u4FEE\u53D7\u55FD\u56DA\u5782\u58FD" + //  2770 -  2779
                "\u5AC2\u5B88\u5CAB\u5CC0\u5E25\u6101\uFFFD\u8056\u8072\u8165" + //  2780 -  2789
                "\u8AA0\u9192\u4E16\u52E2\u6B72\u6D17\u7A05\u7B39\u7D30\uF96F" + //  2790 -  2799
                "\u8CB0\u53EC\u562F\u5851\u5BB5\u5C0F\u5C11\u5DE2\u6240\u6383" + //  2800 -  2809
                "\u6414\u662D\u68B3\u6CBC\u6D88\u6EAF\u701F\u70A4\u71D2\u7526" + //  2810 -  2819
                "\u758F\u758E\u7619\u7B11\u7BE0\u7C2B\u7D20\u7D39\u852C\u856D" + //  2820 -  2829
                "\u8607\u8A34\u900D\u9061\u90B5\u92B7\u97F6\u9A37\u4FD7\u5C6C" + //  2830 -  2839
                "\u675F\u6D91\u7C9F\u7E8C\u8B16\u8D16\u901F\u5B6B\u5DFD\u640D" + //  2840 -  2849
                "\u859B\u893B\u8A2D\u8AAA\u96EA\u9F67\u5261\u66B9\u6BB2\u7E96" + //  2850 -  2859
                "\u87FE\u8D0D\u9583\u965D\u651D\u6D89\u71EE\uF96E\u57CE\u59D3" + //  2860 -  2869
                "\u5BAC\u6027\u60FA\u6210\u661F\u665F\u7329\u73F9\u76DB\u7701" + //  2870 -  2879
                "\u7B6C\uFFFD\u80E5\u8212\u85AF\u897F\u8A93\u901D\u92E4\u9ECD" + //  2880 -  2889
                "\u9F20\u5915\u596D\u5E2D\u60DC\u6614\u6673\u6790\u6C50\u6DC5" + //  2890 -  2899
                "\u6F5F\u77F3\u78A9\u84C6\u91CB\u932B\u4ED9\u50CA\u5148\u5584" + //  2900 -  2909
                "\u5B0B\u5BA3\u6247\u657E\u65CB\u6E32\u717D\u7401\u7444\u7487" + //  2910 -  2919
                "\u74BF\u766C\u79AA\u7DDA\u7E55\u7FA8\u817A\u81B3\u8239\u861A" + //  2920 -  2929
                "\u87EC\u8A75\u8DE3\u9078\u9291\u9425\u994D\u9BAE\u5368\u5C51" + //  2930 -  2939
                "\u6954\u6CC4\u6D29\u6E2B\u820C\u55C7\uF96C\u7A61\u7D22\u8272" + //  2940 -  2949
                "\u7272\u751F\u7525\uF96D\u7B19\u5885\u58FB\u5DBC\u5E8F\u5EB6" + //  2950 -  2959
                "\u5F90\u6055\u6292\u637F\u654D\u6691\u66D9\u66F8\u6816\u68F2" + //  2960 -  2969
                "\u7280\u745E\u7B6E\u7D6E\u7DD6\u7F72\uFFFD\u5098\u522A\u5C71" + //  2970 -  2979
                "\u6563\u6C55\u73CA\u7523\u759D\u7B97\u849C\u9178\u9730\u4E77" + //  2980 -  2989
                "\u6492\u6BBA\u715E\u85A9\u4E09\uF96B\u6749\u68EE\u6E17\u829F" + //  2990 -  2999
                "\u8518\u886B\u63F7\u6F81\u9212\u98AF\u4E0A\u50B7\u50CF\u511F" + //  3000 -  3009
                "\u5546\u55AA\u5617\u5B40\u5C19\u5CE0\u5E38\u5E8A\u5EA0\u5EC2" + //  3010 -  3019
                "\u60F3\u6851\u6A61\u6E58\u723D\u7240\u72C0\u76F8\u7965\u7BB1" + //  3020 -  3029
                "\u7FD4\u88F3\u89F4\u8A73\u8C61\u8CDE\u971C\u585E\u74BD\u8CFD" + //  3030 -  3039
                "\u6E23\u7009\u7345\u7802\u793E\u7940\u7960\u79C1\u7BE9\u7D17" + //  3040 -  3049
                "\u7D72\u8086\u820D\u838E\u84D1\u86C7\u88DF\u8A50\u8A5E\u8B1D" + //  3050 -  3059
                "\u8CDC\u8D66\u8FAD\u90AA\u98FC\u99DF\u9E9D\u524A\uF969\u6714" + //  3060 -  3069
                "\uF96A\uFFFD\u813E\u81C2\u83F2\u871A\u88E8\u8AB9\u8B6C\u8CBB" + //  3070 -  3079
                "\u9119\u975E\u98DB\u9F3B\u56AC\u5B2A\u5F6C\u658C\u6AB3\u6BAF" + //  3080 -  3089
                "\u6D5C\u6FF1\u7015\u725D\u73AD\u8CA7\u8CD3\u983B\u6191\u6C37" + //  3090 -  3099
                "\u8058\u9A01\u4E4D\u4E8B\u4E9B\u4ED5\u4F3A\u4F3C\u4F7F\u4FDF" + //  3100 -  3109
                "\u50FF\u53F2\u53F8\u5506\u55E3\u56DB\u58EB\u5962\u5A11\u5BEB" + //  3110 -  3119
                "\u5BFA\u5C04\u5DF3\u5E2B\u5F99\u601D\u6368\u659C\u65AF\u67F6" + //  3120 -  3129
                "\u67FB\u68AD\u6B7B\u6C99\u6CD7\u4E15\u5099\u5315\u532A\u5351" + //  3130 -  3139
                "\u5983\u5A62\u5E87\u60B2\u618A\u6249\u6279\u6590\u6787\u69A7" + //  3140 -  3149
                "\u6BD4\u6BD6\u6BD7\u6BD8\u6CB8\uF968\u7435\u75FA\u7812\u7891" + //  3150 -  3159
                "\u79D5\u79D8\u7C83\u7DCB\u7FE1\u80A5\uFFFD\u5B5A\u5B75\u5BCC" + //  3160 -  3169
                "\u5E9C\uF966\u6276\u6577\u65A7\u6D6E\u6EA5\u7236\u7B26\u7C3F" + //  3170 -  3179
                "\u7F36\u8150\u8151\u819A\u8240\u8299\u83A9\u8A03\u8CA0\u8CE6" + //  3180 -  3189
                "\u8CFB\u8D74\u8DBA\u90E8\u91DC\u961C\u9644\u99D9\u9CE7\u5317" + //  3190 -  3199
                "\u5206\u5429\u5674\u58B3\u5954\u596E\u5FFF\u61A4\u626E\u6610" + //  3200 -  3209
                "\u6C7E\u711A\u76C6\u7C89\u7CDE\u7D1B\u82AC\u8CC1\u96F0\uF967" + //  3210 -  3219
                "\u4F5B\u5F17\u5F7F\u62C2\u5D29\u670B\u68DA\u787C\u7E43\u9D6C" + //  3220 -  3229
                "\u99A5\u9C12\u672C\u4E76\u4FF8\u5949\u5C01\u5CEF\u5CF0\u6367" + //  3230 -  3239
                "\u68D2\u70FD\u71A2\u742B\u7E2B\u84EC\u8702\u9022\u92D2\u9CF3" + //  3240 -  3249
                "\u4E0D\u4ED8\u4FEF\u5085\u5256\u526F\u5426\u5490\u57E0\u592B" + //  3250 -  3259
                "\u5A66\uFFFD\u78A7\u8617\u95E2\u9739\uF965\u535E\u5F01\u8B8A" + //  3260 -  3269
                "\u8FA8\u8FAF\u908A\u5225\u77A5\u9C49\u9F08\u4E19\u5002\u5175" + //  3270 -  3279
                "\u5C5B\u5E77\u661E\u663A\u67C4\u68C5\u70B3\u7501\u75C5\u79C9" + //  3280 -  3289
                "\u7ADD\u8F27\u9920\u9A08\u4FDD\u5821\u5831\u5BF6\u666E\u6B65" + //  3290 -  3299
                "\u6D11\u6E7A\u6F7D\u73E4\u752B\u83E9\u88DC\u8913\u8B5C\u8F14" + //  3300 -  3309
                "\u4F0F\u50D5\u5310\u535C\u5B93\u5FA9\u670D\u798F\u8179\u832F" + //  3310 -  3319
                "\u8514\u8907\u8986\u8F39\u8F3B\u6A0A\u7169\u71D4\u756A\uF964" + //  3320 -  3329
                "\u7E41\u8543\u85E9\u98DC\u4F10\u7B4F\u7F70\u95A5\u51E1\u5E06" + //  3330 -  3339
                "\u68B5\u6C3E\u6C4E\u6CDB\u72AF\u7BC4\u8303\u6CD5\u743A\u50FB" + //  3340 -  3349
                "\u5288\u58C1\u64D8\u6A97\u74A7\u7656\uFFFD\u767C\u8DCB\u91B1" + //  3350 -  3359
                "\u9262\u9AEE\u9B43\u5023\u508D\u574A\u59A8\u5C28\u5E47\u5F77" + //  3360 -  3369
                "\u623F\u653E\u65B9\u65C1\u6609\u678B\u699C\u6EC2\u78C5\u7D21" + //  3370 -  3379
                "\u80AA\u8180\u822B\u82B3\u84A1\u868C\u8A2A\u8B17\u90A6\u9632" + //  3380 -  3389
                "\u9F90\u500D\u4FF3\uF963\u57F9\u5F98\u62DC\u6392\u676F\u6E43" + //  3390 -  3399
                "\u7119\u76C3\u80CC\u80DA\u88F4\u88F5\u8919\u8CE0\u8F29\u914D" + //  3400 -  3409
                "\u966A\u4F2F\u4F70\u5E1B\u67CF\u6822\u767D\u767E\u9B44\u5E61" + //  3410 -  3419
                "\u99C1\u4F34\u534A\u53CD\u53DB\u62CC\u642C\u6500\u6591\u69C3" + //  3420 -  3429
                "\u6CEE\u6F58\u73ED\u7554\u7622\u76E4\u76FC\u78D0\u78FB\u792C" + //  3430 -  3439
                "\u7D46\u822C\u87E0\u8FD4\u9812\u98EF\u52C3\u62D4\u64A5\u6E24" + //  3440 -  3449
                "\u6F51\uFFFD\u6C76\u7D0A\u7D0B\u805E\u868A\u9580\u96EF\u52FF" + //  3450 -  3459
                "\u6C95\u7269\u5473\u5A9A\u5C3E\u5D4B\u5F4C\u5FAE\u672A\u68B6" + //  3460 -  3469
                "\u6963\u6E3C\u6E44\u7709\u7C73\u7F8E\u8587\u8B0E\u8FF7\u9761" + //  3470 -  3479
                "\u9EF4\u5CB7\u60B6\u610D\u61AB\u654F\u65FB\u65FC\u6C11\u6CEF" + //  3480 -  3489
                "\u739F\u73C9\u7DE1\u9594\u5BC6\u871C\u8B10\u525D\u535A\u62CD" + //  3490 -  3499
                "\u640F\u64B2\u6734\u6A38\u6CCA\u73C0\u749E\u7B94\u7C95\u7E1B" + //  3500 -  3509
                "\u818A\u8236\u8584\u8FEB\u96F9\u82D7\u9328\u52D9\u5DEB\u61AE" + //  3510 -  3519
                "\u61CB\u620A\u62C7\u64AB\u65E0\u6959\u6B66\u6BCB\u7121\u73F7" + //  3520 -  3529
                "\u755D\u7E46\u821E\u8302\u856A\u8AA3\u8CBF\u9727\u9D61\u58A8" + //  3530 -  3539
                "\u9ED8\u5011\u520E\u543B\u554F\u6587\uFFFD\u8511\u51A5\u540D" + //  3540 -  3549
                "\u547D\u660E\u669D\u6927\u6E9F\u76BF\u7791\u8317\u84C2\u879F" + //  3550 -  3559
                "\u9169\u9298\u9CF4\u8882\u4FAE\u5192\u52DF\u59C6\u5E3D\u6155" + //  3560 -  3569
                "\u6478\u6479\u66AE\u67D0\u6A21\u6BCD\u6BDB\u725F\u7261\u7441" + //  3570 -  3579
                "\u7738\u77DB\u8017\u82BC\u8305\u8B00\u8B28\u8C8C\u6728\u6C90" + //  3580 -  3589
                "\u7267\u76EE\u7766\u7A46\u9DA9\u6B7F\u6C92\u5922\u6726\u8499" + //  3590 -  3599
                "\u536F\u5893\u5999\u5EDF\u63CF\u6634\u6773\u6E3A\u732B\u7AD7" + //  3600 -  3609
                "\u7164\u7F75\u8CB7\u8CE3\u9081\u9B45\u8108\u8C8A\u964C\u9A40" + //  3610 -  3619
                "\u9EA5\u5B5F\u6C13\u731B\u76F2\u76DF\u840C\u51AA\u8993\u514D" + //  3620 -  3629
                "\u5195\u52C9\u68C9\u6C94\u7704\u7720\u7DBF\u7DEC\u9762\u9EB5" + //  3630 -  3639
                "\u6EC5\uFFFD\u7ACB\u7B20\u7C92\u6469\u746A\u75F2\u78BC\u78E8" + //  3640 -  3649
                "\u99AC\u9B54\u9EBB\u5BDE\u5E55\u6F20\u819C\u83AB\u9088\u4E07" + //  3650 -  3659
                "\u534D\u5A29\u5DD2\u5F4E\u6162\u633D\u6669\u66FC\u6EFF\u6F2B" + //  3660 -  3669
                "\u7063\u779E\u842C\u8513\u883B\u8F13\u9945\u9C3B\u551C\u62B9" + //  3670 -  3679
                "\u672B\u6CAB\u8309\u896A\u977A\u4EA1\u5984\u5FD8\u5FD9\u671B" + //  3680 -  3689
                "\u7DB2\u7F54\u8292\u832B\u83BD\u8F1E\u9099\u57CB\u59B9\u5A92" + //  3690 -  3699
                "\u5BD0\u6627\u679A\u6885\u6BCF\u7281\u72F8\u7406\u7483\uF962" + //  3700 -  3709
                "\u75E2\u7C6C\u7F79\u7FB8\u8389\u88CF\u88E1\u91CC\u91D0\u96E2" + //  3710 -  3719
                "\u9BC9\u541D\u6F7E\u71D0\u7498\u85FA\u8EAA\u96A3\u9C57\u9E9F" + //  3720 -  3729
                "\u6797\u6DCB\u7433\u81E8\u9716\u782C\uFFFD\u907C\u9B27\u9F8D" + //  3730 -  3739
                "\u58D8\u5A41\u5C62\u6A13\u6DDA\u6F0F\u763B\u7D2F\u7E37\u851E" + //  3740 -  3749
                "\u8938\u93E4\u964B\u5289\u65D2\u67F3\u69B4\u6D41\u6E9C\u700F" + //  3750 -  3759
                "\u7409\u7460\u7559\u7624\u786B\u8B2C\u985E\u516D\u622E\u9678" + //  3760 -  3769
                "\u4F96\u502B\u5D19\u6DEA\u7DB8\u8F2A\u5F8B\u6144\u6817\uF961" + //  3770 -  3779
                "\u9686\u52D2\u808B\u51DC\u51CC\u695E\u7A1C\u7DBE\u83F1\u9675" + //  3780 -  3789
                "\u4FDA\u5229\u5398\u540F\u550E\u5C65\u60A7\u674E\u68A8\u6D6C" + //  3790 -  3799
                "\u7DA0\u83C9\u9304\u9E7F\u9E93\u8AD6\u58DF\u5F04\u6727\u7027" + //  3800 -  3809
                "\u74CF\u7C60\u807E\u5121\u7028\u7262\u78CA\u8CC2\u8CDA\u8CF4" + //  3810 -  3819
                "\u96F7\u4E86\u50DA\u5BEE\u5ED6\u6599\u71CE\u7642\u77AD\u804A" + //  3820 -  3829
                "\u84FC\uFFFD\u7149\u7489\u7DF4\u806F\u84EE\u8F26\u9023\u934A" + //  3830 -  3839
                "\u51BD\u5217\u52A3\u6D0C\u70C8\u88C2\u5EC9\u6582\u6BAE\u6FC2" + //  3840 -  3849
                "\u7C3E\u7375\u4EE4\u4F36\u56F9\uF95F\u5CBA\u5DBA\u601C\u73B2" + //  3850 -  3859
                "\u7B2D\u7F9A\u7FCE\u8046\u901E\u9234\u96F6\u9748\u9818\u9F61" + //  3860 -  3869
                "\u4F8B\u6FA7\u79AE\u91B4\u96B7\u52DE\uF960\u6488\u64C4\u6AD3" + //  3870 -  3879
                "\u6F5E\u7018\u7210\u76E7\u8001\u8606\u865C\u8DEF\u8F05\u9732" + //  3880 -  3889
                "\u9B6F\u9DFA\u9E75\u788C\u797F\u8F1B\u91CF\u4FB6\u5137\u52F5" + //  3890 -  3899
                "\u5442\u5EEC\u616E\u623E\u65C5\u6ADA\u6FFE\u792A\u85DC\u8823" + //  3900 -  3909
                "\u95AD\u9A62\u9A6A\u9E97\u9ECE\u529B\u66C6\u6B77\u701D\u792B" + //  3910 -  3919
                "\u8F62\u9742\u6190\u6200\u6523\u6F23\uFFFD\u863F\u87BA\u88F8" + //  3920 -  3929
                "\u908F\uF95C\u6D1B\u70D9\u73DE\u7D61\u843D\uF95D\u916A\u99F1" + //  3930 -  3939
                "\uF95E\u4E82\u5375\u6B04\u6B12\u703E\u721B\u862D\u9E1E\u524C" + //  3940 -  3949
                "\u8FA3\u5D50\u64E5\u652C\u6B16\u6FEB\u7C43\u7E9C\u85CD\u8964" + //  3950 -  3959
                "\u89BD\u62C9\u81D8\u881F\u5ECA\u6717\u6D6A\u72FC\u7405\u746F" + //  3960 -  3969
                "\u8782\u90DE\u4F86\u5D0D\u5FA0\u840A\u51B7\u63A0\u7565\u4EAE" + //  3970 -  3979
                "\u5006\u5169\u51C9\u6881\u6A11\u7CAE\u7CB1\u7CE7\u826F\u8AD2" + //  3980 -  3989
                "\u6597\u675C\u6793\u75D8\u7AC7\u8373\uF95A\u8C46\u9017\u982D" + //  3990 -  3999
                "\u5C6F\u81C0\u829A\u9041\u906F\u920D\u5F97\u5D9D\u6A59\u71C8" + //  4000 -  4009
                "\u767B\u7B49\u85E4\u8B04\u9127\u9A30\u5587\u61F6\uF95B\u7669" + //  4010 -  4019
                "\u7F85\uFFFD\u68F9\u6AC2\u6DD8\u6E21\u6ED4\u6FE4\u71FE\u76DC" + //  4020 -  4029
                "\u7779\u79B1\u7A3B\u8404\u89A9\u8CED\u8DF3\u8E48\u9003\u9014" + //  4030 -  4039
                "\u9053\u90FD\u934D\u9676\u97DC\u6BD2\u7006\u7258\u72A2\u7368" + //  4040 -  4049
                "\u7763\u79BF\u7BE4\u7E9B\u8B80\u58A9\u60C7\u6566\u65FD\u66BE" + //  4050 -  4059
                "\u6C8C\u711E\u71C9\u8C5A\u9813\u4E6D\u7A81\u4EDD\u51AC\u51CD" + //  4060 -  4069
                "\u52D5\u540C\u61A7\u6771\u6850\u68DF\u6D1E\u6F7C\u75BC\u77B3" + //  4070 -  4079
                "\u7AE5\u80F4\u8463\u9285\u515C\u5CB1\u5E36\u5F85\u6234\u64E1" + //  4080 -  4089
                "\u73B3\u81FA\u888B\u8CB8\u968A\u9EDB\u5B85\u5FB7\u60B3\u5012" + //  4090 -  4099
                "\u5200\u5230\u5716\u5835\u5857\u5C0E\u5C60\u5CF6\u5D8B\u5EA6" + //  4100 -  4109
                "\u5F92\u60BC\u6311\u6389\u6417\u6843\uFFFD\u4E39\u4EB6\u4F46" + //  4110 -  4119
                "\u55AE\u5718\u58C7\u5F56\u65B7\u65E6\u6A80\u6BB5\u6E4D\u77ED" + //  4120 -  4129
                "\u7AEF\u7C1E\u7DDE\u86CB\u8892\u9132\u935B\u64BB\u6FBE\u737A" + //  4130 -  4139
                "\u75B8\u9054\u5556\u574D\u61BA\u64D4\u66C7\u6DE1\u6E5B\u6F6D" + //  4140 -  4149
                "\u6FB9\u75F0\u8043\u81BD\u8541\u8983\u8AC7\u8B5A\u931F\u6C93" + //  4150 -  4159
                "\u7553\u7B54\u8E0F\u905D\u5510\u5802\u5858\u5E62\u6207\u649E" + //  4160 -  4169
                "\u68E0\u7576\u7CD6\u87B3\u9EE8\u4EE3\u5788\u576E\u5927\u5C0D" + //  4170 -  4179
                "\u8166\uF948\uF949\u5C3F\uF94A\uF94B\uF94C\uF94D\uF94E\uF94F" + //  4180 -  4189
                "\uF950\uF951\u5AE9\u8A25\u677B\u7D10\uF952\uF953\uF954\uF955" + //  4190 -  4199
                "\uF956\uF957\u80FD\uF958\uF959\u5C3C\u6CE5\u533F\u6EBA\u591A" + //  4200 -  4209
                "\u8336\uFFFD\u7D0D\uF926\uF927\u8872\u56CA\u5A18\uF928\uF929" + //  4210 -  4219
                "\uF92A\uF92B\uF92C\u4E43\uF92D\u5167\u5948\u67F0\u8010\uF92E" + //  4220 -  4229
                "\u5973\u5E74\u649A\u79CA\u5FF5\u606C\u62C8\u637B\u5BE7\u5BD7" + //  4230 -  4239
                "\u52AA\uF92F\u5974\u5F29\u6012\uF930\uF931\uF932\u7459\uF933" + //  4240 -  4249
                "\uF934\uF935\uF936\uF937\uF938\u99D1\uF939\uF93A\uF93B\uF93C" + //  4250 -  4259
                "\uF93D\uF93E\uF93F\uF940\uF941\uF942\uF943\u6FC3\uF944\uF945" + //  4260 -  4269
                "\u81BF\u8FB2\u60F1\uF946\uF947\uF913\u90A3\uF914\uF915\uF916" + //  4270 -  4279
                "\uF917\uF918\u8AFE\uF919\uF91A\uF91B\uF91C\u6696\uF91D\u7156" + //  4280 -  4289
                "\uF91E\uF91F\u96E3\uF920\u634F\u637A\u5357\uF921\u678F\u6960" + //  4290 -  4299
                "\u6E73\uF922\u7537\uF923\uF924\uF925\uFFFD\u671E\u671F\u675E" + //  4300 -  4309
                "\u68CB\u68C4\u6A5F\u6B3A\u6C23\u6C7D\u6C82\u6DC7\u7398\u7426" + //  4310 -  4319
                "\u742A\u7482\u74A3\u7578\u757F\u7881\u78EF\u7941\u7947\u7948" + //  4320 -  4329
                "\u797A\u7B95\u7D00\u7DBA\u7F88\u8006\u802D\u808C\u8A18\u8B4F" + //  4330 -  4339
                "\u8C48\u8D77\u9321\u9324\u98E2\u9951\u9A0E\u9A0F\u9A65\u9E92" + //  4340 -  4349
                "\u7DCA\u4F76\u5409\u62EE\u6854\u91D1\u55AB\u513A\uF90B\uF90C" + //  4350 -  4359
                "\u5A1C\u61E6\uF90D\u62CF\u62FF\uF90E\uF90F\uF910\uF911\uF912" + //  4360 -  4369
                "\u53CA\u6025\u6271\u6C72\u7D1A\u7D66\u4E98\u5162\u77DC\u80AF" + //  4370 -  4379
                "\u4F01\u4F0E\u5176\u5180\u55DC\u5668\u573B\u57FA\u57FC\u5914" + //  4380 -  4389
                "\u5947\u5993\u5BC4\u5C90\u5D0E\u5DF1\u5E7E\u5FCC\u6280\u65D7" + //  4390 -  4399
                "\u65E3\uFFFD\u9B3C\uF907\u53EB\u572D\u594E\u63C6\u69FB\u73EA" + //  4400 -  4409
                "\u7845\u7ABA\u7AC5\u7CFE\u8475\u898F\u8D73\u9035\u95A8\u52FB" + //  4410 -  4419
                "\u5747\u7547\u7B60\u83CC\u921E\uF908\u6A58\u514B\u524B\u5287" + //  4420 -  4429
                "\u621F\u68D8\u6975\u9699\u50C5\u52A4\u52E4\u61C3\u65A4\u6839" + //  4430 -  4439
                "\u69FF\u747E\u7B4B\u82B9\u83EB\u89B2\u8B39\u8FD1\u9949\uF909" + //  4440 -  4449
                "\u4ECA\u5997\u64D2\u6611\u6A8E\u7434\u7981\u79BD\u82A9\u887E" + //  4450 -  4459
                "\u887F\u895F\uF90A\u9326\u4F0B\u5BAE\u5F13\u7A79\u7AAE\u828E" + //  4460 -  4469
                "\u8EAC\u5026\u5238\u52F8\u5377\u5708\u62F3\u6372\u6B0A\u6DC3" + //  4470 -  4479
                "\u7737\u53A5\u7357\u8568\u8E76\u95D5\u673A\u6AC3\u6F70\u8A6D" + //  4480 -  4489
                "\u8ECC\u994B\uF906\u6677\u6B78\u8CB4\uFFFD\u5340\u53E3\u53E5" + //  4490 -  4499
                "\u548E\u5614\u5775\u57A2\u5BC7\u5D87\u5ED0\u61FC\u62D8\u6551" + //  4500 -  4509
                "\u67B8\u67E9\u69CB\u6B50\u6BC6\u6BEC\u6C42\u6E9D\u7078\u72D7" + //  4510 -  4519
                "\u7396\u7403\u77BF\u77E9\u7A76\u7D7F\u8009\u81FC\u8205\u820A" + //  4520 -  4529
                "\u82DF\u8862\u8B33\u8CFC\u8EC0\u9011\u90B1\u9264\u92B6\u99D2" + //  4530 -  4539
                "\u9A45\u9CE9\u9DD7\u9F9C\u570B\u5C40\u83CA\u97A0\u97AB\u9EB4" + //  4540 -  4549
                "\u541B\u7A98\u7FA4\u88D9\u8ECD\u90E1\u5800\u5C48\u6398\u7A9F" + //  4550 -  4559
                "\u50D1\u54AC\u55AC\u5B0C\u5DA0\u5DE7\u652A\u654E\u6821\u6A4B" + //  4560 -  4569
                "\u72E1\u768E\u77EF\u7D5E\u7FF9\u81A0\u854E\u86DF\u8F03\u8F4E" + //  4570 -  4579
                "\u90CA\u9903\u9A55\u9BAB\u4E18\u4E45\u4E5D\u4EC7\u4FF1\u5177" + //  4580 -  4589
                "\u52FE\uFFFD\u79D1\u83D3\u8A87\u8AB2\u8DE8\u904E\u934B\u9846" + //  4590 -  4599
                "\u5ED3\u69E8\u85FF\u90ED\uF905\u51A0\u5B98\u5BEC\u6163\u68FA" + //  4600 -  4609
                "\u6B3E\u704C\u742F\u74D8\u7BA1\u7F50\u83C5\u89C0\u8CAB\u95DC" + //  4610 -  4619
                "\u9928\u522E\u605D\u62EC\u9002\u4F8A\u5149\u5321\u58D9\u5EE3" + //  4620 -  4629
                "\u66E0\u6D38\u709A\u72C2\u73D6\u7B50\u80F1\u945B\u5366\u639B" + //  4630 -  4639
                "\u7F6B\u4E56\u5080\u584A\u58DE\u602A\u6127\u62D0\u69D0\u9B41" + //  4640 -  4649
                "\u5B8F\u7D18\u80B1\u8F5F\u4EA4\u6606\u68B1\u68CD\u6EFE\u7428" + //  4650 -  4659
                "\u889E\u9BE4\u6C68\uF904\u9AA8\u4F9B\u516C\u5171\u529F\u5B54" + //  4660 -  4669
                "\u5DE5\u6050\u606D\u62F1\u63A7\u653B\u73D9\u7A7A\u86A3\u8CA2" + //  4670 -  4679
                "\u978F\u4E32\u5BE1\u6208\u679C\u74DC\uFFFD\u68E8\u6EAA\u754C" + //  4680 -  4689
                "\u7678\u78CE\u7A3D\u7CFB\u7E6B\u7E7C\u8A08\u8AA1\u8C3F\u968E" + //  4690 -  4699
                "\u9DC4\u53E4\u53E9\u544A\u5471\u56FA\u59D1\u5B64\u5C3B\u5EAB" + //  4700 -  4709
                "\u62F7\u6537\u6545\u6572\u66A0\u67AF\u69C1\u6CBD\u75FC\u7690" + //  4710 -  4719
                "\u777E\u7A3F\u7F94\u8003\u80A1\u818F\u82E6\u82FD\u83F0\u85C1" + //  4720 -  4729
                "\u8831\u88B4\u8AA5\uF903\u8F9C\u932E\u96C7\u9867\u9AD8\u9F13" + //  4730 -  4739
                "\u54ED\u659B\u66F2\u688F\u7A40\u8C37\u9D60\u56F0\u5764\u5D11" + //  4740 -  4749
                "\u74A5\u74CA\u75D9\u786C\u78EC\u7ADF\u7AF6\u7D45\u7D93\u8015" + //  4750 -  4759
                "\u803F\u811B\u8396\u8B66\u8F15\u9015\u93E1\u9803\u9838\u9A5A" + //  4760 -  4769
                "\u9BE8\u4FC2\u5553\u583A\u5951\u5B63\u5C46\u60B8\u6212\u6842" + //  4770 -  4779
                "\u68B0\uFFFD\u77BC\u9210\u9ED4\u52AB\u602F\u8FF2\u5048\u61A9" + //  4780 -  4789
                "\u63ED\u64CA\u683C\u6A84\u6FC0\u8188\u89A1\u9694\u5805\u727D" + //  4790 -  4799
                "\u72AC\u7504\u7D79\u7E6D\u80A9\u898B\u8B74\u9063\u9D51\u6289" + //  4800 -  4809
                "\u6C7A\u6F54\u7D50\u7F3A\u8A23\u517C\u614A\u7B9D\u8B19\u9257" + //  4810 -  4819
                "\u938C\u4EAC\u4FD3\u501E\u50BE\u5106\u52C1\u52CD\u537F\u5770" + //  4820 -  4829
                "\u5883\u5E9A\u5F91\u6176\u61AC\u64CE\u656C\u666F\u66BB\u66F4" + //  4830 -  4839
                "\u6897\u6D87\u7085\u70F1\u749F\u64DA\u64E7\u6E20\u70AC\u795B" + //  4840 -  4849
                "\u8DDD\u8E1E\uF902\u907D\u9245\u92F8\u4E7E\u4EF6\u5065\u5DFE" + //  4850 -  4859
                "\u5EFA\u6106\u6957\u8171\u8654\u8E47\u9375\u9A2B\u4E5E\u5091" + //  4860 -  4869
                "\u6770\u6840\u5109\u528D\u5292\u6AA2\uFFFD\u5323\u5CAC\u7532" + //  4870 -  4879
                "\u80DB\u9240\u9598\u525B\u5808\u59DC\u5CA1\u5D17\u5EB7\u5F3A" + //  4880 -  4889
                "\u5F4A\u6177\u6C5F\u757A\u7586\u7CE0\u7D73\u7DB1\u7F8C\u8154" + //  4890 -  4899
                "\u8221\u8591\u8941\u8B1B\u92FC\u964D\u9C47\u4ECB\u4EF7\u500B" + //  4900 -  4909
                "\u51F1\u584F\u6137\u613E\u6168\u6539\u69EA\u6F11\u75A5\u7686" + //  4910 -  4919
                "\u76D6\u7B87\u82A5\u84CB\uF900\u93A7\u958B\u5580\u5BA2\u5751" + //  4920 -  4929
                "\uF901\u7CB3\u7FB9\u91B5\u5028\u53BB\u5C45\u5DE8\u62D2\u636E" + //  4930 -  4939
                "\u9593\u4E6B\u559D\u66F7\u6E34\u78A3\u7AED\u845B\u8910\u874E" + //  4940 -  4949
                "\u97A8\u52D8\u574E\u582A\u5D4C\u611F\u61BE\u6221\u6562\u67D1" + //  4950 -  4959
                "\u6A44\u6E1B\u7518\u75B3\u76E3\u77B0\u7D3A\u90AF\u9451\u9452" + //  4960 -  4969
                "\u9F95\uFFFD\u4F3D\u4F73\u5047\u50F9\u52A0\u53EF\u5475\u54E5" + //  4970 -  4979
                "\u5609\u5AC1\u5BB6\u6687\u67B6\u67B7\u67EF\u6B4C\u73C2\u75C2" + //  4980 -  4989
                "\u7A3C\u82DB\u8304\u8857\u8888\u8A36\u8CC8\u8DCF\u8EFB\u8FE6" + //  4990 -  4999
                "\u99D5\u523B\u5374\u5404\u606A\u6164\u6BBC\u73CF\u811A\u89BA" + //  5000 -  5009
                "\u89D2\u95A3\u4F83\u520A\u58BE\u5978\u59E6\u5E72\u5E79\u61C7" + //  5010 -  5019
                "\u63C0\u6746\u67EC\u687F\u6F97\u764E\u770B\u78F5\u7A08\u7AFF" + //  5020 -  5029
                "\u7C21\u809D\u826E\u8271\u8AEB\uE03F\uE040\uE041\uE042\uE043" + //  5030 -  5039
                "\uE044\uE045\uE046\uE047\uE048\uE049\uE04A\uE04B\uE04C\uE04D" + //  5040 -  5049
                "\uE04E\uE04F\uE050\uE051\uE052\uE053\uE054\uE055\uE056\uE057" + //  5050 -  5059
                "\uE058\uE059\uE05A\uE05B\uE05C\uE05D\uFFFD\uE000\uE001\uE002" + //  5060 -  5069
                "\uE003\uE004\uE005\uE006\uE007\uE008\uE009\uE00A\uE00B\uE00C" + //  5070 -  5079
                "\uE00D\uE00E\uE00F\uE010\uE011\uE012\uE013\uE014\uE015\uE016" + //  5080 -  5089
                "\uE017\uE018\uE019\uE01A\uE01B\uE01C\uE01D\uE01E\uE01F\uE020" + //  5090 -  5099
                "\uE021\uE022\uE023\uE024\uE025\uE026\uE027\uE028\uE029\uE02A" + //  5100 -  5109
                "\uE02B\uE02C\uE02D\uE02E\uE02F\uE030\uE031\uE032\uE033\uE034" + //  5110 -  5119
                "\uE035\uE036\uE037\uE038\uE039\uE03A\uE03B\uE03C\uE03D\uE03E" + //  5120 -  5129
                "\uD738\uD73C\uD744\uD747\uD749\uD750\uD751\uD754\uD756\uD757" + //  5130 -  5139
                "\uD758\uD759\uD760\uD761\uD763\uD765\uD769\uD76C\uD770\uD774" + //  5140 -  5149
                "\uD77C\uD77D\uD781\uD788\uD789\uD78C\uD790\uD798\uD799\uD79B" + //  5150 -  5159
                "\uD79D\uFFFD\uD624\uD62D\uD638\uD639\uD63C\uD640\uD645\uD648" + //  5160 -  5169
                "\uD649\uD64B\uD64D\uD651\uD654\uD655\uD658\uD65C\uD667\uD669" + //  5170 -  5179
                "\uD670\uD671\uD674\uD683\uD685\uD68C\uD68D\uD690\uD694\uD69D" + //  5180 -  5189
                "\uD69F\uD6A1\uD6A8\uD6AC\uD6B0\uD6B9\uD6BB\uD6C4\uD6C5\uD6C8" + //  5190 -  5199
                "\uD6CC\uD6D1\uD6D4\uD6D7\uD6D9\uD6E0\uD6E4\uD6E8\uD6F0\uD6F5" + //  5200 -  5209
                "\uD6FC\uD6FD\uD700\uD704\uD711\uD718\uD719\uD71C\uD720\uD728" + //  5210 -  5219
                "\uD729\uD72B\uD72D\uD734\uD735\uD589\uD590\uD5A5\uD5C8\uD5C9" + //  5220 -  5229
                "\uD5CC\uD5D0\uD5D2\uD5D8\uD5D9\uD5DB\uD5DD\uD5E4\uD5E5\uD5E8" + //  5230 -  5239
                "\uD5EC\uD5F4\uD5F5\uD5F7\uD5F9\uD600\uD601\uD604\uD608\uD610" + //  5240 -  5249
                "\uD611\uD613\uD614\uD615\uD61C\uD620\uFFFD\uD408\uD41D\uD440" + //  5250 -  5259
                "\uD444\uD45C\uD460\uD464\uD46D\uD46F\uD478\uD479\uD47C\uD47F" + //  5260 -  5269
                "\uD480\uD482\uD488\uD489\uD48B\uD48D\uD494\uD4A9\uD4CC\uD4D0" + //  5270 -  5279
                "\uD4D4\uD4DC\uD4DF\uD4E8\uD4EC\uD4F0\uD4F8\uD4FB\uD4FD\uD504" + //  5280 -  5289
                "\uD508\uD50C\uD514\uD515\uD517\uD53C\uD53D\uD540\uD544\uD54C" + //  5290 -  5299
                "\uD54D\uD54F\uD551\uD558\uD559\uD55C\uD560\uD565\uD568\uD569" + //  5300 -  5309
                "\uD56B\uD56D\uD574\uD575\uD578\uD57C\uD584\uD585\uD587\uD588" + //  5310 -  5319
                "\uD38D\uD38F\uD390\uD391\uD398\uD399\uD39C\uD3A0\uD3A8\uD3A9" + //  5320 -  5329
                "\uD3AB\uD3AD\uD3B4\uD3B8\uD3BC\uD3C4\uD3C5\uD3C8\uD3C9\uD3D0" + //  5330 -  5339
                "\uD3D8\uD3E1\uD3E3\uD3EC\uD3ED\uD3F0\uD3F4\uD3FC\uD3FD\uD3FF" + //  5340 -  5349
                "\uD401\uFFFD\uD264\uD280\uD281\uD284\uD288\uD290\uD291\uD295" + //  5350 -  5359
                "\uD29C\uD2A0\uD2A4\uD2AC\uD2B1\uD2B8\uD2B9\uD2BC\uD2BF\uD2C0" + //  5360 -  5369
                "\uD2C2\uD2C8\uD2C9\uD2CB\uD2D4\uD2D8\uD2DC\uD2E4\uD2E5\uD2F0" + //  5370 -  5379
                "\uD2F1\uD2F4\uD2F8\uD300\uD301\uD303\uD305\uD30C\uD30D\uD30E" + //  5380 -  5389
                "\uD310\uD314\uD316\uD31C\uD31D\uD31F\uD320\uD321\uD325\uD328" + //  5390 -  5399
                "\uD329\uD32C\uD330\uD338\uD339\uD33B\uD33C\uD33D\uD344\uD345" + //  5400 -  5409
                "\uD37C\uD37D\uD380\uD384\uD38C\uD16C\uD17C\uD184\uD188\uD1A0" + //  5410 -  5419
                "\uD1A1\uD1A4\uD1A8\uD1B0\uD1B1\uD1B3\uD1B5\uD1BA\uD1BC\uD1C0" + //  5420 -  5429
                "\uD1D8\uD1F4\uD1F8\uD207\uD209\uD210\uD22C\uD22D\uD230\uD234" + //  5430 -  5439
                "\uD23C\uD23D\uD23F\uD241\uD248\uD25C\uFFFD\uD044\uD045\uD047" + //  5440 -  5449
                "\uD049\uD050\uD054\uD058\uD060\uD06C\uD06D\uD070\uD074\uD07C" + //  5450 -  5459
                "\uD07D\uD081\uD0A4\uD0A5\uD0A8\uD0AC\uD0B4\uD0B5\uD0B7\uD0B9" + //  5460 -  5469
                "\uD0C0\uD0C1\uD0C4\uD0C8\uD0C9\uD0D0\uD0D1\uD0D3\uD0D4\uD0D5" + //  5470 -  5479
                "\uD0DC\uD0DD\uD0E0\uD0E4\uD0EC\uD0ED\uD0EF\uD0F0\uD0F1\uD0F8" + //  5480 -  5489
                "\uD10D\uD130\uD131\uD134\uD138\uD13A\uD140\uD141\uD143\uD144" + //  5490 -  5499
                "\uD145\uD14C\uD14D\uD150\uD154\uD15C\uD15D\uD15F\uD161\uD168" + //  5500 -  5509
                "\uCF67\uCF69\uCF70\uCF71\uCF74\uCF78\uCF80\uCF85\uCF8C\uCFA1" + //  5510 -  5519
                "\uCFA8\uCFB0\uCFC4\uCFE0\uCFE1\uCFE4\uCFE8\uCFF0\uCFF1\uCFF3" + //  5520 -  5529
                "\uCFF5\uCFFC\uD000\uD004\uD011\uD018\uD02D\uD034\uD035\uD038" + //  5530 -  5539
                "\uD03C\uFFFD\uCE58\uCE59\uCE5C\uCE5F\uCE60\uCE61\uCE68\uCE69" + //  5540 -  5549
                "\uCE6B\uCE6D\uCE74\uCE75\uCE78\uCE7C\uCE84\uCE85\uCE87\uCE89" + //  5550 -  5559
                "\uCE90\uCE91\uCE94\uCE98\uCEA0\uCEA1\uCEA3\uCEA4\uCEA5\uCEAC" + //  5560 -  5569
                "\uCEAD\uCEC1\uCEE4\uCEE5\uCEE8\uCEEB\uCEEC\uCEF4\uCEF5\uCEF7" + //  5570 -  5579
                "\uCEF8\uCEF9\uCF00\uCF01\uCF04\uCF08\uCF10\uCF11\uCF13\uCF15" + //  5580 -  5589
                "\uCF1C\uCF20\uCF24\uCF2C\uCF2D\uCF2F\uCF30\uCF31\uCF38\uCF54" + //  5590 -  5599
                "\uCF55\uCF58\uCF5C\uCF64\uCF65\uCD95\uCD98\uCD9C\uCDA4\uCDA5" + //  5600 -  5609
                "\uCDA7\uCDA9\uCDB0\uCDC4\uCDCC\uCDD0\uCDE8\uCDEC\uCDF0\uCDF8" + //  5610 -  5619
                "\uCDF9\uCDFB\uCDFD\uCE04\uCE08\uCE0C\uCE14\uCE19\uCE20\uCE21" + //  5620 -  5629
                "\uCE24\uCE28\uCE30\uCE31\uCE33\uCE35\uFFFD\uCC3C\uCC3D\uCC3E" + //  5630 -  5639
                "\uCC44\uCC45\uCC48\uCC4C\uCC54\uCC55\uCC57\uCC58\uCC59\uCC60" + //  5640 -  5649
                "\uCC64\uCC66\uCC68\uCC70\uCC75\uCC98\uCC99\uCC9C\uCCA0\uCCA8" + //  5650 -  5659
                "\uCCA9\uCCAB\uCCAC\uCCAD\uCCB4\uCCB5\uCCB8\uCCBC\uCCC4\uCCC5" + //  5660 -  5669
                "\uCCC7\uCCC9\uCCD0\uCCD4\uCCE4\uCCEC\uCCF0\uCD01\uCD08\uCD09" + //  5670 -  5679
                "\uCD0C\uCD10\uCD18\uCD19\uCD1B\uCD1D\uCD24\uCD28\uCD2C\uCD39" + //  5680 -  5689
                "\uCD5C\uCD60\uCD64\uCD6C\uCD6D\uCD6F\uCD71\uCD78\uCD88\uCD94" + //  5690 -  5699
                "\uCB4C\uCB50\uCB58\uCB59\uCB5D\uCB64\uCB78\uCB79\uCB9C\uCBB8" + //  5700 -  5709
                "\uCBD4\uCBE4\uCBE7\uCBE9\uCC0C\uCC0D\uCC10\uCC14\uCC1C\uCC1D" + //  5710 -  5719
                "\uCC21\uCC22\uCC27\uCC28\uCC29\uCC2C\uCC2E\uCC30\uCC38\uCC39" + //  5720 -  5729
                "\uCC3B\uFFFD\uC9D5\uC9D6\uC9D9\uC9DA\uC9DC\uC9DD\uC9E0\uC9E2" + //  5730 -  5739
                "\uC9E4\uC9E7\uC9EC\uC9ED\uC9EF\uC9F0\uC9F1\uC9F8\uC9F9\uC9FC" + //  5740 -  5749
                "\uCA00\uCA08\uCA09\uCA0B\uCA0C\uCA0D\uCA14\uCA18\uCA29\uCA4C" + //  5750 -  5759
                "\uCA4D\uCA50\uCA54\uCA5C\uCA5D\uCA5F\uCA60\uCA61\uCA68\uCA7D" + //  5760 -  5769
                "\uCA84\uCA98\uCABC\uCABD\uCAC0\uCAC4\uCACC\uCACD\uCACF\uCAD1" + //  5770 -  5779
                "\uCAD3\uCAD8\uCAD9\uCAE0\uCAEC\uCAF4\uCB08\uCB10\uCB14\uCB18" + //  5780 -  5789
                "\uCB20\uCB21\uCB41\uCB48\uCB49\uC918\uC92C\uC934\uC950\uC951" + //  5790 -  5799
                "\uC954\uC958\uC960\uC961\uC963\uC96C\uC970\uC974\uC97C\uC988" + //  5800 -  5809
                "\uC989\uC98C\uC990\uC998\uC999\uC99B\uC99D\uC9C0\uC9C1\uC9C4" + //  5810 -  5819
                "\uC9C7\uC9C8\uC9CA\uC9D0\uC9D1\uC9D3\uFFFD\uC810\uC811\uC813" + //  5820 -  5829
                "\uC815\uC816\uC81C\uC81D\uC820\uC824\uC82C\uC82D\uC82F\uC831" + //  5830 -  5839
                "\uC838\uC83C\uC840\uC848\uC849\uC84C\uC84D\uC854\uC870\uC871" + //  5840 -  5849
                "\uC874\uC878\uC87A\uC880\uC881\uC883\uC885\uC886\uC887\uC88B" + //  5850 -  5859
                "\uC88C\uC88D\uC894\uC89D\uC89F\uC8A1\uC8A8\uC8BC\uC8BD\uC8C4" + //  5860 -  5869
                "\uC8C8\uC8CC\uC8D4\uC8D5\uC8D7\uC8D9\uC8E0\uC8E1\uC8E4\uC8F5" + //  5870 -  5879
                "\uC8FC\uC8FD\uC900\uC904\uC905\uC906\uC90C\uC90D\uC90F\uC911" + //  5880 -  5889
                "\uC79A\uC7A0\uC7A1\uC7A3\uC7A4\uC7A5\uC7A6\uC7AC\uC7AD\uC7B0" + //  5890 -  5899
                "\uC7B4\uC7BC\uC7BD\uC7BF\uC7C0\uC7C1\uC7C8\uC7C9\uC7CC\uC7CE" + //  5900 -  5909
                "\uC7D0\uC7D8\uC7DD\uC7E4\uC7E8\uC7EC\uC800\uC801\uC804\uC808" + //  5910 -  5919
                "\uC80A\uFFFD\uC6E9\uC6EC\uC6F0\uC6F8\uC6F9\uC6FD\uC704\uC705" + //  5920 -  5929
                "\uC708\uC70C\uC714\uC715\uC717\uC719\uC720\uC721\uC724\uC728" + //  5930 -  5939
                "\uC730\uC731\uC733\uC735\uC737\uC73C\uC73D\uC740\uC744\uC74A" + //  5940 -  5949
                "\uC74C\uC74D\uC74F\uC751\uC752\uC753\uC754\uC755\uC756\uC757" + //  5950 -  5959
                "\uC758\uC75C\uC760\uC768\uC76B\uC774\uC775\uC778\uC77C\uC77D" + //  5960 -  5969
                "\uC77E\uC783\uC784\uC785\uC787\uC788\uC789\uC78A\uC78E\uC790" + //  5970 -  5979
                "\uC791\uC794\uC796\uC797\uC798\uC688\uC689\uC68B\uC68D\uC694" + //  5980 -  5989
                "\uC695\uC698\uC69C\uC6A4\uC6A5\uC6A7\uC6A9\uC6B0\uC6B1\uC6B4" + //  5990 -  5999
                "\uC6B8\uC6B9\uC6BA\uC6C0\uC6C1\uC6C3\uC6C5\uC6CC\uC6CD\uC6D0" + //  6000 -  6009
                "\uC6D4\uC6DC\uC6DD\uC6E0\uC6E1\uC6E8\uFFFD\uC5D0\uC5D1\uC5D4" + //  6010 -  6019
                "\uC5D8\uC5E0\uC5E1\uC5E3\uC5E5\uC5EC\uC5ED\uC5EE\uC5F0\uC5F4" + //  6020 -  6029
                "\uC5F6\uC5F7\uC5FC\uC5FD\uC5FE\uC5FF\uC600\uC601\uC605\uC606" + //  6030 -  6039
                "\uC607\uC608\uC60C\uC610\uC618\uC619\uC61B\uC61C\uC624\uC625" + //  6040 -  6049
                "\uC628\uC62C\uC62D\uC62E\uC630\uC633\uC634\uC635\uC637\uC639" + //  6050 -  6059
                "\uC63B\uC640\uC641\uC644\uC648\uC650\uC651\uC653\uC654\uC655" + //  6060 -  6069
                "\uC65C\uC65D\uC660\uC66C\uC66F\uC671\uC678\uC679\uC67C\uC680" + //  6070 -  6079
                "\uC57D\uC580\uC584\uC587\uC58C\uC58D\uC58F\uC591\uC595\uC597" + //  6080 -  6089
                "\uC598\uC59C\uC5A0\uC5A9\uC5B4\uC5B5\uC5B8\uC5B9\uC5BB\uC5BC" + //  6090 -  6099
                "\uC5BD\uC5BE\uC5C4\uC5C5\uC5C6\uC5C7\uC5C8\uC5C9\uC5CA\uC5CC" + //  6100 -  6109
                "\uC5CE\uFFFD\uC434\uC43C\uC43D\uC448\uC464\uC465\uC468\uC46C" + //  6110 -  6119
                "\uC474\uC475\uC479\uC480\uC494\uC49C\uC4B8\uC4BC\uC4E9\uC4F0" + //  6120 -  6129
                "\uC4F1\uC4F4\uC4F8\uC4FA\uC4FF\uC500\uC501\uC50C\uC510\uC514" + //  6130 -  6139
                "\uC51C\uC528\uC529\uC52C\uC530\uC538\uC539\uC53B\uC53D\uC544" + //  6140 -  6149
                "\uC545\uC548\uC549\uC54A\uC54C\uC54D\uC54E\uC553\uC554\uC555" + //  6150 -  6159
                "\uC557\uC558\uC559\uC55D\uC55E\uC560\uC561\uC564\uC568\uC570" + //  6160 -  6169
                "\uC571\uC573\uC574\uC575\uC57C\uC345\uC368\uC369\uC36C\uC370" + //  6170 -  6179
                "\uC372\uC378\uC379\uC37C\uC37D\uC384\uC388\uC38C\uC3C0\uC3D8" + //  6180 -  6189
                "\uC3D9\uC3DC\uC3DF\uC3E0\uC3E2\uC3E8\uC3E9\uC3ED\uC3F4\uC3F5" + //  6190 -  6199
                "\uC3F8\uC408\uC410\uC424\uC42C\uC430\uFFFD\uC22F\uC231\uC232" + //  6200 -  6209
                "\uC234\uC248\uC250\uC251\uC254\uC258\uC260\uC265\uC26C\uC26D" + //  6210 -  6219
                "\uC270\uC274\uC27C\uC27D\uC27F\uC281\uC288\uC289\uC290\uC298" + //  6220 -  6229
                "\uC29B\uC29D\uC2A4\uC2A5\uC2A8\uC2AC\uC2AD\uC2B4\uC2B5\uC2B7" + //  6230 -  6239
                "\uC2B9\uC2DC\uC2DD\uC2E0\uC2E3\uC2E4\uC2EB\uC2EC\uC2ED\uC2EF" + //  6240 -  6249
                "\uC2F1\uC2F6\uC2F8\uC2F9\uC2FB\uC2FC\uC300\uC308\uC309\uC30C" + //  6250 -  6259
                "\uC30D\uC313\uC314\uC315\uC318\uC31C\uC324\uC325\uC328\uC329" + //  6260 -  6269
                "\uC1B0\uC1BD\uC1C4\uC1C8\uC1CC\uC1D4\uC1D7\uC1D8\uC1E0\uC1E4" + //  6270 -  6279
                "\uC1E8\uC1F0\uC1F1\uC1F3\uC1FC\uC1FD\uC200\uC204\uC20C\uC20D" + //  6280 -  6289
                "\uC20F\uC211\uC218\uC219\uC21C\uC21F\uC220\uC228\uC229\uC22B" + //  6290 -  6299
                "\uC22D\uFFFD\uC0E5\uC0E8\uC0EC\uC0F4\uC0F5\uC0F7\uC0F9\uC100" + //  6300 -  6309
                "\uC104\uC108\uC110\uC115\uC11C\uC11D\uC11E\uC11F\uC120\uC123" + //  6310 -  6319
                "\uC124\uC126\uC127\uC12C\uC12D\uC12F\uC130\uC131\uC136\uC138" + //  6320 -  6329
                "\uC139\uC13C\uC140\uC148\uC149\uC14B\uC14C\uC14D\uC154\uC155" + //  6330 -  6339
                "\uC158\uC15C\uC164\uC165\uC167\uC168\uC169\uC170\uC174\uC178" + //  6340 -  6349
                "\uC185\uC18C\uC18D\uC18E\uC190\uC194\uC196\uC19C\uC19D\uC19F" + //  6350 -  6359
                "\uC1A1\uC1A5\uC1A8\uC1A9\uC1AC\uC091\uC094\uC098\uC0A0\uC0A1" + //  6360 -  6369
                "\uC0A3\uC0A5\uC0AC\uC0AD\uC0AF\uC0B0\uC0B3\uC0B4\uC0B5\uC0B6" + //  6370 -  6379
                "\uC0BC\uC0BD\uC0BF\uC0C0\uC0C1\uC0C5\uC0C8\uC0C9\uC0CC\uC0D0" + //  6380 -  6389
                "\uC0D8\uC0D9\uC0DB\uC0DC\uC0DD\uC0E4\uFFFD\uBE68\uBE6A\uBE70" + //  6390 -  6399
                "\uBE71\uBE73\uBE74\uBE75\uBE7B\uBE7C\uBE7D\uBE80\uBE84\uBE8C" + //  6400 -  6409
                "\uBE8D\uBE8F\uBE90\uBE91\uBE98\uBE99\uBEA8\uBED0\uBED1\uBED4" + //  6410 -  6419
                "\uBED7\uBED8\uBEE0\uBEE3\uBEE4\uBEE5\uBEEC\uBF01\uBF08\uBF09" + //  6420 -  6429
                "\uBF18\uBF19\uBF1B\uBF1C\uBF1D\uBF40\uBF41\uBF44\uBF48\uBF50" + //  6430 -  6439
                "\uBF51\uBF55\uBF94\uBFB0\uBFC5\uBFCC\uBFCD\uBFD0\uBFD4\uBFDC" + //  6440 -  6449
                "\uBFDF\uBFE1\uC03C\uC051\uC058\uC05C\uC060\uC068\uC069\uC090" + //  6450 -  6459
                "\uBDD5\uBDD8\uBDDC\uBDE9\uBDF0\uBDF4\uBDF8\uBE00\uBE03\uBE05" + //  6460 -  6469
                "\uBE0C\uBE0D\uBE10\uBE14\uBE1C\uBE1D\uBE1F\uBE44\uBE45\uBE48" + //  6470 -  6479
                "\uBE4C\uBE4E\uBE54\uBE55\uBE57\uBE59\uBE5A\uBE5B\uBE60\uBE61" + //  6480 -  6489
                "\uBE64\uFFFD\uBC99\uBC9A\uBCA0\uBCA1\uBCA4\uBCA7\uBCA8\uBCB0" + //  6490 -  6499
                "\uBCB1\uBCB3\uBCB4\uBCB5\uBCBC\uBCBD\uBCC0\uBCC4\uBCCD\uBCCF" + //  6500 -  6509
                "\uBCD0\uBCD1\uBCD5\uBCD8\uBCDC\uBCF4\uBCF5\uBCF6\uBCF8\uBCFC" + //  6510 -  6519
                "\uBD04\uBD05\uBD07\uBD09\uBD10\uBD14\uBD24\uBD2C\uBD40\uBD48" + //  6520 -  6529
                "\uBD49\uBD4C\uBD50\uBD58\uBD59\uBD64\uBD68\uBD80\uBD81\uBD84" + //  6530 -  6539
                "\uBD87\uBD88\uBD89\uBD8A\uBD90\uBD91\uBD93\uBD95\uBD99\uBD9A" + //  6540 -  6549
                "\uBD9C\uBDA4\uBDB0\uBDB8\uBDD4\uBC1D\uBC1E\uBC1F\uBC24\uBC25" + //  6550 -  6559
                "\uBC27\uBC29\uBC2D\uBC30\uBC31\uBC34\uBC38\uBC40\uBC41\uBC43" + //  6560 -  6569
                "\uBC44\uBC45\uBC49\uBC4C\uBC4D\uBC50\uBC5D\uBC84\uBC85\uBC88" + //  6570 -  6579
                "\uBC8B\uBC8C\uBC8E\uBC94\uBC95\uBC97\uFFFD\uBB00\uBB04\uBB0D" + //  6580 -  6589
                "\uBB0F\uBB11\uBB18\uBB1C\uBB20\uBB29\uBB2B\uBB34\uBB35\uBB36" + //  6590 -  6599
                "\uBB38\uBB3B\uBB3C\uBB3D\uBB3E\uBB44\uBB45\uBB47\uBB49\uBB4D" + //  6600 -  6609
                "\uBB4F\uBB50\uBB54\uBB58\uBB61\uBB63\uBB6C\uBB88\uBB8C\uBB90" + //  6610 -  6619
                "\uBBA4\uBBA8\uBBAC\uBBB4\uBBB7\uBBC0\uBBC4\uBBC8\uBBD0\uBBD3" + //  6620 -  6629
                "\uBBF8\uBBF9\uBBFC\uBBFF\uBC00\uBC02\uBC08\uBC09\uBC0B\uBC0C" + //  6630 -  6639
                "\uBC0D\uBC0F\uBC11\uBC14\uBC15\uBC16\uBC17\uBC18\uBC1B\uBC1C" + //  6640 -  6649
                "\uBA58\uBA5C\uBA64\uBA65\uBA67\uBA68\uBA69\uBA70\uBA71\uBA74" + //  6650 -  6659
                "\uBA78\uBA83\uBA84\uBA85\uBA87\uBA8C\uBAA8\uBAA9\uBAAB\uBAAC" + //  6660 -  6669
                "\uBAB0\uBAB2\uBAB8\uBAB9\uBABB\uBABD\uBAC4\uBAC8\uBAD8\uBAD9" + //  6670 -  6679
                "\uBAFC\uFFFD\uB96B\uB96D\uB974\uB975\uB978\uB97C\uB984\uB985" + //  6680 -  6689
                "\uB987\uB989\uB98A\uB98D\uB98E\uB9AC\uB9AD\uB9B0\uB9B4\uB9BC" + //  6690 -  6699
                "\uB9BD\uB9BF\uB9C1\uB9C8\uB9C9\uB9CC\uB9CE\uB9CF\uB9D0\uB9D1" + //  6700 -  6709
                "\uB9D2\uB9D8\uB9D9\uB9DB\uB9DD\uB9DE\uB9E1\uB9E3\uB9E4\uB9E5" + //  6710 -  6719
                "\uB9E8\uB9EC\uB9F4\uB9F5\uB9F7\uB9F8\uB9F9\uB9FA\uBA00\uBA01" + //  6720 -  6729
                "\uBA08\uBA15\uBA38\uBA39\uBA3C\uBA40\uBA42\uBA48\uBA49\uBA4B" + //  6730 -  6739
                "\uBA4D\uBA4E\uBA53\uBA54\uBA55\uB8C5\uB8CC\uB8D0\uB8D4\uB8DD" + //  6740 -  6749
                "\uB8DF\uB8E1\uB8E8\uB8E9\uB8EC\uB8F0\uB8F8\uB8F9\uB8FB\uB8FD" + //  6750 -  6759
                "\uB904\uB918\uB920\uB93C\uB93D\uB940\uB944\uB94C\uB94F\uB951" + //  6760 -  6769
                "\uB958\uB959\uB95C\uB960\uB968\uB969\uFFFD\uB798\uB799\uB79C" + //  6770 -  6779
                "\uB7A0\uB7A8\uB7A9\uB7AB\uB7AC\uB7AD\uB7B4\uB7B5\uB7B8\uB7C7" + //  6780 -  6789
                "\uB7C9\uB7EC\uB7ED\uB7F0\uB7F4\uB7FC\uB7FD\uB7FF\uB800\uB801" + //  6790 -  6799
                "\uB807\uB808\uB809\uB80C\uB810\uB818\uB819\uB81B\uB81D\uB824" + //  6800 -  6809
                "\uB825\uB828\uB82C\uB834\uB835\uB837\uB838\uB839\uB840\uB844" + //  6810 -  6819
                "\uB851\uB853\uB85C\uB85D\uB860\uB864\uB86C\uB86D\uB86F\uB871" + //  6820 -  6829
                "\uB878\uB87C\uB88D\uB8A8\uB8B0\uB8B4\uB8B8\uB8C0\uB8C1\uB8C3" + //  6830 -  6839
                "\uB729\uB72C\uB72F\uB730\uB738\uB739\uB73B\uB744\uB748\uB74C" + //  6840 -  6849
                "\uB754\uB755\uB760\uB764\uB768\uB770\uB771\uB773\uB775\uB77C" + //  6850 -  6859
                "\uB77D\uB780\uB784\uB78C\uB78D\uB78F\uB790\uB791\uB792\uB796" + //  6860 -  6869
                "\uB797\uFFFD\uB540\uB541\uB543\uB544\uB545\uB54B\uB54C\uB54D" + //  6870 -  6879
                "\uB550\uB554\uB55C\uB55D\uB55F\uB560\uB561\uB5A0\uB5A1\uB5A4" + //  6880 -  6889
                "\uB5A8\uB5AA\uB5AB\uB5B0\uB5B1\uB5B3\uB5B4\uB5B5\uB5BB\uB5BC" + //  6890 -  6899
                "\uB5BD\uB5C0\uB5C4\uB5CC\uB5CD\uB5CF\uB5D0\uB5D1\uB5D8\uB5EC" + //  6900 -  6909
                "\uB610\uB611\uB614\uB618\uB625\uB62C\uB634\uB648\uB664\uB668" + //  6910 -  6919
                "\uB69C\uB69D\uB6A0\uB6A4\uB6AB\uB6AC\uB6B1\uB6D4\uB6F0\uB6F4" + //  6920 -  6929
                "\uB6F8\uB700\uB701\uB705\uB728\uB4C0\uB4C4\uB4C8\uB4D0\uB4D5" + //  6930 -  6939
                "\uB4DC\uB4DD\uB4E0\uB4E3\uB4E4\uB4E6\uB4EC\uB4ED\uB4EF\uB4F1" + //  6940 -  6949
                "\uB4F8\uB514\uB515\uB518\uB51B\uB51C\uB524\uB525\uB527\uB528" + //  6950 -  6959
                "\uB529\uB52A\uB530\uB531\uB534\uB538\uFFFD\uB367\uB369\uB36B" + //  6960 -  6969
                "\uB36E\uB370\uB371\uB374\uB378\uB380\uB381\uB383\uB384\uB385" + //  6970 -  6979
                "\uB38C\uB390\uB394\uB3A0\uB3A1\uB3A8\uB3AC\uB3C4\uB3C5\uB3C8" + //  6980 -  6989
                "\uB3CB\uB3CC\uB3CE\uB3D0\uB3D4\uB3D5\uB3D7\uB3D9\uB3DB\uB3DD" + //  6990 -  6999
                "\uB3E0\uB3E4\uB3E8\uB3FC\uB410\uB418\uB41C\uB420\uB428\uB429" + //  7000 -  7009
                "\uB42B\uB434\uB450\uB451\uB454\uB458\uB460\uB461\uB463\uB465" + //  7010 -  7019
                "\uB46C\uB480\uB488\uB49D\uB4A4\uB4A8\uB4AC\uB4B5\uB4B7\uB4B9" + //  7020 -  7029
                "\uB2EE\uB2EF\uB2F3\uB2F4\uB2F5\uB2F7\uB2F8\uB2F9\uB2FA\uB2FB" + //  7030 -  7039
                "\uB2FF\uB300\uB301\uB304\uB308\uB310\uB311\uB313\uB314\uB315" + //  7040 -  7049
                "\uB31C\uB354\uB355\uB356\uB358\uB35B\uB35C\uB35E\uB35F\uB364" + //  7050 -  7059
                "\uB365\uFFFD\uB1DF\uB1E8\uB1E9\uB1EC\uB1F0\uB1F9\uB1FB\uB1FD" + //  7060 -  7069
                "\uB204\uB205\uB208\uB20B\uB20C\uB214\uB215\uB217\uB219\uB220" + //  7070 -  7079
                "\uB234\uB23C\uB258\uB25C\uB260\uB268\uB269\uB274\uB275\uB27C" + //  7080 -  7089
                "\uB284\uB285\uB289\uB290\uB291\uB294\uB298\uB299\uB29A\uB2A0" + //  7090 -  7099
                "\uB2A1\uB2A3\uB2A5\uB2A6\uB2AA\uB2AC\uB2B0\uB2B4\uB2C8\uB2C9" + //  7100 -  7109
                "\uB2CC\uB2D0\uB2D2\uB2D8\uB2D9\uB2DB\uB2DD\uB2E2\uB2E4\uB2E5" + //  7110 -  7119
                "\uB2E6\uB2E8\uB2EB\uB2EC\uB2ED\uB140\uB141\uB144\uB148\uB150" + //  7120 -  7129
                "\uB151\uB154\uB155\uB158\uB15C\uB160\uB178\uB179\uB17C\uB180" + //  7130 -  7139
                "\uB182\uB188\uB189\uB18B\uB18D\uB192\uB193\uB194\uB198\uB19C" + //  7140 -  7149
                "\uB1A8\uB1CC\uB1D0\uB1D4\uB1DC\uB1DD\uFFFD\uB05D\uB07C\uB07D" + //  7150 -  7159
                "\uB080\uB084\uB08C\uB08D\uB08F\uB091\uB098\uB099\uB09A\uB09C" + //  7160 -  7169
                "\uB09F\uB0A0\uB0A1\uB0A2\uB0A8\uB0A9\uB0AB\uB0AC\uB0AD\uB0AE" + //  7170 -  7179
                "\uB0AF\uB0B1\uB0B3\uB0B4\uB0B5\uB0B8\uB0BC\uB0C4\uB0C5\uB0C7" + //  7180 -  7189
                "\uB0C8\uB0C9\uB0D0\uB0D1\uB0D4\uB0D8\uB0E0\uB0E5\uB108\uB109" + //  7190 -  7199
                "\uB10B\uB10C\uB110\uB112\uB113\uB118\uB119\uB11B\uB11C\uB11D" + //  7200 -  7209
                "\uB123\uB124\uB125\uB128\uB12C\uB134\uB135\uB137\uB138\uB139" + //  7210 -  7219
                "\uAFCB\uAFCD\uAFCE\uAFD4\uAFDC\uAFE8\uAFE9\uAFF0\uAFF1\uAFF4" + //  7220 -  7229
                "\uAFF8\uB000\uB001\uB004\uB00C\uB010\uB014\uB01C\uB01D\uB028" + //  7230 -  7239
                "\uB044\uB045\uB048\uB04A\uB04C\uB04E\uB053\uB054\uB055\uB057" + //  7240 -  7249
                "\uB059\uFFFD\uAE79\uAE7B\uAE7C\uAE7D\uAE84\uAE85\uAE8C\uAEBC" + //  7250 -  7259
                "\uAEBD\uAEBE\uAEC0\uAEC4\uAECC\uAECD\uAECF\uAED0\uAED1\uAED8" + //  7260 -  7269
                "\uAED9\uAEDC\uAEE8\uAEEB\uAEED\uAEF4\uAEF8\uAEFC\uAF07\uAF08" + //  7270 -  7279
                "\uAF0D\uAF10\uAF2C\uAF2D\uAF30\uAF32\uAF34\uAF3C\uAF3D\uAF3F" + //  7280 -  7289
                "\uAF41\uAF42\uAF43\uAF48\uAF49\uAF50\uAF5C\uAF5D\uAF64\uAF65" + //  7290 -  7299
                "\uAF79\uAF80\uAF84\uAF88\uAF90\uAF91\uAF95\uAF9C\uAFB8\uAFB9" + //  7300 -  7309
                "\uAFBC\uAFC0\uAFC7\uAFC8\uAFC9\uAE0D\uAE14\uAE30\uAE31\uAE34" + //  7310 -  7319
                "\uAE37\uAE38\uAE3A\uAE40\uAE41\uAE43\uAE45\uAE46\uAE4A\uAE4C" + //  7320 -  7329
                "\uAE4D\uAE4E\uAE50\uAE54\uAE56\uAE5C\uAE5D\uAE5F\uAE60\uAE61" + //  7330 -  7339
                "\uAE65\uAE68\uAE69\uAE6C\uAE70\uAE78\uFFFD\uAD0C\uAD0D\uAD0F" + //  7340 -  7349
                "\uAD11\uAD18\uAD1C\uAD20\uAD29\uAD2C\uAD2D\uAD34\uAD35\uAD38" + //  7350 -  7359
                "\uAD3C\uAD44\uAD45\uAD47\uAD49\uAD50\uAD54\uAD58\uAD61\uAD63" + //  7360 -  7369
                "\uAD6C\uAD6D\uAD70\uAD73\uAD74\uAD75\uAD76\uAD7B\uAD7C\uAD7D" + //  7370 -  7379
                "\uAD7F\uAD81\uAD82\uAD88\uAD89\uAD8C\uAD90\uAD9C\uAD9D\uADA4" + //  7380 -  7389
                "\uADB7\uADC0\uADC1\uADC4\uADC8\uADD0\uADD1\uADD3\uADDC\uADE0" + //  7390 -  7399
                "\uADE4\uADF8\uADF9\uADFC\uADFF\uAE00\uAE01\uAE08\uAE09\uAE0B" + //  7400 -  7409
                "\uACAF\uACB0\uACB8\uACB9\uACBB\uACBC\uACBD\uACC1\uACC4\uACC8" + //  7410 -  7419
                "\uACCC\uACD5\uACD7\uACE0\uACE1\uACE4\uACE7\uACE8\uACEA\uACEC" + //  7420 -  7429
                "\uACEF\uACF0\uACF1\uACF3\uACF5\uACF6\uACFC\uACFD\uAD00\uAD04" + //  7430 -  7439
                "\uAD06\uFFFD\uAC00\uAC01\uAC04\uAC07\uAC08\uAC09\uAC0A\uAC10" + //  7440 -  7449
                "\uAC11\uAC12\uAC13\uAC14\uAC15\uAC16\uAC17\uAC19\uAC1A\uAC1B" + //  7450 -  7459
                "\uAC1C\uAC1D\uAC20\uAC24\uAC2C\uAC2D\uAC2F\uAC30\uAC31\uAC38" + //  7460 -  7469
                "\uAC39\uAC3C\uAC40\uAC4B\uAC4D\uAC54\uAC58\uAC5C\uAC70\uAC71" + //  7470 -  7479
                "\uAC74\uAC77\uAC78\uAC7A\uAC80\uAC81\uAC83\uAC84\uAC85\uAC86" + //  7480 -  7489
                "\uAC89\uAC8A\uAC8B\uAC8C\uAC90\uAC94\uAC9C\uAC9D\uAC9F\uACA0" + //  7490 -  7499
                "\uACA1\uACA8\uACA9\uACAA\uACAC\u043E\u043F\u0440\u0441\u0442" + //  7500 -  7509
                "\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044A\u044B\u044C" + //  7510 -  7519
                "\u044D\u044E\u044F\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + //  7520 -  7529
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uE1D6\uE1D7\uE1D8" + //  7530 -  7539
                "\uE1D9\uE1DA\uE1DB\uE1DC\uE1DD\uE1DE\uE1DF\uE1E0\uE1E1\uE1E2" + //  7540 -  7549
                "\uE1E3\uE1E4\uE1E5\uE1E6\uE1E7\uE1E8\uE1E9\uE1EA\uE1EB\uE1EC" + //  7550 -  7559
                "\uE1ED\uE1EE\uE1EF\uE1F0\uE1F1\uE1F2\uE1F3\uE1F4\u042E\u042F" + //  7560 -  7569
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + //  7570 -  7579
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\u0430\u0431\u0432\u0433\u0434" + //  7580 -  7589
                "\u0435\u0451\u0436\u0437\u0438\u0439\u043A\u043B\u043C\u043D" + //  7590 -  7599
                "\u30E0\u30E1\u30E2\u30E3\u30E4\u30E5\u30E6\u30E7\u30E8\u30E9" + //  7600 -  7609
                "\u30EA\u30EB\u30EC\u30ED\u30EE\u30EF\u30F0\u30F1\u30F2\u30F3" + //  7610 -  7619
                "\u30F4\u30F5\u30F6\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + //  7620 -  7629
                "\uFFFD\uFFFD\uE292\uE293\uE294\uE295\uE296\uE297\uE298\uE299" + //  7630 -  7639
                "\uE29A\uE29B\uE29C\uE29D\uE29E\uE29F\uE2A0\uE2A1\uE2A2\uE2A3" + //  7640 -  7649
                "\uE2A4\uE2A5\uE2A6\uE2A7\uE2A8\uE2A9\uE2AA\uE2AB\uE2AC\uE2AD" + //  7650 -  7659
                "\uE2AE\uE2AF\uE2B0\u30C0\u30C1\u30C2\u30C3\u30C4\u30C5\u30C6" + //  7660 -  7669
                "\u30C7\u30C8\u30C9\u30CA\u30CB\u30CC\u30CD\u30CE\u30CF\u30D0" + //  7670 -  7679
                "\u30D1\u30D2\u30D3\u30D4\u30D5\u30D6\u30D7\u30D8\u30D9\u30DA" + //  7680 -  7689
                "\u30DB\u30DC\u30DD\u30DE\u30DF\u3080\u3081\u3082\u3083\u3084" + //  7690 -  7699
                "\u3085\u3086\u3087\u3088\u3089\u308A\u308B\u308C\u308D\u308E" + //  7700 -  7709
                "\u308F\u3090\u3091\u3092\u3093\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + //  7710 -  7719
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uE234\uE235\uE236" + //  7720 -  7729
                "\uE237\uE238\uE239\uE23A\uE23B\uE23C\uE23D\uE23E\uE23F\uE240" + //  7730 -  7739
                "\uE241\uE242\uE243\uE244\uE245\uE246\uE247\uE248\uE249\uE24A" + //  7740 -  7749
                "\uE24B\uE24C\uE24D\uE24E\uE24F\uE250\uE251\uE252\u3060\u3061" + //  7750 -  7759
                "\u3062\u3063\u3064\u3065\u3066\u3067\u3068\u3069\u306A\u306B" + //  7760 -  7769
                "\u306C\u306D\u306E\u306F\u3070\u3071\u3072\u3073\u3074\u3075" + //  7770 -  7779
                "\u3076\u3077\u3078\u3079\u307A\u307B\u307C\u307D\u307E\u307F" + //  7780 -  7789
                "\u24AF\u24B0\u24B1\u24B2\u24B3\u24B4\u24B5\u2474\u2475\u2476" + //  7790 -  7799
                "\u2477\u2478\u2479\u247A\u247B\u247C\u247D\u247E\u247F\u2480" + //  7800 -  7809
                "\u2481\u2482\u00B9\u00B2\u00B3\u2074\u207F\u2081\u2082\u2083" + //  7810 -  7819
                "\u2084\uFFFD\u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416" + //  7820 -  7829
                "\u0417\u0418\u0419\u041A\u041B\u041C\u041D\u041E\u041F\u0420" + //  7830 -  7839
                "\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042A" + //  7840 -  7849
                "\u042B\u042C\u042D\u320F\u3210\u3211\u3212\u3213\u3214\u3215" + //  7850 -  7859
                "\u3216\u3217\u3218\u3219\u321A\u321B\u249C\u249D\u249E\u249F" + //  7860 -  7869
                "\u24A0\u24A1\u24A2\u24A3\u24A4\u24A5\u24A6\u24A7\u24A8\u24A9" + //  7870 -  7879
                "\u24AA\u24AB\u24AC\u24AD\u24AE\u24E3\u24E4\u24E5\u24E6\u24E7" + //  7880 -  7889
                "\u24E8\u24E9\u2460\u2461\u2462\u2463\u2464\u2465\u2466\u2467" + //  7890 -  7899
                "\u2468\u2469\u246A\u246B\u246C\u246D\u246E\u00BD\u2153\u2154" + //  7900 -  7909
                "\u00BC\u00BE\u215B\u215C\u215D\u215E\uFFFD\u30A1\u30A2\u30A3" + //  7910 -  7919
                "\u30A4\u30A5\u30A6\u30A7\u30A8\u30A9\u30AA\u30AB\u30AC\u30AD" + //  7920 -  7929
                "\u30AE\u30AF\u30B0\u30B1\u30B2\u30B3\u30B4\u30B5\u30B6\u30B7" + //  7930 -  7939
                "\u30B8\u30B9\u30BA\u30BB\u30BC\u30BD\u30BE\u30BF\u326F\u3270" + //  7940 -  7949
                "\u3271\u3272\u3273\u3274\u3275\u3276\u3277\u3278\u3279\u327A" + //  7950 -  7959
                "\u327B\u24D0\u24D1\u24D2\u24D3\u24D4\u24D5\u24D6\u24D7\u24D8" + //  7960 -  7969
                "\u24D9\u24DA\u24DB\u24DC\u24DD\u24DE\u24DF\u24E0\u24E1\u24E2" + //  7970 -  7979
                "\u33C5\u33AD\u33AE\u33AF\u33DB\u33A9\u33AA\u33AB\u33AC\u33DD" + //  7980 -  7989
                "\u33D0\u33D3\u33C3\u33C9\u33DC\u33C6\uFFFD\uFFFD\uFFFD\uFFFD" + //  7990 -  7999
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + //  8000 -  8009
                "\uFFFD\uFFFD\uE178\uE179\uE17A\uE17B\uE17C\uE17D\uE17E\uE17F" + //  8010 -  8019
                "\uE180\uE181\uE182\uE183\uE184\uE185\uE186\uE187\uE188\uE189" + //  8020 -  8029
                "\uE18A\uE18B\uE18C\uE18D\uE18E\uE18F\uE190\uE191\uE192\uE193" + //  8030 -  8039
                "\uE194\uE195\uE196\u33B1\u33B2\u33B3\u33B4\u33B5\u33B6\u33B7" + //  8040 -  8049
                "\u33B8\u33B9\u3380\u3381\u3382\u3383\u3384\u33BA\u33BB\u33BC" + //  8050 -  8059
                "\u33BD\u33BE\u33BF\u3390\u3391\u3392\u3393\u3394\u2126\u33C0" + //  8060 -  8069
                "\u33C1\u338A\u338B\u338C\u33D6\u2546\u2547\u2548\u2549\u254A" + //  8070 -  8079
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + //  8080 -  8089
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + //  8090 -  8099
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + //  8100 -  8109
                "\uFFFD\uFFFD\uE0BC\uE0BD\uE0BE\uE0BF\uE0C0\uE0C1\uE0C2\uE0C3" + //  8110 -  8119
                "\uE0C4\uE0C5\uE0C6\uE0C7\uE0C8\uE0C9\uE0CA\uE0CB\uE0CC\uE0CD" + //  8120 -  8129
                "\uE0CE\uE0CF\uE0D0\uE0D1\uE0D2\uE0D3\uE0D4\uE0D5\uE0D6\uE0D7" + //  8130 -  8139
                "\uE0D8\uE0D9\uE0DA\u2542\u2512\u2511\u251A\u2519\u2516\u2515" + //  8140 -  8149
                "\u250E\u250D\u251E\u251F\u2521\u2522\u2526\u2527\u2529\u252A" + //  8150 -  8159
                "\u252D\u252E\u2531\u2532\u2535\u2536\u2539\u253A\u253D\u253E" + //  8160 -  8169
                "\u2540\u2541\u2543\u2544\u2545\u3170\u3171\u3172\u3173\u3174" + //  8170 -  8179
                "\u3175\u3176\u3177\u3178\u3179\u317A\u317B\u317C\u317D\u317E" + //  8180 -  8189
                "\u317F\u3180\u3181\u3182\u3183\u3184\u3185\u3186\u3187\u3188" + //  8190 -  8199
                "\u3189\u318A\u318B\u318C\u318D\u318E\uFFFD\u3041\u3042\u3043" + //  8200 -  8209
                "\u3044\u3045\u3046\u3047\u3048\u3049\u304A\u304B\u304C\u304D" + //  8210 -  8219
                "\u304E\u304F\u3050\u3051\u3052\u3053\u3054\u3055\u3056\u3057" + //  8220 -  8229
                "\u3058\u3059\u305A\u305B\u305C\u305D\u305E\u305F\u3150\u3151" + //  8230 -  8239
                "\u3152\u3153\u3154\u3155\u3156\u3157\u3158\u3159\u315A\u315B" + //  8240 -  8249
                "\u315C\u315D\u315E\u315F\u3160\u3161\u3162\u3163\u3164\u3165" + //  8250 -  8259
                "\u3166\u3167\u3168\u3169\u316A\u316B\u316C\u316D\u316E\u316F" + //  8260 -  8269
                "\uFF40\uFF41\uFF42\uFF43\uFF44\uFF45\uFF46\uFF47\uFF48\uFF49" + //  8270 -  8279
                "\uFF4A\uFF4B\uFF4C\uFF4D\uFF4E\uFF4F\uFF50\uFF51\uFF52\uFF53" + //  8280 -  8289
                "\uFF54\uFF55\uFF56\uFF57\uFF58\uFF59\uFF5A\uFF5B\uFF5C\uFF5D" + //  8290 -  8299
                "\uFFE3\uFFFD\u00E6\u0111\u00F0\u0127\u0131\u0133\u0138\u0140" + //  8300 -  8309
                "\u0142\u00F8\u0153\u00DF\u00FE\u0167\u014B\u0149\u3200\u3201" + //  8310 -  8319
                "\u3202\u3203\u3204\u3205\u3206\u3207\u3208\u3209\u320A\u320B" + //  8320 -  8329
                "\u320C\u320D\u320E\uFF20\uFF21\uFF22\uFF23\uFF24\uFF25\uFF26" + //  8330 -  8339
                "\uFF27\uFF28\uFF29\uFF2A\uFF2B\uFF2C\uFF2D\uFF2E\uFF2F\uFF30" + //  8340 -  8349
                "\uFF31\uFF32\uFF33\uFF34\uFF35\uFF36\uFF37\uFF38\uFF39\uFF3A" + //  8350 -  8359
                "\uFF3B\uFFE6\uFF3D\uFF3E\uFF3F\u2116\u33C7\u2122\u33C2\u33D8" + //  8360 -  8369
                "\u2121\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + //  8370 -  8379
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + //  8380 -  8389
                "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uE11A\uE11B\uE11C" + //  8390 -  8399
                "\uE11D\uE11E\uE11F\uE120\uE121\uE122\uE123\uE124\uE125\uE126" + //  8400 -  8409
                "\uE127\uE128\uE129\uE12A\uE12B\uE12C\uE12D\uE12E\uE12F\uE130" + //  8410 -  8419
                "\uE131\uE132\uE133\uE134\uE135\uE136\uE137\uE138\u2663\u25C9" + //  8420 -  8429
                "\u25C8\u25A3\u25D0\u25D1\u2592\u25A4\u25A5\u25A8\u25A7\u25A6" + //  8430 -  8439
                "\u25A9\u2668\u260F\u260E\u261C\u261E\u00B6\u2020\u2021\u2195" + //  8440 -  8449
                "\u2197\u2199\u2196\u2198\u266D\u2669\u266A\u266C\u327F\u321C" + //  8450 -  8459
                "\u25A1\u25A0\u25B3\u25B2\u25BD\u25BC\u2192\u2190\u2191\u2193" + //  8460 -  8469
                "\u2194\u3013\u226A\u226B\u221A\u223D\u221D\u2235\u222B\u222C" + //  8470 -  8479
                "\u2208\u220B\u2286\u2287\u2282\u2283\u222A\u2229\u2227\u2228" + //  8480 -  8489
                "\uFFE2\uFFFD\u00C6\u00D0\u00AA\u0126\uFFFD\u0132\uFFFD\u013F" + //  8490 -  8499
                "\u0141\u00D8\u0152\u00BA\u00DE\u0166\u014A\uFFFD\u3260\u3261" + //  8500 -  8509
                "\u3262\u3263\u3264\u3265\u3266\u3267\u3268\u3269\u326A\u326B" + //  8510 -  8519
                "\u326C\u326D\u326E\u00F7\u2260\u2264\u2265\u221E\u2234\u00B0" + //  8520 -  8529
                "\u2032\u2033\u2103\u212B\uFFE0\uFFE1\uFFE5\u2642\u2640\u2220" + //  8530 -  8539
                "\u22A5\u2312\u2202\u2207\u2261\u2252\u00A7\u203B\u2606\u2605" + //  8540 -  8549
                "\u25CB\u25CF\u25CE\u25C7\u25C6\uD277\uD293\uD2CD\uD2E7\uD30A" + //  8550 -  8559
                "\uD326\uD359\uD360\uD3B2\uD3B5\uD3C7\uD424\uD4B0\uD4E9\uD505" + //  8560 -  8569
                "\uD510\uD519\uD520\uD524\uD55F\uD561\uD56C\uD571\uD5AC\uD5CF" + //  8570 -  8579
                "\uD62C\uD6A9\uD6B8\uD6D5\uD70C\uD76D\uFFFD\u3395\u3396\u3397" + //  8580 -  8589
                "\u2113\u3398\u33C4\u33A3\u33A4\u33A5\u33A6\u3399\u339A\u339B" + //  8590 -  8599
                "\u339C\u339D\u339E\u339F\u33A0\u33A1\u33A2\u33CA\u338D\u338E" + //  8600 -  8609
                "\u338F\u33CF\u3388\u3389\u33C8\u33A7\u33A8\u33B0\uCAD2\uCB2C" + //  8610 -  8619
                "\uCB80\uCBE5\uCBF0\uCC1F\uCC26\uCC2F\uCC3F\uCC42\uCC71\uCC7C" + //  8620 -  8629
                "\uCCE3\uCCE5\uCD40\uCDC3\uCE3C\uCE7B\uCE97\uCEA9\uCEC8\uCEFD" + //  8630 -  8639
                "\uCF19\uCF8D\uCF90\uCF9F\uCFAC\uCFBD\uD088\uD114\uD160\uD169" + //  8640 -  8649
                "\uC2B3\uC2C0\uC2E6\uC302\uC30B\uC327\uC330\uC343\uC34C\uC37B" + //  8650 -  8659
                "\uC385\uC399\uC3A0\uC3BC\uC3FC\uC43F\uC477\uC493\uC4D3\uC4D4" + //  8660 -  8669
                "\uC53C\uC53F\uC54F\uC55F\uC590\uC5AB\uC5B6\uC5F1\uC5F3\uC61D" + //  8670 -  8679
                "\uC62B\uFFFD\u2500\u2502\u250C\u2510\u2518\u2514\u251C\u252C" + //  8680 -  8689
                "\u2524\u2534\u253C\u2501\u2503\u250F\u2513\u251B\u2517\u2523" + //  8690 -  8699
                "\u2533\u252B\u253B\u254B\u2520\u252F\u2528\u2537\u253F\u251D" + //  8700 -  8709
                "\u2530\u2525\u2538\uBE28\uBE4B\uBE9C\uBEB4\uBEED\uBEF0\uBEF4" + //  8710 -  8719
                "\uBEFF\uBF24\uBF5C\uBF78\uBFC0\uBFD5\uBFDD\uBFE8\uC004\uC020" + //  8720 -  8729
                "\uC059\uC074\uC0AE\uC0B7\uC0BB\uC0C3\uC0C7\uC0CF\uC125\uC13F" + //  8730 -  8739
                "\uC151\uC157\uC193\uC1BB\uC28C\uB2D1\uB2E0\uB331\uB338\uB368" + //  8740 -  8749
                "\uB36A\uB39C\uB3D3\uB400\uB40F\uB42C\uB457\uB47F\uB4B4\uB4C1" + //  8750 -  8759
                "\uB4E7\uB52E\uB532\uB537\uB53F\uB568\uB584\uB5F4\uB680\uB6B8" + //  8760 -  8769
                "\uB70C\uB7D0\uB80F\uB894\uB8DC\uB917\uFFFD\u03B1\u03B2\u03B3" + //  8770 -  8779
                "\u03B4\u03B5\u03B6\u03B7\u03B8\u03B9\u03BA\u03BB\u03BC\u03BD" + //  8780 -  8789
                "\u03BE\u03BF\u03C0\u03C1\u03C3\u03C4\u03C5\u03C6\u03C7\u03C8" + //  8790 -  8799
                "\u03C9\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uE34E\uE34F" + //  8800 -  8809
                "\uE350\uE351\uE352\uE353\uE354\uE355\uE356\uE357\uE358\uE359" + //  8810 -  8819
                "\uE35A\uE35B\uE35C\uE35D\uE35E\uE35F\uE360\uE361\uE362\uE363" + //  8820 -  8829
                "\uE364\uE365\uE366\uE367\uE368\uE369\uE36A\uE36B\uE36C\uAE49" + //  8830 -  8839
                "\uAE62\uAEA0\uAF04\uAF33\uAF4C\uAF58\uAF5B\uAF68\uAF93\uAFB2" + //  8840 -  8849
                "\uAFBF\uAFD8\uAFE7\uB00D\uB021\uB060\uB090\uB0BB\uB0EC\uB10F" + //  8850 -  8859
                "\uB11E\uB147\uB153\uB159\uB16F\uB17A\uB1A7\uB1B0\uB233\uB2A7" + //  8860 -  8869
                "\uB2C1\u51B2\u6A47\uF869\u5DF5\u5FB4\u9D44\u5FF1\u62C6\u6A50" + //  8870 -  8879
                "\u99C4\uF86A\u8759\u5E96\u70AE\u8216\u924B\u9784\uF86B\u84D6" + //  8880 -  8889
                "\u8E55\u7627\uF86C\u9DF3\u7095\u5EE8\uF86D\u7BCB\uF86E\u769E" + //  8890 -  8899
                "\u9190\u9DBB\uFFFD\u0391\u0392\u0393\u0394\u0395\u0396\u0397" + //  8900 -  8909
                "\u0398\u0399\u039A\u039B\u039C\u039D\u039E\u039F\u03A0\u03A1" + //  8910 -  8919
                "\u03A3\u03A4\u03A5\u03A6\u03A7\u03A8\u03A9\uFFFD\uFFFD\uFFFD" + //  8920 -  8929
                "\uFFFD\uFFFD\uFFFD\uFFFD\uE2F0\uE2F1\uE2F2\uE2F3\uE2F4\uE2F5" + //  8930 -  8939
                "\uE2F6\uE2F7\uE2F8\uE2F9\uE2FA\uE2FB\uE2FC\uE2FD\uE2FE\uE2FF" + //  8940 -  8949
                "\uE300\uE301\uE302\uE303\uE304\uE305\uE306\uE307\uE308\uE309" + //  8950 -  8959
                "\uE30A\uE30B\uE30C\uE30D\uE30E\u75E3\uF865\u615A\u5231\u60B5" + //  8960 -  8969
                "\u6C05\u7C00\u8734\u8E91\u6FFA\u7C37\u873B\u780C\u9746\u5CED" + //  8970 -  8979
                "\u7D83\u9214\u9798\uF866\u8E85\u9AD1\u6031\u8471\u6467\uF867" + //  8980 -  8989
                "\u7503\u7B92\u97A6\u9E81\u9EA4\uF868\u8233\u9C2E\u8558\u8202" + //  8990 -  8999
                "\u86F9\u5401\u71A8\u873F\u5E43\u885E\u56FF\u5E37\u8564\u9EDD" + //  9000 -  9009
                "\u9B3B\u6ABC\u73E2\u9F66\u6339\u682E\u9823\u4EDE\u7725\u7CA2" + //  9010 -  9019
                "\u8014\u89DC\u8D6D\u67DE\u6F5C\u8695\u5D82\u7634\uFFFD\u2170" + //  9020 -  9029
                "\u2171\u2172\u2173\u2174\u2175\u2176\u2177\u2178\u2179\uFFFD" + //  9030 -  9039
                "\uFFFD\uFFFD\uFFFD\uFFFD\u2160\u2161\u2162\u2163\u2164\u2165" + //  9040 -  9049
                "\u2166\u2167\u2168\u2169\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + //  9050 -  9059
                "\uE3AC\uE3AD\uE3AE\uE3AF\uE3B0\uE3B1\uE3B2\uE3B3\uE3B4\uE3B5" + //  9060 -  9069
                "\uE3B6\uE3B7\uE3B8\uE3B9\uE3BA\uE3BB\uE3BC\uE3BD\uE3BE\uE3BF" + //  9070 -  9079
                "\uE3C0\uE3C1\uE3C2\uE3C3\uE3C4\uE3C5\uE3C6\uE3C7\uE3C8\uE3C9" + //  9080 -  9089
                "\uE3CA\u9D08\u621E\u904F\u5D52\u8AF3\u9EEF\u9785\u6B38\u769A" + //  9090 -  9099
                "\u7919\u9749\u9628\uF860\u7BDB\u7C65\u7F98\u6554\u605A\uF861" + //  9100 -  9109
                "\uF862\u81D9\u8815\u8B8C\u5869\u995C\u5B30\u7768\u7FF3\u854B" + //  9110 -  9119
                "\u9068\u5ABC\u8580\uF851\u8561\uF852\u9AF4\u9EFB\u59A3\uF853" + //  9120 -  9129
                "\u6C98\u7765\u7BE6\u8153\u8F61\u9AC0\u64EF\u860B\uF854\u9870" + //  9130 -  9139
                "\u9B22\u59D2\uF855\u6942\u69CE\u7B25\u69CA\u9460\u6B43\u9364" + //  9140 -  9149
                "\u970E\u6BA4\u9C13\u566C\uFFFD\u3131\u3132\u3133\u3134\u3135" + //  9150 -  9159
                "\u3136\u3137\u3138\u3139\u313A\u313B\u313C\u313D\u313E\u313F" + //  9160 -  9169
                "\u3140\u3141\u3142\u3143\u3144\u3145\u3146\u3147\u3148\u3149" + //  9170 -  9179
                "\u314A\u314B\u314C\u314D\u314E\u314F\u927E\u6FDB\u77C7\u7030" + //  9180 -  9189
                "\u7CDC\u95A9\uF84E\u6B02\u7254\u80D6\u9AE3\u9B74\uF84F\u7FFB" + //  9190 -  9199
                "\u8F9F\u6C74\u8FAE\uF850\u99E2\u5F46\u8FF8\u9D07\u9EFC\u8760" + //  9200 -  9209
                "\u4E30\u8451\u4EC6\u7F58\u82FB\u8709\u982B\u9B92\u95E5\u97C3" + //  9210 -  9219
                "\u515A\u87F7\u7893\u83DF\u5484\u578C\u809A\u86AA\u6ED5\u706F" + //  9220 -  9229
                "\u9419\u7296\u5E71\u57D3\u6994\u6DBC\u9B4E\u7658\u8182\u8821" + //  9230 -  9239
                "\u9462\u6ADF\u9B23\u6624\u6CE0\u82D3\u86C9\u6F66\u826B\uFFFD" + //  9240 -  9249
                "\uFF01\uFF02\uFF03\uFF04\uFF05\uFF06\uFF07\uFF08\uFF09\uFF0A" + //  9250 -  9259
                "\uFF0B\uFF0C\uFF0D\uFF0E\uFF0F\uFF10\uFF11\uFF12\uFF13\uFF14" + //  9260 -  9269
                "\uFF15\uFF16\uFF17\uFF18\uFF19\uFF1A\uFF1B\uFF1C\uFF1D\uFF1E" + //  9270 -  9279
                "\uFF1F\u874C\u970D\u76E5\u9E1B\u9278\u4F5D\u50B4\u5ABE\u5AD7" + //  9280 -  9289
                "\uF846\u750C\u89AF\u98B6\u63AC\u8DEA\u5DF9\u6F0C\u5C8C\u7B08" + //  9290 -  9299
                "\uF847\u9C2D\uF848\u7CEF\u5583\u66E9\u8FFA\u4F5E\uF849\u5B65" + //  9300 -  9309
                "\uF84A\u977C\u601B\uE4A7\uE4A8\uE4A9\uE4AA\uE4AB\uE4AC\uE4AD" + //  9310 -  9319
                "\uE4AE\uE4AF\uE4B0\uE4B1\uE4B2\uE4B3\uE4B4\uE4B5\uE4B6\uE4B7" + //  9320 -  9329
                "\uE4B8\uE4B9\uE4BA\uE4BB\uE4BC\uE4BD\uE4BE\uE4BF\uE4C0\uE4C1" + //  9330 -  9339
                "\uE4C2\uE4C3\uE4C4\uE4C5\uFFFD\u21D2\u21D4\u2200\u2203\u00B4" + //  9340 -  9349
                "\u02DC\u02C7\u02D8\u02DD\u02DA\u02D9\u00B8\u02DB\u00A1\u00BF" + //  9350 -  9359
                "\u02D0\u222E\u2211\u220F\u00A4\u2109\u2030\u25C1\u25C0\u25B7" + //  9360 -  9369
                "\u25B6\u2664\u2660\u2661\u2665\u2667\uE487\uE488\uE489\uE48A" + //  9370 -  9379
                "\uE48B\uE48C\uE48D\uE48E\uE48F\uE490\uE491\uE492\uE493\uE494" + //  9380 -  9389
                "\uE495\uE496\uE497\uE498\uE499\uE49A\uE49B\uE49C\uE49D\uE49E" + //  9390 -  9399
                "\uE49F\uE4A0\uE4A1\uE4A2\uE4A3\uE4A4\uE4A5\uE4A6\uE449\uE44A" + //  9400 -  9409
                "\uE44B\uE44C\uE44D\uE44E\uE44F\uE450\uE451\uE452\uE453\uE454" + //  9410 -  9419
                "\uE455\uE456\uE457\uE458\uE459\uE45A\uE45B\uE45C\uE45D\uE45E" + //  9420 -  9429
                "\uE45F\uE460\uE461\uE462\uE463\uE464\uE465\uE466\uE467\uFFFD" + //  9430 -  9439
                "\u3000\u3001\u3002\u30FB\u2025\u2026\u00A8\u3003\u2010\u2014" + //  9440 -  9449
                "\u2225\uFF3C\u301C\u2018\u2019\u201C\u201D\u3014\u3015\u3008" + //  9450 -  9459
                "\u3009\u300A\u300B\u300C\u300D\u300E\u300F\u3010\u3011\u00B1" + //  9460 -  9469
                "\u00D7\uE429\uE42A\uE42B\uE42C\uE42D\uE42E\uE42F\uE430\uE431" + //  9470 -  9479
                "\uE432\uE433\uE434\uE435\uE436\uE437\uE438\uE439\uE43A\uE43B" + //  9480 -  9489
                "\uE43C\uE43D\uE43E\uE43F\uE440\uE441\uE442\uE443\uE444\uE445" + //  9490 -  9499
                "\uE446\uE447\uE448\uE3EB\uE3EC\uE3ED\uE3EE\uE3EF\uE3F0\uE3F1" + //  9500 -  9509
                "\uE3F2\uE3F3\uE3F4\uE3F5\uE3F6\uE3F7\uE3F8\uE3F9\uE3FA\uE3FB" + //  9510 -  9519
                "\uE3FC\uE3FD\uE3FE\uE3FF\uE400\uE401\uE402\uE403\uE404\uE405" + //  9520 -  9529
                "\uE406\uE407\uE408\uE409\uFFFD\uC63A\uC6B7\uC6DF\uC70B\uC736" + //  9530 -  9539
                "\uC77B\uC7A7\uC7AA\uC807\uC814\uC81B\uC839\uC84B\uC890\uC89C" + //  9540 -  9549
                "\uC8A0\uC8AC\uC8B0\uC8B8\uC8E8\uC8F0\uC8F1\uC92B\uC96D\uC9A4" + //  9550 -  9559
                "\uC9D4\uCA30\uCA57\uCA70\uCA97\uCAA0\uE3CB\uE3CC\uE3CD\uE3CE" + //  9560 -  9569
                "\uE3CF\uE3D0\uE3D1\uE3D2\uE3D3\uE3D4\uE3D5\uE3D6\uE3D7\uE3D8" + //  9570 -  9579
                "\uE3D9\uE3DA\uE3DB\uE3DC\uE3DD\uE3DE\uE3DF\uE3E0\uE3E1\uE3E2" + //  9580 -  9589
                "\uE3E3\uE3E4\uE3E5\uE3E6\uE3E7\uE3E8\uE3E9\uE3EA\uE38D\uE38E" + //  9590 -  9599
                "\uE38F\uE390\uE391\uE392\uE393\uE394\uE395\uE396\uE397\uE398" + //  9600 -  9609
                "\uE399\uE39A\uE39B\uE39C\uE39D\uE39E\uE39F\uE3A0\uE3A1\uE3A2" + //  9610 -  9619
                "\uE3A3\uE3A4\uE3A5\uE3A6\uE3A7\uE3A8\uE3A9\uE3AA\uE3AB\uFFFD" + //  9620 -  9629
                "\uB990\uB9DF\uB9FB\uBA1C\uBA6B\uBA6D\uBA80\uBAAF\uBAC3\uBAE0" + //  9630 -  9639
                "\uBBC1\uBBD5\uBBDC\uBBE0\uBC0E\uBC28\uBC37\uBC5C\uBC68\uBC98" + //  9640 -  9649
                "\uBC9C\uBCB9\uBCCC\uBCD2\uBCD3\uBCD4\uBD23\uBD97\uBDB4\uBE18" + //  9650 -  9659
                "\uBE21\uE36D\uE36E\uE36F\uE370\uE371\uE372\uE373\uE374\uE375" + //  9660 -  9669
                "\uE376\uE377\uE378\uE379\uE37A\uE37B\uE37C\uE37D\uE37E\uE37F" + //  9670 -  9679
                "\uE380\uE381\uE382\uE383\uE384\uE385\uE386\uE387\uE388\uE389" + //  9680 -  9689
                "\uE38A\uE38B\uE38C\uE32F\uE330\uE331\uE332\uE333\uE334\uE335" + //  9690 -  9699
                "\uE336\uE337\uE338\uE339\uE33A\uE33B\uE33C\uE33D\uE33E\uE33F" + //  9700 -  9709
                "\uE340\uE341\uE342\uE343\uE344\uE345\uE346\uE347\uE348\uE349" + //  9710 -  9719
                "\uE34A\uE34B\uE34C\uE34D\uFFFD\u944A\u571C\u61FD\u9B1F\u5A93" + //  9720 -  9729
                "\u6033\u56C2\u7334\u7BCC\u5FFB\u8FC4\u9821\uAC02\uAC0B\uAC79" + //  9730 -  9739
                "\uAC87\uAC93\uACE9\uACFA\uAD19\uAD28\uAD2B\uAD9B\uADD5\uADEC" + //  9740 -  9749
                "\uAE02\uAE0F\uAE11\uAE27\uAE3C\uAE44\uE30F\uE310\uE311\uE312" + //  9750 -  9759
                "\uE313\uE314\uE315\uE316\uE317\uE318\uE319\uE31A\uE31B\uE31C" + //  9760 -  9769
                "\uE31D\uE31E\uE31F\uE320\uE321\uE322\uE323\uE324\uE325\uE326" + //  9770 -  9779
                "\uE327\uE328\uE329\uE32A\uE32B\uE32C\uE32D\uE32E\uE2D1\uE2D2" + //  9780 -  9789
                "\uE2D3\uE2D4\uE2D5\uE2D6\uE2D7\uE2D8\uE2D9\uE2DA\uE2DB\uE2DC" + //  9790 -  9799
                "\uE2DD\uE2DE\uE2DF\uE2E0\uE2E1\uE2E2\uE2E3\uE2E4\uE2E5\uE2E6" + //  9800 -  9809
                "\uE2E7\uE2E8\uE2E9\uE2EA\uE2EB\uE2EC\uE2ED\uE2EE\uE2EF\uFFFD" + //  9810 -  9819
                "\u88C5\u7E94\u67E2\u86C6\u8C6C\u7CF4\u56C0\u5DD3\u78DA\u7FE6" + //  9820 -  9829
                "\u7A83\u6904\u6883\u6662\u7445\u8E36\uF863\u566A\u7681\u7AC8" + //  9830 -  9839
                "\u7B0A\u7CF6\u7D5B\u9BDB\u6A05\u8E64\u851F\u8098\u96BC\uF864" + //  9840 -  9849
                "\u8A3C\uE2B1\uE2B2\uE2B3\uE2B4\uE2B5\uE2B6\uE2B7\uE2B8\uE2B9" + //  9850 -  9859
                "\uE2BA\uE2BB\uE2BC\uE2BD\uE2BE\uE2BF\uE2C0\uE2C1\uE2C2\uE2C3" + //  9860 -  9869
                "\uE2C4\uE2C5\uE2C6\uE2C7\uE2C8\uE2C9\uE2CA\uE2CB\uE2CC\uE2CD" + //  9870 -  9879
                "\uE2CE\uE2CF\uE2D0\uE273\uE274\uE275\uE276\uE277\uE278\uE279" + //  9880 -  9889
                "\uE27A\uE27B\uE27C\uE27D\uE27E\uE27F\uE280\uE281\uE282\uE283" + //  9890 -  9899
                "\uE284\uE285\uE286\uE287\uE288\uE289\uE28A\uE28B\uE28C\uE28D" + //  9900 -  9909
                "\uE28E\uE28F\uE290\uE291\uFFFD\u5A7F\uF856\uF857\uF858\u5C20" + //  9910 -  9919
                "\u6103\uF859\u71F9\uF85A\u5070\uF85B\u6308\u8258\u9704\u87C0" + //  9920 -  9929
                "\u7463\u53DF\uF85C\u666C\u6EB2\u795F\uF85D\u9D89\u8671\u557B" + //  9930 -  9939
                "\uF85E\u7DE6\u77E7\uF85F\u843C\u8D0B\uE253\uE254\uE255\uE256" + //  9940 -  9949
                "\uE257\uE258\uE259\uE25A\uE25B\uE25C\uE25D\uE25E\uE25F\uE260" + //  9950 -  9959
                "\uE261\uE262\uE263\uE264\uE265\uE266\uE267\uE268\uE269\uE26A" + //  9960 -  9969
                "\uE26B\uE26C\uE26D\uE26E\uE26F\uE270\uE271\uE272\uE215\uE216" + //  9970 -  9979
                "\uE217\uE218\uE219\uE21A\uE21B\uE21C\uE21D\uE21E\uE21F\uE220" + //  9980 -  9989
                "\uE221\uE222\uE223\uE224\uE225\uE226\uE227\uE228\uE229\uE22A" + //  9990 -  9999
                "\uE22B\uE22C\uE22D\uE22E\uE22F\uE230\uE231\uE232\uE233\uFFFD" + // 10000 - 10009
                "\u8F64\u6F09\uF84B\u8F46\u7C5F\u857E\u8A84\uF84C\u50C2\u9ACF" + // 10010 - 10019
                "\u7ABF\u51DB\u5EE9\uF84D\u6F13\u79BB\u87AD\u9B51\u75F3\u5CA6" + // 10020 - 10029
                "\u5ABD\u87C7\u8B3E\u93DD\u9B18\u9B4D\u771B\u82FA\u8109\u4FDB" + // 10030 - 10039
                "\u8004\uE1F5\uE1F6\uE1F7\uE1F8\uE1F9\uE1FA\uE1FB\uE1FC\uE1FD" + // 10040 - 10049
                "\uE1FE\uE1FF\uE200\uE201\uE202\uE203\uE204\uE205\uE206\uE207" + // 10050 - 10059
                "\uE208\uE209\uE20A\uE20B\uE20C\uE20D\uE20E\uE20F\uE210\uE211" + // 10060 - 10069
                "\uE212\uE213\uE214\uE1B7\uE1B8\uE1B9\uE1BA\uE1BB\uE1BC\uE1BD" + // 10070 - 10079
                "\uE1BE\uE1BF\uE1C0\uE1C1\uE1C2\uE1C3\uE1C4\uE1C5\uE1C6\uE1C7" + // 10080 - 10089
                "\uE1C8\uE1C9\uE1CA\uE1CB\uE1CC\uE1CD\uE1CE\uE1CF\uE1D0\uE1D1" + // 10090 - 10099
                "\uE1D2\uE1D3\uE1D4\uE1D5\uFFFD\uE4C6\uE4C7\uE4C8\uE4C9\uE4CA" + // 10100 - 10109
                "\u01C2\u2266\u2267\u212A\uFFE4\u02BA\uF843\u64F1\u7FAF\u9163" + // 10110 - 10119
                "\uF844\u9ABC\u84B9\u54FD\u6243\u6AA0\u71B2\u754A\uF845\u96DE" + // 10120 - 10129
                "\u6772\u77BD\u8A41\u6831\u69D3\u7B9C\uE197\uE198\uE199\uE19A" + // 10130 - 10139
                "\uE19B\uE19C\uE19D\uE19E\uE19F\uE1A0\uE1A1\uE1A2\uE1A3\uE1A4" + // 10140 - 10149
                "\uE1A5\uE1A6\uE1A7\uE1A8\uE1A9\uE1AA\uE1AB\uE1AC\uE1AD\uE1AE" + // 10150 - 10159
                "\uE1AF\uE1B0\uE1B1\uE1B2\uE1B3\uE1B4\uE1B5\uE1B6\uE159\uE15A" + // 10160 - 10169
                "\uE15B\uE15C\uE15D\uE15E\uE15F\uE160\uE161\uE162\uE163\uE164" + // 10170 - 10179
                "\uE165\uE166\uE167\uE168\uE169\uE16A\uE16B\uE16C\uE16D\uE16E" + // 10180 - 10189
                "\uE16F\uE170\uE171\uE172\uE173\uE174\uE175\uE176\uE177\uFFFD" + // 10190 - 10199
                "\uE468\uE469\uE46A\uE46B\uE46C\uE46D\uE46E\uE46F\uE470\uE471" + // 10200 - 10209
                "\uE472\uE473\uE474\uE475\uE476\uE477\uE478\uE479\uE47A\uE47B" + // 10210 - 10219
                "\uE47C\uE47D\uE47E\uE47F\uE480\uE481\uE482\uE483\uE484\uE485" + // 10220 - 10229
                "\uE486\uE139\uE13A\uE13B\uE13C\uE13D\uE13E\uE13F\uE140\uE141" + // 10230 - 10239
                "\uE142\uE143\uE144\uE145\uE146\uE147\uE148\uE149\uE14A\uE14B" + // 10240 - 10249
                "\uE14C\uE14D\uE14E\uE14F\uE150\uE151\uE152\uE153\uE154\uE155" + // 10250 - 10259
                "\uE156\uE157\uE158\uE0FB\uE0FC\uE0FD\uE0FE\uE0FF\uE100\uE101" + // 10260 - 10269
                "\uE102\uE103\uE104\uE105\uE106\uE107\uE108\uE109\uE10A\uE10B" + // 10270 - 10279
                "\uE10C\uE10D\uE10E\uE10F\uE110\uE111\uE112\uE113\uE114\uE115" + // 10280 - 10289
                "\uE116\uE117\uE118\uE119\uFFFD\uE40A\uE40B\uE40C\uE40D\uE40E" + // 10290 - 10299
                "\uE40F\uE410\uE411\uE412\uE413\uE414\uE415\uE416\uE417\uE418" + // 10300 - 10309
                "\uE419\uE41A\uE41B\uE41C\uE41D\uE41E\uE41F\uE420\uE421\uE422" + // 10310 - 10319
                "\uE423\uE424\uE425\uE426\uE427\uE428\uE0DB\uE0DC\uE0DD\uE0DE" + // 10320 - 10329
                "\uE0DF\uE0E0\uE0E1\uE0E2\uE0E3\uE0E4\uE0E5\uE0E6\uE0E7\uE0E8" + // 10330 - 10339
                "\uE0E9\uE0EA\uE0EB\uE0EC\uE0ED\uE0EE\uE0EF\uE0F0\uE0F1\uE0F2" + // 10340 - 10349
                "\uE0F3\uE0F4\uE0F5\uE0F6\uE0F7\uE0F8\uE0F9\uE0FA"
                ;

    }

    protected static class Encoder extends CharsetEncoder {

        private static final char SBase = '\uAC00';
        private static final char LBase = '\u1100';
        private static final char VBase = '\u1161';
        private static final char TBase = '\u11A7';
        private static final int  VCount = 21;
        private static final int  TCount = 28;
        private static final byte G0 = 0;
        private static final byte G1 = 1;
        private static final byte G2 = 2;
        private static final byte G3 = 3;
        private byte   charState = G0;
        private char   l, v, t;

        private int  mask1;
        private int  mask2;
        private int  shift;

        private final Surrogate.Parser sgp = new Surrogate.Parser();

        public Encoder(Charset cs) {
            super(cs, 2.0f, 2.0f);
            mask1 = 0xFFF8;
            mask2 = 0x0007;
            shift = 3;
        }

        protected Encoder(Charset cs, String modIdx2a) {
            super(cs, 2.0f, 2.0f);
            mask1 = 0xFFF8;
            mask2 = 0x0007;
            shift = 3;
            index1 = index1;
            index2 = index2;
            index2a = modIdx2a;
        }

        /**
         * Returns true if the given character can be converted to the
         * target character encoding.
         */

        public boolean canEncode(char ch) {
           int  index;
           int  theBytes;

           index = index1[((ch & mask1) >> shift)] + (ch & mask2);
           if (index < 15000)
             theBytes = (int)(index2.charAt(index));
           else
             theBytes = (int)(index2a.charAt(index-15000));

           if (theBytes != 0)
              return (true);

           // only return true if input char was unicode null - all others are
           //    undefined
           return( ch == '\u0000');
        }

        private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            char[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            int outputSize = 0;         // size of output
            byte[] outputBytes = new byte[2];

            boolean needsFlushing = false;

            try {
                while (sp < sl) {
                char inputChar = sa[sp];

                // Reject surrogates
                if (sgp.parse(inputChar, sa, sp, sl) < 0)
                    return sgp.error();
                if (Surrogate.is(inputChar))
                        return sgp.unmappableResult();

                switch (charState) {
                case G0:
                    l = LBase;
                    v = VBase;
                    t = TBase;

                    if ( isLeadingC(inputChar) ) {     // Leading Consonant
                        l = inputChar;
                        charState = G1;
                        break;
                    }

                    if ( isVowel(inputChar) ) {        // Vowel
                        v = inputChar;
                        charState = G2;
                        break;
                    }

                    if ( isTrailingC(inputChar) ) {    // Trailing Consonant
                        t = inputChar;
                        charState = G3;
                        break;
                    }

                    break;

                    case G1:
                        if ( isLeadingC(inputChar) ) {     // Leading Consonant
                            l = composeLL(l, inputChar);
                            needsFlushing = true;
                        break;
                        }

                        if ( isVowel(inputChar) ) {        // Vowel
                            v = inputChar;
                            charState = G2;
                            needsFlushing = true;
                            break;
                        }

                        if ( isTrailingC(inputChar) ) {    // Trailing Consonant
                            t = inputChar;
                            charState = G3;
                            needsFlushing = true;
                            break;
                        }

                        charState = G0;
                        break;

                    case G2:
                        if ( isLeadingC(inputChar) ) {     // Leading Consonant
                            needsFlushing = true;

                            l = inputChar;
                            v = VBase;
                            t = TBase;
                            charState = G1;
                            break;
                        }

                        if ( isVowel(inputChar) ) {        // Vowel
                            needsFlushing = true;
                            v = composeVV(l, inputChar);
                            charState = G2;
                            break;
                        }

                        if ( isTrailingC(inputChar) ) {    // Trailing Consonant
                            needsFlushing = true;
                            t = inputChar;
                            charState = G3;
                            break;
                        }

                        charState = G0;
                        break;

                    case G3:
                        if ( isTrailingC(inputChar) ) {    // Trailing Consonant
                            needsFlushing = true;
                            t = composeTT(t, inputChar);
                            charState = G3;
                            break;
                        }

                        charState = G0;
                        break;
                  }

                  if (charState == G0 || sl - sp < 2) {
                      int spaceNeeded;

                      if (needsFlushing) {
                        needsFlushing = false;

                        outputBytes = encodeHangul(composeHangul());

                        if (outputBytes[0] == 0x00 && outputBytes[1] == 0x00
                            && inputChar != '\u0000') {
                            return CoderResult.unmappableForLength(1);
                        }

                        if (outputBytes[0] == 0x00)
                            spaceNeeded = 1;
                        else
                            spaceNeeded = 2;

                        if (dl - dp < spaceNeeded)
                             return CoderResult.OVERFLOW;
                          if (spaceNeeded == 1)
                                da[dp++] = outputBytes[1];
                          else {
                                da[dp++] = outputBytes[0];
                                da[dp++] = outputBytes[1];
                          }
                      }

                      outputBytes = encodeHangul(inputChar);

                      if (outputBytes[0] == 0x00 && outputBytes[1] == 0x00
                          && inputChar != '\u0000') {
                          return CoderResult.unmappableForLength(1);
                      }

                      if (outputBytes[0] == 0x00)
                          spaceNeeded = 1;
                      else
                          spaceNeeded = 2;

                      if (dl - dp < spaceNeeded)
                            return CoderResult.OVERFLOW;

                      if (spaceNeeded == 1)
                            da[dp++] = outputBytes[1];
                      else {
                            da[dp++] = outputBytes[0];
                            da[dp++] = outputBytes[1];
                        }
                    }
                  sp++;
                }
                return CoderResult.UNDERFLOW;
            } finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            int mark = src.position();
            int outputSize = 0;
            byte[] outputBytes = new byte[2];
            boolean needsFlushing = false;

            try {
                while (src.hasRemaining()) {
                    char inputChar = src.get();
                    if (Surrogate.is(inputChar)) {
                        if (sgp.parse(inputChar, src) < 0)
                            return sgp.error();
                    return sgp.unmappableResult();
                    }

                    if (inputChar >= '\uFFFE')
                        return CoderResult.unmappableForLength(1);

                    switch (charState) {
                    case G0:
                        l = LBase;
                        v = VBase;
                        t = TBase;

                        if ( isLeadingC(inputChar) ) {     // Leading Consonant
                            l = inputChar;
                            charState = G1;
                            break;
                        }

                        if ( isVowel(inputChar) ) {        // Vowel
                            v = inputChar;
                            charState = G2;
                            break;
                        }

                        if ( isTrailingC(inputChar) ) {    // Trailing Consonant
                            t = inputChar;
                            charState = G3;
                            break;
                        }

                        break;

                        case G1:
                            if ( isLeadingC(inputChar) ) {     // Leading Consonant
                                l = composeLL(l, inputChar);
                                needsFlushing = true;
                            break;
                            }

                            if ( isVowel(inputChar) ) {        // Vowel
                                v = inputChar;
                                charState = G2;
                                needsFlushing = true;
                                break;
                            }

                            if ( isTrailingC(inputChar) ) {    // Trailing Consonant
                                t = inputChar;
                                charState = G3;
                                needsFlushing = true;
                                break;
                            }

                            charState = G0;
                            break;

                        case G2:
                            if ( isLeadingC(inputChar) ) {     // Leading Consonant
                                needsFlushing = true;

                                l = inputChar;
                                v = VBase;
                                t = TBase;
                                charState = G1;
                                break;
                            }

                            if ( isVowel(inputChar) ) {        // Vowel
                                needsFlushing = true;
                                v = composeVV(l, inputChar);
                                charState = G2;
                                break;
                            }

                            if ( isTrailingC(inputChar) ) {    // Trailing Consonant
                                needsFlushing = true;
                                t = inputChar;
                                charState = G3;
                                break;
                            }

                            charState = G0;
                            break;

                        case G3:
                            if ( isTrailingC(inputChar) ) {    // Trailing Consonant
                                needsFlushing = true;
                                t = composeTT(t, inputChar);
                                charState = G3;
                                break;
                            }

                            charState = G0;
                            break;
                      }

                      if (charState == G0 || src.remaining() <= 0) {
                          int spaceNeeded;

                          if (needsFlushing) {
                            needsFlushing = false;

                            outputBytes = encodeHangul(composeHangul());
                            if (outputBytes[0] == 0x00
                                && outputBytes[1] == 0x00
                                && inputChar != '\u0000') {
                                return CoderResult.unmappableForLength(1);
                            }
                            if (outputBytes[0] == 0x00)
                                spaceNeeded = 1;
                            else
                                spaceNeeded = 2;

                            if (dst.remaining() < spaceNeeded)
                                 return CoderResult.OVERFLOW;
                              if (spaceNeeded == 1)
                                    dst.put(outputBytes[1]);
                              else {
                                    dst.put(outputBytes[0]);
                                    dst.put(outputBytes[1]);
                              }
                          }

                          outputBytes = encodeHangul(inputChar);
                          if (outputBytes[0] == 0x00 && outputBytes[1] == 0x00
                              && inputChar != '\u0000') {
                              return CoderResult.unmappableForLength(1);
                          }
                          if (outputBytes[0] == 0x00)
                              spaceNeeded = 1;
                          else
                              spaceNeeded = 2;

                          if (dst.remaining() < spaceNeeded)
                                return CoderResult.OVERFLOW;

                          if (spaceNeeded == 1)
                                dst.put(outputBytes[1]);
                          else {
                                dst.put(outputBytes[0]);
                                dst.put(outputBytes[1]);
                            }
                        }
                      mark++;
                }
                return CoderResult.UNDERFLOW;
            } finally {
                src.position(mark);
            }
        }

        protected void implReset() {
            charState = G0;
        }

        private char composeHangul() {
           int lIndex, vIndex, tIndex;

           lIndex = l - LBase;
           vIndex = v - VBase;
           tIndex = t - TBase;

           return (char)((lIndex * VCount + vIndex) * TCount + tIndex + SBase);
        }

        private char composeLL(char l1, char l2) {
           return l2;
        }

        private char composeVV(char v1, char v2) {
           return v2;
        }

        private char composeTT(char t1, char t2) {
           return t2;
        }

        private boolean isLeadingC(char c) {
           return (c >= LBase && c <= '\u1159');
        }

        private boolean isVowel(char c) {
           return (c >= VBase && c <= '\u11a2');
        }

        private boolean isTrailingC(char c) {
           return (c >= TBase && c <= '\u11f9');
        }

        private byte[] encodeHangul(char unicode) {
            int index;
            byte[] outputBytes = new byte[2];

            int theBytes;

            // first we convert the unicode to its byte representation

            index = index1[((unicode & mask1) >> shift)] + (unicode & mask2);
            if (index < 15000)
             theBytes = (int)(index2.charAt(index));
            else
             theBytes = (int)(index2a.charAt(index-15000));

            outputBytes[0] = (byte)((theBytes & 0x0000ff00)>>8);
            outputBytes[1] = (byte)(theBytes & 0x000000ff);

            return outputBytes;
        }

        protected static short index1[] =
        {
                 4456, 14123, 13777, 13022, 12397, 10298,  9098,  8689, // 0000 - 003F
                 5710,  3347, 22446, 22124, 22076, 21927, 21833, 21740, // 0040 - 007F
                20283, 20283, 20283, 20283,  4410, 21650, 21430, 21283, // 0080 - 00BF
                15001, 20283, 21101, 20939, 14934, 20283, 20875, 20763, // 00C0 - 00FF
                20283, 20283,  4384, 20283, 14845, 20283,  4329, 20547, // 0100 - 013F
                20416,  4302, 15153, 20283, 14835, 20283, 20283, 20283, // 0140 - 017F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0180 - 01BF
                 5232, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 01C0 - 01FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0200 - 023F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0240 - 027F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20053, // 0280 - 02BF
                20284, 20283, 20282, 20212, 20283, 20283, 20283, 20283, // 02C0 - 02FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0300 - 033F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0340 - 037F
                20283, 20283,  4283, 20119, 20073, 20010,  4219, 19959, // 0380 - 03BF
                19868, 18990, 20283, 20283, 20283, 20283, 20283, 20283, // 03C0 - 03FF
                 3974, 20283, 18672, 18524, 18264, 18219, 18160, 18120, // 0400 - 043F
                17998, 17942,  3945, 20283, 20283, 20283, 20283, 20283, // 0440 - 047F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0480 - 04BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 04C0 - 04FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0500 - 053F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0540 - 057F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0580 - 05BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 05C0 - 05FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0600 - 063F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0640 - 067F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0680 - 06BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 06C0 - 06FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0700 - 073F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0740 - 077F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0780 - 07BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 07C0 - 07FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0800 - 083F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0840 - 087F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0880 - 08BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 08C0 - 08FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0900 - 093F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0940 - 097F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0980 - 09BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 09C0 - 09FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0A00 - 0A3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0A40 - 0A7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0A80 - 0ABF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0AC0 - 0AFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0B00 - 0B3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0B40 - 0B7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0B80 - 0BBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0BC0 - 0BFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0C00 - 0C3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0C40 - 0C7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0C80 - 0CBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0CC0 - 0CFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0D00 - 0D3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0D40 - 0D7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0D80 - 0DBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0DC0 - 0DFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0E00 - 0E3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0E40 - 0E7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0E80 - 0EBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0EC0 - 0EFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0F00 - 0F3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0F40 - 0F7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0F80 - 0FBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 0FC0 - 0FFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1000 - 103F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1040 - 107F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1080 - 10BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 10C0 - 10FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1100 - 113F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1140 - 117F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1180 - 11BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 11C0 - 11FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1200 - 123F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1240 - 127F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1280 - 12BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 12C0 - 12FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1300 - 133F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1340 - 137F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1380 - 13BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 13C0 - 13FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1400 - 143F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1440 - 147F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1480 - 14BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 14C0 - 14FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1500 - 153F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1540 - 157F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1580 - 15BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 15C0 - 15FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1600 - 163F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1640 - 167F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1680 - 16BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 16C0 - 16FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1700 - 173F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1740 - 177F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1780 - 17BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 17C0 - 17FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1800 - 183F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1840 - 187F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1880 - 18BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 18C0 - 18FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1900 - 193F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1940 - 197F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1980 - 19BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 19C0 - 19FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1A00 - 1A3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1A40 - 1A7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1A80 - 1ABF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1AC0 - 1AFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1B00 - 1B3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1B40 - 1B7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1B80 - 1BBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1BC0 - 1BFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1C00 - 1C3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1C40 - 1C7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1C80 - 1CBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1CC0 - 1CFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1D00 - 1D3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1D40 - 1D7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1D80 - 1DBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1DC0 - 1DFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1E00 - 1E3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1E40 - 1E7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1E80 - 1EBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1EC0 - 1EFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1F00 - 1F3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1F40 - 1F7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1F80 - 1FBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 1FC0 - 1FFF
                20283, 20283, 17623, 17315, 16839, 20283, 16567, 17307, // 2000 - 203F
                20283, 20283, 20283, 20283, 20283, 20283, 20951, 20725, // 2040 - 207F
                 3849, 20283, 20283, 20283, 20283,  3710, 20283, 20283, // 2080 - 20BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 20C0 - 20FF
                19598,  3671, 16412, 20283,  3561, 11971, 20283, 20283, // 2100 - 213F
                20283, 20283, 20047, 21800, 16517, 16420, 16229, 15959, // 2140 - 217F
                20283, 20283, 15629, 15568, 20283, 20283, 20283, 20283, // 2180 - 21BF
                20283, 20283, 21782, 20283, 20283, 20283, 20283, 20283, // 21C0 - 21FF
                15111, 14991,  3448, 14073, 14506, 14115,  9750,  6540, // 2200 - 223F
                20283, 20283, 21712, 20283, 14089, 19350, 20283, 20283, // 2240 - 227F
                19146, 20283, 20283, 20283,  6485, 20283, 20283, 20283, // 2280 - 22BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 22C0 - 22FF
                20283, 20283, 21557, 20283, 20283, 20283, 20283, 20283, // 2300 - 233F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2340 - 237F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2380 - 23BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 23C0 - 23FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2400 - 243F
                20283, 20283, 20283, 20283, 13911, 13769, 18195, 13591, // 2440 - 247F
                13464, 20283, 20283, 20895, 13355, 13121, 13007, 20283, // 2480 - 24BF
                20283, 20283, 12771, 12526, 12444, 12374, 20283, 20283, // 24C0 - 24FF
                12324, 17112, 11906, 11796, 11712, 11463, 11319, 11132, // 2500 - 253F
                11106, 11028, 20283, 20283, 20283, 20283, 20283, 20283, // 2540 - 257F
                20283, 20283, 21531, 20283, 10818, 10667, 11592, 17030, // 2580 - 25BF
                10560, 10336, 10275, 20283, 20283, 20283, 20283, 20283, // 25C0 - 25FF
                 6401, 14786, 20283, 16784, 20283, 20283, 20283, 20283, // 2600 - 263F
                 9556, 20283, 20283, 20283,  9405,  9073, 20283, 20283, // 2640 - 267F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2680 - 26BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 26C0 - 26FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2700 - 273F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2740 - 277F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2780 - 27BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 27C0 - 27FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2800 - 283F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2840 - 287F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2880 - 28BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 28C0 - 28FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2900 - 293F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2940 - 297F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2980 - 29BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 29C0 - 29FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2A00 - 2A3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2A40 - 2A7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2A80 - 2ABF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2AC0 - 2AFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2B00 - 2B3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2B40 - 2B7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2B80 - 2BBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2BC0 - 2BFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2C00 - 2C3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2C40 - 2C7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2C80 - 2CBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2CC0 - 2CFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2D00 - 2D3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2D40 - 2D7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2D80 - 2DBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2DC0 - 2DFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2E00 - 2E3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2E40 - 2E7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2E80 - 2EBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2EC0 - 2EFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2F00 - 2F3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2F40 - 2F7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2F80 - 2FBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 2FC0 - 2FFF
                 8992,  8806,  8671, 20627, 20283, 20283, 20283, 20283, // 3000 - 303F
                 3433,  8610,  8535,  8348,  8236,  8070,  7920,  7679, // 3040 - 307F
                 7520,  7393,  7057, 20283,  3414,  7020,  6950,  6878, // 3080 - 30BF
                 6803,  6584,  6339,  6173,  5930,  5766,  5702, 22236, // 30C0 - 30FF
                20283, 20283, 20283, 20283, 20283, 20283,  3362,  5554, // 3100 - 313F
                 5263,  5147,  5070,  4707,  3882,  3601,  3577,  3546, // 3140 - 317F
                 3484,  3339, 20283, 20283, 20283, 20283, 20283, 20283, // 3180 - 31BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 31C0 - 31FF
                 3279,  3040,  2333,  2222, 20283, 20283, 20283, 20283, // 3200 - 323F
                20283, 20283, 20283, 20283,  1962,  1909,  1733, 22839, // 3240 - 327F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3280 - 32BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 32C0 - 32FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3300 - 333F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3340 - 337F
                22791, 22767, 22709, 22685, 22669, 22622, 22544, 22528, // 3380 - 33BF
                22501, 22474, 22438, 22205, 20283, 20283, 20283, 20283, // 33C0 - 33FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3400 - 343F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3440 - 347F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3480 - 34BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 34C0 - 34FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3500 - 353F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3540 - 357F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3580 - 35BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 35C0 - 35FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3600 - 363F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3640 - 367F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3680 - 36BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 36C0 - 36FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3700 - 373F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3740 - 377F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3780 - 37BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 37C0 - 37FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3800 - 383F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3840 - 387F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3880 - 38BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 38C0 - 38FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3900 - 393F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3940 - 397F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3980 - 39BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 39C0 - 39FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3A00 - 3A3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3A40 - 3A7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3A80 - 3ABF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3AC0 - 3AFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3B00 - 3B3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3B40 - 3B7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3B80 - 3BBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3BC0 - 3BFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3C00 - 3C3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3C40 - 3C7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3C80 - 3CBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3CC0 - 3CFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3D00 - 3D3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3D40 - 3D7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3D80 - 3DBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3DC0 - 3DFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3E00 - 3E3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3E40 - 3E7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3E80 - 3EBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3EC0 - 3EFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3F00 - 3F3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3F40 - 3F7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3F80 - 3FBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 3FC0 - 3FFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4000 - 403F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4040 - 407F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4080 - 40BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 40C0 - 40FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4100 - 413F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4140 - 417F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4180 - 41BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 41C0 - 41FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4200 - 423F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4240 - 427F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4280 - 42BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 42C0 - 42FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4300 - 433F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4340 - 437F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4380 - 43BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 43C0 - 43FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4400 - 443F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4440 - 447F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4480 - 44BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 44C0 - 44FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4500 - 453F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4540 - 457F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4580 - 45BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 45C0 - 45FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4600 - 463F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4640 - 467F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4680 - 46BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 46C0 - 46FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4700 - 473F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4740 - 477F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4780 - 47BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 47C0 - 47FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4800 - 483F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4840 - 487F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4880 - 48BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 48C0 - 48FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4900 - 493F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4940 - 497F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4980 - 49BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 49C0 - 49FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4A00 - 4A3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4A40 - 4A7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4A80 - 4ABF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4AC0 - 4AFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4B00 - 4B3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4B40 - 4B7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4B80 - 4BBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4BC0 - 4BFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4C00 - 4C3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4C40 - 4C7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4C80 - 4CBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4CC0 - 4CFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4D00 - 4D3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4D40 - 4D7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4D80 - 4DBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 4DC0 - 4DFF
                22140, 22109,  3309, 22068, 20283,  6251, 22037, 21985, // 4E00 - 4E3F
                18955, 12953, 14741, 21969, 20283, 11823, 12606, 14572, // 4E40 - 4E7F
                11696, 21919, 21808, 21732,  3215, 21642, 14439, 11343, // 4E80 - 4EBF
                21626, 18893, 16254, 21593, 12481, 20283, 21543, 19047, // 4EC0 - 4EFF
                 3186,  3171, 21467, 20283, 20283, 18405, 16109, 21399, // 4F00 - 4F3F
                21339, 21355, 21316,  2088, 20283,  3013, 21275, 18693, // 4F40 - 4F7F
                 2990, 21251,  2903, 21076, 20283, 14407,  6184, 17875, // 4F80 - 4FBF
                11073,  2051,  2880, 10697, 20965, 14397,  2837, 20927, // 4FC0 - 4FFF
                20957,  1935,  2748,  2733,  2658, 20855, 20283, 21190, // 5000 - 503F
                21000, 20825,  5965,  7765,  5903, 20283, 20755, 20724, // 5040 - 507F
                20532,  5832,  2557, 20485, 20283,  6375, 20839, 14379, // 5080 - 50BF
                17210,  2502,  2458, 20747,  5799,  5777, 20283,  2348, // 50C0 - 50FF
                20408,  1780, 16867, 17585,  2296, 20633, 16460, 16339, // 5100 - 513F
                20392, 20274,  6509,  9896,  9830, 20204,  2281, 20097, // 5140 - 517F
                20065, 20502,  9810, 20283, 19975, 20349, 20238,  5721, // 5180 - 51BF
                20524,  2247, 20283, 20002,  2130, 20283, 19951, 19912, // 51C0 - 51FF
                19896, 19860,  2115,  5669, 15140,  2003, 19834, 19711, // 5200 - 523F
                21123, 20177, 20196,  2619, 21448,  1988,  6033,  5634, // 5240 - 527F
                 8161, 19688,  1884, 12852, 19617, 20781, 20283, 14361, // 5280 - 52BF
                 1809, 17400, 14870, 19566,  9140, 20283,  6661, 19501, // 52C0 - 52FF
                 5508, 19473, 19442,  1759, 19316,  8917, 20283,   135, // 5300 - 533F
                19271, 19109, 20219, 19852, 18982, 18934, 18918,  5373, // 5340 - 537F
                14864, 20283, 18598, 18800, 18664,  5292, 20283, 14915, // 5380 - 53BF
                 9968, 18509, 14776, 16013, 20020, 20027, 18436, 18404, // 53C0 - 53FF
                19000, 18317, 18253, 20560, 18211, 17639, 13558, 18152, // 5400 - 543F
                19809, 18055, 17322, 20283, 20283, 17965, 17332, 15523, // 5440 - 547F
                17934, 14622, 17874, 20283, 13796, 17845, 13572, 17813, // 5480 - 54BF
                17728, 17674, 20283, 20283, 17339, 17615, 19765, 13802, // 54C0 - 54FF
                 3113, 14315, 17584, 13249, 20283, 17152, 17346, 14247, // 5500 - 553F
                13060, 17074, 15316, 14205, 20339, 20283, 20283, 11524, // 5540 - 557F
                17556, 17353, 20283, 17456, 16793, 17364, 20283, 20283, // 5580 - 55BF
                 5179, 20283, 12933, 19751, 20232, 20283, 20283,  5081, // 55C0 - 55FF
                14099, 16578, 12240, 20283, 20283, 16181,  8594, 20283, // 5600 - 563F
                20283, 20283, 20167, 20283, 20283, 17297, 12197, 20283, // 5640 - 567F
                13968, 20283, 20283, 20283,  4986,  5247, 12126, 11482, // 5680 - 56BF
                17270,  4053, 15969, 19680, 17151, 20283, 17073, 15578, // 56C0 - 56FF
                11260, 16908,  8481, 16892, 20283, 16824, 16792, 20132, // 5700 - 573F
                16661,  8418, 16556, 20283, 13014,  8386, 16502, 11419, // 5740 - 577F
                19584, 16402, 10403, 20283, 16285, 20283, 20283, 20283, // 5780 - 57BF
                13329, 16221, 10530, 14943, 16180, 20283, 16117, 12384, // 57C0 - 57FF
                15951, 15881, 20283, 13895, 11039, 13255, 15826,  5619, // 5800 - 583F
                20283,  7958, 10677, 15621, 10285,  9080,  4944,  9090, // 5840 - 587F
                 7716,  8678,  5609, 18752, 20283, 15560,  9240, 19465, // 5880 - 58BF
                 7068, 13876, 22212, 15538,  2603,  8897, 20283, 22219, // 58C0 - 58FF
                20283, 14214, 10994, 22226,  7823, 22116, 21996, 13827, // 5900 - 593F
                18471, 15491, 15469, 12939, 15428, 12645, 16751, 15398, // 5940 - 597F
                12596, 12203, 19284, 21815, 19233, 15324, 20283, 21825, // 5980 - 59BF
                 6897, 21477, 15274, 21406, 13649, 15103, 20283, 15031, // 59C0 - 59FF
                21413, 20283, 21323, 15009, 14973, 21083, 13601,  9442, // 5A00 - 5A3F
                21093, 20975, 20283, 12132, 11890, 20283, 20283, 13885, // 5A40 - 5A7F
                20283, 20283, 19092,  6778,  9160, 20283, 20283,  4257, // 5A80 - 5ABF
                20985, 20862, 13836, 20283, 20539, 19982, 20283, 20283, // 5AC0 - 5AFF
                 4881, 19992, 13448, 20283, 20283, 18854, 14942, 20283, // 5B00 - 5B3F
                14878, 20283, 14749, 14731, 11683, 19919, 14695, 14653, // 5B40 - 5B7F
                 4846, 14630,  7116, 14580, 11488,  9021, 14498, 14447, // 5B80 - 5BBF
                14429,  8744, 14387, 13419, 19695, 14369,  4772, 14323, // 5BC0 - 5BFF
                19116, 14305, 18516, 18447, 14255, 14213, 18075, 14195, // 5C00 - 5C3F
                14107, 14081, 18085, 15914, 13976,  8554, 18092, 18102, // 5C40 - 5C7F
                20283,  8445, 13934, 20283, 18112, 17985, 17820, 13903, // 5C80 - 5CBF
                13884, 20283, 20283, 17684, 13835, 13817, 13761, 15928, // 5CC0 - 5CFF
                12278,  4718, 17694, 17463, 11947, 17473, 20283, 20283, // 5D00 - 5D3F
                20283,  6982, 13657, 20283, 20283, 17483, 20283, 20283, // 5D40 - 5D7F
                 6474, 18715, 20283,  4663, 13609, 18831, 20283, 13537, // 5D80 - 5DBF
                20283,  4602, 11425,  4421, 17281, 13456, 16915, 16831, // 5DC0 - 5DFF
                11377,  8312, 16509, 16296,  4230,  3070, 10757, 13399, // 5E00 - 5E3F
                13377, 17920,  4186, 10897, 16303, 20283, 16314, 13347, // 5E40 - 5E7F
                 8264, 11195,  4142,  2609, 13285,  5463,  4131, 13113, // 5E80 - 5EBF
                 6099, 13068, 12999, 18648, 12870, 12837, 15366,  5950, // 5EC0 - 5EFF
                15833,  5867, 15405, 12787, 13409, 14980, 14894, 18588, // 5F00 - 5F3F
                13339, 12763, 13295, 14901, 18574, 14702, 12717, 14709, // 5F40 - 5F7F
                12685, 18489, 12653, 12518, 12415, 12366, 17899, 13983, // 5F80 - 5FBF
                10070,  8149, 13168, 12296, 12277, 18330, 13990,  4591, // 5FC0 - 5FFF
                20283, 10192,  2942, 18277, 12154, 12097, 13997, 20283, // 6000 - 603F
                13944,  4026, 12060, 13668, 18381, 12034, 11946, 20283, // 6040 - 607F
                 3995, 13675,  7886,  9926, 11924, 20283, 11898, 11777, // 6080 - 60BF
                 3959, 20283, 13682,  4365, 11749, 20283, 11704, 13544, // 60C0 - 60FF
                13583, 11649,  3912,  9448, 10050, 20283, 11626, 17706, // 6100 - 613F
                 9278, 11514,  4537, 11496,  5658, 11455, 11433,  3648, // 6140 - 617F
                12425,  9166, 11385, 11302, 17534, 12436,  8958, 18047, // 6180 - 61BF
                11869, 11246, 20283, 20283, 12991, 20283,  8862, 11228, // 61C0 - 61FF
                11164, 11124, 11098,  5405, 12306,  8750, 11020, 12914, // 6200 - 623F
                11002, 10944, 14558, 10896, 20283, 12862, 12316, 12067, // 6240 - 627F
                10849, 11784, 11759, 10799, 20283,  2960, 11536, 11543, // 6280 - 62BF
                 8631, 10775, 10723, 10654, 20283,  7632, 11550, 12797, // 62C0 - 62FF
                10951, 10626, 10861, 20283, 20283, 14351, 20283, 10810, // 6300 - 633F
                20283, 10636, 10593, 20283,  7537, 10552,  8451,  8318, // 6340 - 637F
                14288, 10504, 17926, 10473, 10437, 10388, 20283, 20283, // 6380 - 63BF
                10328,  6924, 10267,  7850, 10600,  3525,  7607, 20283, // 63C0 - 63FF
                20283,  3495, 16723,  6639,  4866, 16326, 20283, 17720, // 6400 - 643F
                20283, 20283, 20283, 10191, 10173, 10610, 20283, 10095, // 6440 - 647F
                20283, 10049, 10516, 17666,  6551,  5131, 10022,  2476, // 6480 - 64BF
                10419, 17607,  7706,  9988, 10111, 16137,  9999, 17548, // 64C0 - 64FF
                 9848, 20283, 20283,  9775, 14156,  7653, 12741,  9699, // 6500 - 653F
                 3392,  9681,  9860, 12709, 17448, 16053, 17254,  9548, // 6540 - 657F
                17189, 15867,  9516,  9782,  9341,  2025,  9484,  9334, // 6580 - 65BF
                 9327, 17754, 17175, 20283,  9397,  9320,  9230, 17135, // 65C0 - 65FF
                12663,  9251,  9223, 12624,  9174,  9116,  9065, 17097, // 6600 - 663F
                 8887,  8841, 20283,  8212, 17011,  9049,  7557,  9029, // 6640 - 667F
                 6262,  8984,  8966,  8880,  8830,  7154, 16977,  8663, // 6680 - 66BF
                15590,  8202, 12510,  8656,  8798,  8192,  8776,  8758, // 66C0 - 66FF
                 8711,  8649,  6240, 15985, 12454,  8602,  7012,  3762, // 6700 - 673F
                12407,  7202,  8527,  6221, 20283,  3290,  8489, 14534, // 6740 - 677F
                 6691,  6442,  8426, 16929, 20283,  4727,  8394,  8340, // 6780 - 67BF
                 6135,  4015,  8282, 16816, 16737,  7582,  8228, 14187, // 67C0 - 67FF
                20283, 20283, 16711, 20283,  7503, 16675,  7382,  8185, // 6800 - 683F
                 8096,  8062,  8041, 20283, 20283,  3235, 12288,  3224, // 6840 - 687F
                 7005, 22582,  3148,  3200,  7235,  7974,  7912, 20283, // 6880 - 68BF
                15169,  7195, 16629,  7894,  7867,  7671, 16604,  6431, // 68C0 - 68FF
                 7575,  3024,  6645, 20283, 22565, 20283,  7536,  2975, // 6900 - 693F
                16483, 16382, 13199,  7049,  7492,  7433,  2714,  7372, // 6940 - 697F
                20283, 20283,  5976,  5520,  2542, 12146,  3257,  5425, // 6980 - 69BF
                 6994, 16277,  7296, 20283, 20283,  7268, 20283,  4975, // 69C0 - 69FF
                16243, 16204,  6850,  6754,  6611, 20283,  2184,  7228, // 6A00 - 6A3F
                14597,  7184,  7162,  7134,  6421, 10349, 20283, 20283, // 6A40 - 6A7F
                 7106,  6165, 22395, 14459,  7038, 20283,  4242,  4198, // 6A80 - 6ABF
                16151, 20283,  8249, 16078, 20283, 20283, 12089,  7446, // 6AC0 - 6AFF
                16036, 15904, 15873, 20283,  6968, 20283, 15799,  6942, // 6B00 - 6B3F
                 3637,  5914,  6923, 22347,  3331, 15762,  4761,  6905, // 6B40 - 6B7F
                 2145,  5470, 12052,  6870,  5886, 11985, 15721, 15689, // 6B80 - 6BBF
                17065,  2173, 15675,  6839, 20283,   128, 20283, 20283, // 6BC0 - 6BFF
                 2070,  6821, 22178, 20283, 21655, 20283, 13739,  6795, // 6C00 - 6C3F
                 6743, 11916,  6725, 15652,  6690,  6604,  6576, 15613, // 6C40 - 6C7F
                20700,  6409,  6331,  6278, 20283, 21664, 20425,  6192, // 6C80 - 6CBF
                 4544,  5337, 20434, 17628,  6158,  6116,  5991, 20283, // 6CC0 - 6CFF
                20283,  3854,  4120,  3874,  1973,  3793, 15552,  5922, // 6D00 - 6D3F
                 3731, 20283, 20283, 22656,  3859, 22614,  5843,  5821, // 6D40 - 6D7F
                 1744,  5758,  3324, 20283, 20283, 22149,  2421,  3081, // 6D80 - 6DBF
                 5736, 21787,  4102,  5694, 17802,  5546,  2766,  5449, // 6DC0 - 6DFF
                20283, 20283, 22093,  2487,  5255, 13473, 15483,  5139, // 6E00 - 6E3F
                 9565, 15454, 11769,  5089, 21953,  9570, 15352,  6141, // 6E40 - 6E7F
                20283, 20283,  5062,  5788, 15240, 15190, 20817, 15125, // 6E80 - 6EBF
                15072,  2325, 17058, 20283, 20283, 21944,  5680,  5040, // 6EC0 - 6EFF
                 2214,  2160, 22171, 20283,  4906,  2227, 20684,  4835, // 6F00 - 6F3F
                22026, 20283,   422,  4780, 15023,  4387,  4726, 14965, // 6F40 - 6F7F
                   15,  4699,  4621, 20283,  2232, 11568,  6066, 22831, // 6F80 - 6FBF
                 4577, 14814, 20013, 14800,  4527, 22816, 19368,  3263, // 6FC0 - 6FFF
                22759, 12500,  5330,  4429, 22796,  4395,  4314, 11506, // 7000 - 703F
                20283, 13180,  4265,  4113, 11352, 11078,  4014,  3867, // 7040 - 707F
                18993, 14723, 14611,  3777, 21575,  7770, 16876,  3721, // 7080 - 70BF
                20283,  3656, 20283,  3617, 20283, 20283, 22646, 22607, // 70C0 - 70FF
                12886, 11859, 20283, 22520, 22493, 20283,  3593, 20283, // 7100 - 713F
                21749, 18974,  3569, 22430,  2865, 18910, 20283,  3977, // 7140 - 717F
                 5216, 22415, 14548,  2643, 14486,  3533, 21030,  9767, // 7180 - 71BF
                22299,  3476,  3317, 21602,  3948,  3713, 20283, 22284, // 71C0 - 71FF
                 3271, 20283,  3223, 20642, 20283, 14465,  3032, 14421, // 7200 - 723F
                 2998,  2950, 14341,  2911,  9633,  4092, 14274, 17795, // 7240 - 727F
                 2756, 20283, 11294, 20283, 14174, 12079, 20283, 20283, // 7280 - 72BF
                 2466, 11238,  2443, 22266, 17228, 20807, 20283,  2318, // 72C0 - 72FF
                20283, 14137, 11220, 16344,  3674, 17047,  5112, 11174, // 7300 - 733F
                 4997, 20283,  2266, 20283, 20283,  2203,  2153,  2096, // 7340 - 737F
                11604, 22197,  4955,  2059, 21498, 22164, 14037, 20674, // 7380 - 73BF
                 2011, 16368, 11156, 22060,  1954, 22019, 21292, 20384, // 73C0 - 73FF
                20318, 20263,  6518,  9901,  1901,  1861,  1725,   474, // 7400 - 743F
                  415, 20102, 16423, 21895,     8, 22872, 20283, 11116, // 7440 - 747F
                14015,  6050, 20283, 22864, 21856, 22847, 22824, 21764, // 7480 - 74BF
                11012,  5892, 11402, 22804, 22783, 10936, 21110, 20283, // 74C0 - 74FF
                19405,  2582, 19361, 22775, 20111, 22747, 22739, 22717, // 7500 - 753F
                20584, 13866, 12488,  5323, 13753, 13727, 22701, 22693, // 7540 - 757F
                10874, 13713, 19177, 15962, 15571, 20354, 21568, 22677, // 7580 - 75BF
                13699,  3451, 13632, 22630, 13510, 20283, 22590,  3087, // 75C0 - 75FF
                22581, 12377, 20283, 21513, 22573, 20283,  4892, 20363, // 7600 - 763F
                13487, 11090, 13391, 22564, 11847, 21370, 22552, 22536, // 7640 - 767F
                 5018, 10767, 22509, 13369, 20283, 10646, 20283, 13309, // 7680 - 76BF
                13277, 22482,  5686, 19720, 19058, 10544, 13213, 22466, // 76C0 - 76FF
                18962, 22454, 20283,  1893, 22423, 18900, 20469, 22403, // 7700 - 773F
                22394, 10670, 20283, 19622, 21243, 22367, 20283, 18872, // 7740 - 777F
                20283,  9145,  2633, 10465, 10278,  4820, 22355, 19325, // 7780 - 77BF
                20460, 20283, 20443, 19005, 13186, 21228, 19010, 20283, // 77C0 - 77FF
                13154, 10709, 13086, 20283,  3189,  4674, 13036, 20283, // 7800 - 783F
                21470, 20293, 20283, 20968, 20283, 19019, 20283,  2384, // 7840 - 787F
                21213,  4613, 21177, 20283, 19818, 21049, 20283, 12892, // 7880 - 78BF
                21023, 12829, 22346, 12811, 20283, 22338,  2560, 18064, // 78C0 - 78FF
                10377, 10429, 10259,  9757, 20283,  5526, 20283, 12755, // 7900 - 793F
                22330, 22319, 22311, 12731, 22292, 22277, 20283, 12699, // 7940 - 797F
                 9623, 20488,  4082, 20283, 10241, 12677, 17784, 17505, // 7980 - 79BF
                22256, 17217, 20800, 22248,  9872, 17037, 20283, 17974, // 79C0 - 79FF
                22190, 22157,  4498, 16943, 22148, 10183, 16697, 17850, // 7A00 - 7A3F
                22132, 16548, 20154, 20283,  6668, 20653, 22101, 20615, // 7A40 - 7A7F
                16351, 22092, 12583, 22084, 20283,  6529, 20283, 12350, // 7A80 - 7ABF
                 4475, 22049, 20145, 20575, 22012, 12254, 10087,  6382, // 7AC0 - 7AFF
                20283, 22004, 20509, 15530, 21977,  4352, 20283, 20374, // 7B00 - 7B3F
                10014, 15258, 21961, 20283, 21952,  9389,  1783,  2299, // 7B40 - 7B7F
                19787, 17733, 12221, 12186, 20308,  2133, 15212, 21943, // 7B80 - 7BBF
                21935, 15147,  5222, 19774, 21911, 20253, 20283, 20283, // 7BC0 - 7BFF
                21903, 20283, 12168,  9840, 20184, 12111, 19729, 21451, // 7C00 - 7C3F
                17302,  4161, 20283, 19527, 21888,  4037, 19593, 20283, // 7C40 - 7C7F
                16407,  6040,  5168, 21880, 11999,  9691, 20042, 19943, // 7C80 - 7CBF
                20283, 11961,  9673,  8501, 21872, 19510,  4006, 12389, // 7CC0 - 7CFF
                21864, 21849, 21841, 21795, 21772, 15890, 21757, 14063, // 7D00 - 7D3F
                11938, 20283, 21748, 10290, 13809, 21724, 19609, 19550, // 7D40 - 7D7F
                22231,  9580, 12948,  8082, 21702,  3923, 19398, 21694, // 7D80 - 7DBF
                19451, 11818,  9540, 21634, 21618, 21610,  7735, 12601, // 7DC0 - 7DFF
                20283, 19340,  1762, 15329, 12476, 15279, 19255, 18256, // 7E00 - 7E3F
                19240, 20283, 11726,  9508,  5313, 19170, 21601, 19140, // 7E40 - 7E7F
                11667,  3901, 21422, 21551, 20283, 20283, 20283, 20283, // 7E80 - 7EBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 7EC0 - 7EFF
                20283, 20283, 20283, 20283, 20283, 20283,  9476, 21521, // 7F00 - 7F3F
                20283,  3820, 21506, 21497, 20283, 11618, 21489, 11837, // 7F40 - 7F7F
                17325, 21459,  7247, 21391,  3685, 21383, 11582, 21363, // 7F80 - 7FBF
                 5011, 11447, 11408, 19155, 21347, 19042, 21334, 18949, // 7FC0 - 7FFF
                21308, 11690, 21300, 21291, 20283, 17677, 19101, 16581, // 8000 - 803F
                 6787, 11333,  9312, 21267, 20283, 19125, 21259, 15972, // 8040 - 807F
                 7080, 18887,  9215, 21236, 18865, 18776, 18687,  2588, // 8080 - 80BF
                20990,  6862,  9108,  4898,  2626, 20283, 11067, 21221, // 80C0 - 80FF
                11146, 21202, 20283, 21185, 20995, 18617, 20283, 18501, // 8100 - 813F
                20283, 20867, 21170, 20283, 16559, 19997, 21159, 21151, // 8140 - 817F
                21139, 21131, 20283, 11053, 21118, 21109, 14887, 10911, // 8180 - 81BF
                21068,  9083, 20283, 21060, 19928, 21042, 14658, 10888, // 81C0 - 81FF
                10737, 21016, 10715, 14663, 10367, 10691, 14585, 10228, // 8200 - 823F
                21008, 20283, 20283, 20947,  6717, 14260, 10165, 20919, // 8240 - 827F
                20283, 17990, 10574, 18420,  8681, 18388, 10077, 20911, // 8280 - 82BF
                20283, 20283, 18341, 13618, 18284, 20283,  9746, 10496, // 82C0 - 82FF
                 9616, 18191, 18817, 20283, 20283, 20903, 18144, 20891, // 8300 - 833F
                20883,  4175,  4071, 20283, 20283, 20283, 18840,  2614, // 8340 - 837F
                20283, 17957,  8976, 20847, 10451,  8156, 20283, 21818, // 8380 - 83BF
                17777,  7759,  6108,  3514, 20283,  7723, 20833, 17498, // 83C0 - 83FF
                12842, 10320, 20283, 20283, 20283, 17204, 17108, 20793, // 8400 - 843F
                20283, 17026, 16989, 12847,  3769, 15838, 16936,  4680, // 8440 - 847F
                20283, 20283, 20741, 16861, 16780, 20283,  4648, 20733, // 8480 - 84BF
                20716, 16690, 16653, 10206, 20283,  6596,  3462,  6299, // 84C0 - 84FF
                20283, 20283, 16615, 20708, 16541,  3381, 20283, 21326, // 8500 - 853F
                 6656, 16494, 18593, 20623, 16454, 20608, 20283,  8872, // 8540 - 857F
                20600, 18761, 16333, 14910,  8768, 20592, 20583, 10139, // 8580 - 85BF
                16250,  6558, 21086,  3246,  3136,  6499, 18740,  2390, // 85C0 - 85FF
                10125,  9963,  8725,  9886, 20283, 20978, 20283, 18702, // 8600 - 863F
                20283,  8641, 20568, 14924, 18634, 20283, 16105,  6371, // 8640 - 867F
                20283,  9824, 18494, 20283, 13953, 16060, 20283, 20283, // 8680 - 86BF
                 8461, 16008,  3059, 15935,  2930, 19985, 20283, 15818, // 86C0 - 86FF
                20555, 20520, 20283, 20496, 20283, 20283,  2848, 13958, // 8700 - 873F
                20283,  5441, 18450, 15736, 20477, 20468,  1946, 20459, // 8740 - 877F
                 9800, 18078, 20283, 18459,  9713, 18095, 13553,  9651, // 8780 - 87BF
                20451, 20283, 20283, 20283, 20442,  2785,  9594,  6323, // 87C0 - 87FF
                18105, 20283, 13937, 18359, 15518, 20283, 15461, 13567, // 8800 - 883F
                20400,  5101,  9530, 15420, 15311, 20334, 20326,  8366, // 8840 - 887F
                15247, 20301,  9498,  8274, 20283, 11519,  2677, 20283, // 8880 - 88BF
                15205, 18350,  2571, 15176, 15136, 20292, 11529, 20246, // 88C0 - 88FF
                18301, 20283, 20227, 20192, 17687,  9462,  8033, 20162, // 8900 - 893F
                 6027, 20283, 20283, 18237,  2521,  9427,  9373, 18228, // 8940 - 897F
                15079, 11390, 11311, 20283, 14860, 14825,  9355,  9265, // 8980 - 89BF
                20153, 20283,  9130,  2409, 11255, 20283,  2367, 20144, // 89C0 - 89FF
                20127, 20089, 11265, 20081, 10854,  9010,  5983,  8911, // 8A00 - 8A3F
                14772, 20283, 20035, 10659, 19967, 14645, 19936, 14618, // 8A40 - 8A7F
                17418,  4487, 10509, 19904, 19888, 19876, 19842, 14521, // 8A80 - 8ABF
                 4204, 10482,  8790, 10393, 14472,  8703, 14237, 19826, // 8AC0 - 8AFF
                19803,  7904, 19795, 14056, 19786, 19759, 10398, 13926, // 8B00 - 8B3F
                13792, 13639, 20283, 19745,  7663,  4441, 19737, 17466, // 8B40 - 8B7F
                19728,  8588, 19703,  4043, 20283, 20283, 20283, 20283, // 8B80 - 8BBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 8BC0 - 8BFF
                20283, 20283, 20283, 20283, 20283, 20283, 18129, 18033, // 8C00 - 8C3F
                13529, 19674, 17476,  8515,  3109,  8475, 20283, 13434, // 8C40 - 8C7F
                 8408,  8380, 20283, 14983, 19666, 19658, 19650, 19642, // 8C80 - 8CBF
                19634, 19574, 13324,  8332, 19558,  8301,  4295, 10412, // 8CC0 - 8CFF
                 1794, 19543,  7859, 20283, 20283, 20283, 20283, 20283, // 8D00 - 8D3F
                20283, 20283, 20283, 20283,  2310, 10104, 19535, 20283, // 8D40 - 8D7F
                12418,  8114, 20283, 13245, 10525, 19526,  7711,  8088, // 8D80 - 8DBF
                 7567, 10004, 20283,  9853,  5604, 19518,  9235, 20283, // 8DC0 - 8DFF
                20283,  8008, 19509,  7484, 20283,  7948, 19493, 20283, // 8E00 - 8E3F
                 7934, 19481, 12299, 13140, 19459, 20283,  2258, 20283, // 8E40 - 8E7F
                13097,  7837, 13056, 20283, 20283,  7817, 20283, 20283, // 8E80 - 8EBF
                19450,  7784,  7741, 18024, 20283,  8892, 20283, 19434, // 8EC0 - 8EFF
                16982, 12929,  7693,  8287,  7460, 12904, 16746, 19426, // 8F00 - 8F3F
                 2195,  5538, 20283, 13685, 12639, 20283, 20283, 20283, // 8F40 - 8F7F
                20283, 20283, 20283, 16756,  7512, 19418, 19387, 20283, // 8F80 - 8FBF
                 7621,  7364, 12590, 20283,  7176,  7596, 19379, 19333, // 8FC0 - 8FFF
                19308, 19300, 19292, 12549, 19279,  7126, 12469, 19263, // 9000 - 903F
                 2814,  3826, 19248, 12269, 19228, 19220,  7474, 19212, // 9040 - 907F
                19204, 19196,  5306, 12236,  7425, 19188, 19163, 19154, // 9080 - 90BF
                12193,  7407, 20283,  7098,  5243, 19133, 11752, 12309, // 90C0 - 90FF
                 7323, 20283,  7253, 12122, 18007, 10629,  7216, 20283, // 9100 - 913F
                20283, 12026,  3691, 20283,  6892, 11884, 10864, 19124, // 9140 - 917F
                17908, 11830, 19082,  3426, 20283,  8046,  5004, 20283, // 9180 - 91BF
                19074, 11733, 19066, 19035,  7305,  6768, 10603, 20283, // 91C0 - 91FF
                20283,  8205, 19027,  7030, 20283, 20283,  3302,  6705, // 9200 - 923F
                18942, 11678, 17829, 16213,  3468, 20283, 20283, 18926, // 9240 - 927F
                18880, 20283, 11641, 18848, 20283, 20283,  6620, 11478, // 9280 - 92BF
                20283, 21686,  6464, 20283,  2081,  6353, 20283, 18825, // 92C0 - 92FF
                 2044, 20283, 18816, 18808, 18792, 18784, 20283, 20283, // 9300 - 933F
                20283, 18769,  1928,  7111,  2726,  6960,  8195, 17382, // 9340 - 937F
                20283,  1773,  1717,  6305, 16041, 21675, 18760, 20283, // 9380 - 93BF
                15909, 20283, 11415,  7385, 11371, 20283,  6934, 20283, // 93C0 - 93FF
                21441, 20283, 20283, 18748,  7375, 15923,  6424, 18739, // 9400 - 943F
                20774,  6206, 11280,  6977, 18727, 20283, 20283,  3734, // 9440 - 947F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 9480 - 94BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 94C0 - 94FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 9500 - 953F
                20283, 20283, 20283, 20283, 20283, 20283, 17652, 20283, // 9540 - 957F
                18710, 11210, 11189, 18701,  6987, 18680,  2599, 15771, // 9580 - 95BF
                17514,  6089,  1853, 17393, 11060, 20283, 20283, 20283, // 95C0 - 95FF
                20283, 20283, 20283, 20420, 10990, 18656,  6009, 15776, // 9600 - 963F
                18642,  6414, 18633,  6287,  5944,  5857, 18625, 18610, // 9640 - 967F
                 4105,  5813,  5236, 18582,  4549, 18564, 10926,  5342, // 9680 - 96BF
                18556,  4827, 17805, 10841,  3065, 18548, 18540, 10752, // 96C0 - 96FF
                18532, 22029,  2435, 10585, 17240, 20283, 18479, 10360, // 9700 - 973F
                 5750, 18467,  4691, 20057, 10217, 10158, 21716,  2936, // 9740 - 977F
                21561,  5347, 20283, 18458, 18428, 18413, 20283, 20283, // 9780 - 97BF
                22661,  5458, 15361, 13468, 20283, 20283,  6150,  4915, // 97C0 - 97FF
                18396, 18375, 18367, 18358, 10065, 20693, 18349, 18325, // 9800 - 983F
                 6915, 21535,  9560, 18309, 19371,    20, 18300, 20283, // 9840 - 987F
                20283, 20283, 20283, 20283, 20283, 18292, 10041, 20283, // 9880 - 98BF
                22041, 20283, 20283,  6075,  9945,  4268, 11347, 20931, // 98C0 - 98FF
                 4586,  9920, 18272, 18245, 18236, 18227, 20283, 20283, // 9900 - 993F
                 3724,  9739,  9724, 16871, 20283, 20283, 20283, 20283, // 9940 - 997F
                20283, 20283,  6831,  9609, 22649, 18203,  4359,  9438, // 9980 - 99BF
                 9272, 20283, 18184,  9205,  5648,  4095,  9156, 17161, // 99C0 - 99FF
                 4253, 18176, 20283,  9017, 20283,  4532, 18168, 20283, // 9A00 - 9A3F
                18137,  2759, 22269,  5582,  2854,  8948, 20283, 20283, // 9A40 - 9A7F
                20283, 20283, 20283, 20283, 20283, 18128, 20283, 18041, // 9A80 - 9ABF
                18032, 17121,  8856, 18023,  3786,  6813, 20637, 20283, // 9AC0 - 9AFF
                20283, 20283, 20283, 18015,  5568,  5395,  8740, 21580, // 9B00 - 9B3F
                 4168, 17231,  8625,  5277, 20283, 17083,  6513, 20283, // 9B40 - 9B7F
                20283,  6735,  4060, 16802, 20283, 21585, 20283, 20283, // 9B80 - 9BBF
                20283,  8550,  6682, 11864,  1888, 18006, 20283, 20283, // 9BC0 - 9BFF
                20283, 20810, 17950, 20283, 20677, 20266,  5193, 14553, // 9C00 - 9C3F
                16765,  8441, 16638, 20283, 20283, 20283, 20283, 20283, // 9C40 - 9C7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 9C80 - 9CBF
                20283, 20283, 20283, 20283, 19180,  8308,  3538, 20283, // 9CC0 - 9CFF
                16590, 17916, 20283,  2955,  6568, 17907, 20283, 14346, // 9D00 - 9D3F
                19813, 20283,  8260, 18903, 17895, 18059,  1837, 20283, // 9D40 - 9D7F
                20283,  8145, 20283, 20283, 20283,  8023, 17969, 14283, // 9D80 - 9DBF
                19769, 20283, 16526, 20283, 20283, 20283,  5126, 17883, // 9DC0 - 9DFF
                20283, 20283, 20283,  5054, 20283, 20283, 20283, 20283, // 9E00 - 9E3F
                20283, 20283, 20283, 20283, 20283, 20283,  2636,  3930, // 9E40 - 9E7F
                 7882, 20283,  2683, 21052, 17357, 20283, 17274, 14297, // 9E80 - 9EBF
                 2471, 10380,  7844, 17866, 20283, 17858, 19588, 14146, // 9EC0 - 9EFF
                16469, 17837, 14151, 20283, 17828, 20283, 20283,  2020, // 9F00 - 9F3F
                20283,  5032,  4929, 16263,  7791,  4860, 16190, 20283, // 9F40 - 9F7F
                20283,  9760, 17770, 15885, 20283, 20283, 20283, 20283, // 9F80 - 9FBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // 9FC0 - 9FFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A000 - A03F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A040 - A07F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A080 - A0BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A0C0 - A0FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A100 - A13F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A140 - A17F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A180 - A1BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A1C0 - A1FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A200 - A23F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A240 - A27F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A280 - A2BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A2C0 - A2FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A300 - A33F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A340 - A37F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A380 - A3BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A3C0 - A3FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A400 - A43F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A440 - A47F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A480 - A4BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A4C0 - A4FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A500 - A53F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A540 - A57F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A580 - A5BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A5C0 - A5FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A600 - A63F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A640 - A67F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A680 - A6BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A6C0 - A6FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A700 - A73F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A740 - A77F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A780 - A7BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A7C0 - A7FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A800 - A83F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A840 - A87F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A880 - A8BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A8C0 - A8FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A900 - A93F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A940 - A97F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A980 - A9BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // A9C0 - A9FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // AA00 - AA3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // AA40 - AA7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // AA80 - AABF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // AAC0 - AAFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // AB00 - AB3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // AB40 - AB7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // AB80 - ABBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // ABC0 - ABFF
                17762, 17749, 17741,  7752, 17714,  5623, 17702, 17660, // AC00 - AC3F
                17651,  6059, 12943, 17601, 20283, 20283, 17593, 17572, // AC40 - AC7F
                17564,  7700, 17542, 12207, 17530, 17522, 17513, 17491, // AC80 - ACBF
                 7647, 17442, 22322, 20283, 17434, 17426, 17289,  4794, // ACC0 - ACFF
                17262, 12136,  7628, 17248, 17239, 17197, 18858, 17183, // AD00 - AD3F
                14327,  7603, 17169, 17160,  7552, 13661, 17143, 22856, // AD40 - AD7F
                 7350, 17129, 17120, 22809, 13613, 20283, 16164, 20283, // AD80 - ADBF
                17091, 17082, 17019, 18835, 17005,  6103, 20283, 16997, // ADC0 - ADFF
                16967, 16959,  3756, 20283, 16022, 20283, 16951, 16923, // AE00 - AE3F
                16900,  7260, 16884, 13072, 16854, 16810, 16801, 16773, // AE40 - AE7F
                12429, 11306, 20283, 20283, 16764, 20283, 20283, 11788, // AE80 - AEBF
                16731,  4870, 16719, 16705, 20283, 16683, 10099, 16669, // AEC0 - AEFF
                10026, 16646, 16637, 20283, 20283,  9992, 16623,  9033, // AF00 - AF3F
                 7149, 16598, 16589, 16534,  8834, 16525, 20283,  6635, // AF40 - AF7F
                16477, 16468, 16447, 16741, 20283, 20283,  2527, 16439, // AF80 - AFBF
                16431, 16394,  7507, 16376, 15847, 16322, 16271, 16262, // AFC0 - AFFF
                16237, 16608, 16198,  6435,  6547, 16189, 20283, 20283, // B000 - B03F
                 6649, 16172, 19410,  6492, 16163, 20283, 20283, 16487, // B040 - B07F
                16145, 16386, 16133, 16125, 16094, 16086,  6364, 16072, // B080 - B0BF
                 7272, 16049, 16030, 16021, 16001, 16208, 20283, 20283, // B0C0 - B0FF
                20283, 15993, 15980, 15943, 22752, 15898, 15803, 15863, // B100 - B13F
                15855, 15846, 15811, 15793, 15784, 15785, 20283, 15756, // B140 - B17F
                15744, 15729,  4755, 15715, 15707, 15706, 15697, 20283, // B180 - B1BF
                20283, 15766, 15683,  5474, 20283, 15669, 15660,  6316, // B1C0 - B1FF
                 6747, 15646,  3797,  6258, 15637, 20283, 22726,  6145, // B200 - B23F
                20283, 20283, 20283, 15607, 15598, 15586, 15129, 20688, // B240 - B27F
                14818,  6236, 15546, 15507, 15499,  2415, 15477, 20283, // B280 - B2BF
                 6217, 15448, 15436, 15413, 15390, 15382, 22731, 15374, // B2C0 - B2FF
                15346, 15337, 15304,  3781, 20283, 20283,  6131, 15295, // B300 - B33F
                20283, 20283, 14490, 15287, 21034, 15266, 15234, 15225, // B340 - B37F
                15198, 14278, 15184, 14141, 15165, 15119, 20283, 20283, // B380 - B3BF
                 2207, 15095, 15087,  6020, 15066, 15057, 20283,  2015, // B3C0 - B3FF
                15048, 15698, 15039, 15017, 14999, 14959, 22851, 20283, // B400 - B43F
                20283, 20283, 14951, 14932, 14853, 22721, 20283, 15661, // B440 - B47F
                14843, 14833, 20283,  9626, 13491, 14808, 22556,  5972, // B480 - B4BF
                14794, 14784, 14765, 22486, 14757, 13158,  3253, 14739, // B4C0 - B4FF
                20283, 20283, 13090, 14717, 12815, 14687, 14679, 14671, // B500 - B53F
                14638, 12493, 14605,  6672, 14593, 14570, 20283, 20283, // B540 - B57F
                 5226, 20283, 20283, 20283, 14542, 14529, 14514, 22639, // B580 - B5BF
                14480, 12172, 14455, 14437, 20283, 11965, 21776, 20283, // B5C0 - B5FF
                20283, 20283, 14415, 14405,  4085, 14067, 21706, 20283, // B600 - B63F
                20283, 14395, 20283, 20283, 19344, 14377, 20283, 20283, // B640 - B67F
                14359, 20283, 20283, 11671, 14335, 22595,  5910, 14313, // B680 - B6BF
                20283, 20283, 21525, 20283, 20283, 20283, 14268, 14245, // B6C0 - B6FF
                14230, 11586, 20283, 20283, 20283, 14222, 14203, 14182, // B700 - B73F
                11337, 14168,  2592, 20283, 14131, 14097, 14049, 21206, // B740 - B77F
                14031, 21143, 14023, 14009, 13966, 13919, 10578, 13893, // B780 - B7BF
                15638,  5882, 13874, 20283, 20283,  4075, 13860, 10455, // B7C0 - B7FF
                13852, 13844, 13825, 13785,  4684, 13747,  4652, 13735, // B800 - B83F
                13721, 20283,  3143, 10210, 13707, 10143,  5839, 13693, // B840 - B87F
                20283, 22259,  6503, 20283, 20283, 13647, 13626, 13599, // B880 - B8BF
                13522,  9890, 13504, 16064,  3077, 13481, 13446, 13427, // B8C0 - B8FF
                 9804, 20283, 15599, 13417, 13407, 20283, 20283,  9717, // B900 - B93F
                13385,  9655,  5784, 13363, 13337, 13317, 15251, 13303, // B940 - B97F
                 9466,  5728, 13293, 20283, 20283,  9431, 13271,  9377, // B980 - B9BF
                 5676, 13263, 13234, 13226,  5597, 13207,  9359, 13194, // B9C0 - B9FF
                13176, 13166, 17040,  9134, 20283, 20283, 20283, 13148, // BA00 - BA3F
                13129, 13105, 22600, 13080, 19880, 13049, 13030, 12989, // BA40 - BA7F
                12981, 19846, 20283, 20283, 20283, 12973, 12961, 12922, // BA80 - BABF
                 3092, 12912, 20283, 12882, 12860, 20283, 20283,  4047, // BAC0 - BAFF
                12823, 20512,  2861, 12805, 12795,  5515,  8519, 12779, // BB00 - BB3F
                13438,  5497, 12749, 12739,  5420,  8412, 20283, 20283, // BB40 - BB7F
                20283, 12725, 12707, 20283, 19578, 12693,  8118, 20283, // BB80 - BBBF
                12671, 12661, 12632,  7952, 12622, 20283, 20283, 12614, // BBC0 - BBFF
                12573, 12565,  5362, 12557, 19485, 12542, 12534, 12508, // BC00 - BC3F
                12462,  2807, 12452,  7745, 20283, 12405, 20283, 20283, // BC40 - BC7F
                19391, 12358,  7411, 12344, 12336, 12286, 12262,  5299, // BC80 - BCBF
                12248,  7327, 12229, 12215, 20283, 20283,  7220, 12180, // BCC0 - BCFF
                 3695,  5212, 12162, 20283,  3097, 19086, 20283, 20283, // BD00 - BD3F
                12144, 12105, 12087, 12075,  6772, 12050, 20283, 20283, // BD40 - BD7F
                12042, 12015, 12007,  5162,  6468, 20283, 11993, 11983, // BD80 - BDBF
                20283, 20283,  6357, 11955, 20283,  5108, 11932, 11914, // BDC0 - BDFF
                11877,  6309, 11812, 11804,  4993, 11767, 20283, 20283, // BE00 - BE3F
                 6210, 11741, 11284,  4970, 11720, 11657, 11634,  3102, // BE40 - BE7F
                11612, 18731, 11600, 11576, 20283, 11566,  6093, 20283, // BE80 - BEBF
                20283, 20283, 11558, 11504, 11471,  6013, 11441, 15338, // BEC0 - BEFF
                 4951, 11398, 20283, 11364,  5861, 20283, 20283, 20283, // BF00 - BF3F
                11327, 11292, 11273, 18568, 20283, 20283, 20283, 11236, // BF40 - BF7F
                20283, 20283, 18483, 20283, 20283, 20283, 11218, 20283, // BF80 - BFBF
                11203, 10221, 11182,  9949,  2578, 11172, 20283, 20283, // BFC0 - BFFF
                 5652, 20283, 20283, 20283, 11154, 20283, 20283,  8952, // C000 - C03F
                20283, 20283,  4888, 11140, 11114, 11086,  5399, 20283, // C040 - C07F
                20283, 20283, 11047, 11010, 10983,  5281, 10975, 13496, // C080 - C0BF
                10967, 10959, 10934, 10919,  4064, 10905,  5197,  4816, // C0C0 - C0FF
                10882, 10872, 10834,  1841, 10826, 17887, 10791, 10783, // C100 - C13F
                10765, 10745,  4801, 10731,  4933, 10705, 10685, 10644, // C140 - C17F
                20377, 17576, 10618,  7354,  2428, 10568, 10542, 11852, // C180 - C1BF
                16971, 10490,  2531, 10463, 10445, 10427, 10344, 16098, // C1C0 - C1FF
                10314, 15748,  4670, 10306, 10257, 10249,  4642, 20283, // C200 - C23F
                20283, 10239, 10200, 10181, 10151, 15511, 10133, 15440, // C240 - C27F
                 2380, 10119, 10085, 10058, 13238, 10034, 21375,  4609, // C280 - C2BF
                10012, 20283, 20283, 13133,  9980, 13218,  4519,  9957, // C2C0 - C2FF
                 9934,  9913, 18967,  9880, 12965,  9868,  9838, 20283, // C300 - C33F
                22408, 12577, 20283, 20283, 20283,  9818,  9790,  9732, // C340 - C37F
                12019,  9707, 20283,  4494,  9689, 20283, 20283, 11661, // C380 - C3BF
                 9671, 20283, 20283,  9663,  9641,  9602,  9938,  9588, // C3C0 - C3FF
                20283,  9578,  9538, 20283,  9794,  9645,  9524,  8566, // C400 - C43F
                20283,  9506, 20283, 20283,  8138,  9492,  7986,  4471, // C440 - C47F
                 9474, 20283, 22376,  7811, 20283, 20283, 20283,  9456, // C480 - C4BF
                20283, 20283, 22381, 20283, 20283,  4348,  9421,  9413, // C4C0 - C4FF
                 9385,  7317,  9367,  4377, 20283,  9349,  9310,  9302, // C500 - C53F
                 3809,  9294, 22386,  9286,  9259,  9213,  9198,  3125, // C540 - C57F
                 9190,  2695,  9182,  9124,  9106,  4237,   466,  9057, // C580 - C5BF
                 4333,  9041,  9004,  8974,  8941,  4306,  8933, 15157, // C5C0 - C5FF
                 8925,  8905,  8870,  8849, 16571,  8822,  8814,  4193, // C600 - C63F
                 8784,  8766,  8733, 19602,  8723, 11975,  4157,  8697, // C640 - C67F
                 8639,  8618, 19354,  8582, 12328,  4033,  8574,  8562, // C680 - C6BF
                 8543, 11032,  8509,  8996,  8497,  8469,  8459,  8434, // C6C0 - C6FF
                 7061,  8402, 22240,  4002,  8374,  8364,  8356, 21989, // C700 - C73F
                 8326,  4741,  3984,  8295,  8272,  8244, 19051,  8220, // C740 - C77F
                13041,  8177,  8169,  8134,  8126,  4635,  8108, 21194, // C780 - C7BF
                 8078,  8054,  8031,  8016, 19715,  8002, 20283, 20283, // C7C0 - C7FF
                 7994,  7982,  7966, 12897,  7942, 20785,  3919,  7928, // C800 - C83F
                 7902,  7875, 19320, 20283, 20283, 20283,  7831,  7807, // C840 - C87F
                 7799,  5531,  7778, 18602,  7731,  7687,  7661,  7640, // C880 - C8BF
                14919,  7615,  9972,  3897,  7590,  7565,  7545, 18440, // C8C0 - C8FF
                 7528, 17643,  3816,  7482, 20283, 20662, 13562, 20283, // C900 - C93F
                20283, 20283,  7468,  7458,  7441, 13576,  7419, 20343, // C940 - C97F
                20283,  7401,  7362,  7343, 20171, 20283, 20283, 20283, // C980 - C9BF
                 7335,  7313,  7288,  3749,  7280, 20136,  7243,  7210, // C9C0 - C9FF
                 7174,  7142, 10407,  7124, 20283,  3681,  7096, 20283, // CA00 - CA3F
                20283, 16289,  7088, 10534,  7076,  7028,  6958, 20311, // CA40 - CA7F
                 5613, 20283, 15296,  6932,  6913, 20283, 20283,  9244, // CA80 - CABF
                 6886, 21481,  3632,  6858,  6829, 21417, 19096, 20283, // CAC0 - CAFF
                20283,  6811,  6762,  6733,  6713,  6782, 20283, 20283, // CB00 - CB3F
                 3510,  6699,  6680,  6628, 14882, 20283, 20283,  6592, // CB40 - CB7F
                 6566, 20283, 20283, 19923, 20283, 20283, 20283,  6537, // CB80 - CBBF
                20283, 20283, 15918, 20283, 18719,  3458,  6482, 20283, // CBC0 - CBFF
                20283, 16307,  6458, 12874,  3399,  6450,  6398,  6390, // CC00 - CC3F
                 2373,  6347,  5954,  6295,  6270,  6248,  6229, 14905, // CC40 - CC7F
                20283, 20283, 20283,  6200,  6181,  6124, 18334,  6083, // CC80 - CCBF
                14001,  3377,  6003, 20283, 20667, 13948,  5962, 20283, // CCC0 - CCFF
                 3242,  5938,  5900,  5875, 13548,  5851, 20283,  3132, // CD00 - CD3F
                 5829, 20283, 20283, 11250,  5807, 14562,  3055,  5796, // CD40 - CD7F
                20283,  5774, 10803,  5744,  2964,  2926,  5718, 20283, // CD80 - CDBF
                16356, 14292,  5666, 20283, 20283,  5642,  5631,  5590, // CDC0 - CDFF
                10477,  5576,  7854,  2844,  5562,  5505,  5490, 10520, // CE00 - CE3F
                20283, 20283, 20283,  5482,  5437,  5413,  2480,  5389, // CE40 - CE7F
                14160,  1942,  5381,  5370,  5355,  2800, 20283, 20283, // CE80 - CEBF
                 2781,  5289, 20283, 20283, 17101,  5271,  8715,  5205, // CEC0 - CEFF
                 5187,  5176,  5155,  1831,  5120,  8100,  5097,  5078, // CF00 - CF3F
                20283, 20283,  7496,  5048,  5429,  2673,  5026,  4983, // CF40 - CF7F
                 4963,  6998,  4941, 15226,  2567,  4923,  4878, 20256, // CF80 - CFBF
                 7300, 20283, 20283, 20283,  4854,  4843,  4809,  6615, // CFC0 - CFFF
                 4788, 20283,  2517,  4769, 20283,  6043,  7188,  4749, // D000 - D03F
                 7166,  2405,  4735,  4715,  4660, 10353,  4629,  7042, // D040 - D07F
                 2363,  4599, 20283, 20283,  4246,  4557, 16155, 17414, // D080 - D0BF
                 4506,  4483,  4464,  8253,  4449,  7450,  4437,  4418, // D0C0 - D0FF
                20283,  5316,  6972, 20283, 20283, 20283,  4403,  4373, // D100 - D13F
                 4341,  6843,  4322, 22182,  4291,  4276, 20283, 21659, // D140 - D17F
                 6282,  4227, 20283, 20283,  4212,  4183,  4150,  4563, // D180 - D1BF
                 4139, 20283, 20283,  4128, 20283, 20283, 20429,  4023, // D1C0 - D1FF
                15058,  1790,  3992, 20283, 20283, 17632,  3967,  5995, // D200 - D23F
                 2306,  3956, 20283,  5453, 15356, 20283, 15049, 20283, // D240 - D27F
                 3938,  3909,  3890,  4910,  3842,  6070,  2254,  3834, // D280 - D2BF
                 3805,  3742,  4581,  3703, 11356, 20283,  3664,  3645, // D2C0 - D2FF
                 3625,  4569,  3609, 22303,  3585,  3554,  3522,  3503, // D300 - D33F
                20646, 20283, 20283,  2191,  3492, 20283, 20283, 17051, // D340 - D37F
                 3441,  2100,  3422,  3407,  3389,  3370,  4512,  3355, // D380 - D3BF
                14041,  3298,  3287,  3232,  2140,  6522,  3208,  9905, // D3C0 - D3FF
                21682,  3197, 20283, 11840, 20106, 20283, 20283, 20283, // D400 - D43F
                 3179, 20283, 20283,  6054,  3164, 21162, 20283,  3156, // D440 - D47F
                 3121,  3048, 20358, 20283, 20283,  2077,  3021, 20283, // D480 - D4BF
                20283, 22634,  3006, 13514, 20283,  2983,  2972,  2919, // D4C0 - D4FF
                20367,  2896,  2888,  2040,  2873, 20283, 20283, 22513, // D500 - D53F
                 2830, 22458,  1924,  2822,  2793,  2774,  1824,  2741, // D540 - D57F
                19626,  2722,  2711, 20283, 10370, 22371, 20283, 20283, // D580 - D5BF
                20283,  2703,  2691,  2666,  9149,  2651, 22359, 17378, // D5C0 - D5FF
                 2550,  2539,  2510, 19014,  2495, 18068, 20283,  2451, // D600 - D63F
                 2398,  2356, 17407,  2341, 15040,  1769,  2289, 20283, // D640 - D67F
                16361, 17788,  2274, 10231,  1713,  2240,  2181,  2168, // D680 - D6BF
                17221,  2123,    35, 21671,  2108,  2067,  2033, 17978, // D6C0 - D6FF
                 1996, 20657, 21437,  1981,  1970,  1917, 22053,  1877, // D700 - D73F
                19778, 20770,  1869,  1849,  1817, 17371,  1802, 12115, // D740 - D77F
                17389,  1752,  1741,  1706, 20283, 20283, 20283, 20283, // D780 - D7BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // D7C0 - D7FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // D800 - D83F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // D840 - D87F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // D880 - D8BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // D8C0 - D8FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // D900 - D93F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // D940 - D97F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // D980 - D9BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // D9C0 - D9FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DA00 - DA3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DA40 - DA7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DA80 - DABF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DAC0 - DAFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DB00 - DB3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DB40 - DB7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DB80 - DBBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DBC0 - DBFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DC00 - DC3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DC40 - DC7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DC80 - DCBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DCC0 - DCFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DD00 - DD3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DD40 - DD7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DD80 - DDBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DDC0 - DDFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DE00 - DE3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DE40 - DE7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DE80 - DEBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DEC0 - DEFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DF00 - DF3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DF40 - DF7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DF80 - DFBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // DFC0 - DFFF
                 1698,  1690,  1682,  1674,  1666,  1658,  1650,  1642, // E000 - E03F
                 1634,  1626,  1618,  1610,  1602,  1594,  1586,  1578, // E040 - E07F
                 1570,  1562,  1554,  1546,  1538,  1530,  1522,  1514, // E080 - E0BF
                 1506,  1498,  1490,  1482,  1474,  1466,  1458,  1450, // E0C0 - E0FF
                 1442,  1434,  1426,  1418,  1410,  1402,  1394,  1386, // E100 - E13F
                 1378,  1370,  1362,  1354,  1346,  1338,  1330,  1322, // E140 - E17F
                 1314,  1306,  1298,  1290,  1282,  1274,  1266,  1258, // E180 - E1BF
                 1250,  1242,  1234,  1226,  1218,  1210,  1202,  1194, // E1C0 - E1FF
                 1186,  1178,  1170,  1162,  1154,  1146,  1138,  1130, // E200 - E23F
                 1122,  1114,  1106,  1098,  1090,  1082,  1074,  1066, // E240 - E27F
                 1058,  1050,  1042,  1034,  1026,  1018,  1010,  1002, // E280 - E2BF
                  994,   986,   978,   970,   962,   954,   946,   938, // E2C0 - E2FF
                  930,   922,   914,   906,   898,   890,   882,   874, // E300 - E33F
                  866,   858,   850,   842,   834,   826,   818,   810, // E340 - E37F
                  802,   794,   786,   778,   770,   762,   754,   746, // E380 - E3BF
                  738,   730,   722,   714,   706,   698,   690,   682, // E3C0 - E3FF
                  674,   666,   658,   650,   642,   634,   626,   618, // E400 - E43F
                  610,   602,   594,   586,   578,   570,   562,   554, // E440 - E47F
                  546,   538,   530,   522,   514,   506,   498,   490, // E480 - E4BF
                  482,   462, 20283, 20283, 20283, 20283, 20283, 20283, // E4C0 - E4FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E500 - E53F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E540 - E57F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E580 - E5BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E5C0 - E5FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E600 - E63F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E640 - E67F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E680 - E6BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E6C0 - E6FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E700 - E73F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E740 - E77F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E780 - E7BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E7C0 - E7FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E800 - E83F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E840 - E87F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E880 - E8BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E8C0 - E8FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E900 - E93F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E940 - E97F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E980 - E9BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // E9C0 - E9FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EA00 - EA3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EA40 - EA7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EA80 - EABF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EAC0 - EAFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EB00 - EB3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EB40 - EB7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EB80 - EBBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EBC0 - EBFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EC00 - EC3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EC40 - EC7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EC80 - ECBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // ECC0 - ECFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // ED00 - ED3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // ED40 - ED7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // ED80 - EDBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EDC0 - EDFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EE00 - EE3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EE40 - EE7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EE80 - EEBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EEC0 - EEFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EF00 - EF3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EF40 - EF7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EF80 - EFBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // EFC0 - EFFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F000 - F03F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F040 - F07F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F080 - F0BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F0C0 - F0FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F100 - F13F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F140 - F17F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F180 - F1BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F1C0 - F1FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F200 - F23F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F240 - F27F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F280 - F2BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F2C0 - F2FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F300 - F33F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F340 - F37F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F380 - F3BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F3C0 - F3FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F400 - F43F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F440 - F47F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F480 - F4BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F4C0 - F4FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F500 - F53F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F540 - F57F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F580 - F5BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F5C0 - F5FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F600 - F63F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F640 - F67F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F680 - F6BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F6C0 - F6FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F700 - F73F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F740 - F77F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F780 - F7BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F7C0 - F7FF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F800 - F83F
                15217,   454,   446,   438,   430,   407, 20283, 20283, // F840 - F87F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F880 - F8BF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // F8C0 - F8FF
                  399,   391,   383,   375,   367,   359,   351,   343, // F900 - F93F
                  335,   327,   319,   311,   303,   295,   287,   279, // F940 - F97F
                  271,   263,   255,   247,   239,   231,   223,   215, // F980 - F9BF
                  207,   199,   191,   183,   175,   167,   159,   151, // F9C0 - F9FF
                  143,   123, 20283, 20283, 20283, 20283, 20283, 20283, // FA00 - FA3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FA40 - FA7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FA80 - FABF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FAC0 - FAFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FB00 - FB3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FB40 - FB7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FB80 - FBBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FBC0 - FBFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FC00 - FC3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FC40 - FC7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FC80 - FCBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FCC0 - FCFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FD00 - FD3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FD40 - FD7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FD80 - FDBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FDC0 - FDFF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FE00 - FE3F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FE40 - FE7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FE80 - FEBF
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FEC0 - FEFF
                16846,   115,   107,    99,    91,    83,    75,    67, // FF00 - FF3F
                   59,    51,    43,    28, 20283, 20283, 20283, 20283, // FF40 - FF7F
                20283, 20283, 20283, 20283, 20283, 20283, 20283, 20283, // FF80 - FFBF
                20283, 20283, 20283, 20283,     0, 20283, 20283, 20283,
        };

        protected static String index2 =
                "\uA1CB\uA1CC\uA1FE\uA3FE\u9AAA\uA1CD\uA3DC\u0000\uD7B9\u0000" + //     0 -     9
                "\uE9C3\u9CB0\uE8FD\uE8AF\u0000\u0000\uDFBB\u0000\u0000\uF3A5" + //    10 -    19
                "\u0000\u0000\u0000\uEFB5\u0000\u0000\u0000\uFAE9\uA3F8\uA3F9" + //    20 -    29
                "\uA3FA\uA3FB\uA3FC\uA3FD\u0000\u0000\uC8C8\u0000\u0000\uC8C9" + //    30 -    39
                "\uA0FC\u0000\uC8CA\uA3F0\uA3F1\uA3F2\uA3F3\uA3F4\uA3F5\uA3F6" + //    40 -    49
                "\uA3F7\uA3E8\uA3E9\uA3EA\uA3EB\uA3EC\uA3ED\uA3EE\uA3EF\uA3E0" + //    50 -    59
                "\uA3E1\uA3E2\uA3E3\uA3E4\uA3E5\uA3E6\uA3E7\uA3D8\uA3D9\uA3DA" + //    60 -    69
                "\uA3DB\uA1AC\uA3DD\uA3DE\uA3DF\uA3D0\uA3D1\uA3D2\uA3D3\uA3D4" + //    70 -    79
                "\uA3D5\uA3D6\uA3D7\uA3C8\uA3C9\uA3CA\uA3CB\uA3CC\uA3CD\uA3CE" + //    80 -    89
                "\uA3CF\uA3C0\uA3C1\uA3C2\uA3C3\uA3C4\uA3C5\uA3C6\uA3C7\uA3B8" + //    90 -    99
                "\uA3B9\uA3BA\uA3BB\uA3BC\uA3BD\uA3BE\uA3BF\uA3B0\uA3B1\uA3B2" + //   100 -   109
                "\uA3B3\uA3B4\uA3B5\uA3B6\uA3B7\uA3A8\uA3A9\uA3AA\uA3AB\uA3AC" + //   110 -   119
                "\uA3AD\uA3AE\uA3AF\uFAA1\uFAA2\uFAE6\uFCA9\u0000\u0000\u0000" + //   120 -   129
                "\u0000\uFBC6\uCFB3\u0000\u0000\u0000\uF9AF\u0000\u0000\u0000" + //   130 -   139
                "\u0000\u0000\uD2FB\uF4EE\uF6F4\uF6F6\uF7B8\uF7C8\uF7D3\uF8DB" + //   140 -   149
                "\uF8F0\uEDA2\uEDA3\uEDEE\uEEDB\uF2BD\uF2FA\uF3B1\uF4A7\uECE1" + //   150 -   159
                "\uECE4\uECE7\uECE8\uECF7\uECF8\uECFA\uEDA1\uECC1\uECC5\uECC6" + //   160 -   169
                "\uECC9\uECCA\uECD5\uECDD\uECDE\uECAF\uECB0\uECB1\uECB2\uECB5" + //   170 -   179
                "\uECB8\uECBA\uECC0\uEBCF\uEBD0\uEBD1\uEBD2\uEBD8\uECA6\uECA7" + //   180 -   189
                "\uECAA\uEBBA\uEBBB\uEBBD\uEBC1\uEBC2\uEBC6\uEBC7\uEBCC\uEAF4" + //   190 -   199
                "\uEAF7\uEAFC\uEAFE\uEBA4\uEBA7\uEBA9\uEBAA\uE8FB\uE8FE\uE9A7" + //   200 -   209
                "\uE9AC\uE9CC\uE9F7\uEAC1\uEAE5\uE7E6\uE7F7\uE8E7\uE8E8\uE8F0" + //   210 -   219
                "\uE8F1\uE8F7\uE8F9\uE7C7\uE7CB\uE7CD\uE7CF\uE7D0\uE7D3\uE7DF" + //   220 -   229
                "\uE7E4\uE7A9\uE7AA\uE7AC\uE7AD\uE7B0\uE7BF\uE7C1\uE7C6\uE6F1" + //   230 -   239
                "\uE6F2\uE6F5\uE6F6\uE6F7\uE6F9\uE7A1\uE7A6\uE6E4\uE6E5\uE6E6" + //   240 -   249
                "\uE6E8\uE6EA\uE6EB\uE6EC\uE6EF\uE6C7\uE6CA\uE6D2\uE6D6\uE6D9" + //   250 -   259
                "\uE6DC\uE6DF\uE6E1\uE6B0\uE6B1\uE6B3\uE6B7\uE6B8\uE6BC\uE6C4" + //   260 -   269
                "\uE6C6\uE5FB\uE5FC\uE5FE\uE6A1\uE6A4\uE6A7\uE6AD\uE6AF\uE5BB" + //   270 -   279
                "\uE5BC\uE5C4\uE5CE\uE5D0\uE5D2\uE5D6\uE5FA\uE1ED\uE3F5\uE4A1" + //   280 -   289
                "\uE4A9\uE5AE\uE5B1\uE5B2\uE5B9\uDDF4\uDEFC\uDEFE\uDFB3\uDFE1" + //   290 -   299
                "\uDFE8\uE0F1\uE1AD\uD6CD\uD7CB\uD7E4\uDBC5\uDBE4\uDCA5\uDDA5" + //   300 -   309
                "\uDDD5\uD2F7\uD2F8\uD4E6\uD4FC\uD5A5\uD5AB\uD5AE\uD6B8\uD2EA" + //   310 -   319
                "\uD2EB\uD2F0\uD2F1\uD2F2\uD2F3\uD2F4\uD2F5\uD2E1\uD2E2\uD2E4" + //   320 -   329
                "\uD2E5\uD2E6\uD2E7\uD2E8\uD2E9\uD2D4\uD2D5\uD2D6\uD2D7\uD2D9" + //   330 -   339
                "\uD2DA\uD2DE\uD2DF\uD2CB\uD2CD\uD2CE\uD2CF\uD2D0\uD2D1\uD2D2" + //   340 -   349
                "\uD2D3\uD2C2\uD2C3\uD2C4\uD2C6\uD2C7\uD2C8\uD2C9\uD2CA\uD2A7" + //   350 -   359
                "\uD2A8\uD2A9\uD2AA\uD2AB\uD2AD\uD2B2\uD2BE\uD1F2\uD1F6\uD1FA" + //   360 -   369
                "\uD1FC\uD1FD\uD1FE\uD2A2\uD2A3\uD1E6\uD1E8\uD1E9\uD1EA\uD1EB" + //   370 -   379
                "\uD1ED\uD1EF\uD1F0\uD1DD\uD1DE\uD1DF\uD1E0\uD1E2\uD1E3\uD1E4" + //   380 -   389
                "\uD1E5\uD0B8\uD0D0\uD0DD\uD1D4\uD1D5\uD1D8\uD1DB\uD1DC\uCBD0" + //   390 -   399
                "\uCBD6\uCBE7\uCDCF\uCDE8\uCEAD\uCFFB\uD0A2\u9DDE\u9DE2\u9DEA" + //   400 -   409
                "\u9DF1\u9DF5\u9DF9\u9DFB\u0000\uE9DC\uD9C1\u0000\uF5F2\uE0C5" + //   410 -   419
                "\u9DAF\u0000\u0000\uDAFE\u0000\u0000\uCCBE\u0000\u0000\uF2FC" + //   420 -   429
                "\u9CCC\u9CD2\u9CD3\u9DB1\u9DBE\u9DC1\u9DD2\u9DD8\u9CA4\u9CA7" + //   430 -   439
                "\u9CA9\u9CAB\u9CB2\u9CB6\u9CBA\u9CBD\u9BD1\u9BE0\u9BE2\u9BE6" + //   440 -   449
                "\u9BEF\u9BF3\u9CA2\u9CA3\u9AD5\u9ADB\u9ADD\u9BA3\u9BA8\u9BAE" + //   450 -   459
                "\u9BC6\u9BCC\u9AA3\u9AA4\u9AA5\u0000\u0000\u0000\u0000\u0000" + //   460 -   469
                "\uBEEE\uBEEF\u9FFA\u0000\uF6FD\u0000\uDBF7\u0000\u0000\u0000" + //   470 -   479
                "\u0000\uFBEA\u99F9\u99FA\u99FB\u99FC\u99FD\u99FE\u9AA1\u9AA2" + //   480 -   489
                "\u99F1\u99F2\u99F3\u99F4\u99F5\u99F6\u99F7\u99F8\u99E9\u99EA" + //   490 -   499
                "\u99EB\u99EC\u99ED\u99EE\u99EF\u99F0\u99E1\u99E2\u99E3\u99E4" + //   500 -   509
                "\u99E5\u99E6\u99E7\u99E8\u99D9\u99DA\u99DB\u99DC\u99DD\u99DE" + //   510 -   519
                "\u99DF\u99E0\u99D1\u99D2\u99D3\u99D4\u99D5\u99D6\u99D7\u99D8" + //   520 -   529
                "\u99C9\u99CA\u99CB\u99CC\u99CD\u99CE\u99CF\u99D0\u99C1\u99C2" + //   530 -   539
                "\u99C3\u99C4\u99C5\u99C6\u99C7\u99C8\u99B9\u99BA\u99BB\u99BC" + //   540 -   549
                "\u99BD\u99BE\u99BF\u99C0\u99B1\u99B2\u99B3\u99B4\u99B5\u99B6" + //   550 -   559
                "\u99B7\u99B8\u99A9\u99AA\u99AB\u99AC\u99AD\u99AE\u99AF\u99B0" + //   560 -   569
                "\u99A1\u99A2\u99A3\u99A4\u99A5\u99A6\u99A7\u99A8\u98F7\u98F8" + //   570 -   579
                "\u98F9\u98FA\u98FB\u98FC\u98FD\u98FE\u98EF\u98F0\u98F1\u98F2" + //   580 -   589
                "\u98F3\u98F4\u98F5\u98F6\u98E7\u98E8\u98E9\u98EA\u98EB\u98EC" + //   590 -   599
                "\u98ED\u98EE\u98DF\u98E0\u98E1\u98E2\u98E3\u98E4\u98E5\u98E6" + //   600 -   609
                "\u98D7\u98D8\u98D9\u98DA\u98DB\u98DC\u98DD\u98DE\u98CF\u98D0" + //   610 -   619
                "\u98D1\u98D2\u98D3\u98D4\u98D5\u98D6\u98C7\u98C8\u98C9\u98CA" + //   620 -   629
                "\u98CB\u98CC\u98CD\u98CE\u98BF\u98C0\u98C1\u98C2\u98C3\u98C4" + //   630 -   639
                "\u98C5\u98C6\u98B7\u98B8\u98B9\u98BA\u98BB\u98BC\u98BD\u98BE" + //   640 -   649
                "\u98AF\u98B0\u98B1\u98B2\u98B3\u98B4\u98B5\u98B6\u98A7\u98A8" + //   650 -   659
                "\u98A9\u98AA\u98AB\u98AC\u98AD\u98AE\u97FD\u97FE\u98A1\u98A2" + //   660 -   669
                "\u98A3\u98A4\u98A5\u98A6\u97F5\u97F6\u97F7\u97F8\u97F9\u97FA" + //   670 -   679
                "\u97FB\u97FC\u97ED\u97EE\u97EF\u97F0\u97F1\u97F2\u97F3\u97F4" + //   680 -   689
                "\u97E5\u97E6\u97E7\u97E8\u97E9\u97EA\u97EB\u97EC\u97DD\u97DE" + //   690 -   699
                "\u97DF\u97E0\u97E1\u97E2\u97E3\u97E4\u97D5\u97D6\u97D7\u97D8" + //   700 -   709
                "\u97D9\u97DA\u97DB\u97DC\u97CD\u97CE\u97CF\u97D0\u97D1\u97D2" + //   710 -   719
                "\u97D3\u97D4\u97C5\u97C6\u97C7\u97C8\u97C9\u97CA\u97CB\u97CC" + //   720 -   729
                "\u97BD\u97BE\u97BF\u97C0\u97C1\u97C2\u97C3\u97C4\u97B5\u97B6" + //   730 -   739
                "\u97B7\u97B8\u97B9\u97BA\u97BB\u97BC\u97AD\u97AE\u97AF\u97B0" + //   740 -   749
                "\u97B1\u97B2\u97B3\u97B4\u97A5\u97A6\u97A7\u97A8\u97A9\u97AA" + //   750 -   759
                "\u97AB\u97AC\u96FB\u96FC\u96FD\u96FE\u97A1\u97A2\u97A3\u97A4" + //   760 -   769
                "\u96F3\u96F4\u96F5\u96F6\u96F7\u96F8\u96F9\u96FA\u96EB\u96EC" + //   770 -   779
                "\u96ED\u96EE\u96EF\u96F0\u96F1\u96F2\u96E3\u96E4\u96E5\u96E6" + //   780 -   789
                "\u96E7\u96E8\u96E9\u96EA\u96DB\u96DC\u96DD\u96DE\u96DF\u96E0" + //   790 -   799
                "\u96E1\u96E2\u96D3\u96D4\u96D5\u96D6\u96D7\u96D8\u96D9\u96DA" + //   800 -   809
                "\u96CB\u96CC\u96CD\u96CE\u96CF\u96D0\u96D1\u96D2\u96C3\u96C4" + //   810 -   819
                "\u96C5\u96C6\u96C7\u96C8\u96C9\u96CA\u96BB\u96BC\u96BD\u96BE" + //   820 -   829
                "\u96BF\u96C0\u96C1\u96C2\u96B3\u96B4\u96B5\u96B6\u96B7\u96B8" + //   830 -   839
                "\u96B9\u96BA\u96AB\u96AC\u96AD\u96AE\u96AF\u96B0\u96B1\u96B2" + //   840 -   849
                "\u96A3\u96A4\u96A5\u96A6\u96A7\u96A8\u96A9\u96AA\u95F9\u95FA" + //   850 -   859
                "\u95FB\u95FC\u95FD\u95FE\u96A1\u96A2\u95F1\u95F2\u95F3\u95F4" + //   860 -   869
                "\u95F5\u95F6\u95F7\u95F8\u95E9\u95EA\u95EB\u95EC\u95ED\u95EE" + //   870 -   879
                "\u95EF\u95F0\u95E1\u95E2\u95E3\u95E4\u95E5\u95E6\u95E7\u95E8" + //   880 -   889
                "\u95D9\u95DA\u95DB\u95DC\u95DD\u95DE\u95DF\u95E0\u95D1\u95D2" + //   890 -   899
                "\u95D3\u95D4\u95D5\u95D6\u95D7\u95D8\u95C9\u95CA\u95CB\u95CC" + //   900 -   909
                "\u95CD\u95CE\u95CF\u95D0\u95C1\u95C2\u95C3\u95C4\u95C5\u95C6" + //   910 -   919
                "\u95C7\u95C8\u95B9\u95BA\u95BB\u95BC\u95BD\u95BE\u95BF\u95C0" + //   920 -   929
                "\u95B1\u95B2\u95B3\u95B4\u95B5\u95B6\u95B7\u95B8\u95A9\u95AA" + //   930 -   939
                "\u95AB\u95AC\u95AD\u95AE\u95AF\u95B0\u95A1\u95A2\u95A3\u95A4" + //   940 -   949
                "\u95A5\u95A6\u95A7\u95A8\u94F7\u94F8\u94F9\u94FA\u94FB\u94FC" + //   950 -   959
                "\u94FD\u94FE\u94EF\u94F0\u94F1\u94F2\u94F3\u94F4\u94F5\u94F6" + //   960 -   969
                "\u94E7\u94E8\u94E9\u94EA\u94EB\u94EC\u94ED\u94EE\u94DF\u94E0" + //   970 -   979
                "\u94E1\u94E2\u94E3\u94E4\u94E5\u94E6\u94D7\u94D8\u94D9\u94DA" + //   980 -   989
                "\u94DB\u94DC\u94DD\u94DE\u94CF\u94D0\u94D1\u94D2\u94D3\u94D4" + //   990 -   999
                "\u94D5\u94D6\u94C7\u94C8\u94C9\u94CA\u94CB\u94CC\u94CD\u94CE" + //  1000 -  1009
                "\u94BF\u94C0\u94C1\u94C2\u94C3\u94C4\u94C5\u94C6\u94B7\u94B8" + //  1010 -  1019
                "\u94B9\u94BA\u94BB\u94BC\u94BD\u94BE\u94AF\u94B0\u94B1\u94B2" + //  1020 -  1029
                "\u94B3\u94B4\u94B5\u94B6\u94A7\u94A8\u94A9\u94AA\u94AB\u94AC" + //  1030 -  1039
                "\u94AD\u94AE\u93FD\u93FE\u94A1\u94A2\u94A3\u94A4\u94A5\u94A6" + //  1040 -  1049
                "\u93F5\u93F6\u93F7\u93F8\u93F9\u93FA\u93FB\u93FC\u93ED\u93EE" + //  1050 -  1059
                "\u93EF\u93F0\u93F1\u93F2\u93F3\u93F4\u93E5\u93E6\u93E7\u93E8" + //  1060 -  1069
                "\u93E9\u93EA\u93EB\u93EC\u93DD\u93DE\u93DF\u93E0\u93E1\u93E2" + //  1070 -  1079
                "\u93E3\u93E4\u93D5\u93D6\u93D7\u93D8\u93D9\u93DA\u93DB\u93DC" + //  1080 -  1089
                "\u93CD\u93CE\u93CF\u93D0\u93D1\u93D2\u93D3\u93D4\u93C5\u93C6" + //  1090 -  1099
                "\u93C7\u93C8\u93C9\u93CA\u93CB\u93CC\u93BD\u93BE\u93BF\u93C0" + //  1100 -  1109
                "\u93C1\u93C2\u93C3\u93C4\u93B5\u93B6\u93B7\u93B8\u93B9\u93BA" + //  1110 -  1119
                "\u93BB\u93BC\u93AD\u93AE\u93AF\u93B0\u93B1\u93B2\u93B3\u93B4" + //  1120 -  1129
                "\u93A5\u93A6\u93A7\u93A8\u93A9\u93AA\u93AB\u93AC\u92FB\u92FC" + //  1130 -  1139
                "\u92FD\u92FE\u93A1\u93A2\u93A3\u93A4\u92F3\u92F4\u92F5\u92F6" + //  1140 -  1149
                "\u92F7\u92F8\u92F9\u92FA\u92EB\u92EC\u92ED\u92EE\u92EF\u92F0" + //  1150 -  1159
                "\u92F1\u92F2\u92E3\u92E4\u92E5\u92E6\u92E7\u92E8\u92E9\u92EA" + //  1160 -  1169
                "\u92DB\u92DC\u92DD\u92DE\u92DF\u92E0\u92E1\u92E2\u92D3\u92D4" + //  1170 -  1179
                "\u92D5\u92D6\u92D7\u92D8\u92D9\u92DA\u92CB\u92CC\u92CD\u92CE" + //  1180 -  1189
                "\u92CF\u92D0\u92D1\u92D2\u92C3\u92C4\u92C5\u92C6\u92C7\u92C8" + //  1190 -  1199
                "\u92C9\u92CA\u92BB\u92BC\u92BD\u92BE\u92BF\u92C0\u92C1\u92C2" + //  1200 -  1209
                "\u92B3\u92B4\u92B5\u92B6\u92B7\u92B8\u92B9\u92BA\u92AB\u92AC" + //  1210 -  1219
                "\u92AD\u92AE\u92AF\u92B0\u92B1\u92B2\u92A3\u92A4\u92A5\u92A6" + //  1220 -  1229
                "\u92A7\u92A8\u92A9\u92AA\u91F9\u91FA\u91FB\u91FC\u91FD\u91FE" + //  1230 -  1239
                "\u92A1\u92A2\u91F1\u91F2\u91F3\u91F4\u91F5\u91F6\u91F7\u91F8" + //  1240 -  1249
                "\u91E9\u91EA\u91EB\u91EC\u91ED\u91EE\u91EF\u91F0\u91E1\u91E2" + //  1250 -  1259
                "\u91E3\u91E4\u91E5\u91E6\u91E7\u91E8\u91D9\u91DA\u91DB\u91DC" + //  1260 -  1269
                "\u91DD\u91DE\u91DF\u91E0\u91D1\u91D2\u91D3\u91D4\u91D5\u91D6" + //  1270 -  1279
                "\u91D7\u91D8\u91C9\u91CA\u91CB\u91CC\u91CD\u91CE\u91CF\u91D0" + //  1280 -  1289
                "\u91C1\u91C2\u91C3\u91C4\u91C5\u91C6\u91C7\u91C8\u91B9\u91BA" + //  1290 -  1299
                "\u91BB\u91BC\u91BD\u91BE\u91BF\u91C0\u91B1\u91B2\u91B3\u91B4" + //  1300 -  1309
                "\u91B5\u91B6\u91B7\u91B8\u91A9\u91AA\u91AB\u91AC\u91AD\u91AE" + //  1310 -  1319
                "\u91AF\u91B0\u91A1\u91A2\u91A3\u91A4\u91A5\u91A6\u91A7\u91A8" + //  1320 -  1329
                "\u90F7\u90F8\u90F9\u90FA\u90FB\u90FC\u90FD\u90FE\u90EF\u90F0" + //  1330 -  1339
                "\u90F1\u90F2\u90F3\u90F4\u90F5\u90F6\u90E7\u90E8\u90E9\u90EA" + //  1340 -  1349
                "\u90EB\u90EC\u90ED\u90EE\u90DF\u90E0\u90E1\u90E2\u90E3\u90E4" + //  1350 -  1359
                "\u90E5\u90E6\u90D7\u90D8\u90D9\u90DA\u90DB\u90DC\u90DD\u90DE" + //  1360 -  1369
                "\u90CF\u90D0\u90D1\u90D2\u90D3\u90D4\u90D5\u90D6\u90C7\u90C8" + //  1370 -  1379
                "\u90C9\u90CA\u90CB\u90CC\u90CD\u90CE\u90BF\u90C0\u90C1\u90C2" + //  1380 -  1389
                "\u90C3\u90C4\u90C5\u90C6\u90B7\u90B8\u90B9\u90BA\u90BB\u90BC" + //  1390 -  1399
                "\u90BD\u90BE\u90AF\u90B0\u90B1\u90B2\u90B3\u90B4\u90B5\u90B6" + //  1400 -  1409
                "\u90A7\u90A8\u90A9\u90AA\u90AB\u90AC\u90AD\u90AE\u8FFD\u8FFE" + //  1410 -  1419
                "\u90A1\u90A2\u90A3\u90A4\u90A5\u90A6\u8FF5\u8FF6\u8FF7\u8FF8" + //  1420 -  1429
                "\u8FF9\u8FFA\u8FFB\u8FFC\u8FED\u8FEE\u8FEF\u8FF0\u8FF1\u8FF2" + //  1430 -  1439
                "\u8FF3\u8FF4\u8FE5\u8FE6\u8FE7\u8FE8\u8FE9\u8FEA\u8FEB\u8FEC" + //  1440 -  1449
                "\u8FDD\u8FDE\u8FDF\u8FE0\u8FE1\u8FE2\u8FE3\u8FE4\u8FD5\u8FD6" + //  1450 -  1459
                "\u8FD7\u8FD8\u8FD9\u8FDA\u8FDB\u8FDC\u8FCD\u8FCE\u8FCF\u8FD0" + //  1460 -  1469
                "\u8FD1\u8FD2\u8FD3\u8FD4\u8FC5\u8FC6\u8FC7\u8FC8\u8FC9\u8FCA" + //  1470 -  1479
                "\u8FCB\u8FCC\u8FBD\u8FBE\u8FBF\u8FC0\u8FC1\u8FC2\u8FC3\u8FC4" + //  1480 -  1489
                "\u8FB5\u8FB6\u8FB7\u8FB8\u8FB9\u8FBA\u8FBB\u8FBC\u8FAD\u8FAE" + //  1490 -  1499
                "\u8FAF\u8FB0\u8FB1\u8FB2\u8FB3\u8FB4\u8FA5\u8FA6\u8FA7\u8FA8" + //  1500 -  1509
                "\u8FA9\u8FAA\u8FAB\u8FAC\uFEFB\uFEFC\uFEFD\uFEFE\u8FA1\u8FA2" + //  1510 -  1519
                "\u8FA3\u8FA4\uFEF3\uFEF4\uFEF5\uFEF6\uFEF7\uFEF8\uFEF9\uFEFA" + //  1520 -  1529
                "\uFEEB\uFEEC\uFEED\uFEEE\uFEEF\uFEF0\uFEF1\uFEF2\uFEE3\uFEE4" + //  1530 -  1539
                "\uFEE5\uFEE6\uFEE7\uFEE8\uFEE9\uFEEA\uFEDB\uFEDC\uFEDD\uFEDE" + //  1540 -  1549
                "\uFEDF\uFEE0\uFEE1\uFEE2\uFED3\uFED4\uFED5\uFED6\uFED7\uFED8" + //  1550 -  1559
                "\uFED9\uFEDA\uFECB\uFECC\uFECD\uFECE\uFECF\uFED0\uFED1\uFED2" + //  1560 -  1569
                "\uFEC3\uFEC4\uFEC5\uFEC6\uFEC7\uFEC8\uFEC9\uFECA\uFEBB\uFEBC" + //  1570 -  1579
                "\uFEBD\uFEBE\uFEBF\uFEC0\uFEC1\uFEC2\uFEB3\uFEB4\uFEB5\uFEB6" + //  1580 -  1589
                "\uFEB7\uFEB8\uFEB9\uFEBA\uFEAB\uFEAC\uFEAD\uFEAE\uFEAF\uFEB0" + //  1590 -  1599
                "\uFEB1\uFEB2\uFEA3\uFEA4\uFEA5\uFEA6\uFEA7\uFEA8\uFEA9\uFEAA" + //  1600 -  1609
                "\uC9F9\uC9FA\uC9FB\uC9FC\uC9FD\uC9FE\uFEA1\uFEA2\uC9F1\uC9F2" + //  1610 -  1619
                "\uC9F3\uC9F4\uC9F5\uC9F6\uC9F7\uC9F8\uC9E9\uC9EA\uC9EB\uC9EC" + //  1620 -  1629
                "\uC9ED\uC9EE\uC9EF\uC9F0\uC9E1\uC9E2\uC9E3\uC9E4\uC9E5\uC9E6" + //  1630 -  1639
                "\uC9E7\uC9E8\uC9D9\uC9DA\uC9DB\uC9DC\uC9DD\uC9DE\uC9DF\uC9E0" + //  1640 -  1649
                "\uC9D1\uC9D2\uC9D3\uC9D4\uC9D5\uC9D6\uC9D7\uC9D8\uC9C9\uC9CA" + //  1650 -  1659
                "\uC9CB\uC9CC\uC9CD\uC9CE\uC9CF\uC9D0\uC9C1\uC9C2\uC9C3\uC9C4" + //  1660 -  1669
                "\uC9C5\uC9C6\uC9C7\uC9C8\uC9B9\uC9BA\uC9BB\uC9BC\uC9BD\uC9BE" + //  1670 -  1679
                "\uC9BF\uC9C0\uC9B1\uC9B2\uC9B3\uC9B4\uC9B5\uC9B6\uC9B7\uC9B8" + //  1680 -  1689
                "\uC9A9\uC9AA\uC9AB\uC9AC\uC9AD\uC9AE\uC9AF\uC9B0\uC9A1\uC9A2" + //  1690 -  1699
                "\uC9A3\uC9A4\uC9A5\uC9A6\uC9A7\uC9A8\uC8FB\uC8FC\u0000\uC8FD" + //  1700 -  1709
                "\u0000\uC8FE\u0000\u0000\uC8BE\u0000\u0000\u0000\u0000\u0000" + //  1710 -  1719
                "\u0000\uE9CA\u0000\uE1F0\u0000\uE6FC\u0000\u0000\uD7FB\uD0D6" + //  1720 -  1729
                "\uDDF5\uF7F1\u0000\uA8C1\uA8C2\uA8C3\uA8C4\uA8C5\uA8C6\uA8C7" + //  1730 -  1739
                "\uA8C8\uC8FA\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uE6EE" + //  1740 -  1749
                "\u0000\uCCDC\uC8F7\uC8F8\u0000\u0000\uC8F9\u0000\u0000\u0000" + //  1750 -  1759
                "\uE3B5\u0000\u0000\u0000\u0000\u0000\u0000\uE8B2\u0000\u0000" + //  1760 -  1769
                "\uC8B2\u0000\u0000\u0000\u0000\u0000\u0000\uCCC7\u0000\u0000" + //  1770 -  1779
                "\u0000\uCBFB\u0000\u0000\u0000\u0000\u0000\u0000\uE6DD\u0000" + //  1780 -  1789
                "\u0000\uC5F3\u0000\u0000\u0000\u0000\u0000\u0000\uF2BE\uF6A1" + //  1790 -  1799
                "\u0000\uEBCB\uC8F2\u0000\u0000\u0000\uC8F3\u0000\u0000\u0000" + //  1800 -  1809
                "\uCCCD\u0000\uDAFA\u0000\uF6CF\u0000\uE9B8\uC8EC\uC8ED\u0000" + //  1810 -  1819
                "\uC8EE\u0000\uC8EF\u0000\u0000\uA0F6\u0000\u0000\uC7D8\uC7D9" + //  1820 -  1829
                "\u0000\u0000\uA0D6\u0000\u0000\uC4D1\u0000\u0000\u0000\uEDCE" + //  1830 -  1839
                "\u0000\u0000\u0000\u0000\u0000\uBCAD\uBCAE\uBCAF\uBCB0\uC8EA" + //  1840 -  1849
                "\uC8EB\u0000\u0000\u0000\u0000\u0000\u0000\uF9EF\uCFF4\uF7E6" + //  1850 -  1859
                "\u0000\uCDE4\u0000\uD1AE\uDCED\uE8CE\u0000\uF0F9\uCEB5\uC8E5" + //  1860 -  1869
                "\uC8E6\u0000\u0000\uC8E7\u0000\uC8E8\uC8E9\uC8E0\u0000\u0000" + //  1870 -  1879
                "\u0000\uC8E1\u0000\u0000\u0000\uF0A5\uCBFD\u0000\u0000\u0000" + //  1880 -  1889
                "\u0000\u0000\uCDE6\u0000\u0000\u0000\u9BBB\u0000\u0000\uF2D8" + //  1890 -  1899
                "\u0000\uEFA2\uE2DA\uF6FC\u0000\u0000\uFBD0\uD1AD\u0000\uA8B9" + //  1900 -  1909
                "\uA8BA\uA8BB\uA8BC\uA8BD\uA8BE\uA8BF\uA8C0\uC8DA\uC8DB\u0000" + //  1910 -  1919
                "\uC8DC\u0000\uC8DD\u0000\u0000\uC7CE\u0000\u0000\u0000\u0000" + //  1920 -  1929
                "\u0000\u0000\uE4C8\u0000\u0000\u0000\uF3DA\u0000\uCBC1\u0000" + //  1930 -  1939
                "\uDBC3\u0000\u0000\uC4B2\u0000\u0000\u0000\u0000\u0000\u0000" + //  1940 -  1949
                "\uFBDD\u0000\uEFCA\u0000\uF1C1\u0000\u9CEF\uE2E9\uDCCA\uECB4" + //  1950 -  1959
                "\uFAC0\u0000\uA8B1\uA8B2\uA8B3\uA8B4\uA8B5\uA8B6\uA8B7\uA8B8" + //  1960 -  1969
                "\uC8D9\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uF2D0\u0000" + //  1970 -  1979
                "\uEAFB\uC8D6\uC8D7\u0000\u0000\uC8D8\u0000\u0000\u0000\uEDA5" + //  1980 -  1989
                "\uEEF2\u0000\u0000\u0000\u0000\uDCF9\uC8D3\u0000\u0000\u0000" + //  1990 -  1999
                "\uC8D4\u0000\u0000\u0000\uD7D7\uDFA2\u0000\u0000\u0000\uCEBE" + //  2000 -  2009
                "\u0000\uDAD6\u0000\uCAB1\u0000\u0000\u0000\u0000\u0000\uB5C5" + //  2010 -  2019
                "\u0000\u0000\u0000\uDEAC\u0000\u0000\u0000\u0000\uEDC5\uF3D6" + //  2020 -  2029
                "\u0000\u0000\uDED9\uC8CF\u0000\u0000\u0000\u0000\uC8D0\u0000" + //  2030 -  2039
                "\u0000\uA0F0\u0000\u0000\u0000\u0000\u0000\u0000\uD6E2\u0000" + //  2040 -  2049
                "\u0000\u0000\uE7EB\uF1D5\u0000\u0000\u0000\uF0BB\u0000\uD1AC" + //  2050 -  2059
                "\u0000\u0000\u0000\u0000\u0000\u0000\uDAC7\uC8CE\u0000\u0000" + //  2060 -  2069
                "\u0000\u0000\u0000\u0000\u0000\u9DC5\u0000\u0000\uC7B5\u0000" + //  2070 -  2079
                "\u0000\u0000\u0000\u0000\u0000\uE0A7\u0000\u0000\u0000\uE5F9" + //  2080 -  2089
                "\uECEA\uDDD6\uEDC2\u9AC5\u9ADA\u0000\uE2AE\u0000\uD3B7\uFACC" + //  2090 -  2099
                "\u0000\u0000\u0000\u0000\uC6DF\uC6E0\u0000\uC6E1\uC8CC\u0000" + //  2100 -  2109
                "\u0000\u0000\uC8CD\u0000\u0000\u0000\uFAFD\u0000\u0000\u0000" + //  2110 -  2119
                "\u0000\u0000\uD6AA\uC8C6\u0000\u0000\u0000\uC8C7\u0000\u0000" + //  2120 -  2129
                "\u0000\uDBED\u0000\u0000\u0000\u0000\u0000\u0000\uEFA9\u0000" + //  2130 -  2139
                "\u0000\uC6F5\u0000\uC6F6\u0000\u0000\u0000\u0000\uE4EA\uF2CF" + //  2140 -  2149
                "\u0000\uF7BF\u0000\uE7BE\u0000\uFCF2\u0000\u0000\uD6B4\u0000" + //  2150 -  2159
                "\u0000\u9BA2\u0000\u0000\u9AD0\u0000\u0000\uD7A9\uA0FB\uC8C2" + //  2160 -  2169
                "\u0000\uC8C3\u0000\u0000\u0000\u0000\uD9EC\u0000\uD9BD\u0000" + //  2170 -  2179
                "\uD8DF\uC8C1\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uF5A3" + //  2180 -  2189
                "\u0000\u0000\uA0E6\u0000\u0000\u0000\u0000\u0000\u0000\uF9DD" + //  2190 -  2199
                "\uEABF\u9BA4\u0000\uD4BC\u0000\uFCEA\u0000\u0000\u0000\u0000" + //  2200 -  2209
                "\u0000\uB5B5\uB5B6\u0000\u0000\uE5DB\uF8F7\u0000\u0000\u0000" + //  2210 -  2219
                "\uF6D4\u0000\uA9C9\uA9CA\uA9CB\uA9CC\uA2DF\u0000\u0000\u0000" + //  2220 -  2229
                "\uD8BC\uF2B0\u0000\u0000\u0000\uF9D4\uF7CA\u0000\u0000\uD6C8" + //  2230 -  2239
                "\uC8BF\uA0FA\u0000\u0000\uC8C0\u0000\u0000\u0000\uD5D8\u0000" + //  2240 -  2249
                "\uF0BD\uD7D0\uD4D0\u0000\u0000\uC6AD\u0000\u0000\u0000\u0000" + //  2250 -  2259
                "\u0000\u0000\uF5ED\u0000\uCFF3\u0000\uEDEF\u0000\uE8A3\u0000" + //  2260 -  2269
                "\u0000\u0000\u0000\uCFF1\uC8BA\u0000\u0000\u0000\uC8BB\u0000" + //  2270 -  2279
                "\u0000\u0000\uCDEC\u0000\u0000\u0000\uDCB2\uD0EC\uCEFD\uC8B3" + //  2280 -  2289
                "\uC8B4\u0000\u0000\uC8B5\u0000\u0000\u0000\uD6ED\u0000\u0000" + //  2290 -  2299
                "\u0000\u0000\u0000\u0000\uE8A4\u0000\u0000\uC5FC\u0000\u0000" + //  2300 -  2309
                "\u0000\u0000\u0000\u0000\uEEE5\u0000\uDEF5\u0000\uD7E1\uFAF5" + //  2310 -  2319
                "\u0000\u0000\uD5C9\uF8AC\u0000\u0000\uFCD1\u0000\uEDB2\uF4AF" + //  2320 -  2329
                "\u0000\uFBA3\u0000\uA9C1\uA9C2\uA9C3\uA9C4\uA9C5\uA9C6\uA9C7" + //  2330 -  2339
                "\uA9C8\uC8AF\u0000\u0000\u0000\uC8B0\u0000\u0000\u0000\uCAA4" + //  2340 -  2349
                "\u0000\uDBF8\u0000\u0000\u0000\uDEC7\uC8A8\uC8A9\u0000\uC8AA" + //  2350 -  2359
                "\u0000\uC8AB\u0000\u0000\uC5AF\u0000\u0000\u0000\u0000\u0000" + //  2360 -  2369
                "\u0000\uDFD8\u0000\u0000\u0000\uA0C9\u0000\uC3A4\uC3A5\u0000" + //  2370 -  2379
                "\u0000\uBDB3\u0000\u0000\u0000\u0000\u0000\u0000\uDDDD\u0000" + //  2380 -  2389
                "\u0000\u0000\uD7F4\uF0DD\u0000\u0000\u0000\uCEAB\uC8A6\u0000" + //  2390 -  2399
                "\u0000\u0000\u0000\uC8A7\u0000\u0000\uC5A4\u0000\u0000\u0000" + //  2400 -  2409
                "\u0000\u0000\u0000\u9CF8\u0000\u0000\u0000\uB4CB\u0000\uB4CC" + //  2410 -  2419
                "\u0000\u0000\u0000\uE4FB\u0000\u0000\uF9E4\u0000\u0000\uBCDB" + //  2420 -  2429
                "\u0000\u0000\u0000\uBCDC\u0000\u0000\uEFC5\u0000\uE7E7\u0000" + //  2430 -  2439
                "\u0000\uD7FD\u0000\uFBCF\u0000\u0000\u0000\u0000\u0000\u0000" + //  2440 -  2449
                "\uCFB7\uC8A3\uC8A4\u0000\u0000\uC8A5\u0000\u0000\u0000\uCEE0" + //  2450 -  2459
                "\u0000\u0000\u0000\uDCD2\uFDEA\u0000\uDFD2\u0000\uCECA\u0000" + //  2460 -  2469
                "\uEEDA\u0000\u0000\u0000\uFCDC\u0000\u0000\u0000\u0000\uD3B5" + //  2470 -  2479
                "\u0000\u0000\u0000\u0000\uC4AB\uC4AC\u0000\u0000\uFCB9\uEEC2" + //  2480 -  2489
                "\uCAF5\u0000\u0000\u0000\uEFE5\uC7FE\u0000\u0000\u0000\uC8A1" + //  2490 -  2499
                "\u0000\u0000\u0000\uF4D2\uE0BA\u0000\u0000\u0000\u0000\uDFC0" + //  2500 -  2509
                "\uC7F8\uC7F9\u0000\uC7FA\uC7FB\uC7FC\u0000\u0000\uC4F8\u0000" + //  2510 -  2519
                "\u0000\u0000\u0000\u0000\u0000\uD5C1\u0000\u0000\u0000\u9ECA" + //  2520 -  2529
                "\u0000\u0000\u0000\u0000\u0000\uBCE5\u0000\u0000\uBCE6\uC7F7" + //  2530 -  2539
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uFCCE\u0000\uDDEE" + //  2540 -  2549
                "\uC7F4\uC7F5\u0000\u0000\uC7F6\u0000\u0000\u0000\uCBF8\u0000" + //  2550 -  2559
                "\u0000\u0000\u0000\u0000\u0000\uCAD8\u0000\u0000\uC4E9\u0000" + //  2560 -  2569
                "\u0000\u0000\u0000\u0000\u0000\uE7E0\uEBAE\u0000\u0000\uBBD7" + //  2570 -  2579
                "\u0000\u0000\u0000\u0000\u0000\u0000\u9ACA\u0000\u0000\u0000" + //  2580 -  2589
                "\uF8CB\u0000\u0000\u0000\u0000\u0000\uB6EA\uB6EB\u0000\u0000" + //  2590 -  2599
                "\uE6F3\u0000\u0000\u0000\u0000\u0000\u0000\uE5BD\u0000\u0000" + //  2600 -  2609
                "\u0000\uCCD2\u0000\uDDA4\u0000\u0000\u0000\uEEE2\u0000\u0000" + //  2610 -  2619
                "\u0000\u0000\uCBA7\u0000\uDACE\u0000\u0000\uFBD7\u0000\u0000" + //  2620 -  2629
                "\uEBCA\uE0A1\u0000\u0000\uD9AA\u0000\u0000\u0000\u0000\u0000" + //  2630 -  2639
                "\u0000\uD6DD\u0000\u0000\uFDF7\u0000\u0000\u0000\u0000\u0000" + //  2640 -  2649
                "\uE2D9\uC7EE\u0000\u0000\u0000\uC7EF\u0000\u0000\u0000\uF3DB" + //  2650 -  2659
                "\u0000\uDBA7\uF6B7\u0000\uCFE6\uF0F2\uC7E8\uC7E9\u0000\uC7EA" + //  2660 -  2669
                "\u0000\uC7EB\u0000\u0000\uC4E1\u0000\u0000\u0000\u0000\u0000" + //  2670 -  2679
                "\u0000\uCDCD\u0000\u0000\u0000\uD1CB\uD6E4\u0000\u0000\u0000" + //  2680 -  2689
                "\uD5F2\uC7E6\u0000\uC7E7\u0000\u0000\u0000\u0000\u0000\uBEE4" + //  2690 -  2699
                "\uBEE5\u0000\uBEE6\uC7E3\uC7E4\u0000\u0000\uC7E5\u0000\u0000" + //  2700 -  2709
                "\uA0F8\uC7E1\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uD0BF" + //  2710 -  2719
                "\u0000\uFAAC\uC7DF\uC7E0\u0000\u0000\u0000\u0000\u0000\u0000" + //  2720 -  2729
                "\u9BFA\u0000\u0000\u0000\uFDA6\uEBEF\u0000\uF4A6\u0000\uCCCA" + //  2730 -  2739
                "\uF3A8\uC7DA\u0000\u0000\u0000\uC7DB\u0000\u0000\u0000\uD9FA" + //  2740 -  2749
                "\uD3EE\u0000\u0000\u0000\uFAB8\u0000\uDFF9\uD7E0\u0000\u0000" + //  2750 -  2759
                "\u0000\u0000\u0000\u0000\uFDA4\u0000\u0000\uE4A2\u0000\uE2E8" + //  2760 -  2769
                "\u0000\uE6D0\u0000\uFBE8\uC7D4\uC7D5\u0000\uC7D6\uA0F5\uC7D7" + //  2770 -  2779
                "\u0000\u0000\uC4BE\u0000\u0000\u0000\u0000\u0000\u0000\uE0D1" + //  2780 -  2789
                "\u0000\u0000\uE9A8\uC7D2\uA0F4\u0000\u0000\u0000\uC7D3\u0000" + //  2790 -  2799
                "\u0000\uA0D3\u0000\u0000\uC4BC\uC4BD\u0000\u0000\uB9F1\u0000" + //  2800 -  2809
                "\u0000\uB9F2\uB9F3\u0000\u0000\uD4ED\uE2C4\u0000\u0000\u0000" + //  2810 -  2819
                "\u0000\uE9E7\uC7CF\uC7D0\u0000\u0000\uC7D1\u0000\u0000\uA0F3" + //  2820 -  2829
                "\uC7C9\u0000\u0000\u0000\uC7CA\u0000\u0000\u0000\uCEFC\u0000" + //  2830 -  2839
                "\uDBC4\u0000\uF8F1\u0000\u0000\uC3F6\u0000\u0000\u0000\u0000" + //  2840 -  2849
                "\u0000\u0000\u9DC7\u0000\u0000\u0000\uD5F0\u0000\u0000\uD1CA" + //  2850 -  2859
                "\u0000\u0000\uB9A5\u0000\u0000\u0000\u0000\u0000\u0000\uD8E0" + //  2860 -  2869
                "\uFCBA\uFDAF\uF0CE\uA0F1\u0000\u0000\u0000\uA0F2\u0000\u0000" + //  2870 -  2879
                "\u0000\uE9B5\u0000\uCCC9\uFAD5\u0000\u0000\uE1D4\uA0EF\u0000" + //  2880 -  2889
                "\u0000\u0000\uC7C4\uC7C5\u0000\uC7C6\uC7C2\u0000\u0000\u0000" + //  2890 -  2899
                "\uC7C3\u0000\u0000\u0000\uEAE2\u0000\u0000\u0000\u0000\uD7C2" + //  2900 -  2909
                "\u0000\uD4BA\uE4B3\u0000\uE9DA\u0000\uDEB6\u0000\uD9BF\uC7BE" + //  2910 -  2919
                "\u0000\u0000\uC7BF\u0000\uC7C0\u0000\u0000\uC3E6\u0000\u0000" + //  2920 -  2929
                "\u0000\u0000\u0000\u0000\uF9ED\u0000\u0000\u0000\uD8CB\u0000" + //  2930 -  2939
                "\u9ADE\u0000\u0000\u0000\uD2C1\u0000\u0000\u0000\uF8D7\u0000" + //  2940 -  2949
                "\uF7FA\u0000\u0000\u0000\uF8AB\u0000\u0000\u0000\uEAC4\u0000" + //  2950 -  2959
                "\u0000\u0000\u0000\uF9A9\u0000\u0000\u0000\u0000\uC3E3\uC3E4" + //  2960 -  2969
                "\u0000\uC3E5\uC7BD\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + //  2970 -  2979
                "\uE6CB\u0000\uF5F1\uC7BB\uA0ED\u0000\u0000\uC7BC\u0000\u0000" + //  2980 -  2989
                "\u0000\uE3E0\u0000\uCAC9\uF2E9\u0000\uD5CE\u0000\uDFD1\u0000" + //  2990 -  2999
                "\u0000\u0000\u0000\u0000\uEDED\uF8B8\uC7B7\u0000\u0000\u0000" + //  3000 -  3009
                "\uC7B8\u0000\u0000\u0000\uF8A5\u0000\u0000\u0000\u0000\u0000" + //  3010 -  3019
                "\uE5BA\uA0EC\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uE3D5" + //  3020 -  3029
                "\uF5D0\u0000\uEABA\u0000\uEAD3\u0000\u0000\uEDC9\uDDAB\u0000" + //  3030 -  3039
                "\uA9B9\uA9BA\uA9BB\uA9BC\uA9BD\uA9BE\uA9BF\uA9C0\uC7B0\uC7B1" + //  3040 -  3049
                "\u0000\uC7B2\u0000\uC7B3\u0000\u0000\uC3DC\u0000\u0000\u0000" + //  3050 -  3059
                "\u0000\u0000\u0000\uFCEE\u0000\u0000\u0000\uD7EE\uD1F1\u0000" + //  3060 -  3069
                "\u0000\u0000\u0000\uDED4\u0000\uE0AC\u0000\u0000\uB7E6\u0000" + //  3070 -  3079
                "\u0000\u0000\u0000\u0000\u0000\u9AF1\u0000\u0000\u0000\uDDF6" + //  3080 -  3089
                "\u0000\uCDC0\u0000\u0000\u0000\u9FA9\uB8FA\u0000\u0000\u0000" + //  3090 -  3099
                "\u9FBB\uBAC3\u0000\u0000\u0000\uBBA8\uBBA9\uBBAA\u0000\u0000" + //  3100 -  3109
                "\uDFDA\u0000\u0000\u0000\u0000\u0000\u0000\uF8A6\u0000\uDECA" + //  3110 -  3119
                "\uF2C6\uC7AE\u0000\uC7AF\u0000\u0000\u0000\u0000\u0000\uBEDF" + //  3120 -  3129
                "\uBEE0\u0000\u0000\uC3D5\u0000\u0000\u0000\u0000\u0000\u0000" + //  3130 -  3139
                "\uD4F6\uE5B7\u0000\u0000\uB7CC\u0000\uB7CD\u0000\u0000\u0000" + //  3140 -  3149
                "\u0000\uEEA9\uF6BC\u0000\u0000\uCCDB\uC7AA\uC7AB\u0000\u0000" + //  3150 -  3159
                "\uC7AC\u0000\u0000\uC7AD\uC7A6\u0000\u0000\u0000\uC7A7\u0000" + //  3160 -  3169
                "\u0000\u0000\uF9F2\uECA5\uD0DF\u0000\uE7EA\uD0EB\uDCD1\uC7A3" + //  3170 -  3179
                "\u0000\u0000\u0000\uC7A4\u0000\u0000\u0000\uD0EA\u0000\u0000" + //  3180 -  3189
                "\u0000\u0000\u0000\u0000\uF2B2\uF3F6\uF6DB\uC7A1\u0000\u0000" + //  3190 -  3199
                "\u0000\u0000\u0000\u0000\u0000\uF0C9\u0000\uFCFC\uC6F9\u0000" + //  3200 -  3209
                "\u0000\u0000\uC6FA\u0000\u0000\u0000\uD8CC\uF9F1\u0000\uCEDF" + //  3210 -  3219
                "\uFAA4\uE6B2\u0000\uD6D3\u0000\u0000\u0000\u0000\u0000\u0000" + //  3220 -  3229
                "\u0000\uCAD4\uC6F4\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + //  3230 -  3239
                "\uF2CD\u0000\u0000\uC3C9\u0000\u0000\u0000\u0000\u0000\u0000" + //  3240 -  3249
                "\uD5ED\uE7DD\u0000\u0000\uB5EE\u0000\u0000\u0000\u0000\u0000" + //  3250 -  3259
                "\u0000\uD7B4\u0000\u0000\u0000\u9DC9\u0000\u0000\u0000\uD5EB" + //  3260 -  3269
                "\u0000\uFAD2\u0000\u0000\u0000\u0000\u0000\uF8EF\u0000\uA9B1" + //  3270 -  3279
                "\uA9B2\uA9B3\uA9B4\uA9B5\uA9B6\uA9B7\uA9B8\uC6F3\u0000\u0000" + //  3280 -  3289
                "\u0000\u0000\u0000\u0000\u0000\uF9F8\u0000\uDBCA\uC6F1\uC6F2" + //  3290 -  3299
                "\u0000\u0000\u0000\u0000\u0000\u0000\uD6C2\u0000\u0000\u0000" + //  3300 -  3309
                "\uF5E4\u0000\u0000\uF3A6\uDDE0\uE1A6\u0000\uD7F2\u0000\uE1C0" + //  3310 -  3319
                "\u0000\uDBE2\uE6D8\u0000\u0000\uE1D7\u0000\uE6CF\u0000\uF4F1" + //  3320 -  3329
                "\u0000\u0000\uFCB6\uF2AD\uEFE1\uF3AE\uDCC6\uD9EB\u0000\uA4F8" + //  3330 -  3339
                "\uA4F9\uA4FA\uA4FB\uA4FC\uA4FD\uA4FE\u0000\u0048\u0049\u004A" + //  3340 -  3349
                "\u004B\u004C\u004D\u004E\u004F\uC6ED\u0000\u0000\u0000\uC6EE" + //  3350 -  3359
                "\u0000\u0000\u0000\uA4A1\uA4A2\uA4A3\uA4A4\uA4A5\uA4A6\uA4A7" + //  3360 -  3369
                "\uC6E8\uC6E9\u0000\uC6EA\u0000\uC6EB\u0000\u0000\uC3C3\u0000" + //  3370 -  3379
                "\u0000\u0000\u0000\u0000\u0000\uE1CA\uEBE3\u0000\uF2DE\uC6E7" + //  3380 -  3389
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uCDBA\u0000\u0000" + //  3390 -  3399
                "\uC2F4\uC2F5\u0000\u0000\u0000\uA0C6\uC2F6\uC6E4\uC6E5\u0000" + //  3400 -  3409
                "\u0000\uC6E6\u0000\u0000\u0000\uABA1\uABA2\uABA3\uABA4\uABA5" + //  3410 -  3419
                "\uABA6\uABA7\uC6E2\uC6E3\u0000\u0000\u0000\u0000\u0000\u0000" + //  3420 -  3429
                "\uF5DD\u0000\u0000\u0000\uAAA1\uAAA2\uAAA3\uAAA4\uAAA5\uAAA6" + //  3430 -  3439
                "\uAAA7\uC6DD\u0000\u0000\u0000\uC6DE\u0000\u0000\u0000\uA2B2" + //  3440 -  3449
                "\u0000\u0000\u0000\u0000\u0000\u0000\uECB7\u0000\u0000\uC2ED" + //  3450 -  3459
                "\u0000\u0000\u0000\u0000\u0000\u0000\uE2F1\u0000\u0000\u0000" + //  3460 -  3469
                "\uDBA4\u0000\uCFC9\uE2FC\uEFFA\u0000\uD4F3\uD4C9\u0000\u0000" + //  3470 -  3479
                "\u0000\u0000\uD6FA\u0000\uA4F0\uA4F1\uA4F2\uA4F3\uA4F4\uA4F5" + //  3480 -  3489
                "\uA4F6\uA4F7\uA0E7\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + //  3490 -  3499
                "\uE1DF\u0000\uDAD1\uC6D4\uC6D5\u0000\uC6D6\uC6D7\uC6D8\u0000" + //  3500 -  3509
                "\u0000\uC2DD\u0000\u0000\u0000\u0000\u0000\u0000\uF3F8\u0000" + //  3510 -  3519
                "\u0000\u9AE5\uC6D3\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + //  3520 -  3529
                "\uCCA9\uFDC6\u0000\u9CE5\u0000\u0000\u0000\uE8A2\u0000\u0000" + //  3530 -  3539
                "\u0000\uDCF3\uD9B0\u0000\uE6E9\u0000\uA4E8\uA4E9\uA4EA\uA4EB" + //  3540 -  3549
                "\uA4EC\uA4ED\uA4EE\uA4EF\uC6D0\uC6D1\u0000\u0000\uC6D2\u0000" + //  3550 -  3559
                "\u0000\u0000\uA2E5\uA2E2\u0000\u0000\u0000\uA7D9\u0000\uE7BC" + //  3560 -  3569
                "\u0000\u0000\u0000\u0000\u0000\uD1EE\u0000\uA4E0\uA4E1\uA4E2" + //  3570 -  3579
                "\uA4E3\uA4E4\uA4E5\uA4E6\uA4E7\uC6CD\uC6CE\u0000\u0000\u0000" + //  3580 -  3589
                "\uC6CF\uA0E5\u0000\uE6FB\u0000\u0000\u0000\u0000\u0000\uE6D4" + //  3590 -  3599
                "\u0000\uA4D8\uA4D9\uA4DA\uA4DB\uA4DC\uA4DD\uA4DE\uA4DF\uC6C7" + //  3600 -  3609
                "\u0000\u0000\u0000\uC6C8\u0000\uC6C9\u0000\uFBF4\uD5A7\u0000" + //  3610 -  3619
                "\u0000\u0000\uF1F6\u0000\uE6D3\uC6C0\uC6C1\u0000\uC6C2\u0000" + //  3620 -  3629
                "\uC6C3\u0000\u0000\uC2D0\uA0C0\uC2D1\u0000\u0000\u0000\u0000" + //  3630 -  3639
                "\u9BF9\u0000\u0000\uFDE4\uFACE\uC6BF\u0000\u0000\u0000\u0000" + //  3640 -  3649
                "\u0000\u0000\u0000\uF4AA\uE9AF\u0000\uD6AD\u0000\u0000\uFDCE" + //  3650 -  3659
                "\u0000\u0000\u0000\uE8A1\uC6BC\uC6BD\u0000\u0000\uC6BE\u0000" + //  3660 -  3669
                "\u0000\u0000\uA2B5\u0000\u0000\u0000\u0000\u0000\u0000\uE8E5" + //  3670 -  3679
                "\u0000\u0000\uC2BB\u0000\u0000\u0000\u0000\u0000\u0000\uCFD8" + //  3680 -  3689
                "\u0000\u0000\u0000\uF1D0\u0000\u0000\u0000\u0000\u0000\uBABD" + //  3690 -  3699
                "\uBABE\u0000\uBABF\uC6B8\u0000\u0000\u0000\uC6B9\u0000\u0000" + //  3700 -  3709
                "\u0000\\\u0000\u0000\u0000\u0000\u0000\u0000\uF5B7\uE0F0" + //  3710 -  3719
                "\u0000\uEDC8\uEFC3\u0000\u0000\u0000\u0000\u0000\u0000\uD8C3" + //  3720 -  3729
                "\u0000\u0000\uD7B5\u0000\u0000\u0000\u0000\u0000\u0000\uF3C8" + //  3730 -  3739
                "\u0000\uF3BA\uC6B4\uC6B5\u0000\uC6B6\u0000\uA0E2\u0000\u0000" + //  3740 -  3749
                "\uC2A3\uC2A4\u0000\uC2A5\uC2A6\u0000\u0000\u9EBC\u0000\u0000" + //  3750 -  3759
                "\uB1E1\u0000\u0000\u0000\uCFF5\u0000\u0000\uFDAE\u0000\u0000" + //  3760 -  3769
                "\uF8E3\u0000\uD4DD\u0000\u0000\uEAD8\u0000\uFDDC\uEDB3\uCEC9" + //  3770 -  3779
                "\u0000\u0000\u0000\u0000\u0000\uB4F4\u0000\u0000\u0000\u9BCA" + //  3780 -  3789
                "\u0000\uE7A3\u0000\u0000\uE0DD\uFBF3\u0000\u0000\u0000\u0000" + //  3790 -  3799
                "\u0000\uB4AE\uB4AF\u0000\uB4B0\uC6B2\u0000\uC6B3\u0000\u0000" + //  3800 -  3809
                "\u0000\u0000\u0000\uBEC6\uBEC7\u0000\u0000\uC1DF\u0000\u0000" + //  3810 -  3819
                "\u0000\u0000\u0000\u0000\uE5A2\u0000\u0000\u0000\uEBB4\uEAA1" + //  3820 -  3829
                "\u0000\uF8BC\uCEA6\u9CC2\uC6AE\uC6AF\u0000\u0000\uC6B0\u0000" + //  3830 -  3839
                "\u0000\uC6B1\uC6AA\u0000\u0000\u0000\uC6AB\u0000\u0000\u0000" + //  3840 -  3849
                "\uA9FB\uA9FC\uA9FD\uA9FE\u0000\u0000\u0000\uE5C7\uD6AC\u0000" + //  3850 -  3859
                "\u0000\u0000\uE8CB\u0000\u0000\uF8DD\u0000\uCFB6\u0000\u0000" + //  3860 -  3869
                "\u0000\uEDC7\uEEAC\u0000\u0000\uE2AA\u0000\uD5A6\u0000\u0000" + //  3870 -  3879
                "\uD4D7\u0000\uA4D0\uA4D1\uA4D2\uA4D3\uA4D4\uA4D5\uA4D6\uA4D7" + //  3880 -  3889
                "\uC6A6\uC6A7\u0000\uA0E1\u0000\uC6A8\u0000\u0000\uC1D1\u0000" + //  3890 -  3899
                "\u0000\u0000\u0000\u0000\u0000\uE1D9\u0000\u0000\uEFAB\uC6A5" + //  3900 -  3909
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uE4C3\u0000\u0000" + //  3910 -  3919
                "\uC1AD\u0000\u0000\u0000\u0000\u0000\u0000\uE2B8\uEBAB\u0000" + //  3920 -  3929
                "\u0000\uF9E9\u0000\u0000\u0000\uE7A4\u0000\uD6E3\uC6A2\uC6A3" + //  3930 -  3939
                "\u0000\u0000\uC6A4\u0000\u0000\u0000\uACD7\u0000\u0000\u0000" + //  3940 -  3949
                "\u0000\u0000\u0000\uF0CF\uF3BE\uE2AC\uC5FD\u0000\u0000\u0000" + //  3950 -  3959
                "\u0000\u0000\u0000\u0000\uEFD7\u0000\uD4C3\uC5F7\u0000\u0000" + //  3960 -  3969
                "\u0000\uC5F8\u0000\u0000\u0000\uACA7\u0000\u0000\u0000\u0000" + //  3970 -  3979
                "\u0000\u0000\uE0C3\u0000\u0000\uC0C0\uC0C1\uC0C2\uC0C3\uC0C4" + //  3980 -  3989
                "\uC0C5\uC0C6\uC5F4\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + //  3990 -  3999
                "\uE6ED\u0000\u0000\uC0AE\u0000\u0000\u0000\u0000\u0000\u0000" + //  4000 -  4009
                "\u9DA6\u0000\u9DB6\u0000\uFCE9\u0000\u0000\u0000\u0000\u0000" + //  4010 -  4019
                "\u0000\u0000\uDBDA\uC5F1\u0000\u0000\u0000\u0000\u0000\u0000" + //  4020 -  4029
                "\u0000\uFCC8\u0000\u0000\uBFEB\u0000\u0000\u0000\u0000\u0000" + //  4030 -  4039
                "\u0000\uD7E6\u0000\u0000\u0000\uF3C6\u0000\u0000\u0000\u0000" + //  4040 -  4049
                "\u0000\uB8FE\u0000\u0000\u0000\uD2A5\u0000\u0000\uFDEE\u0000" + //  4050 -  4059
                "\u0000\uF8EA\u9BDF\u0000\u0000\u0000\u0000\u0000\uBBFE\uBCA1" + //  4060 -  4069
                "\u0000\u0000\uECBF\uFCD8\u0000\u0000\u0000\u0000\u0000\uB7AF" + //  4070 -  4079
                "\uB7B0\u0000\u0000\uE9DF\u0000\u0000\u0000\u0000\u0000\u0000" + //  4080 -  4089
                "\uB6CB\u0000\u0000\uDAAA\u0000\u0000\u0000\u0000\u0000\u0000" + //  4090 -  4099
                "\uFAB4\u0000\u0000\uE2D7\u0000\u0000\u0000\u0000\u0000\u0000" + //  4100 -  4109
                "\uE9EA\uD7CC\u0000\uF7A8\u0000\u0000\u0000\u0000\uFBCE\u0000" + //  4110 -  4119
                "\u0000\uDCC7\u0000\u0000\u0000\u0000\u0000\uE1A9\uC5EF\u0000" + //  4120 -  4129
                "\u0000\u0000\u0000\u0000\u0000\u0000\uE4DD\uDFEE\uCBAC\uC5EE" + //  4130 -  4139
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uEEBC\u9DEC\uEFC1" + //  4140 -  4149
                "\uC5E8\uC5E9\u0000\uC5EA\u0000\uC5EB\u0000\u0000\uBFDB\u0000" + //  4150 -  4159
                "\u0000\u0000\u0000\u0000\u0000\uF1C3\uEEDF\u0000\u0000\uCEDA" + //  4160 -  4169
                "\uFBEB\uDBA6\uDBDE\uD8E5\u0000\u0000\uF5AE\uFBAA\u0000\u0000" + //  4170 -  4179
                "\u0000\u0000\uECFB\uC5E7\u0000\u0000\u0000\u0000\u0000\u0000" + //  4180 -  4189
                "\u0000\uD8AD\u0000\u0000\uBFCB\uA0A1\uBFCC\u0000\u0000\u0000" + //  4190 -  4199
                "\u0000\uF9E3\u9CEE\u0000\u0000\u0000\uF4DB\u0000\uE2F4\u0000" + //  4200 -  4209
                "\u0000\uD3C8\uC5E4\uC5E5\u0000\u0000\uC5E6\u0000\u0000\u0000" + //  4210 -  4219
                "\uA5E1\uA5E2\uA5E3\uA5E4\uA5E5\uA5E6\uA5E7\uC5E3\u0000\u0000" + //  4220 -  4229
                "\u0000\u0000\u0000\u0000\u0000\uE1FD\u0000\u0000\uBEED\u0000" + //  4230 -  4239
                "\u9FF9\u0000\u0000\u0000\u0000\uDEB1\u0000\u0000\u0000\u0000" + //  4240 -  4249
                "\uC5B0\uC5B1\u0000\u0000\uDEBE\u0000\u0000\u0000\u0000\u0000" + //  4250 -  4259
                "\u0000\u9CDE\u9BB5\u9AC7\u0000\uFBA5\uE1EE\u0000\u0000\u0000" + //  4260 -  4269
                "\u0000\u0000\u0000\uF6D0\uEBE6\uDAF9\uC5DF\uA0DF\u0000\u0000" + //  4270 -  4279
                "\uC5E0\u0000\u0000\u0000\uA5C1\uA5C2\uA5C3\uA5C4\uA5C5\uA5C6" + //  4280 -  4289
                "\uA5C7\uA0DE\uC5DE\u0000\u0000\u0000\u0000\u0000\u0000\uD6F3" + //  4290 -  4299
                "\u0000\u0000\u0000\uA9B0\uA8AF\uA9AF\u0000\u0000\u0000\u0000" + //  4300 -  4309
                "\uBFA9\uBFAA\uBFAB\u0000\u9BC3\u0000\u0000\u0000\u0000\u0000" + //  4310 -  4319
                "\u0000\uECCB\uC5D9\u0000\u0000\u0000\uC5DA\u0000\u0000\u0000" + //  4320 -  4329
                "\uA9A5\uA8A6\uA9A6\u0000\u0000\u0000\u0000\uBEF6\uBEF7\uBEF8" + //  4330 -  4339
                "\uBEF9\uC5D2\uC5D3\u0000\uC5D4\uC5D5\uC5D6\u0000\u0000\uBEB1" + //  4340 -  4349
                "\u0000\u0000\u0000\u0000\u0000\u0000\uF0AF\uD6BD\u0000\u0000" + //  4350 -  4359
                "\uF6EE\u0000\uF6CC\uE2F8\u0000\u0000\u0000\uFBED\u0000\uE0AD" + //  4360 -  4369
                "\u0000\u0000\uEAEE\uC5D0\u0000\uC5D1\u0000\u0000\u0000\u0000" + //  4370 -  4379
                "\u0000\uBEBD\u0000\u0000\u0000\uA9A2\u0000\u0000\u0000\u0000" + //  4380 -  4389
                "\u0000\u0000\uD3C1\uF0CD\u0000\uD6EE\u0000\u0000\u0000\u0000" + //  4390 -  4399
                "\u0000\u0000\uE7BB\uC5CD\uC5CE\u0000\u0000\uC5CF\u0000\u0000" + //  4400 -  4409
                "\u0000\uA2AE\u0080\u0000\uA2B4\u0000\u0084\uA1D7\uC5CB\u0000" + //  4410 -  4419
                "\u0000\u0000\u0000\u0000\u0000\u0000\uF4B9\uF1B6\u0000\uD6D2" + //  4420 -  4429
                "\u0000\uF9D5\uE7BA\uEBD5\uD5F7\uEFE7\uE1BE\uC5C9\uC5CA\u0000" + //  4430 -  4439
                "\u0000\u0000\u0000\u0000\u0000\uDEA7\u0000\u0000\uE6BB\uC5C4" + //  4440 -  4449
                "\u0000\u0000\u0000\uC5C5\u0000\u0000\u0000\u0001\u0002\u0003" + //  4450 -  4459
                "\u0004\u0005\u0006\u0007\uC5BD\uC5BE\u0000\uC5BF\uC5C0\uC5C1" + //  4460 -  4469
                "\u0000\u0000\uBEAB\u0000\u0000\u0000\u0000\u0000\u0000\uF3C1" + //  4470 -  4479
                "\uD0AB\u0000\uD4E4\uC5BB\uC5BC\u0000\u0000\u0000\u0000\u0000" + //  4480 -  4489
                "\u0000\uF2BC\uECE3\u0000\u0000\u9FEB\u0000\u0000\u0000\u0000" + //  4490 -  4499
                "\u0000\u0000\uECF9\u0000\u0000\uF8AD\uC5B8\uC5B9\u0000\u0000" + //  4500 -  4509
                "\uC5BA\u0000\u0000\u0000\uA0E8\u0000\uC6EC\uA0E9\u0000\u0000" + //  4510 -  4519
                "\uBDCC\u0000\u0000\u0000\u0000\uBDCD\u0000\uFBCC\uEBA1\u0000" + //  4520 -  4529
                "\u0000\uD4A6\u0000\u0000\u0000\uCBF6\u0000\u0000\u0000\u0000" + //  4530 -  4539
                "\uF8F4\u0000\uD9B7\u0000\u0000\uFCCF\uFBA2\u0000\uE0DC\u0000" + //  4540 -  4549
                "\u0000\u0000\uD7F6\u0000\u0000\u0000\uE2CA\uC5B2\u0000\u0000" + //  4550 -  4559
                "\u0000\uC5B3\u0000\u0000\u0000\uC5EC\u0000\uC5ED\u0000\u0000" + //  4560 -  4569
                "\u0000\uA0E4\u0000\uC6C4\uC6C5\uC6C6\u0000\uCCAD\uF6FA\uD6B2" + //  4570 -  4579
                "\uD2D8\u0000\u0000\u0000\u0000\uC6B7\u0000\u0000\u0000\uCEF5" + //  4580 -  4589
                "\u0000\u0000\u0000\u0000\u9EAA\u0000\uFBEC\u0000\uDDC8\uA0DC" + //  4590 -  4599
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uE8E4\u0000\u0000" + //  4600 -  4609
                "\uBDC2\u0000\u0000\u0000\u0000\u0000\u0000\uD6DE\uE4F4\uE1EF" + //  4610 -  4619
                "\u0000\uE9FA\u0000\u0000\u0000\uFBCB\u0000\u0000\uCAD5\uC5AB" + //  4620 -  4629
                "\u0000\u0000\u0000\uC5AC\u0000\u0000\u0000\uA0A8\u0000\uC0E7" + //  4630 -  4639
                "\uC0E8\u0000\u0000\uBDA2\uBDA3\u0000\uBDA4\u0000\u0000\u0000" + //  4640 -  4649
                "\uF8E4\u0000\u0000\u0000\u0000\u0000\uB7C5\uB7C6\u0000\uB7C7" + //  4650 -  4659
                "\uC5A8\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uD4F1\u0000" + //  4660 -  4669
                "\u0000\uBCF5\u0000\u0000\u0000\u0000\u0000\u0000\uD7FE\u0000" + //  4670 -  4679
                "\u0000\u0000\uF1F1\u0000\u0000\u0000\u0000\u0000\uB7C1\uB7C2" + //  4680 -  4689
                "\u0000\u0000\uF4EC\u0000\u0000\u0000\u0000\uEFFE\u0000\uF4CD" + //  4690 -  4699
                "\u0000\u0000\u0000\u0000\uF1BF\uF8B1\u0000\uA4C8\uA4C9\uA4CA" + //  4700 -  4709
                "\uA4CB\uA4CC\uA4CD\uA4CE\uA4CF\uC5A7\u0000\u0000\u0000\u0000" + //  4710 -  4719
                "\u0000\u0000\u0000\uD5CF\uD0F8\u0000\uCFF7\u0000\u0000\u0000" + //  4720 -  4729
                "\u0000\u0000\u0000\u0000\uCDBD\uC5A5\u0000\u0000\u0000\uC5A6" + //  4730 -  4739
                "\u0000\u0000\u0000\uC0BC\u0000\uC0BD\uC0BE\u0000\uC0BF\uC4FD" + //  4740 -  4749
                "\u0000\u0000\u0000\uC4FE\u0000\u0000\u0000\uB3F4\uB3F5\uB3F6" + //  4750 -  4759
                "\u0000\u0000\u0000\uE1A8\u0000\u0000\u0000\u0000\uD5F6\uC4F9" + //  4760 -  4769
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uF5C1\uDCC4\u0000" + //  4770 -  4779
                "\uDAEB\u0000\uE2D8\uEDD6\u9CFB\u0000\uD6D1\uE0B3\uC4F6\u0000" + //  4780 -  4789
                "\u0000\u0000\uC4F7\u0000\u0000\u0000\u9EB3\u0000\uB0FA\uB0FB" + //  4790 -  4799
                "\u0000\u0000\u9FDB\u0000\u0000\uBCC5\uBCC6\u0000\u9FDC\uC4F1" + //  4800 -  4809
                "\uC4F2\u0000\uC4F3\u0000\uC4F4\u0000\u0000\uBCA7\u0000\u0000" + //  4810 -  4819
                "\u0000\u0000\u0000\u0000\uE2EB\uD6FC\u0000\u0000\uF6CB\u0000" + //  4820 -  4829
                "\uF1E6\uEDC1\uE8BC\uEED1\u0000\uEFC2\u0000\u0000\u0000\u0000" + //  4830 -  4839
                "\u0000\u0000\uEDEC\uC4F0\u0000\u0000\u0000\u0000\u0000\u0000" + //  4840 -  4849
                "\u0000\uD3EB\u0000\uE9D4\uC4ED\uC4EE\u0000\u0000\uC4EF\u0000" + //  4850 -  4859
                "\u0000\u0000\uF3BB\u0000\uE5E1\u0000\u0000\u0000\uF2CA\u0000" + //  4860 -  4869
                "\u0000\u0000\u0000\u0000\uB2AD\uB2AE\u0000\uB2AF\uC4EB\u0000" + //  4870 -  4879
                "\u0000\u0000\u0000\u0000\u0000\u0000\uFBFB\u0000\u0000\uBBD9" + //  4880 -  4889
                "\u0000\u0000\u0000\u0000\u0000\u0000\u9CFE\u0000\u0000\u0000" + //  4890 -  4899
                "\uDBCF\uCBA4\u0000\u0000\uF8E0\u0000\uD8AE\u0000\uF9D3\uD5FE" + //  4900 -  4909
                "\u0000\u0000\u0000\u0000\uC6A9\u0000\u0000\u0000\uEAA4\u0000" + //  4910 -  4919
                "\u0000\u0000\uFAC2\uC4EA\u0000\u0000\u0000\uA0DA\u0000\u0000" + //  4920 -  4929
                "\u0000\uF6CD\u0000\u0000\u0000\u0000\u0000\uBCC9\uBCCA\u0000" + //  4930 -  4939
                "\uBCCB\uA0D8\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uF2C8" + //  4940 -  4949
                "\u0000\u0000\uBBBF\u0000\u0000\u0000\u0000\u0000\u0000\uF4BD" + //  4950 -  4959
                "\u0000\uCFB8\uE9DB\uC4E6\u0000\u0000\u0000\u0000\uC4E7\u0000" + //  4960 -  4969
                "\u0000\uBAF9\uBAFA\uBAFB\u0000\u0000\u0000\u0000\uD0A7\u0000" + //  4970 -  4979
                "\uF0CB\u0000\uD0C7\uC4E5\u0000\u0000\u0000\u0000\u0000\u0000" + //  4980 -  4989
                "\u0000\uE6BF\u0000\u0000\u9FBF\u0000\u0000\u0000\u0000\u0000" + //  4990 -  4999
                "\u0000\uE8AB\uDEE2\u0000\u0000\uDBA3\u0000\u0000\uD6CA\uCBD9" + //  5000 -  5009
                "\u0000\u0000\uE8BA\u0000\u0000\u0000\uE3C7\u0000\u0000\u9DB3" + //  5010 -  5019
                "\u0000\u0000\uEEDC\u0000\uCBCB\uFCD5\uC4E2\uC4E3\u0000\u0000" + //  5020 -  5029
                "\uC4E4\u0000\u0000\u0000\uF0BA\uEEB1\u0000\u0000\uEEB2\u0000" + //  5030 -  5039
                "\uFBCA\u0000\u0000\u0000\u0000\u0000\uCDE3\uD8BB\uC4DC\u0000" + //  5040 -  5049
                "\u0000\u0000\uC4DD\u0000\u0000\u0000\uE5A4\u9AC3\u0000\u0000" + //  5050 -  5059
                "\uD5B6\u0000\uEAB9\u0000\u0000\u0000\u0000\u0000\uF1DE\u0000" + //  5060 -  5069
                "\uA4C0\uA4C1\uA4C2\uA4C3\uA4C4\uA4C5\uA4C6\uA4C7\uC4D9\u0000" + //  5070 -  5079
                "\u0000\u0000\u0000\u0000\u0000\u0000\uE1F5\uF1B3\u0000\uDFCF" + //  5080 -  5089
                "\u0000\u0000\uD3C0\uE3D7\u0000\uEFE6\uFCD0\uC4D7\uC4D8\u0000" + //  5090 -  5099
                "\u0000\u0000\u0000\u0000\u0000\uFABC\uE6E2\u0000\u0000\uBAE3" + //  5100 -  5109
                "\u0000\u0000\u0000\u0000\u0000\u0000\u9EA8\u0000\uEBA2\uEBA3" + //  5110 -  5119
                "\uC4D2\u0000\u0000\u0000\uC4D3\u0000\u0000\u0000\uF6AF\u9DF6" + //  5120 -  5129
                "\u0000\u0000\u0000\u0000\uD9E8\u0000\uF7EB\uF5C9\u0000\uEAFD" + //  5130 -  5139
                "\u0000\uD9DD\u0000\uDAB4\uEEAA\uFBE9\u0000\uA4B8\uA4B9\uA4BA" + //  5140 -  5149
                "\uA4BB\uA4BC\uA4BD\uA4BE\uA4BF\uC4CD\uC4CE\u0000\uC4CF\u0000" + //  5150 -  5159
                "\uC4D0\u0000\u0000\uBAD9\uBADA\u0000\uBADB\u0000\u0000\u0000" + //  5160 -  5169
                "\uD8A3\u0000\u0000\uDAD9\u0000\uF0D8\uC4CC\u0000\u0000\u0000" + //  5170 -  5179
                "\u0000\u0000\u0000\u0000\uFDAB\u0000\uDFE0\uC4C9\uC4CA\u0000" + //  5180 -  5189
                "\u0000\uC4CB\u0000\u0000\u0000\uE8A7\u0000\u0000\u0000\u0000" + //  5190 -  5199
                "\u0000\uBCA4\uBCA5\u0000\uBCA6\uC4C7\uC4C8\u0000\u0000\u0000" + //  5200 -  5209
                "\uA0D5\u0000\u0000\uBAC0\u0000\u0000\u0000\u0000\u0000\u0000" + //  5210 -  5219
                "\uE3D8\u0000\u0000\u0000\uE3D9\u0000\u0000\u0000\u0000\u0000" + //  5220 -  5229
                "\u9EF5\u0000\u0000\u0000\u9AA6\u0000\u0000\u0000\u0000\u0000" + //  5230 -  5239
                "\uCCB0\uEAA2\u0000\u0000\uCFDB\u0000\u0000\u0000\u0000\u0000" + //  5240 -  5249
                "\u0000\uDEAD\u0000\uFABF\u0000\uCBE2\uD4A4\u0000\uDEE0\uDAFD" + //  5250 -  5259
                "\uE4C6\uE8BE\u0000\uA4B0\uA4B1\uA4B2\uA4B3\uA4B4\uA4B5\uA4B6" + //  5260 -  5269
                "\uA4B7\uC4C1\u0000\u0000\uC4C2\uC4C3\u0000\u0000\u0000\uE5E0" + //  5270 -  5279
                "\u0000\u0000\u0000\u0000\u0000\uBBE7\uBBE8\u9FD3\uBBE9\uA0D4" + //  5280 -  5289
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uE6F4\u0000\u0000" + //  5290 -  5299
                "\u9FB6\u0000\u0000\uBAAD\uBAAE\u0000\u0000\uEBE9\u0000\u0000" + //  5300 -  5309
                "\u0000\uE8BB\u0000\u0000\uE2B9\u0000\u0000\u0000\u0000\u0000" + //  5310 -  5319
                "\u0000\uC5CC\u0000\u0000\uD7BA\u0000\uF2D5\uF5E5\uD9EF\u0000" + //  5320 -  5329
                "\u0000\uF8EE\u0000\u0000\u0000\uDEB5\u0000\u0000\uF4BB\uDAD5" + //  5330 -  5339
                "\u0000\uF9B2\u0000\u0000\u0000\uF4B4\u9DBD\u0000\u0000\u0000" + //  5340 -  5349
                "\uFBB9\u0000\uE4D3\u0000\uCDF9\uC4B7\uC4B8\u0000\uC4B9\uC4BA" + //  5350 -  5359
                "\uC4BB\u0000\u0000\uB9D8\u0000\u0000\uB9D9\uB9DA\uB9DB\uB9DC" + //  5360 -  5369
                "\uC4B6\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uF1ED\u0000" + //  5370 -  5379
                "\uCCCF\uC4B3\uC4B4\u0000\u0000\uC4B5\u0000\u0000\uA0D2\uC4AD" + //  5380 -  5389
                "\u0000\u0000\uA0D1\uC4AE\u0000\u0000\u0000\uF7E3\u0000\u0000" + //  5390 -  5399
                "\u0000\u0000\u0000\u9FD2\u0000\u0000\u0000\uF4AB\u0000\u0000" + //  5400 -  5409
                "\u0000\u9CC1\uD0BD\uC4A7\uC4A8\u0000\uC4A9\u0000\uC4AA\u0000" + //  5410 -  5419
                "\u0000\uB9BC\u0000\uB9BD\u0000\u0000\u0000\u0000\uF7B4\u0000" + //  5420 -  5429
                "\u0000\u0000\u0000\uC4DE\uC4DF\u0000\uC4E0\uC4A5\uC4A6\u0000" + //  5430 -  5439
                "\u0000\u0000\u0000\u0000\u0000\u9AC0\u0000\uCAE9\u0000\uF4E8" + //  5440 -  5449
                "\uE5F4\uF4BC\uF4D5\u0000\u0000\u0000\u0000\uC5FE\u0000\u0000" + //  5450 -  5459
                "\u0000\uEADF\u0000\u0000\u0000\u0000\uCDB7\u0000\uEFD4\u0000" + //  5460 -  5469
                "\u0000\uE2E6\uE2A8\u0000\u0000\u0000\u0000\u0000\uB3FD\uB3FE" + //  5470 -  5479
                "\u0000\uB4A1\uC4A1\uC4A2\u0000\u0000\uC4A3\u0000\u0000\uC4A4" + //  5480 -  5489
                "\uC3FB\uC3FC\u0000\uC3FD\u0000\uC3FE\u0000\u0000\uB9B6\u0000" + //  5490 -  5499
                "\u0000\u0000\uB9B7\u0000\uB9B8\uC3FA\u0000\u0000\u0000\u0000" + //  5500 -  5509
                "\u0000\u0000\u0000\uF8D0\u0000\u0000\uB9A9\u0000\uB9AA\u0000" + //  5510 -  5519
                "\u0000\u0000\u0000\uF2CE\uDBB4\u0000\u0000\u0000\uD5EC\uD5F8" + //  5520 -  5529
                "\uDAF3\u0000\u0000\u0000\uC1C1\uC1C2\uC1C3\u0000\u0000\uEFAE" + //  5530 -  5539
                "\u0000\u0000\u0000\uF4D0\uCEF3\u0000\uEFE4\u0000\uD7C5\uEBE2" + //  5540 -  5549
                "\u0000\u0000\uFCE7\u0000\uA4A8\uA4A9\uA4AA\uA4AB\uA4AC\uA4AD" + //  5550 -  5559
                "\uA4AE\uA4AF\uC3F7\uC3F8\u0000\u0000\uC3F9\u0000\u0000\u0000" + //  5560 -  5569
                "\u9BF1\u9AF8\u0000\u0000\u0000\uD7A2\uC3F3\u0000\u0000\u0000" + //  5570 -  5579
                "\uC3F4\u0000\u0000\u0000\uCCF3\uE6BE\u0000\u0000\u0000\uF6AE" + //  5580 -  5589
                "\uC3EE\uC3EF\u0000\uC3F0\u0000\uC3F1\u0000\u0000\uB8C3\u0000" + //  5590 -  5599
                "\uB8C4\uB8C5\uB8C6\u0000\u0000\uEEE6\u0000\uE0D3\u0000\u0000" + //  5600 -  5609
                "\u0000\u0000\uD9D7\u0000\u0000\u0000\u0000\uC2C7\u0000\u0000" + //  5610 -  5619
                "\u0000\uCCF7\u0000\u0000\u0000\u0000\u0000\uB0B7\uB0B8\u0000" + //  5620 -  5629
                "\uB0B9\uC3ED\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uF8F2" + //  5630 -  5639
                "\u0000\uF4F9\uC3EB\u0000\u0000\u0000\uC3EC\u0000\u0000\u0000" + //  5640 -  5649
                "\u9BD2\u0000\u0000\u0000\u0000\u0000\u9FCF\u0000\u0000\u0000" + //  5650 -  5659
                "\uD8B7\uCEB1\uCAC2\u0000\u0000\uFBB4\uC3EA\u0000\u0000\u0000" + //  5660 -  5669
                "\u0000\u0000\u0000\u0000\uF4F8\u0000\u0000\uB8B5\u0000\u0000" + //  5670 -  5679
                "\u0000\u0000\u0000\u0000\uEED9\u0000\u0000\u0000\uF9EC\u0000" + //  5680 -  5689
                "\u0000\u0000\uCBCC\u0000\uD4A3\uF0F8\uD7A8\u0000\u0000\u0000" + //  5690 -  5699
                "\uE1E7\u0000\uABF0\uABF1\uABF2\uABF3\uABF4\uABF5\uABF6\u0000" + //  5700 -  5709
                "\u0040\u0041\u0042\u0043\u0044\u0045\u0046\u0047\uC3E7\u0000" + //  5710 -  5719
                "\u0000\u0000\u0000\u0000\u0000\u0000\uD6A9\u0000\u0000\uB8AA" + //  5720 -  5729
                "\uB8AB\u0000\u0000\uB8AC\uB8AD\u0000\uEFE3\u0000\u0000\uCFEE" + //  5730 -  5739
                "\uF6BE\uE0B2\uFCFE\uD1AB\uC3E1\u0000\u0000\u0000\uC3E2\u0000" + //  5740 -  5749
                "\u0000\u0000\uD5FA\u0000\uE4F7\u0000\u9DCD\u0000\uE1BC\uE0EF" + //  5750 -  5759
                "\u0000\u0000\uE9BF\uFCFD\uE6CE\u0000\uABE8\uABE9\uABEA\uABEB" + //  5760 -  5769
                "\uABEC\uABED\uABEE\uABEF\uC3DE\u0000\u0000\u0000\u0000\u0000" + //  5770 -  5779
                "\u0000\u0000\uF3D0\u0000\u0000\uB7F8\u0000\u0000\u0000\u0000" + //  5780 -  5789
                "\u0000\u0000\uD7B6\uCFB5\u0000\uD9A8\uC3DD\u0000\u0000\u0000" + //  5790 -  5799
                "\u0000\u0000\u0000\u0000\uE8E9\u0000\uE3AC\uC3D7\u0000\u0000" + //  5800 -  5809
                "\u0000\uC3D8\u0000\u0000\u0000\uD3E9\uE2C9\u0000\uFCDB\uCDAD" + //  5810 -  5819
                "\u0000\uF6D9\uFAF4\u0000\u0000\u0000\u0000\u0000\uF8AA\uA0CE" + //  5820 -  5829
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uDBA8\u0000\u0000" + //  5830 -  5839
                "\uB7D5\u0000\u0000\u0000\u0000\u0000\u0000\uE9B1\u0000\u0000" + //  5840 -  5849
                "\uFAAD\uC3D3\u0000\u0000\u0000\uC3D4\u0000\u0000\u0000\uDBD6" + //  5850 -  5859
                "\u0000\u0000\u0000\u0000\u0000\u9FC8\u0000\u0000\u0000\uF8C9" + //  5860 -  5869
                "\u0000\u0000\u0000\u0000\uE3D2\uC3CE\uC3CF\u0000\uC3D0\u0000" + //  5870 -  5879
                "\uC3D1\u0000\u0000\uB7AE\u0000\u0000\u0000\u0000\u0000\u0000" + //  5880 -  5889
                "\u9BFC\u0000\u0000\u0000\uCCE1\u0000\u0000\u0000\u0000\uD6EA" + //  5890 -  5899
                "\uC3CD\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uCBED\u0000" + //  5900 -  5909
                "\u0000\uB6D7\u0000\u0000\u0000\u0000\u0000\u0000\uCAB0\u0000" + //  5910 -  5919
                "\uF7A7\u0000\uCEC8\uEAB7\u0000\uFCC0\u0000\uFDE7\uF7EF\u0000" + //  5920 -  5929
                "\uABE0\uABE1\uABE2\uABE3\uABE4\uABE5\uABE6\uABE7\uC3CA\uC3CB" + //  5930 -  5939
                "\u0000\u0000\uC3CC\u0000\u0000\u0000\uEAC2\uF2E6\uF0B6\u0000" + //  5940 -  5949
                "\u0000\u0000\uCBEF\uFCDF\u0000\u0000\u0000\u0000\uC3A8\uC3A9" + //  5950 -  5959
                "\u0000\uC3AA\uC3C8\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + //  5960 -  5969
                "\uFAA5\u0000\u0000\uB5DF\u0000\u0000\u0000\u0000\u0000\u0000" + //  5970 -  5979
                "\u9AF0\uE9BE\u0000\u0000\uFAC9\u0000\u0000\uE1CD\u0000\uCAB8" + //  5980 -  5989
                "\u0000\uF7C1\u0000\u0000\uE7B6\u0000\u0000\u0000\u0000\uC5F9" + //  5990 -  5999
                "\uC5FA\u0000\uC5FB\uC3C4\u0000\u0000\u0000\uC3C5\u0000\u0000" + //  6000 -  6009
                "\u0000\uDBC1\u0000\u0000\u0000\u0000\u0000\uBBBE\u9FC4\u0000" + //  6010 -  6019
                "\u0000\uB5BF\u0000\uB5C0\u0000\uB5C1\u0000\u0000\uCBBA\u0000" + //  6020 -  6029
                "\u0000\uE5D1\u0000\u0000\u0000\uF9DC\u0000\u0000\uF3DC\u0000" + //  6030 -  6039
                "\u0000\uDDCF\u0000\u0000\u0000\u0000\u0000\u0000\uC4FA\u0000" + //  6040 -  6049
                "\u0000\uD6A2\u0000\uEDF0\u0000\u0000\u0000\u0000\uC7A5\u0000" + //  6050 -  6059
                "\u0000\u0000\uB0C0\u0000\uB0C1\u0000\u0000\uEEFE\u0000\uE7FE" + //  6060 -  6069
                "\u0000\u0000\u0000\u0000\uC6AC\u0000\u0000\u0000\uDEAB\uDBE8" + //  6070 -  6079
                "\u0000\u0000\uE3DD\uC3BE\u0000\u0000\u0000\uC3BF\u0000\u0000" + //  6080 -  6089
                "\u0000\uFCC4\u0000\u0000\u0000\u0000\u0000\u9FC3\u0000\u0000" + //  6090 -  6099
                "\u0000\uDFCB\u0000\u0000\u0000\u0000\u0000\u9EB9\u0000\u0000" + //  6100 -  6109
                "\u0000\uCEA2\u0000\u0000\uF3EE\u0000\uF1BC\u0000\u0000\uFADA" + //  6110 -  6119
                "\u0000\u0000\uDAEA\uDAC6\uC3B7\uC3B8\u0000\uC3B9\uC3BA\uC3BB" + //  6120 -  6129
                "\u0000\u0000\u9EE2\u0000\u0000\u0000\u0000\u0000\u0000\uDCB7" + //  6130 -  6139
                "\u0000\u0000\u0000\uDCC8\u0000\u0000\u0000\u0000\u0000\uB4B4" + //  6140 -  6149
                "\u0000\u0000\u0000\uEBE5\u0000\u0000\uE1D2\u0000\u9AFA\uF8DC" + //  6150 -  6159
                "\uF7EE\uEBE8\u0000\uD2FA\u0000\u0000\uEFE0\u0000\u0000\u0000" + //  6160 -  6169
                "\uE5E5\uD0D5\u0000\uABD8\uABD9\uABDA\uABDB\uABDC\uABDD\uABDE" + //  6170 -  6179
                "\uABDF\uC3B6\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uF6D5" + //  6180 -  6189
                "\uD5E2\u0000\uDDF3\uEAFA\u0000\uF6BD\uE1BB\uCDBF\uF4D4\uE6CD" + //  6190 -  6199
                "\uC3B3\uC3B4\u0000\u0000\uC3B5\u0000\u0000\u0000\u9EA1\u0000" + //  6200 -  6209
                "\u0000\u0000\u0000\u0000\uBAF1\uBAF2\u0000\u0000\u9EDF\u0000" + //  6210 -  6219
                "\u0000\u0000\u0000\u0000\u0000\uD4E1\u0000\uD1A3\uE1D6\uC3B1" + //  6220 -  6229
                "\uA0CA\u0000\u0000\u0000\uC3B2\u0000\u0000\uB4BF\u0000\u0000" + //  6230 -  6239
                "\u0000\u0000\u0000\u0000\uDEFD\uF2F9\u0000\uD5C7\uC3B0\u0000" + //  6240 -  6249
                "\u0000\u0000\u0000\u0000\u0000\u0000\uF1E9\u0000\u0000\uB4B1" + //  6250 -  6259
                "\u0000\u0000\u0000\u0000\u0000\u0000\uFDBE\u0000\u0000\uCAAC" + //  6260 -  6269
                "\uC3AD\u0000\u0000\u0000\uC3AE\u0000\uC3AF\u0000\u9BE7\uDEDE" + //  6270 -  6279
                "\uF2AF\uF8A9\u0000\u0000\u0000\u0000\uC5E2\u0000\u0000\u0000" + //  6280 -  6289
                "\uF8CE\uF9F0\uE0ED\uE3B3\uF4B3\uC3AB\uC3AC\u0000\u0000\u0000" + //  6290 -  6299
                "\u0000\u0000\u0000\uD6FE\u0000\u0000\u0000\uF5E0\u0000\u0000" + //  6300 -  6309
                "\u0000\u0000\u0000\uBAEA\uBAEB\u0000\u0000\uB4A6\u0000\uB4A7" + //  6310 -  6319
                "\u0000\uB4A8\u0000\u0000\uFAAF\u0000\uEBFC\u0000\u0000\uE0EA" + //  6320 -  6329
                "\u0000\uD9CB\u0000\uD9D2\uD3CB\uD8F7\uDAA9\uF5F8\u0000\uABD0" + //  6330 -  6339
                "\uABD1\uABD2\uABD3\uABD4\uABD5\uABD6\uABD7\uC3A6\u0000\u0000" + //  6340 -  6349
                "\u0000\uC3A7\u0000\u0000\u0000\uF8E8\u0000\u0000\u0000\u0000" + //  6350 -  6359
                "\u0000\uBADF\uBAE0\u0000\u0000\uB3B9\u0000\uB3BA\uB3BB\uB3BC" + //  6360 -  6369
                "\u0000\u0000\uFBF6\u0000\u0000\u0000\u0000\u0000\u0000\uF5CA" + //  6370 -  6379
                "\uE9B6\u0000\u0000\uF1D3\uF5E7\u0000\u0000\u0000\u0000\uCADA" + //  6380 -  6389
                "\uC2FC\uC2FD\u0000\uC2FE\uC3A1\uC3A2\uC3A3\uA0C8\uC2FB\u0000" + //  6390 -  6399
                "\u0000\u0000\u0000\u0000\u0000\u0000\uA1DA\uA1D9\u0000\uF6D8" + //  6400 -  6409
                "\u0000\u0000\u0000\uD4C7\u0000\u0000\u0000\uD7B0\uD8E8\uCBBD" + //  6410 -  6419
                "\u0000\u0000\uDFCE\u0000\u0000\u0000\u0000\u0000\u0000\uF4D1" + //  6420 -  6429
                "\u0000\u0000\uD4A1\uCEB2\u0000\u0000\u0000\u0000\u0000\uB2F1" + //  6430 -  6439
                "\uB2F2\u0000\u0000\uE8DB\u0000\uDBB3\u0000\u0000\u0000\uD1F7" + //  6440 -  6449
                "\uC2F7\uC2F8\u0000\u0000\uC2F9\u0000\uC2FA\uA0C7\uC2F0\u0000" + //  6450 -  6459
                "\u0000\u0000\uC2F1\u0000\u0000\u0000\uDCF2\u0000\u0000\u0000" + //  6460 -  6469
                "\u0000\u0000\uBADC\u0000\u0000\u0000\u9CFD\u0000\u0000\u0000" + //  6470 -  6479
                "\u0000\uCFA9\uA0C4\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + //  6480 -  6489
                "\uA1D1\u0000\u0000\uB2FE\u0000\u0000\u0000\uB3A1\u0000\u0000" + //  6490 -  6499
                "\uDBE7\uE2BF\u0000\u0000\u0000\u0000\u0000\u9EFC\u0000\u0000" + //  6500 -  6509
                "\u0000\uE4AE\u0000\u0000\u0000\u0000\u0000\u9BCB\u0000\u0000" + //  6510 -  6519
                "\u0000\uE8CD\u0000\u0000\u0000\u0000\uC6F7\uC6F8\u0000\u0000" + //  6520 -  6529
                "\uE8C0\uE8C1\u0000\u0000\u0000\uCFE3\uE9A2\uC2E9\u0000\u0000" + //  6530 -  6539
                "\u0000\u0000\u0000\u0000\u0000\uA1EF\u0000\u0000\u9ECF\u0000" + //  6540 -  6549
                "\u0000\u0000\u0000\u0000\u0000\uF4CC\uDAFC\u0000\u0000\uEDBE" + //  6550 -  6559
                "\u0000\u0000\u0000\uD5C0\uE3F0\uEDFA\uA0C2\u0000\u0000\u0000" + //  6560 -  6569
                "\u0000\u0000\u0000\u0000\uE4EC\u0000\uF7C0\u0000\uD0E3\u0000" + //  6570 -  6579
                "\u9BCF\u0000\uDAA1\u0000\uABC8\uABC9\uABCA\uABCB\uABCC\uABCD" + //  6580 -  6589
                "\uABCE\uABCF\uC2E6\uC2E7\u0000\u0000\u0000\u0000\u0000\u0000" + //  6590 -  6599
                "\uDCEF\u0000\uD6A5\u0000\uCDE7\u0000\uE8DC\u0000\u0000\uE7D7" + //  6600 -  6609
                "\u0000\u0000\uD9BC\u0000\uE5C6\u0000\u0000\u0000\u0000\uC4F5" + //  6610 -  6619
                "\u0000\u0000\u0000\uE7E5\u0000\u0000\uCFCA\uE1D1\uC2E2\uC2E3" + //  6620 -  6629
                "\u0000\u0000\u0000\uC2E4\u0000\u0000\uB2D1\u0000\u0000\u0000" + //  6630 -  6639
                "\u0000\u0000\u0000\uE2A4\u0000\u0000\u0000\uF5A1\u0000\u0000" + //  6640 -  6649
                "\u0000\u0000\u0000\uB2F4\uB2F5\u0000\u0000\uD3C6\u0000\uDBE6" + //  6650 -  6659
                "\u0000\u0000\u0000\u0000\uFDB3\u0000\uD5E4\u0000\u0000\uDFE2" + //  6660 -  6669
                "\uE7DB\u0000\u0000\u0000\u0000\u0000\uB6AB\uB6AC\u0000\uB6AD" + //  6670 -  6679
                "\uC2E1\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uF4ED\u0000" + //  6680 -  6689
                "\uF2AE\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uDDED\uC2DE" + //  6690 -  6699
                "\uC2DF\u0000\u0000\uC2E0\u0000\u0000\u0000\uE8AD\u0000\u0000" + //  6700 -  6709
                "\u0000\u0000\uEFAF\uC2DB\uC2DC\u0000\u0000\u0000\u0000\u0000" + //  6710 -  6719
                "\u0000\uEBFA\u0000\uF9E6\u0000\uE0B1\u0000\u0000\u0000\u0000" + //  6720 -  6729
                "\uDFA5\u0000\uF9D2\uC2DA\u0000\u0000\u0000\u0000\u0000\u0000" + //  6730 -  6739
                "\u0000\uEFC6\u0000\uEFE2\uF1F0\uCFB4\u0000\u0000\u0000\u0000" + //  6740 -  6749
                "\u0000\uB4A9\uB4AA\u0000\u0000\uF8F6\u0000\u0000\u0000\u0000" + //  6750 -  6759
                "\uF5D2\uEDE9\uC2D8\u0000\u0000\u0000\uC2D9\u0000\u0000\u0000" + //  6760 -  6769
                "\uE9E9\u0000\u0000\u0000\u0000\u0000\uBACC\u0000\u0000\u0000" + //  6770 -  6779
                "\uDAAC\uEAB0\u0000\u0000\u0000\u0000\uA0C1\u0000\u0000\u0000" + //  6780 -  6789
                "\uD3C4\u0000\u0000\uD6C0\u0000\uE7B5\u0000\u0000\u0000\u0000" + //  6790 -  6799
                "\u0000\uDBF0\u0000\uABC0\uABC1\uABC2\uABC3\uABC4\uABC5\uABC6" + //  6800 -  6809
                "\uABC7\uC2D7\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uDBA5" + //  6810 -  6819
                "\u0000\uEEFD\u0000\u0000\u0000\u0000\u0000\u0000\uE4AB\uC2D4" + //  6820 -  6829
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uE2CF\u0000\uDDF2" + //  6830 -  6839
                "\u0000\u0000\uD9BE\u0000\u0000\u0000\u0000\uC5D7\uC5D8\u0000" + //  6840 -  6849
                "\u0000\uD5DA\u0000\uD7A7\u0000\u0000\u0000\uEEC0\uC2D2\uC2D3" + //  6850 -  6859
                "\u0000\u0000\u0000\u0000\u0000\u0000\uDBCE\u0000\uF7C3\u0000" + //  6860 -  6869
                "\uEDD1\u0000\u0000\u0000\u0000\u0000\uE9F9\u0000\uABB8\uABB9" + //  6870 -  6879
                "\uABBA\uABBB\uABBC\uABBD\uABBE\uABBF\uC2CB\u0000\u0000\u0000" + //  6880 -  6889
                "\uC2CC\u0000\u0000\u0000\uF5B2\u9AAF\u0000\u0000\u0000\u0000" + //  6890 -  6899
                "\uEFD1\u0000\u0000\uD9B5\u0000\uCFFD\u0000\u0000\uDEDD\u0000" + //  6900 -  6909
                "\u0000\u0000\uD9D1\uA0BF\u0000\u0000\u0000\u0000\u0000\u0000" + //  6910 -  6919
                "\u0000\uCEA8\u0000\uCFB1\u0000\u0000\u0000\u0000\u0000\u0000" + //  6920 -  6929
                "\u0000\uD9DA\uC2C8\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + //  6930 -  6939
                "\uF3A1\u0000\u9CC7\u0000\uD1A7\u0000\u0000\uFDE3\uCEB3\u0000" + //  6940 -  6949
                "\uABB0\uABB1\uABB2\uABB3\uABB4\uABB5\uABB6\uABB7\uA0BD\u0000" + //  6950 -  6959
                "\u0000\u0000\u0000\u0000\u0000\u0000\uEBB9\u0000\uFDE2\uF3AD" + //  6960 -  6969
                "\u0000\uFDDB\u0000\u0000\u0000\u0000\uA0DD\u0000\u0000\u0000" + //  6970 -  6979
                "\uCECE\u0000\u0000\u0000\u0000\uDAAE\uCAEE\u0000\u0000\u0000" + //  6980 -  6989
                "\uCAC8\uF9EE\uDBEC\u0000\u0000\uCDBE\u0000\uDAE9\u0000\u0000" + //  6990 -  6999
                "\u0000\u0000\uC4E8\uA0D7\u0000\u0000\uD5D9\u0000\u9DAD\u0000" + //  7000 -  7009
                "\uD8DE\u0000\u0000\uF1B9\u0000\u0000\uDAD3\u0000\uF6EA\u0000" + //  7010 -  7019
                "\uABA8\uABA9\uABAA\uABAB\uABAC\uABAD\uABAE\uABAF\uC2C5\u0000" + //  7020 -  7029
                "\u0000\u0000\u0000\u0000\u0000\u0000\uD0B7\u0000\u9AB5\u0000" + //  7030 -  7039
                "\uCBFE\uEDEA\u0000\u0000\u0000\u0000\uC5AD\uC5AE\u0000\u0000" + //  7040 -  7049
                "\uD9EA\uF5A2\u0000\u0000\u0000\uD7D1\u0000\uAAF0\uAAF1\uAAF2" + //  7050 -  7059
                "\uAAF3\u0000\u0000\u0000\u0000\uC0A7\uC0A8\u0000\u0000\uDBFA" + //  7060 -  7069
                "\u0000\u0000\u0000\uE8B5\u0000\uD3A6\uC2C3\uC2C4\u0000\u0000" + //  7070 -  7079
                "\u0000\u0000\u0000\u0000\uECBD\uE2DC\uDEEB\uF0DC\uC2BE\u0000" + //  7080 -  7089
                "\u0000\u0000\uC2BF\u0000\u0000\uA0BC\uA0BB\u0000\u0000\u0000" + //  7090 -  7099
                "\u0000\u0000\u0000\u0000\uD5CD\u0000\uD3AA\u0000\u0000\u0000" + //  7100 -  7109
                "\uCCAC\u0000\u0000\u0000\uD3B4\u0000\u0000\u0000\u0000\uDCD5" + //  7110 -  7119
                "\u0000\uF7B5\uFCF3\uF0F3\uC2BA\u0000\u0000\u0000\u0000\u0000" + //  7120 -  7129
                "\u0000\u0000\uF4F5\u0000\uD0B9\uD4F2\u0000\u0000\u0000\u0000" + //  7130 -  7139
                "\u0000\uD1A6\uC2B4\uC2B5\u0000\uC2B6\uC2B7\uC2B8\u0000\u0000" + //  7140 -  7149
                "\uB2C7\uB2C8\uB2C9\u0000\u0000\u0000\u0000\uEDD5\u0000\u0000" + //  7150 -  7159
                "\uD9BA\u0000\u9DE8\u0000\uE9F8\uE2E5\u0000\u0000\u0000\u0000" + //  7160 -  7169
                "\uC5A1\uC5A2\u0000\uC5A3\uC2B3\u0000\u0000\u0000\u0000\u0000" + //  7170 -  7179
                "\u0000\u0000\uCABC\u0000\uE8FA\u0000\u0000\uCEE9\u0000\u0000" + //  7180 -  7189
                "\u0000\u0000\uC4FB\uC4FC\u0000\u0000\uD8F6\u0000\uD1A4\u0000" + //  7190 -  7199
                "\uCDE2\u0000\u0000\uDFB4\u0000\u0000\u0000\u0000\uD7DD\uFABA" + //  7200 -  7209
                "\uC2B0\uC2B1\u0000\u0000\uC2B2\u0000\u0000\u0000\uD3B3\u0000" + //  7210 -  7219
                "\u0000\u0000\u0000\u0000\uBAB8\uBAB9\uBABA\u0000\uDAD4\uE2A7" + //  7220 -  7229
                "\uFBFC\u0000\u0000\uF1DC\u0000\u0000\uE8C9\uF4FE\u0000\u0000" + //  7230 -  7239
                "\u0000\u0000\uE7FC\uC2AE\uC2AF\u0000\u0000\u0000\u0000\u0000" + //  7240 -  7249
                "\u0000\uCDC4\u0000\u0000\u0000\uF5DB\u0000\u0000\uFAC1\u0000" + //  7250 -  7259
                "\u0000\u9EC0\uB1ED\u0000\uB1EE\uB1EF\uB1F0\u0000\uCEAA\u0000" + //  7260 -  7269
                "\uCBC8\u0000\u0000\u0000\u0000\u0000\uB3BF\uB3C0\u0000\uB3C1" + //  7270 -  7279
                "\uC2A7\u0000\uC2A8\u0000\uC2A9\u0000\u0000\uC2AA\uC1FC\uC1FD" + //  7280 -  7289
                "\u0000\uC1FE\uA0BA\uC2A1\uC2A2\u0000\uCED9\u0000\u0000\u9ABE" + //  7290 -  7299
                "\u0000\u0000\u0000\u0000\uC4EC\u0000\u0000\u0000\uF0E5\u0000" + //  7300 -  7309
                "\u0000\u0000\uF4C4\uC1FA\u0000\uC1FB\u0000\u0000\u0000\u0000" + //  7310 -  7319
                "\u0000\uBEBA\u0000\u0000\u0000\uE4C7\u0000\u0000\u0000\u0000" + //  7320 -  7329
                "\u0000\u9FB7\uBAB1\u0000\uBAB2\uC1F6\uC1F7\u0000\u0000\uC1F8" + //  7330 -  7339
                "\u0000\u0000\uC1F9\uC1F2\uC1F3\u0000\uC1F4\u0000\uC1F5\u0000" + //  7340 -  7349
                "\u0000\uB1C3\uB1C4\u0000\u0000\u0000\u0000\u0000\uBCD8\uBCD9" + //  7350 -  7359
                "\u0000\uBCDA\uC1F1\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + //  7360 -  7369
                "\uE7CA\u0000\uF5D1\uE7B3\u0000\u0000\u0000\u0000\u0000\u0000" + //  7370 -  7379
                "\uE0D6\u0000\u0000\u9ABD\u0000\u0000\u0000\u0000\u0000\u0000" + //  7380 -  7389
                "\u9BB8\uE9CB\u0000\uAAE8\uAAE9\uAAEA\uAAEB\uAAEC\uAAED\uAAEE" + //  7390 -  7399
                "\uAAEF\uC1EE\uC1EF\u0000\u0000\uC1F0\u0000\u0000\u0000\uCEF4" + //  7400 -  7409
                "\u0000\u0000\u0000\u0000\u0000\uB9FC\uB9FD\u0000\uB9FE\uC1EB" + //  7410 -  7419
                "\u0000\u0000\u0000\uC1EC\u0000\u0000\u0000\uFBAE\uD1E1\u0000" + //  7420 -  7429
                "\u0000\uDBC0\u0000\uEFDF\u0000\u0000\uF1EF\u0000\uE5F6\uEEBF" + //  7430 -  7439
                "\uE2E4\uC1E7\uC1E8\u0000\uC1E9\u0000\u0000\u0000\u0000\uE5A1" + //  7440 -  7449
                "\u0000\u0000\u0000\u0000\uC5C6\uC5C7\u0000\uC5C8\uC1E6\u0000" + //  7450 -  7459
                "\u0000\u0000\u0000\u0000\u0000\u0000\uD6A6\uDCBE\uC1E3\uC1E4" + //  7460 -  7469
                "\u0000\u0000\uC1E5\u0000\u0000\u0000\uF2C0\u0000\u0000\uF1E5" + //  7470 -  7479
                "\u0000\uF4C3\uC1E0\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + //  7480 -  7489
                "\uCBE6\u0000\uD1F8\uEAF8\uEAF9\uDAB3\u0000\u0000\u0000\u0000" + //  7490 -  7499
                "\uC4DA\uC4DB\u0000\u0000\uCEE8\uDBDB\u0000\u0000\u0000\u0000" + //  7500 -  7509
                "\u0000\uB2E3\u0000\u0000\u0000\uD5B8\u0000\u0000\uF7FD\u0000" + //  7510 -  7519
                "\uAAE0\uAAE1\uAAE2\uAAE3\uAAE4\uAAE5\uAAE6\uAAE7\uC1D8\u0000" + //  7520 -  7529
                "\u0000\u0000\uC1D9\uC1DA\uC1DB\u0000\uE5AB\u0000\u0000\u0000" + //  7530 -  7539
                "\u0000\u0000\u0000\u0000\uDCE9\uA0B5\uA0B6\u0000\u0000\u0000" + //  7540 -  7549
                "\uC1D5\u0000\u0000\uB1B6\u0000\uB1B7\u0000\u0000\u0000\u0000" + //  7550 -  7559
                "\uE0AF\uF4E7\u0000\uEFDC\uCFFC\uA0B4\u0000\u0000\u0000\u0000" + //  7560 -  7569
                "\u0000\u0000\u0000\uF7C5\u0000\uE8CA\u0000\u0000\u0000\u9DAC" + //  7570 -  7579
                "\uEBF5\u0000\u0000\uCFAF\u0000\u0000\uCAD3\u0000\u0000\uCAAF" + //  7580 -  7589
                "\uC1D2\uC1D3\u0000\u0000\uC1D4\u0000\u0000\u0000\uEEE8\uDADE" + //  7590 -  7599
                "\u0000\uF2F7\u0000\u0000\uB1B2\u0000\u0000\u0000\u0000\u0000" + //  7600 -  7609
                "\u0000\uEAB5\u0000\uE5AA\uDFBA\uC1CC\u0000\u0000\u0000\uC1CD" + //  7610 -  7619
                "\u0000\u0000\u0000\uE9E6\u0000\u9EAB\uE3F6\u0000\u0000\uB1A4" + //  7620 -  7629
                "\u0000\u0000\u0000\u0000\u0000\u0000\uCEC0\uE3D4\uD1CF\uF1F5" + //  7630 -  7639
                "\uA0B3\u0000\u0000\u0000\uC1C9\uC1CA\u0000\u0000\uB0E7\u0000" + //  7640 -  7649
                "\u0000\uB0E8\u0000\u0000\u0000\uCEE6\uFCAB\uD5BB\u0000\u0000" + //  7650 -  7659
                "\uF2A8\uA0B2\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uCCED" + //  7660 -  7669
                "\u0000\uCDA1\u0000\u0000\u0000\u0000\u0000\uDFB5\u0000\uAAD8" + //  7670 -  7679
                "\uAAD9\uAADA\uAADB\uAADC\uAADD\uAADE\uAADF\uC1C8\u0000\u0000" + //  7680 -  7689
                "\u0000\uA0B1\u0000\u0000\u0000\uF4E5\uD8C2\uDCD0\uCCEE\u0000" + //  7690 -  7699
                "\u0000\uB0D1\uB0D2\uB0D3\uB0D4\u0000\u0000\u0000\uD0D3\u0000" + //  7700 -  7709
                "\uD3BD\u0000\u0000\u0000\uF0EB\u0000\u0000\u0000\u0000\uCCD1" + //  7710 -  7719
                "\u0000\uDFEA\u0000\u0000\uDCCC\u0000\uD0CB\u0000\u0000\u0000" + //  7720 -  7729
                "\uFCA4\uA0B0\uC1C7\u0000\u0000\u0000\u0000\u0000\u0000\uD6A3" + //  7730 -  7739
                "\u0000\u0000\u0000\uFACD\u0000\u0000\u0000\u0000\u0000\u9FB2" + //  7740 -  7749
                "\uB9F5\u0000\u0000\uB0B0\uB0B1\uB0B2\uB0B3\uB0B4\u0000\u0000" + //  7750 -  7759
                "\uD6E1\uCFD2\u0000\uD0B6\u0000\u0000\u0000\uF1AE\u0000\uEFCE" + //  7760 -  7769
                "\u0000\u0000\u0000\uFADB\uCBE3\uF7A9\u9DED\uFBA6\uA0AE\u0000" + //  7770 -  7779
                "\u0000\u0000\uC1C4\u0000\u0000\u0000\uF3B3\uE4D8\uCFF9\uCFDA" + //  7780 -  7789
                "\u0000\u0000\uD6C6\u0000\u0000\u0000\u0000\u9CF0\uE0E5\uC1BB" + //  7790 -  7799
                "\uC1BC\u0000\uC1BD\u0000\uC1BE\uC1BF\uC1C0\uC1B9\u0000\uC1BA" + //  7800 -  7809
                "\u0000\u0000\u0000\u0000\u0000\uBEAE\u0000\u0000\u0000\uD7F5" + //  7810 -  7819
                "\uE3F3\uCFE5\u0000\u0000\u0000\uD9D3\u0000\u0000\u0000\u0000" + //  7820 -  7829
                "\uD3DE\uC1B6\uC1B7\u0000\u0000\uC1B8\u0000\u0000\u0000\uF1CC" + //  7830 -  7839
                "\u0000\u0000\uE5B8\u0000\u0000\uFDD9\u0000\u0000\uCCA3\u0000" + //  7840 -  7849
                "\u0000\u0000\uE5C0\uFCB5\u0000\u0000\u0000\u0000\uC3F5\u0000" + //  7850 -  7859
                "\u0000\u0000\uEDFC\u0000\u0000\uE1DB\u0000\uD3D6\u0000\u0000" + //  7860 -  7869
                "\u0000\u0000\u0000\u0000\uEDD0\uC1B1\uC1B2\u0000\uA0AD\uC1B3" + //  7870 -  7879
                "\uC1B4\u0000\u0000\u9DDC\u0000\u0000\u0000\u0000\u0000\u0000" + //  7880 -  7889
                "\uFCE2\u0000\uF8A7\u0000\uD0BE\u0000\uDDDC\u0000\u0000\u0000" + //  7890 -  7899
                "\u0000\uD4D6\uC1B0\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + //  7900 -  7909
                "\uDABA\u0000\uCCFE\uCDE1\u0000\uE1BA\u0000\uDBEF\uDAB2\u0000" + //  7910 -  7919
                "\uAAD0\uAAD1\uAAD2\uAAD3\uAAD4\uAAD5\uAAD6\uAAD7\uC1AE\uA0AC" + //  7920 -  7929
                "\u0000\u0000\uC1AF\u0000\u0000\u0000\uEBB3\u0000\uF0B4\u0000" + //  7930 -  7939
                "\u0000\uCBF4\uC1A8\u0000\u0000\u0000\uC1A9\u0000\u0000\u0000" + //  7940 -  7949
                "\uF1A1\u0000\u0000\u0000\u0000\u0000\u9FAD\u0000\u0000\u0000" + //  7950 -  7959
                "\uCED4\uE7AB\u0000\u0000\u0000\uCBC3\uC1A1\uC1A2\u0000\uC1A3" + //  7960 -  7969
                "\uA0AA\uC1A4\uC1A5\u0000\uD7DE\u0000\u0000\u0000\u0000\uDEDC" + //  7970 -  7979
                "\u0000\uF0AC\uC0FD\u0000\uC0FE\u0000\u0000\u0000\u0000\u0000" + //  7980 -  7989
                "\uBEA9\uBEAA\u0000\u9FF0\uC0FA\uC0FB\u0000\u0000\uC0FC\u0000" + //  7990 -  7999
                "\u0000\uA0A9\uC0F8\u0000\u0000\u0000\uC0F9\u0000\u0000\u0000" + //  8000 -  8009
                "\uE9C9\u0000\u0000\u0000\u0000\uD3CE\uC0F5\u0000\u0000\u0000" + //  8010 -  8019
                "\u0000\uC0F6\u0000\u0000\uD9D0\u0000\u0000\u0000\u0000\u0000" + //  8020 -  8029
                "\uE5A3\uC0F4\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uE3A8" + //  8030 -  8039
                "\u0000\uD4D5\uDFCD\u0000\uFCB8\uD1D0\u0000\u0000\u0000\uECA2" + //  8040 -  8049
                "\uEDFD\u0000\uF5B4\uFBB8\uC0F0\uC0F1\u0000\u0000\uC0F2\u0000" + //  8050 -  8059
                "\uC0F3\u0000\uE4D0\u0000\u0000\u0000\u0000\u0000\uF2EE\u0000" + //  8060 -  8069
                "\uAAC8\uAAC9\uAACA\uAACB\uAACC\uAACD\uAACE\uAACF\uC0EE\uC0EF" + //  8070 -  8079
                "\u0000\u0000\u0000\u0000\u0000\u0000\uF0FC\u0000\u0000\u0000" + //  8080 -  8089
                "\uDDBA\u0000\u0000\u0000\uF2BF\u0000\uCBFA\uF9F9\uCCFD\uD3FE" + //  8090 -  8099
                "\u0000\u0000\u0000\u0000\uC4D4\uC4D5\u0000\uC4D6\uC0E9\u0000" + //  8100 -  8109
                "\u0000\u0000\uC0EA\u0000\u0000\u0000\uEAC6\u0000\u0000\u0000" + //  8110 -  8119
                "\u0000\u0000\uB9C5\u0000\u0000\uB9C6\uC0E1\uC0E2\u0000\uC0E3" + //  8120 -  8129
                "\uC0E4\uC0E5\uC0E6\uA0A7\uC0DF\u0000\uC0E0\u0000\u0000\u0000" + //  8130 -  8139
                "\u0000\u0000\uBEA5\uBEA6\u0000\u0000\u9CB7\u0000\u0000\u0000" + //  8140 -  8149
                "\u0000\u0000\u0000\uD0FB\uECDB\u0000\u0000\uDDB4\uE4B5\uD8B0" + //  8150 -  8159
                "\u0000\u0000\u0000\u0000\uFCF1\u0000\u0000\u0000\uD0BC\uC0DA" + //  8160 -  8169
                "\uC0DB\u0000\u0000\uC0DC\u0000\uC0DD\uC0DE\uC0D6\uC0D7\uC0D8" + //  8170 -  8179
                "\u0000\u0000\u0000\uC0D9\u0000\uFAB7\uD0C6\u0000\u0000\uCCAB" + //  8180 -  8189
                "\uEEA8\u0000\u0000\u9AD8\u0000\u0000\u0000\u0000\u0000\u0000" + //  8190 -  8199
                "\uCBF5\u0000\u0000\uFCFB\u0000\u0000\u0000\u0000\u0000\u0000" + //  8200 -  8209
                "\uD4EF\u0000\u0000\uF1DB\u0000\uFAD9\u0000\uF1B8\uFDF5\uE0F9" + //  8210 -  8219
                "\uC0CE\u0000\u0000\uA0A6\uC0CF\uC0D0\uC0D1\u0000\uD2B0\uF1BA" + //  8220 -  8229
                "\u0000\uD7B3\uE3C3\uF3FD\uDEDA\u0000\uAAC0\uAAC1\uAAC2\uAAC3" + //  8230 -  8239
                "\uAAC4\uAAC5\uAAC6\uAAC7\uC0CA\u0000\u0000\uC0CB\u0000\u0000" + //  8240 -  8249
                "\u0000\u0000\uD6D0\u0000\u0000\u0000\u0000\uC5C2\uC5C3\u0000" + //  8250 -  8259
                "\u0000\uCCBB\u0000\u0000\u0000\u0000\u0000\u0000\uEDE4\u0000" + //  8260 -  8269
                "\u0000\uDDE7\uC0C9\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + //  8270 -  8279
                "\uCDE5\u0000\uD9BB\uCAF3\uF6D3\uE6F8\uEAF5\u0000\u0000\u0000" + //  8280 -  8289
                "\uD5E0\uF6CA\uFDCA\uD8D6\uF4CF\uC0C7\u0000\u0000\u0000\uC0C8" + //  8290 -  8299
                "\u0000\u0000\u0000\uF2F5\u0000\u0000\uD4AE\u0000\u0000\uCFCD" + //  8300 -  8309
                "\u0000\u0000\u0000\u0000\u0000\u0000\uFDF1\u0000\u0000\u0000" + //  8310 -  8319
                "\uD1F4\uD2BA\u0000\u0000\u0000\uDFF2\uC0BA\u0000\u0000\u0000" + //  8320 -  8329
                "\uC0BB\u0000\u0000\u0000\uD6F2\u0000\uDEF4\u0000\uDFDB\u0000" + //  8330 -  8339
                "\uCFAE\u0000\u0000\u0000\u0000\u0000\uE3C2\u0000\uAAB8\uAAB9" + //  8340 -  8349
                "\uAABA\uAABB\uAABC\uAABD\uAABE\uAABF\uC0B3\uC0B4\u0000\uC0B5" + //  8350 -  8359
                "\u0000\uC0B6\uA0A5\uC0B7\uC0B2\u0000\u0000\u0000\u0000\u0000" + //  8360 -  8369
                "\u0000\u0000\uD0DA\uD0DB\uC0AF\uC0B0\u0000\u0000\uC0B1\u0000" + //  8370 -  8379
                "\u0000\u0000\uD8E7\u0000\uD9C9\u0000\u0000\u0000\uF8C0\u0000" + //  8380 -  8389
                "\u0000\u0000\uD3DD\u0000\uF8C2\u0000\u0000\uF2AC\u0000\u0000" + //  8390 -  8399
                "\uCAAD\uCAAE\uC0A9\u0000\u0000\uA0A4\uC0AA\u0000\u0000\u0000" + //  8400 -  8409
                "\uF5B0\u0000\u0000\u0000\u0000\u0000\uB9BE\u0000\u0000\u0000" + //  8410 -  8419
                "\uDBA9\u0000\u0000\uD3BB\uCAEC\u0000\uE0B0\u0000\u0000\uD4E2" + //  8420 -  8429
                "\u0000\uF6D7\u0000\uD7F9\uC0A4\uC0A5\u0000\u0000\u0000\uC0A6" + //  8430 -  8439
                "\u0000\u0000\uDCAE\u0000\u0000\u0000\u0000\u0000\u0000\u9AD1" + //  8440 -  8449
                "\u0000\u0000\u0000\uCFEC\u0000\u0000\u0000\u0000\uF4DF\uC0A3" + //  8450 -  8459
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u9DA4\uDEEF\uBFFE" + //  8460 -  8469
                "\uC0A1\u0000\u0000\uC0A2\u0000\u0000\u0000\uFBDF\uE7E3\u9DA5" + //  8470 -  8479
                "\u0000\u0000\u0000\uEAAE\uEAAD\u0000\u0000\uD3F1\u0000\uCBF9" + //  8480 -  8489
                "\uD4D4\u9ABA\uD9DC\u0000\uEEBE\u0000\uF7ED\uBFFC\uBFFD\u0000" + //  8490 -  8499
                "\u0000\u0000\u0000\u0000\u0000\u9BC4\u0000\uDDD0\uF0D9\uBFF8" + //  8500 -  8509
                "\u0000\u0000\u0000\uBFF9\u0000\u0000\u0000\uD4CA\u0000\u0000" + //  8510 -  8519
                "\u0000\u0000\u0000\uB9AB\uB9AC\uB9AD\u0000\uEEA7\uF5BD\u0000" + //  8520 -  8529
                "\uF8F5\u0000\u0000\uEDE8\u0000\uAAB0\uAAB1\uAAB2\uAAB3\uAAB4" + //  8530 -  8539
                "\uAAB5\uAAB6\uAAB7\uBFF2\uBFF3\u0000\uBFF4\u0000\uBFF5\u0000" + //  8540 -  8549
                "\u0000\uD7EF\u0000\u0000\u0000\u0000\u0000\u0000\uE1D5\u0000" + //  8550 -  8559
                "\u0000\uD4EA\uBFEF\uBFF0\uBFF1\u0000\u0000\u0000\u0000\u0000" + //  8560 -  8569
                "\uBEA2\uBEA3\u0000\u9FEF\uBFEC\uBFED\u0000\u0000\uBFEE\u0000" + //  8570 -  8579
                "\u0000\uA0A2\uBFE6\u0000\u0000\u0000\uBFE7\u0000\u0000\u0000" + //  8580 -  8589
                "\uDCA8\u0000\u9CD6\u0000\u0000\u0000\uF0BF\u0000\uF6A4\u0000" + //  8590 -  8599
                "\uE3B6\u0000\uD9CA\u0000\uDAB1\uD8C7\uDCE2\uF3CE\uF5F4\u0000" + //  8600 -  8609
                "\uAAA8\uAAA9\uAAAA\uAAAB\uAAAC\uAAAD\uAAAE\uAAAF\uBFE0\uBFE1" + //  8610 -  8619
                "\u0000\uBFE2\u0000\uBFE3\u0000\u0000\u9BB2\u0000\u0000\uD8AA" + //  8620 -  8629
                "\u0000\u0000\u0000\uDDD9\u0000\u0000\u0000\u9DE7\uD9E7\uBFDF" + //  8630 -  8639
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uFBDB\u0000\uEAC5" + //  8640 -  8649
                "\uEAF3\u0000\uDDDB\u0000\uDCD7\u0000\u0000\uDFF5\u0000\u0000" + //  8650 -  8659
                "\uE8F8\uF8ED\u0000\u0000\uE0E7\u0000\uCCD9\u0000\u0000\uD4C6" + //  8660 -  8669
                "\u0000\uA1BC\uA1BD\u0000\uA1EB\uA1B2\uA1B3\u0000\u0000\uE9BA" + //  8670 -  8679
                "\u0000\u0000\u0000\u0000\u0000\u0000\uCBCE\uFBD8\u0000\u0038" + //  8680 -  8689
                "\u0039\u003A\u003B\u003C\u003D\u003E\u003F\uBFDC\uBFDD\u0000" + //  8690 -  8699
                "\u0000\uBFDE\u0000\u0000\u0000\uEFF5\uCADF\u0000\uEBB1\uEDBF" + //  8700 -  8709
                "\u0000\uF5CC\u0000\u0000\uFCE5\u0000\u0000\u0000\u0000\uC4C4" + //  8710 -  8719
                "\uC4C5\u0000\uC4C6\uBFD8\u0000\u0000\u0000\u0000\u0000\u0000" + //  8720 -  8729
                "\u0000\uE5EE\uDCA2\uBFD1\uBFD2\u0000\uBFD3\uBFD4\uBFD5\u0000" + //  8730 -  8739
                "\u0000\uEAA6\u0000\u0000\u0000\u0000\u0000\u0000\uDDA3\u0000" + //  8740 -  8749
                "\u0000\u0000\uEFB8\u0000\u0000\u0000\uD7C0\u0000\uDFF6\uF0C7" + //  8750 -  8759
                "\uF0C6\u0000\uD8BA\u0000\uF1F4\uF4F0\uBFD0\u0000\u0000\u0000" + //  8760 -  8769
                "\u0000\u0000\u0000\u0000\uF4C0\u0000\uE8D8\u0000\uCDD8\uE7D6" + //  8770 -  8779
                "\uCCDA\u0000\u0000\uCAE3\uBFCD\uBFCE\u0000\u0000\uBFCF\u0000" + //  8780 -  8789
                "\u0000\u0000\uD5DF\u0000\u0000\u0000\uD6E5\u0000\uCEC7\u0000" + //  8790 -  8799
                "\u0000\u0000\u0000\u0000\uFDF6\u0000\uA1B4\uA1B5\uA1B6\uA1B7" + //  8800 -  8809
                "\uA1B8\uA1B9\uA1BA\uA1BB\uBFC6\u0000\u0000\uBFC7\uBFC8\uBFC9" + //  8810 -  8819
                "\u0000\uBFCA\uBFC2\u0000\u0000\u9FFE\uBFC3\uBFC4\uBFC5\u0000" + //  8820 -  8829
                "\uCDBC\u0000\uF3E5\u0000\u0000\u0000\u0000\u0000\uB2CF\uB2D0" + //  8830 -  8839
                "\u0000\u0000\uF2CB\u0000\uF2CC\u0000\u0000\u0000\uE4CF\uBFBC" + //  8840 -  8849
                "\uBFBD\u0000\uBFBE\uBFBF\u9FFD\u0000\u0000\u9DD4\u0000\uE2D0" + //  8850 -  8859
                "\uF4F7\u0000\u0000\u0000\uF3A4\u0000\u0000\u0000\uD4FB\uFCE3" + //  8860 -  8869
                "\uBFBB\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u9BA6\u0000" + //  8870 -  8879
                "\uE5C3\u0000\u0000\u0000\u0000\uD9A6\u0000\u0000\uF0C5\uE3C1" + //  8880 -  8889
                "\uFCCC\uFCCD\u0000\u0000\u0000\uF2E2\u0000\u0000\u0000\u0000" + //  8890 -  8899
                "\uDECD\uECF3\u0000\u0000\uEDE0\uBFB9\u0000\u0000\u0000\uBFBA" + //  8900 -  8909
                "\u0000\u0000\u0000\uF2E0\uF1C9\u9DBF\u0000\u0000\u0000\uDDE3" + //  8910 -  8919
                "\u0000\u0000\u0000\u0000\uFCDD\uBFB4\uBFB5\u0000\u0000\u0000" + //  8920 -  8929
                "\uBFB6\uBFB7\uBFB8\uBFAC\u9FFB\u0000\u9FFC\uBFAD\u0000\uBFAE" + //  8930 -  8939
                "\uBFAF\uBFA5\uBFA6\u0000\uBFA7\u0000\uBFA8\u0000\u0000\uFCBE" + //  8940 -  8949
                "\uD5F1\u0000\u0000\u0000\u0000\u0000\uBBD8\u0000\u0000\u0000" + //  8950 -  8959
                "\uFACA\u0000\u0000\u0000\uE5E3\u0000\uEAD1\uDFF4\u0000\u0000" + //  8960 -  8969
                "\u0000\u0000\uD1EC\uE4DE\uBFA4\u0000\u0000\u0000\u0000\u0000" + //  8970 -  8979
                "\u0000\u0000\uCCEC\u0000\uFDBB\uFDC7\u0000\u0000\u0000\u0000" + //  8980 -  8989
                "\uE7B2\u0000\uA1A1\uA1A2\uA1A3\uA1A8\u0000\u0000\u0000\u0000" + //  8990 -  8999
                "\uBFFA\uBFFB\u0000\uA0A3\uBFA1\uBFA2\u0000\u0000\uBFA3\u0000" + //  9000 -  9009
                "\u0000\u0000\uDBBE\u0000\u0000\uE0E2\u0000\u0000\uF8BE\u0000" + //  9010 -  9019
                "\u0000\u0000\u0000\u0000\u0000\uE0F4\u0000\uCFE0\u0000\uEFDD" + //  9020 -  9029
                "\u0000\uF2AA\u0000\u0000\u0000\u0000\u0000\uB2C4\uB2C5\u0000" + //  9030 -  9039
                "\uB2C6\uBEFA\uBEFB\uBEFC\u0000\uBEFD\u0000\uBEFE\u0000\uE3E7" + //  9040 -  9049
                "\uD8B9\u0000\uF6F8\u9CB3\u0000\uDCC5\uCCD8\uBEF0\uBEF1\u0000" + //  9050 -  9059
                "\uBEF2\uBEF3\uBEF4\uBEF5\u0000\uF9C0\uE9F0\u0000\u0000\uD9DB" + //  9060 -  9069
                "\u0000\uF3E4\u0000\uA2CD\uA2DB\uA2DC\u0000\uA2DD\uA2DA\u0000" + //  9070 -  9079
                "\u0000\u9CD7\u0000\u0000\u0000\u0000\u0000\u0000\uF0B0\u0000" + //  9080 -  9089
                "\u0000\uF3D2\u0000\u0000\uEEF4\u0000\uE2D3\u0000\u0030\u0031" + //  9090 -  9099
                "\u0032\u0033\u0034\u0035\u0036\u0037\uBEEC\u0000\u0000\u0000" + //  9100 -  9109
                "\u0000\u0000\u0000\u0000\u9BC9\u0000\uEDC6\u0000\u0000\u0000" + //  9110 -  9119
                "\u0000\uE1B9\u0000\uE3C0\uBEEA\u0000\u0000\u0000\uBEEB\u0000" + //  9120 -  9129
                "\u0000\u0000\uCAC7\u0000\u0000\u0000\u0000\u0000\u9FA4\u0000" + //  9130 -  9139
                "\u0000\u0000\uE1A7\uEED3\uD0C3\u0000\u0000\u0000\uF2D9\u0000" + //  9140 -  9149
                "\u0000\u0000\u0000\uC7EC\uC7ED\u0000\u0000\uD5AD\u0000\u0000" + //  9150 -  9159
                "\u0000\u0000\u0000\u0000\uE3B8\u0000\u0000\u0000\uDDE9\u0000" + //  9160 -  9169
                "\u0000\u0000\uF1F3\u0000\uE7B1\u0000\u0000\u0000\u9AF9\uF5F0" + //  9170 -  9179
                "\u0000\uD8DC\u9FF8\uBEE7\u0000\u0000\u0000\uBEE8\u0000\uBEE9" + //  9180 -  9189
                "\uBEE1\u0000\u0000\u0000\uBEE2\u0000\u0000\uBEE3\uBEDA\uBEDB" + //  9190 -  9199
                "\u0000\uBEDC\uBEDD\uBEDE\u0000\u0000\uDDBF\u0000\u0000\u0000" + //  9200 -  9209
                "\uF6EF\u0000\uDEF9\uBED9\u0000\u0000\u0000\u0000\u0000\u0000" + //  9210 -  9219
                "\u0000\uF5AB\u0000\uDDCB\uD0D4\u0000\uE6B6\uE0AE\uFDDA\u0000" + //  9220 -  9229
                "\u0000\uF9D1\u0000\u0000\uE9D9\u0000\u0000\u0000\uD4AF\u0000" + //  9230 -  9239
                "\u0000\u0000\u0000\uDDC5\u0000\u0000\u0000\u0000\uC2C9\uC2CA" + //  9240 -  9249
                "\u0000\u0000\uDBB2\uFBC4\u0000\uF3E3\u0000\uD9A5\uFBE7\uBED6" + //  9250 -  9259
                "\uBED7\u0000\u0000\uBED8\u0000\u0000\u0000\uCAC6\u0000\u0000" + //  9260 -  9269
                "\uD5C2\u0000\u0000\uDAE0\u0000\u0000\u9DE9\u0000\u0000\u0000" + //  9270 -  9279
                "\uE9BD\u0000\uD7C9\u0000\u0000\uEBDB\uBED2\uBED3\u0000\u0000" + //  9280 -  9289
                "\u0000\uBED4\uBED5\u9FF7\uBEC8\uBEC9\uBECA\u0000\uBECB\uBECC" + //  9290 -  9299
                "\uBECD\u9FF6\uBEC2\uBEC3\u0000\uBEC4\u9FF4\uBEC5\u0000\u9FF5" + //  9300 -  9309
                "\uBEC1\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uE1A1\u0000" + //  9310 -  9319
                "\uF2A9\uF0C4\u0000\u0000\uE2E2\uE9EF\u0000\u0000\uDBB1\u0000" + //  9320 -  9329
                "\u0000\u0000\uD5E9\u0000\u0000\uDBB0\u0000\u0000\uE5DA\uE3BF" + //  9330 -  9339
                "\u0000\u0000\uE4D6\u0000\u0000\uD0C5\uF4AE\u0000\uDDA8\uBEBE" + //  9340 -  9349
                "\uBEBF\u0000\u0000\uBEC0\u0000\u0000\u0000\uD0CC\u0000\u0000" + //  9350 -  9359
                "\u0000\u0000\u0000\uB8C9\uB8CA\u0000\uB8CB\uBEBB\u0000\u0000" + //  9360 -  9369
                "\u0000\uBEBC\u0000\u0000\u0000\uE3A9\u0000\u0000\u0000\u0000" + //  9370 -  9379
                "\u0000\uB8B2\uB8B3\u0000\uB8B4\uBEB8\uBEB9\u0000\u0000\u0000" + //  9380 -  9389
                "\u0000\u0000\u0000\uE0FE\u0000\uDFFB\u0000\uD9E9\u0000\u0000" + //  9390 -  9399
                "\uD0FE\u0000\uECED\uD3A9\u0000\uA2BC\uA2BD\u0000\uA2C0\uA2BB" + //  9400 -  9409
                "\uA2BE\u0000\uA2BF\uBEB5\u0000\uBEB6\u0000\u0000\u0000\u0000" + //  9410 -  9419
                "\uBEB7\uBEB2\uBEB3\u0000\u0000\uBEB4\u0000\u0000\u0000\uD8CA" + //  9420 -  9429
                "\u0000\u0000\u0000\u0000\u0000\uB8AE\uB8AF\u0000\u0000\uECF1" + //  9430 -  9439
                "\u0000\u0000\u0000\u0000\u0000\u0000\uF3DE\u0000\u0000\u0000" + //  9440 -  9449
                "\uE9D7\uE4F1\u0000\u0000\u0000\uCAEF\uBEAF\u0000\u0000\u0000" + //  9450 -  9459
                "\uBEB0\u0000\u0000\u0000\uF7DB\u0000\u0000\u0000\u0000\u0000" + //  9460 -  9469
                "\uB8A7\uB8A8\u0000\uB8A9\uBEAC\u0000\u0000\u0000\u0000\u0000" + //  9470 -  9479
                "\u0000\u0000\uDDAE\u0000\uE3E6\u0000\u0000\u0000\u0000\u0000" + //  9480 -  9489
                "\u0000\uD3A8\uBEA7\u0000\u0000\u0000\uBEA8\u0000\u0000\u0000" + //  9490 -  9499
                "\uD3B2\u0000\u0000\u0000\uE2C0\uF2DF\uBEA4\u0000\u0000\u0000" + //  9500 -  9509
                "\u0000\u0000\u0000\u0000\uE9A4\u0000\uDDEC\uDAE8\u0000\u0000" + //  9510 -  9519
                "\u0000\u0000\u0000\uD4E0\uBDFE\u0000\u0000\u0000\uBEA1\u0000" + //  9520 -  9529
                "\u0000\u0000\uFAE5\uE2FA\u0000\u0000\u0000\uCAB6\uBDFB\u0000" + //  9530 -  9539
                "\u0000\u0000\u0000\u0000\u0000\u0000\uDFFD\u0000\uE2A6\u0000" + //  9540 -  9549
                "\u0000\u0000\u0000\u0000\uE0C0\u0000\uA1CF\u0000\uA1CE\u0000" + //  9550 -  9559
                "\u0000\u0000\u0000\u0000\uE4D4\u0000\u0000\u0000\uDBCB\uDAB5" + //  9560 -  9569
                "\u0000\u0000\u0000\uF5D3\u0000\u0000\uECDC\uF7B7\uBDFA\u0000" + //  9570 -  9579
                "\u0000\u0000\u0000\u0000\u0000\u0000\uEFF2\uE2B7\uBDF9\u0000" + //  9580 -  9589
                "\u0000\u0000\u9FEE\u0000\u0000\u0000\uF5F9\u0000\u0000\u0000" + //  9590 -  9599
                "\u0000\u9AE3\uBDF4\uBDF5\u0000\u0000\u0000\uBDF6\u0000\u0000" + //  9600 -  9609
                "\uFAC5\u0000\u0000\u0000\uF9B8\u0000\u0000\uF1E8\uD9F2\uDBF5" + //  9610 -  9619
                "\uCAB5\uD9C6\u0000\u0000\uD0D7\u0000\u0000\u0000\u0000\u0000" + //  9620 -  9629
                "\u0000\uB5D9\u0000\u0000\uD9C0\uD6EF\u0000\u0000\u0000\u0000" + //  9630 -  9639
                "\uD9CC\uBDF2\u0000\uBDF3\u0000\u0000\u0000\u0000\u0000\uBDFD" + //  9640 -  9649
                "\u0000\u0000\u0000\uD5A2\u0000\u0000\u0000\u0000\u0000\uB7F6" + //  9650 -  9659
                "\u0000\u0000\uB7F7\uBDEE\uBDEF\u0000\u0000\uBDF0\u0000\u0000" + //  9660 -  9669
                "\uBDF1\uBDED\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uD3D8" + //  9670 -  9679
                "\u0000\uFCF9\u0000\u0000\u0000\u0000\uDFF3\uCEE7\uDAC2\u9FEC" + //  9680 -  9689
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uD5DB\u0000\uEAF2" + //  9690 -  9699
                "\uCBC7\u0000\uCDF4\u0000\u0000\uDBAF\uEFD9\uBDEB\u0000\u0000" + //  9700 -  9709
                "\u0000\uBDEC\u0000\u0000\u0000\uFBAB\u0000\u0000\u0000\u0000" + //  9710 -  9719
                "\u0000\uB7F2\uB7F3\u0000\u0000\uD1C7\uE9AE\u0000\uE8BD\u0000" + //  9720 -  9729
                "\u0000\uFAC4\uBDE6\uBDE7\u0000\u9FE9\uBDE8\uBDE9\u0000\u0000" + //  9730 -  9739
                "\uD0CF\u0000\uCFFA\uF3CA\uE0D7\u0000\u0000\uE7C8\u0000\u0000" + //  9740 -  9749
                "\u0000\u0000\u0000\u0000\uA1C5\uA1F1\u0000\u0000\u9CC9\u0000" + //  9750 -  9759
                "\u0000\u0000\u0000\u0000\u0000\uD7A3\u0000\u0000\uFDF8\uFDF9" + //  9760 -  9769
                "\u0000\u0000\u0000\uF6BF\u0000\uE5C1\u0000\u0000\u0000\u0000" + //  9770 -  9779
                "\uE0EE\u0000\u0000\uD6F9\u0000\uCDD7\uDED8\u0000\u0000\uF2F8" + //  9780 -  9789
                "\uBDE4\u0000\uBDE5\u0000\u0000\u0000\u0000\u0000\uBDFC\u0000" + //  9790 -  9799
                "\u0000\u0000\uD5CC\u0000\u0000\u0000\u0000\u0000\uB7EF\u0000" + //  9800 -  9809
                "\u0000\u0000\uD9B3\u0000\u0000\uD8F4\u0000\uE9B7\uBDE1\uBDE2" + //  9810 -  9819
                "\u0000\u0000\uBDE3\u0000\u0000\u0000\uDAA5\u0000\uDBBD\u0000" + //  9820 -  9829
                "\u0000\u0000\uD0E7\u0000\u0000\uECFD\u0000\uD2AE\u9FE6\u0000" + //  9830 -  9839
                "\u0000\u0000\u0000\u0000\u0000\u0000\uD3AF\u0000\uDAE7\u0000" + //  9840 -  9849
                "\u0000\u0000\uF7CC\u0000\u0000\u0000\uF7F5\u0000\uCBE5\u0000" + //  9850 -  9859
                "\u0000\uCFAD\u0000\u0000\u9CD0\u0000\uE7F9\uF8A8\uBDDE\uBDDF" + //  9860 -  9869
                "\u0000\u0000\u0000\u0000\u0000\u0000\uF6DF\u0000\uF2DA\uE4EB" + //  9870 -  9879
                "\uBDDA\u0000\u0000\u0000\uBDDB\u0000\u0000\u0000\uE0D0\u0000" + //  9880 -  9889
                "\u0000\u0000\u0000\u0000\uB7E1\u0000\u0000\u0000\u9AE2\u0000" + //  9890 -  9899
                "\uD4DF\u0000\u0000\u0000\uF6DA\u0000\u0000\u0000\u0000\uC6FB" + //  9900 -  9909
                "\uC6FC\u0000\uC6FD\uBDD3\uBDD4\u0000\u9FE4\uBDD5\uBDD6\u0000" + //  9910 -  9919
                "\u0000\uFAC3\uE5D7\u0000\uECC8\u0000\u0000\u0000\uE1E5\uEEF9" + //  9920 -  9929
                "\u0000\u0000\u0000\uE7F6\uBDD2\u0000\u9FE3\u0000\u0000\u0000" + //  9930 -  9939
                "\u0000\u0000\uBDF7\uBDF8\u0000\u0000\uE1E2\uD1C6\u0000\u0000" + //  9940 -  9949
                "\u0000\u0000\u0000\uBBD5\u9FCD\u0000\uBBD6\uBDCE\uBDCF\u0000" + //  9950 -  9959
                "\uBDD0\uBDD1\u0000\u0000\u0000\uE8B3\u9BEE\u0000\u0000\u0000" + //  9960 -  9969
                "\u0000\uF3D1\u0000\u0000\u0000\u0000\uC1CE\uC1CF\u0000\uC1D0" + //  9970 -  9979
                "\uBDC5\u0000\u0000\uBDC6\uBDC7\u0000\u9FE2\u0000\uDBFB\u0000" + //  9980 -  9989
                "\uCBE0\u0000\u0000\u0000\u0000\u0000\uB2BF\uB2C0\u0000\u0000" + //  9990 -  9999
                "\u9AAD\uF4AD\u0000\uFCAA\u0000\u0000\u0000\uDBA2\uF2F6\u0000" + // 10000 - 10009
                "\u0000\uCABA\u9FE1\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 10010 - 10019
                "\uF9B6\u0000\uF3BC\u0000\uDAD2\u0000\u0000\u0000\u0000\u0000" + // 10020 - 10029
                "\u9EC3\u0000\u0000\uB2BB\uBDBC\u0000\u0000\u0000\uBDBD\uBDBE" + // 10030 - 10039
                "\u0000\u0000\uF7C7\u0000\u0000\u0000\u0000\u9ACC\u0000\uD6CE" + // 10040 - 10049
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uCED7\uBDB7\u0000" + // 10050 - 10059
                "\u0000\uBDB8\u0000\uBDB9\u0000\u0000\u9EAC\u0000\u9CF3\u0000" + // 10060 - 10069
                "\u0000\u0000\u0000\uE3FD\u0000\uF9B1\u0000\u0000\uFCA3\u0000" + // 10070 - 10079
                "\uDBBB\u0000\u0000\u0000\uF2BA\uBDB6\u0000\u0000\u0000\u0000" + // 10080 - 10089
                "\u0000\u0000\u0000\uCCE6\u0000\uD9B8\uD9B9\uEFC9\u0000\u0000" + // 10090 - 10099
                "\u0000\u0000\u0000\uB2B8\u0000\u0000\u0000\uFAD3\u0000\u9CF9" + // 10100 - 10109
                "\u0000\u0000\uD3E4\uF6F7\u0000\u0000\uD5BA\uF3CD\uCBE1\uBDB4" + // 10110 - 10119
                "\uBDB5\u0000\u0000\u9FDF\u0000\u0000\u0000\uE7DE\u0000\u0000" + // 10120 - 10129
                "\u0000\uD6D6\uE1CC\uBDAE\u0000\u0000\u0000\uBDAF\u0000\u0000" + // 10130 - 10139
                "\u0000\uF0B1\u0000\u0000\u0000\u0000\u0000\uB7D2\uB7D3\u0000" + // 10140 - 10149
                "\uB7D4\uBDAA\u0000\u0000\u0000\u0000\uBDAB\u0000\u0000\uFAD4" + // 10150 - 10159
                "\u0000\u0000\u0000\uECE5\u0000\u0000\uCADE\uDFE4\u0000\u0000" + // 10160 - 10169
                "\u0000\uE6FD\u0000\uF5C4\u0000\u0000\u0000\u0000\u0000\u0000" + // 10170 - 10179
                "\u9DD7\uBDA9\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uF0FA" + // 10180 - 10189
                "\u0000\uEED7\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uE4E8" + // 10190 - 10199
                "\uBDA6\uBDA7\u0000\u0000\uBDA8\u0000\u0000\u0000\uE2BE\u0000" + // 10200 - 10209
                "\u0000\u0000\u0000\u0000\uB7CE\uB7CF\u0000\u0000\uDABC\uD8FC" + // 10210 - 10219
                "\u0000\u0000\u0000\u0000\u0000\uBBD1\uBBD2\u0000\u0000\uE0CF" + // 10220 - 10229
                "\u0000\u0000\u0000\u0000\u0000\u0000\uC8BC\u0000\uC8BD\uBDA5" + // 10230 - 10239
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uE5DD\uFDFB\uBCFB" + // 10240 - 10249
                "\uBCFC\u0000\uBCFD\u0000\uBCFE\u0000\uBDA1\uBCFA\u0000\u0000" + // 10250 - 10259
                "\u0000\u0000\u0000\u0000\u0000\uE6A6\u0000\uF0AB\u0000\u0000" + // 10260 - 10269
                "\u0000\u0000\u0000\uEBE7\u0000\uA2C4\uA2C5\u0000\u0000\u0000" + // 10270 - 10279
                "\u0000\u0000\u0000\uDCAD\u0000\u0000\uEEF3\uE7F1\u0000\uFDB4" + // 10280 - 10289
                "\u0000\u0000\u0000\u9DB7\u0000\u0000\uCEED\u0000\u0028\u0029" + // 10290 - 10299
                "\u002A\u002B\u002C\u002D\u002E\u002F\uBCF6\uBCF7\u0000\u0000" + // 10300 - 10309
                "\uBCF8\u0000\u0000\uBCF9\uBCF0\u0000\u0000\u0000\uBCF1\u0000" + // 10310 - 10319
                "\u0000\u0000\uD5D1\u0000\uD8F0\uF8C3\uEAD7\u0000\uCAD1\u0000" + // 10320 - 10329
                "\u0000\u0000\uEAF1\u0000\uD0A6\u0000\uA2C2\uA2C1\u0000\uA1DB" + // 10330 - 10339
                "\u0000\u0000\uA1DD\uA1DC\uBCEB\uBCEC\u0000\uBCED\u0000\u0000" + // 10340 - 10349
                "\u0000\u0000\uFCF4\u0000\u0000\u0000\u0000\uC5A9\uC5AA\u0000" + // 10350 - 10359
                "\u0000\uDCA4\u0000\u0000\u0000\uF0B8\u0000\u0000\uCBB8\u0000" + // 10360 - 10369
                "\u0000\u0000\u0000\u0000\u0000\uC7E2\u0000\u0000\uF5A7\u0000" + // 10370 - 10379
                "\u0000\u0000\u0000\u0000\u0000\uE0A8\uD5F3\u0000\uF5CF\uE5F3" + // 10380 - 10389
                "\uF0C2\u0000\u9ACD\u0000\u0000\u0000\uEBB0\uF4E3\u0000\u0000" + // 10390 - 10399
                "\u0000\uCFC4\u0000\u0000\u0000\u0000\uFAA7\u0000\u0000\u0000" + // 10400 - 10409
                "\u0000\uC2B9\u0000\u0000\u0000\uDDB8\uCFC5\uDFDF\u0000\u0000" + // 10410 - 10419
                "\uE8B6\u0000\u0000\uD6CF\uF4BA\u0000\uF7C9\uBCEA\u0000\u0000" + // 10420 - 10429
                "\u0000\u0000\u0000\u0000\u0000\uF5A8\u0000\uD5D3\uF3F5\uF7AE" + // 10430 - 10439
                "\u0000\u0000\uEFC8\u0000\uCDF3\uBCE8\u0000\u0000\u0000\uBCE9" + // 10440 - 10449
                "\u0000\u0000\u0000\uFAF8\u0000\u0000\u0000\u0000\u0000\uB7B3" + // 10450 - 10459
                "\uB7B4\u0000\uB7B5\uBCE7\u0000\u0000\u0000\u0000\u0000\u0000" + // 10460 - 10469
                "\u0000\uD8BE\u0000\uCFDE\u0000\u0000\uCED0\u0000\u0000\u0000" + // 10470 - 10479
                "\u0000\uC3F2\u0000\u0000\u0000\uF4EB\u0000\uEEB5\u0000\uF5D8" + // 10480 - 10489
                "\uBCE3\u0000\u0000\u0000\uBCE4\u0000\u0000\u0000\u9BBC\u9BDC" + // 10490 - 10499
                "\u0000\uCDC9\uF9B7\u0000\uE2A3\uD3FC\u0000\u0000\uEDE6\u0000" + // 10500 - 10509
                "\u0000\u0000\uE0A5\u0000\uF7AB\u0000\u0000\uF7CB\uDFAE\uE8F5" + // 10510 - 10519
                "\u0000\u0000\u0000\u0000\uA0D0\u0000\u0000\u0000\uF6AC\u0000" + // 10520 - 10529
                "\u0000\u0000\u0000\u9AEF\u0000\u0000\u0000\u0000\uC2C0\uC2C1" + // 10530 - 10539
                "\u0000\uC2C2\uBCE0\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 10540 - 10549
                "\uD9CD\u0000\uDED7\u0000\u0000\u0000\u0000\u0000\uCBDF\u0000" + // 10550 - 10559
                "\uA2B8\uA2B7\u0000\u0000\u0000\u0000\uA1DF\uA1DE\uBCDD\uBCDE" + // 10560 - 10569
                "\u0000\u0000\uBCDF\u0000\u0000\u0000\uD8D3\u0000\u0000\u0000" + // 10570 - 10579
                "\u0000\u0000\uB7AA\uB7AB\u0000\u0000\uE7CE\u0000\u0000\uDFDC" + // 10580 - 10589
                "\u0000\uF9C7\u0000\uE6C8\u0000\u0000\u0000\u0000\uF8DA\u0000" + // 10590 - 10599
                "\u0000\uE4C4\u0000\u0000\u0000\u0000\u0000\u0000\uF3FB\u0000" + // 10600 - 10609
                "\u0000\uD8A4\u0000\u0000\u0000\u0000\u0000\uF2A7\uBCD5\u0000" + // 10610 - 10619
                "\u0000\u9FDD\uBCD6\u0000\uBCD7\u0000\u9CAC\uE4CE\u0000\u0000" + // 10620 - 10629
                "\u0000\u0000\u0000\u0000\uEFF7\u0000\u0000\uF3B5\u0000\u0000" + // 10630 - 10639
                "\uF8A4\u0000\u0000\uD1F3\uBCD0\u0000\u0000\u0000\u0000\u0000" + // 10640 - 10649
                "\u0000\u0000\uF9AB\u0000\uCFAC\uF0F0\u0000\uF4FD\uDBC8\u0000" + // 10650 - 10659
                "\u0000\u0000\uEECC\u0000\u0000\uDEF2\u0000\uA2C9\uA2CC\u0000" + // 10660 - 10669
                "\u0000\u0000\u0000\u0000\u0000\uFAE0\u0000\u0000\uE1B1\u0000" + // 10670 - 10679
                "\u0000\uF7B2\u0000\u0000\uD3F3\uBCCE\u0000\u0000\u0000\uBCCF" + // 10680 - 10689
                "\u0000\u0000\u0000\uF9FE\uDBBA\uDAF5\u0000\u0000\u0000\uD7D6" + // 10690 - 10699
                "\u9BBE\u0000\uDCC1\u0000\uDEC6\uBCCC\uBCCD\u0000\u0000\u0000" + // 10700 - 10709
                "\u0000\u0000\u0000\u9DCC\u0000\u0000\u0000\uE0A2\u0000\u0000" + // 10710 - 10719
                "\u0000\u9DEE\u0000\uCED8\u0000\uCBDE\uF4AC\uDAFB\u0000\uF6E9" + // 10720 - 10729
                "\uE8F3\uBCC7\u0000\u0000\u0000\uBCC8\u0000\u0000\u0000\u9CE2" + // 10730 - 10739
                "\u0000\u0000\uCFC0\u0000\uE6A8\uBCC0\uBCC1\u0000\uBCC2\uBCC3" + // 10740 - 10749
                "\uBCC4\u0000\u0000\uDADF\u0000\uEFB3\u0000\u0000\u0000\u0000" + // 10750 - 10759
                "\uEDE3\u0000\u0000\uD3E1\u9CEA\uBCBF\u0000\u0000\u0000\u0000" + // 10760 - 10769
                "\u0000\u0000\u0000\uCEEB\u0000\uD2B9\uD5C3\u0000\u0000\uDAE5" + // 10770 - 10779
                "\uDAD0\u0000\uD1D9\uBCBC\uBCBD\u0000\u0000\uBCBE\u0000\u0000" + // 10780 - 10789
                "\u9FDA\uBCB9\uBCBA\u0000\u0000\u0000\u0000\uBCBB\u0000\uEFB9" + // 10790 - 10799
                "\u0000\u0000\uF8D8\u0000\u0000\u0000\u0000\uC3DF\uC3E0\u0000" + // 10800 - 10809
                "\u0000\u9CF1\uEFD8\uE6C9\u0000\uD8B8\uFAF3\u0000\uA1E1\uA1E0" + // 10810 - 10819
                "\u0000\uA2C3\uA2C7\uA2C8\uA2CB\uA2CA\uBCB1\u0000\u0000\uBCB2" + // 10820 - 10829
                "\uBCB3\u9FD9\uBCB4\uBCB5\uBCAB\u0000\u0000\u0000\u0000\uBCAC" + // 10830 - 10839
                "\u0000\u0000\uE4AA\u0000\uF5E1\uEDDA\u0000\u9AB9\u0000\uD0FC" + // 10840 - 10849
                "\u0000\u0000\u0000\uF4FC\u0000\u0000\u0000\uCCC1\u0000\uD2ED" + // 10850 - 10859
                "\u0000\u0000\uD3FB\u0000\u0000\u0000\u0000\u0000\u0000\uFDA3" + // 10860 - 10869
                "\u0000\uFBE5\uBCAA\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 10870 - 10879
                "\uCBB2\uF1C2\uBCA8\u0000\u0000\u0000\uBCA9\u0000\u0000\u0000" + // 10880 - 10889
                "\uD3E6\uF2DD\uCFBF\u0000\uEBAC\u0000\uF6F5\u0000\u0000\u0000" + // 10890 - 10899
                "\u0000\u0000\u0000\u0000\uF6BA\uBCA2\u0000\u0000\u0000\uBCA3" + // 10900 - 10909
                "\u0000\u0000\u0000\uEBEC\u0000\u0000\uD3C5\uFCEC\uD2DB\uBBF9" + // 10910 - 10919
                "\uBBFA\u0000\uBBFB\uBBFC\uBBFD\u0000\u0000\uEBDF\u0000\u0000" + // 10920 - 10929
                "\u0000\u0000\u0000\uD6CB\uBBF8\u0000\u0000\u0000\u0000\u0000" + // 10930 - 10939
                "\u0000\u0000\uE8B7\u0000\uFBC3\uDDEA\u0000\uE2A2\u0000\uEEA6" + // 10940 - 10949
                "\u0000\u0000\uF2A5\u0000\u0000\u0000\u0000\u0000\uF2A6\uBBF5" + // 10950 - 10959
                "\uBBF6\u0000\u0000\uBBF7\u0000\u0000\u9FD8\uBBF2\uBBF3\u0000" + // 10960 - 10969
                "\u9FD6\u0000\uBBF4\u0000\u9FD7\uBBEA\u0000\u0000\uBBEB\uBBEC" + // 10970 - 10979
                "\uBBED\uBBEE\u9FD4\uBBE3\uBBE4\u0000\uBBE5\u0000\uBBE6\u0000" + // 10980 - 10989
                "\u0000\uF4C6\u0000\u0000\u0000\u0000\u0000\u0000\uD0F3\uE0AA" + // 10990 - 10999
                "\uE8E2\u0000\uE1B6\uF8B7\u0000\u9AB4\u0000\u0000\u0000\uE0BF" + // 11000 - 11009
                "\uBBE2\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uF2EF\u0000" + // 11010 - 11019
                "\uEEFA\uFDF4\u0000\u0000\uD3E3\u0000\uFBC2\u0000\uA6E2\uA6E3" + // 11020 - 11029
                "\uA6E4\uA6B6\u0000\u0000\u0000\u0000\uBFF6\uBFF7\u0000\u0000" + // 11030 - 11039
                "\uDCC2\u0000\u0000\uF0A7\u0000\u0000\uE6C0\uBBDF\uBBE0\u0000" + // 11040 - 11049
                "\u0000\uBBE1\u0000\u0000\u0000\uDDB1\u0000\uD8AF\uE3A3\u0000" + // 11050 - 11059
                "\u0000\uF4C5\uDCA3\u0000\u0000\u9AE0\u0000\u0000\uCECD\u0000" + // 11060 - 11069
                "\u0000\uD4DC\u0000\u0000\u0000\uCCF5\uF5B5\uE4AD\u0000\u0000" + // 11070 - 11079
                "\u0000\uFBFD\u0000\u0000\u0000\u9AEB\uBBDD\uBBDE\u0000\u0000" + // 11080 - 11089
                "\u0000\u0000\u0000\u0000\uE4DF\u0000\uCAD6\u0000\uE0F7\uE4B2" + // 11090 - 11099
                "\uCCFC\u0000\u0000\u0000\uFBE4\u0000\uA6DB\uA6DC\uA6C0\uA6DD" + // 11100 - 11109
                "\uA6DE\uA6DF\uA6E0\uA6E1\uBBDC\u0000\u0000\u0000\u0000\u0000" + // 11110 - 11119
                "\u0000\u0000\uD0C8\u0000\uCDFC\u0000\uD9E6\u0000\uE2F9\uE2A1" + // 11120 - 11129
                "\uEBD4\u0000\uA6BF\uA6D7\uA6D8\uA6B5\uA6AB\uA6D9\uA6DA\uA6BB" + // 11130 - 11139
                "\uBBDA\u9FD1\u0000\u0000\uBBDB\u0000\u0000\u0000\uF2B7\u0000" + // 11140 - 11149
                "\u0000\uFAF6\uF6AA\uFAF7\u9FD0\u0000\u0000\u0000\u0000\u0000" + // 11150 - 11159
                "\u0000\u0000\uCECB\u0000\uD5FC\u0000\u0000\u0000\u0000\u0000" + // 11160 - 11169
                "\u0000\uD3D4\u9FCE\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 11170 - 11179
                "\uFCC2\uEABB\uBBD3\u0000\u0000\u0000\uBBD4\u9FCC\u0000\u0000" + // 11180 - 11189
                "\uF9D8\uF9D9\uCAE0\uDACA\u0000\u0000\u0000\uDFC9\u0000\u0000" + // 11190 - 11199
                "\u0000\u0000\uDFED\u9FCB\u0000\u0000\u0000\u0000\uBBD0\u0000" + // 11200 - 11209
                "\u0000\uF8CD\u0000\uCBD2\u0000\u0000\u0000\uEBCE\uBBCF\u0000" + // 11210 - 11219
                "\u0000\u0000\u0000\u0000\u0000\u0000\uF3E9\u0000\uFAD8\u0000" + // 11220 - 11229
                "\uF3D5\u0000\uCFAB\u9EA3\u0000\uEBF3\u9FCA\u0000\u0000\u0000" + // 11230 - 11239
                "\u0000\u0000\u0000\u0000\uE4E4\u0000\uFAAB\uEBEB\uE7F8\uD9E5" + // 11240 - 11249
                "\u0000\u0000\u0000\u0000\uC3D6\u0000\u0000\u0000\uFAB0\u0000" + // 11250 - 11259
                "\u0000\u0000\u0000\uF8D5\uE5D8\u0000\u0000\u0000\uFDBA\u0000" + // 11260 - 11269
                "\u0000\uFDE1\uF6FE\uBBCB\uBBCC\u0000\u0000\u0000\uBBCD\u0000" + // 11270 - 11279
                "\u0000\uCAFC\uCAFD\u0000\u0000\u0000\u0000\u0000\uBAF6\uBAF7" + // 11280 - 11289
                "\u0000\uBAF8\uBBCA\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 11290 - 11299
                "\u9AED\u0000\uFDF3\uFDF2\uF7A6\u0000\u0000\u0000\u0000\u0000" + // 11300 - 11309
                "\uB2A7\u0000\u0000\u0000\uD8F2\u0000\u0000\uE3CA\u0000\uA6BD" + // 11310 - 11319
                "\uA6D3\uA6D4\uA6B3\uA6AA\uA6D5\uA6D6\uA6BA\uBBC7\uBBC8\u0000" + // 11320 - 11329
                "\u0000\uBBC9\u0000\u0000\u0000\uD6FD\u0000\u0000\u0000\u0000" + // 11330 - 11339
                "\u0000\uB6E7\u0000\u0000\u0000\uECD1\u0000\u0000\u0000\u0000" + // 11340 - 11349
                "\u0000\uECC7\u0000\u0000\u0000\uD8BD\u0000\u0000\u0000\u0000" + // 11350 - 11359
                "\uC6BA\uC6BB\u0000\uA0E3\uBBC2\uBBC3\u0000\uBBC4\uBBC5\uBBC6" + // 11360 - 11369
                "\u0000\u0000\uCCF0\u0000\u0000\uD7AF\u0000\u0000\u0000\uE3BC" + // 11370 - 11379
                "\uF8D6\u0000\u0000\uDBEE\u0000\uD5FB\uDEBB\u0000\u0000\uF4FB" + // 11380 - 11389
                "\u0000\u0000\u0000\uCCB8\u0000\u0000\u0000\uD0AE\uBBC0\uBBC1" + // 11390 - 11399
                "\u0000\u0000\u0000\u0000\u0000\u0000\uE7C2\u0000\u0000\u0000" + // 11400 - 11409
                "\uE3A7\u0000\uDFD6\uFDE8\u0000\u0000\uEEEB\u0000\u0000\u0000" + // 11410 - 11419
                "\u0000\u0000\u0000\uF6F3\u0000\u0000\u0000\uD8B5\u9DA8\u0000" + // 11420 - 11429
                "\u0000\uE4DC\u0000\uEAD0\u0000\u0000\u0000\u0000\u0000\uCCD4" + // 11430 - 11439
                "\uCBAF\u9FC5\u0000\u0000\u0000\u9FC6\u0000\u0000\u0000\uECCD" + // 11440 - 11449
                "\u0000\uECCE\u0000\uD6BF\u0000\uCBC6\u0000\u0000\uF0F6\u0000" + // 11450 - 11459
                "\u0000\uD5E7\u0000\uA6B9\uA6CF\uA6D0\uA6B4\uA6A8\uA6D1\uA6D2" + // 11460 - 11469
                "\uA6B8\uBBBA\u0000\u0000\uBBBB\uBBBC\uBBBD\u0000\u0000\uE2C8" + // 11470 - 11479
                "\u0000\u0000\u0000\u0000\u0000\u0000\uEDC4\u0000\u0000\u0000" + // 11480 - 11489
                "\uCBD4\uE0BE\uE3F8\uEAE9\uFCB2\u0000\uF3D3\uF3D4\u9DC2\u0000" + // 11490 - 11499
                "\u0000\uF7E4\u0000\uF7D1\uBBB9\u0000\u0000\u0000\u0000\u0000" + // 11500 - 11509
                "\u0000\u0000\uD5B3\u0000\uEDB1\u0000\uCCC3\uF7BE\uFCCB\u0000" + // 11510 - 11519
                "\u0000\u0000\uF9AC\u0000\u0000\u0000\u0000\u9CB9\uF0A6\u0000" + // 11520 - 11529
                "\u0000\u0000\uDFD7\uDBD0\uDBD1\u0000\u0000\uF8D9\u0000\u0000" + // 11530 - 11539
                "\u0000\uEEBD\u0000\u0000\uD8C6\u0000\u0000\uE4E3\uF5CE\u0000" + // 11540 - 11549
                "\u0000\uCDF2\u0000\uCFEB\u0000\u0000\u0000\uCDB8\uBBB5\uBBB6" + // 11550 - 11559
                "\u0000\u0000\uBBB7\u0000\u0000\uBBB8\uBBB4\u0000\u0000\u0000" + // 11560 - 11569
                "\u0000\u0000\u0000\u0000\uFCE8\uF3BD\uBBB2\uBBB3\u0000\u0000" + // 11570 - 11579
                "\u9FC2\u0000\u0000\u0000\uFDFD\u0000\u0000\u0000\u0000\u0000" + // 11580 - 11589
                "\u9EF9\u0000\u0000\u0000\uA1E3\uA1E2\u0000\u0000\uA2BA\uA2B9" + // 11590 - 11599
                "\uBBB0\uBBB1\u0000\u0000\u0000\u0000\u0000\u0000\uFADC\u0000" + // 11600 - 11609
                "\uEDB5\uE1E3\uBBAB\u0000\u0000\u0000\uBBAC\u0000\u0000\u0000" + // 11610 - 11619
                "\uF1AA\uCED1\u0000\u0000\uF6C7\u0000\uFCCA\u0000\u0000\u0000" + // 11620 - 11629
                "\uF3E1\u0000\u0000\uCBC4\uBBA3\uBBA4\u0000\uBBA5\uBBA6\uBBA7" + // 11630 - 11639
                "\u0000\u0000\uE0D5\u0000\uEFB0\u0000\u0000\uE2C7\u0000\uEAEF" + // 11640 - 11649
                "\uEAF0\u0000\u0000\u0000\uDAC0\uF8B4\uEBF2\uBBA1\u0000\uBBA2" + // 11650 - 11659
                "\u0000\u0000\u0000\u0000\u0000\u9FED\u0000\u0000\u0000\uF3C3" + // 11660 - 11669
                "\u0000\u0000\u0000\u0000\u0000\uB6D1\uB6D2\u0000\u0000\uFAE8" + // 11670 - 11679
                "\u0000\u9DEF\u0000\u0000\u0000\u0000\uCCF9\uCDB5\u9ADC\u0000" + // 11680 - 11689
                "\u0000\uCFBE\u0000\u0000\uECBB\u0000\u0000\u0000\uD5AF\u0000" + // 11690 - 11699
                "\u0000\u0000\uD6F5\u0000\uF6E7\uD2DD\u0000\uDFCC\u0000\u0000" + // 11700 - 11709
                "\uFCC9\u0000\uA6B7\uA6CB\uA6CC\uA6B2\uA6A9\uA6BE\uA6CD\uA6CE" + // 11710 - 11719
                "\uBAFC\uBAFD\u0000\u0000\uBAFE\u0000\u0000\u0000\uF1F9\u0000" + // 11720 - 11729
                "\uF2C4\uE0CB\u0000\u0000\uEBB8\u0000\uE0B7\uD7EC\uF1EC\uE5AF" + // 11730 - 11739
                "\uD5E1\uBAF3\u0000\u0000\u9FC1\uBAF4\u0000\uBAF5\u0000\uFBB3" + // 11740 - 11749
                "\uE4C2\u0000\u0000\u0000\u0000\u0000\u0000\uE9E8\u0000\u0000" + // 11750 - 11759
                "\uE5E4\uDFF1\u0000\u0000\uF7E1\u0000\uF9F7\u9FC0\u0000\u0000" + // 11760 - 11769
                "\u0000\u0000\u0000\u0000\u0000\uFBC9\u0000\uCCFB\u0000\u0000" + // 11770 - 11779
                "\u0000\uD3FA\uF4A4\u0000\u0000\uCCBC\uF7EA\u0000\u0000\u0000" + // 11780 - 11789
                "\u0000\u0000\uB2A8\uB2A9\uB2AA\u0000\uA6A5\uA6C4\uA6C3\uA6B0" + // 11790 - 11799
                "\uA6A7\uA6BC\uA6C9\uA6CA\u9FBE\u0000\u0000\u0000\uBAEE\uBAEF" + // 11800 - 11809
                "\u0000\uBAF0\uBAEC\u0000\u0000\u0000\uBAED\u0000\u0000\u0000" + // 11810 - 11819
                "\uD1CC\uDDFC\u0000\u0000\u0000\u0000\uCAE1\u0000\uD4CC\u0000" + // 11820 - 11829
                "\u0000\uF6AD\u0000\uF5B3\u0000\uF0B5\u0000\u0000\uD7E7\u0000" + // 11830 - 11839
                "\u0000\u0000\u0000\u0000\u0000\uC7A2\u0000\u0000\uF6C2\u0000" + // 11840 - 11849
                "\u0000\uEFBB\u0000\u0000\u0000\u9FDE\u0000\uBCE1\u0000\u0000" + // 11850 - 11859
                "\uE5EA\u0000\u0000\uF1E0\u0000\u0000\u0000\u9DB8\u0000\u0000" + // 11860 - 11869
                "\u0000\u0000\uD0C4\u0000\u0000\u0000\uCAD0\uBAE7\u0000\u0000" + // 11870 - 11879
                "\uBAE8\u0000\uBAE9\u0000\u0000\uD9AE\uD5AC\u0000\uE2C6\u0000" + // 11880 - 11889
                "\u0000\u0000\uDDE6\u0000\u0000\u0000\uDCFE\u0000\uF0F5\u0000" + // 11890 - 11899
                "\uDDE8\uD3ED\uF5FC\u9DC4\uDABF\u0000\uA6A4\uA6C2\uA6C1\uA6AF" + // 11900 - 11909
                "\uA6A6\uA6C6\uA6C5\uA6B1\uBAE6\u0000\u0000\u0000\u0000\u0000" + // 11910 - 11919
                "\u0000\u0000\uDBF1\u0000\uEAED\u0000\u0000\uFCB4\uF5C2\u0000" + // 11920 - 11929
                "\u0000\uD7DC\uBAE4\u0000\u0000\u0000\uBAE5\u0000\u0000\u0000" + // 11930 - 11939
                "\uF0FB\uFAE1\uF0DA\uCCE7\uDAF4\u0000\uFDE6\u0000\u0000\u0000" + // 11940 - 11949
                "\u0000\u0000\u0000\u0000\uE2FE\uBAE1\u0000\u0000\u0000\uBAE2" + // 11950 - 11959
                "\u0000\u0000\u0000\uFBD5\u0000\u0000\u0000\u0000\u0000\uB6C6" + // 11960 - 11969
                "\u0000\u0000\u0000\u9AA9\uA1CA\u0000\u0000\u0000\u0000\uBFD9" + // 11970 - 11979
                "\u0000\u0000\uBFDA\uBADE\u0000\u0000\u0000\u0000\u0000\u0000" + // 11980 - 11989
                "\u0000\uD6B1\uDEB2\uBADD\u0000\u0000\u0000\u9FBD\u0000\u0000" + // 11990 - 11999
                "\u0000\u9CF6\u0000\u0000\uF1D4\u0000\uEDF2\uBAD5\uBAD6\u0000" + // 12000 - 12009
                "\uBAD7\u0000\uBAD8\u0000\u9FBC\uBAD2\uBAD3\uBAD4\u0000\u0000" + // 12010 - 12019
                "\u0000\u0000\u0000\uBDEA\u9FEA\u0000\u0000\uEBB7\uEFF8\uF5DC" + // 12020 - 12029
                "\uEDCC\uDBD5\uF1CF\u0000\uF9CF\uEBDA\uCAC1\u0000\uD2B8\uCDF1" + // 12030 - 12039
                "\u0000\uE3D3\uBACE\uBACF\u0000\u0000\uBAD0\u0000\u0000\uBAD1" + // 12040 - 12049
                "\uBACD\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uE3D6\u0000" + // 12050 - 12059
                "\uCDF0\u0000\uF9F6\u0000\u0000\uDFF0\u0000\u0000\uDDEB\u0000" + // 12060 - 12069
                "\u0000\uE4F9\u0000\u0000\uE3AF\uBACA\uBACB\u0000\u0000\u0000" + // 12070 - 12079
                "\u0000\u0000\u0000\uCCB3\u0000\u0000\uDBF3\uBAC9\u0000\u0000" + // 12080 - 12089
                "\u0000\u0000\u0000\u0000\u0000\uFACB\u0000\uEAB3\u0000\uCED6" + // 12090 - 12099
                "\u0000\u0000\u0000\u0000\uCCA5\uBAC6\uBAC7\u0000\u0000\uBAC8" + // 12100 - 12109
                "\u0000\u0000\u0000\uEDD8\uE1C7\u0000\u0000\u0000\u0000\uC8F4" + // 12110 - 12119
                "\uC8F5\u0000\u0000\uDEA9\u0000\u0000\u0000\u0000\u0000\u0000" + // 12120 - 12129
                "\uE5F1\u0000\u0000\u0000\uFBE6\u0000\u0000\u0000\u0000\u0000" + // 12130 - 12139
                "\uB1A1\uB1A2\u0000\uB1A3\uBAC5\u0000\u0000\u0000\u0000\u0000" + // 12140 - 12149
                "\u0000\u0000\uE7B4\u0000\uF7BD\uECAE\u0000\u0000\u0000\uD0E1" + // 12150 - 12159
                "\u0000\uE0F5\uBAC1\u0000\u0000\u0000\uBAC2\u0000\u0000\u0000" + // 12160 - 12169
                "\uF3C2\u0000\u0000\u0000\u0000\u0000\uB6C0\uB6C1\u0000\uB6C2" + // 12170 - 12179
                "\uBABB\u0000\u0000\u0000\uBABC\u0000\u0000\u0000\uF3B0\u0000" + // 12180 - 12189
                "\u9ABF\uCCC4\u0000\u0000\uE9F4\u0000\u0000\u0000\u0000\u0000" + // 12190 - 12199
                "\u0000\uDDC4\u0000\u0000\u0000\uECF4\u0000\u0000\u0000\u0000" + // 12200 - 12209
                "\u0000\uB0D7\uB0D8\u0000\uB0D9\uBAB6\u0000\u0000\u0000\uBAB7" + // 12210 - 12219
                "\u0000\u0000\u0000\u9DDA\u0000\uDAD8\uD1B9\u0000\uDFA9\uBAB3" + // 12220 - 12229
                "\uBAB4\u9FB8\u9FB9\u9FBA\uBAB5\u0000\u0000\uD8D7\u0000\u0000" + // 12230 - 12239
                "\u0000\u0000\u0000\u0000\uCFA5\u0000\u0000\uDFC4\uBAAF\u0000" + // 12240 - 12249
                "\u0000\u0000\uBAB0\u0000\u0000\u0000\uE2B5\u0000\u0000\uCAE6" + // 12250 - 12259
                "\u0000\uD3AE\uBAA8\uBAA9\u0000\uBAAA\uBAAB\uBAAC\u0000\u0000" + // 12260 - 12269
                "\uE9AB\u0000\u0000\uE1E1\uD3CF\uF4F6\u0000\uF5F7\u0000\u0000" + // 12270 - 12279
                "\u0000\u0000\u0000\u0000\u0000\uE2FD\uBAA7\u0000\u0000\u0000" + // 12280 - 12289
                "\u0000\u0000\u0000\u0000\uF7D2\u0000\uD8CE\uD8CF\u0000\u0000" + // 12290 - 12299
                "\u0000\u0000\u0000\u0000\u9DF3\u0000\u0000\uCAF1\u0000\u0000" + // 12300 - 12309
                "\u0000\u0000\u0000\u0000\uD4B4\u0000\u0000\uD0E2\u0000\u0000" + // 12310 - 12319
                "\u0000\u0000\uDDA6\u0000\uA6A1\uA6AC\uA6A2\uA6AD\u0000\u0000" + // 12320 - 12329
                "\u0000\u0000\uBFE8\uBFE9\u0000\uBFEA\uBAA3\uBAA4\u0000\u0000" + // 12330 - 12339
                "\uBAA5\u0000\u0000\uBAA6\u9FB4\uBAA1\uBAA2\u0000\u9FB5\u0000" + // 12340 - 12349
                "\u0000\u0000\uD0AA\u0000\u0000\u0000\u0000\u9BAB\uB9F8\u0000" + // 12350 - 12359
                "\u0000\uB9F9\uB9FA\u0000\uB9FB\u0000\uFCC7\uDCD6\uE2E0\u0000" + // 12360 - 12369
                "\u0000\u0000\uDAB0\u0000\uA8E5\uA8E6\u0000\u0000\u0000\u0000" + // 12370 - 12379
                "\u0000\u0000\uE5CB\u0000\u0000\uDBC6\uD0F1\u0000\uD0F2\u0000" + // 12380 - 12389
                "\u0000\u0000\uCDA7\u0000\u0000\uD0AC\u0000\u0020\u0021\"" + // 12390 - 12399
                "\u0023\u0024\u0025\u0026\u0027\u9FB3\u0000\u0000\u0000\u0000" + // 12400 - 12409
                "\u0000\u0000\u0000\uCAD2\u0000\uD5D0\uE5D9\u0000\u0000\u0000" + // 12410 - 12419
                "\u0000\u0000\u0000\uF5B1\u0000\u0000\uF5C3\uE9D8\u0000\u0000" + // 12420 - 12429
                "\u0000\u0000\u0000\uB2A5\uB2A6\u0000\u0000\uCCA8\u0000\uDAC1" + // 12430 - 12439
                "\uCCD5\u0000\uD9E4\u0000\uA8DD\uA8DE\uA8DF\uA8E0\uA8E1\uA8E2" + // 12440 - 12449
                "\uA8E3\uA8E4\uB9F4\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 12450 - 12459
                "\uD9D4\uD6E8\uB9EC\uB9ED\u0000\uB9EE\uB9EF\uB9F0\u0000\u0000" + // 12460 - 12469
                "\uF1CE\uF2E4\u0000\u0000\uD0B0\u0000\u0000\uEEAD\u0000\uFAE3" + // 12470 - 12479
                "\u0000\u0000\u0000\u0000\uD3DB\uD6B5\uECA4\u0000\u0000\uEFA5" + // 12480 - 12489
                "\u0000\uD3CC\uDAED\u0000\u0000\u0000\uB6A6\uB6A7\uB6A8\u0000" + // 12490 - 12499
                "\u0000\uDEE1\u0000\uE4A3\u0000\u0000\u0000\uD7B7\uB9EB\u0000" + // 12500 - 12509
                "\u0000\u0000\u0000\u0000\u0000\u0000\uE4F2\u0000\uDBC7\uDED5" + // 12510 - 12519
                "\u0000\u0000\u0000\u0000\uF0F4\u0000\uA8D5\uA8D6\uA8D7\uA8D8" + // 12520 - 12529
                "\uA8D9\uA8DA\uA8DB\uA8DC\uB9E8\uB9E9\u0000\u0000\uB9EA\u0000" + // 12530 - 12539
                "\u0000\u9FB1\u9FB0\uB9E6\u0000\u0000\u0000\uB9E7\u0000\u0000" + // 12540 - 12549
                "\uEECF\uF7D7\u0000\u0000\uE0A6\uD6C1\uE1DC\uB9DD\u0000\u0000" + // 12550 - 12559
                "\uB9DE\uB9DF\uB9E0\uB9E1\uB9E2\uB9D2\uB9D3\u0000\uB9D4\uB9D5" + // 12560 - 12569
                "\uB9D6\u9FAF\uB9D7\uB9D0\u0000\uB9D1\u0000\u0000\u0000\u0000" + // 12570 - 12579
                "\u0000\u9FE8\u0000\u0000\u0000\uF2F2\uF3EB\u0000\uF0D7\u0000" + // 12580 - 12589
                "\u0000\uD0CE\u0000\u0000\uDAF7\u0000\u0000\u0000\uE5FD\uDDE5" + // 12590 - 12599
                "\uD8CD\u0000\u0000\u0000\uF6C6\u0000\u0000\u0000\u0000\uEAE1" + // 12600 - 12609
                "\u0000\u0000\uDCE3\uDFAD\uB9CC\uB9CD\u0000\u0000\uB9CE\u0000" + // 12610 - 12619
                "\u0000\uB9CF\u9FAE\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 12620 - 12629
                "\uDCB5\uE0F8\uB9CA\u0000\u0000\uB9CB\u0000\u9FAC\u0000\u0000" + // 12630 - 12639
                "\u9BEB\uD5F9\u0000\u9BA1\u0000\u0000\u0000\uF7AC\uEBC4\uEDE1" + // 12640 - 12649
                "\uE0AB\uDDC7\u0000\uDFEF\uCCD3\uD3F9\u0000\u0000\u0000\u0000" + // 12650 - 12659
                "\uD4F0\uB9C9\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uCDE0" + // 12660 - 12669
                "\uE3B0\uB9C7\u9FAB\u0000\u0000\uB9C8\u0000\u0000\u0000\uE0C9" + // 12670 - 12679
                "\u0000\u0000\u0000\uD6C9\u0000\uE8D9\uEFD6\u0000\u0000\u0000" + // 12680 - 12689
                "\uD3E2\u0000\uE2DF\uB9C3\u0000\u0000\u0000\uB9C4\u0000\u0000" + // 12690 - 12699
                "\u0000\uD1B8\u0000\u0000\u0000\u0000\uD6DF\uB9C1\u0000\u0000" + // 12700 - 12709
                "\u0000\u0000\u0000\u0000\u0000\uF3E2\u0000\uF3E0\uE7AF\u0000" + // 12710 - 12719
                "\u0000\u0000\u0000\u0000\uDBAD\uB9BF\u0000\u0000\u0000\uB9C0" + // 12720 - 12729
                "\u0000\u0000\u0000\uF0D4\uCBE4\uFBD4\uF5E6\uE3EA\u9CB5\uB9BB" + // 12730 - 12739
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uE2A5\uCDB9\uB9B9" + // 12740 - 12749
                "\u0000\u0000\u0000\uB9BA\u0000\u0000\u0000\uE3C6\u0000\u0000" + // 12750 - 12759
                "\u0000\uDEE4\u0000\uF7A5\u0000\uCBAE\u0000\uDAAF\u0000\uD8B6" + // 12760 - 12769
                "\u0000\uA8CD\uA8CE\uA8CF\uA8D0\uA8D1\uA8D2\uA8D3\uA8D4\uB9AE" + // 12770 - 12779
                "\u0000\u0000\uB9AF\uB9B0\uB9B1\uB9B2\u0000\uFBF0\u0000\u0000" + // 12780 - 12789
                "\uECAC\u0000\u0000\u0000\uF0A9\uB9A8\u0000\u0000\u0000\u0000" + // 12790 - 12799
                "\u0000\u0000\u0000\uE3A6\uD1DA\uB9A6\u0000\u0000\u0000\uB9A7" + // 12800 - 12809
                "\u0000\u0000\u0000\u9DA9\u0000\u0000\u0000\u0000\u0000\uB5F5" + // 12810 - 12819
                "\uB5F6\u0000\uB5F7\uB9A1\u0000\u0000\u0000\uB9A2\u0000\u0000" + // 12820 - 12829
                "\u0000\uD6F0\uF3AF\u0000\u0000\uCDA5\u0000\u9DF8\u9BAD\u0000" + // 12830 - 12839
                "\u0000\uD5E6\u0000\u0000\u0000\uF5FE\uD4AC\u0000\u0000\u0000" + // 12840 - 12849
                "\uCAE7\u0000\u0000\u0000\u0000\uD5F4\u0000\u0000\u0000\uCDED" + // 12850 - 12859
                "\u9FAA\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uDDCA\u0000" + // 12860 - 12869
                "\uF3DF\u0000\uF8C8\uCEC6\u0000\u0000\u0000\u0000\uC2F2\uC2F3" + // 12870 - 12879
                "\u0000\uA0C5\uB8FC\uB8FD\u0000\u0000\u0000\u0000\u0000\u0000" + // 12880 - 12889
                "\uFDB6\u0000\u0000\u0000\uFCAC\uFCAD\uD8A7\u0000\u0000\u0000" + // 12890 - 12899
                "\uA0AB\uC1A6\uC1A7\u0000\u0000\uDBD4\uD7C7\u0000\u0000\u0000" + // 12900 - 12909
                "\u0000\uF2FE\uB8FB\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 12910 - 12919
                "\uD5E8\uDBAE\uB8F6\uB8F7\u0000\uB8F8\u0000\uB8F9\u0000\u0000" + // 12920 - 12929
                "\uEEB0\u0000\u0000\u0000\u0000\u0000\u0000\uF2C7\u0000\u0000" + // 12930 - 12939
                "\u0000\uFAA8\u0000\u0000\u0000\u0000\u0000\uB0C2\u0000\u0000" + // 12940 - 12949
                "\u0000\uCCE8\u0000\u0000\u0000\u0000\uF1FD\u0000\uDEBF\uFBBA" + // 12950 - 12959
                "\uF9B9\uB8F4\u0000\uB8F5\u0000\u0000\u0000\u0000\u0000\uBDDC" + // 12960 - 12969
                "\uBDDD\u0000\u9FE5\uB8F0\uB8F1\u0000\uB8F2\uB8F3\u0000\u0000" + // 12970 - 12979
                "\u9FA8\u9FA7\u0000\u0000\uB8EB\uB8EC\uB8ED\u0000\uB8EE\uB8EA" + // 12980 - 12989
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uD1D7\u0000\uCFAA" + // 12990 - 12999
                "\u0000\u0000\uCEA9\u0000\u0000\uD6F8\u0000\uA9E1\uA9E2\uA9E3" + // 13000 - 13009
                "\uA9E4\uA9E5\uA9E6\u0000\u0000\uF7E7\u0000\u0000\uCDDE\u0000" + // 13010 - 13019
                "\uF7A4\u0000\u0018\u0019\u001A\u001B\u001C\u001D\u001E\u001F" + // 13020 - 13029
                "\uB8E7\uB8E8\u0000\u0000\uB8E9\u0000\u0000\u0000\uF8DF\u0000" + // 13030 - 13039
                "\uF7F2\u0000\u0000\u0000\uC0D2\uC0D3\uC0D4\u0000\uC0D5\uB8E5" + // 13040 - 13049
                "\uB8E6\u0000\u9FA5\u0000\u9FA6\u0000\u0000\u9DC8\u0000\u0000" + // 13050 - 13059
                "\u0000\u0000\u0000\u0000\uF6F2\u0000\uDFC2\u0000\uF9BF\uD6AF" + // 13060 - 13069
                "\uD5C6\u0000\u0000\u0000\u0000\u0000\uB1F4\uB1F5\u0000\uB1F6" + // 13070 - 13079
                "\uB8E0\u0000\u0000\u0000\uB8E1\u0000\u0000\u0000\uDDF7\u0000" + // 13080 - 13089
                "\u0000\u0000\u0000\u0000\uB5F0\uB5F1\u0000\u0000\uF0E2\u0000" + // 13090 - 13099
                "\u0000\u0000\u9DD3\u0000\uEECE\uB8D8\uB8D9\u0000\uB8DA\u0000" + // 13100 - 13109
                "\uB8DB\uB8DC\u0000\uE9BC\u0000\u0000\u0000\u0000\u0000\uEAEC" + // 13110 - 13119
                "\u0000\uA9D9\uA9DA\uA9DB\uA9DC\uA9DD\uA9DE\uA9DF\uA9E0\uB8D6" + // 13120 - 13129
                "\u0000\uB8D7\u0000\u0000\u0000\u0000\u0000\uBDC3\uBDC4\u0000" + // 13130 - 13139
                "\u0000\uF5EC\u0000\u0000\u0000\u0000\u0000\uEEE7\uB8D3\uB8D4" + // 13140 - 13149
                "\u0000\u0000\uB8D5\u0000\u0000\u0000\uDEE3\u0000\u0000\u0000" + // 13150 - 13159
                "\u0000\u0000\uB5EB\uB5EC\u0000\uB5ED\uB8D1\u0000\u0000\u0000" + // 13160 - 13169
                "\u0000\u0000\u0000\u0000\uF5BC\uF2A4\uB8CF\uB8D0\u0000\u0000" + // 13170 - 13179
                "\u0000\u0000\u0000\u0000\uCEB4\u0000\u0000\u0000\uE3C5\uEBF8" + // 13180 - 13189
                "\u0000\uF2B1\u0000\u9CBC\uB8CC\uB8CD\uB8CE\u9FA3\u0000\u0000" + // 13190 - 13199
                "\u0000\u0000\uF9A3\uE0DB\uF6EB\u0000\uCBF1\uB8C7\u0000\u0000" + // 13200 - 13209
                "\u0000\uB8C8\u0000\u0000\u0000\uD8EE\u0000\uF2C1\u0000\u0000" + // 13210 - 13219
                "\u0000\uBDC8\uBDC9\uBDCA\u0000\uBDCB\uB8BE\uB8BF\u0000\uB8C0" + // 13220 - 13229
                "\u0000\uB8C1\uB8C2\u9FA2\uB8BB\uB8BC\uB8BD\u0000\u0000\u0000" + // 13230 - 13239
                "\u0000\u0000\uBDBA\uBDBB\u0000\u0000\uF0E1\u0000\u0000\u0000" + // 13240 - 13249
                "\u0000\u0000\u0000\uD8C5\u0000\u0000\u0000\uCAED\u0000\u0000" + // 13250 - 13259
                "\u0000\u0000\uE8EB\uB8B6\uB8B7\u0000\u0000\uB8B8\u0000\uB8B9" + // 13260 - 13269
                "\uB8BA\uB8B0\u0000\u0000\u0000\uB8B1\u0000\u0000\u0000\uE9DD" + // 13270 - 13279
                "\uDBCD\u0000\u0000\uDDCE\u0000\uDFCA\u0000\u0000\u0000\u0000" + // 13280 - 13289
                "\u0000\uD3F8\uF1A8\u9FA1\u0000\u0000\u0000\u0000\u0000\u0000" + // 13290 - 13299
                "\u0000\uD3A7\uFBB2\uB8A5\u0000\u0000\u0000\uB8A6\u0000\u0000" + // 13300 - 13309
                "\u0000\uF5D4\u0000\u0000\u0000\u0000\uD9A9\uB7FD\uB7FE\u0000" + // 13310 - 13319
                "\uB8A1\u0000\uB8A2\u0000\u0000\uF2E1\u0000\uDEB9\u0000\u0000" + // 13320 - 13329
                "\u0000\u0000\uE4EF\u0000\u0000\u0000\uE9B9\uB7FC\u0000\u0000" + // 13330 - 13339
                "\u0000\u0000\u0000\u0000\u0000\u9BD3\u0000\uFAB9\uCACF\u0000" + // 13340 - 13349
                "\uFCB3\uEAEA\uEAEB\uD0FA\u0000\uA9D1\uA9D2\uA9D3\uA9D4\uA9D5" + // 13350 - 13359
                "\uA9D6\uA9D7\uA9D8\uB7F9\uB7FA\u0000\u0000\uB7FB\u0000\u0000" + // 13360 - 13369
                "\u0000\u9CC8\u0000\u0000\u0000\u9DFC\u0000\uEFD3\u0000\u0000" + // 13370 - 13379
                "\u9CE7\uE4C1\uF8EB\u0000\uDBAC\uB7F4\u0000\u0000\u0000\uB7F5" + // 13380 - 13389
                "\u0000\u0000\u0000\uEBA8\u0000\u0000\u0000\uDBFE\u0000\uDFC8" + // 13390 - 13399
                "\u0000\u0000\u0000\u0000\uD9B6\u0000\uFDAC\uB7F1\u0000\u0000" + // 13400 - 13409
                "\u0000\u0000\u0000\u0000\u0000\uFAD7\uFBC1\uB7F0\u0000\u0000" + // 13410 - 13419
                "\u0000\u0000\u0000\u0000\u0000\uD8AC\uF3CC\uB7EB\uB7EC\u0000" + // 13420 - 13429
                "\uB7ED\u0000\uB7EE\u0000\u0000\uF8FB\uE3CF\u0000\u0000\u0000" + // 13430 - 13439
                "\u0000\u0000\uB9B3\uB9B4\u0000\uB9B5\uB7EA\u0000\u0000\u0000" + // 13440 - 13449
                "\u0000\u0000\u0000\u0000\uF8C6\u0000\uCBDD\u0000\u0000\uD9E3" + // 13450 - 13459
                "\u0000\u0000\uF3AC\u0000\uA9F3\uA9F4\uA9F5\u0000\u0000\u0000" + // 13460 - 13469
                "\u0000\u0000\uD4B7\u0000\u0000\u0000\uE0DE\uF6B4\uEAD2\u0000" + // 13470 - 13479
                "\uF9FB\uB7E7\uB7E8\u0000\u0000\uB7E9\u0000\u0000\u0000\uD6FB" + // 13480 - 13489
                "\u0000\u0000\u0000\u0000\u0000\uB5DA\u0000\u0000\u0000\u9FD5" + // 13490 - 13499
                "\uBBEF\uBBF0\u0000\uBBF1\uB7E2\u0000\u0000\u0000\uB7E3\u0000" + // 13500 - 13509
                "\u0000\u0000\uD7E5\u9DC0\u0000\u0000\u0000\u0000\uC7B9\u0000" + // 13510 - 13519
                "\u0000\uC7BA\uB7DD\uB7DE\u0000\uB7DF\u0000\uB7E0\u0000\u0000" + // 13520 - 13529
                "\uFCC3\u0000\u0000\u0000\u0000\uD4E7\u0000\uE7AE\u0000\uD6BA" + // 13530 - 13539
                "\u0000\uDFEC\uE4C0\u0000\u0000\uE5A9\uE0F6\uF6B3\u0000\u0000" + // 13540 - 13549
                "\u0000\u0000\uC3D2\u0000\u0000\u0000\uD3D9\u0000\u0000\u0000" + // 13550 - 13559
                "\u0000\uE7EF\u0000\u0000\u0000\u0000\uC1E2\u0000\u0000\u0000" + // 13560 - 13569
                "\uD8C1\u0000\u0000\u0000\u0000\uFAA6\u0000\u0000\u0000\u0000" + // 13570 - 13579
                "\uC1EA\uA0B8\u0000\u0000\uE1FE\u0000\u9CA6\u0000\u0000\uCBF0" + // 13580 - 13589
                "\u0000\uA9EB\uA9EC\uA9ED\uA9EE\uA9EF\uA9F0\uA9F1\uA9F2\uB7DC" + // 13590 - 13599
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uF6A5\u0000\uCEE4" + // 13600 - 13609
                "\u0000\uE8F2\u0000\u0000\u0000\u0000\u0000\uB1CB\u0000\u0000" + // 13610 - 13619
                "\u0000\uCAB4\u0000\u0000\uF8E2\uCFC2\uB7DA\u0000\u0000\u0000" + // 13620 - 13629
                "\uB7DB\u0000\u0000\u0000\uE5CA\u0000\uF6C0\uFDDD\u0000\u0000" + // 13630 - 13639
                "\uF1FB\u0000\u0000\u0000\u0000\uFDD2\uD1C1\uB7D9\u0000\u0000" + // 13640 - 13649
                "\u0000\u0000\u0000\u0000\u0000\uCACD\u0000\uD5B9\u0000\u9CC3" + // 13650 - 13659
                "\u0000\u0000\u0000\u0000\u0000\uB1B8\uB1B9\u0000\u0000\uE5BF" + // 13660 - 13669
                "\u9CD1\u0000\u0000\uCEBF\u0000\u0000\uE3FA\u0000\u0000\uF0AA" + // 13670 - 13679
                "\uF9D0\u0000\u0000\uFBE3\u0000\u0000\u0000\u0000\u0000\u0000" + // 13680 - 13689
                "\uE6AC\u0000\uCEDE\uB7D6\u0000\u0000\u0000\uB7D7\u0000\u0000" + // 13690 - 13699
                "\u0000\uCAB2\u0000\u0000\uDCBB\u0000\uF1F8\uB7D0\u0000\u0000" + // 13700 - 13709
                "\u0000\uB7D1\u0000\u0000\u0000\uF4E1\uF9B5\u0000\u0000\uE1C3" + // 13710 - 13719
                "\uE1C2\uB7CA\u0000\u0000\u0000\uB7CB\u0000\u0000\u0000\uDBE3" + // 13720 - 13729
                "\u0000\u0000\u0000\u0000\uF1E1\uB7C8\uB7C9\u0000\u0000\u0000" + // 13730 - 13739
                "\u0000\u0000\u0000\uE2A9\u0000\u0000\uDEBC\uB7C3\u0000\u0000" + // 13740 - 13749
                "\u0000\uB7C4\u0000\u0000\u0000\uF9B4\u0000\u0000\uD5D4\uFDCF" + // 13750 - 13759
                "\u0000\uDCE8\u0000\u0000\u0000\uFAD6\u0000\uD3F6\u0000\uA8EF" + // 13760 - 13769
                "\uA8F0\uA8F1\uA8F2\uA8F3\uA8F4\uA8F5\u0000\u0010\u0011\u0012" + // 13770 - 13779
                "\u0013\u0014\u0015\u0016\u0017\uB7BD\uB7BE\u0000\uB7BF\u0000" + // 13780 - 13789
                "\uB7C0\u0000\u0000\uFCA6\u0000\u0000\u0000\u0000\u0000\u0000" + // 13790 - 13799
                "\uF6E3\u0000\u0000\u0000\uF8D4\u0000\u0000\u9AB3\u0000\u0000" + // 13800 - 13809
                "\uD5A9\uFAE2\u0000\u0000\u0000\uD0E5\u0000\uE4B1\u0000\u0000" + // 13810 - 13819
                "\u0000\u0000\u9DCE\u0000\uDCE7\uB7BC\u0000\u0000\u0000\u0000" + // 13820 - 13829
                "\u0000\u0000\u0000\uFAF1\u0000\uDFC7\u0000\u0000\u0000\u0000" + // 13830 - 13839
                "\u0000\u0000\u0000\u9AC8\uB7B9\uB7BA\u0000\u0000\uB7BB\u0000" + // 13840 - 13849
                "\u0000\u9EFB\uB7B6\uB7B7\u0000\u0000\u0000\u0000\u0000\uB7B8" + // 13850 - 13859
                "\uB7B1\u0000\u0000\u0000\uB7B2\u0000\u0000\u0000\u9AB7\u0000" + // 13860 - 13869
                "\uCDA3\u0000\u0000\uE8E6\u9EFA\u0000\u0000\u0000\u0000\u0000" + // 13870 - 13879
                "\u0000\u0000\uFDB5\u0000\uE1FC\u0000\u0000\u0000\u0000\u0000" + // 13880 - 13889
                "\u0000\u0000\u9CA1\uB7AC\u0000\u0000\u0000\u0000\u0000\u0000" + // 13890 - 13899
                "\u0000\uF4DC\u0000\uE4CD\u0000\uD6B9\u0000\u0000\u0000\uEFC0" + // 13900 - 13909
                "\u0000\uA8E7\uA8E8\uA8E9\uA8EA\uA8EB\uA8EC\uA8ED\uA8EE\uB7A5" + // 13910 - 13919
                "\uB7A6\u0000\uB7A7\uB7A8\uB7A9\u0000\u0000\uD0CD\u0000\u0000" + // 13920 - 13929
                "\u0000\u0000\u9BB7\u0000\uD0F7\uEDD4\u0000\u0000\u0000\u0000" + // 13930 - 13939
                "\u0000\u0000\u9CD5\u0000\u0000\uECF6\uE2E1\uE3BE\u0000\u0000" + // 13940 - 13949
                "\u0000\u0000\uC3C7\u0000\u0000\u0000\uCDF7\uF0DE\u0000\u0000" + // 13950 - 13959
                "\u0000\u9DCB\u0000\u0000\u0000\u9CE6\uB7A4\u0000\u0000\u0000" + // 13960 - 13969
                "\u0000\u0000\u0000\u0000\uFCF7\u0000\uD3F5\u0000\uD7A6\u0000" + // 13970 - 13979
                "\uF6B5\uD7DB\u0000\u0000\uF4CB\u0000\u0000\u0000\uFDC5\u0000" + // 13980 - 13989
                "\u0000\u9DE6\u0000\u0000\u0000\uD2B7\u0000\u0000\u9DD5\u0000" + // 13990 - 13999
                "\u9EA6\u0000\u0000\u0000\u0000\uC3C0\uC3C1\u0000\uC3C2\uB7A1" + // 14000 - 14009
                "\uB7A2\u0000\u0000\uB7A3\u0000\u0000\u0000\uD1AF\uD7E3\u0000" + // 14010 - 14019
                "\u0000\u0000\uE0C6\uB6FA\uB6FB\uB6FC\u0000\u0000\u0000\uB6FD" + // 14020 - 14029
                "\uB6FE\uB6F5\u0000\u0000\u0000\uB6F6\u0000\u0000\u0000\uD6BC" + // 14030 - 14039
                "\uD3E5\u0000\u0000\u0000\u0000\uC6EF\uC6F0\u0000\uA0EA\uB6EF" + // 14040 - 14049
                "\uB6F0\u0000\uB6F1\u0000\uB6F2\u0000\u0000\uCCC5\uECD0\uCBBB" + // 14050 - 14059
                "\u0000\uDEF3\u0000\u0000\uE1C9\uCAFA\u0000\u0000\u0000\u0000" + // 14060 - 14069
                "\u0000\uB6CC\u0000\u0000\u0000\uA1EE\u0000\u0000\uA1F0\uA1C4" + // 14070 - 14079
                "\u0000\uCFDD\u0000\u0000\uE8A9\u0000\uE3BB\uE3BA\u0000\uA1C1" + // 14080 - 14089
                "\uA1D5\u0000\u0000\uA1C2\uA1C3\u9AA7\u9AA8\uB6EE\u0000\u0000" + // 14090 - 14099
                "\u0000\u0000\u0000\u0000\u0000\uF7A3\u0000\uCFD1\u0000\u0000" + // 14100 - 14109
                "\u0000\u0000\uCBDC\uCCFA\u0000\uA1FD\uA1FB\uA1FA\uA1F2\uA1F3" + // 14110 - 14119
                "\u0000\uA2B1\u0000\u0008\u0009\n\u000B\u000C\r\u000E" + // 14120 - 14129
                "\u000F\uB6EC\u0000\u0000\u0000\uB6ED\u0000\u0000\u0000\uE7D9" + // 14130 - 14139
                "\u0000\u0000\u0000\u0000\u0000\u9EE6\u0000\u0000\u0000\u9BE4" + // 14140 - 14149
                "\u9BD6\u0000\u0000\u0000\uCDD5\u0000\u0000\u0000\u0000\uD5FD" + // 14150 - 14159
                "\u0000\u0000\u0000\u0000\uC4AF\uC4B0\u0000\uC4B1\uB6E8\u0000" + // 14160 - 14169
                "\u0000\u0000\uB6E9\u0000\u0000\u0000\uD4BB\u0000\u0000\u0000" + // 14170 - 14179
                "\u0000\uFDFA\uB6E4\uB6E5\u0000\uB6E6\u0000\u0000\u0000\u0000" + // 14180 - 14189
                "\uDEDB\u0000\u0000\uEFDE\u0000\uE3B9\uEBC5\uF4A9\uCDB6\uD2F9" + // 14190 - 14199
                "\u0000\uDAAD\uD2E3\uB6E3\u0000\u0000\u0000\u0000\u0000\u0000" + // 14200 - 14209
                "\u0000\uE4AF\u0000\uDBAB\u0000\u0000\u0000\u0000\u0000\u0000" + // 14210 - 14219
                "\u0000\uF9BE\uB6DF\uB6E0\u0000\u0000\uB6E1\u0000\u0000\uB6E2" + // 14220 - 14229
                "\uB6DC\uB6DD\u0000\u0000\u0000\uB6DE\u0000\u0000\uFDC9\u0000" + // 14230 - 14239
                "\u9CC4\u0000\u0000\uE4A6\uF9A4\uB6DB\u0000\u0000\u0000\u0000" + // 14240 - 14249
                "\u0000\u0000\u0000\uF6E4\u0000\u9CA5\u0000\u0000\u0000\uE9D6" + // 14250 - 14259
                "\u0000\u0000\u0000\u9AFE\u0000\u0000\uCADD\uD5DE\uB6D9\u0000" + // 14260 - 14269
                "\u0000\u0000\uB6DA\u0000\u0000\u0000\uDFE5\u0000\u0000\u0000" + // 14270 - 14279
                "\u0000\u0000\uB5AE\u0000\u0000\u0000\u9DFE\u0000\u0000\u0000" + // 14280 - 14289
                "\u0000\uE1B7\u0000\u0000\u0000\u0000\uC3E9\u0000\u0000\u0000" + // 14290 - 14299
                "\uD8AB\u0000\u0000\uFDCB\u0000\uEEF6\uEACF\uF0EE\uE3FC\u0000" + // 14300 - 14309
                "\uD3DF\uD3F4\uE1B3\u9EF8\u0000\u0000\u0000\u0000\u0000\u0000" + // 14310 - 14319
                "\u0000\uD7DA\u0000\uF5BB\u0000\uDED1\u0000\u0000\u0000\u0000" + // 14320 - 14329
                "\u0000\uB1AF\uB1B0\u0000\uB1B1\uB6D3\u0000\u0000\u0000\uB6D4" + // 14330 - 14339
                "\u0000\u0000\u0000\uF4E0\u0000\u9BC8\u0000\u0000\u0000\uFBF8" + // 14340 - 14349
                "\u0000\u0000\u0000\u0000\uF1A9\u0000\u0000\u0000\uF2C9\u9EF7" + // 14350 - 14359
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uFAB6\u0000\uF3F3" + // 14360 - 14369
                "\uE3FB\u0000\uDED0\uCEB0\u0000\uD6F7\uF1D9\uB6D0\u0000\u0000" + // 14370 - 14379
                "\u0000\u0000\u0000\u0000\u0000\uCCCB\u0000\uD8DB\u0000\uF9CE" + // 14380 - 14389
                "\uE9D5\uE3D1\u0000\u0000\uD2BC\uB6CE\u0000\u0000\u0000\u0000" + // 14390 - 14399
                "\u0000\u0000\u0000\uE1F3\uDCF6\uB6CA\u0000\u0000\u0000\u0000" + // 14400 - 14409
                "\u0000\u0000\u0000\uD9B2\uFDA5\uB6C7\uB6C8\u0000\u0000\uB6C9" + // 14410 - 14419
                "\u0000\u0000\u0000\uE5AC\uFDA1\u0000\uDFD0\uECB3\u0000\uF3F2" + // 14420 - 14429
                "\u0000\uEED6\uEAB2\uD0F6\uECD9\uDACB\uCFA8\uB6C5\u0000\u0000" + // 14430 - 14439
                "\u0000\u0000\u0000\u0000\u0000\uD3A2\u0000\uE3E4\uE9BB\u0000" + // 14440 - 14449
                "\u0000\u0000\u0000\u0000\uE2D6\uB6C3\uB6C4\u0000\u0000\u0000" + // 14450 - 14459
                "\u0000\u0000\u0000\uFCE6\u0000\u0000\u0000\uF0D0\u0000\uF7F0" + // 14460 - 14469
                "\uEEB3\u0000\u0000\uE3CD\u0000\u0000\u0000\u0000\uF4F4\uFAB2" + // 14470 - 14479
                "\uB6BE\u0000\u0000\u0000\uB6BF\u0000\u0000\u0000\uDCEC\u0000" + // 14480 - 14489
                "\u0000\u0000\u0000\u0000\uB4F5\uB4F6\uB4F7\u0000\uEEA5\u0000" + // 14490 - 14499
                "\u0000\uFAAA\uE6C3\uE1B2\uCAAB\u0000\uA1D0\u0000\u0000\u0000" + // 14500 - 14509
                "\u0000\uA1AB\u0000\uA1FC\uB6B6\uB6B7\u0000\uB6B8\uB6B9\uB6BA" + // 14510 - 14519
                "\u0000\u0000\uDEA6\u0000\u0000\uEBFE\u0000\uEBDD\uF0E0\uB6B3" + // 14520 - 14529
                "\u0000\uB6B4\uB6B5\u0000\u0000\u0000\u0000\uD2EE\u0000\u0000" + // 14530 - 14539
                "\uE1E6\uF7F9\uB6B0\uB6B1\u0000\u0000\uB6B2\u0000\u0000\u0000" + // 14540 - 14549
                "\uFBA7\u0000\uE9C2\u0000\u0000\u0000\uD8C4\u0000\u0000\u0000" + // 14550 - 14559
                "\u0000\uF6E8\u0000\u0000\u0000\u0000\uC3D9\uC3DA\u0000\uC3DB" + // 14560 - 14569
                "\u9EF4\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uCBEB\u0000" + // 14570 - 14579
                "\uCEAF\uF1B5\uEFD2\uE8C8\uEBF1\u0000\u0000\u0000\u9DDF\u0000" + // 14580 - 14589
                "\uF6EC\uDADC\uFAE4\uB6AE\uB6AF\u0000\u0000\u0000\u0000\u0000" + // 14590 - 14599
                "\u0000\uCAF4\u0000\u0000\u9DE1\uB6A9\u0000\u0000\u0000\uB6AA" + // 14600 - 14609
                "\u0000\u0000\u0000\uF5A4\u0000\u0000\u9DF7\u0000\u0000\uF4DA" + // 14610 - 14619
                "\u0000\u0000\u0000\u0000\u0000\u0000\uFBFA\u0000\uCFA4\u0000" + // 14620 - 14629
                "\uE1FA\uE4CC\u0000\uE1E4\uE8C7\u0000\u0000\uCEDB\uB6A1\uB6A2" + // 14630 - 14639
                "\u0000\uB6A3\uB6A4\uB6A5\u0000\u0000\uE3CC\u0000\u0000\u0000" + // 14640 - 14649
                "\uCFF8\uEFAC\u0000\uF9CA\u0000\uEAE8\u0000\uE5ED\u0000\u0000" + // 14650 - 14659
                "\u0000\uF2B8\uF6C8\u0000\u0000\u0000\uF4BF\uE2EF\u0000\uD9F1" + // 14660 - 14669
                "\uF1C7\uB5FE\u0000\u0000\u0000\u0000\u0000\u0000\u9EF3\uB5FB" + // 14670 - 14679
                "\uB5FC\u9EF1\u0000\uB5FD\u0000\u0000\u9EF2\uB5F8\uB5F9\uB5FA" + // 14680 - 14689
                "\u0000\u0000\u0000\u9EF0\u0000\uE2D5\uEDCF\u0000\u0000\u0000" + // 14690 - 14699
                "\uDDA2\u0000\u0000\uF3F4\uF8F3\uF0C1\uDEAF\uF8B0\u0000\u0000" + // 14700 - 14709
                "\uE6B5\u0000\u0000\uF9A8\u0000\u0000\uDDD8\uB5F2\u0000\u0000" + // 14710 - 14719
                "\uB5F3\uB5F4\u0000\u0000\u0000\uF6A7\u0000\u0000\u0000\uE6FA" + // 14720 - 14729
                "\u0000\uF0ED\u0000\uDDA1\u0000\uEDAF\uFCF8\u0000\uD8EB\uB5EF" + // 14730 - 14739
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uCED2\u0000\uEDAD" + // 14740 - 14749
                "\uFAEA\u0000\u0000\uCDEE\uEDA6\u0000\uEDAE\uB5E7\u0000\u0000" + // 14750 - 14759
                "\uB5E8\uB5E9\u0000\uB5EA\u9EEF\uB5E3\u0000\u0000\u0000\u0000" + // 14760 - 14769
                "\uB5E4\u0000\u0000\u9ABC\u0000\u0000\u0000\u0000\u0000\u0000" + // 14770 - 14779
                "\uE2D2\u0000\uF6A2\uE1F4\uB5E2\u0000\u0000\u0000\u0000\u0000" + // 14780 - 14789
                "\u0000\u0000\uA2CF\uA2CE\uB5E0\u9EEE\u0000\u0000\uB5E1\u0000" + // 14790 - 14799
                "\u0000\u0000\uE7B9\u9BC1\u0000\u0000\u0000\uF0AD\uB5DB\u0000" + // 14800 - 14809
                "\u0000\u0000\uB5DC\u0000\u0000\u0000\uE7D8\u0000\u0000\u0000" + // 14810 - 14819
                "\u0000\u0000\uB4BD\uB4BE\u0000\u0000\uD4AD\uF6D1\u0000\u0000" + // 14820 - 14829
                "\u0000\u0000\u9ACB\uB5D8\u0000\u0000\u0000\u0000\u0000\u0000" + // 14830 - 14839
                "\u0000\uA8AE\uA9AE\uB5D7\u0000\u0000\u0000\u0000\u0000\u0000" + // 14840 - 14849
                "\u0000\uA8A4\uA9A4\uB5D2\uB5D3\u0000\uB5D4\u0000\uB5D5\u0000" + // 14850 - 14859
                "\u0000\uCCAF\u0000\u0000\u0000\u0000\u0000\u0000\uE4F8\u0000" + // 14860 - 14869
                "\u0000\u0000\uD7CD\u0000\u0000\uD4D1\uE9ED\u0000\uDFC5\u0000" + // 14870 - 14879
                "\u0000\uE5BE\u0000\u0000\u0000\u0000\uC2E5\u0000\u0000\u0000" + // 14880 - 14889
                "\uE0CE\u0000\uF5FD\u0000\u0000\uE5B0\u0000\u0000\u0000\uEDE5" + // 14890 - 14899
                "\u0000\u0000\uFDC4\u0000\uECAD\u0000\u0000\u0000\u0000\uA0CB" + // 14900 - 14909
                "\u0000\u0000\u0000\uE0E0\u0000\u0000\u0000\u0000\uCBDB\u0000" + // 14910 - 14919
                "\u0000\u0000\u0000\uC1CB\u0000\u0000\u0000\uFAC8\uD6D7\u0000" + // 14920 - 14929
                "\uE9E5\uFBDC\uB5D1\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 14930 - 14939
                "\uA9A1\u0000\u9CD9\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 14940 - 14949
                "\uE6B4\uB5CE\uB5CF\u0000\u0000\uB5D0\u0000\u0000\u9EEB\uB5CA" + // 14950 - 14959
                "\uB5CB\u0000\uB5CC\u9EEA\u0000\u0000\u0000\uEDD2\u0000\uD4D8" + // 14960 - 14969
                "\uDCC9\uD7F1\u0000\uE3E3\u0000\u0000\u0000\u0000\uE4B0\u0000" + // 14970 - 14979
                "\u0000\uD2C0\u0000\u0000\u0000\u0000\u0000\u0000\uF8AF\uEFF6" + // 14980 - 14989
                "\u0000\uA1F4\u0000\u0000\uA1F5\u0000\u0000\u0000\uA2B3\uB5C9"   // 14990 - 14999
                ;

        protected static String index2a =
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uA8A1\u0000\uD2A6" + // 15000 - 15009
                "\u0000\u0000\uE7F4\uD1D6\u0000\u0000\uE6C2\uB5C7\u0000\u0000" + // 15010 - 15019
                "\u0000\uB5C8\u0000\u0000\u0000\uFCD2\u0000\uEBC8\u0000\u9AFD" + // 15020 - 15029
                "\u0000\uE6C1\u0000\u0000\uECD8\u0000\u0000\u0000\uEDAC\uB5C6" + // 15030 - 15039
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uC8B1\u9EE8\u0000" + // 15040 - 15049
                "\u0000\u0000\u0000\u0000\u0000\u0000\uA0E0\uB5C4\u0000\u0000" + // 15050 - 15059
                "\u0000\u0000\u0000\u0000\u0000\uC5F2\uB5C2\u0000\u0000\u0000" + // 15060 - 15069
                "\uB5C3\u0000\u0000\u0000\uDBB5\u0000\uF3E7\uD8FE\u0000\u0000" + // 15070 - 15079
                "\uE9A9\u0000\uD3C7\u0000\u0000\uDCDD\uF8AE\uB5BB\u0000\u0000" + // 15080 - 15089
                "\u9EE7\uB5BC\uB5BD\u0000\uB5BE\uB5B7\u0000\u0000\uB5B8\uB5B9" + // 15090 - 15099
                "\u0000\uB5BA\u0000\uECA9\u0000\uF2EB\u0000\uFDEF\u0000\uF9F3" + // 15100 - 15109
                "\u0000\uA2A3\u0000\uA1D3\uA2A4\u0000\u0000\u0000\uA1D4\uB5B3" + // 15110 - 15119
                "\u0000\u0000\u0000\uB5B4\u0000\u0000\u0000\uD2FC\u0000\u0000" + // 15120 - 15129
                "\u0000\u0000\u0000\uB4BA\uB4BB\u0000\u0000\uD7EB\u0000\u0000" + // 15130 - 15139
                "\u0000\u0000\u0000\u0000\uF7F7\uDCAC\u0000\u0000\uF5E9\u0000" + // 15140 - 15149
                "\u9DFA\u9EA9\u0000\u0000\u0000\uA8AB\uA9AB\u0000\u0000\u0000" + // 15150 - 15159
                "\u0000\uBFB0\uBFB1\uBFB2\uBFB3\uB5B1\uB5B2\u0000\u0000\u0000" + // 15160 - 15169
                "\u0000\u0000\u0000\uD1A5\uDCB8\u0000\u0000\uCFD9\u0000\u0000" + // 15170 - 15179
                "\uDCCD\uEDFB\u0000\uDEF0\uB5AF\u0000\u0000\u0000\uB5B0\u0000" + // 15180 - 15189
                "\u0000\u0000\uCDA2\uE8AE\u0000\u0000\u0000\uE1BD\uB5A9\uB5AA" + // 15190 - 15199
                "\u0000\uB5AB\uB5AC\uB5AD\u0000\u0000\uEEAE\uD6AE\u0000\u0000" + // 15200 - 15209
                "\u9DA1\u0000\u0000\uDFD5\u0000\u0000\uEDD7\u0000\u0000\u0000" + // 15210 - 15219
                "\u9AAC\u9AB0\u9AB8\u9AC9\u9AD3\uB5A8\u0000\u0000\u0000\u0000" + // 15220 - 15229
                "\u0000\u0000\u0000\uA0D9\uB5A5\uB5A6\u0000\u0000\uB5A7\u0000" + // 15230 - 15239
                "\u0000\u0000\uECEE\u0000\u0000\uDDAA\u0000\u0000\uEABE\uD9B1" + // 15240 - 15249
                "\u0000\u0000\u0000\u0000\u0000\uB8A3\uB8A4\u0000\u0000\uD4F5" + // 15250 - 15259
                "\u0000\uD0C9\uEFA7\uE2EC\u0000\uDBEA\u9EE4\uB5A2\u9EE5\uB5A3" + // 15260 - 15269
                "\u0000\u0000\uB5A4\u0000\uEEBB\uCDB4\u9BF2\uE0F3\uEACD\u0000" + // 15270 - 15279
                "\u0000\u0000\uDCEE\u0000\u0000\uF5EA\uE6E0\uB4F8\u0000\u0000" + // 15280 - 15289
                "\uB4F9\uB4FA\u0000\uB4FB\uB4FC\u9EE3\u0000\u0000\u0000\u0000" + // 15290 - 15299
                "\u0000\u0000\u0000\uA0BE\uB4EF\uB4F0\u0000\uB4F1\uB4F2\uB4F3" + // 15300 - 15309
                "\u0000\u0000\uFBAC\uCFC3\uEBFD\u0000\u0000\u0000\u0000\uCCF6" + // 15310 - 15319
                "\u0000\u0000\uD3BA\u0000\uDBAA\u0000\u0000\u0000\uF7E0\u0000" + // 15320 - 15329
                "\u0000\u0000\uDADA\u0000\uF2DC\uFBD6\uE9B2\uB4EE\u0000\u0000" + // 15330 - 15339
                "\u0000\u0000\u0000\u0000\u0000\u9FC7\uB4EB\uB4EC\u0000\u0000" + // 15340 - 15349
                "\uB4ED\u0000\u0000\u0000\uEAB8\uD1F9\u0000\u0000\u0000\u0000" + // 15350 - 15359
                "\uC6A1\u0000\u0000\u0000\uF9DB\u0000\u0000\u0000\u0000\uF4E6" + // 15360 - 15369
                "\u0000\u0000\uE6C5\uEFD5\uB4E6\uB4E7\uB4E8\uB4E9\u0000\u0000" + // 15370 - 15379
                "\u0000\uB4EA\uB4DC\u0000\u0000\uB4DD\uB4DE\uB4DF\uB4E0\uB4E1" + // 15380 - 15389
                "\u9EE1\u0000\uB4D8\u0000\uB4D9\uB4DA\uB4DB\u0000\uCACC\u0000" + // 15390 - 15399
                "\u0000\u0000\u0000\uFBBF\u0000\u0000\uE3BD\u0000\uCFE1\uF0C0" + // 15400 - 15409
                "\uECDA\u0000\uDDD7\uB4D4\uB4D5\u0000\uB4D6\u0000\uB4D7\u0000" + // 15410 - 15419
                "\u0000\uE4B7\u0000\uEADB\u0000\uF5FA\u9CE8\u0000\uEEF5\u0000" + // 15420 - 15429
                "\uDECE\u0000\u0000\u0000\u0000\uE7F3\uB4D2\u9EE0\uB4D3\u0000" + // 15430 - 15439
                "\u0000\u0000\u0000\u0000\uBDB0\uBDB1\u0000\uBDB2\uB4CF\uB4D0" + // 15440 - 15449
                "\u0000\u0000\uB4D1\u0000\u0000\u0000\uF1BE\u0000\u0000\uD3AC" + // 15450 - 15459
                "\u0000\u0000\uCDCC\u0000\u0000\u0000\u0000\uEDD9\u0000\uFCB1" + // 15460 - 15469
                "\uCCF8\u0000\u0000\uDDC6\uFAD1\u0000\uF7DF\uB4CD\u0000\u0000" + // 15470 - 15479
                "\u0000\uB4CE\u0000\u0000\u0000\uE0C2\u0000\uCAE4\u0000\uE7B7" + // 15480 - 15489
                "\u0000\uD2AF\uDCE5\u0000\u0000\u0000\u0000\uD0A5\uF1B4\uB4C6" + // 15490 - 15499
                "\uB4C7\u0000\uB4C8\u0000\uB4C9\uB4CA\u9EDE\uB4C3\uB4C4\uB4C5" + // 15500 - 15509
                "\u0000\u0000\u0000\u0000\u0000\uBDAC\uBDAD\u0000\u0000\u9AF5" + // 15510 - 15519
                "\uF1E3\uD5EE\u0000\u0000\u0000\u0000\uE3E2\uFBBC\uD9A4\u0000" + // 15520 - 15529
                "\u0000\uDFE9\u0000\uEEDE\u0000\u0000\uF7C2\u0000\uD7A4\uCEC5" + // 15530 - 15539
                "\u0000\u0000\u0000\u0000\uCED5\uD6E6\uB4C0\uB4C1\u0000\u0000" + // 15540 - 15549
                "\uB4C2\u0000\u0000\u0000\uF1BD\u0000\u0000\uE2E7\uFDD7\u0000" + // 15550 - 15559
                "\uD9F8\uD4C2\u0000\u0000\u0000\u0000\uF6E5\u0000\uA2D9\uA2D7" + // 15560 - 15569
                "\u0000\u0000\u0000\u0000\u0000\u0000\uCBCA\u0000\u0000\uD6B7" + // 15570 - 15579
                "\uCDB3\u0000\u0000\u0000\u0000\u9CE9\uB4B8\uB4B9\u0000\u0000" + // 15580 - 15589
                "\u0000\u0000\u0000\u0000\uE7A5\u0000\uD5F5\uD3BE\uB4B7\u0000" + // 15590 - 15599
                "\u0000\u0000\u0000\u0000\u0000\u0000\u9EFE\uB4B5\u0000\u0000" + // 15600 - 15609
                "\u0000\uB4B6\u0000\u0000\u0000\uCCBD\u0000\u0000\uD1A9\uDDCC" + // 15610 - 15619
                "\u0000\uD3D2\u0000\uF5C0\u0000\u0000\u0000\uDFDD\u0000\uA1E7" + // 15620 - 15629
                "\uA1E8\uA1E6\uA1E9\uA1EA\uA2D5\uA2D8\uA2D6\uB4B2\u0000\u0000" + // 15630 - 15639
                "\u0000\u0000\u0000\u0000\u0000\uB7AD\uB4AB\u0000\u0000\uB4AC" + // 15640 - 15649
                "\uB4AD\u0000\u0000\u0000\uE7FD\u0000\u0000\uE6A3\uFBF1\uCBB0" + // 15650 - 15659
                "\uB4A5\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u9EEC\uB4A2" + // 15660 - 15669
                "\uB4A3\u0000\u0000\uB4A4\u0000\u0000\u0000\uD4B8\uEBBE\uDDEF" + // 15670 - 15679
                "\u0000\uDDF0\uDDF1\uB3FB\u0000\u0000\u0000\uB3FC\u0000\u0000" + // 15680 - 15689
                "\u0000\uDFAF\u0000\uCAC3\u0000\u0000\uEEFC\u9EDC\u0000\u0000" + // 15690 - 15699
                "\u0000\u0000\u0000\u0000\u0000\u9EE9\uB3F9\u0000\u0000\u0000" + // 15700 - 15709
                "\u0000\u0000\u0000\u0000\u9EDB\uB3F7\u0000\u0000\u0000\uB3F8" + // 15710 - 15719
                "\u0000\u0000\u0000\uE0E8\u0000\u0000\uD3AB\u0000\uEBDC\uB3F0" + // 15720 - 15729
                "\uB3F1\u0000\uB3F2\u0000\uB3F3\u0000\u0000\u9DEB\u0000\u0000" + // 15730 - 15739
                "\u0000\u0000\u0000\uEADA\uB3EE\u0000\uB3EF\u0000\u0000\u0000" + // 15740 - 15749
                "\u0000\u0000\uBCF2\uBCF3\u0000\uBCF4\uB3EB\uB3EC\u9EDA\u0000" + // 15750 - 15759
                "\uB3ED\u0000\u0000\u0000\uE8E0\u0000\u0000\u0000\u0000\u0000" + // 15760 - 15769
                "\uB3FA\u0000\u0000\u0000\uE7A2\uE4D9\u0000\u0000\u0000\uF0E6" + // 15770 - 15779
                "\u0000\u0000\u0000\uE4B9\uB3EA\u0000\u0000\u0000\u0000\u0000" + // 15780 - 15789
                "\u0000\u0000\u9ED9\uB3E8\u9ED8\u0000\u0000\uB3E9\u0000\u0000" + // 15790 - 15799
                "\u0000\uE9B0\u0000\u0000\u0000\u0000\u0000\uB3DB\uB3DC\u0000" + // 15800 - 15809
                "\uB3DD\uB3E4\uB3E5\u0000\u9ED7\uB3E6\uB3E7\u0000\u0000\u9CE3" + // 15810 - 15819
                "\u0000\u0000\u0000\u0000\uE4B6\u0000\uE5E8\uDCC3\u0000\u0000" + // 15820 - 15829
                "\uEDDE\uD3F2\u0000\u0000\uDCA7\u0000\u0000\uD6E7\u0000\u0000" + // 15830 - 15839
                "\u0000\uFBD9\uEDF7\u0000\u0000\uE5B5\uB3E3\u0000\u0000\u0000" + // 15840 - 15849
                "\u0000\u0000\u0000\u0000\u9ECD\uB3E0\uB3E1\u0000\u0000\uB3E2" + // 15850 - 15859
                "\u0000\u0000\u9ED6\uB3DE\uB3DF\u0000\u0000\u0000\u0000\u0000" + // 15860 - 15869
                "\u0000\uDEB0\u0000\u0000\u0000\uD5B2\u0000\u0000\u0000\uD5BC" + // 15870 - 15879
                "\u0000\uCBA8\uEBBC\uE4BE\u0000\u0000\u0000\u0000\u0000\uCFCF" + // 15880 - 15889
                "\u0000\u0000\u0000\uEDB9\uF1C5\u0000\uF3CF\uD7AB\uB3D9\u0000" + // 15890 - 15899
                "\u0000\u0000\uB3DA\u0000\u0000\u0000\uCFED\u0000\uEDEB\u0000" + // 15900 - 15909
                "\u0000\u0000\uF0EC\u0000\u0000\u0000\u0000\uDCB3\u0000\u0000" + // 15910 - 15919
                "\u0000\u0000\uC2EA\u0000\u0000\u0000\uEFB2\u0000\u0000\u0000" + // 15920 - 15929
                "\u0000\uF1DA\u0000\uFAF2\u0000\u0000\uE8C3\u0000\uF1C8\u0000" + // 15930 - 15939
                "\u0000\u0000\uCEF1\uB3D1\uB3D2\u0000\uB3D3\uB3D4\uB3D5\u9ED5" + // 15940 - 15949
                "\u0000\uCFDC\u0000\uD3D1\u0000\u0000\uCCB1\uF7D8\u0000\uA5A9" + // 15950 - 15959
                "\uA5AA\u0000\u0000\u0000\u0000\u0000\u0000\uDFA8\u0000\u0000" + // 15960 - 15969
                "\uF5B6\u0000\u0000\u0000\u0000\u0000\u0000\uF4E9\uD6EC\uEBD3" + // 15970 - 15979
                "\uB3CE\u0000\uB3CF\uB3D0\u0000\u0000\u0000\u0000\uD8D0\u0000" + // 15980 - 15989
                "\uF0C8\uD1A1\uD1A2\uB3CA\uB3CB\u0000\uB3CC\uB3CD\u0000\u0000" + // 15990 - 15999
                "\u9ED4\uB3C8\u0000\u0000\u0000\u0000\uB3C9\u0000\u0000\u9AFC" + // 16000 - 16009
                "\u0000\uD3B1\u0000\u0000\u0000\u0000\uDAE4\u0000\u0000\u0000" + // 16010 - 16019
                "\u9CB1\uB3C7\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u9EBD" + // 16020 - 16029
                "\uB3C4\uB3C5\u0000\u0000\uB3C6\u0000\u0000\u0000\u9BC7\u0000" + // 16030 - 16039
                "\uD5B1\u0000\u0000\u0000\uFBAF\u0000\u0000\u0000\uCBD1\uB3C2" + // 16040 - 16049
                "\uB3C3\u0000\u0000\u0000\u0000\u0000\u0000\uCCD7\uE5C2\u0000" + // 16050 - 16059
                "\u0000\uF6C9\u9AE9\u0000\u0000\u0000\u0000\u0000\u9EFD\uB7E4" + // 16060 - 16069
                "\u0000\uB7E5\uB3BD\u0000\u0000\u9ED2\uB3BE\u0000\u0000\u0000" + // 16070 - 16079
                "\uD5EA\uF1EE\u0000\u0000\u0000\u9AF7\uB3B2\uB3B3\u0000\uB3B4" + // 16080 - 16089
                "\uB3B5\uB3B6\uB3B7\uB3B8\uB3AF\uB3B0\uB3B1\u0000\u0000\u0000" + // 16090 - 16099
                "\u0000\u0000\uBCEE\uBCEF\u0000\u0000\u9CB8\u0000\u0000\u0000" + // 16100 - 16109
                "\u0000\u0000\u0000\uDAE1\u0000\uD6B6\u0000\uF3F1\u0000\u0000" + // 16110 - 16119
                "\u0000\uE3D0\u0000\u0000\uF2FB\uB3AA\uB3AB\uB3AC\u0000\uB3AD" + // 16120 - 16129
                "\u0000\u0000\uB3AE\u9ED1\uB3A9\u0000\u0000\u0000\u0000\u0000" + // 16130 - 16139
                "\u0000\uEBF4\u0000\u0000\u9BED\uB3A4\u0000\u0000\u0000\uB3A5" + // 16140 - 16149
                "\u0000\u0000\u0000\uD4A2\uCFF6\u0000\u0000\u0000\u0000\uC5B4" + // 16150 - 16159
                "\uC5B5\u0000\uC5B6\u9ED0\u0000\u0000\u0000\u0000\u0000\u0000" + // 16160 - 16169
                "\u0000\uB1CC\uB2F6\u0000\uB2F7\u0000\uB2F8\u0000\uB2F9\u0000" + // 16170 - 16179
                "\uDCFC\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uE1B0\uB2F3" + // 16180 - 16189
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uE4CB\uB2EF\u0000" + // 16190 - 16199
                "\u0000\u0000\uB2F0\u0000\u0000\u0000\uDBE0\u0000\u0000\u0000" + // 16200 - 16209
                "\u0000\u0000\u9ED3\u0000\u0000\u0000\uE6E7\u0000\u0000\uEAC7" + // 16210 - 16219
                "\u0000\uF1D8\u0000\u0000\uD8D8\u0000\u0000\uE0F2\u0000\uA5A1" + // 16220 - 16229
                "\uA5A2\uA5A3\uA5A4\uA5A5\uA5A6\uA5A7\uA5A8\uB2EB\uB2EC\u0000" + // 16230 - 16239
                "\u0000\uB2ED\u0000\u0000\u0000\uE4C5\u0000\u0000\u9DB9\u0000" + // 16240 - 16249
                "\u0000\uCDCB\u0000\u0000\u0000\u0000\u0000\u0000\uEDA8\uDEC2" + // 16250 - 16259
                "\uF6E2\uEDDC\uB2EA\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 16260 - 16269
                "\uEED2\uB2E7\uB2E8\u0000\u0000\uB2E9\u0000\u0000\u0000\u9BF7" + // 16270 - 16279
                "\uCFB0\uF7D9\uF3E6\u9BF5\u0000\uEBD9\u0000\uCFA7\uEAAF\u0000" + // 16280 - 16289
                "\u0000\u0000\u0000\uC2BC\uC2BD\u0000\u0000\uF2ED\u0000\uDBD9" + // 16290 - 16299
                "\u0000\uF0A8\u0000\u0000\uDBDF\uD3D3\uF8C7\u0000\u0000\u0000" + // 16300 - 16309
                "\u0000\uC2EE\uC2EF\u0000\u0000\u9AEE\uCACE\uF8C1\uD2B4\u0000" + // 16310 - 16319
                "\u0000\uDCB4\uB2E5\uB2E6\u0000\u0000\u0000\u0000\u0000\u0000" + // 16320 - 16329
                "\uDAE6\uF7B3\u0000\u0000\uCBB9\u0000\u0000\uEDF9\u0000\u0000" + // 16330 - 16339
                "\u0000\uD1D3\u0000\uE5F0\u0000\u0000\u0000\uD8ED\uE3C4\uF0F1" + // 16340 - 16349
                "\u0000\u0000\uD4CD\u0000\u9DAB\uF3B8\u0000\u0000\u0000\uA0CF" + // 16350 - 16359
                "\uC3E8\u0000\u0000\u0000\uC8B6\u0000\uC8B7\u0000\u0000\uDAC8" + // 16360 - 16369
                "\uDFA6\u0000\uF9B3\uF2D2\u0000\uCAC4\u9ECC\u0000\u0000\u0000" + // 16370 - 16379
                "\uB2E4\u0000\u0000\u0000\uE5C5\u0000\u0000\u0000\u0000\u0000" + // 16380 - 16389
                "\uB3A6\uB3A7\u0000\uB3A8\uB2DE\uB2DF\u0000\uB2E0\u0000\uB2E1" + // 16390 - 16399
                "\uB2E2\u0000\uD3DC\u0000\u0000\uFAFE\u9AE7\u0000\u0000\u0000" + // 16400 - 16409
                "\uDDFB\u0000\u0000\u0000\u0000\uA7A4\u0000\u0000\uA2E0\u0000" + // 16410 - 16419
                "\uA5B8\uA5B9\u0000\u0000\u0000\u0000\u0000\u0000\uF9C2\u0000" + // 16420 - 16429
                "\uEABC\uB2DC\u0000\u0000\u0000\u0000\u0000\u0000\uB2DD\uB2D9" + // 16430 - 16439
                "\uB2DA\u0000\u0000\uB2DB\u0000\u0000\u9ECB\uB2D5\uB2D6\u0000" + // 16440 - 16449
                "\u9EC9\u0000\uB2D7\u0000\u0000\u9BE1\u0000\uE2F2\u9CEB\u0000" + // 16450 - 16459
                "\u0000\u0000\uEEB9\u0000\u0000\u0000\u0000\uD5E3\uB2D4\u0000" + // 16460 - 16469
                "\u0000\u0000\u0000\u0000\u0000\u0000\uE8A8\uB2D2\u0000\u0000" + // 16470 - 16479
                "\u0000\uB2D3\u0000\u0000\u0000\u9BF4\u0000\u0000\u0000\u0000" + // 16480 - 16489
                "\u0000\uB3A2\uB3A3\u0000\u0000\uF5AF\u0000\u9CDC\u0000\u0000" + // 16490 - 16499
                "\uCEF0\u0000\uCCD0\u0000\u0000\u0000\u0000\uCFA6\u0000\u0000" + // 16500 - 16509
                "\uF7B6\u0000\u0000\u0000\u0000\uF4DE\u0000\uA5B0\uA5B1\uA5B2" + // 16510 - 16519
                "\uA5B3\uA5B4\uA5B5\uA5B6\uA5B7\u9EC8\u0000\u0000\u0000\u0000" + // 16520 - 16529
                "\u0000\u0000\u0000\uCFCE\u9EC6\u0000\u0000\u9EC7\uB2CD\uB2CE" + // 16530 - 16539
                "\u0000\u0000\uF3F9\u0000\uEDF8\u0000\uF5C7\u0000\u0000\uF6C4" + // 16540 - 16549
                "\u0000\u0000\u0000\uEEDD\uE7C4\u0000\uF1A6\uCBD5\u0000\u0000" + // 16550 - 16559
                "\u0000\u0000\u0000\u0000\uE1A3\uD2E0\u0000\uA2B6\u0000\uA1C7" + // 16560 - 16569
                "\uA1C8\u0000\u0000\u0000\u0000\uBFC0\uBFC1\u0000\u0000\uCAA9" + // 16570 - 16579
                "\u0000\u0000\u0000\u0000\u0000\u0000\uF7B0\u0000\uCCEA\uB2CC" + // 16580 - 16589
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u9BD5\uB2CA\uB2CB" + // 16590 - 16599
                "\u0000\u0000\u9EC5\u0000\u0000\u0000\uDFF8\u0000\u0000\u0000" + // 16600 - 16609
                "\u0000\u0000\uB2EE\u9ECE\u0000\u0000\uD9A1\u0000\uD8C0\uDCDB" + // 16610 - 16619
                "\u0000\u0000\uEDBD\uB2C1\u0000\uB2C2\u9EC4\uB2C3\u0000\u0000" + // 16620 - 16629
                "\u0000\uDCEA\u0000\u0000\uF0F7\u0000\uF0CA\uB2BE\u0000\u0000" + // 16630 - 16639
                "\u0000\u0000\u0000\u0000\u0000\uD7F7\uB2BC\u0000\u0000\u0000" + // 16640 - 16649
                "\u0000\uB2BD\u0000\u0000\uDEEE\u0000\u0000\u0000\u0000\u9DF2" + // 16650 - 16659
                "\u0000\uF2A3\u0000\uF7F8\u0000\u0000\u0000\u0000\uD0B3\uB2B9" + // 16660 - 16669
                "\u0000\u0000\u0000\uB2BA\u0000\u0000\u0000\uF1BB\u0000\u0000" + // 16670 - 16679
                "\u0000\u9CF2\uE9F1\uB2B5\u0000\u0000\uB2B6\u0000\uB2B7\u0000" + // 16680 - 16689
                "\u0000\uE9C8\u0000\uCBCF\u0000\uE3C9\u0000\u0000\uF6E0\u0000" + // 16690 - 16699
                "\u0000\u0000\u0000\uE9F3\uF2C3\uB2B2\uB2B3\u0000\u0000\uB2B4" + // 16700 - 16709
                "\u0000\u0000\u0000\uE2E3\uEEFB\u0000\u0000\uDFF7\uD7CA\uB2B0" + // 16710 - 16719
                "\uB2B1\u0000\u0000\u0000\u0000\u0000\u0000\uE1B8\u0000\uE8F4" + // 16720 - 16729
                "\uD3FD\uB2AB\u0000\u0000\u0000\uB2AC\u0000\u0000\u0000\u9DA3" + // 16730 - 16739
                "\u0000\u0000\u0000\u0000\u0000\uB2D8\u0000\u0000\u0000\uF1CD" + // 16740 - 16749
                "\u0000\u0000\u0000\u0000\uD2B3\uD2BF\u0000\u0000\u0000\uE3F4" + // 16750 - 16759
                "\uCDD0\u0000\u0000\u9BCE\u9EC2\u0000\u0000\u0000\u0000\u0000" + // 16760 - 16769
                "\u0000\u0000\uCBBE\uB1FE\uB2A1\u0000\uB2A2\uB2A3\uB2A4\u0000" + // 16770 - 16779
                "\u0000\uDBBC\u0000\u0000\u0000\u0000\u0000\u0000\uA2D0\u0000" + // 16780 - 16789
                "\uA2D1\u0000\uF2A2\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 16790 - 16799
                "\uFDBD\uB1FD\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uE4D5" + // 16800 - 16809
                "\uB1FA\uB1FB\u0000\u0000\uB1FC\u0000\u0000\u0000\uEAF6\u0000" + // 16810 - 16819
                "\u0000\uF6F9\u9CFA\u0000\uEEA4\u0000\u0000\u0000\u0000\uD0A4" + // 16820 - 16829
                "\u0000\u0000\u9ACF\u0000\u0000\u0000\uE1DE\uCBEE\u0000\uA2D3" + // 16830 - 16839
                "\uA2D4\u0000\u0000\u0000\uA1A5\uA1A6\u0000\uA3A1\uA3A2\uA3A3" + // 16840 - 16849
                "\uA3A4\uA3A5\uA3A6\uA3A7\uB1F7\uB1F8\u9EC1\u0000\u0000\uB1F9" + // 16850 - 16859
                "\u0000\u0000\uD9D5\u0000\u0000\uDFAA\u0000\u0000\u0000\uEAE3" + // 16860 - 16869
                "\u0000\u0000\u0000\u0000\u0000\u9CD8\u0000\u0000\u0000\uDCB9" + // 16870 - 16879
                "\u0000\u0000\u0000\uF1C0\uB1F1\u0000\u0000\u0000\uB1F2\u0000" + // 16880 - 16889
                "\uB1F3\u0000\uD3A5\u0000\u0000\u0000\u9EA2\u0000\u0000\uF7CF" + // 16890 - 16899
                "\uB1E8\uB1E9\u0000\uB1EA\u9EBF\uB1EB\uB1EC\u0000\uCFEA\u0000" + // 16900 - 16909
                "\u0000\uCFD0\u0000\uEACC\u0000\u0000\uD0F9\uECAB\uDED3\uF7E9" + // 16910 - 16919
                "\u9DE3\u0000\uF9F5\uB1E6\u0000\uB1E7\u0000\u9EBE\u0000\u0000" + // 16920 - 16929
                "\u0000\uD8DD\u0000\uCDFD\uF2AB\u0000\u0000\u9DD6\u0000\u0000" + // 16930 - 16939
                "\u0000\uD0AD\u0000\u0000\uF2C2\uF6C3\u0000\uD7D2\u0000\u0000" + // 16940 - 16949
                "\uF9A2\uB1E2\uB1E3\u0000\u0000\uB1E4\u0000\u0000\uB1E5\uB1DD" + // 16950 - 16959
                "\uB1DE\u0000\uB1DF\u0000\uB1E0\u0000\u9EBB\uB1DB\uB1DC\u9EBA" + // 16960 - 16969
                "\u0000\u0000\u0000\u0000\u0000\uBCE2\u0000\u0000\u0000\uEDE7" + // 16970 - 16979
                "\uFBB5\uF8EC\u0000\u0000\u0000\uCEF2\u0000\uD6D9\u0000\u0000" + // 16980 - 16989
                "\u9BD9\u0000\u0000\u0000\u0000\u0000\uEECA\uB1D7\uB1D8\u0000" + // 16990 - 16999
                "\u0000\uB1D9\u0000\u0000\uB1DA\uB1D5\u0000\u0000\u0000\uB1D6" + // 17000 - 17009
                "\u0000\u0000\u0000\u9DAE\u0000\uE7FB\uFCB7\uFCE4\uFBC5\uB1D1" + // 17010 - 17019
                "\uB1D2\u0000\uB1D3\u0000\u9EB8\u0000\u0000\uE7A8\u0000\u0000" + // 17020 - 17029
                "\u0000\u0000\u0000\u0000\uA1E5\uA1E4\u0000\u0000\uF2F1\u0000" + // 17030 - 17039
                "\u0000\u0000\u0000\u0000\u0000\uB8D2\u0000\u0000\uE0FA\uEEC4" + // 17040 - 17049
                "\uD9DE\u0000\u0000\u0000\u0000\uC6DB\uC6DC\u0000\u0000\uFCC1" + // 17050 - 17059
                "\u0000\uEEAB\uD4A5\u9AEA\u0000\u0000\uFDC3\u0000\u0000\u0000" + // 17060 - 17069
                "\uEBF6\uCFB2\u0000\uCDDD\u0000\u0000\u0000\u0000\u0000\u0000" + // 17070 - 17079
                "\u0000\uD9FD\uB1D0\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 17080 - 17089
                "\uD6DB\uB1CD\uB1CE\u0000\u0000\uB1CF\u0000\u0000\u0000\uDCB6" + // 17090 - 17099
                "\uE4E9\u0000\u0000\u0000\u0000\uC4BF\uC4C0\u0000\u0000\uFDC0" + // 17100 - 17109
                "\u0000\u0000\u0000\u0000\u0000\u0000\uA6A3\uA6C8\uA6C7\uA6AE" + // 17110 - 17119
                "\uB1C8\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u9BAA\uB1C5" + // 17120 - 17129
                "\uB1C6\u0000\u0000\uB1C7\u0000\u0000\u0000\uE8DA\uDAC3\uDAC4" + // 17130 - 17139
                "\uD4C5\u0000\uE7FA\uB1BA\u0000\u0000\uB1BB\uB1BC\uB1BD\uB1BE" + // 17140 - 17149
                "\u0000\uECD7\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uEAE6" + // 17150 - 17159
                "\uB1B5\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uF1E7\uB1B3" + // 17160 - 17169
                "\u0000\u0000\u0000\uB1B4\u0000\u0000\u0000\uD7B2\u0000\u0000" + // 17170 - 17179
                "\u0000\u0000\uD0FD\uB1AD\u0000\u0000\u0000\uB1AE\u0000\u0000" + // 17180 - 17189
                "\u0000\uD6B0\uF8CA\u0000\uFCFA\u0000\uD9FE\u9EB5\uB1A8\u0000" + // 17190 - 17199
                "\u9EB6\uB1A9\uB1AA\u0000\u0000\uF5D7\u0000\u0000\uD8BF\u0000" + // 17200 - 17209
                "\u0000\u0000\u9BA9\u0000\u0000\uD0C1\u0000\u0000\uDCBC\uD2B6" + // 17210 - 17219
                "\uF5D5\u0000\u0000\u0000\u0000\uC8C4\uC8C5\u0000\u0000\uCEEA" + // 17220 - 17229
                "\u0000\u0000\u0000\u0000\u0000\u0000\u9BBA\u9AF2\uEAE0\uB1A7" + // 17230 - 17239
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uD9F6\uB1A5\u9EB4" + // 17240 - 17249
                "\u0000\u0000\uB1A6\u0000\u0000\u0000\uCDBB\u0000\uEFDA\uEED8" + // 17250 - 17259
                "\u0000\uDDA7\uB0FC\u0000\u0000\u0000\uB0FD\u0000\uB0FE\u0000" + // 17260 - 17269
                "\u9DA7\u0000\u9EA7\u0000\u0000\u0000\u0000\u0000\uCFD5\uD8FD" + // 17270 - 17279
                "\u0000\u0000\uE2DE\uE1B5\u0000\u0000\uCDEF\uF1A7\uCEE5\uB0F5" + // 17280 - 17289
                "\uB0F6\u0000\uB0F7\u0000\uB0F8\uB0F9\u0000\uD0EF\u0000\u9DB2" + // 17290 - 17299
                "\uFDED\u9BFE\u0000\u0000\u0000\uD5BE\u0000\u0000\u0000\u0000" + // 17300 - 17309
                "\uA1D8\u0000\u0000\u0083\u0000\uA1AE\uA1AF\u0000\u0000\uA1B0" + // 17310 - 17319
                "\uA1B1\u0000\u0000\uF7A2\u0000\u0000\u0000\u0000\u0000\u0000" + // 17320 - 17329
                "\uD4FE\u0000\u0000\uCDB2\u0000\uDAAB\u0000\uCAA7\u0000\u0000" + // 17330 - 17339
                "\uEAAC\u0000\u0000\u0000\uCAA8\u0000\u0000\uF3DD\u0000\u0000" + // 17340 - 17349
                "\u0000\uE4DA\u0000\u0000\uFDAA\uF9E2\u0000\u0000\u0000\u0000" + // 17350 - 17359
                "\u0000\u9DDD\uD8EA\u0000\u0000\uEAE7\uDFC3\uD1D2\uCEE2\u0000" + // 17360 - 17369
                "\uD3A4\u0000\uC8F0\u0000\u0000\uC8F1\uA0FE\u0000\u0000\uC7F3" + // 17370 - 17379
                "\u0000\u0000\u0000\u0000\u0000\u0000\uF6DD\u0000\uF1A3\u0000" + // 17380 - 17389
                "\uC8F6\u0000\u0000\u0000\u0000\u0000\u0000\uCEBC\u0000\u0000" + // 17390 - 17399
                "\u0000\uD8F5\u0000\u0000\u0000\uCCCE\u0000\u0000\uC8AC\u0000" + // 17400 - 17409
                "\u0000\uC8AD\uC8AE\u0000\u0000\uC5B7\u0000\u0000\u0000\u0000" + // 17410 - 17419
                "\u0000\u0000\u9BA7\uF1CA\u0000\uCEA3\uB0F1\u9EB2\uB0F2\u0000" + // 17420 - 17429
                "\uB0F3\u0000\u0000\uB0F4\uB0ED\uB0EE\u0000\u0000\uB0EF\u0000" + // 17430 - 17439
                "\u0000\uB0F0\uB0E9\u0000\u0000\u0000\uB0EA\u0000\u0000\u0000" + // 17440 - 17449
                "\uCAF2\uDFA4\u0000\u0000\uD4C4\u0000\uF4B7\uFDC2\uFCB0\u0000" + // 17450 - 17459
                "\uFDEC\uCAE2\u0000\u0000\uD7C4\u0000\u0000\u0000\u0000\u0000" + // 17460 - 17469
                "\u0000\uE7E2\u0000\u0000\uDDDA\u0000\u0000\u0000\u0000\u0000" + // 17470 - 17479
                "\u0000\uE3CE\u0000\u0000\uE3A1\u0000\u0000\uE8E3\u0000\u0000" + // 17480 - 17489
                "\uF3AB\uB0E2\uB0E3\u0000\uB0E4\uB0E5\uB0E6\u0000\u0000\uEEC9" + // 17490 - 17499
                "\u0000\u0000\u0000\uE2DD\u0000\u0000\uE9E0\u0000\u9BB0\u0000" + // 17500 - 17509
                "\uD0D8\uFCA2\uD4BE\uB0E1\u0000\u0000\u0000\u0000\u0000\u0000" + // 17510 - 17519
                "\u0000\uE4E1\uB0DC\uB0DD\uB0DE\u0000\uB0DF\u0000\u0000\uB0E0" + // 17520 - 17529
                "\uB0DA\uB0DB\u0000\u0000\u0000\u0000\u0000\u0000\uDDC9\u0000" + // 17530 - 17539
                "\u0000\uD4D3\uB0D5\u0000\u0000\u9EB1\uB0D6\u0000\u0000\u0000" + // 17540 - 17549
                "\uF7EC\u0000\u0000\u0000\uE8F6\u0000\uCBD3\u0000\u0000\u9AD7" + // 17550 - 17559
                "\uE0BC\u0000\uF4CA\uD4FA\uB0CB\uB0CC\u0000\uB0CD\uB0CE\uB0CF" + // 17560 - 17569
                "\uB0D0\u9EB0\uB0C9\u9EAF\uB0CA\u0000\u0000\u0000\u0000\u0000" + // 17570 - 17579
                "\uBCD2\uBCD3\uBCD4\u0000\uD3D0\u0000\u0000\u0000\u0000\u0000" + // 17580 - 17589
                "\u0000\u0000\uDFC1\uB0C5\uB0C6\u0000\u0000\uB0C7\u0000\u0000" + // 17590 - 17599
                "\uB0C8\uB0C3\u0000\u0000\u0000\uB0C4\u0000\u0000\u0000\uCCAA" + // 17600 - 17609
                "\u0000\u0000\uF0C3\uCCD6\u0000\uF4FA\u0000\u0000\u0000\u0000" + // 17610 - 17619
                "\uCDD6\uFCF6\u0000\uA1A9\u0000\u0000\u0000\uA1AA\u0000\u0000" + // 17620 - 17629
                "\u0000\uDBF2\u0000\u0000\u0000\u0000\uC5F5\uC5F6\u0000\u0000" + // 17630 - 17639
                "\uDDC3\u0000\uF9DF\u0000\u0000\u0000\u0000\uC1DC\uC1DD\u0000" + // 17640 - 17649
                "\uC1DE\uB0BF\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uEDFE" + // 17650 - 17659
                "\uB0BC\uB0BD\u0000\u0000\uB0BE\u0000\u0000\u0000\uD2B5\u0000" + // 17660 - 17669
                "\u0000\u0000\uD3D5\u0000\uF9EB\uEEA3\u0000\u0000\u0000\u0000" + // 17670 - 17679
                "\u0000\u0000\uD1BE\u0000\u0000\uF6B9\u0000\u0000\u0000\u0000" + // 17680 - 17689
                "\u0000\u0000\uE9B3\u0000\u0000\uCDDF\u0000\u0000\uF5CB\u0000" + // 17690 - 17699
                "\uE4F0\uCBAB\uB0BA\uB0BB\u0000\u0000\u0000\u0000\u0000\u0000" + // 17700 - 17709
                "\uE3E5\u0000\uCBC5\uEAB4\uB0B5\u0000\u0000\u0000\uB0B6\u0000" + // 17710 - 17719
                "\u0000\u0000\uFDCD\u0000\u0000\u0000\uF3B6\u0000\uE4EE\uF9A1" + // 17720 - 17729
                "\u0000\u0000\uFBEF\u0000\u0000\u0000\uEFA8\u0000\u0000\u0000" + // 17730 - 17739
                "\uEEB4\uB0A8\uB0A9\uB0AA\uB0AB\uB0AC\uB0AD\uB0AE\uB0AF\uB0A5" + // 17740 - 17749
                "\uB0A6\uB0A7\u9EAE\u0000\u0000\u0000\u0000\uE0C1\uEFDB\u0000" + // 17750 - 17759
                "\u0000\uF0E9\uB0A1\uB0A2\u9EAD\u0000\uB0A3\u0000\u0000\uB0A4" + // 17760 - 17769
                "\uDBC2\u0000\u0000\u0000\u0000\uCAFE\u0000\u0000\uF4EA\u0000" + // 17770 - 17779
                "\u0000\u0000\uCEB9\u0000\u0000\uD4AA\u0000\uE5CC\u0000\u0000" + // 17780 - 17789
                "\u0000\u0000\uC8B8\uC8B9\u0000\u0000\uF7E5\u0000\u0000\u0000" + // 17790 - 17799
                "\uCCB2\u0000\u0000\uD3BF\u0000\u0000\u0000\u0000\u0000\u0000" + // 17800 - 17809
                "\uF0E7\uE2CC\u0000\uF9E0\u0000\u0000\u0000\u0000\uECD6\u0000" + // 17810 - 17819
                "\u0000\uD3E0\u0000\uE4BF\u0000\uFBC0\u0000\uDABE\uE0A9\u0000" + // 17820 - 17829
                "\u0000\u0000\u0000\u0000\u0000\u0000\uCCC6\uDCAF\u0000\u0000" + // 17830 - 17839
                "\u0000\u0000\u0000\uF0A3\u0000\uEDAA\u0000\u0000\uF2A1\uCEE1" + // 17840 - 17849
                "\u0000\u0000\u0000\uD4AB\uCAB3\uCDA6\u0000\uCDC3\uD3DA\u0000" + // 17850 - 17859
                "\u0000\u0000\u0000\u0000\u0000\u9CC5\uD9F9\u0000\u0000\uD3EA" + // 17860 - 17869
                "\uF5F5\u9CEC\uEFC7\u0000\uDCFB\u0000\u0000\u0000\u0000\u0000" + // 17870 - 17879
                "\u0000\u0000\uF8B5\uFDD3\uEBED\uD6DC\u0000\u0000\u0000\u0000" + // 17880 - 17889
                "\u0000\uBCB6\uBCB7\u0000\uBCB8\uCDDC\uD9F7\u0000\u0000\u0000" + // 17890 - 17899
                "\u0000\u0000\u0000\u9DE4\uF3A3\u0000\uD3EC\uE4E5\u0000\u0000" + // 17900 - 17909
                "\u0000\u0000\u0000\u0000\u0000\uE2F5\u9CC0\uE4BC\u0000\u0000" + // 17910 - 17919
                "\u0000\u0000\u0000\u0000\uFCC6\u0000\u0000\u0000\uDBC9\u0000" + // 17920 - 17929
                "\u0000\u0000\uE4FA\u0000\uEEBA\u0000\u0000\u0000\u9AE6\u0000" + // 17930 - 17939
                "\uF8D3\u0000\uACEA\uACEB\uACEC\uACED\uACEE\uACEF\uACF0\uACF1" + // 17940 - 17949
                "\uE4CA\u0000\uDCE1\u9BFD\u0000\uF9C8\u0000\u0000\uD7E9\uEDF6" + // 17950 - 17959
                "\u0000\u0000\u0000\uDEED\u0000\uF1B2\u0000\uF1B1\u0000\u0000" + // 17960 - 17969
                "\u0000\u0000\u0000\uF9CD\u0000\u0000\u0000\uECB9\u0000\u0000" + // 17970 - 17979
                "\u0000\u0000\uC8D1\uC8D2\u0000\u0000\uE4DB\u0000\uE1FB\uCBA2" + // 17980 - 17989
                "\u0000\u0000\u0000\uE9E3\u0000\uEDCB\uCFE4\u0000\uACE2\uACE3" + // 17990 - 17999
                "\uACE4\uACE5\uACE6\uACE7\uACE8\uACE9\uCCF4\u0000\u0000\u0000" + // 18000 - 18009
                "\u0000\u0000\u0000\u0000\uD4F8\u9BB9\u0000\uE2D1\u0000\u0000" + // 18010 - 18019
                "\u0000\u0000\u9EA4\uCDD4\u0000\u0000\u0000\u0000\u0000\u0000" + // 18020 - 18029
                "\u0000\uE6E3\u9BEC\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 18030 - 18039
                "\uCDAC\uFAB5\u0000\u0000\u0000\u9AB1\u0000\u0000\u0000\uD3BC" + // 18040 - 18049
                "\u0000\u0000\u0000\uCAF0\u0000\uEFD0\u0000\uCDB1\u0000\u0000" + // 18050 - 18059
                "\u0000\u0000\u0000\uDDDF\u0000\u0000\u0000\uDAF2\u0000\u0000" + // 18060 - 18069
                "\u0000\u0000\uA0F9\uC8A2\u0000\u0000\uF6A6\u0000\u0000\u0000" + // 18070 - 18079
                "\u0000\u0000\u0000\uEBD7\u0000\u0000\uE0DA\u0000\u0000\u0000" + // 18080 - 18089
                "\uEEF7\u0000\u0000\uDFA3\u0000\u0000\u0000\u0000\u0000\u0000" + // 18090 - 18099
                "\u9BB1\u0000\u0000\uFDDF\u0000\u0000\u0000\u0000\u0000\u0000" + // 18100 - 18109
                "\uE3B2\u0000\u0000\uCBAA\u0000\u0000\u0000\u0000\u9BB4\u0000" + // 18110 - 18119
                "\uACDA\uACDB\uACDC\uACDD\uACDE\uACDF\uACE0\uACE1\uCDE9\u0000" + // 18120 - 18129
                "\u0000\u0000\u0000\u0000\u0000\u0000\uCDDB\uD8E9\u0000\u0000" + // 18130 - 18139
                "\uF8FE\u0000\uCFCC\u0000\u0000\uE2BC\u0000\u0000\uFCED\uECE0" + // 18140 - 18149
                "\uD2FE\u0000\uFDE5\uF6A3\u0000\uD9FC\uFDA9\u0000\uE7EE\u0000" + // 18150 - 18159
                "\uACD1\uACD2\uACD3\uACD4\uACD5\uACD6\uACD8\uACD9\uD4F9\u0000" + // 18160 - 18169
                "\u0000\u0000\u0000\u0000\uF5E2\uE1D3\uDCC0\u0000\u0000\u0000" + // 18170 - 18179
                "\u0000\u0000\uD1C8\uD1C9\uF1D2\uD2CC\uCFCB\u0000\u0000\uCABD" + // 18180 - 18189
                "\u0000\u0000\uD8C9\u0000\u0000\u0000\u0000\u0000\u0000\uA9E7" + // 18190 - 18199
                "\uA9E8\uA9E9\uA9EA\uFBB0\u0000\u0000\u0000\uD8A9\uE5DF\uF9A7" + // 18200 - 18209
                "\u0000\uF8C5\u0000\u0000\u0000\u0000\u0000\uDCFA\u0000\uACBA" + // 18210 - 18219
                "\uACBB\uACBC\uACBD\uACBE\uACBF\uACC0\uACC1\uCEBD\u0000\u0000" + // 18220 - 18229
                "\u0000\u0000\u0000\u0000\u0000\uE0A4\uDCBF\u0000\u0000\u0000" + // 18230 - 18239
                "\u0000\u0000\u0000\u0000\uD0DC\uE6AE\u0000\u0000\u0000\u0000" + // 18240 - 18249
                "\u0000\uEFB6\u0000\uF7CE\uFABE\u0000\u0000\u0000\u0000\u0000" + // 18250 - 18259
                "\u0000\uF5C5\uEEE0\u0000\uACB2\uACB3\uACB4\uACB5\uACB6\uACB7" + // 18260 - 18269
                "\uACB8\uACB9\uF3C9\u0000\u0000\uE4BB\u0000\u0000\u0000\u0000" + // 18270 - 18279
                "\u9ADF\uD6BB\uDED6\u0000\u0000\uECBE\u0000\u0000\u0000\uE5B4" + // 18280 - 18289
                "\uCDC8\uEEC8\uF9A6\u0000\u0000\u0000\u0000\u0000\u0000\uDFBD" + // 18290 - 18299
                "\u9BF0\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uDCDC\uEAC3" + // 18300 - 18309
                "\u0000\uEFB4\u0000\u0000\u0000\uD7BE\u0000\uF9EA\uD1CE\uEED4" + // 18310 - 18319
                "\u0000\uD4D2\uD9A3\uFDA8\uD7D9\uCCF2\uF7DD\u0000\uDEBA\u0000" + // 18320 - 18329
                "\u0000\u0000\u0000\uF6E1\u0000\u0000\u0000\u0000\uC3BC\uC3BD" + // 18330 - 18339
                "\u0000\u0000\uEABD\uE6FE\u9AFB\uF7C4\uF5AD\u0000\uD9E0\uFAFA" + // 18340 - 18349
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uD7EA\uD6C5\u0000" + // 18350 - 18359
                "\u0000\u0000\u0000\u0000\u0000\u0000\uD5C5\uE7E8\uE8D7\uDAF8" + // 18360 - 18369
                "\uD4CB\u0000\u0000\u0000\uF7F6\uE2CE\u0000\uE9F5\u0000\uE1EB" + // 18370 - 18379
                "\u0000\u0000\u0000\uFCE1\uEDB0\uFDD1\uF6BB\u0000\u0000\uD0D9" + // 18380 - 18389
                "\u0000\u0000\uDDD2\uF7F4\uE7DC\uE4A5\uFBE1\uFAED\uF0A2\uCCF1" + // 18390 - 18399
                "\u0000\uFAA3\uE2F7\u0000\uDEC9\u0000\u0000\u0000\u0000\u0000" + // 18400 - 18409
                "\u0000\u0000\uDBD7\uCAEA\u0000\u0000\uCFD4\u0000\uF8BD\u0000" + // 18410 - 18419
                "\u0000\uDDB3\uD4EC\u0000\u0000\uF2B9\u0000\uDFB7\uCFD3\u0000" + // 18420 - 18429
                "\u0000\u0000\u0000\u0000\u9DDB\u0000\uF7BB\uF2EA\uDEC8\uE9D3" + // 18430 - 18439
                "\u0000\u0000\u0000\u0000\uC1D6\uC1D7\u0000\u0000\uDFC6\u0000" + // 18440 - 18449
                "\u0000\u0000\u0000\u0000\u0000\uE3DA\u0000\uFCD9\u9DD1\u0000" + // 18450 - 18459
                "\u0000\u0000\u0000\u0000\u0000\u0000\uD9AD\uD6C4\u9CCA\u0000" + // 18460 - 18469
                "\u0000\u0000\u0000\u0000\u0000\uE5F2\u0000\u0000\uD0F4\uDFAC" + // 18470 - 18479
                "\u0000\uD6DA\u0000\u0000\u0000\u0000\u0000\uBBCE\u0000\u0000" + // 18480 - 18489
                "\u0000\uFCE0\uD7C8\uFDAD\u0000\u0000\u0000\uECE2\u0000\u9CFC" + // 18490 - 18499
                "\u0000\u0000\uF3EC\u0000\u0000\u0000\u0000\uDEA1\u0000\uE9D1" + // 18500 - 18509
                "\uF3A9\uD0E0\uE9D2\u0000\uDAE3\u0000\u0000\uE1B4\u0000\u0000" + // 18510 - 18519
                "\u0000\u0000\uF4D3\u0000\uACAA\uACAB\uACAC\uACAD\uACAE\uACAF" + // 18520 - 18529
                "\uACB0\uACB1\uE2CD\u0000\u0000\u0000\u9CAE\u0000\uEFFD\uF2E8" + // 18530 - 18539
                "\uDDD4\u0000\uEAA3\u0000\u0000\u0000\uD6C3\uD6F4\uE9EB\uE9EC" + // 18540 - 18549
                "\uE0E4\u0000\u0000\u0000\u0000\uDAA7\uEDCD\uE4D2\u0000\u0000" + // 18550 - 18559
                "\uEAA9\uE4BA\uF3A2\uCDD2\uE2CB\u0000\uFACF\u0000\u0000\u0000" + // 18560 - 18569
                "\u0000\u0000\u9FC9\u0000\u0000\u0000\uFBA1\u0000\u0000\u0000" + // 18570 - 18579
                "\uE5E9\uE9EE\uE4F6\uD0C0\u0000\uF0B7\uEEA1\u0000\u0000\u0000" + // 18580 - 18589
                "\uCBAD\u0000\uF9B0\u0000\u0000\u0000\uE9FE\u0000\u0000\u0000" + // 18590 - 18599
                "\u0000\uE4ED\u0000\u0000\u0000\u0000\uA0AF\uC1C5\u0000\uC1C6" + // 18600 - 18609
                "\uD7C1\u0000\u0000\u0000\u0000\uE5D5\u0000\u0000\uE2BB\u0000" + // 18610 - 18619
                "\uF7AD\u0000\u0000\u0000\uF8E1\uEBE4\u0000\u0000\uF2E7\u0000" + // 18620 - 18629
                "\uD7D5\uD4B6\uF9E8\uF9DA\u0000\u0000\u0000\u0000\u0000\u0000" + // 18630 - 18639
                "\u0000\uFDD0\uF6ED\u0000\uF9AE\u0000\uDDBE\u0000\u0000\u0000" + // 18640 - 18649
                "\uF1B7\uEEF8\u0000\u0000\u0000\uD9D9\u9CCB\u0000\uF8A1\u0000" + // 18650 - 18659
                "\u0000\u0000\uE8D6\u0000\uF6B2\u0000\u0000\u0000\u0000\uCFF0" + // 18660 - 18669
                "\uF9BD\u0000\uACA1\uACA2\uACA3\uACA4\uACA5\uACA6\uACA8\uACA9" + // 18670 - 18679
                "\uD0B1\u9BC5\u0000\u0000\u0000\uD5EF\u0000\u0000\uCEDD\uEBC0" + // 18680 - 18689
                "\u0000\uFDA2\u0000\u0000\u0000\uEEED\u0000\u0000\u0000\uECEB" + // 18690 - 18699
                "\uDEC5\uCBA6\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uD5A1" + // 18700 - 18709
                "\uDAA6\u0000\u0000\uE0EC\u0000\u0000\u0000\u0000\uD3F7\u0000" + // 18710 - 18719
                "\u0000\u0000\u0000\uC2EB\uA0C3\u0000\uC2EC\u9BF8\u0000\u9AF6" + // 18720 - 18729
                "\u0000\u0000\u0000\u0000\u0000\uBBAD\uBBAE\u0000\uBBAF\uF7A1" + // 18730 - 18739
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uEECB\uF1A4\u9AEC" + // 18740 - 18749
                "\u0000\u0000\u0000\u0000\u0000\u0000\uF5CD\u0000\uF1F2\uFAC7" + // 18750 - 18759
                "\uECF0\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uEBFB\uE7CC" + // 18760 - 18769
                "\u0000\uD6A8\uCEA7\u0000\uD4B5\u0000\u0000\uCCB7\uDBB8\u0000" + // 18770 - 18779
                "\u0000\u0000\u0000\uD0E9\uD9E1\u0000\u0000\uE0B8\u0000\u0000" + // 18780 - 18789
                "\uCDD1\uF3B9\uEFFC\uD1C4\uEFB1\u0000\uD1C5\u0000\uD0DE\u0000" + // 18790 - 18799
                "\uD7D8\u0000\uFDA7\u0000\u0000\u0000\u0000\uEAAB\uF5DF\u0000" + // 18800 - 18809
                "\uEEB6\u0000\u0000\u0000\uE2F6\uD3CA\uF5DE\u0000\u0000\u0000" + // 18810 - 18819
                "\u0000\u0000\u0000\u0000\uD9AB\uCBEA\u0000\u0000\u0000\uCBBC" + // 18820 - 18829
                "\u0000\u0000\u0000\uE5F5\u0000\u0000\u0000\u0000\u0000\uB1D4" + // 18830 - 18839
                "\u0000\u0000\u0000\uD4E5\u0000\u0000\u0000\uF9C3\uD9AF\u0000" + // 18840 - 18849
                "\u0000\u0000\uF9E7\u0000\u0000\u0000\uDEAE\u0000\u0000\u0000" + // 18850 - 18859
                "\u0000\u0000\uB1AB\uB1AC\u0000\u0000\uCDC6\uF2B6\u0000\u0000" + // 18860 - 18869
                "\uDDFE\u0000\u0000\uD4A9\u0000\u0000\u0000\u0000\uCDC2\uE7DA" + // 18870 - 18879
                "\uEBDE\u0000\u0000\uF5C8\u0000\uD4DE\u0000\u0000\uEBBF\u0000" + // 18880 - 18889
                "\uD7CE\uD1BF\u0000\u0000\u0000\uD0D1\uCBBF\u0000\uEDA4\u0000" + // 18890 - 18899
                "\u0000\uFADF\u0000\u0000\u0000\u0000\u0000\u0000\uE4BD\u0000" + // 18900 - 18909
                "\u0000\uDBE1\u0000\u0000\uE5C9\u0000\uEDB4\u0000\uECD4\uEACB" + // 18910 - 18919
                "\u0000\u0000\uCABF\uD5B0\u0000\uCFE9\u9AC4\u0000\u0000\u0000" + // 18920 - 18929
                "\u0000\u0000\u9BC0\u0000\uE0D9\u0000\u0000\u0000\u0000\u0000" + // 18930 - 18939
                "\u0000\uD9D6\uCBA5\u0000\u0000\u0000\u0000\uCBE9\u0000\u0000" + // 18940 - 18949
                "\uCEEE\u0000\u9BCD\uECCF\u0000\u0000\u0000\uE7D1\uD2AC\u0000" + // 18950 - 18959
                "\uCEF9\u0000\u0000\uE0FD\u0000\u0000\uD8F8\u0000\u0000\u0000" + // 18960 - 18969
                "\uBDD7\uBDD8\uBDD9\u0000\u0000\uD6A1\uFDBF\u0000\uFCD3\u0000" + // 18970 - 18979
                "\uEFA1\u0000\uEFBF\u0000\u0000\u0000\u0000\u0000\uCECF\u0000" + // 18980 - 18989
                "\uA5F7\uA5F8\u0000\u0000\u0000\u0000\u0000\u0000\uCCDD\u0000" + // 18990 - 18999
                "\u0000\u9CE4\u0000\uFDDE\uCAC0\u0000\u0000\u0000\uD9C3\uD0E8" + // 19000 - 19009
                "\u0000\u0000\u0000\uE0B4\u0000\u0000\u0000\u0000\uC7FD\u0000" + // 19010 - 19019
                "\u0000\u0000\uD7BC\uCCE3\u0000\u0000\uE6DB\uCCA2\uF7FE\uDFBC" + // 19020 - 19029
                "\u0000\u9DD0\u0000\u0000\uEBCD\uEFF9\u0000\u0000\u0000\uDDBC" + // 19030 - 19039
                "\uF6DC\u0000\u0000\uF8BB\u0000\uE8D1\u0000\u0000\u0000\u0000" + // 19040 - 19049
                "\uECF2\u0000\u0000\u0000\u0000\uC0CC\uC0CD\u0000\u0000\uF2D7" + // 19050 - 19059
                "\u0000\uCAF8\uDAEF\u9AC2\u0000\uD6D4\uD7ED\uD1D1\u0000\u0000" + // 19060 - 19069
                "\u0000\u0000\u0000\uE1F2\uE5D4\u0000\u0000\u0000\u0000\u0000" + // 19070 - 19079
                "\u0000\uF3FA\u9DFD\u0000\uE1A5\u0000\u0000\u0000\u0000\u0000" + // 19080 - 19089
                "\uBAC4\u0000\u0000\u0000\uD8DA\u9EA5\u0000\u0000\u0000\u0000" + // 19090 - 19099
                "\uC2D6\u0000\u0000\u0000\uECBC\u0000\u0000\uE5AD\u0000\uE7ED" + // 19100 - 19109
                "\uFDC1\uDAE2\u0000\u0000\uD8B3\u0000\u0000\uDCE6\u0000\u0000" + // 19110 - 19119
                "\uDED2\u0000\u0000\uEDE2\uDFAB\u0000\u0000\u0000\u0000\u0000" + // 19120 - 19129
                "\u0000\u0000\uD6A4\uDDBB\u0000\u0000\u0000\u0000\uCEAC\u0000" + // 19130 - 19139
                "\u0000\uE6BA\u0000\u0000\uCDA9\u0000\u0000\u0000\uA1F8\uA1F9" + // 19140 - 19149
                "\u0000\u0000\uA1F6\uA1F7\uEED0\u0000\u0000\u0000\u0000\u0000" + // 19150 - 19159
                "\u0000\u0000\uEEE1\uF7C6\uCFC8\u0000\u0000\u0000\uE1D0\u0000" + // 19160 - 19169
                "\u0000\uE3B1\uFCEB\uCDA8\u0000\uCCB6\u0000\u0000\uEBF7\u0000" + // 19170 - 19179
                "\u0000\u0000\u0000\u0000\u0000\uF0E8\u0000\uDDC0\uF5BE\u0000" + // 19180 - 19189
                "\uDEF7\u0000\u0000\u0000\u0000\uCAFB\uD8B1\u0000\uDCAB\u0000" + // 19190 - 19199
                "\u0000\u0000\u0000\uD5A4\uE9AD\uD8E4\uFAB3\uE2C5\uFCBD\u0000" + // 19200 - 19209
                "\u0000\uECC4\uE0D4\u0000\uEBB6\u0000\uD7A1\uCBE8\u0000\uF9AD" + // 19210 - 19219
                "\u9CDD\uEEEA\u0000\u0000\u0000\uF0E4\uF3B4\uD4EE\uEAC0\uE1CF" + // 19220 - 19229
                "\u0000\uCCBA\u0000\u0000\u0000\u0000\u9BE5\u0000\uF6E6\u0000" + // 19230 - 19239
                "\u0000\uDBE5\u0000\uDDDE\u0000\u0000\uD9F0\uE9A3\uF9C6\uFCDA" + // 19240 - 19249
                "\u0000\uD4B3\uD3B9\uEADE\u0000\u0000\uF0FD\u0000\u0000\u0000" + // 19250 - 19259
                "\u0000\u0000\uD7AC\uECEF\u0000\u0000\u0000\uF9BA\u0000\uEBB5" + // 19260 - 19269
                "\u0000\uCFA1\uE4A8\u0000\uF4B6\uECFE\u0000\u0000\uE3AE\uF0E3" + // 19270 - 19279
                "\uF1E4\uDCF1\uD6A7\u0000\u0000\u0000\u0000\uD0F5\u0000\u0000" + // 19280 - 19289
                "\uE8ED\uD0D2\uF5EF\uCFC7\u0000\u0000\uD4B2\uCCEF\u0000\uD4E8" + // 19290 - 19299
                "\uFBAD\u0000\u0000\uF8E7\u0000\uE1CE\u0000\uF7E2\uF7DC\uE1EA" + // 19300 - 19309
                "\uCEC1\uD4B1\u0000\uFDB1\uE6BD\u0000\uEDDD\uCEC4\u0000\uCBA1" + // 19310 - 19319
                "\u0000\u0000\u0000\u0000\uC1B5\u0000\u0000\u0000\uF4D7\uCCA1" + // 19320 - 19329
                "\u9ABB\u0000\uCFBA\u9BD4\uEEE9\u9AD9\u0000\u0000\uF5DA\u0000" + // 19330 - 19339
                "\u0000\uF2DB\uE4FC\u0000\u0000\u0000\u0000\u0000\uB6CF\u0000" + // 19340 - 19349
                "\u0000\u0000\uA1EC\uA1ED\u0000\u0000\u0000\u0000\uBFE4\uBFE5" + // 19350 - 19359
                "\u0000\u0000\uF1F7\u0000\u0000\u0000\uE8B8\u0000\u0000\uDEB4" + // 19360 - 19369
                "\u0000\u0000\u0000\u0000\u0000\u0000\uFBE2\u0000\uCDD3\uE2FB" + // 19370 - 19379
                "\u0000\uCCA6\u0000\u0000\u0000\u0000\uDABB\uF2E3\uE9B4\uD2DC" + // 19380 - 19389
                "\u0000\u0000\u0000\u0000\u0000\uB9F6\uB9F7\u0000\u0000\uCBB5" + // 19390 - 19399
                "\uD8D1\u0000\uF4CE\uF3F7\u0000\u0000\uDCBA\u0000\u9DD9\uCCB4" + // 19400 - 19409
                "\u0000\u0000\u0000\uB2FA\uB2FB\uB2FC\u0000\uB2FD\uDCA9\u0000" + // 19410 - 19419
                "\u0000\u0000\u0000\uDEF6\u9BD0\uDCAA\uE2C3\uDCDE\u0000\uDCDF" + // 19420 - 19429
                "\u0000\u0000\uEFAD\uE6AB\uF5EE\u0000\u0000\uCABB\u0000\u0000" + // 19430 - 19439
                "\uE3DC\u0000\uDCD3\u0000\u0000\u0000\u0000\uDDE2\uFBF9\uDDC1" + // 19440 - 19449
                "\uCFC6\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uF6C5\uF4B2" + // 19450 - 19459
                "\u0000\u0000\u0000\u9DBA\u0000\u0000\u0000\uE7F2\uEDDF\u0000" + // 19460 - 19469
                "\u0000\uCACB\u0000\uFDD6\u0000\u0000\u0000\u0000\uF8D1\u0000" + // 19470 - 19479
                "\uF8D2\uD4B0\uF3B2\uFBB7\u0000\u0000\u0000\u0000\u0000\uB9E3" + // 19480 - 19489
                "\uB9E4\u0000\uB9E5\uEBB2\u0000\u0000\u0000\u0000\uF1A2\u9DB0" + // 19490 - 19499
                "\u0000\uCFE8\u0000\uEDC3\uD0B2\u0000\u0000\uCEFE\uDAA8\uF4C2" + // 19500 - 19509
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u9AD6\uCEA5\u0000" + // 19510 - 19519
                "\u9ACE\u0000\u0000\u0000\u0000\uD6D8\uF5D9\u0000\u0000\u0000" + // 19520 - 19529
                "\u0000\u0000\u0000\u0000\u9BA5\uF1CB\u0000\u0000\uD0AF\uDDB9" + // 19530 - 19539
                "\u0000\u0000\uD1C3\uF1FC\u0000\uF3C7\u9CBF\u0000\uE0EB\u0000" + // 19540 - 19549
                "\u0000\uCCB5\u0000\u0000\u0000\u0000\u0000\uCFBD\uDBD3\u0000" + // 19550 - 19559
                "\uFAE7\uD8E3\uF4C1\u0000\uDDB7\u0000\uCAEB\uD9E2\u0000\uFDB2" + // 19560 - 19569
                "\u0000\uE3AD\uD6CC\uD9B4\uCAB9\u0000\uEEE4\u0000\u0000\u0000" + // 19570 - 19579
                "\u0000\u0000\uB9C2\u0000\u0000\u0000\uE1F7\u0000\u0000\u0000" + // 19580 - 19589
                "\u0000\u0000\uDABD\u0000\u0000\u0000\uDAB7\u0000\u0000\u0000" + // 19590 - 19599
                "\u0000\uA1C9\u0000\u0000\u0000\u0000\uBFD6\uBFD7\u0000\u0000" + // 19600 - 19609
                "\uF7D6\uDEEA\uCBB4\u0000\u0000\uEFBE\u0000\uCAA5\u0000\u0000" + // 19610 - 19619
                "\uD6AB\uD0C2\u0000\u0000\u0000\uEFEC\u0000\u0000\u0000\u0000" + // 19620 - 19629
                "\uC7DC\uC7DD\u0000\uC7DE\uF9C5\uDDD3\uD6F1\uECFC\uFCF0\u0000" + // 19630 - 19639
                "\u0000\uEDC0\uD3E8\u0000\u0000\uDEA8\uF4E4\uECC2\u0000\uD9F5" + // 19640 - 19649
                "\uE1AE\u0000\u0000\uECC3\uCFFE\u0000\uF8BF\uD8E2\uFCA7\uF7FC" + // 19650 - 19659
                "\uF7B1\uCEBB\uF4A1\u0000\u0000\uEECD\uDDB6\uEEAF\uCDF8\u0000" + // 19660 - 19669
                "\u0000\u0000\u0000\uDEB8\uD1C2\u0000\uF9A5\u0000\uE8D5\u0000" + // 19670 - 19679
                "\u0000\u0000\uE1F6\uDECC\u0000\u0000\uFCDE\u0000\uDBF9\uD7B1" + // 19680 - 19689
                "\u0000\u0000\u0000\uCBFC\u0000\u0000\uCDFB\uF6D6\u0000\uE7F5" + // 19690 - 19699
                "\uE8EF\uE3F9\uD2BB\uE2C2\u0000\uF3D8\uE5D3\u0000\u0000\uF3D9" + // 19700 - 19709
                "\u0000\uCFE7\uF3CB\uEDA9\uCABE\u0000\u0000\u0000\u0000\uC0F7" + // 19710 - 19719
                "\u0000\u0000\u0000\uE0FC\uD4A8\u0000\uEDD3\uD8EF\uD4C1\u0000" + // 19720 - 19729
                "\u0000\u0000\u0000\u0000\u0000\u0000\u9DCA\uECA1\u0000\u0000" + // 19730 - 19739
                "\u0000\uCCB9\u0000\u0000\uFBDE\uE3DB\u0000\uD3C9\u0000\uDCCF" + // 19740 - 19749
                "\u0000\u0000\u0000\uE7F0\u0000\uD0EE\u0000\u0000\uF3AA\uD9C8" + // 19750 - 19759
                "\u0000\u0000\uEEE3\uD7BD\u0000\u0000\u0000\uF4C9\u0000\u0000" + // 19760 - 19769
                "\u0000\u0000\u0000\uCDAE\u0000\u0000\u0000\u9CCD\u0000\u0000" + // 19770 - 19779
                "\u0000\u0000\uC8E2\u0000\u0000\uC8E3\uE9AA\u0000\u0000\u0000" + // 19780 - 19789
                "\u0000\u0000\u0000\u0000\uCBCD\uDACD\u0000\u0000\u0000\uF9CC" + // 19790 - 19799
                "\u0000\uE1DA\uDBBF\uD9C7\uE4D7\uEADD\u0000\uD4F7\u0000\u0000" + // 19800 - 19809
                "\u0000\uD5E5\u0000\u0000\u0000\u0000\u0000\u9DE5\u0000\u0000" + // 19810 - 19819
                "\u0000\uCAE5\u0000\u0000\u0000\uDCA1\uF0B3\u0000\uE5EC\u0000" + // 19820 - 19829
                "\u0000\u0000\uD1E7\u0000\uD3F0\u9DC3\u0000\u0000\u0000\u0000" + // 19830 - 19839
                "\uF0A4\uE1EC\uE2C1\u0000\uCEA4\u0000\u0000\u0000\u0000\u0000" + // 19840 - 19849
                "\uB8EF\u0000\u0000\u0000\uDACF\u0000\uDCD4\u0000\uDCA6\u0000" + // 19850 - 19859
                "\uE7D4\u0000\uCACA\u0000\u0000\u0000\uD9FB\u0000\uA5F0\uA5F1" + // 19860 - 19869
                "\u0000\uA5F2\uA5F3\uA5F4\uA5F5\uA5F6\uFCEF\u0000\uE0E3\u0000" + // 19870 - 19879
                "\u0000\u0000\u0000\u0000\uB8E2\uB8E3\u0000\uB8E4\uE1A4\uCDAB" + // 19880 - 19889
                "\u0000\uD9F4\uE8A6\uCDCE\uE1E9\u0000\uD3EF\u0000\u0000\uECD3" + // 19890 - 19899
                "\u0000\u0000\uDDC2\uEFB7\uEBAF\u0000\u0000\u0000\u0000\u0000" + // 19900 - 19909
                "\uE5DE\u0000\uF4C8\uE8EA\uF5F3\u0000\u0000\uF9DE\u0000\u0000" + // 19910 - 19919
                "\uFAA9\u0000\uE1DD\u0000\u0000\u0000\u0000\uC2E8\u0000\u0000" + // 19920 - 19929
                "\u0000\uE3ED\u0000\uE8C2\u0000\uEDF5\uFDFE\uFCA5\uFAB1\uDFD9" + // 19930 - 19939
                "\u0000\uE0D2\u0000\u0000\uE2B6\u0000\u0000\u0000\u0000\uEFF1" + // 19940 - 19949
                "\u0000\uFCC5\uCBC2\u0000\u0000\u0000\u0000\uFDD5\u0000\uA5E8" + // 19950 - 19959
                "\uA5E9\uA5EA\uA5EB\uA5EC\uA5ED\uA5EE\uA5EF\uE7C9\u0000\uE2F3" + // 19960 - 19969
                "\uE7E1\u0000\u0000\uE3CB\u0000\uCEAE\u0000\u0000\u0000\u0000" + // 19970 - 19979
                "\uD9A2\u0000\u0000\uD2EC\u0000\u0000\u0000\u0000\u0000\u0000" + // 19980 - 19989
                "\uF2F4\u0000\u0000\uFDF0\u0000\uE0BD\uCEE3\u0000\u0000\u0000" + // 19990 - 19999
                "\uF0FE\u0000\u0000\u0000\u0000\u9BAC\uD7CF\uEBEA\uFDEB\u0000" + // 20000 - 20009
                "\uA5D7\uA5D8\u0000\u0000\u0000\u0000\u0000\u0000\uE3A5\u0000" + // 20010 - 20019
                "\u0000\uE7D5\uF5BF\uCFA2\uCDAF\uCFA3\u0000\u0000\uCDB0\uF1FE" + // 20020 - 20029
                "\uD0A3\uE1AF\uF8A3\u0000\uCAA6\uDEF1\u0000\u0000\u0000\uF0DF" + // 20030 - 20039
                "\uF8C4\u0000\u0000\uD5DC\uF3C4\uCBD7\u0000\u0000\u0000\u0000" + // 20040 - 20049
                "\uA8F7\uA8F8\u0000\u0000\u0000\u9AAB\u0000\u0000\u0000\u0000" + // 20050 - 20059
                "\u0000\uF0A1\u0000\uDEAA\u0000\uD0ED\u0000\u0000\u0000\u0000" + // 20060 - 20069
                "\u0000\uE5F7\u0000\uA5D0\uA5D1\u0000\uA5D2\uA5D3\uA5D4\uA5D5" + // 20070 - 20079
                "\uA5D6\uD1C0\u0000\u0000\uE8C5\u0000\uE4B8\u0000\uE1E8\uCDAA" + // 20080 - 20089
                "\u0000\uE3F2\u0000\uFBF7\u0000\uF7D0\u0000\uEEF0\u0000\u0000" + // 20090 - 20099
                "\u0000\uCCC2\u0000\u0000\u0000\uEAD4\u0000\u0000\u0000\u0000" + // 20100 - 20109
                "\uA0EB\u0000\u0000\u0000\uDFA7\u0000\uDFE7\uE1C1\u0000\uA5C8" + // 20110 - 20119
                "\uA5C9\uA5CA\uA5CB\uA5CC\uA5CD\uA5CE\uA5CF\uE5EB\u0000\uEFF4" + // 20120 - 20129
                "\uDDB5\u0000\u0000\u0000\u0000\uD0F0\u0000\u0000\u0000\u0000" + // 20130 - 20139
                "\uC2AB\uC2AC\u0000\uC2AD\uF5BA\u0000\u0000\u0000\u0000\u0000" + // 20140 - 20149
                "\u0000\u0000\uD9DF\uCEBA\u0000\u0000\u0000\u0000\u0000\u0000" + // 20150 - 20159
                "\u0000\uE2B4\uD7AE\u0000\u0000\uE0E1\u0000\u0000\u0000\u0000" + // 20160 - 20169
                "\uFAC6\u0000\u0000\u0000\u0000\uA0B9\u0000\u0000\u0000\uDEFB" + // 20170 - 20179
                "\uD0BB\uD5B7\uEEF1\u0000\u0000\uCADB\u0000\u0000\u0000\u0000" + // 20180 - 20189
                "\u0000\uFCD7\uEADC\uDBD2\u0000\u0000\u0000\u0000\u0000\u0000" + // 20190 - 20199
                "\uF4A8\u0000\uDCF8\u0000\uEEEF\uD5D7\uEAE4\uF8A2\uCDEB\uD7BF" + // 20200 - 20209
                "\uFBB1\u0000\uA2A8\uA2AB\uA2AA\uA2AD\uA2A6\uA2A9\u0000\u0000" + // 20210 - 20219
                "\uDDE4\uF0EF\uF6F1\uFAF0\u0000\u0000\uD1F5\uCAE8\u0000\uF8E6" + // 20220 - 20229
                "\uDCCE\u0000\u0000\u0000\u0000\uDECB\uF6B8\u0000\u0000\u0000" + // 20230 - 20239
                "\u9DE0\u0000\u0000\u0000\uE5A7\uD5D2\uD5A3\u0000\u0000\u0000" + // 20240 - 20249
                "\u0000\uF0B2\u0000\u0000\uDEE8\u0000\u0000\u0000\u0000\u0000" + // 20250 - 20259
                "\u0000\uA0DB\u0000\u0000\uD7B8\u0000\u0000\u0000\u0000\u0000" + // 20260 - 20269
                "\u0000\u9AD4\u9CE0\u0000\uE0BB\uCEC3\u0000\uD0BA\uF7BA\uD8F3" + // 20270 - 20279
                "\uF7CD\u0000\uA2B0\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 20280 - 20289
                "\u0000\uA2A7\uDEA5\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 20290 - 20299
                "\uE6DA\uCAB7\u0000\u0000\uD3E7\u0000\uF8E5\u0000\u0000\uCEB7" + // 20300 - 20309
                "\u0000\u0000\u0000\u0000\u0000\u0000\uC2C6\u0000\u0000\uE0C4" + // 20310 - 20319
                "\u0000\uCFB9\u0000\uD5CA\uD7E2\uE2AF\uE1F1\u0000\uD2A4\u0000" + // 20320 - 20329
                "\u0000\u0000\u0000\uF5FB\uF8FA\u0000\u0000\uDFB9\u0000\u0000" + // 20330 - 20339
                "\u0000\u0000\uF9E1\u0000\u0000\u0000\u0000\uC1ED\u0000\u0000" + // 20340 - 20349
                "\u0000\uD8F1\u0000\uD4CF\u0000\u0000\u0000\uE6B9\u0000\u0000" + // 20350 - 20359
                "\u0000\u0000\uC7B4\u0000\u0000\u0000\uD7AA\u0000\u0000\u0000" + // 20360 - 20369
                "\u0000\uC7C1\uA0EE\u0000\u0000\uE1AB\u0000\u0000\u0000\u0000" + // 20370 - 20379
                "\u0000\u0000\uBCD1\u0000\u0000\uE0FB\u0000\u0000\u0000\uEFEA" + // 20380 - 20389
                "\uFADE\u0000\uE8B4\uEBC3\u0000\uEAAA\uFAFC\uF5F6\uF0BC\uFDD4" + // 20390 - 20399
                "\uFAEC\u0000\u0000\u0000\u0000\u0000\uF1EB\u0000\uEBF0\uF1D6" + // 20400 - 20409
                "\u0000\u0000\uE5E2\u0000\uCCCC\u0000\uA9A8\uA8A9\uA9A9\u0000" + // 20410 - 20419
                "\u0000\u0000\u0000\u0000\uDDBD\u0000\u0000\u0000\uF9C1\u0000" + // 20420 - 20429
                "\u0000\u0000\u0000\uC5F0\u0000\u0000\u0000\uFBF2\u0000\uDBF6" + // 20430 - 20439
                "\u0000\uDEDF\uDAF6\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 20440 - 20449
                "\uF5B8\u9CAF\u0000\u0000\u0000\uF6DE\u0000\u0000\u9BB6\uE8C4" + // 20450 - 20459
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u9BC2\uE3A4\u0000" + // 20460 - 20469
                "\u0000\u0000\u0000\u0000\u0000\u0000\uCFEF\u9BD7\u0000\u0000" + // 20470 - 20479
                "\u0000\u0000\u0000\uF9C4\u0000\uDFA1\uDDE1\u0000\u0000\u0000" + // 20480 - 20489
                "\u0000\u0000\u0000\uFCA1\uEFEE\uDCD8\uF2BB\u0000\uDEA4\u0000" + // 20490 - 20499
                "\uDACC\u0000\u0000\u0000\uF3FC\u0000\u0000\uEEA2\u0000\u0000" + // 20500 - 20509
                "\uE1C5\u0000\u0000\u0000\u0000\u0000\u0000\uB9A3\u0000\uB9A4" + // 20510 - 20519
                "\uE8A5\u9BDD\u0000\u0000\u0000\u0000\u0000\u0000\uF4A2\u0000" + // 20520 - 20529
                "\uF1D7\u0000\uCED3\u0000\u0000\u0000\u0000\uDCF7\u0000\u0000" + // 20530 - 20539
                "\uEED5\u0000\u0000\u0000\u0000\uF9F4\u0000\uA9A7\u0000\u0000" + // 20540 - 20549
                "\u0000\u0000\u0000\u0000\uA8A8\uF5B9\u0000\uDCF0\uE3F1\u0000" + // 20550 - 20559
                "\u0000\u0000\u0000\uCFD6\u0000\uD7F0\u0000\uEBE1\uF9CB\u0000" + // 20560 - 20569
                "\u0000\u0000\uCBF3\uF4A5\u0000\u0000\uF3D7\u0000\u0000\u0000" + // 20570 - 20579
                "\uDCBD\u0000\uCCE5\uFDB9\u0000\u0000\u0000\u0000\u0000\u0000" + // 20580 - 20589
                "\u0000\uD0B4\uFDBC\uDFB1\uE3EF\u0000\u0000\u0000\u0000\uE0A3" + // 20590 - 20599
                "\u9CDF\u0000\u0000\u0000\uDADD\u0000\u0000\uDAB9\uCFF2\uF7B9" + // 20600 - 20609
                "\uD9F3\u0000\u0000\uE1CB\u0000\u0000\uCFE2\uCDF6\u0000\u0000" + // 20610 - 20619
                "\uEFF0\u0000\uF4BE\u9CE1\uFBB6\u0000\u0000\u0000\u0000\u0000" + // 20620 - 20629
                "\u0000\uA1AD\u0000\u0000\u0000\uE9D0\u0000\u0000\u0000\u0000" + // 20630 - 20639
                "\u0000\u9BE3\u0000\u0000\u0000\uD5B4\u0000\u0000\u0000\u0000" + // 20640 - 20649
                "\uC6D9\uC6DA\u0000\u0000\uE8B1\u0000\uFCAE\u0000\u0000\u0000" + // 20650 - 20659
                "\u0000\uA0FD\u0000\u0000\u0000\uA0B7\uC1E1\u0000\u0000\u0000" + // 20660 - 20669
                "\uA0CC\uC3C6\uA0CD\u0000\u0000\uFADD\u0000\u0000\u0000\u0000" + // 20670 - 20679
                "\u0000\u0000\uFCBF\u0000\u0000\uE2AB\uF3E8\u0000\u0000\u0000" + // 20680 - 20689
                "\u0000\u0000\uB4BC\u0000\u0000\u0000\u9BDE\u0000\uD4E9\u0000" + // 20690 - 20699
                "\u0000\uE3FE\uD1AA\uE8AA\u0000\uEAB6\uF9FA\uE6CC\uDFB8\u0000" + // 20700 - 20709
                "\uEAA5\u0000\u0000\u0000\uD7AD\u9DBB\uE1E0\u0000\uD9AC\u0000" + // 20710 - 20719
                "\uF5EB\u0000\uE0B6\u0000\uF7DE\u0000\u0000\u0000\u0000\u0000" + // 20720 - 20729
                "\u0000\u0000\uA9FA\uF1FA\u9AB2\u0000\uE5B6\uF3EF\u0000\u0000" + // 20730 - 20739
                "\uFBDA\uE2BD\u0000\u0000\u0000\uE3C8\u0000\u0000\u0000\uD6F6" + // 20740 - 20749
                "\u0000\u0000\u0000\uEACA\u0000\u9CAA\u0000\u0000\u0000\uF6B0" + // 20750 - 20759
                "\uEFCF\uE9CF\u0000\uA9AA\u0000\u0000\u0000\u0000\u0000\uA9AD" + // 20760 - 20769
                "\u0000\uC8E4\u0000\u0000\u0000\u0000\u0000\u0000\uF1D1\u0000" + // 20770 - 20779
                "\u0000\u0000\uF0BE\uD2BD\uCCA4\u0000\u0000\u0000\u0000\uC1AA" + // 20780 - 20789
                "\uC1AB\u0000\uC1AC\uEBAD\u0000\u0000\u0000\u9CBE\uD5AA\u0000" + // 20790 - 20799
                "\u0000\uCEA1\uF5A9\u0000\u0000\uDDF9\u0000\u0000\uE2AD\u0000" + // 20800 - 20809
                "\u0000\u0000\u0000\u0000\u0000\uF5E3\u0000\u0000\uF2D1\u9CB4" + // 20810 - 20819
                "\u0000\u0000\u0000\uE9C1\u0000\uCCA7\uEAC9\u0000\u0000\u0000" + // 20820 - 20829
                "\u0000\u0000\uF8B6\uCDCA\uD7D4\uDEA3\u0000\uE4E0\u0000\u0000" + // 20830 - 20839
                "\u0000\uE7EC\uEEEE\u9AC6\uF3F0\u0000\uDFBF\uE3EE\u0000\u0000" + // 20840 - 20849
                "\u0000\u0000\u0000\uE8D4\u0000\uCBDA\u0000\uE7D2\uD7C3\uF6F0" + // 20850 - 20859
                "\uE8DE\u0000\u0000\uF2EC\u0000\u0000\uFAEE\u0000\u0000\u0000" + // 20860 - 20869
                "\uE4FD\u0000\u0000\uE3EC\u0000\uA9A3\u0000\u0000\u0000\u0000" + // 20870 - 20879
                "\u0000\u0000\uA1C0\uE2F0\u0000\u0000\u0000\u0000\u0000\u0000" + // 20880 - 20889
                "\uFABB\uE9C7\uE6AA\u0000\u0000\u0000\u0000\u0000\u0000\uA9CD" + // 20890 - 20899
                "\uA9CE\uA9CF\uA9D0\uEDBC\u0000\u0000\uD8D4\u0000\u0000\u0000" + // 20900 - 20909
                "\uDCDA\uE9FD\uD0CA\u0000\uF5D6\uD9C5\uE4B4\u0000\uEDA7\uF5AC" + // 20910 - 20919
                "\u0000\u0000\u0000\u0000\u0000\uE4F5\u0000\uDCE4\u0000\uE5EF" + // 20920 - 20929
                "\u0000\u0000\u0000\u0000\u0000\uDEF8\uF8E9\uE3DE\u0000\uA8AA" + // 20930 - 20939
                "\u0000\u0000\u0000\u0000\u0000\uA8AD\uA9AC\u9CAD\uF3ED\u0000" + // 20940 - 20949
                "\u0000\u0000\u0000\u0000\u0000\uA9F9\u0000\u0000\u0000\uDCB1" + // 20950 - 20959
                "\u0000\u0000\u0000\uD5D6\u0000\uFAEF\uE3E1\u0000\u0000\u0000" + // 20960 - 20969
                "\u0000\u0000\u0000\uF5A6\u0000\u0000\uE8C6\u0000\u0000\u0000" + // 20970 - 20979
                "\u0000\u0000\u0000\uD5B5\u0000\u0000\uCAAA\uE1F9\u0000\uEAB1" + // 20980 - 20989
                "\u0000\u0000\u0000\uEAD6\uF1B0\u0000\u0000\u0000\uE2EE\u0000" + // 20990 - 20999
                "\u0000\u0000\u0000\uE5E7\u0000\u0000\u0000\uCAA3\uDDB2\u0000" + // 21000 - 21009
                "\u0000\u0000\u0000\uE6A9\u0000\uEFF3\uFDE9\u0000\uCFC1\u0000" + // 21010 - 21019
                "\uE0DF\uDEEC\u0000\u0000\uEDB8\u0000\u0000\u0000\uDBB6\u0000" + // 21020 - 21029
                "\u0000\uE6F0\u9AB6\u0000\u0000\u0000\u0000\u0000\uB4FD\uB4FE" + // 21030 - 21039
                "\u0000\uB5A1\uD7FC\u0000\uEDBB\u0000\u0000\uF6AB\u0000\u0000" + // 21040 - 21049
                "\uE0B5\u0000\u0000\u0000\u0000\u0000\u0000\uDEFA\u0000\uD7F8" + // 21050 - 21059
                "\uD5C4\u9CD4\u0000\u0000\u0000\u0000\u0000\uEDF4\uD4EB\u0000" + // 21060 - 21069
                "\uDEA2\u0000\u0000\u0000\uE5E6\u0000\uF3A7\u0000\u0000\uCDEA" + // 21070 - 21079
                "\u0000\uEBEE\u0000\u0000\uD8B4\u0000\u0000\u0000\u0000\u0000" + // 21080 - 21089
                "\u0000\uE9E4\u0000\u0000\uD7A5\u0000\u0000\u0000\u0000\uF7E8" + // 21090 - 21099
                "\u0000\uA8A2\u0000\u0000\u0000\u0000\u0000\u0000\uA1BF\uF8B3" + // 21100 - 21109
                "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uEDB6\uCEEF\u0000" + // 21110 - 21119
                "\u0000\uF2F3\u0000\u0000\u0000\u0000\uF4EF\u0000\u0000\u0000" + // 21120 - 21129
                "\uF6CE\uCCAE\u0000\uDADB\u0000\u0000\u0000\u0000\uCDC7\uDBB9" + // 21130 - 21139
                "\u0000\u9AF4\u0000\u0000\u0000\u0000\u0000\uB6F7\uB6F8\u0000" + // 21140 - 21149
                "\uB6F9\uEDF3\uDCD9\uE0CD\u0000\u0000\u0000\u0000\uF7DA\uE9A6" + // 21150 - 21159
                "\uCBF2\u0000\u0000\u0000\u0000\u0000\u0000\uC7A8\u0000\uC7A9" + // 21160 - 21169
                "\uDDAF\uDDB0\u0000\u9BEA\uCBB7\uE8D3\u0000\u0000\uDDF8\u0000" + // 21170 - 21179
                "\u9AE4\u0000\u0000\u0000\uE8CF\uE8D2\u0000\uCAC5\uCCEB\u0000" + // 21180 - 21189
                "\u0000\u0000\u0000\uE5A6\u0000\u0000\u0000\u0000\uC0EB\uC0EC" + // 21190 - 21199
                "\u0000\uC0ED\uD8E6\u9BBD\uF4B1\u0000\u0000\u0000\u0000\u0000" + // 21200 - 21209
                "\uB6F3\uB6F4\u0000\u0000\uD1B3\u0000\u0000\u0000\u0000\u0000" + // 21210 - 21219
                "\uEFED\uFDD8\u0000\u0000\u0000\u0000\uD2F6\u0000\u0000\uCFBB" + // 21220 - 21229
                "\u0000\u0000\u0000\uD3AD\uE8E1\uCEEC\u9DBC\u0000\u9AE8\uF9FD" + // 21230 - 21239
                "\u0000\uCADC\u0000\u0000\uE2B2\u0000\uD4BD\u0000\u9BE8\uD9CE" + // 21240 - 21249
                "\u0000\uF6B6\u0000\uCEC2\uD6C7\u0000\uE3B4\u0000\uF1AD\uF5C6" + // 21250 - 21259
                "\u0000\uE1A2\uE9C6\u0000\u0000\u0000\uF2C5\uDEBD\u0000\uF6A9" + // 21260 - 21269
                "\u0000\u0000\u0000\uDAA4\u0000\uDBD8\u0000\u0000\uCAA2\u0000" + // 21270 - 21279
                "\u0000\uD1CD\u0000\uA2AC\uA9F6\uA8AC\u0000\uA8F9\uA8F6\uA8FA" + // 21280 - 21289
                "\uA2AF\uE9FC\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uD9EE" + // 21290 - 21299
                "\uD2B1\u0000\u0000\u0000\u9CF7\uCCE9\u0000\uD9C4\uE9A5\uD6D5" + // 21300 - 21309
                "\u0000\uCDC5\u9BBF\uEDBA\uD1BD\u0000\uF1A5\uE9CE\u0000\u0000" + // 21310 - 21319
                "\u0000\uF9BC\u0000\u0000\uDECF\u0000\u0000\u0000\u0000\u0000" + // 21320 - 21329
                "\u0000\uF8CC\u0000\uEAD9\uF9D7\u0000\u0000\u9CDB\u0000\u0000" + // 21330 - 21339
                "\u0000\u0000\uEEEC\u0000\u0000\uD3A3\uEEB7\uF6A8\uDDFD\u0000" + // 21340 - 21349
                "\u0000\u0000\u0000\u9DAA\u0000\uF8CF\u0000\u0000\u0000\u0000" + // 21350 - 21359
                "\uEAC8\uEEB8\uF1AC\uD7E8\uCBD8\u0000\u0000\u0000\uE9E2\u0000" + // 21360 - 21369
                "\u0000\uD4FD\u0000\u0000\uE0C8\u0000\u0000\u0000\u9FE0\uBDBF" + // 21370 - 21379
                "\uBDC0\u0000\uBDC1\uE0CC\uEBF9\u0000\u0000\u0000\u0000\u0000" + // 21380 - 21389
                "\u9AAE\u9CCF\u0000\uD6BE\u0000\u0000\u0000\uE2BA\u0000\uE3DF" + // 21390 - 21399
                "\u0000\uDEC3\u0000\uDEC4\uCAA1\u0000\u0000\uECF5\uE8EE\u0000" + // 21400 - 21409
                "\uCBA9\uF1AF\u0000\u0000\uEACE\u0000\uE8DF\u0000\u0000\u0000" + // 21410 - 21419
                "\u0000\uC2D5\u0000\u0000\u0000\uE7C5\u9DA2\u0000\uE0E9\u0000" + // 21420 - 21429
                "\uA1C6\uA1BE\uA9F7\uA9F8\uA2A5\u0000\uA2D2\u0000\uC8D5\u0000" + // 21430 - 21439
                "\u0000\u0000\u0000\u0000\u0000\uFCF5\u0000\u0000\u0000\uE0E6" + // 21440 - 21449
                "\u0000\u0000\u0000\u0000\u0000\u0000\uF4D8\uD6B3\uDDAD\uD1BC" + // 21450 - 21459
                "\u0000\uE5CF\u0000\uCBB6\u0000\uDAB8\u0000\uDBE9\uFDCC\u0000" + // 21460 - 21469
                "\u0000\u0000\u0000\u0000\u0000\uD0A9\u0000\u0000\uEDAB\u0000" + // 21470 - 21479
                "\uE3B7\u0000\u0000\u0000\u0000\uC2CD\uC2CE\u0000\uC2CF\uDBEB" + // 21480 - 21489
                "\u0000\uDFFE\u0000\u0000\uD8E1\u0000\uF7F3\u9BDB\u0000\u0000" + // 21490 - 21499
                "\u0000\u0000\u0000\u0000\u0000\uEBC9\uCEB8\u0000\u0000\u0000" + // 21500 - 21509
                "\uD8D2\uF9D6\u0000\u0000\uE1C4\u0000\u0000\u0000\u0000\u0000" + // 21510 - 21519
                "\uE8B0\uF9FC\u0000\uCCC0\u0000\u0000\u0000\u0000\u0000\uB6D8" + // 21520 - 21529
                "\u0000\u0000\u0000\uA2C6\u0000\u0000\u0000\u0000\u0000\uF0B9" + // 21530 - 21539
                "\uE4FE\uE4C9\u0000\uE4E6\u0000\uF1EA\u0000\u0000\u0000\uCBEC" + // 21540 - 21549
                "\uCBC0\uF3C5\u0000\u0000\uD4C0\uD5BF\u0000\u0000\u0000\uA1D2" + // 21550 - 21559
                "\u0000\u0000\u0000\u0000\u0000\u9DF0\u9CC6\u0000\u0000\uF8DE" + // 21560 - 21569
                "\uF9AA\uCAF7\u0000\uEDB7\u0000\u0000\uEFE8\u0000\u0000\uE1BF" + // 21570 - 21579
                "\u0000\u0000\u0000\u9CED\uD0A1\u0000\u0000\u0000\uCEF7\u0000" + // 21580 - 21589
                "\u0000\uE0D8\u0000\uDCF5\uE0B9\u0000\u0000\u0000\uD4CE\u9CF4" + // 21590 - 21599
                "\uF4B5\uF0DB\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uE7BD" + // 21600 - 21609
                "\uF8BA\uE8D0\u0000\u0000\uD8FB\u0000\u0000\uEAD5\uF4F3\uDAC9" + // 21610 - 21619
                "\u0000\uE6DE\u0000\u0000\u9CBB\u0000\uE4A7\uECD2\u0000\u0000" + // 21620 - 21629
                "\uF6B1\u0000\u9BDA\uCEFB\uF9E5\u0000\uE0CA\u0000\u0000\uF2FD" + // 21630 - 21639
                "\uD3B0\u0000\uFAFB\u0000\u0000\uFABD\uCCC8\uEFCD\uD5D5\u0000" + // 21640 - 21649
                "\uA1A7\u0000\uA8A3\u0000\u0081\u0000\u0000\u0000\uD1A8\u0000" + // 21650 - 21659
                "\u0000\u0000\u0000\uC5E1\u0000\u0000\u0000\uD8C8\u0000\u0000" + // 21660 - 21669
                "\uEEC1\u0000\uC8CB\u0000\u0000\u0000\u0000\u0000\u0000\uFBE0" + // 21670 - 21679
                "\uF2E5\u0000\u0000\uC6FE\u0000\u0000\u0000\u0000\u0000\u0000" + // 21680 - 21689
                "\uEFFB\u0000\u0000\uFAF9\uD7C6\u0000\uD1BB\uF7AA\u0000\uEDCA" + // 21690 - 21699
                "\uD7D3\uD8FA\uD6E0\u0000\uF1C6\u0000\u0000\u0000\u0000\u0000" + // 21700 - 21709
                "\uB6CD\u0000\u0000\u0000\uA1D6\u0000\u0000\u0000\u0000\u0000" + // 21710 - 21719
                "\uFCA8\u0000\u0000\uECE6\uEBD6\u0000\uECDF\u0000\u0000\u0000" + // 21720 - 21729
                "\uDFFC\u0000\uD0E6\u0000\u0000\uDEC1\u0000\u0000\uE4AC\u0000" + // 21730 - 21739
                "\u0078\u0079\u007A\u007B\u007C\u007D\u007E\u007F\uCCBF\u0000" + // 21740 - 21749
                "\u0000\u0000\u0000\u0000\u0000\u0000\uFDC8\uE1AC\u0000\u0000" + // 21750 - 21759
                "\uE3EB\u0000\uEEC7\u0000\u0000\uE2DB\u0000\u0000\u0000\uDFDE" + // 21760 - 21769
                "\u0000\uE0C7\uE1C8\uDBB7\uDFE3\u0000\u0000\u0000\u0000\u0000" + // 21770 - 21779
                "\u9EF6\u0000\u0000\u0000\uA2A1\u0000\uA2A2\u0000\u0000\u0000" + // 21780 - 21789
                "\uD7FA\u0000\u0000\u0000\uFBC8\uCEDC\uF2B5\uD0E4\uDDD1\u0000" + // 21790 - 21799
                "\u0000\u0000\u0000\uA8FB\uA8FC\uA8FD\uA8FE\u0000\uEAA7\uE9F6" + // 21800 - 21809
                "\uFBBB\u0000\uE7E9\uEFCC\u0000\u0000\uD9D8\u0000\u0000\u0000" + // 21810 - 21819
                "\u0000\u0000\u0000\uD8D5\u0000\u0000\uD8D9\u0000\uF4A3\u0000" + // 21820 - 21829
                "\u0000\uF4DD\u0000\u0070\u0071\u0072\u0073\u0074\u0075\u0076" + // 21830 - 21839
                "\u0077\uD2EF\u0000\u0000\u0000\uE2ED\u0000\u0000\uDEE9\uFCBC" + // 21840 - 21849
                "\u0000\uDAA2\uDAA3\u0000\uD2A1\u0000\u0000\uF2D4\u0000\uD1B0" + // 21850 - 21859
                "\u0000\uCCE0\u0000\uDBFD\uD1BA\u0000\uF1C4\u0000\uE5B3\uFBF5" + // 21860 - 21869
                "\uE9E1\uFDE0\uCBB3\u0000\u0000\u0000\u0000\u0000\u0000\uD5DD" + // 21870 - 21879
                "\uEFC4\u0000\u0000\u0000\u0000\u0000\u0000\uE1D8\uD6EB\u0000" + // 21880 - 21889
                "\u0000\u0000\uF4D9\u9CCE\u0000\u0000\uD2C5\uFBD1\uE7C0\uEBA5" + // 21890 - 21899
                "\u0000\uDFFA\uE3A2\u9DC6\u0000\u0000\u0000\u0000\u0000\u0000" + // 21900 - 21909
                "\uF0EA\uE1C6\u0000\u0000\u0000\uD4BF\u0000\u9BE9\u0000\uE5F8" + // 21910 - 21919
                "\u0000\u0000\uDEC0\uECA3\u0000\uE9CD\u0000\u0068\u0069\u006A" + // 21920 - 21929
                "\u006B\u006C\u006D\u006E\u006F\uEFBD\uFCD6\u0000\u0000\uDBF4" + // 21930 - 21939
                "\u0000\uEFAA\uF8B9\uEEC6\u0000\u0000\u0000\u0000\u0000\u0000" + // 21940 - 21949
                "\u0000\uF4F2\uD0B5\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 21950 - 21959
                "\uE9C0\uCECC\uF5E8\uF7D5\u0000\uD3CD\u0000\uF3FE\u0000\uE3AB" + // 21960 - 21969
                "\uEBE0\u0000\u0000\u0000\uCEFA\uCBF7\uE5A5\uD8A2\u0000\u0000" + // 21970 - 21979
                "\u0000\u0000\u9BF6\uDDAC\u0000\uFCAF\uD3A1\u0000\uF1AB\u0000" + // 21980 - 21989
                "\u0000\u0000\u0000\uC0B8\uC0B9\u0000\u0000\uE3F7\u0000\u0000" + // 21990 - 21999
                "\u0000\u0000\u0000\uECA8\u9AD2\u0000\u9DB5\u0000\u0000\u0000" + // 22000 - 22009
                "\u0000\uFBEE\uEDF1\u0000\u0000\uF1E2\u0000\uD4DB\u0000\u0000" + // 22010 - 22019
                "\uFBA8\uD0A8\u0000\u0000\uDAEC\u0000\u0000\uE7B8\u0000\u0000" + // 22020 - 22029
                "\u0000\u0000\u0000\u0000\u9AC1\u9BFB\u0000\u9BD8\u0000\uCDFA" + // 22030 - 22039
                "\u0000\u0000\u0000\u0000\u0000\uF8FD\u0000\u0000\uF8FC\u9DB4" + // 22040 - 22049
                "\u0000\uEFBC\uD8A1\u0000\u0000\u0000\u0000\uC8DE\uC8DF\u0000" + // 22050 - 22059
                "\u0000\uCDF5\u0000\u0000\u0000\uFDB0\uD5A8\u0000\uCEF8\uDCB0" + // 22060 - 22069
                "\u0000\u0000\u0000\u0000\uE3AA\u0000\u0060\u0061\u0062\u0063" + // 22070 - 22079
                "\u0064\u0065\u0066\u0067\uCFD7\u0000\u0000\u0000\u0000\u0000" + // 22080 - 22089
                "\u0000\uCFDF\uE9A1\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + // 22090 - 22099
                "\uDFB6\uE5CD\u0000\u0000\u0000\uFAEB\u0000\uCFBC\u0000\uEDDB" + // 22100 - 22109
                "\uDFB2\uDFBE\uF9BB\u0000\uDCF4\u0000\u0000\uF4B8\uF7BC\uDCFD" + // 22110 - 22119
                "\u0000\uE8EC\uE4E7\u0000\u0058\u0059\u005A\u005B\u0082\u005D" + // 22120 - 22129
                "\u005E\u005F\uCDDA\u0000\u0000\u0000\u0000\u0000\uD9CF\u0000" + // 22130 - 22139
                "\uECE9\uEFCB\u0000\uF6D2\u0000\u0000\u0000\uD8B2\uF0D6\u0000" + // 22140 - 22149
                "\u0000\u0000\u0000\u0000\u0000\u0000\uE4F3\uCAD9\u0000\u0000" + // 22150 - 22159
                "\uEFEF\u0000\uF5AA\u0000\u0000\uE8CC\u0000\u0000\u0000\uDEB7" + // 22160 - 22169
                "\u0000\u0000\uCBC9\u0000\u9BAF\uE6D1\uF0CC\u0000\u0000\uDAC5" + // 22170 - 22179
                "\u0000\uD8EC\u0000\u0000\u0000\u0000\uC5DB\uC5DC\u0000\uC5DD" + // 22180 - 22189
                "\uFDFC\u0000\u0000\u0000\u0000\uE1AA\u0000\u0000\uE8AC\u0000" + // 22190 - 22199
                "\uE8DD\u0000\u0000\uEFE9\u0000\uA2E4\u0000\u0000\uA7E4\uA7EE" + // 22200 - 22209
                "\uA7E9\u0000\u0000\uF9C9\u0000\uE4E2\u0000\uFBBD\u0000\u0000" + // 22210 - 22219
                "\uECEC\uFBBE\uDFEB\u0000\uE1F8\u0000\u0000\uE2D4\uD2FD\u0000" + // 22220 - 22229
                "\uE5A8\u0000\u0000\u0000\u9DCF\u0000\u0000\u0000\u0000\uA1A4" + // 22230 - 22239
                "\u0000\u0000\u0000\u0000\uC0AB\uC0AC\u0000\uC0AD\uDDFA\u0000" + // 22240 - 22249
                "\u0000\u0000\u0000\u0000\u0000\uF0D5\uE2B3\uDEE7\u0000\u0000" + // 22250 - 22259
                "\u0000\u0000\u0000\u0000\uB7D8\u0000\u0000\uEEC3\u0000\u0000" + // 22260 - 22269
                "\u0000\u0000\u0000\u0000\uCEF6\u0000\uFAD0\uF8F9\u0000\u0000" + // 22270 - 22279
                "\u0000\u0000\uF0AE\u0000\u0000\u9CA8\u0000\uFDB8\uE3E8\u0000" + // 22280 - 22289
                "\uD4A7\uE8FC\uDEE6\u0000\u0000\u0000\u0000\uDFD4\u0000\u0000" + // 22290 - 22299
                "\uE7A7\u0000\uE6D7\u0000\u0000\u0000\u0000\uC6CA\uC6CB\u0000" + // 22300 - 22309
                "\uC6CC\uE9DE\u0000\u0000\u0000\u0000\u0000\uF0D3\uF2B4\uD1B7" + // 22310 - 22319
                "\uF2B3\u0000\u0000\u0000\u0000\u0000\u0000\uB0EB\u0000\uB0EC" + // 22320 - 22329
                "\uDEE5\uD1B5\u0000\u0000\u0000\u0000\u0000\uD1B6\uD8A8\u0000" + // 22330 - 22339
                "\u0000\u0000\uCCE4\u0000\u0000\uD1B4\uDAF1\u0000\u0000\u0000" + // 22340 - 22349
                "\u0000\u0000\u0000\u0000\uE6A2\uCAF9\u0000\u0000\uD4DA\u0000" + // 22350 - 22359
                "\u0000\u0000\u0000\uC7F0\uC7F1\u0000\uC7F2\u9CDA\u0000\u0000" + // 22360 - 22369
                "\uF4E2\u0000\u0000\u0000\u0000\uA0F7\u0000\u0000\u0000\u9FF1" + // 22370 - 22379
                "\uBEAD\u0000\u0000\u0000\u9FF2\u9FF3\u0000\u0000\u0000\uBECE" + // 22380 - 22389
                "\uBECF\uBED0\u0000\uBED1\uF3B7\u0000\u0000\u0000\u0000\u0000" + // 22390 - 22399
                "\u0000\u0000\uDBFC\uD9C2\u0000\uF0D2\u0000\uE4D1\u0000\u0000" + // 22400 - 22409
                "\u0000\u9FE7\u0000\uBDE0\u0000\u0000\uE9FB\uEAA8\u0000\u0000" + // 22410 - 22419
                "\u0000\u0000\uFDB7\uD8F9\u0000\u0000\u0000\u0000\u9CF5\u0000" + // 22420 - 22429
                "\u0000\uE6D5\u0000\u0000\uE9F2\u0000\uDFB0\u0000\uA7EA\u0000" + // 22430 - 22439
                "\u0000\uA7EB\u0000\u0000\uA7DF\u0000\u0050\u0051\u0052\u0053" + // 22440 - 22449
                "\u0054\u0055\u0056\u0057\uF7AF\uDAB6\u0000\uCAD7\u0000\u0000" + // 22450 - 22459
                "\u0000\u0000\uC7CB\uC7CC\u0000\uC7CD\uDFD3\u0000\u0000\u0000" + // 22460 - 22469
                "\uDAF0\u0000\uE2EA\u0000\uA7BC\uA7ED\uA7B5\u0000\u0000\u0000" + // 22470 - 22479
                "\u0000\uA7B9\uE7C3\u0000\uECCC\u0000\u0000\u0000\u0000\u0000" + // 22480 - 22489
                "\uB5E5\uB5E6\u0000\u0000\uD9ED\u0000\u0000\u0000\u0000\uF5A5" + // 22490 - 22499
                "\u0000\uA7DA\uA7DB\uA2E3\uA7EC\uA7A6\uA7E0\uA7EF\uA2E1\uCDC1" + // 22500 - 22509
                "\u0000\u0000\uFBD3\u0000\u0000\u0000\u0000\uC7C7\uC7C8\u0000" + // 22510 - 22519
                "\u0000\uDBCC\uDDCD\u0000\u0000\u0000\uD4C8\u0000\uA7C7\uA7C8" + // 22520 - 22529
                "\uA7CE\uA7CF\uA7D0\uA7D1\uA7D2\uA7D3\uCDA4\u0000\u0000\uD4F4" + // 22530 - 22539
                "\uDBA1\uDBDC\uDBDD\u0000\uA7BF\uA7C0\uA7C1\uA7C2\uA7C3\uA7C4" + // 22540 - 22549
                "\uA7C5\uA7C6\uE8B9\u0000\uEFA6\u0000\u0000\u0000\u0000\u0000" + // 22550 - 22559
                "\u9EED\uB5DD\u0000\uB5DE\u9AF3\u0000\u0000\u0000\u0000\u0000" + // 22560 - 22569
                "\u0000\u0000\uD9A7\uF4B0\uF3EA\uDAEE\u0000\uD7BB\u0000\uE2B1" + // 22570 - 22579
                "\u9DF4\uE5DC\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uCDD9" + // 22580 - 22589
                "\uD3C3\u0000\uD8A6\u9BB3\uF6C1\u0000\u0000\u0000\uB6D5\uB6D6" + // 22590 - 22599
                "\u0000\u0000\u0000\uB8DD\uB8DE\uB8DF\u0000\u0000\uF8B2\u0000" + // 22600 - 22609
                "\u0000\u0000\uDCEB\u0000\u0000\uFBC7\uD5C8\u0000\uD7DF\u0000" + // 22610 - 22619
                "\uDDA9\u0000\uA7BE\uA7E5\uA7E6\uA7E7\uA7E8\uA7E1\uA7E2\uA7E3" + // 22620 - 22629
                "\uD4E3\uCCE2\u0000\uF7D4\u0000\u0000\u0000\u0000\uC7B6\u0000" + // 22630 - 22639
                "\u0000\u0000\uB6BB\uB6BC\uB6BD\u0000\u0000\uCCDE\u0000\u0000" + // 22640 - 22649
                "\u0000\u0000\u0000\u0000\uDCE0\u0000\u0000\uEFBA\uF1DD\u0000" + // 22650 - 22659
                "\uDEB3\u0000\u0000\u0000\u9AE1\u0000\u0000\uF4C7\u0000\uA7B2" + // 22660 - 22669
                "\uA7B3\uA7B4\uA7A7\uA7A8\uA7A9\uA7AA\uA7BD\uD3B8\uF2D6\u0000" + // 22670 - 22679
                "\u0000\uD4D9\uEEC5\uF2F0\u0000\uA7A5\uA7AB\uA7AC\uA7AD\uA7AE" + // 22680 - 22689
                "\uA7AF\uA7B0\uA7B1\uD1B1\u0000\uCBB1\u0000\u0000\u0000\u0000" + // 22690 - 22699
                "\uD1B2\uECB6\u0000\u0000\u0000\u0000\uFBFE\uD3D7\u0000\uA7D4" + // 22700 - 22709
                "\uA7D5\uA7D6\uA7D7\uA7D8\uA7A1\uA7A2\uA7A3\uEFA4\u0000\uEFEB" + // 22710 - 22719
                "\u0000\u0000\u0000\u0000\u0000\uB5D6\u0000\u0000\u0000\u9EDD" + // 22720 - 22729
                "\uB4B3\u0000\u0000\u0000\uB4E2\uB4E3\uB4E4\u0000\uB4E5\uEFA3" + // 22730 - 22739
                "\uEBA6\uCBA3\uE3E9\u0000\u0000\u0000\uD1FB\uE9C4\u0000\u0000" + // 22740 - 22749
                "\uDCCB\uE9C5\u0000\u0000\u0000\uB3D6\uB3D7\uB3D8\u0000\u0000" + // 22750 - 22759
                "\uE5C8\u0000\u0000\u0000\uFBA4\uD4B9\u0000\uA7BA\uA7BB\uA7DC" + // 22760 - 22769
                "\uA7DD\uA7DE\uA7B6\uA7B7\uA7B8\uCAF6\u0000\uE4A4\uF4D6\u0000" + // 22770 - 22779
                "\u0000\u0000\uDFE6\uFBD2\u0000\uF8F8\uF7FB\u0000\u0000\uE8BF" + // 22780 - 22789
                "\u0000\uA7C9\uA7CA\uA7CB\uA7CC\uA7CD\u0000\u0000\u0000\uFAAE" + // 22790 - 22799
                "\u0000\u0000\u0000\uD6E9\uCEB6\u0000\uF3C0\u0000\uCDFE\u0000" + // 22800 - 22809
                "\u0000\u0000\u9EB7\uB1C9\uB1CA\u0000\u0000\uFBCD\u0000\uD5BD" + // 22810 - 22819
                "\uF1DF\u0000\u0000\uF6FB\uFCBB\u0000\uE2B0\u0000\u0000\uE6A5" + // 22820 - 22829
                "\u0000\u0000\uD3C2\u0000\u0000\u0000\u0000\uD3B6\u0000\uA8C9" + // 22830 - 22839
                "\uA8CA\uA8CB\uA8CC\u0000\u0000\u0000\uA2DE\uF3BF\u0000\uF0D1" + // 22840 - 22849
                "\u0000\u0000\u0000\u0000\u0000\uB5CD\u0000\u0000\u0000\uB1BF" + // 22850 - 22859
                "\uB1C0\uB1C1\u0000\uB1C2\uD7F3\u0000\u0000\u0000\uFCD4\u0000" + // 22860 - 22869
                "\uDAD7\uCCDF\uF2D3\uFBA9\uD8A5\u0000\u0000\u0000\u0000\uD5CB"
                ;

        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (true && src.hasArray() && dst.hasArray())
                return encodeArrayLoop(src, dst);
            else
                return encodeBufferLoop(src, dst);
        }
    }
}
